~VERSION INFORMATION
VERS.           2.0   :CWLS Log ASCII Standard - VERSION 2.0
WRAP.           NO    :One Line per depth step
PROD.  Schlumberger   :LAS Producer
PROG.  DLIS to ASCII 17C0-154                          :LAS Program name and version
CREA.        2010/04/23 18:36                          :LAS Creation date {YYYY/MM/DD hh:mm}
DLIS_CREA.  2010-Apr-23 15:43                          :DLIS Creation date and time {YYYY-MMM-DD hh:mm}
SOURCE.     Nalcor_Energy_Seamus_#1_Int_Main_PEX-AIT_103PUC.DLIS  :DLIS File Name
FILE-ID.     AIT_TLD_MCFL_CNL_103PUC                   :File Identification Number
#--------------------------------------------------
~WELL INFORMATION
#MNEM.UNIT      DATA             DESCRIPTION
#---- ------ --------------   -----------------------------
STRT .M      570.2808        :START DEPTH     
STOP .M      2302.0020       :STOP DEPTH     
STEP .M       0.1524         :STEP     
NULL .          -999.25      :NULL VALUE
COMP .        Nalcor Energy Oil and Gas                :COMPANY
WELL .        Nalcor et al Seamus 1                    :WELL
FLD  .        Parson's Pond                            :FIELD
LOC  .        Latitude: 49.98 N                        :LOCATION
CNTY .        Stoneham #11                             :COUNTY
STAT .        Newfoundland                             :STATE
CTRY .                                                 :COUNTRY
API  .                                                 :API NUMBER
UWI  .                                                 :UNIQUE WELL ID
DATE .        20-Apr-2010                              :LOG DATE {DD-MMM-YYYY}
SRVC .        Schlumberger                             :SERVICE COMPANY
LATI .DEG     46 DEG 23 MIN 57.8 S                     :LATITUDE
LONG .DEG     48 DEG 27 MIN 52.1 S                     :LONGITUDE
GDAT .                                                 :GeoDetic Datum
SECT .        49.98 N                                  :Section
TOWN .        57.70 W                                  :Township
#-----------------------------------------------------------------------------
~PARAMETER INFORMATION
#MNEM.UNIT    VALUE                      DESCRIPTION
#---- -----   --------------------       ------------------------
RUN  .          Run 1                    :RUN NUMBER
PDAT .        Ground Level               :Permanent Datum
EPD  .M          20.690001               :Elevation of Permanent Datum above Mean Sea Level
LMF  .          Kelly Bushing            :Logging Measured From (Name of Logging Elevation Reference)
APD  .M           6.299999               :Elevation of Depth Reference (LMF) above Permanent Datum
#-----------------------------------------------------------------------------
~CURVE INFORMATION
#MNEM.UNIT   API CODE                                  DESCRIPTION
#---- -----  --------                                  -----------------------
DEPT .M                                                :DEPTH (BOREHOLE) {F10.4}
AT10 .OHMM                                             :Array Induction Two Foot Resistivity A10 {F13.4}
AT20 .OHMM                                             :Array Induction Two Foot Resistivity A20 {F13.4}
AT30 .OHMM                                             :Array Induction Two Foot Resistivity A30 {F13.4}
AT60 .OHMM                                             :Array Induction Two Foot Resistivity A60 {F13.4}
AT90 .OHMM                                             :Array Induction Two Foot Resistivity A90 {F13.4}
ATCO90.MM/M                                            :Array Induction Two Foot Conductivity A90 {F13.4}
BS   .MM                                               :Bit Size {F13.4}
DPHI_LIM.V/V                                           :Density Porosity (matrix Limestone) {F13.4}
DPHI_SAN.V/V                                           :Density Porosity (matrix Sandstone) {F13.4}
GDEV .DEG                                              :HGNS Deviation {F13.4}
GR   .GAPI                                             :Gamma-Ray {F13.4}
HCAL .MM                                               :HRCC Cal. Caliper {F13.4}
HDRA .K/M3                                             :HRDD Density Correction {F13.4}
HTEM .DEGC                                             :HTC Temperature {F13.4}
NPOR_LIM.V/V                                           :Enhanced Thermal Neutron Porosity (matrix Limestone) {F13.4}
NPOR_SAN.V/V                                           :Enhanced Thermal Neutron Porosity (matrix Sandstone) {F13.4}
PEFZ .                                                 :HRDD Standard Resolution Formation Photoelectric Factor {F13.4}
RHOZ .K/M3                                             :HRDD Standard Resolution Formation Density {F13.4}
RXOZ .OHMM                                             :MCFL Standard Resolution Invaded Zone Resistivity {F13.4}
SP   .MV                                               :SP Shifted {F13.4}
TENS .LBF                                              :Cable Tension {F13.4}
#-----------------------------------------------------------------------------
# 
#     DEPT        AT10         AT20         AT30         AT60         AT90        ATCO90        BS         DPHI_LIM     DPHI_SAN       GDEV         GR           HCAL         HDRA         HTEM       NPOR_LIM     NPOR_SAN       PEFZ         RHOZ         RXOZ         SP           TENS
#
~A  
  570.2808       0.3714       0.2920       1.0864       1.2475       0.7090    1410.3557     311.0000      -0.9168      -0.9865       4.2783      35.7677     201.8124    1225.5259      44.9110       0.2744       0.3248      10.0000    4073.5845       0.2729     286.0000    1740.0000
  570.4332       0.3714       0.2920       1.0864       1.2475       0.7090    1410.3557     311.0000      -0.9168      -0.9865       4.2694      37.7764     208.0950    1225.5259      44.9110       0.2744       0.3248      10.0000    4073.5845       0.2729     288.8125    1727.0000
  570.5856       0.3714       0.2920       1.0864       1.2475       0.7090    1410.3557     311.0000      -0.9168      -0.9865       4.2276      36.9883     214.6508    1225.5259      44.9110       0.2744       0.3248      10.0000    4073.5845       0.2729     290.2500    1735.0000
  570.7380       0.3714       0.2920       1.0864       1.2475       0.7090    1410.3557     311.0000      -0.9168      -0.9865       4.2530      34.6903     220.9334    1225.5259      44.9110       0.3041       0.3534      10.0000    4073.5845       0.2709     281.6875    1747.0000
  570.8904       0.3714       0.2920       1.0864       1.2475       0.7090    1410.3557     311.0000      -0.9168      -0.9865       4.3330      37.0096     226.9429    1225.5259      44.9110       0.2425       0.2929      10.0000    4073.5845       0.2679     287.1250    1750.0000
  571.0428       0.3714       0.2920       1.0864       1.2475       0.7090    1410.3557     311.0000      -0.9168      -0.9865       4.2512      37.0096     233.2255    1225.5259      44.9110       0.2643       0.3152      10.0000    4073.5845       0.2655     288.0000    1765.0000
  571.1952       0.3714       0.2920       1.0864       1.2475       0.7090    1410.3557     311.0000      -0.9168      -0.9865       4.1829      37.7988     238.6886    1225.5259      44.9110       0.2479       0.2990      10.0000    4073.5845       0.2677     287.1875    1745.0000
  571.3476       0.3714       0.2920       1.0864       1.2475       0.7090    1410.3557     311.0000      -0.9168      -0.9865       4.1115      35.2509     244.4249    1371.0194      44.9110       0.2166       0.2671      10.0000    4277.7231       0.2672     288.9375    1740.0000
  571.5000       0.3714       0.2920       1.0864       1.2475       0.7090    1410.3557     311.0000      -1.0659      -1.1410       4.0231      33.6077     250.1612    1535.1598      44.9110       0.2459       0.2968      10.0000    4532.6577       0.2635     291.6875    1769.0000
  571.6524       0.3917       0.3157       1.2977       1.5600       0.8232    1214.7203     311.0000      -1.0463      -1.1207       4.0928      31.3975     255.3512    1500.3479      44.9110       0.2659       0.3169      10.0000    4499.1685       0.2628     290.7500    1778.0000
  571.8048       0.3861       0.3407       1.5564       1.9822       0.8661    1154.5557     311.0000      -0.8857      -0.9543       4.1487      32.6623     261.0875    1305.8457      45.1906       0.2825       0.3328      10.0000    4224.5273       0.2646     291.1875    1805.0000
  571.9572       0.4181       0.3358       1.3896       1.5790       0.6990    1430.6688     311.0000      -0.7049      -0.7669       4.1570      36.5120     266.0044    1106.6327      44.9110       0.2434       0.2939      10.0000    3915.4302       0.2651     283.1250    1776.0000
  572.1096       0.4466       0.3213       1.1600       1.1480       0.6360    1572.3989     311.0000      -0.6021      -0.6604       4.1239      41.6206     270.3749    1016.8970      44.9110       0.2521       0.3028      10.0000    3739.6575       0.2608     284.8125    1778.0000
  572.2620       0.4454       0.3132       1.2409       1.3229       0.6132    1630.8480     311.0000      -0.5900      -0.6478       4.0841      41.3948     275.8380    1000.3631      45.1906       0.2529       0.3046      10.0000    3718.9219       0.2566     283.8125    1785.0000
  572.4144       0.4631       0.3026       1.3012       1.3992       0.6623    1509.9427     311.0000      -0.6050      -0.6633       4.1056      40.6094     280.2086    1024.0588      44.9110       0.2200       0.2713      10.0000    3744.4846       0.2430     285.0625    1791.0000
  572.5668       0.4638       0.2990       1.2584       1.3722       0.6531    1531.2551     311.0000      -0.6247      -0.6837       4.1169      37.8300     285.1254    1046.5875      44.9110       0.2013       0.2527      10.0000    3778.1670       0.2118     283.2500    1799.0000
  572.7192       0.4712       0.2939       1.2593       1.3538       0.6596    1516.1760     311.0000      -0.6418      -0.7015       4.1206      34.4019     289.4959    1076.8778      44.9110       0.2254       0.2768      10.0000    3807.4348       0.1802     291.1875    1783.0000
  572.8716       0.4737       0.2912       1.2484       1.4116       0.6760    1479.2076     311.0000      -0.6559      -0.7161       4.2247      33.9959     294.9590    1074.9279      45.1906       0.2387       0.2903      10.0000    3831.5286       0.1360     289.6250    1788.0000
  573.0240       0.4756       0.2901       1.2191       1.3699       0.6743    1483.1022     311.0000      -0.6667      -0.7273       4.1172      33.8768     299.3296    1090.5304      45.1906       0.2403       0.2917      10.0000    3850.0515       0.1062     285.5000    1764.0000
  573.1764       0.4768       0.2907       1.2321       1.3677       0.6806    1469.3511     311.0000      -0.6778      -0.7388       4.1592      37.9128     302.6075    1096.4441      45.1906       0.2188       0.2700      10.0000    3869.0811       0.0846     286.1875    1788.0000
  573.3288       0.4810       0.2904       1.2334       1.3771       0.6822    1465.8358     311.0000      -0.6858      -0.7471       4.2333      36.5022     305.8853    1124.8619      45.1906       0.2392       0.2904      10.0000    3882.6660       0.0827     288.3125    1752.0000
  573.4812       0.4852       0.2904       1.2383       1.3672       0.6821    1465.9557     311.0000      -0.6916      -0.7531       4.1643      36.3220     307.7975    1130.1344      45.1906       0.2669       0.3181      10.0000    3892.6504       0.0654     300.9375    1762.0000
  573.6336       0.4879       0.2898       1.2566       1.3894       0.6905    1448.1525     311.0000      -0.6949      -0.7566       4.1415      35.3310     308.0706    1147.1014      45.1906       0.2268       0.2779      10.0000    3898.3108       0.0541     213.0625    1769.0000
  573.7860       0.4805       0.2855       1.2615       1.3954       0.6946    1439.7646     311.0000      -0.6985      -0.7602       4.2673      36.2574     309.1632    1137.4149      45.1906       0.2257       0.2775      10.0000    3904.3921       0.0473     291.1875    1758.0000
  573.9384       0.4779       0.2834       1.2194       1.3652       0.6878    1453.9384     311.0000      -0.6993      -0.7611       4.2270      35.2220     309.7096    1137.8071      45.1906       0.2064       0.2577      10.0000    3905.8369       0.0460     291.1875    1791.0000
  574.0908       0.4796       0.2802       1.2253       1.3639       0.6924    1444.3110     311.0000      -0.6980      -0.7597       4.0545      36.0104     309.7096    1134.9940      45.1906       0.2105       0.2619      10.0000    3903.4961       0.0529     288.8750    1786.0000
  574.2432       0.4747       0.2778       1.2420       1.3828       0.6945    1439.7865     311.0000      -0.6950      -0.7566       4.1514      36.0885     309.7096    1143.4314      45.1906       0.2283       0.2800      10.0000    3898.4089       0.0517     291.1875    1747.0000
  574.3956       0.4684       0.2761       1.2523       1.4169       0.7028    1422.7887     311.0000      -0.6960      -0.7577       4.2886      35.8019     309.7096    1153.0104      45.1906       0.2051       0.2569      10.0000    3900.1746       0.0489     291.0625    1772.0000
  574.5480       0.4664       0.2758       1.2227       1.3803       0.6940    1440.9539     311.0000      -0.6957      -0.7574       4.2115      35.2165     309.7096    1141.1705      45.1906       0.1901       0.2415      10.0000    3899.7148       0.0440     290.6250    1742.0000
  574.7004       0.4665       0.2767       1.1977       1.3664       0.6871    1455.3488     311.0000      -0.6960      -0.7577       4.1446      34.2015     309.7096    1140.6941      45.1906       0.1974       0.2489      10.0000    3900.1909       0.0475     292.3750    1753.0000
  574.8528       0.4641       0.2773       1.2229       1.3856       0.6859    1457.8921     311.0000      -0.6928      -0.7544       4.1364      32.0567     309.7096    1127.5757      45.1906       0.2069       0.2585      10.0000    3894.7183       0.0495     294.7500    1753.0000
  575.0052       0.4633       0.2792       1.2280       1.3778       0.6865    1456.7402     311.0000      -0.6913      -0.7529       4.2669      29.1133     309.9827    1140.0219      45.1906       0.2270       0.2788      10.0000    3892.2080       0.0490     291.1875    1731.0000
  575.1576       0.4622       0.2818       1.2483       1.3740       0.6984    1431.7953     311.0000      -0.6917      -0.7532       4.1981      27.4708     310.2559    1142.4861      45.1906       0.2299       0.2817      10.0000    3892.7683       0.0512     291.1875    1741.0000
  575.3100       0.4555       0.2846       1.2950       1.3861       0.7140    1400.6147     311.0000      -0.6921      -0.7537       4.1794      32.5616     309.7096    1144.8281      45.1906       0.2132       0.2642      10.0000    3893.5420       0.0505     291.6250    1766.0000
  575.4624       0.4517       0.2836       1.2787       1.3704       0.7156    1397.4878     311.0000      -0.6946      -0.7562       4.3743      37.4256     309.7096    1152.2860      45.1906       0.2165       0.2677      10.0000    3897.7930       0.0516     294.8750    1757.0000
  575.6148       0.4438       0.2804       1.2414       1.4045       0.7034    1421.5736     311.0000      -0.6903      -0.7518       4.3335      44.5489     309.7096    1172.2355      45.1906       0.2432       0.2936      10.0000    3890.4827       0.0528     293.6875    1770.0000
  575.7672       0.4339       0.2781       1.2446       1.3916       0.7000    1428.5634     311.0000      -0.6829      -0.7441       4.2673      43.3078     309.7096    1211.1799      45.1906       0.3124       0.3617      10.0000    3877.7424       0.0580     291.1875    1775.0000
  575.9196       0.4293       0.2765       1.2021       1.3439       0.6842    1461.5574     311.0000      -0.6737      -0.7345       4.3758      41.7128     309.7096    1214.6864      45.1906       0.3901       0.4343      10.0000    3861.9902       0.0663     293.6250    1770.0000
  576.0720       0.4157       0.2728       1.2721       1.4341       0.7004    1427.7943     311.0000      -0.6769      -0.7379       4.3121      37.8312     309.7096    1194.7222      45.1906       0.3858       0.4279      10.0000    3867.4626       0.0674     294.0000    1769.0000
  576.2244       0.4106       0.2718       1.2863       1.4419       0.7044    1419.5542     311.0000      -0.6871      -0.7485       4.3327      39.2495     309.7096    1151.8505      45.1906       0.3329       0.3776      10.0000    3885.0012       0.0592     291.1875    1770.0000
  576.3768       0.4022       0.2723       1.2490       1.3705       0.6935    1441.9727     311.0000      -0.6985      -0.7602       4.2956      41.5629     310.2559    1117.4731      45.1906       0.2707       0.3188      10.0000    3904.3862       0.0502     294.3125    1767.0000
  576.5292       0.4046       0.2734       1.2620       1.3893       0.6952    1438.3730     311.0000      -0.7031      -0.7650       4.3436      40.9005     309.7096    1117.5244      45.1906       0.2526       0.3027      10.0000    3912.2178       0.0468     293.4375    1765.0000
  576.6816       0.4013       0.2770       1.3254       1.3609       0.6953    1438.2061     311.0000      -0.7063      -0.7684       4.3729      37.6784     309.7096    1140.0826      45.1906       0.2865       0.3361      10.0000    3917.8486       0.0517     294.8125    1761.0000
  576.8340       0.3943       0.2793       1.3430       1.4309       0.7217    1385.5399     311.0000      -0.7055      -0.7675       4.4166      35.6249     309.9827    1167.2511      45.1906       0.2958       0.3442      10.0000    3916.4072       0.0605     293.1875    1776.0000
  576.9864       0.3869       0.2764       1.2970       1.3707       0.7142    1400.1766     311.0000      -0.6965      -0.7582       4.3533      37.2765     309.7096    1196.7909      45.1906       0.3062       0.3530      10.0000    3901.0674       0.0869     296.1250    1783.0000
  577.1388       0.3783       0.2703       1.2501       1.3427       0.6835    1463.0676     311.0000      -0.6814      -0.7425       4.2787      42.9300     309.7096    1225.3730      45.1906       0.3711       0.4149      10.0000    3875.1614       0.0843     293.5000    1780.0000
  577.2912       0.3715       0.2698       1.2208       1.3082       0.6809    1468.6305     311.0000      -0.6777      -0.7388       4.3685      44.7535     309.9827    1245.4484      45.1906       0.4579       0.4942      10.0000    3868.9390       0.0831     295.0625    1806.0000
  577.4436       0.3611       0.2675       1.1697       1.2521       0.6588    1517.9376     311.0000      -0.6878      -0.7491       4.3841      45.0069     309.7096    1226.3156      45.1906       0.4048       0.4453      10.0000    3886.0764       0.0926     296.8125    1785.0000
  577.5960       0.3602       0.2661       1.2317       1.3243       0.6784    1474.1378     311.0000      -0.7042      -0.7662       4.3947      38.9891     309.7096    1180.7163      45.1906       0.2735       0.3214      10.0000    3914.2083       0.0995     291.5625    1783.0000
  577.7484       0.3603       0.2675       1.2435       1.3303       0.6772    1476.7323     311.0000      -0.7124      -0.7747       4.4068      37.3921     309.7096    1158.7307      45.1906       0.2476       0.2979      10.0000    3928.2188       0.0771     296.1875    1799.0000
  577.9008       0.3624       0.2697       1.2593       1.3669       0.6851    1459.6959     311.0000      -0.7168      -0.7792       4.3982      35.5417     309.9827    1159.3563      45.1906       0.2337       0.2853      10.0000    3935.7180       0.0529     291.1875    1798.0000
  578.0532       0.3669       0.2724       1.2331       1.2828       0.6592    1516.9508     311.0000      -0.7200      -0.7825       4.3699      37.7098     309.7096    1170.3069      45.1906       0.2086       0.2602      10.0000    3941.1196       0.0450     293.0625    1854.0000
  578.2056       0.3704       0.2776       1.2962       1.2837       0.6604    1514.1740     311.0000      -0.7207      -0.7833       4.3024      40.5517     309.7096    1155.2054      45.1906       0.2213       0.2732      10.0000    3942.4519       0.0485     296.1875    1811.0000
  578.3580       0.3687       0.2841       1.3605       1.3902       0.6904    1448.5393     311.0000      -0.7144      -0.7768       4.3405      39.1074     309.7096    1150.1620      45.1906       0.2228       0.2743      10.0000    3931.6472       0.0599     296.1250    1753.0000
  578.5104       0.3726       0.2829       1.2879       1.3326       0.6793    1472.1130     311.0000      -0.6971      -0.7588       4.3036      38.1156     309.7096    1131.1097      45.1906       0.2268       0.2782      10.0000    3901.9565       0.0668     292.2500    1782.0000
  578.6628       0.3751       0.2847       1.2571       1.2913       0.6588    1517.8453     311.0000      -0.6696      -0.7303       4.2843      33.8315     309.7096    1113.7991      45.1906       0.2110       0.2621      10.0000    3854.9360       0.0915     291.1875    1799.0000
  578.8152       0.3748       0.2834       1.2735       1.3135       0.6693    1494.1074     311.0000      -0.6461      -0.7060       4.2557      37.3019     310.2559    1072.5298      45.1906       0.2144       0.2658      10.0000    3814.8645       0.0857     291.1875    1786.0000
  578.9676       0.3740       0.2824       1.3045       1.3586       0.6796    1471.4652     311.0000      -0.6435      -0.7033       4.3217      37.0759     310.2559    1072.0525      45.1906       0.2733       0.3245      10.0000    3810.4631       0.1247     291.1875    1787.0000
  579.1200       0.3792       0.2840       1.2539       1.2971       0.6650    1503.6735     311.0000      -0.6601      -0.7205       4.2837      40.5203     310.2559    1111.5665      45.1906       0.2679       0.3184      10.0000    3838.7793       0.1104     291.1875    1779.0000
  579.2724       0.3830       0.2843       1.2571       1.2825       0.6597    1515.7830     311.0000      -0.6716      -0.7324       4.3144      43.1865     310.2559    1158.5515      45.1906       0.2265       0.2765      10.0000    3858.4355       0.1235     290.6875    1759.0000
  579.4248       0.3854       0.2848       1.2736       1.3030       0.6635    1507.1692     311.0000      -0.6685      -0.7292       4.0822      47.5635     309.7096    1184.5796      45.1906       0.2551       0.3051      10.0000    3853.1045       0.0870     289.3750    1780.0000
  579.5772       0.3853       0.2855       1.2726       1.3306       0.6722    1487.7401     311.0000      -0.6587      -0.7190       4.3992      45.7643     309.7096    1177.5117      45.1906       0.3743       0.4216      10.0000    3836.3293       0.0616     291.2500    1785.0000
  579.7296       0.3849       0.2857       1.2611       1.2977       0.6665    1500.3013     311.0000      -0.6571      -0.7174       4.3963      44.1111     309.7096    1176.2791      45.1906       0.3498       0.3940      10.0000    3833.7253       0.0601     293.6250    1759.0000
  579.8820       0.3821       0.2853       1.2827       1.3248       0.6697    1493.3026     311.0000      -0.6606      -0.7210       4.1005      41.5910     309.7096    1196.9827      45.1906       0.3708       0.4119      10.0000    3839.6597       0.0587     291.1875    1810.0000
  580.0344       0.3807       0.2846       1.2775       1.3729       0.6804    1469.6584     311.0000      -0.6716      -0.7324       4.2703      41.1381     309.7096    1217.1376      45.1906       0.4089       0.4484      10.0000    3858.4275       0.0614     291.6875    1806.0000
  580.1868       0.3831       0.2845       1.2876       1.3295       0.6759    1479.6010     311.0000      -0.6871      -0.7484       4.3217      39.6959     309.7096    1199.1444      45.1906       0.3635       0.4072      10.0000    3884.8701       0.0447     294.0625    1840.0000
  580.3392       0.3872       0.2842       1.2680       1.2976       0.6629    1508.4098     311.0000      -0.7053      -0.7673       4.2142      40.1602     309.7096    1171.9070      45.1906       0.2747       0.3242      10.0000    3916.1128       0.0385     291.2500    1852.0000
  580.4916       0.3876       0.2815       1.3334       1.3786       0.6855    1458.7883     311.0000      -0.7118      -0.7741       4.1221      39.7784     309.7096    1156.2780      45.1906       0.2774       0.3266      10.0000    3927.1941       0.0381     291.1875    1860.0000
  580.6440       0.3971       0.2842       1.3021       1.3615       0.6841    1461.7841     311.0000      -0.7008      -0.7626       4.2362      37.8952     309.7096    1156.4572      45.1906       0.2484       0.2983      10.0000    3908.3293       0.0424     290.0625    1876.0000
  580.7964       0.3940       0.2862       1.2410       1.2868       0.6653    1502.9714     311.0000      -0.6801      -0.7412       4.1611      38.6154     309.7096    1171.6428      45.1906       0.2908       0.3371      10.0000    3873.0059       0.0459     289.6875    1867.0000
  580.9488       0.3921       0.2845       1.2633       1.2822       0.6645    1504.8662     311.0000      -0.6652      -0.7257       4.0290      41.3140     309.7096    1206.4929      45.1906       0.4305       0.4682      10.0000    3847.4570       0.0442     292.0625    1876.0000
  581.1012       0.3876       0.2846       1.2875       1.3208       0.6766    1477.9305     311.0000      -0.6622      -0.7227       4.1315      42.6132     309.7096    1227.7960      45.1906       0.5342       0.5580      10.0000    3842.4321       0.0386     291.1875    1892.0000
  581.2536       0.3862       0.2850       1.2817       1.3523       0.6884    1452.7041     311.0000      -0.6625      -0.7229       4.0810      42.7907     309.7096    1218.9111      45.1906       0.4757       0.5015      10.0000    3842.8020       0.0419     290.6250    1870.0000
  581.4060       0.3862       0.2848       1.2751       1.3640       0.6927    1443.6608     311.0000      -0.6593      -0.7197       4.0475      42.9568     309.7096    1194.6156      45.1906       0.4616       0.4946      10.0000    3837.4641       0.0475     291.1875    1868.0000
  581.5584       0.3871       0.2837       1.2674       1.2956       0.6702    1492.0997     311.0000      -0.6604      -0.7208       4.1665      41.6576     309.7096    1199.8041      45.1906       0.4182       0.4544      10.0000    3839.3230       0.0577     288.0000    1888.0000
  581.7108       0.3884       0.2825       1.2727       1.2943       0.6659    1501.6943     311.0000      -0.6723      -0.7332       4.1023      43.7421     309.7096    1218.6663      45.1906       0.3901       0.4282      10.0000    3859.7021       0.0593     286.3750    1917.0000
  581.8632       0.3880       0.2817       1.2673       1.2732       0.6656    1502.4313     311.0000      -0.6864      -0.7477       3.9704      41.7122     309.7096    1210.3086      45.1906       0.5278       0.5525      10.0000    3883.7600       0.0536     287.5000    1962.0000
  582.0156       0.3859       0.2814       1.2731       1.2825       0.6728    1486.4220     311.0000      -0.6967      -0.7584       4.0891      41.7122     310.2559    1197.9015      45.1906       0.4215       0.4595      10.0000    3901.4229       0.0482     287.7500    1941.0000
  582.1680       0.3824       0.2814       1.2909       1.3161       0.6757    1479.8401     311.0000      -0.7036      -0.7655       4.1184      36.6348     309.7096    1154.9655      45.1906       0.2970       0.3445      10.0000    3913.1069       0.0481     287.7500    1855.0000
  582.3204       0.3773       0.2828       1.2761       1.3053       0.6670    1499.1472     311.0000      -0.7167      -0.7791       4.0156      38.2353     309.7096    1141.4700      45.1906       0.2888       0.3392      10.0000    3935.4883       0.0500     285.3750    1853.0000
  582.4728       0.3798       0.2815       1.2432       1.2885       0.6580    1519.8167     311.0000      -0.7291      -0.7920       3.9939      36.9211     310.2559    1136.5802      45.1906       0.2139       0.2646      10.0000    3956.8408       0.0529     285.4375    1843.0000
  582.6252       0.3809       0.2848       1.2731       1.2733       0.6554    1525.6694     311.0000      -0.7379      -0.8011       4.0456      35.5131     309.7096    1138.0240      45.1906       0.2341       0.2855      10.0000    3971.8774       0.0463     283.0000    1842.0000
  582.7776       0.3829       0.2868       1.2941       1.3114       0.6695    1493.7107     311.0000      -0.7433      -0.8067       4.0208      31.0518     309.7096    1143.2173      45.1906       0.2132       0.2649      10.0000    3981.0234       0.0427     284.5000    1855.0000
  582.9300       0.3791       0.2881       1.3138       1.3280       0.6756    1480.1375     311.0000      -0.7494      -0.8130       3.7951      33.0886     309.7096    1137.9214      45.1906       0.1689       0.2197      10.0000    3991.4600       0.0427     291.1875    1882.0000
  583.0824       0.3859       0.2875       1.2851       1.3059       0.6734    1485.0762     311.0000      -0.7542      -0.8180       3.8146      33.8675     309.7096    1147.5653      45.1906       0.1714       0.2224      10.0000    3999.7324       0.0444     284.7500    1878.0000
  583.2348       0.3873       0.2877       1.2614       1.2861       0.6717    1488.8058     311.0000      -0.7502      -0.8139       4.0298      35.1105     309.7096    1162.3000      45.1906       0.2002       0.2517      10.0000    3992.9170       0.0410     284.4375    1869.0000
  583.3872       0.3876       0.2864       1.2833       1.3113       0.6715    1489.2166     311.0000      -0.7339      -0.7969       3.8533      36.4707     309.7096    1213.3196      45.1906       0.2666       0.3173      10.0000    3964.9050       0.0440     282.6875    1864.0000
  583.5396       0.3933       0.2853       1.2723       1.3693       0.6973    1434.1804     311.0000      -0.7121      -0.7743       3.8424      41.5161     309.7096    1258.1602      45.1906       0.3105       0.3574      10.0000    3927.6760       0.0453     284.7500    1891.0000
  583.6920       0.4010       0.2850       1.2763       1.3978       0.7173    1394.1853     311.0000      -0.6946      -0.7562       3.7708      46.1488     310.2559    1250.4590      45.1906       0.4146       0.4556      10.0000    3897.8086       0.0461     282.8125    1879.0000
  583.8444       0.4157       0.2873       1.2624       1.3472       0.7091    1410.1548     311.0000      -0.6883      -0.7497       3.8692      47.3419     310.2559    1201.8270      45.1906       0.3993       0.4403      10.0000    3887.0405       0.0513     281.3750    1890.0000
  583.9968       0.4289       0.2860       1.3367       1.3871       0.7280    1373.5824     311.0000      -0.6840      -0.7452       3.8440      46.9566     310.2559    1177.2773      45.1906       0.2812       0.3290      10.0000    3879.5996       0.0533     279.6875    1900.0000
  584.1492       0.4428       0.2833       1.3115       1.4005       0.7380    1355.0887     311.0000      -0.6799      -0.7410       3.6955      49.4798     309.9827    1197.5786      45.1906       0.3017       0.3482      10.0000    3872.6580       0.0551     279.4375    1918.0000
  584.3016       0.4407       0.2927       1.1848       1.2983       0.6901    1449.0469     311.0000      -0.6720      -0.7328       3.7083      54.5863     309.7096    1220.2936      45.1906       0.4254       0.4647      10.0000    3859.1970       0.0497     281.3750    1894.0000
  584.4540       0.4468       0.2922       1.1683       1.1943       0.6463    1547.1536     311.0000      -0.6822      -0.7434       3.7995      56.4098     309.7096    1260.0951      45.1906       0.4630       0.4922      10.0000    3876.6418       0.0481     283.6875    1884.0000
  584.6064       0.4473       0.2939       1.0259       1.2057       0.6412    1559.5355     311.0000      -0.7405      -0.8038       3.8513      52.7039     309.7096    1349.2234      45.1906       0.4835       0.5096      10.0000    3976.2251       0.0450     281.3750    1885.0000
  584.7588       0.4577       0.3025       0.8927       1.2644       0.5306    1884.5013     311.0000      -0.8874      -0.9561       3.6529      47.4731     309.7096    1481.0438      45.1906       0.5047       0.5328      10.0000    4227.5083       0.0502     281.3750    1902.0000
  584.9112       0.5622       0.3217       1.0350       0.9777       0.5552    1801.1589     311.0000      -1.0253      -1.0989       3.6777      43.2216     309.7096    1546.6526      45.1906       0.4783       0.5080      10.0000    4463.2070       0.0734     289.5625    1880.0000
  585.0636       0.6356       0.3916       1.6401       1.2474       0.7018    1424.8610     311.0000      -1.1166      -1.1935       3.8491      38.3446     309.7096    1525.8009      45.1906       0.4262       0.4599      10.0000    4619.3462       0.1020     288.6250    1893.0000
  585.2160       0.4761       0.4543       1.9978       1.3351       0.7946    1258.5685     311.0000      -1.1221      -1.1993       3.5850      31.7187     310.2559    1441.4468      45.1906       0.4149       0.4528      10.0000    4628.7998       0.1037     284.8125    1911.0000
  585.3684       0.5365       0.3826       1.1537       0.8513       0.4895    2042.8157     311.0000      -1.1221      -1.1993       3.5050      29.1007     310.2559    1373.4186      45.1906       0.3140       0.3611      10.0000    4628.7998       0.0935     282.0625    1901.0000
  585.5208       0.5207       0.3359       0.9093       0.8378       0.5324    1878.3771     311.0000      -1.1221      -1.1993       3.6989      28.4188     312.4411    1368.6313      45.1906       0.2085       0.2595      10.0000    4628.7998       0.0924     284.5000    1894.0000
  585.6732       0.4719       0.2682       1.2817       0.6710       0.4083    2449.1116     311.0000      -1.1062      -1.1828       3.7502      32.7871     309.7096    1399.6599      45.1906       0.2037       0.2551      10.0000    4601.6245       0.0906     281.3750    1925.0000
  585.8256       0.4229       0.2437       1.0276       1.4156       0.7181    1392.5050     311.0000      -1.0090      -1.0820       3.5906      36.5935     310.2559    1372.1268      45.1906       0.2435       0.2956      10.0000    4435.3569       0.0629     281.3750    1933.0000
  585.9780       0.3904       0.2259       0.9164       1.3216       0.6717    1488.8329     311.0000      -0.8877      -0.9564       3.6223      41.1064     310.2559    1269.0492      45.1906       0.2108       0.2623      10.0000    4228.0352       0.0576     281.3750    1946.0000
  586.1304       0.3863       0.2208       0.9696       1.1244       0.6057    1650.9399     311.0000      -0.7784      -0.8430       3.6591      43.9184     310.2559    1169.4567      45.1906       0.2042       0.2553      10.0000    4041.0117       0.0520     287.0625    1944.0000
  586.2828       0.3983       0.2356       1.2405       1.2081       0.5880    1700.6864     311.0000      -0.7506      -0.8143       3.7360      44.3474     310.8022    1139.8060      45.1906       0.2240       0.2754      10.0000    3993.5142       0.0544     288.2500    1900.0000
  586.4352       0.4119       0.2490       1.3096       1.7403       0.6930    1442.9872     311.0000      -0.7507      -0.8144       3.7218      42.8719     310.8022    1145.6368      45.1906       0.2533       0.3046      10.0000    3993.7246       0.0507     287.4375    1878.0000
  586.5876       0.4203       0.2641       1.3344       1.4494       0.6844    1461.0496     311.0000      -0.7586      -0.8225       3.7692      38.2365     310.2559    1127.4064      45.1906       0.2291       0.2808      10.0000    4007.1555       0.0529     285.4375    1880.0000
  586.7400       0.4200       0.2775       1.4609       1.3870       0.8258    1210.9427     311.0000      -0.7671      -0.8313       3.6694      35.6925     310.8022    1110.7795      45.1906       0.1987       0.2503      10.0000    4021.6750       0.0581     288.5625    1890.0000
  586.8924       0.4085       0.2817       1.4014       1.4478       0.7945    1258.5833     311.0000      -0.7710      -0.8354       3.9833      37.3969     310.8022    1119.5609      45.1906       0.1861       0.2375      10.0000    4028.4473       0.0813     286.7500    1879.0000
  587.0448       0.4033       0.2831       1.2926       1.3845       0.7493    1334.6500     311.0000      -0.7706      -0.8350       3.5986      38.3264     310.8022    1141.9203      45.1906       0.1917       0.2433      10.0000    4027.7009       0.0840     287.7500    1880.0000
  587.1972       0.3974       0.2795       1.2491       1.3623       0.6892    1450.9764     311.0000      -0.7679      -0.8322       3.5393      39.2737     310.8022    1148.8685      45.1906       0.1868       0.2382      10.0000    4023.1409       0.0712     287.7500    1861.0000
  587.3496       0.3784       0.2763       1.2191       1.3353       0.6768    1477.5453     311.0000      -0.7640      -0.8281       3.8568      41.0174     310.8022    1138.8270      45.1906       0.1925       0.2442      10.0000    4016.3699       0.0653     287.3125    1871.0000
  587.5020       0.3761       0.2714       1.1576       1.3157       0.6262    1596.9698     311.0000      -0.7602      -0.8242       3.7041      37.8762     310.8022    1127.9192      45.1906       0.2051       0.2569      10.0000    4009.9573       0.0821     284.6250    1888.0000
  587.6544       0.3803       0.2712       1.2249       1.3464       0.6599    1515.3875     311.0000      -0.7585      -0.8224       3.5462      37.8554     310.8022    1126.9684      45.1906       0.2062       0.2577      10.0000    4007.0061       0.0812     283.8125    1874.0000
  587.8068       0.3881       0.2699       1.2424       1.3259       0.6659    1501.6522     311.0000      -0.7586      -0.8226       3.5944      35.0967     310.8022    1125.7799      45.1906       0.2074       0.2588      10.0000    4007.2703       0.0530     284.3750    1874.0000
  587.9592       0.3914       0.2733       1.3565       1.3795       0.6957    1437.4218     311.0000      -0.7554      -0.8192       3.6424      37.0798     310.8022    1119.3309      45.1906       0.2069       0.2585      10.0000    4001.6934       0.0464     288.2500    1872.0000
  588.1116       0.3962       0.2699       1.3187       1.3646       0.6881    1453.1960     311.0000      -0.7411      -0.8044       3.6074      38.2379     310.8022    1105.4299      45.1906       0.2017       0.2526      10.0000    3977.3074       0.0547     285.7500    1884.0000
  588.2640       0.3897       0.2659       1.2136       1.2685       0.6601    1514.8859     311.0000      -0.7139      -0.7762       3.7172      39.8619     310.8022    1113.1497      45.1906       0.2279       0.2784      10.0000    3930.7607       0.0702     288.3125    1867.0000
  588.4164       0.3890       0.2630       1.1040       1.1532       0.6226    1606.2611     311.0000      -0.6805      -0.7416       3.8694      44.2626     310.8022    1156.5402      45.1906       0.3596       0.4039      10.0000    3873.6567       0.0669     291.1875    1869.0000
  588.5688       0.3764       0.2612       1.0634       1.1617       0.6259    1597.6936     311.0000      -0.6537      -0.7138       3.6708      46.9507     310.8022    1238.6239      45.1906       0.4620       0.4966      10.0000    3827.8252       0.0669     290.0000    1887.0000
  588.7212       0.3806       0.2682       1.1602       1.2384       0.6525    1532.5497     311.0000      -0.6438      -0.7035       3.6176      48.5833     310.2559    1295.1448      45.1906       0.5511       0.5718      10.0000    3810.8254       0.0824     289.1250    1883.0000
  588.8736       0.3875       0.2731       1.2216       1.2911       0.6651    1503.4659     311.0000      -0.6518      -0.7119       3.9908      50.0843     310.8022    1298.5518      45.1906       0.5636       0.5835      10.0000    3824.6064       0.0756     291.1875    1887.0000
  589.0260       0.3807       0.2761       1.3027       1.3541       0.6799    1470.8169     311.0000      -0.6675      -0.7281       3.7266      50.8948     310.2559    1232.6017      45.1906       0.4895       0.5192      10.0000    3851.3625       0.0870     290.5000    1892.0000
  589.1784       0.3801       0.2743       1.2634       1.3823       0.6610    1512.9629     311.0000      -0.6781      -0.7391       3.6669      49.9336     310.2559    1181.6509      45.1906       0.3123       0.3557      10.0000    3869.5652       0.0755     290.0000    1892.0000
  589.3308       0.3758       0.2699       1.2155       1.3020       0.6623    1509.8774     311.0000      -0.6730      -0.7339       3.8327      49.7625     310.8022    1174.4890      45.1906       0.3113       0.3562      10.0000    3860.8833       0.0711     285.5625    1908.0000
  589.4832       0.3742       0.2658       1.1642       1.2520       0.6278    1592.9309     311.0000      -0.6602      -0.7206       3.8464      44.4110     310.8022    1211.5114      45.1906       0.3878       0.4301      10.0000    3838.9333       0.0555     289.5000    1931.0000
  589.6356       0.3674       0.2646       1.2192       1.3483       0.6631    1507.9745     311.0000      -0.6506      -0.7106       3.5377      41.7096     310.8022    1244.5059      45.1906       0.4148       0.4536      10.0000    3822.5474       0.0588     290.6250    1922.0000
  589.7880       0.3654       0.2616       1.2410       1.3436       0.6668    1499.6301     311.0000      -0.6538      -0.7139       3.4772      40.8430     310.8022    1233.4960      45.1906       0.3594       0.4017      10.0000    3827.9319       0.0559     291.1875    1923.0000
  589.9404       0.3643       0.2606       1.2403       1.3202       0.6764    1478.5029     311.0000      -0.6623      -0.7227       3.6742      45.4155     310.8022    1205.0806      45.1906       0.3690       0.4100      10.0000    3842.5081       0.0496     287.4375    1964.0000
  590.0928       0.3619       0.2600       1.2180       1.3315       0.6719    1488.3573     311.0000      -0.6660      -0.7266       3.9042      50.2015     310.8022    1168.0000      45.1906       0.3693       0.4119      10.0000    3848.9106       0.0583     287.2500    2035.0000
  590.2452       0.3622       0.2596       1.1924       1.3093       0.6528    1531.9618     311.0000      -0.6631      -0.7236       3.7333      47.6172     310.8022    1156.7245      45.1906       0.3699       0.4134      10.0000    3843.9373       0.0626     291.0000    1900.0000
  590.3976       0.3646       0.2612       1.1687       1.2181       0.6429    1555.5627     311.0000      -0.6645      -0.7251       2.9349      48.8352     310.8022    1179.5051      45.1906       0.3273       0.3737      10.0000    3846.3503       0.0767     288.8750    1875.0000
  590.5500       0.3695       0.2646       1.1626       1.2259       0.6490    1540.7189     311.0000      -0.6768      -0.7378       3.7691      46.2544     311.0753    1189.5819      45.1906       0.3731       0.4191      10.0000    3867.3948       0.0652     289.8125    1904.0000
  590.7024       0.3708       0.2698       1.2051       1.3123       0.6696    1493.4172     311.0000      -0.6976      -0.7593       3.8317      48.2555     310.8022    1175.0291      45.1906       0.3055       0.3531      10.0000    3902.9045       0.0912     284.8750    1902.0000
  590.8548       0.3748       0.2743       1.2862       1.4084       0.7075    1413.4484     311.0000      -0.7057      -0.7678       3.5940      42.0271     311.0753    1126.1582      45.1906       0.2119       0.2610      10.0000    3916.8179       0.0841     283.9375    1888.0000
  591.0072       0.3665       0.2737       1.2220       1.3127       0.6712    1489.8960     311.0000      -0.6953      -0.7569       3.9396      42.0271     310.8022    1095.3915      45.1906       0.2726       0.3220      10.0000    3898.9338       0.0715     287.9375    1868.0000
  591.1596       0.3599       0.2718       1.1464       1.2544       0.6497    1539.2043     311.0000      -0.6759      -0.7368       3.8059      40.2941     310.8022    1092.9438      45.1906       0.3275       0.3763      10.0000    3865.7983       0.0684     291.1875    1886.0000
  591.3120       0.3568       0.2720       1.1628       1.2594       0.6518    1534.2351     311.0000      -0.6699      -0.7306       3.6864      45.5075     310.8022    1113.0564      45.1906       0.3189       0.3656      10.0000    3855.5146       0.0657     281.3750    1863.0000
  591.4644       0.3575       0.2723       1.1959       1.2631       0.6608    1513.3258     311.0000      -0.6774      -0.7384       4.0907      44.1507     310.8022    1144.6147      45.1906       0.3110       0.3580      10.0000    3868.3987       0.0568     286.8750    1862.0000
  591.6168       0.3528       0.2714       1.1793       1.2592       0.6508    1536.6860     311.0000      -0.6870      -0.7484       3.8531      46.1156     310.8022    1187.0398      45.1906       0.3955       0.4377      10.0000    3884.8455       0.0500     287.8750    1882.0000
  591.7692       0.3530       0.2706       1.1877       1.2287       0.6400    1562.4318     311.0000      -0.6923      -0.7538       3.9845      43.6563     310.8022    1219.9132      45.1906       0.3972       0.4371      10.0000    3893.8486       0.0474     291.1875    1923.0000
  591.9216       0.3514       0.2713       1.2121       1.2822       0.6479    1543.5063     311.0000      -0.6983      -0.7601       3.6017      47.6797     310.8022    1206.2678      45.1906       0.4089       0.4456      10.0000    3904.1785       0.0513     279.8750    1878.0000
  592.0740       0.3520       0.2708       1.2741       1.3502       0.6552    1526.1434     311.0000      -0.7059      -0.7679       3.4773      46.8729     311.3485    1172.4675      45.1906       0.3616       0.4046      10.0000    3917.0530       0.0484     305.7500    1919.0000
  592.2264       0.3523       0.2695       1.2805       1.3273       0.6544    1528.2058     311.0000      -0.7083      -0.7704       4.1058      47.7994     311.3485    1156.1572      45.1906       0.3127       0.3586      10.0000    3921.2190       0.0606     280.8750    1918.0000
  592.3788       0.3541       0.2667       1.2291       1.2554       0.6248    1600.5149     311.0000      -0.7057      -0.7678       3.5781      44.5515     310.8022    1164.7719      45.1906       0.3031       0.3519      10.0000    3916.7961       0.0652     283.0000    1907.0000
  592.5312       0.3544       0.2653       1.2311       1.2531       0.6331    1579.5095     311.0000      -0.7045      -0.7665       3.2892      43.9108     310.8022    1164.1598      45.1906       0.3307       0.3789      10.0000    3914.6526       0.0573     283.0000    1919.0000
  592.6836       0.3561       0.2655       1.2450       1.3358       0.6530    1531.2809     311.0000      -0.7097      -0.7719       3.8962      41.1586     310.8022    1131.6323      45.1906       0.2437       0.2945      10.0000    3923.6233       0.0441     289.8750    1915.0000
  592.8360       0.3596       0.2659       1.2404       1.3079       0.6519    1534.0371     311.0000      -0.7163      -0.7787       3.9370      41.1320     310.8022    1104.8622      45.1906       0.1987       0.2493      10.0000    3934.8853       0.0424     287.8125    1931.0000
  592.9884       0.3556       0.2649       1.2251       1.2826       0.6511    1535.9282     311.0000      -0.7204      -0.7829       3.7088      38.9934     310.8022    1093.3973      45.1906       0.2421       0.2941      10.0000    3941.8455       0.0486     287.4375    1915.0000
  593.1408       0.3525       0.2630       1.1558       1.2459       0.6401    1562.3589     311.0000      -0.7232      -0.7859       3.7442      38.1812     310.8022    1109.0836      45.1906       0.2140       0.2658      10.0000    3946.7568       0.0591     286.8750    1946.0000
  593.2932       0.3535       0.2665       1.1908       1.3200       0.6508    1536.4567     311.0000      -0.7292      -0.7921       3.8819      38.1573     310.8022    1122.7732      45.1906       0.1991       0.2508      10.0000    3956.9919       0.0589     287.2500    1934.0000
  593.4456       0.3539       0.2687       1.2353       1.3485       0.6621    1510.3022     311.0000      -0.7332      -0.7962       3.8115      39.8908     311.0753    1115.6761      45.1906       0.1811       0.2322      10.0000    3963.7876       0.0490     287.3125    1947.0000
  593.5980       0.3557       0.2708       1.2402       1.3408       0.6666    1500.0411     311.0000      -0.7301      -0.7930       4.1930      40.9073     310.8022    1095.1238      45.1906       0.1747       0.2257      10.0000    3958.4536       0.0467     287.8750    1966.0000
  593.7504       0.3557       0.2720       1.2693       1.3572       0.6729    1486.1426     311.0000      -0.7203      -0.7828       4.2575      40.3487     311.0753    1081.5142      45.1906       0.2102       0.2624      10.0000    3941.6545       0.0536     288.5000    1947.0000
  593.9028       0.3595       0.2721       1.2817       1.3768       0.6745    1482.6080     311.0000      -0.7129      -0.7752       4.0419      39.5418     310.8022    1076.6354      45.1906       0.1709       0.2219      10.0000    3929.0420       0.0607     291.1875    1955.0000
  594.0552       0.3548       0.2694       1.2325       1.3231       0.6667    1499.9696     311.0000      -0.7119      -0.7741       3.2440      36.7207     310.8022    1083.0496      45.1906       0.1899       0.2416      10.0000    3927.2920       0.0476     289.8125    1966.0000
  594.2076       0.3547       0.2665       1.1643       1.2124       0.6347    1575.5199     311.0000      -0.7161      -0.7785       3.5044      35.1644     310.8022    1091.7384      45.1906       0.1561       0.2066      10.0000    3934.4565       0.0438     290.7500    1935.0000
  594.3600       0.3546       0.2677       1.1731       1.2301       0.6402    1562.1013     311.0000      -0.7193      -0.7818       3.4235      35.5912     311.0753    1102.9558      45.1906       0.1625       0.2133      10.0000    3940.0015       0.0458     291.0625    1931.0000
  594.5124       0.3507       0.2666       1.1957       1.2640       0.6458    1548.5114     311.0000      -0.7188      -0.7813       3.2306      36.7910     310.8022    1095.7897      45.1906       0.1754       0.2267      10.0000    3939.1531       0.0481     291.1875    1904.0000
  594.6648       0.3517       0.2656       1.1938       1.2728       0.6479    1543.5554     311.0000      -0.7147      -0.7771       3.5785      36.3173     310.8022    1060.7841      45.1906       0.1801       0.2315      10.0000    3932.2195       0.0480     293.4375    1892.0000
  594.8172       0.3526       0.2651       1.1814       1.2836       0.6413    1559.3638     311.0000      -0.7085      -0.7706       3.7145      34.6494     311.3485    1038.6801      45.4702       0.1860       0.2376      10.0000    3921.4792       0.0441     293.8125    1883.0000
  594.9696       0.3571       0.2663       1.2084       1.2676       0.6372    1569.4183     311.0000      -0.7028      -0.7647       3.4802      36.5307     310.8022    1025.9004      45.1906       0.1730       0.2241      10.0000    3911.7039       0.0429     292.6875    1884.0000
  595.1220       0.3610       0.2677       1.2594       1.3122       0.6494    1539.7883     311.0000      -0.6980      -0.7598       3.6059      35.6986     310.8022    1029.3157      45.1906       0.1829       0.2344      10.0000    3903.6326       0.0376     293.1250    1892.0000
  595.2744       0.3614       0.2679       1.2964       1.4093       0.6683    1496.3157     311.0000      -0.6951      -0.7568       3.6761      39.4875     310.8022    1029.5706      45.1906       0.1736       0.2244      10.0000    3898.6970       0.0337     290.5000    1894.0000
  595.4268       0.3620       0.2662       1.2683       1.3727       0.6661    1501.3236     311.0000      -0.6918      -0.7533       3.7420      40.2634     310.8022    1023.3824      45.1906       0.2262       0.2780      10.0000    3892.9221       0.0387     291.1875    1927.0000
  595.5792       0.3599       0.2628       1.2105       1.3317       0.6654    1502.8379     311.0000      -0.6854      -0.7467       3.7187      43.4220     310.8022    1017.1058      45.1906       0.2425       0.2947      10.0000    3882.0417       0.0395     291.1875    1906.0000
  595.7316       0.3559       0.2618       1.2140       1.3341       0.6749    1481.7511     311.0000      -0.6715      -0.7322       3.5770      39.6771     310.8022     992.4214      45.1906       0.1962       0.2478      10.0000    3858.1873       0.0369     291.1875    1924.0000
  595.8840       0.3508       0.2609       1.2161       1.3870       0.6895    1450.2789     311.0000      -0.6447      -0.7046       3.7111      38.1781     310.8022     970.8428      45.1906       0.1902       0.2417      10.0000    3812.5149       0.0371     288.4375    1960.0000
  596.0364       0.3448       0.2610       1.1809       1.3638       0.7021    1424.1997     311.0000      -0.5985      -0.6566       3.7743      38.0844     310.8022     910.0123      45.4702       0.1946       0.2461      10.0000    3733.3972       0.0443     286.1250    1928.0000
  596.1888       0.3385       0.2637       1.1422       1.3111       0.6815    1467.2585     311.0000      -0.5319      -0.5876       3.6788      38.8183     310.8022     829.8495      45.4702       0.1743       0.2252      10.0000    3619.4741       0.0516     286.0625    1892.0000
  596.3412       0.3290       0.2666       1.1770       1.3961       0.7040    1420.4301     311.0000      -0.4513      -0.5040       3.3530      44.1741     311.6216     709.9650      45.4702       0.1855       0.2367      10.0000    3481.6443       0.0478     281.6250    1939.0000
  596.4936       0.3208       0.2689       1.2393       1.4485       0.7463    1339.9688     311.0000      -0.3696      -0.4194       3.8077      46.5840     311.8948     610.2715      45.4702       0.2160       0.2673      10.0000    3342.0225       0.0653     281.6875    1943.0000
  596.6460       0.3082       0.2717       1.2528       1.4484       0.7613    1313.4722     311.0000      -0.2997      -0.3469       4.2278      58.3966     312.1680     523.4027      45.4702       0.3084       0.3579      10.0000    3222.4475       0.1138     281.3750    1929.0000
  596.7984       0.2909       0.2725       1.2723       1.5461       0.8195    1220.2742     311.0000      -0.2453      -0.2906       3.5161      57.1787     312.4411     450.5470      45.4702       0.4025       0.4466      10.0000    3129.4829       0.1189     282.4375    1940.0000
  596.9508       0.2748       0.2679       1.1944       1.4429       0.8094    1235.4982     311.0000      -0.2032      -0.2470       3.4380      58.5926     312.7143     381.7015      45.4702       0.3138       0.3615      10.0000    3057.5513       0.0810     284.1250    1944.0000
  597.1032       0.2550       0.2608       1.1822       1.4402       0.8173    1223.5485     311.0000      -0.1658      -0.2082       3.9135      53.7286     312.9874     320.6716      45.4702       0.2458       0.2938      10.0000    2993.4485       0.0525     282.3750    1938.0000
  597.2556       0.2357       0.2534       1.1512       1.3604       0.8244    1212.9938     311.0000      -0.1303      -0.1714       3.1375      53.0897     312.9874     283.8032      45.4702       0.3283       0.3749      10.0000    2932.7717       0.0548     282.6250    1923.0000
  597.4080       0.2295       0.2457       1.1456       1.4591       0.8633    1158.3031     311.0000      -0.1021      -0.1422       3.0955      52.1747     313.5338     259.3281      45.4702       0.3952       0.4363      10.0000    2884.6641       0.0570     281.3750    1933.0000
  597.5604       0.2214       0.2413       1.3124       1.6702       1.0580     945.1736     311.0000      -0.0828      -0.1222       3.8883      46.4963     312.9874     249.2933      45.4702       0.3865       0.4276      10.0000    2851.6697       0.0833     281.3750    1926.0000
  597.7128       0.2193       0.2408       1.2769       1.5423       1.0261     974.5226     311.0000      -0.0812      -0.1205       4.1609      43.2290     312.9874     238.9839      45.4702       0.4317       0.4726      10.0000    2848.8264       0.1210     281.3750    1923.0000
  597.8652       0.2171       0.2450       1.2534       1.3893       1.0839     922.5874     311.0000      -0.0926      -0.1323       4.1995      41.3351     312.9874     223.2373      45.4702       0.3027       0.3514      10.0000    2868.3008       0.1142     281.3750    1929.0000
  598.0176       0.2154       0.2485       1.4652       1.7306       1.1789     848.2247     311.0000      -0.1082      -0.1485       3.3052      40.5281     313.5338     196.8195      45.4702       0.1987       0.2499      10.0000    2895.0842       0.0837     281.3750    1953.0000
  598.1700       0.2175       0.2593       1.5158       1.5257       1.3560     737.4388     311.0000      -0.1112      -0.1516       2.5242      43.8254     313.5338     168.5750      45.4702       0.1707       0.2217      10.0000    2900.1125       0.0809     281.3750    1928.0000
  598.3224       0.2181       0.2591       1.2535       1.1864       1.1042     905.6310     311.0000      -0.0846      -0.1240       3.1683      46.1468     313.5338     115.3731      45.4702       0.1554       0.2058      10.0000    2854.5957       0.1248     281.3750    1927.0000
  598.4748       0.2105       0.2552       1.0261       0.9331       0.8083    1237.1899     311.0000      -0.0558      -0.0942       3.7782      46.7766     313.8069      65.9573      45.4702       0.1524       0.2028      10.0000    2805.4661       0.2091     275.3125    1892.0000
  598.6272       0.2038       0.2486       0.7364       0.8013       0.6222    1607.1241     311.0000      -0.0411      -0.0789       3.8983      44.8690     313.5338       5.9733      45.4702       0.1580       0.2085      10.0000    2780.2581       0.1696     274.2500    1899.0000
  598.7796       0.2003       0.2355       0.5824       0.4933       0.4224    2367.2568     311.0000      -0.1081      -0.1484       3.8060      40.7207     314.0800      31.6250      45.4702       0.1573       0.2078      10.0000    2894.9304       0.1545     278.8750    1882.0000
  598.9320       0.2429       0.3212       0.6953       0.3724       0.3331    3002.4412     311.0000      -0.3202      -0.3682       2.8609      39.6276     315.1727     284.5566      45.4702       0.1405       0.1902      10.0000    3257.5388       0.1603     285.7500    1900.0000
  599.0844       0.3358       0.4657       1.2939       0.8058       0.6619    1510.8682     311.0000      -0.5665      -0.6234       3.1811      36.2373     315.7190     609.0698      45.4702       0.1204       0.1689       9.8190    3678.6458       0.2257     291.1875    1893.0000
  599.2368       0.5986       0.9547       3.9210       1.3969       1.1506     869.1050     311.0000      -0.5767      -0.6340       3.3362      32.0662     318.7238     644.1400      45.4702       0.1556       0.2060       9.0892    3696.1338       0.2622     296.1250    1880.0000
  599.3892       0.7780       1.4671       2.9476       1.1528       0.7763    1288.1292     311.0000      -0.3661      -0.4157       3.2176      35.3626     314.6264     389.2896      45.4702       0.1881       0.2399       7.5511    3335.9834       0.3999     300.3125    1862.0000
  599.5416       0.8429       1.6184       2.4515       1.4993       1.0576     945.5344     311.0000      -0.0976      -0.1375       2.9207      37.1315     321.1822     103.9119      45.4702       0.1221       0.1706       5.7756    2876.8796       0.8495     291.1875    1911.0000
  599.6940       1.3172       1.9270       3.5290       1.6129       0.9656    1035.6392     311.0000      -0.0051      -0.0417       3.0499      45.5332     336.4790      47.2541      45.4702       0.1010       0.1476       4.3127    2718.7722      35.5297     285.3750    1915.0000
  599.8464       1.2944       3.3310       2.6105       1.5817       0.9392    1064.7063     311.0000       0.0239      -0.0116       3.2018      45.7454     347.9516      39.9067      45.4702       0.1095       0.1567       3.5675    2669.0769      63.0004     281.3750    1896.0000
  599.9988       2.6589       4.5907       4.0122       2.4462       1.1545     866.1530     311.0000       0.0323      -0.0029       3.1477      52.2836     348.4979      20.5510      45.4702       0.1217       0.1694       3.2185    2654.7393      65.5514     277.0625    1912.0000
  600.1512       2.5935       3.8314       2.7496       1.3832       1.1224     890.9111     311.0000       0.0405       0.0056       3.0539      52.6646     351.2295      10.8852      45.4702       0.1004       0.1468       3.1233    2640.7397      76.3394     271.6250    1910.0000
  600.3036       3.1883       2.5385       2.6681       2.0034       0.9308    1074.2936     311.0000       0.0280      -0.0073       3.1487      52.2003     353.9611      13.3648      45.4702       0.1055       0.1521       3.0812    2662.1038      78.7364     269.6250    1880.0000
  600.4560       3.7123       2.7252       2.6142       3.1480       1.1605     861.6982     311.0000       0.0271      -0.0083       3.3130      47.5402     354.7805       1.6167      45.4702       0.1088       0.1557       3.0501    2663.6875      72.0863     269.3125    1890.0000
  600.6084       6.2505       2.7263       4.2210       3.5795       1.8221     548.8220     311.0000       0.0288      -0.0065       3.0609      44.5526     356.6926      -3.8109      45.4702       0.0983       0.1445       3.0181    2660.7769      58.7595     267.1875    1883.0000
  600.7608      16.3693       4.4125       8.3823       4.6296       2.8041     356.6190     311.0000       0.0484       0.0138       2.9574      50.3098     359.4242      -1.3449      45.4702       0.0983       0.1445       3.1306    2627.2532      61.4910     261.8750    1902.0000
  600.9132      33.2222       8.6898      20.6892       5.6031       4.6818     213.5940     311.0000       0.0705       0.0367       3.7304      53.9907     360.5168      24.4842      45.4702       0.0831       0.1284       3.4891    2589.4575      46.5614     261.8750    1908.0000
  601.0656      39.1613      16.2656      38.8805       6.8174       8.3506     119.7517     311.0000       0.0693       0.0355       3.5759      62.5372     386.1937      69.8698      45.4702       0.1493       0.1989       3.8862    2591.4666      21.3238     261.8750    1871.0000
  601.2180      36.6299      20.8466      31.7650       9.4516      11.9124      83.9461     311.0000       0.0528       0.0184       2.6423      56.6556     416.2410      96.2141      45.4702       0.1740       0.2246       4.0475    2619.7136      17.0299     261.8750    1892.0000
  601.3704      34.6274      31.9604      24.0267      10.7059      10.4048      96.1092     311.0000       0.0229      -0.0127       3.0057      53.8761     364.3410      79.0350      45.4702       0.1239       0.1713       3.7868    2670.8911      21.7827     261.8750    1904.0000
  601.5228      29.6186      55.3485      25.2657      11.6582      11.6180      86.0733     311.0000       0.0235      -0.0120       3.2470      47.7337     368.7115      34.3215      45.4702       0.0470       0.0868       3.4342    2669.7441      67.6442     261.1875    1890.0000
  601.6752      28.3270      80.0701      24.2658      11.8293      11.3464      88.1336     311.0000       0.0365       0.0015       3.4270      52.7324     370.8969       5.8296      45.4702       0.0134       0.0490       3.2590    2647.5920     337.5520     259.6250    1903.0000
  601.8276      26.2774      74.9712      26.7498      11.5310      11.6872      85.5634     311.0000       0.0415       0.0067       3.3596      65.4061     371.9894      17.3938      45.4702       0.0325       0.0707       3.3442    2639.0215     166.0852     259.1875    1907.0000
  601.9800      24.6186      51.6269      23.3398      10.7917      11.8112      84.6652     311.0000       0.0297      -0.0056       3.5450      76.8758     372.5358      51.2633      45.4702       0.1128       0.1595       3.5590    2659.2434      65.3512     255.3750    1910.0000
  602.1324      22.6685      32.0769      18.6118       9.7051      10.3594      96.5310     311.0000       0.0004      -0.0359       3.4314      86.0312     380.7305      87.1761      45.4702       0.2037       0.2561       3.7557    2709.2605      35.4329     255.1250    1915.0000
  602.2848      25.0499      25.3539      17.5125       9.1753       9.7044     103.0458     311.0000      -0.0152      -0.0521       3.3537      80.8179     376.0868      93.4961      45.4702       0.2082       0.2605       3.8204    2735.9775      28.2915     252.6875    1885.0000
  602.4372      24.9574      25.2860      19.7803       9.8578      10.9074      91.6813     311.0000      -0.0047      -0.0413       3.3508      78.0605     377.9989      65.0702      45.4702       0.1668       0.2178       3.7354    2718.1025      27.8912     252.1250    1904.0000
  602.5896      25.0165      27.2110      22.7514      11.0636      12.8427      77.8654     311.0000       0.0159      -0.0199       3.5137      71.8726     385.3742      30.1354      45.4702       0.1334       0.1828       3.5789    2682.8582      29.7944     248.1875    1892.0000
  602.7420      25.3594      28.9455      25.5423      12.4668      14.3121      69.8710     311.0000       0.0320      -0.0032       3.2629      76.3263     388.3789       8.2333      45.4702       0.1321       0.1813       3.4696    2655.2478      29.3722     243.0000    1883.0000
  602.8944      26.2322      31.5610      28.1226      13.5975      15.8691      63.0156     311.0000       0.0293      -0.0060       3.1898      69.3556     392.2031       4.4425      45.4702       0.1548       0.2051       3.3728    2659.8860      27.0024     239.8750    1883.0000
  603.0468      27.1753      32.9458      29.5952      14.4796      16.9420      59.0248     311.0000       0.0248      -0.0106       3.4307      67.5027     393.2957       4.2961      45.4702       0.1294       0.1783       3.2921    2667.5591      32.1887     236.5625    1891.0000
  603.1992      27.7953      31.7731      29.3414      15.6787      17.0495      58.6528     311.0000       0.0287      -0.0067       3.4735      63.2398     397.6663       0.8271      45.4702       0.1276       0.1764       3.2679    2660.9915      37.1732     232.6875    1874.0000
  603.3516      28.2973      31.7730      30.1670      16.8188      18.4657      54.1544     311.0000       0.0284      -0.0070       2.9363      67.6198     405.3146      -1.6134      45.4702       0.1416       0.1911       3.2828    2661.4883      36.3718     231.8750    1891.0000
  603.5040      29.0907      29.9990      32.1614      17.6797      19.4704      51.3601     311.0000       0.0278      -0.0076       3.1186      68.0830     400.9441      -3.2315      45.4702       0.1398       0.1893       3.3149    2662.5164      30.9810     228.0625    1882.0000
  603.6564      29.3769      28.9290      33.6228      18.5823      20.6491      48.4282     311.0000       0.0209      -0.0148       3.4252      68.3068     401.4905      -0.7689      45.4702       0.1245       0.1732       3.2754    2674.3442      36.8242     227.6875    1910.0000
  603.8088      29.0414      28.3543      34.0328      19.5347      21.7778      45.9182     311.0000       0.0159      -0.0198       3.2763      67.9008     400.3978       3.1710      45.4702       0.1115       0.1592       3.2070    2682.7456      47.7040     222.9375    1919.0000
  603.9612      28.2181      28.0639      35.2473      20.7628      22.8654      43.7342     311.0000       0.0176      -0.0181       3.1399      67.6692     406.9536       4.0908      45.4702       0.1217       0.1699       3.1602    2679.9187      49.4652     222.8125    1899.0000
  604.1136      27.7063      24.7661      33.4001      20.4381      22.7471      43.9616     311.0000       0.0262      -0.0093       2.5672      70.2873     402.5831       1.1220      45.4702       0.1249       0.1731       3.1817    2665.2659      43.7535     219.4375    1886.0000
  604.2660      27.6788      23.7316      32.2315      20.4741      21.6288      46.2346     311.0000       0.0338      -0.0013       3.1700      70.9457     412.4167      -2.3658      45.4702       0.1225       0.1708       3.2436    2652.1929      46.7212     220.2500    1862.0000
  604.4184      27.7729      24.8683      35.9090      24.1068      24.5451      40.7414     311.0000       0.0306      -0.0047       3.5001      72.2714     406.9536      -1.6108      45.4702       0.1126       0.1604       3.2590    2657.7559      54.3314     216.1875    1882.0000
  604.5708      26.4315      25.3048      39.8052      28.8146      27.5367      36.3152     311.0000       0.0209      -0.0147       2.9994      68.5423     424.4357       1.1766      45.4702       0.1019       0.1486       3.2269    2674.2690      53.9729     215.3750    1893.0000
  604.7232      26.1895      25.9279      42.2937      31.6783      31.1362      32.1170     311.0000       0.0106      -0.0254       3.6076      63.9918     417.3336       3.4273      45.4702       0.1138       0.1613       3.1978    2691.8843      56.1126     214.0000    1877.0000
  604.8756      29.1092      26.1143      49.5887      38.5975      36.2132      27.6142     311.0000       0.0084      -0.0276       3.6381      65.2139     424.4357       3.7904      45.4702       0.1268       0.1754       3.2045    2695.5999      50.3935     215.3750    1862.0000
  605.0280      28.8730      26.3649      54.7953      44.9036      43.9355      22.7607     311.0000       0.0142      -0.0217       2.3466      67.3030     428.2599       7.6859      45.4702       0.1339       0.1831       3.2525    2685.7678      38.1102     213.0625    1908.0000
  605.1804      31.7873      25.0525      59.3908      52.6321      59.0716      16.9286     311.0000       0.0209      -0.0147       2.5510      70.3422     430.9915      24.8010      45.4702       0.1414       0.1910       3.3608    2674.2168      29.0847     213.0625    1905.0000
  605.3328      32.8489      21.6765      52.0279      48.5250      64.0288      15.6180     311.0000       0.0284      -0.0069       3.1569      67.0995     432.6304      41.5893      45.4702       0.1746       0.2258       3.5005    2661.3733      24.9538     211.1250    1884.0000
  605.4852      30.6149      19.6226      48.0089      47.3400      76.4988      13.0721     311.0000       0.0330      -0.0021       3.4539      64.2338     434.8157      46.9251      45.4702       0.1805       0.2321       3.5714    2653.5466      24.1404     211.8125    1886.0000
  605.6376      32.4276      19.4903      48.2757      50.9286      87.5190      11.4261     311.0000       0.0485       0.0139       3.9736      60.4566     439.1862      31.5666      45.4702       0.1159       0.1638       3.5183    2627.0901      35.4770     209.8750    1932.0000
  605.7900      32.2014      20.1867      49.8292      55.1183      89.6418      11.1555     311.0000       0.0504       0.0158       3.5503      59.8432     441.9178      34.4687      45.4702       0.0646       0.1074       3.4605    2623.8909      65.7542     209.7500    1918.0000
  605.9424      33.0787      21.4725      49.0761      55.1768      77.8574      12.8440     311.0000       0.0475       0.0129       2.6112      61.4991     450.6588      42.0136      45.4702       0.0633       0.1041       3.4228    2628.7773     108.2837     204.5000    1918.0000
  606.0948      29.7457      21.6838      47.9822      52.9289      60.0050      16.6653     311.0000       0.0396       0.0047       2.8093      63.4904     440.2788      40.9079      45.4702       0.0526       0.0920       3.3971    2642.3267     104.3699     207.0000    1919.0000
  606.2472      27.2074      20.8269      42.2472      46.7388      45.3951      22.0288     311.0000       0.0383       0.0033       2.7320      64.1039     438.6398      19.8543      45.4702       0.0397       0.0787       3.3804    2644.4993      63.9324     205.2500    1948.0000
  606.3996      26.0861      18.8204      36.7269      40.2391      36.0930      27.7062     311.0000       0.0367       0.0017       3.4827      64.9236     447.3809       1.7986      45.4702       0.0544       0.0961       3.4573    2647.2622      37.9519     206.2500    1975.0000
  606.5520      23.1763      17.2132      31.3726      34.8582      29.4559      33.9490     311.0000       0.0299      -0.0054       3.4051      70.5371     450.6588      -1.2267      45.4702       0.1404       0.1895       3.6025    2658.9189      26.1840     205.5625    1912.0000
  606.7044      28.6685      15.2028      26.8575      29.8041      25.4287      39.3256     311.0000       0.0191      -0.0165       3.0523      76.2548     455.0293      -1.2729      45.4702       0.1861       0.2378       3.6648    2677.2649      28.4678     203.2500    1867.0000
  606.8568      26.3751      16.2419      28.6150      31.3433      26.0137      38.4413     311.0000       0.0084      -0.0276       3.4493      73.5820     456.9414      -1.0612      45.4702       0.1787       0.2302       3.6431    2695.5947      29.7265     204.5625    1895.0000
  607.0092      28.9596      16.9276      31.6511      36.1017      31.6520      31.5936     311.0000       0.0036      -0.0326       3.8296      76.2912     467.0482      -0.8419      45.4702       0.1384       0.1879       3.5907    2703.8120      28.8550     204.6250    1906.0000
  607.1616      28.6161      18.4989      33.6621      40.3682      35.2872      28.3389     311.0000      -0.0013      -0.0377       3.3418      72.8898     469.2335       6.6819      45.4702       0.1130       0.1608       3.6041    2712.2795      27.4146     203.2500    1888.0000
  607.3140      28.2558      18.5035      34.8300      44.6261      41.3827      24.1647     311.0000      -0.0038      -0.0403       3.5999      78.4486     477.4282      11.6298      45.4702       0.1340       0.1831       3.6497    2716.4639      27.5045     202.2500    1888.0000
  607.4664      26.7929      18.6422      36.5417      51.5019      41.8640      23.8869     311.0000      -0.0081      -0.0447       3.5429      77.0277     483.7108      13.8373      45.4702       0.1409       0.1905       3.6679    2723.7698      28.9341     202.6875    1871.0000
  607.6188      27.0459      18.6578      39.5831      62.1233      46.8082      21.3638     311.0000      -0.0030      -0.0395       3.2815      80.5020     494.9103       6.1460      45.4702       0.1218       0.1704       3.6531    2715.1707      29.1108     203.2500    1923.0000
  607.7712      27.8203      18.8984      42.1014      78.2580      54.6567      18.2960     311.0000       0.0020      -0.0342       3.3734      74.7349     498.7345       1.2555      45.4702       0.1523       0.2025       3.6214    2706.5005      29.0027     202.9375    1936.0000
  607.9236      29.7650      19.1058      47.3239     101.4551      67.0357      14.9174     311.0000       0.0158      -0.0200       3.0415      67.4667     476.8819       0.1318      45.4702       0.1686       0.2196       3.6902    2683.0181      32.5130     203.1875    1976.0000
  608.0760      32.0300      19.6354      53.9154     139.4475      90.0040      11.1106     311.0000       0.0236      -0.0119       3.3466      62.2784     472.5114      19.8431      45.4702       0.1399       0.1896       3.9377    2669.6243      41.2238     202.0625    1944.0000
  608.2284      34.8172      20.7855      60.9412     200.2738     128.9392       7.7556     311.0000       0.0187      -0.0170       3.6737      62.2551     472.5114      56.2279      45.4702       0.1600       0.2106       4.2874    2678.1045      37.8083     203.2500    1906.0000
  608.3808      36.8126      21.2532      71.8832     305.3626     196.8504       5.0800     311.0000       0.0021      -0.0342       2.6736      64.8083     470.3261      91.4235      45.4702       0.1375       0.1863       4.6182    2706.4570      48.1787     203.2500    1990.0000
  608.5332      39.5610      21.7977      81.0167     437.1540     287.2997       3.4807     311.0000      -0.0132      -0.0501       1.5627      60.7561     463.2240     101.8913      45.4702       0.1090       0.1541       4.7298    2732.5999      69.7555     203.2500    1955.0000
  608.6856      32.3496      23.5056      86.6112     550.1966     350.1265       2.8561     311.0000      -0.0119      -0.0487       2.9183      53.8075     461.0388      87.5671      45.4702       0.0202       0.0547       4.5850    2730.3154     758.2938     203.2500    1885.0000
  608.8380      31.7513      24.3925      83.6955     540.3843     326.3853       3.0639     311.0000       0.0084      -0.0277       3.9158      47.9360     459.9461      52.2020      45.4702      -0.0146       0.0141       4.2295    2695.6936     193.4925     203.2500    1906.0000
  608.9904      29.4122      25.0728      78.1644     454.2170     253.1171       3.9507     311.0000       0.0323      -0.0029       4.3691      49.1101     471.9651      22.3958      45.4702      -0.0020       0.0272       3.7659    2654.8262     103.2456     203.2500    1910.0000
  609.1428      29.0268      23.7834      75.0008     349.9298     202.0850       4.9484     311.0000       0.0551       0.0207       3.3861      55.1322     474.1504       1.9000      45.4702       0.0323       0.0665       3.4054    2615.7639      74.2414     203.2500    1914.0000
  609.2952      28.8973      24.5553      66.1893     272.0189     164.1263       6.0929     311.0000       0.0608       0.0267       3.2621      58.3740     468.4140       3.1540      45.4702       0.0618       0.1010       3.2098    2606.0010      49.6233     202.8750    1911.0000
  609.4476      27.1447      22.6118      57.3368     211.7035     131.4116       7.6097     311.0000       0.0708       0.0370       2.6147      61.3915     476.3356       1.4460      45.4702       0.0832       0.1262       3.1971    2588.8823      33.4711     199.6875    1939.0000
  609.6000      25.6475      20.0141      49.2558     170.5307     114.9584       8.6988     311.0000       0.0726       0.0388       2.7888      65.7858     480.1598       0.2441      45.4702       0.0888       0.1327       3.1921    2585.9082      29.7473     199.9375    1924.0000
  609.7524      25.2981      20.8769      49.3957     195.0687     138.0951       7.2414     311.0000       0.0766       0.0430       2.4982      64.8935     494.3640      -1.5934      45.4702       0.0823       0.1262       3.1902    2579.0576      34.6025     199.6875    2008.0000
  609.9048      26.4558      23.5791      60.0259     251.6290     194.7007       5.1361     311.0000       0.0688       0.0350       3.0702      64.4293     468.1408      21.4436      45.4702       0.0724       0.1150       3.2582    2592.2715      40.1619     196.8750    2107.0000
  610.0572      28.1915      27.5039      69.6388     292.9554     266.1941       3.7567     311.0000       0.0630       0.0290       3.1615      59.3639     489.9934      63.5436      45.4702       0.0568       0.0975       3.4852    2602.2285      41.8963     199.6875    2182.0000
  610.2096      28.4262      29.4410      73.5236     304.9109     347.1825       2.8803     311.0000       0.0580       0.0237       3.1627      61.9117     482.8914     111.5606      45.4702       0.0668       0.1077       3.7818    2610.8794      41.4327     200.6875    2080.0000
  610.3620      30.3408      28.5932      69.4970     268.9043     360.4818       2.7741     311.0000       0.0450       0.0102       3.0294      61.2623     495.4566     142.6401      45.4702       0.0533       0.0929       3.9579    2633.1050      38.5583     199.0000    2044.0000
  610.5144      30.4208      26.3729      60.6277     209.3348     280.5501       3.5644     311.0000       0.0356       0.0006       2.7794      55.9113     479.6135     133.9149      45.4702       0.0535       0.0933       3.9009    2649.0601      32.8064     200.0000    2007.0000
  610.6668      28.8314      25.4691      55.4134     163.6246     195.7337       5.1090     311.0000       0.0307      -0.0046       2.7068      49.8267     479.0672      94.0931      45.4702       0.0712       0.1126       3.6307    2657.5637      36.3803     199.5000    1940.0000
  610.8192      29.8340      24.5561      48.8674     131.1287     138.7606       7.2067     311.0000       0.0451       0.0104       3.2392      43.4819     482.3451      40.8857      45.4702       0.0753       0.1175       3.3654    2632.8481      58.2185     197.9375    1895.0000
  610.9716      28.7521      23.9097      46.7272     113.9301      98.1690      10.1865     311.0000       0.0540       0.0196       3.2660      48.8690     482.3451       9.2223      45.4702       0.0566       0.0967       3.2135    2617.6826      79.8721     197.1875    1923.0000
  611.1240      28.3708      24.7573      47.1817     113.6987      78.9980      12.6585     311.0000       0.0441       0.0094       2.8925      50.0562     482.8914      15.3975      45.4702       0.0405       0.0788       3.2189    2634.5203      83.9327     198.9375    1931.0000
  611.2764      30.5559      28.3403      52.5295     120.5342      70.5425      14.1759     311.0000       0.0432       0.0084       3.0935      52.6403     467.0482      16.4404      45.4702       0.0526       0.0918       3.2167    2636.0742      81.9039     197.1875    1894.0000
  611.4288      30.3137      29.9834      56.3985     119.1677      66.2645      15.0910     311.0000       0.0420       0.0072       2.6910      49.3377     469.2335      15.3072      45.4702       0.0506       0.0899       3.1806    2638.1223      74.4973     196.5000    1902.0000
  611.5812      33.1124      35.8068      59.9954     107.7046      62.2583      16.0621     311.0000       0.0499       0.0153       2.5196      51.1612     466.5019       2.2488      45.4702       0.0624       0.1037       3.1477    2624.7109      73.4745     196.3750    1934.0000
  611.7336      30.3252      28.5143      52.2270      90.2916      51.4968      19.4187     311.0000       0.0481       0.0135       3.3325      54.4781     466.5019       1.2445      45.4702       0.0843       0.1278       3.2388    2627.7598      62.5643     197.2500    1931.0000
  611.8860      25.0525      23.5173      37.8820      61.7507      38.8745      25.7238     311.0000       0.0460       0.0113       3.6226      60.3152     462.6777       0.6955      45.4702       0.0735       0.1169       3.3338    2631.3831      40.4202     197.9375    1932.0000
  612.0384      24.7662      22.7033      35.8111      61.5331      40.9955      24.3929     311.0000       0.0364       0.0014       3.2878      65.0104     462.1314       3.8514      45.4702       0.0990       0.1447       3.3264    2647.6995      35.5744     197.0625    1929.0000
  612.1908      29.1944      25.6819      43.1593      82.0345      61.4542      16.2723     311.0000       0.0297      -0.0056       3.2778      68.2522     456.6682       4.9856      45.4702       0.1155       0.1623       3.2171    2659.2649      31.5398     197.2500    1915.0000
  612.3432      28.9376      25.0693      45.5420      96.0865      75.8114      13.1906     311.0000       0.0322      -0.0030       2.3950      65.2347     469.5067       4.1089      45.4702       0.0917       0.1368       3.1563    2654.9119      34.7228     194.6250    1896.0000
  612.4956      28.1581      24.6894      43.0704     110.0002      90.6204      11.0350     311.0000       0.0454       0.0107       2.6909      59.7291     479.0672      -2.4683      45.4702       0.0708       0.1133       3.1473    2632.2852      34.3340     195.5000    1915.0000
  612.6480      30.2604      26.6257      46.6017     153.6064     126.7158       7.8917     311.0000       0.0471       0.0125       2.4612      56.8401     485.8961      -3.6659      45.4702       0.0648       0.1070       3.1483    2629.4370      36.5637     194.8750    1951.0000
  612.8004      33.5556      27.8884      52.7938     201.0973     171.0535       5.8461     311.0000       0.0397       0.0048       3.3691      56.3081     482.8914      -2.6960      45.4702       0.0767       0.1197       3.0918    2642.1409      38.7134     197.7500    2073.0000
  612.9528      33.4117      28.4468      55.0492     232.4413     206.8750       4.8338     311.0000       0.0343      -0.0008       2.3007      55.0967     489.9934      -0.3772      45.4702       0.0837       0.1275       3.0801    2651.3838      41.5581     200.7500    2085.0000
  613.1052      31.8447      26.9469      51.3690     218.9716     208.4965       4.7962     311.0000       0.0390       0.0040       1.6391      55.3908     482.8914      -0.2429      45.4702       0.0740       0.1170       3.1078    2643.3176      42.7696     199.0625    2054.0000
  613.2576      29.9777      25.8499      47.9340     173.9174     176.7095       5.6590     311.0000       0.0451       0.0104       2.2854      57.0408     488.6277      -0.0286      45.4702       0.0726       0.1150       3.1418    2632.8308      41.6686     199.0000    2145.0000
  613.4100      28.9992      25.2865      45.8625     135.7908     141.7226       7.0560     311.0000       0.0458       0.0111       2.8200      57.2698     489.1740      -0.0377      45.4702       0.0620       0.1034       3.1384    2631.6167      40.9515     197.6875    2045.0000
  613.5624      27.9384      25.0144      42.7166     108.0463     115.1864       8.6816     311.0000       0.0431       0.0083       3.5391      53.9646     476.8819      -1.4329      45.4702       0.0779       0.1205       3.0907    2636.2886      41.5256     198.8125    1972.0000
  613.7148      26.8113      24.5889      39.9687      89.3849      95.1669      10.5079     311.0000       0.0384       0.0034       3.4362      51.1852     486.1693      -2.3236      45.4702       0.0683       0.1102       3.0238    2644.3792      43.9492     197.1875    2045.0000
  613.8672      26.3635      24.8760      38.9906      86.8740      81.1803      12.3183     311.0000       0.0343      -0.0008       1.9643      54.2301     489.4472      -2.0623      45.4702       0.0727       0.1149       2.9474    2651.3369      40.8574     193.0625    2217.0000
  614.0196      26.5751      26.6964      39.5932      92.1872      79.7598      12.5376     311.0000       0.0279      -0.0074       1.9535      55.8514     492.7250       0.1457      45.4702       0.0648       0.1067       2.8752    2662.2661      39.9637     200.3750    2282.0000
  614.1720      27.1031      27.0394      42.4302      98.2878      77.7395      12.8635     311.0000       0.0377       0.0027       2.7895      57.7929     496.0030       0.9794      45.4702       0.0726       0.1153       2.9105    2645.5320      35.2848     202.2500    2181.0000
  614.3244      28.1705      27.2077      43.3953     111.1558      80.2888      12.4550     311.0000       0.0644       0.0303       2.8370      60.3095     517.3092       4.8079      45.4702       0.0664       0.1083       3.0793    2599.9502      32.1133     193.5000    2045.0000
  614.4768      30.2734      28.9372      46.6093     135.1923      91.2536      10.9585     311.0000       0.0850       0.0517       2.5733      56.8889     486.1693      32.9609      45.4702       0.0844       0.1285       3.3425    2564.7200      18.6834     196.8750    1943.0000
  614.6292      32.6909      30.8110      51.3689     171.9279     114.6437       8.7227     311.0000       0.0844       0.0511       2.2231      52.4308     494.3640      63.3895      45.4702       0.1063       0.1526       3.5436    2565.7375      15.5361     193.5000    1950.0000
  614.7816      33.5279      30.0499      51.5841     207.9425     144.7245       6.9097     311.0000       0.0659       0.0319       2.0353      50.0804     496.2761      77.0025      45.4702       0.1067       0.1531       3.5848    2597.3896      14.6771     187.1875    2048.0000
  614.9340      33.8543      28.7453      51.2861     224.1103     177.6785       5.6281     311.0000       0.0522       0.0177       2.9026      53.7327     498.7345      49.5672      45.4702       0.0745       0.1180       3.4275    2620.7502      22.4620     150.2500    2170.0000
  615.0864      31.0875      28.4774      50.4127     224.8590     223.1815       4.4807     311.0000       0.0469       0.0123       2.6761      54.4290     492.1787      19.5346      45.4702       0.0715       0.1143       3.2459    2629.7463      34.0388     150.5000    2175.0000
  615.2388      30.5743      28.5690      49.9231     211.9810     248.1822       4.0293     311.0000       0.0466       0.0120       2.7730      50.9846     495.4566       1.6885      45.4702       0.0776       0.1202       3.1139    2630.2361      34.4553     154.3750    2132.0000
  615.3912      28.8121      27.2358      46.3725     183.3963     238.2575       4.1971     311.0000       0.0458       0.0111       2.6184      52.1427     503.1050      -0.2725      45.4702       0.0717       0.1137       3.0793    2631.6958      28.7372     148.0000    2166.0000
  615.5436      29.3792      25.6470      43.2351     156.9069     209.1009       4.7824     311.0000       0.0370       0.0019       2.7779      55.4635     501.7392      -0.2878      45.4702       0.0572       0.0980       3.0121    2646.8088      29.8681     144.3750    2150.0000
  615.6960      28.6118      26.2555      43.9914     146.1965     179.4770       5.5717     311.0000       0.0369       0.0019       2.3859      61.7696     506.3829      -2.1574      45.4702       0.0655       0.1077       3.0085    2646.8438      32.7985     144.0625    2071.0000
  615.8484      28.0999      26.1502      43.2970     136.1823     156.1305       6.4049     311.0000       0.0412       0.0063       2.6728      59.7959     503.6513       4.6132      45.4702       0.0784       0.1212       3.0137    2639.5325      32.9760     144.6875    2084.0000
  616.0008      29.4047      26.1559      43.6877     129.5725     139.3900       7.1741     311.0000       0.0510       0.0165       3.1422      58.0637     504.7440      13.9737      45.4702       0.0603       0.1010       3.0925    2622.8206      33.6806     160.2500    2065.0000
  616.1532      29.6591      25.4799      41.5257     111.4064     115.1911       8.6812     311.0000       0.0498       0.0153       2.5110      54.8328     513.7582      15.1110      45.4702       0.0611       0.1014       3.1327    2624.8220      35.7565     153.8125    1974.0000
  616.3056      28.5424      25.9100      40.3670      95.4478      96.8028      10.3303     311.0000       0.0410       0.0061       0.9816      51.9425     496.5493       9.3908      45.4702       0.0722       0.1143       3.1089    2639.9204      36.2819     183.7500    1920.0000
  616.4580      31.8470      28.2584      43.8083     106.4675     102.5198       9.7542     311.0000       0.0380       0.0031       0.4398      53.5066     491.6324      -0.7648      45.4702       0.0706       0.1134       3.0663    2644.9431      35.3576     190.0000    1940.0000
  616.6104      32.0373      31.0090      48.1126     117.2042     107.4325       9.3082     311.0000       0.0436       0.0088       3.1438      51.8254     492.1787      -2.4385      45.4702       0.0899       0.1342       3.0286    2635.4683      37.8904     189.2500    1951.0000
  616.7628      33.1111      30.8215      46.4150     119.4780     101.4267       9.8593     311.0000       0.0488       0.0142       2.9434      54.1416     494.3640      -3.1450      45.4702       0.0725       0.1156       3.0338    2626.5142      40.7943     190.3125    1931.0000
  616.9152      34.6164      31.6140      46.6312     129.3886     102.6074       9.7459     311.0000       0.0547       0.0204       2.5705      50.7246     516.2166      -4.8141      45.4702       0.0730       0.1161       3.0432    2616.4131      36.9892     188.1875    1867.0000
  617.0676      33.2605      30.4329      46.9712     143.2471     105.0796       9.5166     311.0000       0.0537       0.0193       2.6929      50.1729     508.2950      -4.9813      45.4702       0.0879       0.1321       3.0325    2618.1836      34.2538     188.1875    1919.0000
  617.2200      35.1927      32.2886      50.1417     163.8232     115.2499       8.6768     311.0000       0.0583       0.0240       2.8448      54.1104     505.8366      -6.2764      45.4702       0.0725       0.1151       3.0583    2610.3542      29.5637     188.8750    2045.0000
  617.3724      36.3910      34.2752      52.7115     188.1694     142.1938       7.0327     311.0000       0.0630       0.0289       2.6510      56.4798     499.0077      -6.1321      45.4702       0.0781       0.1213       3.0989    2602.2659      31.0217     186.9375    2065.0000
  617.5248      36.9339      34.3599      53.4581     194.9831     156.8800       6.3743     311.0000       0.0645       0.0305       2.4328      55.9087     518.9481      -2.2807      45.4702       0.0876       0.1320       3.1143    2599.6267      33.2876     188.9375    2093.0000
  617.6772      36.0259      30.8059      50.0106     187.6933     170.3762       5.8694     311.0000       0.0634       0.0293       2.4874      51.7395     530.4208      -0.8371      45.4702       0.0887       0.1335       3.1540    2601.6245      28.2569     189.7500    2003.0000
  617.8296      34.5516      27.0286      42.9405     157.2824     146.4724       6.8272     311.0000       0.0547       0.0203       2.7282      55.7918     512.3924       3.6237      45.4702       0.0980       0.1437       3.1625    2616.5371      22.2163     192.7500    1977.0000
  617.9820      35.2199      26.6231      42.7405     145.2178     147.1761       6.7946     311.0000       0.0426       0.0078       2.4200      55.7918     505.5634       6.2356      45.4702       0.0923       0.1375       3.1669    2637.1992      18.6852     192.0000    1982.0000
  618.1344      35.9412      30.0734      46.5900     144.9513     158.5554       6.3069     311.0000       0.0292      -0.0061       2.6517      57.0027     514.0313       9.0687      45.4702       0.0810       0.1251       3.0955    2660.1292      23.0836     189.6875    1920.0000
  618.2868      35.2169      31.3064      48.2008     132.9578     146.8427       6.8100     311.0000       0.0230      -0.0125       3.0316      57.9928     518.6750       6.5711      45.4702       0.0778       0.1214       3.0410    2670.6589      28.9445     188.6875    1911.0000
  618.4392      35.6742      35.6853      51.6243     123.9795     123.3772       8.1052     311.0000       0.0195      -0.0161       2.2732      57.2965     515.6703       3.9558      45.4702       0.0760       0.1193       3.0151    2676.6313      37.0638     190.7500    1975.0000
  618.5916      35.8376      29.5310      44.8649     103.3302     104.4401       9.5749     311.0000       0.0234      -0.0122       2.2440      57.7017     503.3782      -2.8265      45.4702       0.0862       0.1303       3.0208    2670.0710      34.9788     191.3750    1901.0000
  618.7440      36.6621      26.5510      38.8827      79.2833      71.7118      13.9447     311.0000       0.0251      -0.0103       2.4171      52.6593     506.9292      -2.8007      45.4702       0.0942       0.1389       2.9754    2667.0295      30.7008     192.7500    1891.0000
  618.8964      38.6468      25.0928      35.6989      70.6063      59.0696      16.9292     311.0000       0.0335      -0.0016       2.6557      55.1734     502.0124      -4.6549      45.4702       0.0808       0.1248       2.9361    2652.6887      28.9135     193.5000    1906.0000
  619.0488      35.7525      30.0133      43.9647      90.8671      64.9340      15.4002     311.0000       0.0464       0.0118       2.9501      57.6457     505.2903       2.8412      45.4702       0.0822       0.1264       2.9182    2630.5769      25.9517     190.7500    1864.0000
  619.2012      37.1343      33.5633      48.6314      98.6836      70.7263      14.1390     311.0000       0.0921       0.0591       1.9042      62.9197     509.6608       3.4204      45.4702       0.0795       0.1240       3.1401    2552.5469      24.0592     190.4375    1893.0000
  619.3536      39.5813      38.0678      58.8688     114.5287      82.3242      12.1471     311.0000       0.1690       0.1388       0.0000      64.5411     524.1382      13.1524      45.4702       0.1033       0.1495       3.6468    2420.9663      10.8449     193.5000    1941.0000
  619.5060      41.7765      36.2787      54.4116     113.8880      72.7088      13.7535     311.0000       0.2147       0.1861       1.8849      59.2633     533.6987      64.1587      45.4702       0.0991       0.1453       4.3614    2342.8723       6.5995     190.1250    1917.0000
  619.6584      41.4598      34.7186      54.2522     132.4785      76.6756      13.0420     311.0000       0.1995       0.1704       2.8183      52.5463     525.5040     136.7013      45.4702       0.1166       0.1634       4.8681    2368.8450       5.4283     191.0625    1867.0000
  619.8108      40.6570      33.9928      55.9173     152.4801      78.1935      12.7888     311.0000       0.1460       0.1149       2.9708      53.7382     540.2545     182.2915      45.4702       0.0945       0.1397       4.9640    2460.4063       6.7070     191.3750    1918.0000
  619.9632      39.6426      33.0929      57.1249     197.5666      92.7124      10.7860     311.0000       0.0881       0.0549       2.4483      60.2548     534.2449     179.3764      45.4702       0.0856       0.1300       4.6658    2559.4326       8.4690     192.0625    1933.0000
  620.1156      39.5590      33.5552      60.7306     273.8625     123.1418       8.1207     311.0000       0.0538       0.0194       2.7765      65.1188     534.2449     134.1302      45.4702       0.0932       0.1383       4.2146    2618.0652      10.4598     191.5000    1940.0000
  620.2680      39.0015      33.8046      67.2163     384.7883     161.9830       6.1735     311.0000       0.0277      -0.0076       1.9625      63.2919     538.0692      84.6877      45.4702       0.0797       0.1237       3.7480    2662.5835      15.4116     191.6875    1949.0000
  620.4204      39.1309      35.3772      67.7168     499.4129     215.1535       4.6478     311.0000       0.0347      -0.0004       3.1475      61.2411     544.8981      32.5010      45.4702       0.0903       0.1352       3.3900    2650.6943      30.7126     192.1875    1931.0000
  620.5728      38.5137      33.9851      71.5262     494.6113     270.5993       3.6955     311.0000       0.0470       0.0123       2.9824      57.9985     511.2997       3.4199      45.4702       0.0916       0.1367       3.2019    2629.6411      39.0309     191.6250    1946.0000
  620.7252      42.4776      33.6026      68.9041     366.5007     269.8289       3.7061     311.0000       0.0538       0.0194       3.0612      57.9624     529.6013      -1.7014      45.4702       0.0844       0.1286       3.1479    2617.9565      36.3955     188.3125    1946.0000
  620.8776      42.2902      34.4606      63.8422     248.0167     222.2478       4.4995     311.0000       0.0573       0.0230       2.6274      58.9022     529.8745      -1.8637      45.4702       0.0773       0.1206       3.1691    2612.0361      37.0598     187.9375    1898.0000
  621.0300      34.4547      28.2477      55.5019     179.8073     169.5423       5.8982     311.0000       0.0507       0.0162       0.5771      61.6816     537.5229      -0.9627      45.4702       0.0684       0.1108       3.1512    2623.3130      36.8430     191.6875    1884.0000
  621.1824      33.3052      24.8790      43.1091     123.3621     121.1940       8.2512     311.0000       0.0360       0.0010       1.4942      65.1260     545.7176       0.6359      45.4702       0.0900       0.1342       3.0916    2648.4253      40.4200     193.5000    1866.0000
  621.3348      28.2218      20.6492      35.0020      89.0802      84.7469      11.7998     311.0000       0.0283      -0.0070       3.0455      62.7285     544.8981       1.4811      45.4702       0.0793       0.1228       3.0608    2661.5686      40.4240     193.5000    1909.0000
  621.4872      27.2666      26.3354      44.5913     114.5781     101.9241       9.8112     311.0000       0.0400       0.0051       3.2072      57.8978     516.2166       2.7828      45.4702       0.0581       0.0999       3.1677    2641.5413      36.2901     193.5000    1939.0000
  621.6396      25.8517      32.1864      49.5002     130.4956     102.5794       9.7485     311.0000       0.0703       0.0365       1.9385      53.9663     521.9529       4.2777      45.4702       0.0743       0.1178       3.4077    2589.7378      31.9408     191.1250    1914.0000
  621.7920      30.5945      33.6426      62.1060     151.9444     108.2864       9.2348     311.0000       0.0841       0.0508       2.1726      56.6003     518.9481      16.0284      45.4702       0.0994       0.1452       3.6295    2566.1067      16.0394     192.0000    1917.0000
  621.9444      31.5546      30.6425      53.6708     155.6833     100.6444       9.9360     311.0000       0.0711       0.0374       2.7228      62.1710     525.7771      27.8270      45.4702       0.1322       0.1803       3.6948    2588.3469      15.8292     193.1250    1975.0000
  622.0968      36.7208      26.9563      42.1697     125.4605      66.3922      15.0620     311.0000       0.0521       0.0176       2.6511      62.2528     506.3829      24.7447      45.4702       0.1194       0.1665       3.6047    2620.9106      17.4395     192.0000    1956.0000
  622.2492      37.1376      31.3470      57.3584     201.9522      95.7717      10.4415     311.0000       0.0414       0.0065       3.1151      59.1898     502.0124      11.2810      45.4702       0.0873       0.1316       3.4449    2639.2246      45.9299     187.9375    1947.0000
  622.4016      42.8746      37.4578      65.2678     257.6438     128.5356       7.7799     311.0000       0.0489       0.0144       2.3377      57.7576     491.0861      -3.1328      45.4702       0.0578       0.0991       3.2953    2626.3093      85.9899     188.7500    1929.0000
  622.5540      36.2345      37.4738      68.5282     330.3381     156.0219       6.4094     311.0000       0.0567       0.0224       2.4406      56.9809     505.8366      -3.6209      45.4702       0.0520       0.0921       3.1969    2613.0515      83.8897     190.9375    1912.0000
  622.7064      37.8374      36.0428      69.7486     411.7677     179.6301       5.5670     311.0000       0.0681       0.0343       2.4476      55.4168     499.2808      -1.9758      45.4702       0.0610       0.1018       3.1541    2593.4653      56.5602     191.7500    1898.0000
  622.8588      36.1773      34.3070      62.6354     410.0825     183.8291       5.4398     311.0000       0.0759       0.0423       2.8409      56.1091     498.7345       0.0913      45.4702       0.0704       0.1117       3.1730    2580.1697      39.1358     193.5000    1884.0000
  623.0112      34.2048      31.8561      60.2095     453.2445     148.6854       6.7256     311.0000       0.0736       0.0399       2.1525      54.2822     500.3735       2.4667      45.4702       0.0615       0.1024       3.2086    2584.1011      37.0919     191.7500    1868.0000
  623.1636      32.8396      31.3767      60.2439     508.1455     140.1206       7.1367     311.0000       0.0695       0.0356       2.2741      54.6881     497.6419       2.5847      45.4702       0.0540       0.0937       3.2688    2591.2222      43.1460     193.3750    1883.0000
  623.3160      31.1895      31.5813      61.3625     549.9213     155.0040       6.4514     311.0000       0.0686       0.0347       2.4669      51.1540     491.0861       0.6492      45.4702       0.0478       0.0867       3.3386    2592.6658      53.0913     192.0625    1902.0000
  623.4684      30.4486      31.5031      64.5621     580.7736     191.0303       5.2348     311.0000       0.0730       0.0393       2.2657      51.8228     503.6513      -1.2691      45.4702       0.0489       0.0872       3.3871    2585.0884      50.7723     190.3750    1935.0000
  623.6208      33.7049      34.8315      74.4650     740.0830     268.4770       3.7247     311.0000       0.0689       0.0351       2.6392      51.7891     504.4708       9.6133      45.4702       0.0522       0.0907       3.5056    2592.1216      54.2907     193.5000    1909.0000
  623.7732      36.4847      38.2752      89.0676     918.4670     391.4950       2.5543     311.0000       0.0481       0.0134       2.3565      52.8136     487.8082      35.9406      45.4702       0.0441       0.0821       3.8518    2627.8091      50.6890     193.5000    1896.0000
  623.9256      42.0350      40.9418     107.3182    1176.8247     604.4922       1.6543     311.0000       0.0368       0.0018       2.4915      51.7092     486.7156      65.0816      45.4702       0.0573       0.0963       4.4325    2647.0535      59.4674     192.6875    1929.0000
  624.0780      44.4213      42.1367     117.6546    1467.2844     878.0410       1.1389     311.0000       0.0135      -0.0224       0.5892      52.4378     475.2430     104.3885      45.4702       0.0626       0.1011       5.0470    2686.9331      65.2775     193.5000    1899.0000
  624.2304      46.6881      40.1448     119.6404    1695.3069     993.5563       1.0065     311.0000       0.0097      -0.0263       1.8627      54.9911     470.8725     129.8912      45.4702       0.0324       0.0662       5.4663    2693.4270      79.7438     193.5000    1869.0000
  624.3828      43.1449      41.2732     123.9849    1822.2988     844.7622       1.1838     311.0000      -0.0127      -0.0496       3.1617      52.9649     469.5067     158.9496      45.4702      -0.0070       0.0207       5.6749    2731.7954     105.1632     193.5000    1929.0000
  624.5352      40.8250      40.2729     112.8398    1801.0637     598.8544       1.6699     311.0000      -0.0148      -0.0517       2.4682      49.2590     470.8725     173.2492      45.4702      -0.0193       0.0058       5.7522    2735.3174     196.3058     192.2500    1946.0000
  624.6876      41.3865      47.5124     108.9321    1558.6688     399.1343       2.5054     311.0000      -0.0130      -0.0498       2.7214      45.6497     470.5993     184.7222      45.4702      -0.0086       0.0176       5.7460    2732.1929     168.0274     193.5000    1888.0000
  624.8400      41.3194      48.5426     119.0086    1183.1025     306.2321       3.2655     311.0000      -0.0066      -0.0433       2.7142      50.6734     472.5114     198.9140      45.4702       0.0147       0.0445       5.6587    2721.3706      71.8525     193.5625    1835.0000
  624.9924      42.2449      58.4280     127.3103     801.2001     231.7688       4.3146     311.0000      -0.0027      -0.0391       2.2112      52.8402     479.3403     204.8845      45.4702       0.0184       0.0507       5.4284    2714.5874      39.4985     194.6250    1907.0000
  625.1448      42.2276      54.9775     120.0739     527.2635     165.0035       6.0605     311.0000      -0.0176      -0.0546       2.4151      55.4794     470.8725     205.3428      45.4702       0.0471       0.0848       5.0354    2740.0183      27.3607     197.1875    2111.0000
  625.2972      39.7007      51.3023      97.2062     327.6447     160.5580       6.2283     311.0000      -0.0201      -0.0572       2.3085      55.3534     471.4188     172.7598      45.4702       0.0732       0.1155       4.5764    2744.3369      28.8348     199.0625    2124.0000
  625.4496      41.2565      44.5785      77.4578     217.6538     149.8230       6.6745     311.0000      -0.0231      -0.0603       2.5632      67.7786     468.1408     118.8679      45.4702       0.1115       0.1585       4.1604    2749.5193      29.2204     202.9375    2161.0000
  625.6020      33.9270      32.2208      57.8746     162.1109     138.6262       7.2136     311.0000      -0.0138      -0.0507       2.3143      75.4220     492.7250      67.4787      45.4702       0.1438       0.1933       3.9370    2733.6436      38.7764     199.7500    2084.0000
  625.7544      31.2809      23.4378      40.0565      93.8185      99.3828      10.0621     311.0000      -0.0062      -0.0428       1.9149      80.9028     477.4282      44.6413      45.4702       0.1612       0.2119       3.8527    2720.6094      36.6326     199.3125    2014.0000
  625.9068      31.2248      25.9194      41.3184      94.5991     114.6163       8.7248     311.0000      -0.0004      -0.0367       2.4483      73.4910     461.0388      51.8558      45.4702       0.1513       0.2015       3.8069    2710.6055      42.4257     198.0000    1990.0000
  626.0592      32.3623      31.8411      48.8615      99.8587     122.9650       8.1324     311.0000      -0.0064      -0.0429       2.8634      66.4877     447.3809      68.3429      45.4702       0.1090       0.1566       3.7016    2720.8613      44.5110     201.0625    1938.0000
  626.2116      31.1688      35.0094      56.0298     101.4750     113.0201       8.8480     311.0000      -0.0112      -0.0479       1.5433      68.2730     437.0009      68.2080      45.4702       0.1076       0.1550       3.5740    2729.0815      43.4122     201.3125    1969.0000
  626.3640      30.8056      32.0184      46.4969      81.6558      98.9809      10.1030     311.0000      -0.0100      -0.0468       2.1829      69.3817     443.0104      56.3226      45.4702       0.1271       0.1757       3.5014    2727.1807      32.9986     201.4375    2016.0000
  626.5164      28.3492      28.5908      40.3619      69.3585      73.4646      13.6120     311.0000      -0.0046      -0.0411       2.9856      68.7415     454.4830      35.3358      45.7498       0.1473       0.1972       3.4577    2717.7915      32.3221     201.4375    1942.0000
  626.6688      28.5213      29.3452      38.6961      63.3007      61.5471      16.2477     311.0000       0.0048      -0.0314       2.7682      64.1143     447.9272      23.9592      45.4702       0.1358       0.1850       3.4236    2701.8596      32.3487     203.2500    1904.0000
  626.8212      30.9744      29.4576      38.7683      59.1529      56.3920      17.7330     311.0000       0.0185      -0.0172       1.9809      63.0056     452.8441      14.9097      45.4702       0.1247       0.1733       3.3802    2678.3838      36.3337     203.2500    1899.0000
  626.9736      32.1151      30.1115      39.3587      59.9519      54.5676      18.3259     311.0000       0.0401       0.0052       1.8668      63.0004     440.2788      11.1620      45.4702       0.1364       0.1857       3.3923    2641.3547      34.8673     203.2500    1882.0000
  627.1260      31.4099      30.2242      42.0194      62.7780      57.1055      17.5115     311.0000       0.0359       0.0008       1.9199      63.9693     443.5567      32.8529      45.4702       0.1549       0.2053       3.4579    2648.6628      42.0220     203.2500    1892.0000
  627.2784      32.3855      32.2508      45.7055      73.6760      61.2190      16.3348     311.0000       0.0149      -0.0209       2.5183      59.7664     438.0936      64.7154      45.4702       0.1208       0.1693       3.5232    2684.4485      44.3293     203.6250    1932.0000
  627.4308      33.9609      32.5431      47.9985      81.7377      66.7527      14.9807     311.0000      -0.0077      -0.0444       2.1231      58.8451     434.2693      92.6876      45.4702       0.1208       0.1693       3.5476    2723.1882      44.6528     203.2500    1926.0000
  627.5832      34.1393      32.4637      50.4194      86.1631      68.3852      14.6230     311.0000       0.0007      -0.0356       1.8045      61.6305     437.0009      69.1733      45.7498       0.1454       0.1952       3.4780    2708.8120      37.0004     203.5625    1929.0000
  627.7356      31.5982      35.3271      49.8659      85.0090      67.3082      14.8570     311.0000       0.0163      -0.0194       2.4299      64.0619     426.6209      35.7969      45.7498       0.1236       0.1719       3.3728    2682.0483      39.3533     204.1250    1890.0000
  627.8880      31.3528      34.3729      48.7590      79.7232      70.8678      14.1108     311.0000       0.0293      -0.0060       2.6952      64.7567     425.8015       5.8637      45.7498       0.0967       0.1429       3.2641    2659.8718      40.3714     205.5000    1888.0000
  628.0404      29.9504      30.3620      41.5802      65.9640      67.3648      14.8446     311.0000       0.0229      -0.0127       2.1308      59.3417     420.0652       5.5573      45.7498       0.1074       0.1545       3.2216    2670.9106      36.1540     205.3125    1983.0000
  628.1928      31.0796      28.8089      38.2933      57.2816      62.4968      16.0008     311.0000       0.0224      -0.0131       1.1651      63.0178     426.0746       6.1255      45.7498       0.1392       0.1885       3.1944    2671.6443      33.2663     209.1250    2137.0000
  628.3452      30.6925      25.9444      33.7800      50.1710      60.0379      16.6561     311.0000       0.0298      -0.0055       2.4042      65.6756     426.0746       5.8825      45.7498       0.1619       0.2126       3.1865    2659.0583      31.6305     211.5625    2108.0000
  628.4976      30.6676      26.5205      34.8948      51.2663      60.3487      16.5704     311.0000       0.0370       0.0020       2.2351      69.8789     432.6304       5.6880      45.7498       0.1177       0.1659       3.1364    2646.7405      33.8069     212.6250    2071.0000
  628.6500      30.4856      28.1986      37.4773      51.9164      59.6927      16.7525     311.0000       0.0349      -0.0002       1.3335      67.0531     432.6304      14.4100      45.7498       0.1073       0.1546       3.1237    2650.3804      33.0547     209.4375    2025.0000
  628.8024      30.6673      29.6924      38.8218      53.0768      58.0569      17.2245     311.0000       0.0188      -0.0168       1.7974      68.1013     432.0841      27.3752      45.7498       0.1254       0.1739       3.1131    2677.7930      37.8123     207.1875    2047.0000
  628.9548      31.3726      32.6223      41.7780      55.8558      56.4324      17.7203     311.0000       0.0107      -0.0253       2.2971      63.9347     416.7873      25.8217      45.7498       0.1273       0.1760       3.1037    2691.6987      39.8595     209.4375    2107.0000
  629.1072      30.5759      32.7235      41.8148      54.1135      51.6354      19.3666     311.0000       0.0078      -0.0283       2.8380      59.7604     412.9631      15.2974      45.7498       0.1224       0.1708       3.1085    2696.7444      41.8392     204.5000    2044.0000
  629.2596      30.2786      32.9952      43.0227      58.5925      50.6271      19.7523     311.0000       0.0139      -0.0219       2.3778      54.6647     411.3241       0.5980      45.7498       0.1263       0.1750       3.1029    2686.1628      41.6004     203.8125    1974.0000
  629.4120      31.3073      34.6728      43.6597      59.7676      48.5721      20.5879     311.0000       0.0078      -0.0283       1.4586      51.4169     410.7778       1.1623      45.7498       0.1351       0.1844       3.0941    2696.7222      39.7123     204.3125    1918.0000
  629.5644      29.6384      33.1424      43.5701      62.3453      48.7755      20.5021     311.0000       0.0059      -0.0302       2.5097      54.3733     408.8657       1.8318      45.7498       0.1288       0.1777       3.0538    2699.9121      40.3272     204.6250    1882.0000
  629.7168      30.2411      35.0959      49.4790      75.4811      57.6267      17.3531     311.0000       0.0031      -0.0331       1.6884      53.6784     404.7683       4.1895      45.7498       0.1328       0.1819       3.0436    2704.6809      40.6725     203.2500    2041.0000
  629.8692      30.5250      39.0432      56.6687      92.0883      70.1529      14.2546     311.0000       0.0162      -0.0196       1.8587      59.4715     401.4905       2.1896      45.7498       0.1387       0.1882       3.1280    2682.3291      38.7580     206.5625    2183.0000
  630.0216      31.4520      33.2455      52.5031      98.6546      79.8798      12.5188     311.0000       0.0304      -0.0049       2.1741      61.2984     396.5736       2.3065      45.7498       0.1498       0.1999       3.2535    2658.0679      38.7147     208.7500    2065.0000
  630.1740      32.8350      31.2047      53.1347     108.7682      96.0617      10.4100     311.0000       0.0656       0.0316       2.0626      64.7727     408.5926       0.8965      45.7498       0.1514       0.2013       3.4848    2597.8884      37.1531     207.0625    2004.0000
  630.3264      33.3327      32.2482      55.6978     114.6204     115.1293       8.6859     311.0000       0.0621       0.0280       1.8506      57.5306     407.4999      35.0356      45.7498       0.1450       0.1943       3.6846    2603.7852      39.7725     204.5625    1949.0000
  630.4788      39.7662      33.6573      57.9606     121.9873     137.9908       7.2469     311.0000       0.0401       0.0052       2.1089      54.6409     394.3884      71.0683      45.7498       0.1050       0.1514       3.7793    2641.4673      42.3368     204.1875    1963.0000
  630.6312      40.2020      38.5558      67.2953     118.3189     140.6158       7.1116     311.0000       0.0030      -0.0333       2.3682      49.6279     390.0178      82.1688      45.7498       0.0468       0.0875       3.6087    2704.9075      47.6071     206.3750    1983.0000
  630.7836      33.3628      36.5108      58.4704      97.5962     123.3116       8.1095     311.0000      -0.0023      -0.0387       1.9635      53.3958     388.9252      48.3613      45.7498       0.0402       0.0800       3.3401    2713.8857      52.0665     206.6250    1992.0000
  630.9360      29.0167      34.4599      52.8485      81.8696      93.2316      10.7260     311.0000       0.0096      -0.0264       1.7490      50.5713     386.1937      10.6459      45.7498       0.0938       0.1379       3.1637    2693.5193      54.2841     208.2500    1918.0000
  631.0884      30.8533      37.3097      54.2822      79.8207      83.6014      11.9615     311.0000       0.0142      -0.0217       2.2258      53.0751     385.6473      -0.5238      45.7498       0.1062       0.1527       3.1100    2685.7244      54.1732     210.7500    1932.0000
  631.2408      31.6177      41.0503      60.1165      84.0999      83.7733      11.9370     311.0000       0.0221      -0.0135       2.6528      49.7126     385.1010      -0.2193      45.7498       0.1075       0.1546       3.1622    2672.2686      55.8464     210.3750    1922.0000
  631.3932      33.4084      40.5797      49.0068      66.7656      58.9502      16.9635     311.0000       0.0013      -0.0351       2.2446      52.0331     386.1937      22.3331      45.7498       0.1146       0.1624       3.2600    2707.8464      36.2816     212.8125    1950.0000
  631.5456      32.4128      32.1095      41.8347      68.1772      50.9198      19.6387     311.0000      -0.0269      -0.0643       1.7601      50.7764     389.7447      50.3521      45.7498       0.1507       0.2007       3.3852    2756.0681      31.6045     211.5625    1934.0000
  631.6980      40.0829      42.4569      58.8689      88.6750      70.0950      14.2663     311.0000      -0.0660      -0.1048       1.8065      49.7383     390.5641      74.2364      45.7498       0.1325       0.1813       3.4516    2822.9426      30.6677     211.5625    1923.0000
  631.8504      52.8024      52.8467      69.3558     110.1276      87.3886      11.4431     311.0000      -0.0643      -0.1030       2.2859      44.8743     390.5641      60.9608      45.7498       0.0919       0.1378       3.4176    2819.9937      50.7999     212.9375    1962.0000
  632.0028      52.6148      52.3749      83.6914     128.5903     106.6589       9.3757     311.0000      -0.0539      -0.0922       2.2836      41.8294     391.1105      39.5706      45.7498       0.0888       0.1339       3.3909    2802.1802      52.5636     213.0625    1946.0000
  632.1552      43.8499      48.7022      68.0046     112.5253      89.2906      11.1994     311.0000      -0.0530      -0.0912       1.4647      46.9250     392.7494      32.7964      45.7498       0.0991       0.1450       3.4161    2800.5454      53.2595     210.5000    1973.0000
  632.3076      40.1518      43.6755      62.7867     101.3643      79.2823      12.6132     311.0000      -0.0600      -0.0986       1.8362      49.9048     393.8420      37.8697      45.7498       0.1094       0.1560       3.4725    2812.6831      54.1576     207.6250    1927.0000
  632.4600      41.7679      44.7032      66.9636     108.1915      81.2762      12.3037     311.0000      -0.0541      -0.0924       2.2431      54.6309     394.3884      32.1219      45.7498       0.0871       0.1323       3.4756    2802.5342      57.1749     206.3750    1932.0000
  632.6124      41.8168      43.8312      67.7289     111.0979      82.2145      12.1633     311.0000      -0.0323      -0.0698       1.7587      56.2861     395.4810      15.2788      45.7498       0.1021       0.1485       3.4364    2765.2117      55.1192     209.3125    1941.0000
  632.7648      42.0636      42.5064      66.7334     102.1666      78.9946      12.6591     311.0000      -0.0207      -0.0578       2.1275      56.0524     397.6663       3.6671      45.7498       0.1166       0.1641       3.3802    2745.3650      50.7770     208.4375    2015.0000
  632.9172      44.5216      44.6676      68.8071     102.4314      80.0982      12.4847     311.0000      -0.0175      -0.0545       2.1826      56.7884     397.6663       3.2907      45.7498       0.1159       0.1633       3.3750    2739.8579      52.9294     207.5625    2079.0000
  633.0696      47.0976      45.6947      70.4342     111.1927      81.5363      12.2645     311.0000      -0.0172      -0.0542       2.0830      55.5964     398.2126       3.3665      45.7498       0.0980       0.1442       3.3368    2739.4248      59.7380     208.0000    2011.0000
  633.2220      42.4761      43.5043      72.5145     122.5212      86.2972      11.5879     311.0000      -0.0148      -0.0517       1.6307      58.8383     397.6663       2.1298      45.7498       0.0936       0.1391       3.3163    2735.2585      67.6912     206.7500    1936.0000
  633.3744      42.9472      45.1391      71.8212     123.7996      83.4246      11.9869     311.0000      -0.0236      -0.0608       2.1249      58.6061     399.3052       5.7464      45.7498       0.0917       0.1370       3.2907    2750.3518      63.1607     204.1250    1932.0000
  633.5268      41.5123      42.0362      69.3006     125.5085      82.7992      12.0774     311.0000      -0.0285      -0.0659       1.7144      57.7325     400.6710       8.1508      45.7498       0.0935       0.1392       3.3004    2758.7959      58.5648     203.2500    1900.0000
  633.6792      41.1117      41.7853      82.0390     161.1882     103.3665       9.6743     311.0000      -0.0296      -0.0671       2.6351      57.7667     402.0368       7.6499      45.7498       0.1206       0.1685       3.3090    2760.6570      53.3166     203.2500    1938.0000
  633.8316      41.9585      52.5297      91.1293     181.7612     122.9891       8.1308     311.0000      -0.0234      -0.0606       2.1584      59.3997     403.9489       2.6615      45.7498       0.1195       0.1672       3.3096    2749.9316      56.9506     203.2500    1957.0000
  633.9840      43.1722      45.0646      83.5072     196.5731     137.2830       7.2842     311.0000      -0.0144      -0.0513       0.5150      56.8343     404.2220      -3.4277      45.7498       0.1103       0.1576       3.3167    2734.6602      62.7267     202.4375    1931.0000
  634.1364      45.7121      40.1222      74.4680     179.4410     133.3439       7.4994     311.0000      -0.0090      -0.0457       1.8425      56.5975     404.7683      -5.4145      45.7498       0.1156       0.1630       3.3310    2725.3748      70.8541     198.5625    1902.0000
  634.2888      44.0121      40.9286      73.3347     178.6700     139.6923       7.1586     311.0000      -0.0057      -0.0423       2.3728      53.7657     404.7683      -5.0218      45.7498       0.1088       0.1559       3.3493    2719.7927      70.8544     200.5000    1893.0000
  634.4412      43.7136      41.4870      78.2247     196.0391     153.1834       6.5281     311.0000      -0.0059      -0.0425       2.3614      53.3219     404.2220      -3.0940      45.7498       0.0934       0.1393       3.3793    2720.0640      67.3454     198.0625    1944.0000
  634.5936      42.8790      43.6480      80.2914     202.9774     163.5789       6.1133     311.0000      -0.0050      -0.0416       2.1315      52.4006     405.8610      -3.1335      45.7498       0.1064       0.1533       3.4227    2718.6052      62.3440     198.9375    1967.0000
  634.7460      41.2287      44.7649      78.2095     191.6349     154.3512       6.4787     311.0000      -0.0080      -0.0446       1.7211      50.3160     406.4073      -3.0081      45.7498       0.1124       0.1596       3.4634    2723.6414      63.4272     199.3750    1923.0000
  634.8984      41.1966      44.9050      79.1436     176.8217     136.0097       7.3524     311.0000      -0.0061      -0.0427       2.5415      53.1579     407.4999      -4.4315      45.7498       0.0968       0.1427       3.4919    2720.4111      60.7678     197.2500    1947.0000
  635.0508      41.7925      46.5736      79.1204     159.0058     123.1438       8.1206     311.0000      -0.0100      -0.0467       2.4534      55.1306     408.0462      -2.3756      45.7498       0.0830       0.1275       3.4429    2727.1130      59.7926     193.5000    1931.0000
  635.2032      40.1477      42.7998      73.3481     135.0646     103.0388       9.7051     311.0000      -0.0126      -0.0494       1.9540      58.1416     411.3241       1.0629      45.7498       0.0850       0.1297       3.3585    2731.4785      54.0648     195.1250    1955.0000
  635.3556      38.9025      38.3405      63.7610     117.6282      88.4444      11.3065     311.0000      -0.0176      -0.0546       0.4721      59.7272     412.9631       4.4940      45.7498       0.1139       0.1611       3.2348    2740.0164      53.5906     193.5000    1934.0000
  635.5080      39.5985      38.3871      62.9378     115.7608      87.2466      11.4618     311.0000      -0.0120      -0.0488       2.4733      55.4731     411.8704       3.5286      45.7498       0.1284       0.1769       3.1917    2730.5461      52.3169     194.7500    1918.0000
  635.6604      39.8940      37.9936      61.5322     120.2786      86.6026      11.5470     311.0000      -0.0015      -0.0379       2.8833      55.9363     417.3336      11.7259      45.7498       0.1200       0.1681       3.1777    2712.5452      57.3111     193.5000    1893.0000
  635.8128      42.7145      41.1663      66.1516     133.0821      91.5671      10.9210     311.0000       0.0082      -0.0278       1.8958      51.9148     415.6946      16.5250      45.7498       0.1113       0.1587       3.2107    2695.9390      59.4373     193.5000    1926.0000
  635.9652      40.6982      41.5126      71.1127     158.0810     100.9458       9.9063     311.0000       0.0091      -0.0270       2.2284      55.3544     420.0652      16.9256      45.7498       0.1032       0.1498       3.1994    2694.4746      64.8714     193.5000    1947.0000
  636.1176      39.9622      45.7983      80.9364     184.7168     116.3135       8.5975     311.0000       0.0056      -0.0306       2.9894      58.2148     420.6115       9.2583      45.7498       0.0988       0.1448       3.1841    2700.4165      73.9201     193.6250    1890.0000
  636.2700      42.4405      57.7539      97.6242     196.4555     125.3412       7.9782     311.0000       0.0066      -0.0295       2.3658      59.6453     430.9915       8.1370      45.7498       0.0823       0.1271       3.2054    2698.6392      74.3255     193.5000    1898.0000
  636.4224      42.0588      43.0087      76.2347     188.2296     113.5133       8.8095     311.0000       0.0066      -0.0295       2.0441      63.6191     424.4357      22.8052      45.7498       0.1040       0.1502       3.2376    2698.7148      56.3708     193.1250    1915.0000
  636.5748      41.1273      34.3366      60.3693     136.8207      86.8700      11.5115     311.0000       0.0191      -0.0166       2.1195      64.2816     429.3525      22.7430      45.7498       0.1185       0.1660       3.2199    2677.3291      53.0971     193.1875    1938.0000
  636.7272      38.7232      36.8455      63.7962     143.2419      86.1796      11.6037     311.0000       0.0271      -0.0083       2.3668      64.2816     433.7231      26.4225      45.7498       0.1119       0.1588       3.1489    2663.6680      56.8849     193.5000    1915.0000
  636.8796      38.7724      38.6628      68.1286     160.4583     105.5145       9.4774     311.0000       0.0261      -0.0094       2.5661      60.2736     427.1672      40.2279      45.7498       0.0988       0.1452       3.1296    2665.4478      72.6515     194.7500    1916.0000
  637.0320      38.0941      39.2339      71.1467     169.4286     122.3043       8.1763     311.0000       0.0125      -0.0234       2.1261      59.2985     432.6304      67.3606      45.7498       0.1049       0.1518       3.1972    2688.6296      52.8891     196.3750    1929.0000
  637.1844      38.0647      38.9284      70.1639     164.5367     130.2331       7.6785     311.0000       0.0053      -0.0309       2.5272      60.4712     437.0009      65.6271      45.7498       0.1350       0.1841       3.2569    2700.9819      45.8141     195.3125    1955.0000
  637.3368      37.3550      37.0516      64.7876     143.0875     120.4106       8.3049     311.0000       0.0109      -0.0250       2.5146      60.5476     435.9083      38.2807      45.7498       0.1408       0.1903       3.2854    2691.2981      40.9126     195.2500    1935.0000
  637.4892      36.7521      34.7431      59.9073     136.4142     112.0112       8.9277     311.0000       0.0161      -0.0197       2.2377      58.6314     430.4451       9.2142      45.7498       0.1209       0.1688       3.3298    2682.4492      45.1376     195.1875    1956.0000
  637.6416      38.2444      35.0044      56.2203     122.4305      98.7775      10.1238     311.0000       0.0134      -0.0225       2.2430      55.1043     432.0841       3.5450      45.7498       0.0807       0.1250       3.3710    2687.1292      47.7017     198.1250    1991.0000
  637.7940      31.6992      30.4668      49.3814     111.2294      86.0716      11.6182     311.0000       0.0190      -0.0167       2.5035      54.4558     429.8988       2.7201      45.7498       0.0725       0.1157       3.3703    2677.4954      49.7182     195.9375    1959.0000
  637.9464      30.0494      28.0317      45.4979      88.8132      72.1008      13.8695     311.0000       0.0243      -0.0111       2.4778      50.8131     432.6304      -0.4158      45.7498       0.0906       0.1354       3.2379    2668.3643      43.3418     194.7500    1925.0000
  638.0988      32.5956      30.0613      48.4583      88.8614      77.3085      12.9352     311.0000       0.0262      -0.0092       2.0974      51.9400     433.1767      -3.1435      45.7498       0.0942       0.1398       3.1081    2665.2351      47.5406     195.3125    1914.0000
  638.2512      28.1732      32.6364      48.3284      78.3911      74.1768      13.4813     311.0000       0.0093      -0.0267       2.6437      53.0096     436.4546       9.0809      45.7498       0.0932       0.1387       3.0592    2694.1050      45.9709     193.5000    1935.0000
  638.4036      27.7601      48.9359      47.7654      69.3101      70.6217      14.1600     311.0000       0.0103      -0.0257       2.6900      55.4715     435.3620      36.5844      45.7498       0.0745       0.1186       3.2141    2692.4612      50.6117     195.3125    1975.0000
  638.5560      24.9827      26.1138      45.6097      73.9676      79.1649      12.6319     311.0000       0.0100      -0.0260       2.0942      58.2822     432.0841      76.0388      45.7498       0.0893       0.1344       3.4588    2692.8743      31.1378     194.6250    1935.0000
  638.7084      16.0083      12.9459      16.6700      22.3877      24.6185      40.6199     311.0000       0.0201      -0.0156       2.1049      60.8239     422.2504      86.7941      45.7498       0.1510       0.2007       3.6170    2675.6743      14.1394     196.1875    1898.0000
  638.8608      25.6890      16.8940      21.0116      31.1364      33.1019      30.2097     311.0000       0.0022      -0.0341       2.5974      59.7894     438.6398      73.5376      45.7498       0.1915       0.2432       3.5740    2706.2544      14.1315     196.6250    1942.0000
  639.0132      36.1323      36.0632      45.4546      66.5582      73.2552      13.6509     311.0000      -0.0149      -0.0518       2.6509      57.4732     423.8894      37.7960      45.7498       0.1056       0.1527       3.3935    2735.5354      22.7626     200.1250    1963.0000
  639.1656      39.1530      48.3561      69.6517      81.2420      85.8188      11.6525     311.0000      -0.0324      -0.0699       2.7340      54.6738     423.8894      15.8956      45.7498       0.0637       0.1068       3.2474    2765.3376      51.3206     194.3125    1968.0000
  639.3180      36.5058      53.6808      82.9821     114.9644     100.3085       9.9692     311.0000      -0.0343      -0.0719       2.4247      57.1839     424.4357       3.6867      45.7498       0.0865       0.1313       3.2173    2768.6243      52.0403     197.6875    1931.0000
  639.4704      37.9109      55.9989      81.0494     127.4289     122.9055       8.1363     311.0000      -0.0252      -0.0625       2.1005      56.6583     423.8894      -0.3009      45.7498       0.0998       0.1457       3.3082    2753.1470      55.1024     196.2500    1938.0000
  639.6228      39.2978      52.8028      76.4492     131.9825      97.6706      10.2385     311.0000      -0.0146      -0.0515       2.6862      51.3884     422.7967      -3.6926      45.7498       0.0951       0.1407       3.4099    2734.9778      57.2262     195.0000    1953.0000
  639.7752      40.5729      48.4635      71.0344     126.4534      78.1861      12.7900     311.0000      -0.0056      -0.0421       2.5261      49.0341     418.9725      -6.8870      45.7498       0.0965       0.1421       3.4567    2719.4946      59.7173     195.6875    1931.0000
  639.9276      41.6609      45.2818      64.6876     110.5269      67.1893      14.8833     311.0000      -0.0031      -0.0396       2.2961      53.0782     417.8799      -7.7238      45.7498       0.0951       0.1409       3.4178    2715.3086      55.7384     196.1250    1938.0000
  640.0800      40.6651      39.4475      60.2703     107.7045      69.6972      14.3478     311.0000      -0.0175      -0.0545       2.5605      55.1672     417.8799       4.6570      45.7498       0.0998       0.1456       3.3487    2739.8474      52.1540     195.0000    1943.0000
  640.2324      44.4286      39.6661      65.6795     128.4286      80.7262      12.3875     311.0000      -0.0255      -0.0628       2.6595      52.9717     416.2410      12.7466      45.7498       0.0922       0.1375       3.3142    2753.6187      56.8711     194.3125    1918.0000
  640.3848      46.0413      44.9320      79.0016     163.9596     106.2059       9.4157     311.0000      -0.0347      -0.0724       2.2390      49.2217     415.6946      24.9765      45.7498       0.0796       0.1231       3.3472    2769.4104      60.6467     193.5000    1925.0000
  640.5372      43.7552      42.9971      93.1984     195.3177     134.3998       7.4405     311.0000      -0.0257      -0.0630       2.2776      48.5158     415.6946      25.6512      45.7498       0.0893       0.1338       3.3968    2753.9419      75.8500     193.5000    1943.0000
  640.6896      44.8725      60.8355      98.5156     201.2545     150.8490       6.6291     311.0000      -0.0207      -0.0578       2.7211      48.0021     415.9678      31.9731      45.7498       0.0866       0.1309       3.4170    2745.3513      78.9190     195.4375    1916.0000
  640.8420      45.6814      53.1276     105.0822     196.7237     166.8139       5.9947     311.0000      -0.0096      -0.0463       2.5442      47.5055     404.2220      28.3735      45.7498       0.0825       0.1267       3.4087    2726.4463     101.1215     193.5000    1923.0000
  640.9944      44.0895      45.3412      81.3522     149.1995     130.1012       7.6863     311.0000       0.0018      -0.0345       2.3376      47.0176     422.7967      18.9795      45.7498       0.0762       0.1194       3.3751    2706.8965      79.2316     193.5000    1960.0000
  641.1468      43.7957      39.0584      62.2770      96.7328      86.0317      11.6236     311.0000      -0.0034      -0.0399       2.4854      47.7139     427.1672      15.1377      45.7498       0.0851       0.1289       3.3768    2715.8252      79.3766     193.5000    1943.0000
  641.2992      42.0788      42.1926      71.2533     119.8243     111.8450       8.9409     311.0000      -0.0176      -0.0546       2.6132      52.3740     406.4073      12.1865      45.7498       0.0853       0.1295       3.3458    2740.1228      71.6674     193.5000    1955.0000
  641.4516      40.7622      45.9749      72.2169     129.2507     121.5733       8.2255     311.0000      -0.0377      -0.0754       2.2551      57.0064     405.3146      17.0469      45.7498       0.0845       0.1290       3.3517    2774.4922      71.1195     193.5000    1917.0000
  641.6040      39.9806      51.4500      70.5978     124.3129     123.2951       8.1106     311.0000      -0.0403      -0.0781       2.2437      55.4320     404.2220      10.4778      45.7498       0.0854       0.1300       3.3363    2778.8484      65.6948     193.5000    1957.0000
  641.7564      41.6786      51.7749      77.0780     135.4957     122.2719       8.1785     311.0000      -0.0381      -0.0759       2.3794      52.1950     402.5831       8.1170      45.7498       0.0871       0.1320       3.3645    2775.2075      65.9268     193.0625    1936.0000
  641.9088      45.3360      50.7095      82.0312     147.5401     118.5849       8.4328     311.0000      -0.0367      -0.0744       2.6074      49.9074     400.1247       3.6409      45.7498       0.1051       0.1514       3.3490    2772.7981      65.8591     193.5000    1943.0000
  642.0612      41.8194      52.6959      78.5363     152.3924     116.4989       8.5838     311.0000      -0.0339      -0.0715       2.6042      56.3121     397.1199       1.9403      45.7498       0.1039       0.1503       3.3098    2767.9617      67.9744     193.5000    1952.0000
  642.2136      39.1569      47.7901      71.1463     145.6166     115.5154       8.6569     311.0000      -0.0284      -0.0658       2.6023      55.7318     397.1199      12.7428      45.7498       0.0900       0.1355       3.2725    2758.6208      63.3078     193.5000    1993.0000
  642.3660      46.2918      42.1177      65.9994     131.5322      99.0853      10.0923     311.0000      -0.0180      -0.0550       2.5908      56.8612     395.4810      15.6522      45.7498       0.1144       0.1617       3.2843    2740.8245      56.3379     193.5000    1960.0000
  642.5184      46.6014      45.6927      74.3063     136.8685     113.4084       8.8177     311.0000      -0.0129      -0.0497       2.4313      53.8502     397.1199      15.6062      45.7498       0.1162       0.1636       3.3097    2732.0200      57.7915     193.5000    1941.0000
  642.6708      51.1335      49.5197      71.6839     127.9703     112.9738       8.8516     311.0000      -0.0101      -0.0468       2.6195      51.4143     393.2957       3.5686      45.7498       0.0977       0.1437       3.3254    2727.2798      64.3881     193.5000    1969.0000
  642.8232      45.2674      49.1409      78.1566     122.7092     113.6970       8.7953     311.0000      -0.0083      -0.0450       3.0870      50.4878     391.6568      -1.3504      45.7498       0.0865       0.1317       3.3287    2724.2639      68.5046     193.5000    2060.0000
  642.9756      43.2388      45.7265      70.7560     102.6367     103.9291       9.6219     311.0000      -0.0072      -0.0438       2.8082      51.5600     391.6568      -0.6187      45.7498       0.0978       0.1436       3.3507    2722.2480      64.3552     194.0625    2043.0000
  643.1280      41.6660      43.4581      65.3322      94.1616      90.9668      10.9930     311.0000      -0.0122      -0.0490       2.5337      59.6719     390.0178       1.1611      45.7498       0.1079       0.1547       3.3283    2730.7861      59.9200     193.5625    1967.0000
  643.2804      41.5116      41.3777      61.2440      84.7246      80.4677      12.4273     311.0000      -0.0176      -0.0546       2.6790      62.4747     391.6568       3.1521      45.7498       0.1071       0.1539       3.3209    2740.0320      56.8346     194.1250    1958.0000
  643.4328      39.7382      39.7324      58.5052      81.2182      74.6494      13.3960     311.0000      -0.0265      -0.0638       2.7556      61.0215     392.2031       8.2166      45.7498       0.1065       0.1535       3.3028    2755.2805      55.7238     193.5000    1997.0000
  643.5852      37.7721      40.3554      56.6486      81.2354      71.2528      14.0345     311.0000      -0.0263      -0.0636       2.4183      61.3027     394.9347      10.2715      45.7498       0.1108       0.1581       3.2903    2755.0151      53.9181     193.7500    1943.0000
  643.7376      37.0587      38.3637      54.3155      82.2119      70.9936      14.0858     311.0000      -0.0252      -0.0625       2.6747      60.0870     393.2957       9.3808      45.7498       0.1286       0.1771       3.2387    2753.1750      46.6666     195.2500    1895.0000
  643.8900      35.6740      37.0932      54.1495      85.3546      73.1635      13.6680     311.0000      -0.0173      -0.0543       2.8999      66.4901     398.7589       5.1386      45.7498       0.1219       0.1701       3.1555    2739.6362      43.4567     194.7500    1925.0000
  644.0424      41.2860      39.3635      58.0819     100.3600      82.7709      12.0815     311.0000      -0.0144      -0.0513       2.5984      63.3748     393.2957       2.1200      45.7498       0.1387       0.1879       3.1267    2734.5996      41.8055     193.9375    1995.0000
  644.1948      48.8489      43.3175      65.1395     114.2449      97.4270      10.2641     311.0000      -0.0068      -0.0434       2.6103      58.0818     394.9347      -0.1435      45.7498       0.1322       0.1812       3.1634    2721.6099      53.0929     196.9375    2021.0000
  644.3472      53.3015      49.7319      74.9623     129.7664     113.7512       8.7911     311.0000      -0.0152      -0.0521       2.7439      52.1169     392.4763      15.8277      45.7498       0.1020       0.1488       3.2535    2736.0398      62.7985     196.2500    1938.0000
  644.4996      46.5891      45.9748      71.8795     126.6213     112.5940       8.8815     311.0000      -0.0196      -0.0566       2.6779      53.9029     392.2031      31.5752      45.7498       0.0919       0.1378       3.3415    2743.4314      69.2330     194.9375    1982.0000
  644.6520      42.4201      42.5326      63.8992     110.6209      99.4104      10.0593     311.0000      -0.0198      -0.0569       2.8568      58.1117     392.4763      34.9178      45.7498       0.1204       0.1682       3.3596    2743.8665      60.9918     193.7500    2013.0000
  644.8044      40.1818      40.8974      61.0193      97.7429      91.0979      10.9772     311.0000      -0.0068      -0.0434       2.8884      63.1440     393.2957      16.9137      45.7498       0.1132       0.1606       3.3630    2721.6069      56.3275     195.0000    1986.0000
  644.9568      39.9709      42.3122      61.1425      91.6859      86.8633      11.5123     311.0000       0.0015      -0.0348       2.9929      62.8024     395.2078      -1.3580      45.7498       0.1101       0.1576       3.3184    2707.3591      51.9207     196.9375    1898.0000
  645.1092      39.1691      42.4741      59.7678      89.1347      81.2575      12.3065     311.0000      -0.0010      -0.0374       2.7665      63.6840     394.9347      -4.4773      45.7498       0.1286       0.1771       3.3022    2711.7898      49.6497     196.8750    1893.0000
  645.2616      37.3866      42.4070      59.5688      88.3314      79.5262      12.5745     311.0000      -0.0121      -0.0489       2.7597      61.0876     393.8420      -0.0443      45.7498       0.1128       0.1603       3.2521    2730.7466      47.5506     197.6250    1987.0000
  645.4140      37.3249      41.9523      58.7324      87.5355      78.3770      12.7588     311.0000      -0.0263      -0.0636       2.8995      62.0141     393.8420       7.6737      45.7498       0.1254       0.1737       3.2274    2754.8879      45.5903     197.6875    1976.0000
  645.5664      40.1593      40.9827      59.5001      91.4384      82.1351      12.1751     311.0000      -0.0334      -0.0710       2.8360      56.5697     400.3978       9.2568      45.7498       0.1256       0.1739       3.1966    2767.1577      51.5581     198.0625    1922.0000
  645.7188      42.7124      42.0216      62.9533     102.0724      92.1620      10.8505     311.0000      -0.0366      -0.0743       2.6994      53.9308     397.1199       6.5310      45.7498       0.0944       0.1406       3.1518    2772.5190      61.8697     198.0625    1974.0000
  645.8712      41.0986      42.6560      66.0493     113.7237     106.6724       9.3745     311.0000      -0.0301      -0.0676       2.9317      56.2470     398.7589      -0.4418      45.7498       0.1030       0.1498       3.1276    2761.5212      65.8106     197.2500    1991.0000
  646.0236      43.1693      43.9643      69.0274     127.2869     123.0385       8.1275     311.0000      -0.0366      -0.0743       3.1406      57.8418     401.7636       1.2054      45.7498       0.1161       0.1637       3.1044    2772.6440      56.8019     195.9375    1926.0000
  646.1760      46.3915      44.0894      71.3851     135.0232     134.6741       7.4253     311.0000      -0.0365      -0.0742       2.7359      58.0252     398.2126       2.2857      45.7498       0.1300       0.1786       3.1241    2772.3557      53.3965     195.6250    1907.0000
  646.3284      49.7761      45.2935      74.9531     149.8115     142.8018       7.0027     311.0000      -0.0346      -0.0722       2.5619      49.0457     397.6663       3.7684      45.7498       0.1204       0.1683       3.1779    2769.1907      59.7295     196.8750    1934.0000
  646.4808      45.4285      46.8773      78.8948     161.9028     147.6097       6.7746     311.0000      -0.0262      -0.0635       3.0739      51.0476     397.3931       1.8394      45.7498       0.0914       0.1372       3.2617    2754.7903      68.0279     196.9375    1946.0000
  646.6332      41.5934      46.6859      74.0956     148.3738     128.1274       7.8047     311.0000      -0.0276      -0.0650       2.9910      49.2106     398.7589       1.6317      45.7498       0.0959       0.1421       3.3030    2757.2329      70.8764     195.8125    1914.0000
  646.7856      40.8838      44.1486      68.1430     133.8557     108.5251       9.2145     311.0000      -0.0359      -0.0736       2.5975      49.4432     400.1247       2.8379      45.7498       0.1128       0.1599       3.2854    2771.3765      64.3757     196.0000    1920.0000
  646.9380      45.8387      49.0409      80.3185     154.0838     123.3127       8.1095     311.0000      -0.0379      -0.0757       2.9157      50.6013     402.5831       2.6143      45.7498       0.1076       0.1544       3.2759    2774.8730      70.3427     195.6875    1952.0000
  647.0904      48.0330      57.3762      94.0405     165.2032     133.0186       7.5177     311.0000      -0.0370      -0.0747       3.0216      53.6758     403.1294       2.7671      45.7498       0.0944       0.1400       3.2758    2773.3120      72.1455     194.3125    1929.0000
  647.2428      47.9256      53.0281      84.2750     145.4410     119.7950       8.3476     311.0000      -0.0381      -0.0758       2.9960      57.2929     400.9441       2.6326      45.7498       0.0927       0.1382       3.2573    2775.1030      71.9175     194.0625    1909.0000
  647.3952      49.8632      49.9108      78.0399     129.7012     108.7371       9.1965     311.0000      -0.0449      -0.0829       2.7842      54.7798     399.8515       3.0272      45.7498       0.1041       0.1506       3.2116    2786.8337      69.5825     193.5000    1962.0000
  647.5476      48.6665      47.8689      75.2348     126.0198     104.2639       9.5910     311.0000      -0.0466      -0.0847       2.9447      50.8948     400.3978       2.0666      45.7498       0.1039       0.1503       3.1973    2789.7622      69.3293     193.5625    2016.0000
  647.7000      49.3816      45.6188      70.7500     122.6686      98.0128      10.2027     311.0000      -0.0390      -0.0768       2.8125      51.6675     400.9441       1.1125      45.7498       0.1082       0.1550       3.2462    2776.6924      70.6621     194.2500    1953.0000
  647.8524      47.7782      44.1525      66.4310     114.0683      90.8471      11.0075     311.0000      -0.0263      -0.0636       3.0438      51.1938     403.1294       0.2954      45.7498       0.0955       0.1414       3.3004    2754.9407      69.6666     194.1250    1918.0000
  648.0048      45.3850      46.3144      68.6163     109.9289      91.8058      10.8926     311.0000      -0.0116      -0.0484       3.0916      53.0488     402.5831      -1.8551      45.7498       0.0916       0.1373       3.3336    2729.8398      69.7209     193.5000    1950.0000
  648.1572      40.8733      47.9182      66.5178     101.8948      85.7035      11.6681     311.0000      -0.0056      -0.0421       2.8222      52.3103     400.1247      -2.4574      45.7498       0.1011       0.1474       3.2878    2719.5283      64.9874     195.9375    1943.0000
  648.3096      37.4857      43.6872      59.7816      88.5060      75.6623      13.2166     311.0000      -0.0031      -0.0395       2.7505      61.3010     394.9347      -1.6820      45.7498       0.1027       0.1492       3.2063    2715.2441      51.2503     195.4375    1901.0000
  648.4620      33.6844      39.8324      50.4431      71.7806      64.3847      15.5316     311.0000       0.0037      -0.0325       2.8422      70.3940     400.3978      -1.4207      45.7498       0.1008       0.1474       3.1619    2703.7046      40.3006     195.0000    1931.0000
  648.6144      34.2376      31.8631      43.6830      62.4033      54.7486      18.2653     311.0000       0.0091      -0.0270       2.9417      74.6595     409.1388      -1.9801      45.7498       0.1556       0.2056       3.1496    2694.4941      33.6702     194.6250    1963.0000
  648.7668      40.7105      33.7139      45.2076      68.4115      55.0475      18.1661     311.0000       0.0025      -0.0337       2.8945      68.4240     408.3194      -1.8494      45.7498       0.1326       0.1813       3.1321    2705.6797      36.0226     195.1250    1947.0000
  648.9192      46.0077      44.8796      68.2129     117.2223      99.9930      10.0007     311.0000      -0.0091      -0.0458       3.2196      61.7669     402.0368      -1.9226      45.7498       0.0986       0.1446       3.1304    2725.5095      50.6721     194.3125    1931.0000
  649.0716      50.5908      53.9233      86.2223     153.7686     128.3201       7.7930     311.0000      -0.0244      -0.0617       3.0029      56.6568     403.1294      17.9248      45.7498       0.0719       0.1147       3.1304    2751.7361      68.6679     193.6250    1967.0000
  649.2240      49.4868      53.8883      90.5092     197.2840     163.2339       6.1262     311.0000      -0.0288      -0.0662       3.1854      53.1825     402.0368      35.7103      45.7498       0.0616       0.1033       3.1734    2759.2842      78.1860     195.6875    1969.0000
  649.3764      60.4206      58.8292      99.6166     229.5255     186.8978       5.3505     311.0000      -0.0291      -0.0665       3.0796      47.2707     398.7589      41.7326      45.7498       0.0844       0.1282       3.2242    2759.8076      79.3486     196.8125    1927.0000
  649.5288      56.2142      51.9115      91.1367     221.9261     189.3780       5.2804     311.0000      -0.0227      -0.0598       2.5466      43.5152     397.6663      22.3725      45.7498       0.0758       0.1189       3.3064    2748.7493      89.0763     196.1875    1956.0000
  649.6812      52.1787      44.2563      75.7831     163.5889     127.0802       7.8690     311.0000      -0.0155      -0.0524       3.0587      44.2637     398.7589       3.5472      45.7498       0.0682       0.1106       3.3866    2736.4250      88.1331     197.1875    1975.0000
  649.8336      51.9820      49.1427      77.4372     132.9319     102.8831       9.7198     311.0000      -0.0180      -0.0550       3.2025      46.5217     400.9441      -0.6416      45.7498       0.0782       0.1214       3.3922    2740.7761      83.5479     195.3125    1968.0000
  649.9860      51.9264      56.1715      83.7278     119.9211     109.2033       9.1572     311.0000      -0.0241      -0.0613       2.9168      41.8570     402.0368       2.3482      45.7498       0.0733       0.1164       3.3551    2751.1626      83.2204     195.8750    1968.0000
  650.1384      44.6113      59.1945      78.3685     107.9613      91.4919      10.9299     311.0000      -0.0248      -0.0620       2.6424      46.1495     402.0368       3.6962      45.7498       0.0724       0.1152       3.3359    2752.3538      84.2954     197.1875    1998.0000
  650.2908      43.3812      50.7118      66.3788      91.3213      75.0317      13.3277     311.0000      -0.0201      -0.0572       2.6833      49.1594     397.6663       3.7649      45.7498       0.0671       0.1099       3.3546    2744.3655      72.4228     198.1250    1950.0000
  650.4432      39.0659      41.1796      53.0720      73.5768      58.2236      17.1752     311.0000      -0.0196      -0.0566       3.0415      61.7160     394.3884       8.0037      45.7498       0.1176       0.1644       3.3988    2743.4656      56.0573     199.9375    1973.0000
  650.5956      39.2487      33.7720      43.7115      60.3011      47.5308      21.0390     311.0000      -0.0281      -0.0655       2.9597      63.2993     410.2315      14.2441      45.7498       0.1113       0.1587       3.4268    2758.0435      50.3609     200.1875    1933.0000
  650.7480      38.3203      34.4272      45.7721      64.3029      51.1621      19.5457     311.0000      -0.0286      -0.0660       2.8828      65.5047     412.9631      13.2873      45.7498       0.1193       0.1672       3.4512    2758.9431      49.9927     199.8125    1967.0000
  650.9004      38.0681      39.7404      52.9952      76.9337      61.4771      16.2662     311.0000      -0.0256      -0.0629       2.9648      66.8388     403.4026       8.4171      45.7498       0.1237       0.1722       3.4316    2753.7793      49.3162     201.5625    1964.0000
  651.0528      37.8020      42.2202      54.7130      77.6732      68.0759      14.6895     311.0000      -0.0168      -0.0538       2.9157      69.5314     415.1483       3.7134      45.7498       0.1240       0.1725       3.3889    2738.7698      47.1452     198.7500    1943.0000
  651.2052      35.9408      37.2381      52.3308      74.3324      71.3815      14.0092     311.0000      -0.0070      -0.0436       2.5533      76.4436     409.6852       3.4797      45.7498       0.1445       0.1943       3.3760    2721.9470      39.0967     198.3125    1950.0000
  651.3576      33.2731      29.0676      42.8507      59.5354      68.0903      14.6864     311.0000      -0.0015      -0.0380       2.8220      81.9699     409.9583       2.5752      45.7498       0.1519       0.2021       3.3453    2712.6431      34.2500     199.0000    2012.0000
  651.5100      38.7624      24.8107      34.5112      45.0150      53.7314      18.6111     311.0000      -0.0007      -0.0371       3.4572      83.3076     410.7778      -0.6638      45.7498       0.1816       0.2332       3.3373    2711.2280      30.5623     198.6875    1965.0000
  651.6624      38.4053      32.2265      45.4811      64.0775      73.0540      13.6885     311.0000      -0.0177      -0.0547       3.2242      75.6458     411.8704      13.4196      45.7498       0.1473       0.1970       3.2951    2740.2224      40.7409     198.6875    1957.0000
  651.8148      46.8381      42.8298      62.9532     102.1108     104.7563       9.5460     311.0000      -0.0278      -0.0651       2.7549      59.1784     409.1388      14.7414      45.7498       0.0793       0.1238       3.3207    2757.4751      68.1973     200.7500    1952.0000
  651.9672      43.3580      50.1405      75.3430     132.3017     121.5149       8.2294     311.0000      -0.0423      -0.0802       2.6801      51.3033     411.3241      16.0480      45.7498       0.0588       0.1011       3.3106    2782.2715     118.4113     200.0000    1949.0000
  652.1196      44.1008      58.9697      85.2876     152.8731     126.7236       7.8912     311.0000      -0.0484      -0.0866       2.7245      48.2266     410.7778       2.9023      45.7498       0.0867       0.1312       3.3044    2792.8333     101.4804     199.6250    1976.0000
  652.2720      45.7248      62.8701      83.4500     148.2034     117.2682       8.5275     311.0000      -0.0584      -0.0968       2.5275      52.4949     405.3146       5.2018      45.7498       0.0984       0.1444       3.2878    2809.8020      89.4994     198.4375    1982.0000
  652.4244      43.3299      54.0138      74.6601     136.6378     100.6456       9.9359     311.0000      -0.0601      -0.0987       2.5619      54.9215     399.3052      10.0195      45.7498       0.1025       0.1489       3.3270    2812.7883      74.5694     199.3750    1969.0000
  652.5768      41.4606      46.8573      65.3643     110.3540      88.7044      11.2734     311.0000      -0.0549      -0.0932       2.8158      58.6072     408.5926      10.3464      45.7498       0.0962       0.1425       3.3580    2803.8184      62.1644     198.7500    1958.0000
  652.7292      48.4755      39.2978      58.0045      88.9832      79.0620      12.6483     311.0000      -0.0470      -0.0851       2.9741      60.8857     413.5093       7.0500      45.7498       0.1339       0.1826       3.4034    2790.3333      46.5910     198.7500    1981.0000
  652.8816      49.4930      38.8631      57.6110      77.2580      95.5816      10.4623     311.0000      -0.0496      -0.0877       2.6983      56.8638     417.8799       7.0822      45.7498       0.1568       0.2068       3.4313    2794.7510      43.5454     199.6250    2000.0000
  653.0340      64.8641      47.1381      76.0190     129.6967     131.9963       7.5760     311.0000      -0.0581      -0.0966       2.7854      51.7598     418.9725       7.9408      45.7498       0.1088       0.1557       3.4357    2809.3347      51.4527     197.6875    1940.0000
  653.1864      69.8491      64.3848      95.3113     156.1024     162.5589       6.1516     311.0000      -0.0632      -0.1019       2.7451      41.8215     414.8752       7.4840      45.7498       0.0816       0.1258       3.4167    2818.1538      78.7117     195.4375    1982.0000
  653.3388      57.9304      60.3513     100.5647     191.5735     175.3321       5.7035     311.0000      -0.0541      -0.0924       2.8087      40.9807     404.7683       0.8445      45.7498       0.0649       0.1072       3.4154    2802.4958     112.0489     196.8750    1972.0000
  653.4912      53.7075      56.9733      91.4818     193.7460     160.7349       6.2214     311.0000      -0.0433      -0.0812       2.7758      42.7510     401.4905      -1.8640      45.7498       0.0626       0.1043       3.4595    2783.9631     101.3805     198.2500    1982.0000
  653.6436      49.8680      56.9482      86.5910     175.4529     125.6384       7.9593     311.0000      -0.0383      -0.0761       2.8613      47.9660     402.8563      -2.9731      45.7498       0.0780       0.1210       3.4790    2775.5701     102.1074     198.0000    1982.0000
  653.7960      46.2458      59.1098      90.9050     168.6226     115.0527       8.6917     311.0000      -0.0312      -0.0687       2.9803      50.2277     406.4073      -3.2403      45.7498       0.0611       0.1027       3.4628    2763.3203      96.4238     197.2500    1986.0000
  653.9484      44.8761      58.7680      77.2312     142.8919      97.1373      10.2947     311.0000      -0.0255      -0.0628       2.8618      52.0807     408.5926      -3.9554      45.7498       0.0684       0.1105       3.4241    2753.5938      75.8444     196.5625    2055.0000
  654.1008      42.4960      50.1624      75.5894     126.5722      93.4175      10.7046     311.0000      -0.0189      -0.0559       2.8622      52.1091     408.5926      -5.8682      45.7498       0.0942       0.1387       3.3993    2742.2500      66.6308     197.9375    2008.0000
  654.2532      55.3069      53.7590      81.7588     131.5111     101.8777       9.8157     311.0000      -0.0249      -0.0622       3.1977      51.8202     404.2220      -4.6852      46.0294       0.1005       0.1459       3.3685    2752.6094      64.4918     197.5625    1920.0000
  654.4056      69.0867      58.5646      90.6574     139.4917     128.9897       7.7526     311.0000      -0.0331      -0.0707       3.2598      47.0083     397.6663      -3.6650      46.0294       0.0964       0.1419       3.3501    2766.6401      80.2023     194.4375    1956.0000
  654.5580      74.2707      60.8208      98.1864     145.8631     151.0517       6.6202     311.0000      -0.0390      -0.0768       2.7557      45.9668     392.2031      -2.6114      45.7498       0.0743       0.1177       3.3495    2776.7041      87.9755     193.9375    1984.0000
  654.7104      71.5312      67.0460     110.8465     154.2454     176.5454       5.6643     311.0000      -0.0369      -0.0746       2.7119      44.8434     389.1984      -3.4463      45.7498       0.0679       0.1105       3.3699    2773.1282      94.8273     193.5000    1934.0000
  654.8628      60.9765      66.0930     103.7071     158.3826     163.1909       6.1278     311.0000      -0.0320      -0.0695       2.9484      45.6269     388.3789      -4.1850      45.7498       0.0786       0.1217       3.4119    2764.7568      81.5492     193.5000    1952.0000
  655.0152      60.8884      62.0410      89.3075     145.7347     134.9882       7.4081     311.0000      -0.0230      -0.0602       3.1133      45.8044     388.3789      -4.8568      46.0294       0.0875       0.1312       3.4989    2749.3540      80.1679     193.5000    1977.0000
  655.1676      66.5413      76.4183     112.4422     197.5277     150.2509       6.6555     311.0000      -0.0185      -0.0555       2.9611      42.9288     384.5547      -4.4532      46.0294       0.0698       0.1118       3.6344    2741.6167      86.7222     193.5000    1949.0000
  655.3200      63.2369      84.4815     131.2384     230.7153     139.5436       7.1662     311.0000      -0.0256      -0.0629       2.9655      38.6422     381.2768       0.1178      46.0294       0.0546       0.0948       3.7116    2753.7437     137.4065     193.5000    1951.0000
  655.4724      66.1639      78.9493     119.4505     222.3746     128.1059       7.8060     311.0000      -0.0377      -0.0754       3.2450      36.0334     376.3600       9.6660      45.7498       0.0485       0.0879       3.6892    2774.3840     209.2790     192.1250    1971.0000
  655.6248      63.7867      74.5447     117.7875     212.0487     132.4696       7.5489     311.0000      -0.0369      -0.0746       3.1323      38.2913     377.4526      10.6101      46.0294       0.0550       0.0950       3.5662    2773.1282     224.0197     193.5000    1950.0000
  655.7772      61.6119      74.1096     110.1802     180.8291     121.1884       8.2516     311.0000      -0.0423      -0.0802       2.9554      43.1320     377.9989      21.5576      46.0294       0.0725       0.1145       3.4672    2782.2727     166.4462     193.5000    1948.0000
  655.9296      76.0606      85.3218      92.7308     136.7259     105.0052       9.5233     311.0000      -0.0411      -0.0790       3.0768      43.9660     379.0916      22.2702      46.0294       0.0801       0.1232       3.4094    2780.3560     110.3310     193.5000    1953.0000
  656.0820      72.2615      66.0258     105.4091     146.5253     122.9162       8.1356     311.0000      -0.0492      -0.0873       3.2455      42.1133     385.6473      30.7002      46.0294       0.0779       0.1209       3.4021    2794.0647     100.3469     193.3750    1977.0000
  656.2344      92.5459      78.9466     135.5095     188.5274     176.6493       5.6609     311.0000      -0.0487      -0.0869       3.3231      40.2603     398.2126      37.2083      45.7498       0.0614       0.1029       3.4193    2793.3613     105.3861     193.1250    1958.0000
  656.3868     111.6115     113.7254     141.4765     202.2868     181.7428       5.5023     311.0000      -0.0591      -0.0976       3.0365      44.8513     400.3978      52.4344      46.0294       0.0631       0.1044       3.4511    2811.0242     129.9248     190.6875    1949.0000
  656.5392      99.7744     133.5099     148.2876     193.8273     172.9353       5.7825     311.0000      -0.0622      -0.1008       3.0007      44.8513     385.1010      53.5040      46.0294       0.0701       0.1121       3.4583    2816.2798     123.7299     189.6875    1984.0000
  656.6916      80.3857      78.8267     114.4204     158.7469     138.5445       7.2179     311.0000      -0.0510      -0.0893       3.0802      46.9606     368.7115      31.2276      46.0294       0.0774       0.1202       3.4285    2797.2734      99.3982     191.0000    1940.0000
  656.8440      70.1437      55.6447      70.7965     109.6502      89.8586      11.1286     311.0000      -0.0339      -0.0715       3.0550      44.3761     362.1558       7.4761      46.0294       0.0756       0.1187       3.3615    2767.9302     100.8243     190.6250    1926.0000
  656.9964      70.1072      58.8928      72.9816      90.9898      77.0199      12.9837     311.0000      -0.0244      -0.0617       3.4253      47.2438     372.5358      -3.4058      46.0294       0.0750       0.1186       3.3083    2751.7920     113.1455     190.8125    1958.0000
  657.1488      59.9037      80.4981      90.7377     107.9515      89.1787      11.2134     311.0000      -0.0110      -0.0478       3.2237      43.7448     371.9894       0.0122      46.0294       0.0850       0.1298       3.3241    2728.8892     145.3502     189.4375    1959.0000
  657.3012      62.3184      88.3733     110.6268     143.2351     105.4512       9.4831     311.0000      -0.0038      -0.0403       2.8936      46.4071     375.8137      44.1267      46.0294       0.1060       0.1527       3.5342    2716.4231     114.0736     190.7500    1948.0000
  657.4536      68.1238      83.2418      92.6639     109.8331      94.2839      10.6063     311.0000      -0.0120      -0.0488       3.3646      49.9126     386.7400     105.0303      46.0294       0.1216       0.1694       3.8012    2730.4434      47.1645     193.0625    1991.0000
  657.6060      76.7088      76.6964      95.8716     112.3803      88.1719      11.3415     311.0000      -0.0308      -0.0682       3.4933      54.4565     388.3789     144.7132      46.0294       0.1300       0.1786       3.9743    2762.5977      35.4747     189.4375    1984.0000
  657.7584      86.9255      87.3342     113.8573     140.1925      94.9866      10.5278     311.0000      -0.0411      -0.0789       3.2959      54.1104     380.1841     131.9449      46.0294       0.1201       0.1680       3.9174    2780.2175      35.1195     188.0625    2040.0000
  657.9108     115.9287      88.5570     123.1373     156.7058     123.2386       8.1143     311.0000      -0.0300      -0.0674       2.9159      57.7096     374.1747      91.3124      46.0294       0.1021       0.1490       3.7746    2761.2773      44.8860     187.5000    1996.0000
  658.0632      94.2746      95.8149     141.5882     187.1341     161.1204       6.2065     311.0000      -0.0305      -0.0679       3.0758      59.7039     370.3505      74.0883      46.0294       0.1098       0.1572       3.6423    2762.0771      47.4927     191.1875    1968.0000
  658.2156      89.2294      88.5595     132.9439     190.3136     183.1296       5.4606     311.0000      -0.0167      -0.0537       3.2523      58.3142     369.5311      49.5596      46.0294       0.1484       0.1983       3.5370    2738.5593      36.0127     187.2500    2004.0000
  658.3680      85.7973      87.5381     128.8866     188.7424     211.9130       4.7189     311.0000      -0.0204      -0.0575       3.1489      54.4201     368.1653      35.3944      46.0294       0.1451       0.1949       3.4224    2744.8162      40.5697     187.5000    1952.0000
  658.5204      81.7139      87.7083     130.2779     215.2228     225.0472       4.4435     311.0000      -0.0137      -0.0506       3.3124      53.4795     369.2579      14.1273      46.0294       0.1373       0.1867       3.3552    2733.5034      50.0863     188.6250    1934.0000
  658.6728      76.9612      92.1921     120.6704     201.9283     206.9432       4.8322     311.0000      -0.0156      -0.0526       3.5903      53.7648     366.2531       7.7374      46.0294       0.1478       0.1978       3.3825    2736.7363      71.5495     189.3750    1918.0000
  658.8252      77.6501      81.4301     113.4170     213.7232     190.8849       5.2388     311.0000      -0.0235      -0.0608       3.0701      50.5541     369.2579      18.9967      46.0294       0.1154       0.1634       3.4715    2750.2480      74.5888     186.8125    1915.0000
  658.9776      90.6732      89.1572     128.3357     243.2997     226.8348       4.4085     311.0000      -0.0358      -0.0735       2.5033      44.4933     369.5311      36.7711      46.0294       0.1073       0.1546       3.5513    2771.2170      60.2241     190.6250    1956.0000
  659.1300      97.5031      97.3311     139.6386     269.7704     247.5594       4.0394     311.0000      -0.0527      -0.0910       3.0481      40.6661     370.3505      50.5002      46.0294       0.1146       0.1617       3.5653    2800.1846      58.7492     191.4375    1976.0000
  659.2824     114.0893      91.9534     136.2627     267.7560     247.5877       4.0390     311.0000      -0.0433      -0.0813       3.3181      40.4657     367.6189      34.8370      46.0294       0.1036       0.1498       3.5127    2784.0730      67.0694     189.0000    1953.0000
  659.4348     115.5327      86.4289     128.4489     256.2374     231.9179       4.3119     311.0000      -0.0298      -0.0673       3.2821      44.4579     368.4384      14.4732      46.0294       0.0816       0.1260       3.4560    2760.9705      98.9973     190.4375    1958.0000
  659.5872     123.1903      84.3150     122.7267     225.2617     208.7002       4.7916     311.0000      -0.0189      -0.0560       3.3313      47.9998     374.7210       1.6301      46.0294       0.0852       0.1301       3.4390    2742.3232     107.2151     193.5000    1957.0000
  659.7396     125.6162      85.6176     114.7533     191.3767     170.0061       5.8821     311.0000      -0.0339      -0.0715       3.7081      48.3717     368.7115      14.5483      46.0294       0.1009       0.1473       3.5018    2768.0537      99.5141     193.5000    1932.0000
  659.8920     101.7228      94.1769     109.9029     166.2747     143.3580       6.9755     311.0000      -0.0443      -0.0823       3.5617      47.6549     367.6189      23.6244      46.0294       0.1040       0.1505       3.5843    2785.7925     101.8890     191.8125    1906.0000
  660.0444      95.7908     112.5905     114.5426     142.2357     114.2557       8.7523     311.0000      -0.0441      -0.0821       3.3459      51.3847     367.0726      34.5633      46.0294       0.0960       0.1418       3.6510    2785.3838      88.1008     192.6875    1912.0000
  660.1968      80.2890      74.1532      77.1881     111.8535     103.6989       9.6433     311.0000      -0.0153      -0.0523       3.0644      49.5611     376.9063      22.6579      46.0294       0.1039       0.1501       3.6443    2736.2219      73.0136     193.1250    1960.0000
  660.3492      92.2191      55.7819      61.2357      69.4748      62.5326      15.9916     311.0000      -0.0026      -0.0390       3.5660      51.2929     394.9347      17.4131      46.0294       0.0999       0.1455       3.5636    2714.3933      66.4036     192.3750    1949.0000
  660.5016     104.9960      53.5803      55.7506      53.4661      50.5548      19.7805     311.0000       0.0128      -0.0231       3.6043      48.2580     418.1531       5.5189      46.0294       0.0873       0.1324       3.4803    2688.1187      74.8242     191.5000    1912.0000
  660.6540     123.3021      76.6885      76.8304      89.4051      77.4549      12.9107     311.0000       0.0426       0.0078       3.2673      53.7669     432.6304      16.6144      46.0294       0.0858       0.1308       3.6887    2637.1938      52.8233     193.1250    1931.0000
  660.8064     122.0272     127.9836     118.1265     119.0791      92.2621      10.8387     311.0000       0.0976       0.0648       3.2896      58.0245     454.4830      57.6968      46.0294       0.1051       0.1519       4.2896    2543.0188      32.0380     192.3750    1943.0000
  660.9588     109.3028      96.6084      85.6785     110.5379     106.0540       9.4292     311.0000       0.1213       0.0893       3.4723      60.6542     460.4924     135.0932      46.0294       0.1170       0.1648       4.9861    2502.6414      15.2451     193.5000    1956.0000
  661.1112     114.0173      60.6670      61.6499      72.0407      65.2056      15.3361     311.0000       0.0757       0.0421       3.3440      61.0423     468.1408     228.7893      46.0294       0.1452       0.1949       5.3830    2580.4888      14.0758     190.1250    1941.0000
  661.2636     115.7854     100.4779     124.7340     173.0105     147.3293       6.7875     311.0000       0.0306      -0.0047       3.2986      65.8704     506.1098     258.7233      46.0294       0.1404       0.1900       5.3547    2657.7317      14.3631     190.2500    1951.0000
  661.4160     173.7772     133.5910     316.3893     339.6731     263.5640       3.7941     311.0000       0.0031      -0.0331       3.4096      74.1775     507.4756     232.5909      46.0294       0.1283       0.1774       5.0779    2704.6196      14.4937     190.2500    1959.0000
  661.5684      83.1117     184.2117     208.3333     289.3114     232.7436       4.2966     311.0000       0.0047      -0.0315       3.3743      85.4823     498.1882     168.8819      46.0294       0.1840       0.2357       4.6833    2702.0171      13.6231     191.6250    1993.0000
  661.7208      85.8560     120.3866     137.2191     264.7097     225.6974       4.4307     311.0000      -0.0102      -0.0469       3.4280      89.7940     505.8366     124.7127      46.0294       0.1706       0.2218       4.2364    2727.3674      15.9683     191.8750    1998.0000
  661.8732      71.4539      62.2324      98.1122     232.0572     211.6642       4.7245     311.0000      -0.0076      -0.0442       3.2495      94.1442     456.1220      87.4043      46.0294       0.1916       0.2434       3.8682    2722.9956      23.2042     191.7500    1988.0000
  662.0256      64.4302      39.1242      64.0154     165.4816     163.5534       6.1142     311.0000       0.0038      -0.0324       3.6113      93.2099     438.3667      59.2637      46.0294       0.2285       0.2808       3.6734    2703.5098      25.8434     193.5000    1929.0000
  662.1780      63.6735      32.7870      50.2771     136.8394     124.1023       8.0579     311.0000       0.0106      -0.0254       3.5091      85.4962     408.5926      46.1085      46.0294       0.2368       0.2895       3.6112    2691.8291      27.1849     193.5000    1973.0000
  662.3304      71.9180      47.6988      78.9670     205.8330     208.4914       4.7964     311.0000       0.0034      -0.0329       3.4555      71.3674     374.9942      32.4538      46.0294       0.1781       0.2295       3.5641    2704.2202      40.0103     193.5000    1949.0000
  662.4828      87.8967      81.7849     120.4181     206.9691     204.0797       4.9000     311.0000      -0.0108      -0.0476       3.3240      51.4529     369.8042      18.1775      46.0294       0.1027       0.1495       3.4545    2728.5217      69.8179     193.5000    1946.0000
  662.6352      76.6687      95.9809     173.5961     232.1440     190.8022       5.2410     311.0000      -0.0277      -0.0651       3.4858      42.2928     366.5263       2.5477      46.0294       0.0562       0.0981       3.3440    2757.4058     133.9915     193.5000    1943.0000
  662.7876      81.4681      93.4530     144.1595     177.5678     175.4545       5.6995     311.0000      -0.0500      -0.0882       3.3114      39.1308     365.9800       2.5558      46.0294       0.0709       0.1132       3.3203    2795.5674     117.7044     193.5000    1993.0000
  662.9400      89.8999      82.0691     113.9652     132.5368     114.4167       8.7400     311.0000      -0.0571      -0.0955       3.2472      40.2919     366.5263       3.3622      46.0294       0.0694       0.1117       3.3734    2807.6265     102.2710     193.5000    1957.0000
  663.0924      79.0005      72.0461      92.3162     105.3916      87.9229      11.3736     311.0000      -0.0491      -0.0872       3.3828      41.3323     366.5263       0.1953      46.0294       0.0792       0.1227       3.4628    2793.9114     126.3599     193.5000    1929.0000
  663.2448      75.1975      62.1543      75.8056      81.4901      69.6778      14.3518     311.0000      -0.0360      -0.0736       3.4870      39.1671     365.1605      -1.9407      46.0294       0.0786       0.1220       3.4991    2771.5054     118.7582     193.5000    1912.0000
  663.3972      68.2145      61.2687      74.0489      80.2691      67.9469      14.7174     311.0000      -0.0312      -0.0687       3.4106      39.2451     362.7021      -2.1031      46.0294       0.0656       0.1081       3.4605    2763.4246     117.1083     194.8125    1970.0000
  663.5496      64.1057      63.7210      78.1971      74.3932      69.6867      14.3499     311.0000      -0.0229      -0.0601       3.3106      40.6361     361.6095      -2.9290      46.0294       0.0757       0.1193       3.4147    2749.1160      88.1003     196.9375    1963.0000
  663.7020      55.2186      56.3427      69.4715      69.4968      67.9012      14.7273     311.0000      -0.0203      -0.0574       3.4157      43.4473     359.1511      -1.2958      46.0294       0.0997       0.1455       3.3822    2744.6411      73.4480     195.6875    1936.0000
  663.8544      46.8365      45.1094      54.1335      61.1752      55.7474      17.9381     311.0000      -0.0161      -0.0531       3.3804      49.4674     365.4337       1.0855      46.0294       0.1100       0.1571       3.4188    2737.5420      57.2164     198.3125    1966.0000
  664.0068      40.7369      38.8448      46.6381      58.5972      49.3533      20.2621     311.0000      -0.0258      -0.0631       3.4653      55.9931     360.5168      14.6153      46.0294       0.1203       0.1683       3.4728    2754.0447      52.0639     201.1250    1984.0000
  664.1592      41.5391      36.4216      43.4577      55.2302      46.3145      21.5915     311.0000      -0.0348      -0.0724       3.3353      62.9099     370.8969      32.4278      46.0294       0.1403       0.1898       3.5106    2769.4863      45.8087     197.3750    1964.0000
  664.3116      39.2504      33.2959      40.3131      51.8690      43.9279      22.7646     311.0000      -0.0376      -0.0753       3.6223      66.6335     370.3505      37.2093      46.0294       0.1660       0.2169       3.4547    2774.3232      38.2430     199.8125    1955.0000
  664.4640      48.9727      42.0127      59.1154      74.5113      73.5719      13.5922     311.0000      -0.0295      -0.0669       3.7530      64.0206     365.7068      24.1776      46.0294       0.1487       0.1988       3.3119    2760.3938      43.0391     199.2500    1973.0000
  664.6164      55.0588      68.5032      81.5026     104.0921      98.3624      10.1665     311.0000      -0.0201      -0.0572       3.5345      62.5476     364.3410       5.3918      46.0294       0.1180       0.1662       3.1788    2744.3081      53.4676     201.1250    1964.0000
  664.7688      56.6234      55.9921      70.9678     104.0511     130.3404       7.6722     311.0000      -0.0153      -0.0522       3.4210      60.8850     366.2531      -2.5160      46.0294       0.1257       0.1744       3.1396    2736.1523      55.7423     201.1250    1953.0000
  664.9212      61.3230      55.4253      75.9331     113.8313     136.6220       7.3195     311.0000      -0.0206      -0.0577       3.4415      59.7670     367.0726      -0.8817      46.0294       0.1540       0.2042       3.1510    2745.2744      44.7803     203.0625    1950.0000
  665.0736      73.9127      62.8383      82.0040     141.0684     163.6774       6.1096     311.0000      -0.0252      -0.0625       3.4898      52.4350     368.1653      -1.4727      46.0294       0.1554       0.2056       3.1891    2753.1731      53.5553     200.4375    1975.0000
  665.2260     106.1622      85.4411     118.4458     193.5313     243.6247       4.1047     311.0000      -0.0397      -0.0775       3.4486      41.2649     367.6189      -0.4334      46.0294       0.1036       0.1502       3.1608    2777.9490      80.1551     202.5000    1974.0000
  665.3784     104.8392     133.0373     155.7799     225.2456     275.3135       3.6322     311.0000      -0.0503      -0.0885       3.6764      32.3916     368.1653       0.7985      46.0294       0.0639       0.1066       3.1550    2796.0654     146.5201     203.2500    1981.0000
  665.5308      94.3060     110.2782     165.0644     218.9126     249.0848       4.0147     311.0000      -0.0622      -0.1009       3.9033      31.0301     368.1653       4.6053      46.0294       0.0684       0.1108       3.1459    2816.4172     133.5125     203.2500    2034.0000
  665.6832      90.8656      80.4122     130.5071     180.3531     190.7659       5.2420     311.0000      -0.0724      -0.1114       3.6618      33.6905     367.6189       9.5246      46.0294       0.0753       0.1186       3.1915    2833.8442     114.4940     201.4375    1982.0000
  665.8356      85.1221      66.3957      97.2302     124.0625     126.4603       7.9076     311.0000      -0.0815      -0.1208       3.7588      35.1118     367.8921      15.2614      46.0294       0.0859       0.1302       3.2074    2849.3696      96.8510     201.5625    1983.0000
  665.9880      75.5447      63.8608      87.3639     100.4210     101.5516       9.8472     311.0000      -0.0815      -0.1208       3.7284      35.8886     368.7115      15.3289      46.0294       0.0800       0.1238       3.1857    2849.3765      96.3880     201.1875    2052.0000
  666.1404      70.7427      59.4977      77.8661      88.6601      83.6595      11.9532     311.0000      -0.0705      -0.1094       3.5622      36.5203     369.2579      10.2866      46.0294       0.0793       0.1228       3.1361    2830.4797      93.0009     202.8750    1989.0000
  666.2928      57.4581      57.4251      67.3434      78.8849      69.1505      14.4612     311.0000      -0.0499      -0.0880       4.0030      40.6895     369.2579       1.6634      46.0294       0.0739       0.1172       3.1368    2795.2656      79.4276     202.0000    1950.0000
  666.4452      49.2393      56.0036      64.4202      77.5687      64.6839      15.4598     311.0000      -0.0354      -0.0730       4.0355      42.7194     369.8042      -1.5841      46.0294       0.0875       0.1322       3.1521    2770.5078      70.5250     203.2500    1938.0000
  666.5976      43.6710      55.5738      61.7610      76.2127      63.3427      15.7871     311.0000      -0.0143      -0.0512       3.7407      49.3869     369.8042      -2.0719      46.0294       0.0983       0.1441       3.2250    2734.5032      62.1698     203.2500    1946.0000
  666.7500      42.4418      53.9414      60.0084      76.6007      65.5597      15.2533     311.0000      -0.0010      -0.0374       4.0371      52.3062     371.4431       3.7878      46.0294       0.1028       0.1494       3.3108    2711.7898      35.9462     200.0625    1986.0000
  666.9024      46.3777      50.6564      63.5604      80.7139      70.1357      14.2581     311.0000       0.0050      -0.0312       4.0211      54.5080     389.4715      21.2393      46.0294       0.1453       0.1950       3.4245    2701.4260      30.9052     200.6875    1965.0000
  667.0548      48.0410      50.3990      62.0303      85.3947      85.9989      11.6281     311.0000      -0.0063      -0.0429       3.8441      55.2460     371.7163      47.7800      46.0294       0.1746       0.2259       3.5191    2720.7463      27.1911     200.0625    1991.0000
  667.2072      47.7321      46.0659      63.4077      96.4382     108.9924       9.1749     311.0000       0.0040      -0.0322       3.8340      57.4748     384.0084      60.7867      46.0294       0.1385       0.1882       3.5871    2703.1230      38.3830     200.6875    2008.0000
  667.3596      57.2037      39.0907      56.0627      83.4523     132.9545       7.5214     311.0000       0.0164      -0.0194       3.9536      62.8643     391.6568      75.2547      46.0294       0.1610       0.2117       3.6906    2681.9531      31.6592     202.1875    1922.0000
  667.5120      63.5366      42.7619      59.5752      90.4212     185.3667       5.3947     311.0000       0.0197      -0.0159       4.0251      59.7217     411.8704      88.6028      46.0294       0.1975       0.2496       3.7434    2676.2996      36.8282     202.6875    1894.0000
  667.6644      88.9064      55.4895      90.3885     146.8307     232.5581       4.3000     311.0000      -0.0149      -0.0518       3.9779      52.9523     369.2579     112.7436      46.0294       0.1544       0.2047       3.7110    2735.4727      49.2717     203.2500    1997.0000
  667.8168     123.4228     108.0367     137.0878     185.6245     252.9971       3.9526     311.0000      -0.0524      -0.0907       3.5959      43.5340     348.4979     115.4096      46.0294       0.0816       0.1265       3.5739    2799.5930     101.1465     202.3750    2079.0000
  667.9692      76.8311     102.5086     175.1568     250.0794     225.3980       4.4366     311.0000      -0.0683      -0.1072       3.9556      37.4237     346.8590     101.3002      46.0294       0.0656       0.1083       3.4494    2826.8640     129.1288     201.8750    2067.0000
  668.1216      64.2569     101.4614     142.5598     231.2351     208.9102       4.7867     311.0000      -0.0613      -0.0999       4.2186      37.2214     345.7664      67.3130      46.0294       0.0606       0.1021       3.3455    2814.7837     106.6008     201.3750    2023.0000
  668.2740      63.5477      93.6660     128.4585     203.5812     124.9017       8.0063     311.0000      -0.0417      -0.0796       3.9536      39.0214     347.6784      33.0443      46.0294       0.0582       0.1002       3.2959    2781.3098      95.8364     201.8750    2008.0000
  668.4264      53.7015      69.8521      81.7035     115.8990      82.7459      12.0852     311.0000      -0.0338      -0.0714       3.8902      48.5442     349.0442       9.0797      46.0294       0.0973       0.1430       3.2384    2767.7480      60.3122     203.2500    1957.0000
  668.5788      44.5490      47.6963      56.3756      75.7530      54.9702      18.1917     311.0000      -0.0333      -0.0709       3.8483      52.6841     357.2390       2.7437      46.0294       0.1419       0.1911       3.2162    2766.9707      51.8043     201.1250    1923.0000
  668.7312      62.2014      47.1915      57.3659      81.9295      64.8112      15.4294     311.0000      -0.0380      -0.0758       3.8010      53.3200     350.6832       4.3440      46.0294       0.1656       0.2163       3.2122    2775.0503      48.0465     202.0000    1933.0000
  668.8836      66.1048      52.5588      65.8096      88.9379      82.2871      12.1526     311.0000      -0.0436      -0.0816       4.0828      46.9849     352.3221       8.4960      46.0294       0.1334       0.1822       3.2506    2784.6274      59.8477     200.6875    1955.0000
  669.0360      77.8889      64.2770      80.0875      87.2657     100.2635       9.9737     311.0000      -0.0410      -0.0789       3.9920      38.0818     345.7664       6.4754      46.0294       0.1040       0.1509       3.3037    2780.1436      80.6321     204.3125    1948.0000
  669.1884     113.0423      92.4712     115.6236     107.9702     125.5596       7.9643     311.0000      -0.0455      -0.0836       3.6654      35.7994     344.6737       6.8386      46.0294       0.0790       0.1234       3.2861    2787.8721     118.3860     203.2500    1950.0000
  669.3408      75.7782     117.9960     108.9347     137.7690      99.8270      10.0173     311.0000      -0.0355      -0.0732       4.1040      34.6622     345.2200       0.3760      46.0294       0.0650       0.1081       3.2760    2770.7405     108.2711     203.2500    1987.0000
  669.4932      61.9780      78.2672     101.7702     121.2907     100.2824       9.9718     311.0000      -0.0273      -0.0646       3.6447      42.3448     348.4979      -0.5834      46.0294       0.0871       0.1315       3.2713    2756.6208      76.4937     203.2500    2013.0000
  669.6456      46.4894      48.8842      58.1541      73.2626      61.2966      16.3141     311.0000      -0.0054      -0.0420       3.9582      46.7822     350.6832       9.5277      46.0294       0.1166       0.1638       3.3386    2719.2549      66.0437     205.1875    2000.0000
  669.7980      46.4259      31.3555      37.0433      50.2151      38.5789      25.9209     311.0000       0.0116      -0.0243       4.0103      47.3658     344.6737      10.2971      46.0294       0.1255       0.1735       3.3934    2690.1211      49.6388     203.2500    1998.0000
  669.9504      45.5581      43.1088      55.2451      67.9782      45.8456      21.8123     311.0000       0.0174      -0.0183       4.0307      48.9867     343.0348      24.0536      46.0294       0.1243       0.1730       3.4507    2680.2427      46.7453     203.2500    1959.0000
  670.1028      47.5272      60.1347      63.4369      77.7167      69.6076      14.3662     311.0000       0.0064      -0.0297       4.0231      54.0456     354.5074      36.7084      46.0294       0.1370       0.1866       3.4824    2698.9722      36.6347     204.1875    1943.0000
  670.2552      38.5594      45.6612      59.2789      68.0074      71.9916      13.8905     311.0000       0.0013      -0.0350       3.9719      66.0033     361.6095      47.6048      46.0294       0.1771       0.2285       3.4584    2707.7178      33.6292     203.2500    1941.0000
  670.4076      30.7689      31.7277      37.8779      47.1741      52.8694      18.9145     311.0000       0.0011      -0.0352       3.9058      71.4738     374.4479      44.6308      46.0294       0.2128       0.2649       3.3658    2708.1233      28.5610     203.2500    1960.0000
  670.5600      31.9794      29.0905      32.5668      41.5330      49.7820      20.0876     311.0000       0.0262      -0.0092       3.7104      72.9884     371.4431      21.3439      46.0294       0.2321       0.2845       3.2661    2665.1968      30.2096     203.2500    1992.0000
  670.7124      41.5712      34.5646      40.1040      54.2810      70.3094      14.2229     311.0000       0.0406       0.0057       4.0074      73.4388     369.2579      11.5538      46.0294       0.2041       0.2558       3.1875    2640.5498      30.8460     206.6875    1972.0000
  670.8648      45.7391      41.8716      48.5928      74.9156      98.2959      10.1734     311.0000       0.0501       0.0156       3.9660      69.6523     364.8874       2.0733      46.0294       0.1821       0.2336       3.1872    2624.2471      33.1616     208.0625    1973.0000
  671.0172      57.9324      49.0169      63.8587      97.5480     132.4750       7.5486     311.0000       0.0277      -0.0077       4.0336      60.2877     363.2484       2.2798      46.0294       0.1628       0.2136       3.1510    2662.6343      36.9122     207.0000    1949.0000
  671.1696      81.7605      76.6235      87.0786     121.0809     166.9179       5.9910     311.0000       0.0001      -0.0362       3.9444      49.8565     355.0537       2.0826      46.0294       0.1413       0.1908       3.1366    2709.7969      53.0065     205.3750    1951.0000
  671.3220      77.1647      79.4856     103.7964     159.0602     190.6390       5.2455     311.0000      -0.0202      -0.0573       4.1496      43.9175     354.5074       2.3172      46.0294       0.1002       0.1470       3.1433    2744.5742      68.2209     207.0625    1972.0000
  671.4744      68.4221      75.3346      89.2708     141.1202     162.5736       6.1511     311.0000      -0.0240      -0.0612       4.0768      43.1975     356.6926       1.3320      46.0294       0.1157       0.1634       3.1940    2751.0032      64.2910     208.0625    1965.0000
  671.6268      59.7899      73.5907      86.4842     123.2822     123.2992       8.1104     311.0000      -0.0203      -0.0574       4.0185      41.4234     357.2390       0.1855      46.0294       0.1191       0.1672       3.2344    2744.6375      68.0991     207.6250    1979.0000
  671.7792      58.0001      77.1354      97.5602     127.9763     116.8265       8.5597     311.0000      -0.0188      -0.0558       3.7965      44.2915     357.7852      -0.0429      46.0294       0.1136       0.1614       3.2419    2742.1084      75.9186     204.2500    1997.0000
  671.9316      48.7618      62.0172      67.0833      88.4609      76.7648      13.0268     311.0000      -0.0183      -0.0553       3.4930      45.4444     357.7852      -0.4516      46.0294       0.1182       0.1665       3.2583    2741.2922      61.9967     203.2500    1973.0000
  672.0840      53.9508      45.6822      53.2904      68.2086      61.5401      16.2496     311.0000      -0.0206      -0.0577       3.6761      42.0896     355.6000       0.0050      46.0294       0.1690       0.2201       3.2829    2745.1636      53.9175     203.7500    1931.0000
  672.2364      63.5989      54.5853      70.6078      94.8755      82.8406      12.0714     311.0000      -0.0323      -0.0699       3.9065      39.6268     354.5074      10.2701      46.0294       0.1376       0.1870       3.3076    2765.2556      59.8797     204.4375    1949.0000
  672.3888      57.4098      89.3500      74.9027      89.2112      83.6390      11.9561     311.0000      -0.0320      -0.0696       3.9907      41.2885     355.6000      14.7958      46.0294       0.1035       0.1507       3.3216    2764.7959      71.1942     204.8750    1997.0000
  672.5412      52.6943      60.8985      83.3645     105.7619     103.6239       9.6503     311.0000      -0.0186      -0.0556       3.9300      55.7870     356.6926      15.4243      46.0294       0.1112       0.1588       3.3283    2741.7810      54.1197     204.6875    1995.0000
  672.6936      41.0277      36.0285      45.4007      55.7087      60.2356      16.6015     311.0000       0.0031      -0.0331       4.1517      61.0892     356.6926       6.3100      46.0294       0.1876       0.2395       3.3333    2704.6399      40.6554     203.5625    1979.0000
  672.8460      56.4826      34.0777      39.2090      42.8801      47.5616      21.0254     311.0000       0.0086      -0.0274       3.9246      63.2494     365.7068       3.4363      46.0294       0.2029       0.2552       3.3486    2695.2646      40.9787     203.6250    1966.0000
  672.9984      79.9517      53.9824      56.6206      73.3047      82.0331      12.1902     311.0000       0.0038      -0.0325       3.6917      57.2063     361.0632       2.2564      46.0294       0.1420       0.1919       3.3830    2703.5461      54.1630     203.4375    1955.0000
  673.1508      70.7210      80.9776      80.8041      87.5527      83.1386      12.0281     311.0000      -0.0015      -0.0379       4.1477      59.5224     355.0537      12.9523      46.0294       0.1038       0.1512       3.3749    2712.4822      75.7635     203.2500    1957.0000
  673.3032      59.3996      52.7677      63.0532      84.6818      79.3670      12.5997     311.0000      -0.0055      -0.0421       4.0282      61.9933     354.5074      28.3959      46.0294       0.1445       0.1942       3.3349    2719.3906      56.5946     205.6875    1996.0000
  673.4556      50.8836      40.2156      49.3334      58.6811      54.8906      18.2180     311.0000      -0.0051      -0.0417       3.8126      59.7916     357.2390      35.5685      46.0294       0.1621       0.2128       3.3105    2718.7476      49.8999     205.3750    1999.0000
  673.6080      52.2759      39.9498      44.9938      53.9151      49.3500      20.2634     311.0000      -0.0041      -0.0406       4.1514      51.7942     355.6000      34.3418      46.0294       0.1257       0.1746       3.3108    2716.9343      49.2536     204.6875    1986.0000
  673.7604      53.8469      42.8579      45.4017      53.1487      45.0561      22.1945     311.0000       0.0128      -0.0231       3.7615      53.3756     356.6926      17.6041      46.0294       0.1332       0.1825       3.3668    2688.1553      55.5402     204.6250    2003.0000
  673.9128      38.7879      43.8787      43.6717      49.9307      43.7624      22.8507     311.0000       0.0376       0.0026       3.7179      60.1427     355.0537      21.2162      46.0294       0.1452       0.1952       3.4615    2645.7000      51.7864     203.8750    1993.0000
  674.0652      32.9694      36.7463      39.7522      43.0789      37.6665      26.5488     311.0000       0.0514       0.0169       3.8804      77.3386     348.4979      46.9737      46.0294       0.2018       0.2539       3.6109    2622.0481      32.5586     205.5000    1976.0000
  674.2176      26.9464      26.3273      28.8794      31.7213      29.2197      34.2235     311.0000       0.0514       0.0169       3.5757      86.8411     369.8042      84.2276      46.0294       0.2229       0.2750       3.7025    2622.0847      23.7987     206.3750    1963.0000
  674.3700      33.0482      24.7828      27.1599      30.3631      29.0663      34.4041     311.0000       0.0372       0.0021       3.8138      90.5476     386.7400      94.3117      46.0294       0.2385       0.2907       3.6671    2646.4604      21.2063     205.5625    1967.0000
  674.5224      32.0008      27.0108      29.6206      33.4037      32.5995      30.6753     311.0000       0.0379       0.0029       3.9474      85.5312     382.9157      59.8762      46.0294       0.2127       0.2645       3.5182    2645.1885      25.7660     205.3750    1952.0000
  674.6748      32.5217      31.3482      33.8312      39.6667      41.6488      24.0103     311.0000       0.0409       0.0060       3.7140      82.7517     382.9157      23.9944      46.0294       0.1780       0.2291       3.3706    2640.0442      30.4507     205.6875    1981.0000
  674.8272      33.7633      31.6134      36.3524      46.6496      53.3243      18.7532     311.0000       0.0440       0.0093       3.8757      81.3816     385.6473       8.2781      46.0294       0.1932       0.2449       3.3122    2634.7231      31.5818     207.0625    1987.0000
  674.9796      31.5778      30.8193      34.9080      45.6502      57.4512      17.4061     311.0000       0.0320      -0.0032       3.7991      73.4936     382.3694      22.7065      46.0294       0.2146       0.2668       3.2925    2655.2844      34.4260     208.0625    1982.0000
  675.1320      36.4843      35.3659      41.6508      57.8545      76.8260      13.0164     311.0000       0.0302      -0.0051       3.9484      65.3921     372.5358      30.2501      46.0294       0.1952       0.2468       3.2661    2658.3713      35.5499     207.8750    1979.0000
  675.2844      37.8265      41.0866      48.8237      73.4443     103.9577       9.6193     311.0000       0.0441       0.0094       4.1605      61.0890     377.4526      25.3453      46.0294       0.1628       0.2134       3.1913    2634.5469      36.1732     210.5625    2010.0000
  675.4368      42.7697      42.4896      52.6233      88.5010     133.4948       7.4909     311.0000       0.0525       0.0180       4.0200      62.0393     375.8137      22.7799      46.0294       0.1719       0.2231       3.1518    2620.2397      33.1137     211.9375    1988.0000
  675.5892      53.5512      47.9500      61.8206     114.4147     176.8111       5.6558     311.0000       0.0399       0.0050       3.7143      55.7804     364.3410      25.3541      46.0294       0.1676       0.2186       3.1719    2641.7932      37.3350     210.7500    1943.0000
  675.7416      64.5145      59.3844      78.5053     163.7106     245.3433       4.0759     311.0000       0.0126      -0.0233       3.7957      47.2949     358.8779      25.2779      46.0294       0.1139       0.1614       3.2357    2688.5134      54.0109     210.6875    1949.0000
  675.8940     101.3893      89.8523     102.5490     192.0477     262.1801       3.8142     311.0000       0.0005      -0.0358       3.9862      40.6322     358.3316      11.3897      46.0294       0.0869       0.1321       3.3279    2709.1406      87.1350     211.7500    1982.0000
  676.0464      83.8106     119.9747     144.9635     212.2093     222.2118       4.5002     311.0000       0.0028      -0.0335       3.9941      37.6212     359.9705       2.2094      46.0294       0.0726       0.1162       3.4295    2705.2124      98.0364     212.8125    1992.0000
  676.1988      61.9368      95.1638     119.1312     176.9528     164.5746       6.0763     311.0000       0.0124      -0.0235       4.0780      36.2002     360.5168      17.0336      46.0294       0.0913       0.1363       3.6375    2688.7544      73.1497     211.8750    2006.0000
  676.3512      58.4784      68.8172      83.0503     117.6253     110.6688       9.0360     311.0000       0.0190      -0.0166       3.9024      38.9016     357.2390      55.7568      46.0294       0.0890       0.1343       3.9572    2677.4675      45.3141     212.7500    1989.0000
  676.5036      55.6722      59.3849      68.7180      86.4012      82.6655      12.0969     311.0000       0.0456       0.0109       3.8545      40.4324     352.8684      89.0896      46.0294       0.0995       0.1457       4.3433    2631.9753      24.0236     212.4375    1998.0000
  676.6560      52.9115      46.5820      53.5225      63.6802      60.9676      16.4021     311.0000       0.0640       0.0300       4.1561      48.3596     347.4053     123.6799      46.0294       0.1098       0.1571       4.6963    2600.5315      16.8021     213.0625    2021.0000
  676.8084      47.3211      41.0106      53.9888      63.4142      58.9693      16.9580     311.0000       0.0876       0.0544       3.9636      51.1052     340.3032     154.2513      46.0294       0.1283       0.1770       4.9928    2560.2502      12.6276     212.4375    2030.0000
  676.9608      47.3559      54.2845      56.7640      64.0345      58.7736      17.0145     311.0000       0.1034       0.0708       4.1175      60.2228     339.2105     196.4340      46.0294       0.1230       0.1716       5.3094    2533.1963      10.9703     212.3750    1999.0000
  677.1132      39.0607      37.6233      32.7561      37.7414      37.6073      26.5906     311.0000       0.1373       0.1060       3.9349      61.8025     336.4790     222.5652      46.0294       0.1800       0.2315       5.6583    2475.1736       7.0593     212.6250    2020.0000
  677.2656      34.2534      21.2787      22.9865      27.3634      24.4476      40.9039     311.0000       0.1520       0.1211       4.2238      61.8363     346.3127     242.1241      46.0294       0.1827       0.2342       5.9871    2450.1624       6.8986     213.0625    2013.0000
  677.4180      40.9598      29.4662      35.8921      42.4773      40.5345      24.6703     311.0000       0.1459       0.1149       4.3169      56.2835     328.8306     257.7453      46.0294       0.0866       0.1326       6.2337    2460.4399       6.8354     211.5625    2004.0000
  677.5704      47.5104      50.1163      52.0229      55.5831      56.3713      17.7395     311.0000       0.1401       0.1088       3.9300      57.3323     323.3674     267.5955      46.0294       0.0582       0.1013       6.3639    2470.5056       8.2177     211.9375    1992.0000
  677.7228      33.2981      30.6525      34.5279      42.6019      42.8684      23.3272     311.0000       0.1495       0.1186       4.2034      65.6549     350.6832     257.6013      46.0294       0.1033       0.1497       6.3550    2454.3467       6.5990     211.8750    1976.0000
  677.8752      23.8207      21.9881      23.0031      26.9579      27.5155      36.3432     311.0000       0.1485       0.1176       4.0481      69.5925     357.7852     241.0541      46.0294       0.1767       0.2279       6.2258    2456.0244       6.4462     211.6875    1995.0000
  678.0276      26.7859      21.8520      22.4668      25.3608      26.1519      38.2381     311.0000       0.1470       0.1160       4.2520      74.6164     372.5358     215.9922      46.0294       0.1990       0.2510       6.0627    2458.6274       6.6641     211.5000    1991.0000
  678.1800      28.6970      21.1850      22.2400      26.8969      26.8249      37.2788     311.0000       0.1408       0.1095       4.1199      74.9207     366.2531     200.4859      46.0294       0.1996       0.2513       5.8985    2469.2898       6.8270     211.1250    1975.0000
  678.3324      29.1380      22.3116      23.6567      27.6554      29.7130      33.6553     311.0000       0.1373       0.1059       4.3660      78.9674     380.1841     191.0069      46.0294       0.1871       0.2386       5.7102    2475.2080       7.2783     211.0625    1998.0000
  678.4848      32.8476      27.9382      29.1778      33.8446      37.6263      26.5772     311.0000       0.1225       0.0906       4.1466      74.3073     376.9063     190.8476      46.0294       0.1621       0.2128       5.4911    2500.4956       8.4611     211.3750    1971.0000
  678.6372      37.2113      34.6127      33.8837      41.6871      44.3852      22.5300     311.0000       0.1173       0.0852       4.0089      71.3641     382.6426     187.9318      46.0294       0.1550       0.2054       5.3349    2509.4360      10.8655     211.7500    1953.0000
  678.7896      33.1564      37.5570      37.3345      45.5869      47.1964      21.1881     311.0000       0.1258       0.0940       4.0872      69.4020     385.6473     186.3954      46.0294       0.1696       0.2207       5.3150    2494.9189      10.5929     210.8750    1981.0000
  678.9420      30.4896      28.5736      29.3095      37.4751      44.9773      22.2334     311.0000       0.1343       0.1028       4.2601      70.3055     375.8137     191.7944      46.0294       0.1568       0.2073       5.3603    2480.3362       9.4536     211.9375    1951.0000
  679.0944      28.6338      23.1164      24.3997      30.1851      32.3266      30.9343     311.0000       0.1192       0.0872       4.5487      70.7115     394.6615     211.9098      46.0294       0.1787       0.2301       5.3454    2506.1089       9.5340     213.0625    1963.0000
  679.2468      29.1821      25.3411      26.0852      34.0481      32.8018      30.4862     311.0000       0.1123       0.0801       4.1820      74.4971     380.1841     229.2483      46.0294       0.2221       0.2745       5.3597    2517.8970       9.8682     213.0625    1991.0000
  679.3992      30.4395      29.7692      33.1002      42.2469      41.4264      24.1392     311.0000       0.1358       0.1044       4.3638      67.5837     392.2031     232.3301      46.0294       0.1686       0.2194       5.4853    2477.7046      10.1953     213.0625    1969.0000
  679.5516      28.7292      30.5603      32.9958      42.5861      45.7446      21.8605     311.0000       0.1751       0.1451       4.4821      64.4994     374.7210     237.3087      46.0294       0.1797       0.2308       5.7036    2410.5825       7.0867     213.0625    1981.0000
  679.7040      28.9481      29.6634      32.9676      42.5758      49.9697      20.0121     311.0000       0.2034       0.1744       4.5193      63.2837     376.3600     243.7661      46.0294       0.2448       0.2970       5.8300    2362.2190       6.3322     212.3750    2004.0000
  679.8564      30.5848      26.9657      29.6281      38.6500      51.4934      19.4200     311.0000       0.2140       0.1854       4.3290      73.9030     373.6284     241.0090      46.0294       0.2600       0.3114       5.8002    2344.1177       5.6079     212.1875    2030.0000
  680.0088      32.6990      23.6761      27.1001      35.9145      50.3390      19.8653     311.0000       0.1997       0.1706       4.3591      73.9425     374.7210     221.8816      46.0294       0.2479       0.2997       5.6128    2368.5681       5.5558     210.5000    2033.0000
  680.1612      36.4994      28.2478      32.8236      42.0873      57.9591      17.2536     311.0000       0.1538       0.1230       4.1921      69.0564     361.0632     185.8492      46.0294       0.2236       0.2758       5.2750    2446.9841       6.0590     212.2500    2006.0000
  680.3136      42.6487      33.9340      40.0180      50.8562      65.2657      15.3220     311.0000       0.0928       0.0598       4.1023      58.3993     326.6453     159.6062      46.0294       0.1819       0.2331       4.8713    2551.2520       8.8940     210.5000    1989.0000
  680.4660      44.9023      38.9127      45.2786      57.2192      73.0215      13.6946     311.0000       0.0749       0.0412       4.2917      60.6816     327.7379     140.0390      46.0294       0.1413       0.1911       4.6455    2581.9446      16.4333     209.0000    1996.0000
  680.6184      43.4398      45.8840      51.6984      60.2239      67.6452      14.7830     311.0000       0.0874       0.0542       4.2591      61.1501     325.2795     140.3074      46.0294       0.1497       0.1999       4.6715    2560.5605      16.0693     208.5625    2001.0000
  680.7708      33.7045      44.8824      45.1037      53.4100      50.0140      19.9944     311.0000       0.1036       0.0710       3.9464      72.7337     325.5527     164.9935      46.0294       0.1330       0.1824       4.8711    2532.8147      12.7093     207.3125    2054.0000
  680.9232      32.4098      39.1966      42.0744      50.1133      44.3280      22.5591     311.0000       0.1131       0.0809       4.2341      75.9321     331.8353     191.0014      46.0294       0.1779       0.2293       5.0569    2516.5916      13.4948     206.8750    2043.0000
  681.0756      26.7973      31.7610      32.8969      38.0499      33.6948      29.6781     311.0000       0.1258       0.0940       4.1821      78.7288     355.0537     206.3069      46.0294       0.2204       0.2721       5.1128    2494.8630       9.8172     205.5000    2010.0000
  681.2280      24.2825      26.5580      26.9212      30.6365      25.7436      38.8446     311.0000       0.1139       0.0817       4.3624      79.4237     391.6568     221.6756      46.0294       0.2962       0.3475       5.0231    2515.1875      10.4986     203.2500    2025.0000
  681.3804      29.8779      28.8544      30.3988      36.2970      35.2897      28.3369     311.0000       0.1043       0.0717       4.2261      82.4132     394.3884     210.6793      46.0294       0.2826       0.3330       4.8862    2531.6453      10.1913     203.2500    2023.0000
  681.5328      29.1914      27.4424      30.2713      36.3833      41.7445      23.9553     311.0000       0.0949       0.0619       4.3988      83.4733     396.0273     189.5621      46.0294       0.2167       0.2682       4.8340    2547.7847      11.9755     203.2500    2013.0000
  681.6852      27.6593      24.8661      27.4339      35.0333      50.6384      19.7479     311.0000       0.0990       0.0662       4.4844      77.4512     400.3978     158.8986      46.0294       0.1936       0.2453       4.9382    2540.6953      11.4636     202.8125    2012.0000
  681.8376      35.9184      30.6812      35.3155      48.0205      72.2642      13.8381     311.0000       0.0784       0.0449       4.2095      68.0206     388.1057     150.2416      46.0294       0.1709       0.2221       5.0697    2575.9473      12.1524     200.0625    2003.0000
  681.9900      42.2042      39.6924      48.0741      69.5056     111.3406       8.9815     311.0000       0.0581       0.0239       4.2574      62.5398     369.8042     149.7087      46.0294       0.1679       0.2190       5.1840    2610.6235      14.9511     200.3125    2016.0000
  682.1424      48.2585      44.7732      54.3312      86.2988     162.9570       6.1366     311.0000       0.0614       0.0272       4.6145      57.7044     349.0442     135.1833      46.0294       0.1702       0.2213       5.2664    2605.0579      19.3804     197.3125    2021.0000
  682.2948      56.7093      57.7958      70.0051     113.6533     209.9366       4.7633     311.0000       0.0791       0.0456       4.3756      53.0720     355.6000     124.4988      46.0294       0.1201       0.1681       5.4180    2574.8162      23.8596     196.2500    1958.0000
  682.4472      66.0551      91.5808      96.9922     147.6039     209.2348       4.7793     311.0000       0.0848       0.0515       4.0367      46.3733     347.4053     124.2399      46.0294       0.0750       0.1186       5.5956    2565.0574      29.3891     193.5625    1970.0000
  682.5996      59.3080      94.2458     111.6180     156.0432     196.0698       5.1002     311.0000       0.0727       0.0390       4.3532      39.4510     343.0348     133.2481      46.0294       0.0584       0.0995       5.7100    2585.7058      22.9930     193.5000    2019.0000
  682.7520      57.2982      78.5593      85.3081     131.8658     149.2328       6.7009     311.0000       0.0584       0.0241       4.2939      35.0503     344.1274     139.6725      46.0294       0.0607       0.1015       5.7110    2610.2014      26.3035     193.1250    1997.0000
  682.9044      66.5677      77.8316      82.9333     107.7428     104.4185       9.5768     311.0000       0.0621       0.0280       4.2819      32.3920     344.1274     132.9706      46.0294       0.0587       0.0990       5.6754    2603.8286      27.3037     193.3750    2007.0000
  683.0568      67.5821      81.0198      83.8678     107.3104      95.0083      10.5254     311.0000       0.0619       0.0277       4.4834      31.4319     342.4884     132.7074      46.0294       0.0602       0.1007       5.6545    2604.2341      39.3561     193.5000    2012.0000
  683.2092      68.8761      87.2740      95.0741     121.9967     105.7694       9.4545     311.0000       0.0589       0.0246       4.2775      30.2422     344.1274     134.3467      46.0294       0.0644       0.1052       5.6508    2609.3494      36.9577     193.5000    1984.0000
  683.3616      70.8381     100.6839     115.9944     133.5896     114.1881       8.7575     311.0000       0.0435       0.0088       4.1764      31.2765     339.7569     146.3656      46.0294       0.0548       0.0952       5.6163    2635.5315      34.9146     193.5000    2006.0000
  683.5140      73.7381      99.6675     114.8555     150.6792     133.1635       7.5096     311.0000       0.0298      -0.0055       4.5600      34.4978     346.8590     157.0790      46.0294       0.0649       0.1061       5.5489    2659.0491      36.1358     193.5000    2016.0000
  683.6664      74.8233      83.8773     103.2716     136.9551     130.8167       7.6443     311.0000       0.0270      -0.0084       4.3768      34.1104     343.0348     155.3967      46.0294       0.0737       0.1160       5.4625    2663.8069      36.5022     193.5000    2051.0000
  683.8188      74.9856      71.1310      91.9296     133.0775     134.6651       7.4258     311.0000       0.0405       0.0056       4.2023      31.7760     358.8779     140.9481      46.0294       0.0727       0.1147       5.3927    2640.7483      41.7837     193.2500    2034.0000
  683.9712      80.9522      66.9281      84.6873     126.6028     122.3023       8.1765     311.0000       0.0576       0.0234       4.6346      31.7436     348.4979     118.1731      46.0294       0.0698       0.1117       5.3283    2611.4700      34.9809     193.5000    1996.0000
  684.1236      79.8355      81.3523      99.0741     129.5462     140.6029       7.1122     311.0000       0.0657       0.0317       4.4650      33.8087     346.5858     105.6781      46.0294       0.0608       0.1014       5.2989    2597.6970      37.4459     192.1875    2034.0000
  684.2760      81.4165     100.6561     114.1174     150.1627     159.7739       6.2588     311.0000       0.0607       0.0266       4.2358      34.9062     341.9421     103.7450      46.0294       0.0605       0.1011       5.3234    2606.1638      36.0984     193.4375    2100.0000
  684.4284      72.5227      99.7189     117.2224     145.6671     151.5243       6.5996     311.0000       0.0569       0.0226       4.4329      32.6225     334.8401     115.4962      46.0294       0.0504       0.0898       5.4598    2612.6379      38.0421     193.2500    2083.0000
  684.5808      67.6878      77.4856      89.3421     120.0468     128.4563       7.7847     311.0000       0.0763       0.0427       4.5897      32.1604     335.9327     121.8765      46.0294       0.0538       0.0936       5.6586    2579.5449      34.2344     193.5000    2093.0000
  684.7332      71.9441      78.5843      89.5241     114.9415     113.3137       8.8251     311.0000       0.0939       0.0610       4.3134      34.0063     340.3032     131.2316      46.0294       0.0587       0.0994       5.8173    2549.3894      19.6547     193.5000    2089.0000
  684.8856      70.6734      82.6637      91.2934     124.4667     119.3107       8.3815     311.0000       0.0850       0.0518       3.9052      31.9217     348.4979     145.5734      46.0294       0.0633       0.1045       5.8406    2564.5664      16.8837     193.5000    2063.0000
  685.0380      75.0845      92.8212     104.0532     135.2435     131.2417       7.6195     311.0000       0.0705       0.0367       4.5063      29.5067     347.9516     149.3423      46.0294       0.0790       0.1221       5.7782    2589.3672      17.2127     193.5000    2068.0000
  685.1904      74.5295      83.0889     101.5849     132.9657     131.2917       7.6166     311.0000       0.0558       0.0215       4.4359      27.0265     338.6642     145.5913      46.0294       0.0776       0.1205       5.6593    2614.5422      24.1384     192.8125    2084.0000
  685.3428      70.8950      65.9577      81.5578     111.3704     112.6986       8.8732     311.0000       0.0591       0.0249       4.4997      32.6374     339.2105     136.9159      46.0294       0.0755       0.1185       5.5515    2608.9568      27.2204     192.9375    2085.0000
  685.4952      78.5659      68.8939      81.9803     105.3630     112.1731       8.9148     311.0000       0.0501       0.0156       4.5011      34.5633     329.9232     134.5439      46.0294       0.0743       0.1171       5.4420    2624.2903      26.9280     189.9375    2118.0000
  685.6476     104.0151      81.5217      89.1144     108.1548     118.4249       8.4442     311.0000       0.0434       0.0086       4.4670      36.8404     343.5811     134.6974      46.0294       0.0704       0.1119       5.3946    2635.8113      33.4002     188.6250    2055.0000
  685.8000     115.0673     111.0835     120.6507     128.7747     134.1046       7.4569     311.0000       0.0326      -0.0026       4.3287      35.5978     351.2295     140.1753      46.0294       0.0463       0.0853       5.4243    2654.3330      46.8032     189.5625    2078.0000
  685.9524      89.4704      89.4158      89.7744      99.4299     124.3119       8.0443     311.0000       0.0363       0.0013       4.2658      37.4508     347.9516     154.9504      46.0294       0.0565       0.0958       5.5410    2647.8926      55.6230     191.3125    2016.0000
  686.1048      80.9689      88.3963      90.7200     102.7865     100.8064       9.9200     311.0000       0.0432       0.0084       4.4852      36.8209     359.9705     188.0114      46.0294       0.0569       0.0967       5.7389    2636.1289      35.2554     190.0625    2010.0000
  686.2572      68.4081      81.0688      87.1810      93.9859      87.1513      11.4743     311.0000       0.0704       0.0366       4.3796      36.6496     359.4242     208.0693      46.0294       0.0490       0.0883       5.9499    2589.6318      18.7502     190.1250    2061.0000
  686.4096      67.4260      78.8476      87.6263     102.0321      87.7700      11.3934     311.0000       0.0721       0.0384       4.4317      32.6518     336.4790     230.0687      46.0294       0.0599       0.1009       6.0787    2586.6926      14.2877     190.6875    2051.0000
  686.5620      68.0701      76.1900      85.6199      97.8065      82.6024      12.1062     311.0000       0.0608       0.0267       4.0731      32.1626     341.9421     228.8024      46.0294       0.0623       0.1039       6.0580    2605.9619      15.1233     190.3125    2068.0000
  686.7144      65.6970      72.5555      85.2214     112.7563      91.9266      10.8782     311.0000       0.0483       0.0137       4.5224      31.5467     360.7900     205.3366      46.0294       0.0821       0.1253       5.9208    2627.4458      19.6286     189.8125    2025.0000
  686.8668      74.0722      62.0321      91.8503     127.8910     106.9631       9.3490     311.0000       0.0354       0.0003       4.6207      35.2165     356.6926     175.6413      46.0294       0.0872       0.1315       5.7447    2649.4348      25.2743     189.0000    2006.0000
  687.0192      77.6726      57.1971      83.2827     137.1022     111.4207       8.9750     311.0000       0.0374       0.0024       4.3437      37.0694     367.0726     150.1322      46.0294       0.0908       0.1354       5.6495    2646.0471      30.4178     188.7500    2006.0000
  687.1716      79.0740      54.5947      80.9367     132.7333     121.1767       8.2524     311.0000       0.0369       0.0018       4.2940      36.0545     360.7900     144.8627      46.0294       0.0943       0.1394       5.6039    2646.9856      35.9945     188.9375    2000.0000
  687.3240      90.0872      68.6205     100.6634     161.4330     156.1912       6.4024     311.0000       0.0402       0.0053       4.4793      38.2354     355.6000     155.4768      46.0294       0.0903       0.1348       5.5799    2641.1729      31.0248     187.1875    2023.0000
  687.4764      93.5826     103.5333     108.8373     156.7526     156.8309       6.3763     311.0000       0.0324      -0.0027       4.4574      36.8716     362.7021     164.4249      46.0294       0.0726       0.1156       5.4634    2654.5347      25.5560     187.6875    2084.0000
  687.6288      97.8788     109.0399     124.7352     136.0938     134.2224       7.4503     311.0000       0.0173      -0.0184       4.3915      38.2704     341.9421     171.8793      46.0294       0.0699       0.1123       5.3039    2680.4080      26.3325     187.8750    2087.0000
  687.7812      78.4094      66.1814      77.2491      98.3182     105.2787       9.4986     311.0000       0.0245      -0.0110       4.6991      33.2302     347.4053     157.4948      46.0294       0.0731       0.1158       5.1812    2668.0703      25.9250     187.3125    2098.0000
  687.9336      67.1873      45.7895      48.7504      59.5663      58.0774      17.2184     311.0000       0.0341      -0.0010       4.6807      33.0276     357.7852     155.9405      46.0294       0.0829       0.1261       5.1432    2651.7100      32.6500     186.9375    2104.0000
  688.0860      66.8469      53.4888      61.5119      72.7606      66.8822      14.9517     311.0000       0.0554       0.0210       4.2960      30.4525     356.6926     166.5444      46.0294       0.0648       0.1072       5.1957    2615.3416      26.2597     186.9375    2060.0000
  688.2384      56.6069      59.2533      76.2885      96.1450      79.8292      12.5267     311.0000       0.0878       0.0546       4.5563      38.9956     344.6737     176.9474      46.0294       0.0684       0.1118       5.2419    2559.9111      22.8979     186.4375    2084.0000
  688.3908      36.0333      44.6662      40.5761      49.6894      45.2991      22.0755     311.0000       0.1351       0.1037       4.6954      54.8495     362.7021     170.7940      46.0294       0.1052       0.1522       5.2110    2478.9502      11.3226     185.4375    2059.0000
  688.5432      30.8493      29.8994      31.3448      30.5587      28.7077      34.8339     311.0000       0.1429       0.1117       4.7999      73.8423     380.4573     170.2032      46.0294       0.1801       0.2317       5.0300    2465.7249      10.7865     183.7500    2028.0000
  688.6956      34.6158      30.2378      43.4544      42.3201      40.5858      24.6391     311.0000       0.1421       0.1109       4.6144      82.1520     356.6926     173.8505      46.0294       0.2064       0.2585       4.8756    2467.0132      10.5712     183.7500    2030.0000
  688.8480      35.5401      37.0438      44.6785      50.2390      48.3738      20.6723     311.0000       0.1724       0.1423       4.5134      86.8208     364.8874     174.0699      46.0294       0.2269       0.2789       4.9291    2415.1433      10.8270     183.7500    2055.0000
  689.0004      33.2352      32.8733      33.3756      36.6534      37.5569      26.6263     311.0000       0.2205       0.1922       4.4631      83.9764     374.1747     169.5809      46.0294       0.2282       0.2799       5.1343    2332.8916       6.0808     183.3750    2040.0000
  689.1528      39.3192      25.8025      29.0084      33.0421      36.9397      27.0711     311.0000       0.2020       0.1730       4.6113      82.1235     377.9989     190.5370      46.0294       0.2807       0.3322       5.1623    2364.5544       6.4135     182.1875    2016.0000
  689.3052      50.5391      38.2925      50.6710      61.1754      71.2812      14.0290     311.0000       0.1441       0.1130       4.6824      75.7837     355.6000     209.8985      46.0294       0.2269       0.2783       4.9387    2463.5181       8.7817     183.6875    2040.0000
  689.4576      79.6345      71.7068      88.2199     102.8908     103.7918       9.6347     311.0000       0.0861       0.0529       4.6098      71.2628     355.0537     216.6731      46.0294       0.1825       0.2332       4.5894    2562.7383      15.6462     181.3750    2087.0000
  689.6100      81.9520      78.0507     133.1947     132.4534     140.2032       7.1325     311.0000       0.0977       0.0648       4.4193      69.0276     359.4242     184.2384      46.0294       0.2020       0.2536       4.3848    2543.0005      15.3031     181.6250    2032.0000
  689.7624      80.6541      91.3779     114.2677     178.3928     192.8960       5.1841     311.0000       0.0963       0.0635       4.5642      64.6088     373.6284     173.4569      46.0294       0.2263       0.2787       4.2766    2545.2708      16.0886     180.6250    2022.0000
  689.9148      75.0270      89.7266     112.2426     172.7030     181.5549       5.5080     311.0000       0.0974       0.0646       4.8822      63.4041     364.8874     179.9874      46.0294       0.1997       0.2510       4.2926    2543.4170      19.9755     180.4375    2033.0000
  690.0672      67.1544      88.5294      97.5040     140.4910     162.3218       6.1606     311.0000       0.0736       0.0399       4.6037      60.4006     357.7852     196.6703      46.0294       0.1839       0.2349       4.3247    2584.1799      22.7000     179.4375    2025.0000
  690.2196      57.6483      66.9651      83.5758     113.4399     122.1256       8.1883     311.0000       0.0658       0.0318       4.6494      63.6037     356.6926     201.2138      46.0294       0.2175       0.2691       4.4267    2597.5535      18.5865     178.9375    2053.0000
  690.3720      45.0909      42.7986      51.0724      65.5552      76.7146      13.0353     311.0000       0.0673       0.0334       4.4472      66.4332     376.0868     194.2809      46.0294       0.2276       0.2800       4.6027    2594.9312      16.8037     175.9375    2048.0000
  690.5244      51.1178      37.5881      43.6505      53.7023      62.8919      15.9003     311.0000       0.0711       0.0373       4.6729      66.6001     370.8969     193.4695      46.0294       0.2019       0.2539       4.8846    2588.4233      15.9765     177.1250    2028.0000
  690.6768      56.2157      48.0367      57.4360      73.0925      79.2503      12.6182     311.0000       0.0584       0.0241       5.0060      60.0633     368.9847     201.3226      46.0294       0.1638       0.2146       5.2152    2610.1990      21.9281     175.8750    2067.0000
  690.8292      66.9706      63.7816      74.3515      93.6272     100.2573       9.9743     311.0000       0.0344      -0.0007       4.6329      52.4234     356.1463     201.3044      46.0294       0.1046       0.1513       5.4603    2651.1750      32.8763     175.1875    2056.0000
  690.9816      58.8833      78.3569      97.7383     112.8997     119.4091       8.3746     311.0000       0.0223      -0.0133       4.3974      43.1218     357.7852     192.9772      46.0294       0.0521       0.0933       5.5889    2671.9377      42.2374     175.6250    2062.0000
  691.1340      61.5478      69.1265      91.1351     124.0280     120.6775       8.2865     311.0000       0.0276      -0.0077       4.7754      37.3313     346.8590     183.9559      46.0294       0.0516       0.0916       5.6316    2662.7332      42.6122     175.4375    2071.0000
  691.2864      59.6865      61.6337      75.4631     104.7074      98.6606      10.1358     311.0000       0.0423       0.0074       4.9731      37.1579     353.9611     190.9411      46.0294       0.0676       0.1091       5.6830    2637.7505      31.5985     174.9375    2054.0000
  691.4388      59.5708      60.8713      76.0318      97.8408      86.2038      11.6004     311.0000       0.0418       0.0070       4.4017      38.7923     362.9753     212.7619      46.0294       0.0809       0.1235       5.7238    2638.4946      28.3403     174.0000    2052.0000
  691.5912      67.2189      60.5795      76.3110      94.6203      90.1123      11.0973     311.0000       0.0340      -0.0011       4.4387      42.0298     353.9611     232.6739      46.0294       0.0720       0.1143       5.7378    2651.8088      26.1730     174.0000    2102.0000
  691.7436      67.3385      74.2341      85.6936     108.0391     111.7827       8.9459     311.0000       0.0112      -0.0248       4.7461      40.5822     355.0537     248.8735      46.0294       0.0707       0.1127       5.6652    2690.8567      27.4322     172.8750    2108.0000
  691.8960      76.3760      85.0451     102.7358     139.7200     145.2628       6.8841     311.0000      -0.0051      -0.0416       4.7160      42.9282     362.7021     251.8127      46.0294       0.0617       0.1029       5.5767    2718.6721      36.4603     172.1250    2081.0000
  692.0484      76.8577      99.7293     128.1595     154.0726     208.5110       4.7959     311.0000      -0.0112      -0.0480       4.5724      46.9528     367.6189     241.6017      46.0294       0.0572       0.0982       5.4616    2729.2236      53.3689     170.1250    2112.0000
  692.2008      73.8257      92.8816     122.7964     185.2965     232.7318       4.2968     311.0000       0.0045      -0.0316       4.6914      52.2259     355.0537     231.4429      46.0294       0.0685       0.1107       5.4162    2702.2209      58.1208     169.5625    2096.0000
  692.3532      74.9528      97.6512     128.8275     227.3490     271.2720       3.6863     311.0000       0.0258      -0.0096       4.8776      57.1420     352.8684     225.1570      46.0294       0.0822       0.1262       5.3971    2665.8467      48.0190     166.7500    2089.0000
  692.5056     106.0406     139.5027     175.1229     238.0329     310.1092       3.2247     311.0000       0.0233      -0.0122       4.5979      55.5533     364.8874     234.6647      46.0294       0.1105       0.1568       5.3445    2670.0835      47.8181     165.3750    2088.0000
  692.6580      98.1251     128.4903     173.5917     238.2544     300.5716       3.3270     311.0000       0.0148      -0.0210       4.6353      62.9651     350.6832     230.1617      46.0294       0.0790       0.1235       5.1454    2684.7041      51.5953     165.7500    2063.0000
  692.8104      81.1831      89.5332     121.3189     174.8859     229.0591       4.3657     311.0000       0.0047      -0.0315       4.5493      77.8189     350.6832     214.6437      46.0294       0.0979       0.1441       4.7672    2702.0049      48.1738     166.7500    2109.0000
  692.9628      69.6912      72.9673      96.6875     124.4045     169.6235       5.8954     311.0000       0.0162      -0.0196       4.7270      89.0537     337.5716     182.7772      46.0294       0.1618       0.2123       4.3181    2682.3047      45.2775     165.9375    2103.0000
  693.1152      73.6691      72.6816      93.0827     119.0954     165.1511       6.0551     311.0000       0.0296      -0.0057       4.7465      88.5749     332.1085     142.0481      46.0294       0.1577       0.2081       3.8956    2659.4377      45.0862     164.8125    2067.0000
  693.2676      83.4433      86.7189     102.4144     126.4905     165.3757       6.0468     311.0000       0.0341      -0.0010       4.8139      78.9666     330.4695     106.3547      46.0294       0.1185       0.1667       3.5736    2651.6082      61.9183     164.8750    2087.0000
  693.4200      94.7677     106.8483     116.7070     130.4935     157.4398       6.3516     311.0000       0.0386       0.0036       4.7394      72.5622     323.3674      74.5285      46.0294       0.1150       0.1627       3.3590    2644.0276      91.7694     164.1875    2070.0000
  693.5724     114.5162     134.0331     156.6010     184.4369     181.3474       5.5143     311.0000       0.0494       0.0148       4.7052      65.0162     320.9090      45.6531      46.0294       0.1021       0.1486       3.2088    2625.5771     141.9761     165.1875    2166.0000
  693.7248     115.2619     162.5031     153.6781     164.7084     157.8094       6.3368     311.0000       0.0618       0.0276       4.8498      56.2474     319.5432      24.3249      46.0294       0.1070       0.1536       3.1091    2604.4036     164.1867     164.8125    2151.0000
  693.8772     107.1932     152.7341     151.2568     158.0639     143.6493       6.9614     311.0000       0.0754       0.0418       4.5857      54.6265     320.9090       7.5488      46.0294       0.0961       0.1413       3.0968    2581.0305     169.7887     164.1875    2077.0000
  694.0296      99.7765     121.2157     121.6324     124.9116     114.5100       8.7329     311.0000       0.0844       0.0511       4.8369      52.4601     318.9969       5.4402      46.0294       0.0664       0.1090       3.2637    2565.6077      94.1910     162.9375    2052.0000
  694.1820      98.5340     102.1466      99.1535     104.7626      90.9432      10.9959     311.0000       0.0790       0.0455       4.7898      57.2367     318.4506      28.9745      46.0294       0.0645       0.1063       3.6449    2574.9099      84.6461     163.8125    2036.0000
  694.3344     111.4779     126.0811     133.9859     130.1120     121.8804       8.2048     311.0000       0.0514       0.0169       4.6472      54.6075     323.3674      62.9270      46.0294       0.0711       0.1128       3.9948    2622.1584      81.8339     159.9375    2040.0000
  694.4868     132.4451     139.7401     172.9826     148.7297     164.7229       6.0708     311.0000       0.0152      -0.0207       4.5346      59.2451     331.0158      96.8449      46.0294       0.0535       0.0937       4.1480    2684.0815     149.7135     158.8125    2062.0000
  694.6392     124.5497     145.4041     172.8178     195.6382     177.9179       5.6206     311.0000       0.0050      -0.0312       4.6841      60.8690     321.7285      96.5540      46.0294       0.0691       0.1113       4.0487    2701.4099     172.2349     156.6250    2076.0000
  694.7916     114.9760     119.7237     156.1333     188.7211     180.8008       5.5309     311.0000       0.0185      -0.0172       4.6111      66.1963     320.6359      75.7246      46.0294       0.0907       0.1355       3.8801    2678.3660     180.7847     156.8125    2071.0000
  694.9440     112.4967     117.3072     148.5544     189.2910     176.8790       5.6536     311.0000       0.0271      -0.0083       4.7595      66.5617     321.7285      66.6382      46.0294       0.0816       0.1260       3.7791    2663.6907     132.7182     156.5000    2068.0000
  695.0964      94.4280     108.6225     134.3302     183.7563     161.0100       6.2108     311.0000       0.0433       0.0085       4.7597      64.8034     323.3674      44.0843      46.0294       0.1043       0.1504       3.7180    2636.0393     129.9926     157.5625    2089.0000
  695.2488      86.0522      94.2418     126.4373     178.6098     153.5816       6.5112     311.0000       0.0458       0.0111       4.6123      67.7785     327.1916      32.9359      46.0294       0.1124       0.1589       3.8014    2631.6082      97.3661     156.2500    2139.0000
  695.4012     105.2580     123.5943     169.0704     284.8109     234.3887       4.2664     311.0000       0.0518       0.0173       4.5726      61.8491     334.0206       6.5937      46.0294       0.1296       0.1765       4.0279    2621.4111     123.0397     154.4375    2086.0000
  695.5536     156.9900     191.7166     275.6103     400.3737     339.0207       2.9497     311.0000       0.0334      -0.0017       4.8937      52.0178     325.5527       2.7549      46.0294       0.0452       0.0829       4.4205    2652.8379     180.4757     154.4375    2059.0000
  695.7060     200.1988     348.7730     446.9019     634.5322     526.2094       1.9004     311.0000       0.0205      -0.0151       4.7543      34.2369     326.0990      -0.8891      46.0294       0.0017       0.0315       4.7946    2674.8782     756.4606     154.4375    2088.0000
  695.8584     211.0891     399.2319     649.9134     891.3221     745.5167       1.3414     311.0000       0.0145      -0.0213       4.7162      26.9965     326.6453      -2.4967      46.0294      -0.0113       0.0144       5.0418    2685.2122    3300.2788     153.1250    2087.0000
  696.0108     236.0660     419.6326     914.3823    1119.1362     880.2473       1.1360     311.0000       0.0010      -0.0354       4.5888      26.5939     327.7379       5.4195      46.0294      -0.0131       0.0115       5.1219    2708.3608    2273.1404     153.7500    2091.0000
  696.1632     227.2090     356.3847    1038.5626    1129.1514     842.4958       1.1869     311.0000      -0.0206      -0.0577       4.4894      29.8083     329.6501      22.2850      46.0294      -0.0060       0.0194       5.1420    2745.2563    1513.9387     150.9375    2098.0000
  696.3156     210.5792     373.2068    1046.6469    1190.6696     798.6868       1.2521     311.0000      -0.0257      -0.0630       4.9217      32.2601     331.0158      23.7002      46.0294      -0.0049       0.0210       5.1043    2753.9302    1254.3446     150.3750    2109.0000
  696.4680     185.6531     384.3857    1163.0656    1273.6488     783.2773       1.2767     311.0000      -0.0109      -0.0477       4.5651      32.2601     331.0158      13.9730      46.0294       0.0053       0.0322       5.0989    2728.6980    1260.3204     148.6875    2073.0000
  696.6204     180.7985     321.6803    1051.8007    1221.3163     707.7021       1.4130     311.0000       0.0137      -0.0222       4.6337      29.4182     333.2011      -3.0289      46.0294      -0.0040       0.0221       5.0622    2686.6064    1526.4595     148.8750    2069.0000
  696.7728     159.5446     266.7921     831.6645    1030.0022     519.4534       1.9251     311.0000       0.0177      -0.0181       4.7139      28.8795     334.2937      -3.1812      46.0294      -0.0063       0.0194       5.0158    2679.8157    1493.4103     148.1250    2124.0000
  696.9252     177.0478     306.7280     942.7210    1456.1764     494.7062       2.0214     311.0000       0.0137      -0.0222       4.8173      29.2821     333.7474      -1.0176      46.0294       0.0026       0.0292       4.9171    2686.5574    1659.1583     148.8125    2128.0000
  697.0776     180.4791     362.4692    1119.5421    1555.8322     749.4064       1.3344     311.0000       0.0135      -0.0223       4.5964      30.7666     333.7474       0.5896      46.0294      -0.0008       0.0256       4.8790    2686.8477    1684.6631     148.8750    2111.0000
  697.2300     183.1945     384.5872    1310.8088    1771.7880     957.9733       1.0439     311.0000       0.0121      -0.0238       4.5484      31.6900     335.3864      11.8165      46.0294      -0.0051       0.0212       4.9364    2689.2783    2603.2078     149.3125    2094.0000
  697.3824     167.5730     326.9027    1646.3016    1928.6520     760.1646       1.3155     311.0000      -0.0004      -0.0368       4.5319      30.0691     337.5716      36.5884      46.0294      -0.0013       0.0250       5.0588    2710.6460    1643.4993     152.6250    2099.0000
  697.5348     154.0306     313.9713     943.3524    1902.6191     915.3047       1.0925     311.0000      -0.0128      -0.0496       4.7237      27.0362     337.5716      55.6028      46.0294      -0.0035       0.0230       5.1166    2731.8223     908.6225     151.4375    2104.0000
  697.6872     185.4624     227.0287    1050.3004    1829.2366    1147.6748       0.8713     311.0000      -0.0305      -0.0679       4.7917      26.6515     345.2200      70.0586      46.0294      -0.0016       0.0251       5.1260    2762.0818     567.1384     152.0625    2125.0000
  697.8396     206.5322     214.1015     809.6169    1537.6807    1056.6260       0.9464     311.0000      -0.0175      -0.0545       4.7482      28.1014     348.4979      46.2043      46.0294       0.0024       0.0290       5.0723    2739.9097     708.4208     153.8125    2072.0000
  697.9920     262.3497     207.8262     606.1766    1135.2599     860.2392       1.1625     311.0000      -0.0128      -0.0497       4.5439      31.2738     336.4790      28.3282      46.0294      -0.0062       0.0196       5.0203    2731.9692     913.3059     154.4375    2075.0000
  698.1444     214.1597     170.6965     428.8938     741.9847     598.2626       1.6715     311.0000       0.0133      -0.0226       4.4279      30.6455     337.5716       2.6124      46.0294      -0.0008       0.0249       5.0096    2687.3267    1097.9844     154.4375    2047.0000
  698.2968     173.9222     146.1266     308.0776     466.2377     387.3400       2.5817     311.0000       0.0186      -0.0170       4.8041      29.9704     341.9421       5.2209      46.0294      -0.0029       0.0229       5.0010    2678.1094     875.6978     154.6875    2081.0000
  698.4492     131.1625     146.5011     223.2255     329.1678     290.9198       3.4374     311.0000       0.0203      -0.0153       4.7394      28.1276     347.9516      10.4525      46.0294      -0.0045       0.0212       4.9745    2675.2871     677.8425     154.4375    2101.0000
  698.6016     104.9538     133.4298     193.8175     230.5668     200.9326       4.9768     311.0000       0.0118      -0.0241       4.4394      31.6915     339.7569      10.9584      46.0294      -0.0129       0.0134       4.8693    2689.7983     810.6743     157.9375    2101.0000
  698.7540      78.4814     123.8742     207.1317     181.0656     143.4260       6.9722     311.0000      -0.0066      -0.0432       4.4449      35.9819     338.6642      15.4128      46.0294      -0.0049       0.0246       4.7187    2721.2441     824.3801     161.5625    2087.0000
  698.9064      55.5751     101.1257     123.6838     122.1705     120.9226       8.2698     311.0000      -0.0136      -0.0505       4.7918      44.6487     340.3032      19.4676      46.0294       0.0341       0.0703       4.4697    2733.3208     245.3890     164.0000    2036.0000
  699.0588      48.7655      53.1732      69.8202      76.9527      70.2382      14.2373     311.0000      -0.0171      -0.0541       4.9172      50.6076     339.2105      37.1544      46.0294       0.1140       0.1599       4.1960    2739.3223      72.2471     164.1875    2068.0000
  699.2112      38.2633      38.6634      49.5873      54.8223      50.4456      19.8233     311.0000      -0.0058      -0.0424       4.7923      61.1210     343.0348      54.9722      46.0294       0.1982       0.2499       4.0426    2719.9460      42.2634     164.1875    2121.0000
  699.3636      48.7497      34.1456      41.8890      49.0941      42.8646      23.3293     311.0000       0.0082      -0.0279       4.8012      62.6197     347.4053      57.8403      46.0294       0.2004       0.2527       4.0670    2695.9907      37.6009     164.6875    2084.0000
  699.5160      57.5839      45.8022      60.7758      80.3795      68.6107      14.5750     311.0000       0.0181      -0.0176       4.5365      59.9035     347.4053      49.5231      46.0294       0.1323       0.1811       4.2457    2678.9639      51.0657     165.8125    2056.0000
  699.6684      72.7678      64.5073      91.5138     122.0190     111.8143       8.9434     311.0000       0.0146      -0.0212       4.5343      55.0994     350.6832      38.1243      46.0294       0.0833       0.1275       4.4500    2685.0510      72.6786     166.7500    2096.0000
  699.8208      94.2595      92.4698     142.4344     180.9899     158.5821       6.3059     311.0000      -0.0047      -0.0412       4.4365      54.6934     355.0537      38.8575      46.3091       0.0507       0.0908       4.5768    2718.0190      99.6578     167.9375    2100.0000
  699.9732      96.3368     172.0163     156.2430     205.7480     167.8363       5.9582     311.0000      -0.0076      -0.0442       4.6747      53.5353     349.0442      33.8769      46.3091       0.0442       0.0834       4.5151    2722.9502     126.2702     170.1250    2052.0000
  700.1256      68.1604     173.8814     123.7386     195.0770     161.5336       6.1907     311.0000       0.0144      -0.0215       4.5836      57.3489     345.2200      21.4207      46.3091       0.0441       0.0835       4.2652    2685.3977     210.1427     170.4375    2079.0000
  700.2780      61.3691     110.8615     145.4633     176.7014     141.6287       7.0607     311.0000       0.0346      -0.0005       4.8411      65.7729     343.5811      35.2230      46.3091       0.0636       0.1057       3.9596    2650.7805     128.6964     171.3125    2096.0000
  700.4304      48.1991      59.1959      69.6547     106.9743      83.7288      11.9433     311.0000       0.0380       0.0030       4.6033      79.5752     375.2673      61.0812      46.3091       0.1232       0.1705       3.7095    2645.0039      54.2038     171.6250    2062.0000
  700.5828      48.8043      32.0831      43.0115      62.1560      45.7714      21.8477     311.0000       0.0253      -0.0102       4.5133      88.2092     352.8684      84.9419      46.3091       0.1690       0.2200       3.5608    2666.7576      43.1689     173.5000    2080.0000
  700.7352      54.2123      45.8371      65.3635      75.3177      60.8158      16.4431     311.0000       0.0239      -0.0116       4.5520      94.3392     349.0442      77.3690      46.3091       0.1768       0.2282       3.4777    2669.1213      47.4238     174.0000    2139.0000
  700.8876      57.0936      70.1608      91.9255     126.5635     109.2678       9.1518     311.0000       0.0176      -0.0181       4.7245     100.2818     351.2295      85.5968      46.3091       0.1372       0.1868       3.4668    2679.8367      59.1748     174.1250    2134.0000
  701.0400      51.5754      69.3169     116.5277     140.1459     110.2362       9.0714     311.0000       0.0181      -0.0176       4.7122     103.2928     368.7115     102.7803      46.0294       0.1477       0.1978       3.5152    2679.0012      46.5717     174.0000    2095.0000
  701.1924      56.1433      60.4874      72.6780     120.9052     121.0208       8.2630     311.0000       0.0112      -0.0247       4.5484     102.3393     349.5905     119.0374      46.3091       0.1823       0.2339       3.5855    2690.8130      41.6963     174.0000    2105.0000
  701.3448      54.7859      47.0799      63.6395      93.7280      83.6569      11.9536     311.0000       0.0035      -0.0328       4.7748      97.8813     353.4147     115.0277      46.3091       0.1779       0.2293       3.6308    2704.0569      35.6105     174.5625    2075.0000
  701.4972      54.5966      52.7521      77.4188     106.2428      80.7509      12.3838     311.0000      -0.0092      -0.0459       4.4583      96.0232     352.8684     104.1162      46.3091       0.1584       0.2090       3.6679    2725.7412      41.2069     174.8125    2098.0000
  701.6496      56.9746      61.4395      88.1072     122.4892     105.6588       9.4644     311.0000      -0.0135      -0.0504       4.4578      93.5690     354.5074      95.8369      46.3091       0.1277       0.1766       3.7567    2733.1453      46.7367     174.0000    2073.0000
  701.8020      49.3677      52.2408      71.8234     103.2752      94.9227      10.5349     311.0000      -0.0095      -0.0462       4.4279      88.2834     359.9705      88.8126      46.3091       0.1225       0.1709       3.9422    2726.2649      60.7492     174.0000    2095.0000
  701.9544      42.2618      46.1023      60.6935      79.5156      71.3522      14.0150     311.0000       0.0085      -0.0275       4.9297      75.3179     369.2579      82.6130      46.3091       0.1120       0.1593       4.2014    2695.4517      44.8141     174.0000    2089.0000
  702.1068      50.0065      50.4455      64.7976      75.4740      75.4162      13.2598     311.0000       0.0318      -0.0034       4.9620      65.9609     367.6189      73.8924      46.3091       0.0955       0.1409       4.4573    2655.6621      38.4706     174.0000    2059.0000
  702.2592      60.1332      57.5354      74.1551      94.4236      89.2117      11.2093     311.0000       0.0379       0.0029       4.5574      55.2975     371.9894      72.0565      46.3091       0.0959       0.1407       4.6488    2645.2222      35.7440     174.0000    2085.0000
  702.4116      67.6206      66.0528      88.7645     118.0726     105.7370       9.4574     311.0000       0.0179      -0.0178       4.2865      49.3585     369.8042      74.4557      46.3091       0.0635       0.1043       4.7485    2679.3318      49.0916     173.5000    2084.0000
  702.5640      60.3766      60.7030      83.2202     122.1192     105.0683       9.5176     311.0000      -0.0119      -0.0486       4.6343      42.2705     384.0084      82.9792      46.3091       0.0352       0.0718       4.7931    2730.2700      66.9177     172.5000    2081.0000
  702.7164      57.7925      56.5595      83.1015     119.5554     103.5541       9.6568     311.0000      -0.0270      -0.0643       4.7444      40.1208     373.0821      76.9184      46.3091       0.0232       0.0575       4.7623    2756.1165      87.6949     173.4375    2091.0000
  702.8688      55.2505      61.3323      88.6836     133.7218     107.5781       9.2956     311.0000      -0.0188      -0.0558       4.5724      39.6032     370.3505      54.3687      46.3091       0.0235       0.0582       4.6659    2742.0632      89.3125     172.5000    2072.0000
  703.0212      54.1884      68.3652      96.0442     146.5423     120.0322       8.3311     311.0000      -0.0048      -0.0413       4.5336      40.8154     380.4573      37.3328      46.3091       0.0335       0.0696       4.5938    2718.1636      74.1999     171.2500    2069.0000
  703.1736      52.7053      70.8189      94.9817     142.2858     109.7176       9.1143     311.0000       0.0112      -0.0248       4.7631      44.2909     384.0084      56.7477      46.3091       0.0444       0.0830       4.6031    2690.8623      73.4868     169.6875    2095.0000
  703.3260      48.9818      53.0861      85.4753     134.7679     111.0144       9.0078     311.0000       0.0105      -0.0255       4.4621      51.6740     376.3600     107.9941      46.3091       0.0744       0.1166       4.6598    2692.0149      40.4341     169.8750    2048.0000
  703.4784      41.6150      36.2573      56.4593      87.0900      67.0702      14.9098     311.0000       0.0089      -0.0272       4.3658      56.9783     384.5547     135.7005      46.3091       0.1272       0.1743       4.6591    2694.8398      32.8591     168.0000    2084.0000
  703.6308      52.2310      36.5508      54.7533      86.1494      57.4258      17.4138     311.0000       0.0094      -0.0267       4.5561      54.4618     377.4526     112.9746      46.3091       0.1383       0.1864       4.6193    2693.9749      31.3045     170.0000    2110.0000
  703.7832      58.6235      53.4645      91.7741     150.0248     113.3914       8.8190     311.0000       0.0224      -0.0132       4.5682      42.7336     376.9063      55.8116      46.3091       0.0647       0.1058       4.6884    2671.7024      58.5805     169.1875    2118.0000
  703.9356      87.1052      97.1028     136.1875     206.2063     156.2890       6.3984     311.0000       0.0289      -0.0064       4.9457      31.7561     382.3694      17.1638      46.3091       0.0144       0.0477       4.8200    2660.5920     171.0259     170.4375    2111.0000
  704.0880      71.8107     119.3223     151.1254     254.2209     188.4626       5.3061     311.0000       0.0378       0.0028       4.6098      29.9294     385.1010       0.2098      46.3091      -0.0020       0.0275       4.9495    2645.3171     226.2501     170.8125    2131.0000
  704.2404      67.9258      86.1939     158.5526     291.6242     204.4083       4.8922     311.0000       0.0482       0.0136       4.3934      30.3346     384.0084      -0.1767      46.3091       0.0090       0.0397       4.9856    2627.5208     144.9027     170.8125    2095.0000
  704.3928      60.2301      72.6324     119.3178     252.4329     179.7125       5.5644     311.0000       0.0576       0.0234       4.3696      31.3213     381.8231       1.5121      46.3091       0.0398       0.0745       4.9359    2611.4697     119.0336     170.9375    2085.0000
  704.5452      51.8019      59.9449      98.3259     211.9973     143.8208       6.9531     311.0000       0.0539       0.0194       4.5966      29.3718     393.8420       4.5004      46.3091       0.0300       0.0655       4.7914    2617.9158      96.0488     171.8125    2046.0000
  704.6976      46.3163      52.7156      84.0522     170.7980     122.6634       8.1524     311.0000       0.0404       0.0055       4.7573      33.8554     383.7352      10.4153      46.3091       0.0440       0.0823       4.6197    2640.8662      93.5670     170.6875    2105.0000
  704.8500      43.6633      49.7036      78.2638     147.4217     129.1067       7.7455     311.0000       0.0212      -0.0144       4.7335      37.3297     402.0368      23.1986      46.3091       0.0684       0.1100       4.4976    2673.7524      74.8558     173.0625    2126.0000
  705.0024      43.8585      47.7776      77.5734     139.0057     149.9129       6.6705     311.0000       0.0116      -0.0243       4.4704      39.1567     395.4810      38.8985      46.3091       0.0982       0.1430       4.4484    2690.1274      60.0337     173.0000    2157.0000
  705.1548      49.5584      52.1320      83.4580     146.1923     181.1486       5.5203     311.0000       0.0081      -0.0280       4.4156      40.4371     397.1199      45.5816      46.3091       0.0971       0.1421       4.3657    2696.1248      48.8692     173.0000    2153.0000
  705.3072      61.0246      57.8021      91.7848     178.7049     218.2919       4.5810     311.0000       0.0246      -0.0109       4.4268      45.0937     388.3789      30.0765      46.3091       0.0764       0.1199       4.2013    2667.9517      57.3416     172.6875    2077.0000
  705.4596      66.0180      66.1426     109.6486     213.0752     267.5406       3.7378     311.0000       0.0331      -0.0021       4.5494      53.7833     384.5547      12.1188      46.3091       0.0705       0.1135       3.8885    2653.4626      78.9996     170.4375    2091.0000
  705.6120      64.1428      65.0486      98.7515     217.4840     255.9344       3.9073     311.0000       0.0388       0.0039       4.6019      60.0136     383.4621      -0.4797      46.3091       0.0863       0.1307       3.5126    2643.6179     121.3672     170.5625    2085.0000
  705.7644      67.2549      68.9162     103.1135     195.5637     237.0688       4.2182     311.0000       0.0244      -0.0111       4.4642      65.5482     390.0178       1.4975      46.3091       0.0872       0.1322       3.1838    2668.2542     113.3696     169.6250    2053.0000
  705.9168      56.5800      59.5513      99.0977     165.7235     179.6774       5.5655     311.0000       0.0217      -0.0139       4.3071      65.1813     373.6284       3.7746      46.3091       0.1213       0.1692       3.0482    2672.9470     110.6532     168.2500    2079.0000
  706.0692      55.7631      61.8725      83.9583     127.6814     129.0854       7.7468     311.0000       0.0268      -0.0086       4.6870      64.0466     373.0821      13.7691      46.3091       0.1233       0.1718       3.1363    2664.1533      76.9708     165.2500    2091.0000
  706.2216      47.6421      59.9694      82.1884     110.4677     113.0291       8.8473     311.0000       0.0291      -0.0062       4.6491      67.2737     374.1747      45.2409      46.3091       0.1226       0.1711       3.3694    2660.1743      54.8222     167.3125    2084.0000
  706.3740      44.2060      45.6919      56.7659      72.1027      65.7445      15.2104     311.0000       0.0261      -0.0093       4.7201      74.9347     387.8326      74.5235      46.3091       0.1467       0.1966       3.6280    2665.3542      44.4447     165.8750    2065.0000
  706.5264      55.5329      38.1407      44.5298      54.2039      49.3166      20.2771     311.0000       0.0167      -0.0191       4.2361      74.5141     378.5452      76.9911      46.3091       0.1773       0.2284       3.8091    2681.5212      43.9842     165.3750    2049.0000
  706.6788      56.8155      53.3529      72.9622      86.8555      69.1409      14.4632     311.0000       0.0231      -0.0125       4.3912      64.5367     375.8137      46.0114      46.3091       0.1115       0.1582       3.9467    2670.5732      57.2421     165.5000    2061.0000
  706.8312      67.5217     102.2484     112.5412     136.1449     111.3246       8.9827     311.0000       0.0243      -0.0112       4.5144      50.9656     377.4526      30.6869      46.3091       0.0345       0.0743       4.1316    2668.4063      84.8791     164.1875    2107.0000
  706.9836      56.7985      78.3273     128.4722     155.4636     136.3284       7.3352     311.0000       0.0176      -0.0181       4.4037      54.5067     375.2673      47.4145      46.3091       0.0448       0.0844       4.2629    2679.8569      62.7050     164.1875    2103.0000
  707.1360      52.6472      60.2450      84.2982     113.5432      86.3682      11.5783     311.0000       0.0174      -0.0183       4.3646      64.2811     377.9989      62.7556      46.3091       0.0998       0.1446       4.2767    2680.2407      37.2462     164.1875    2056.0000
  707.2884      51.1700      51.3857      71.6675      97.7319      66.4019      15.0598     311.0000       0.0306      -0.0046       4.7389      73.7775     377.9989      45.8033      46.3091       0.1343       0.1822       4.2231    2657.6003      31.0728     164.1875    2093.0000
  707.4408      57.8651      54.6612      84.0835     117.8099      79.4122      12.5925     311.0000       0.0390       0.0040       4.7384      66.7168     374.7210      17.0445      46.3091       0.1248       0.1726       4.2497    2643.3901      44.1677     164.1875    2128.0000
  707.5932      61.0392      60.6670     101.1726     160.3223     125.2719       7.9826     311.0000       0.0335      -0.0017       4.8306      54.1963     373.6284       1.0626      46.3091       0.0767       0.1192       4.4057    2652.7617      64.0560     164.0625    2175.0000
  707.7456      66.7463      68.7787     125.0220     220.9476     185.7678       5.3831     311.0000       0.0200      -0.0157       4.3016      41.0695     371.4431       1.8616      46.3091       0.0292       0.0658       4.5941    2675.8506     126.2383     162.0000    2127.0000
  707.8980      68.4936      76.4855     144.7950     282.6582     228.5292       4.3758     311.0000       0.0153      -0.0205       4.3530      41.3037     374.7210       2.8496      46.3091       0.0066       0.0396       4.6286    2683.9004     166.5533     162.1250    2127.0000
  708.0504      58.0327      70.3507     138.7728     350.0785     306.4671       3.2630     311.0000       0.0202      -0.0154       4.6728      48.7099     371.4431       1.8880      46.3091       0.0388       0.0759       4.4495    2675.4143     199.0891     162.4375    2098.0000
  708.2028      52.9761      60.5103     123.9193     407.4644     347.5182       2.8775     311.0000       0.0298      -0.0055       4.5300      57.2460     369.8042       0.6783      46.3091       0.0853       0.1280       4.1735    2659.0208     107.7515     162.5000    2091.0000
  708.3552      51.5094      59.7534     120.8401     510.4319     409.4506       2.4423     311.0000       0.0427       0.0078       4.4335      59.4124     368.1653      -1.1847      46.3091       0.1124       0.1584       4.0666    2637.0613      87.5676     162.3750    2121.0000
  708.5076      54.5918      62.6863     132.6328     690.1124     554.1289       1.8046     311.0000       0.0458       0.0111       4.3196      52.7262     365.9800      -1.4338      46.3091       0.0775       0.1207       4.2038    2631.7229     100.1143     162.2500    2121.0000
  708.6600      65.5846      70.4505     151.1962     863.5493     682.3377       1.4655     311.0000       0.0321      -0.0031       4.6102      47.3573     371.4431       1.3006      46.3091       0.0653       0.1055       4.4334    2655.1199     114.1435     159.5000    2124.0000
  708.8124      75.1281      80.0781     185.4160    1001.4664     796.3306       1.2558     311.0000       0.0155      -0.0203       4.7002      38.8669     369.2579       2.6360      46.3091       0.0546       0.0915       4.6565    2683.5476     140.5897     161.3125    2124.0000
  708.9648      92.5671     108.0691     261.2844     935.7041     833.6319       1.1996     311.0000       0.0029      -0.0333       4.4691      37.4520     364.8874       3.2597      46.3091       0.0098       0.0405       4.8474    2705.0117     244.3185     162.2500    2131.0000
  709.1172     119.5169     148.4563     325.6842     664.2587     646.0073       1.5480     311.0000       0.0010      -0.0353       4.4607      34.4878     367.0726      -1.3504      46.3091      -0.0161       0.0098       4.9667    2708.3047    1153.6805     163.3125    2108.0000
  709.2696     117.7062     159.3521     287.4662     411.9214     398.0460       2.5123     311.0000       0.0047      -0.0315       4.5822      32.7051     375.8137      -0.5505      46.3091      -0.0099       0.0149       5.0287    2701.9448     909.0309     164.1875    2085.0000
  709.4220     109.3341     142.6335     205.9287     243.8783     217.5269       4.5971     311.0000       0.0061      -0.0300       4.3143      30.4930     371.4431       0.7744      46.3091      -0.0117       0.0131       4.9215    2699.5674     766.3091     164.8125    2124.0000
  709.5744      89.4229      88.6181     139.4028     155.6926     129.0319       7.7500     311.0000      -0.0017      -0.0381       4.1526      33.9166     372.5358       7.9343      46.3091      -0.0127       0.0141       4.6478    2712.9172     496.7384     164.8125    2102.0000
  709.7268      63.2847      70.9603     101.4011     102.9964      84.6548      11.8127     311.0000      -0.0182      -0.0552       4.4405      41.8269     362.7021       7.0062      46.3091       0.0349       0.0700       4.1505    2741.0667     111.6070     166.3125    2091.0000
  709.8792      51.9811      57.6827      68.7745      81.0295      60.5521      16.5147     311.0000      -0.0222      -0.0594       4.4568      47.2773     359.4242       2.9871      46.3091       0.1022       0.1464       3.6760    2748.0022      70.2046     168.3125    2111.0000
  710.0316      42.2525      52.3083      59.5940      66.4304      50.2734      19.8912     311.0000      -0.0028      -0.0392       4.2176      60.4835     359.9705      -3.5889      46.3091       0.0996       0.1458       3.3814    2714.7297      51.8872     168.6250    2104.0000
  710.1840      36.0514      49.2111      59.1258      69.0420      50.7239      19.7146     311.0000       0.0300      -0.0052       4.3339      80.0684     362.7021       3.2692      46.3091       0.1131       0.1611       3.3659    2658.6177      55.6286     167.9375    2101.0000
  710.3364      42.9755      55.1775      73.2460      85.9529      61.7610      16.1915     311.0000       0.0284      -0.0069       4.5436      98.2125     362.1558      40.9348      46.3091       0.1723       0.2235       3.4902    2661.4546      46.8046     168.8125    2104.0000
  710.4888      45.5391      90.1021      81.8448     106.4289      77.3761      12.9239     311.0000       0.0167      -0.0190       4.0248     101.2153     364.8874      80.9474      46.3091       0.2037       0.2559       3.6489    2681.3647      45.8265     170.7500    2148.0000
  710.6412      53.7956      65.3988     114.3121     132.8611      97.6157      10.2443     311.0000       0.0126      -0.0233       4.1974      96.4110     366.5263     106.3967      46.3091       0.1684       0.2194       3.7836    2688.4277      38.2166     171.2500    2124.0000
  710.7936      50.9833      40.5731      69.2037     118.7923     101.6202       9.8406     311.0000       0.0217      -0.0139       4.4355      93.7898     382.9157     114.6901      46.3091       0.1939       0.2459       3.8740    2672.9421      31.8988     169.8750    2059.0000
  710.9460      55.7931      34.4064      57.2262      97.2016      81.9728      12.1992     311.0000       0.0109      -0.0251       4.4413      85.1188     364.3410     111.4359      46.3091       0.2653       0.3189       3.8829    2691.4077      27.3667     169.7500    2059.0000
  711.0984      70.3661      49.6847      92.1747     152.2257     136.8413       7.3077     311.0000      -0.0251      -0.0623       4.4090      69.1449     358.8779      94.7380      46.3091       0.1384       0.1877       3.7803    2752.8652      35.1477     168.8750    2091.0000
  711.2508      92.2764      83.1779     105.6226     166.1988     149.2104       6.7019     311.0000      -0.0499      -0.0881       4.3473      53.4494     359.4242      61.6148      46.3091       0.0458       0.0871       3.6197    2795.3010      72.8078     169.6875    2103.0000
  711.4032      49.6923      81.1954     154.3652     173.7231     130.6061       7.6566     311.0000      -0.0447      -0.0827       4.0441      52.1690     359.9705      27.7188      46.3091       0.0444       0.0842       3.4418    2786.4585     118.4310     169.5625    2081.0000
  711.5556      45.1590      64.3824      98.1936     133.5677      97.4393      10.2628     311.0000      -0.0221      -0.0593       4.2832      67.2740     362.7021      11.1907      46.3091       0.0620       0.1039       3.3500    2747.8242      78.2021     171.2500    2078.0000
  711.7080      39.3712      46.1116      68.0117      94.2851      71.1725      14.0504     311.0000       0.0006      -0.0358       4.3635      78.1852     365.4337       1.1349      46.3091       0.0913       0.1365       3.2624    2709.0540      57.3246     170.5625    2118.0000
  711.8604      32.0798      39.5979      48.7373      63.6301      48.7172      20.5266     311.0000       0.0152      -0.0206       4.3886      91.9246     369.2579      -0.1941      46.3091       0.1428       0.1921       3.2897    2683.9827      44.4442     170.8125    2099.0000
  712.0128      28.6698      32.1517      38.9957      48.3082      39.2404      25.4839     311.0000       0.0136      -0.0223       4.5138      94.5586     369.2579       1.7955      46.3091       0.1526       0.2027       3.2938    2686.7896      36.5620     172.1875    2083.0000
  712.1652      28.0122      28.2826      33.7029      38.9026      32.6570      30.6213     311.0000       0.0180      -0.0177       4.2094      93.0892     369.2579       0.2918      46.3091       0.1506       0.2007       3.4272    2679.2571      31.7282     172.6250    2118.0000
  712.3176      32.6865      32.8715      45.0022      51.4516      50.5071      19.7992     311.0000       0.0195      -0.0161       4.2601      80.8332     369.8042      -0.5569      46.3091       0.1266       0.1752       3.5676    2676.5757      38.4049     173.3750    2118.0000
  712.4700      37.9361      39.0994      52.9873      63.3392      70.7021      14.1439     311.0000       0.0270      -0.0084       4.4041      77.4546     370.3505      -2.7831      46.3091       0.0982       0.1447       3.6961    2663.8757      42.0220     173.3750    2137.0000
  712.6224      38.9509      40.1008      57.0176      72.7803      85.0154      11.7626     311.0000       0.0217      -0.0138       4.3200      76.5385     375.8137      -2.5554      46.3091       0.1004       0.1467       3.6682    2672.8364      39.3818     171.8125    2131.0000
  712.7748      48.3276      47.7396      67.8215      97.5721     111.2093       8.9921     311.0000       0.0048      -0.0314       4.3762      71.6340     371.1700      -2.8296      46.3091       0.1360       0.1848       3.5662    2701.7607      41.3209     170.4375    2134.0000
  712.9272      60.3515      61.6781      92.4477     146.5712     163.7395       6.1073     311.0000      -0.0151      -0.0520       4.2635      53.3604     374.1747      -3.9356      46.3091       0.1236       0.1716       3.4955    2735.8789      54.8052     168.3125    2180.0000
  713.0796      50.2591      64.7531      96.5419     178.1889     189.6830       5.2720     311.0000      -0.0217      -0.0589       4.4097      42.9812     374.1747      -5.2562      46.3091       0.0768       0.1211       3.5180    2747.1917      84.8211     168.6250    2164.0000
  713.2320      52.1590      70.9491     110.0378     209.7244     189.0377       5.2900     311.0000      -0.0173      -0.0543       4.3740      45.2442     373.0821      -4.0348      46.3091       0.0574       0.0996       3.5600    2739.5249      76.4608     168.6250    2109.0000
  713.3844      54.6437      58.7032      94.4359     209.1836     161.3051       6.1994     311.0000      -0.0082      -0.0449       4.4969      59.6024     373.3552      -2.0905      46.3091       0.0921       0.1370       3.5784    2724.0420      74.3268     166.7500    2115.0000
  713.5368      51.3353      50.2428      73.0346     159.6301     118.2178       8.4590     311.0000      -0.0107      -0.0475       4.2621      66.0777     376.3600      -0.9472      46.3091       0.1096       0.1562       3.5371    2728.3303      62.7055     165.8125    2083.0000
  713.6892      53.0278      47.8203      68.0249     124.8086      90.8539      11.0067     311.0000      -0.0232      -0.0604       4.2340      64.2200     374.7210      -1.5271      46.3091       0.1424       0.1914       3.4694    2749.6138      65.7934     164.9375    2070.0000
  713.8416      53.2048      56.9182      77.2496     120.4026      98.7145      10.1302     311.0000      -0.0326      -0.0701       3.9804      51.0737     377.1794      -3.2477      46.3091       0.1036       0.1502       3.4334    2765.7217      74.6268     164.1875    2097.0000
  713.9940      53.1296      62.9351      84.1799     109.7524      91.8249      10.8903     311.0000      -0.0268      -0.0641       4.3471      47.7869     379.6378      -4.7827      46.3091       0.0813       0.1262       3.4406    2755.7571      90.8951     164.1875    2120.0000
  714.1464      50.4363      76.5752      89.9791     109.6786     106.2753       9.4095     311.0000      -0.0025      -0.0389       4.3196      54.3160     381.8231      -5.3542      46.3091       0.0884       0.1338       3.4576    2714.1938      75.2504     164.1875    2125.0000
  714.2988      43.5656      60.4378      74.1379      95.6498      84.4016      11.8481     311.0000       0.0236      -0.0119       4.2494      72.3043     387.8326      -1.7283      46.3091       0.1125       0.1603       3.4311    2669.6445      56.0690     164.0000    2108.0000
  714.4512      40.8372      41.3466      51.5122      73.0900      73.5785      13.5909     311.0000       0.0320      -0.0032       4.5217      88.0206     390.5641       9.9354      46.3091       0.1808       0.2324       3.4094    2655.2583      39.2529     164.1875    2103.0000
  714.6036      50.2969      35.6122      44.8790      61.5215      52.0031      19.2296     311.0000       0.0294      -0.0059       4.4416      92.6139     397.1199      17.8044      46.3091       0.1936       0.2456       3.4190    2659.6814      36.0854     162.5000    2110.0000
  714.7560      48.5278      31.3302      39.2436      56.1944      42.9917      23.2603     311.0000       0.0220      -0.0135       4.2131      89.1903     395.4810      15.9845      46.3091       0.1751       0.2264       3.5010    2672.2974      35.0828     161.1250    2085.0000
  714.9084      51.4930      50.6970      71.5950      97.2653      79.1314      12.6372     311.0000       0.0247      -0.0108       4.1021      73.5272     385.1010       7.2842      46.3091       0.1525       0.2025       3.7113    2667.7454      50.8775     159.2500    2068.0000
  715.0608      68.3071     109.0541     105.0627     132.8092     100.8515       9.9156     311.0000       0.0211      -0.0145       4.1331      59.6623     388.3789      -0.4070      46.3091       0.0598       0.1026       3.8811    2673.9829      80.3445     159.5625    2093.0000
  715.2132      58.8474     104.4033     143.9049     153.2487     109.3879       9.1418     311.0000       0.0156      -0.0202       4.4096      56.8257     388.9252      -0.0434      46.3091       0.0427       0.0836       3.8734    2683.3491     125.4657     159.0000    2111.0000
  715.3656      54.7930      59.3616      90.4113     139.3937     107.9457       9.2639     311.0000       0.0159      -0.0199       4.3068      71.8278     394.3884       0.0877      46.3091       0.1181       0.1653       3.6667    2682.8955      67.2734     158.8125    2164.0000
  715.5180      64.8583      49.3993      78.2973     117.5785      83.1855      12.0213     311.0000       0.0261      -0.0094       4.3073      88.8130     400.3978       0.8020      46.3091       0.1584       0.2086       3.4723    2665.4470      53.0254     156.1875    2208.0000
  715.6704      61.8881      60.4723      97.1574     161.4659      88.3530      11.3182     311.0000       0.0318      -0.0034       4.2252     100.6321     388.1057      -0.4990      46.3091       0.1655       0.2164       3.3808    2655.6306      55.8815     154.4375    2194.0000
  715.8228      67.1040      74.1822     117.8999     214.1399     145.2282       6.8857     311.0000       0.0211      -0.0145       4.1669      95.0004     384.5547      -0.3200      46.3091       0.1461       0.1961       3.2989    2673.9009      74.8290     154.4375    2164.0000
  715.9752      67.8744      79.0950     152.9655     270.9425     176.8498       5.6545     311.0000       0.0102      -0.0258       4.4888      87.4793     385.9205       1.3819      46.3091       0.1373       0.1868       3.2189    2692.6321      61.9574     154.4375    2120.0000
  716.1276      60.8979      62.7918     117.2747     277.3484     209.6225       4.7705     311.0000      -0.0004      -0.0368       4.3384      79.3596     388.3789      18.2011      46.3091       0.1594       0.2100       3.2068    2710.7505      50.5221     154.4375    2129.0000
  716.2800      60.2867      50.0078      92.3497     260.8743     191.2154       5.2297     311.0000       0.0117      -0.0242       4.1341      80.8222     390.0178      24.0941      46.3091       0.1638       0.2147       3.2231    2689.9351      42.5339     154.4375    2115.0000
  716.4324      67.6588      57.1266     115.9243     283.7963     227.1752       4.4019     311.0000       0.0273      -0.0081       4.4806      85.7044     390.0178      24.0779      46.3091       0.1479       0.1980       3.2649    2663.3040      48.1453     154.4375    2128.0000
  716.5848      84.7004      57.9129     114.8038     248.1680     213.8475       4.6762     311.0000       0.0400       0.0051       4.3546      86.2599     387.0131      15.1253      46.3091       0.1673       0.2183       3.3175    2641.5256      67.2395     154.4375    2146.0000
  716.7372      71.0648      66.0938     108.8901     195.0288     179.0672       5.5845     311.0000       0.0329      -0.0022       4.2022      88.1128     383.4621      15.3835      46.3091       0.1516       0.2019       3.3994    2653.6931     101.0588     154.4375    2150.0000
  716.8896      62.8038      73.4867     120.2110     173.7169     151.1108       6.6177     311.0000       0.0239      -0.0116       4.3930      84.6134     379.0916      14.8208      46.3091       0.1071       0.1546       3.4056    2669.1370     111.3654     154.4375    2144.0000
  717.0420      52.7390      64.6062      80.6398     114.7924     115.5866       8.6515     311.0000       0.0308      -0.0044       4.3887      89.0054     382.9157       4.9119      46.3091       0.1103       0.1581       3.3483    2657.2610      89.4878     154.4375    2151.0000
  717.1944      52.6496      44.4520      58.1347      78.2551      68.3996      14.6200     311.0000       0.0430       0.0082       4.5300      89.2868     392.2031      -5.8763      46.3091       0.1381       0.1875       3.2220    2636.4856      67.7389     154.4375    2121.0000
  717.3468      54.4915      52.7284      66.5474      91.0117      70.0582      14.2738     311.0000       0.0523       0.0179       4.7438      96.9371     425.5284      -8.9009      46.3091       0.1624       0.2132       3.1525    2620.4834      62.2715     155.2500    2124.0000
  717.4992      56.8200      72.9927     100.9172     147.7864     112.3534       8.9005     311.0000       0.0656       0.0316       4.5309      92.5987     391.1105      -5.3446      46.3091       0.1714       0.2226       3.1738    2597.8567      68.2204     154.4375    2152.0000
  717.6516      60.4338      83.9865     125.0585     165.4558     138.3306       7.2291     311.0000       0.0618       0.0277       4.2977      94.4825     391.1105      31.8992      46.3091       0.1652       0.2160       3.3915    2604.2380      51.5581     157.1875    2152.0000
  717.8040      54.3030      69.4147     101.3435     166.9476     124.4879       8.0329     311.0000       0.0513       0.0168       4.3138      90.0817     395.4810      77.4801      46.3091       0.1951       0.2468       3.6878    2622.2205      33.2331     155.5000    2105.0000
  717.9564      57.9899      56.7082      88.1543     155.2936     128.2351       7.7982     311.0000       0.0290      -0.0063       4.8207      94.8910     387.2863     117.2411      46.3091       0.2106       0.2628       3.9249    2660.4368      27.0373     157.8125    2086.0000
  718.1088      58.7959      46.0844      73.9078     134.1435     117.1774       8.5341     311.0000       0.0136      -0.0223       4.5801      89.0763     385.9205     125.2732      46.3091       0.1705       0.2215       3.9767    2686.7756      24.6382     157.7500    2083.0000
  718.2612      55.4974      42.9255      67.4050     125.4843     111.1483       8.9970     311.0000       0.0113      -0.0247       4.4329      84.4084     386.1937     113.3380      46.3091       0.1693       0.2204       3.9133    2690.6753      29.2476     157.5000    2152.0000
  718.4136      53.1946      51.0553      75.3721     144.5507     136.0101       7.3524     311.0000       0.0121      -0.0238       4.4764      82.9408     388.3789      89.1211      46.3091       0.1362       0.1857       3.7853    2689.3376      35.6134     159.5000    2165.0000
  718.5660      51.5548      53.1109      82.2168     153.0099     146.5374       6.8242     311.0000       0.0305      -0.0047       4.5102      92.7474     412.9631      48.7263      46.3091       0.1368       0.1863       3.6249    2657.8091      55.7730     161.2500    2121.0000
  718.7184      45.9674      57.8757      79.6326     130.9607     126.6264       7.8972     311.0000       0.0338      -0.0014       4.3049     102.3522     390.0178      18.4426      46.3091       0.1607       0.2114       3.4300    2652.2732      48.9281     161.3750    2124.0000
  718.8708      45.6612      58.5126      75.4713     112.1954     105.8708       9.4455     311.0000       0.0374       0.0024       4.5013      98.1466     387.8326       3.0916      46.3091       0.1634       0.2142       3.2917    2645.9766      42.2637     162.3125    2150.0000
  719.0232      39.2768      41.2807      55.8432      81.7566      80.5163      12.4198     311.0000       0.0386       0.0037       4.6258      87.8620     387.2863       1.9021      46.3091       0.1546       0.2051       3.2597    2643.9561      39.6086     162.4375    2095.0000
  719.1756      38.1474      31.9099      42.2552      56.2797      55.5049      18.0164     311.0000       0.0317      -0.0035       4.6883      81.3037     390.0178      13.1567      46.3091       0.1746       0.2259       3.3266    2655.7915      34.0423     164.1875    2136.0000
  719.3280      40.7449      27.1213      34.6764      42.8691      42.6725      23.4343     311.0000       0.0301      -0.0052       4.4613      79.3258     391.6568      13.0212      46.3091       0.1821       0.2337       3.4187    2658.6128      32.6609     163.3750    2150.0000
  719.4804      38.9382      33.7324      42.8857      48.3241      51.4093      19.4517     311.0000       0.0274      -0.0079       4.0157      78.1260     396.5736      13.5529      46.3091       0.1417       0.1913       3.6144    2663.0852      39.9917     164.1875    2135.0000
  719.6328      36.2528      42.1491      49.7277      62.3029      62.9443      15.8871     311.0000       0.0322      -0.0030       4.3228      70.2536     397.6663      16.0754      46.3091       0.0978       0.1441       3.8679    2654.9854      60.5882     164.0625    2146.0000
  719.7852      39.1257      44.4251      50.1492      67.5815      76.0880      13.1427     311.0000       0.0300      -0.0053       4.4361      69.4884     399.8515      30.8180      46.3091       0.0666       0.1098       4.0857    2658.7576      63.6644     164.1875    2078.0000
  719.9376      43.6474      50.6031      59.6530      78.0034      75.2275      13.2930     311.0000       0.0254      -0.0101       4.3732      68.2083     402.0368      31.8093      46.3091       0.0980       0.1438       4.0707    2666.6479      49.1605     164.1875    2100.0000
  720.0900      46.4647      62.5754      83.9392     111.1786      88.9489      11.2424     311.0000       0.0216      -0.0140       4.4871      70.8054     389.4715      19.3121      46.3091       0.1137       0.1602       3.9480    2673.0349      50.0343     164.8125    2150.0000
  720.2424      42.2505      58.4089      75.7890     117.7120     103.8732       9.6271     311.0000       0.0226      -0.0130       4.3555      67.3773     389.4715      10.4892      46.3091       0.0663       0.1096       3.8231    2671.3757      61.0307     164.5000    2173.0000
  720.3948      39.6577      41.7457      65.6190     119.8275      93.5733      10.6868     311.0000       0.0227      -0.0128       4.3624      71.6321     388.3789      26.5722      46.3091       0.0921       0.1374       3.8060    2671.1135      49.6323     164.9375    2174.0000
  720.5472      32.3651      31.0007      50.0427     107.0780      96.8375      10.3266     311.0000       0.0230      -0.0126       4.3463      75.7337     392.4763      43.9601      46.3091       0.1626       0.2131       3.8020    2670.7544      34.1870     164.3125    2149.0000
  720.6996      48.3593      33.7303      57.9516     122.8558     136.9568       7.3016     311.0000       0.0094      -0.0267       4.4153      79.3935     396.0273      52.6617      46.3091       0.1902       0.2421       3.7742    2693.9910      33.6907     164.1875    2174.0000
  720.8520      55.9424      49.1998      85.5187     177.2149     184.9845       5.4059     311.0000      -0.0158      -0.0528       4.4584      64.8300     379.0916      43.3357      46.3091       0.1358       0.1851       3.7027    2737.1008      52.4627     165.7500    2226.0000
  721.0044      72.3161      67.1273     108.1231     202.8378     224.7087       4.4502     311.0000      -0.0498      -0.0880       4.2933      47.4742     379.0916      37.7150      46.3091       0.0684       0.1119       3.6381    2795.2256     132.3841     166.5625    2186.0000
  721.1568      73.7022      73.0409     125.0137     193.6816     211.8252       4.7209     311.0000      -0.0598      -0.0983       4.2067      29.9414     376.9063      21.6882      46.3091       0.0635       0.1054       3.6100    2812.1816     163.7949     165.8125    2142.0000
  721.3092      64.3603      72.7624     113.0929     162.0277     156.0006       6.4102     311.0000      -0.0615      -0.1001       4.3638      28.0962     372.5358      12.9907      46.3091       0.0639       0.1056       3.5713    2815.1987     147.9410     164.1875    2139.0000
  721.4616      56.2786      65.6432      99.1551     123.6373     111.4258       8.9746     311.0000      -0.0450      -0.0830       4.4624      28.9911     370.8969      -1.5841      46.3091       0.0638       0.1056       3.4890    2786.9133     139.4863     164.1875    2137.0000
  721.6140      47.7504      71.0911      80.6417      93.4706      79.3081      12.6091     311.0000      -0.0296      -0.0671       4.1814      47.2743     371.4431       0.4199      46.3091       0.0600       0.1021       3.3971    2760.6836     107.0047     164.3750    2145.0000
  721.7664      41.8307      68.6857      69.6549      74.6867      60.6673      16.4833     311.0000      -0.0051      -0.0416       4.1515      65.1012     373.6284      12.9516      46.3091       0.0914       0.1366       3.3001    2718.7141      81.5178     164.1875    2152.0000
  721.9188      45.2069      63.4014      64.6368      67.7535      52.7433      18.9597     311.0000       0.0203      -0.0153       4.3233      91.5374     375.8137      20.9351      46.3091       0.1475       0.1970       3.2290    2675.2471      61.1329     164.0000    2157.0000
  722.0712      52.6211      70.2985      70.0600      75.2726      54.5177      18.3427     311.0000       0.0336      -0.0015       4.3392      94.9194     374.7210      18.5761      46.3091       0.1753       0.2266       3.1437    2652.5105      64.8176     163.0000    2096.0000
  722.2236      57.1989      85.5267      90.4424     108.2761      70.0977      14.2658     311.0000       0.0377       0.0027       4.1294      91.7261     373.0821       6.8841      46.3091       0.1379       0.1874       3.0764    2645.4961      68.0437     161.1250    2059.0000
  722.3760      57.7099      94.2813     119.9352     140.3961      82.0752      12.1839     311.0000       0.0367       0.0017       4.1019      82.6930     369.8042      -0.1013      46.3091       0.1433       0.1932       3.0237    2647.1931      63.0168     160.0625    2089.0000
  722.5284      61.5722      85.5523     131.0087     180.2679     102.6308       9.7437     311.0000       0.0358       0.0008       4.1258      82.9614     369.2579      -0.2575      46.3091       0.1758       0.2272       2.9965    2648.7390      49.1097     157.5625    2169.0000
  722.6808      69.7481      82.7462     148.0356     259.9783     146.4771       6.8270     311.0000       0.0378       0.0028       4.2326      85.1943     370.8969      -1.8642      46.3091       0.1542       0.2046       2.9947    2645.4075      43.7540     157.1875    2161.0000
  722.8332      76.4826      78.9225     154.2347     380.5348     216.6357       4.6160     311.0000       0.0401       0.0052       4.3310      89.1319     370.3505      -2.4679      46.3091       0.1264       0.1753       3.0018    2641.4075      52.5287     157.8125    2186.0000
  722.9856      69.4836      71.0131     149.9389     520.0823     352.9837       2.8330     311.0000       0.0413       0.0064       3.9567      87.9035     370.3505      -1.2429      46.3091       0.1632       0.2141       3.0077    2639.3999      54.5033     155.2500    2188.0000
  723.1380      65.2843      64.2028     129.0056     559.2321     525.8753       1.9016     311.0000       0.0441       0.0094       4.0696      85.4194     368.7115      -0.1612      46.3091       0.1732       0.2244       3.0690    2634.5090      54.3640     154.4375    2143.0000
  723.2904      60.3709      49.0854     100.3867     430.9441     568.2328       1.7598     311.0000       0.0237      -0.0118       4.1824      77.1302     367.6189      13.9258      46.3091       0.1364       0.1858       3.1609    2669.4875      48.1231     154.4375    2111.0000
  723.4428      62.6371      61.7936     106.0800     290.4360     395.4921       2.5285     311.0000       0.0029      -0.0334       3.8727      59.8550     359.9705      14.9164      46.3091       0.1453       0.1948       3.2903    2705.1096      75.4957     154.4375    2098.0000
  723.5952      57.0280      74.1507     106.8872     205.9170     236.7335       4.2242     311.0000      -0.0249      -0.0621       3.8316      44.4564     354.2342      15.7216      46.3091       0.0840       0.1292       3.4314    2752.5171     137.6815     154.4375    2141.0000
  723.7476      54.5904      89.4029     118.6677     148.6068     146.5213       6.8249     311.0000      -0.0276      -0.0650       4.0162      38.1536     352.8684       3.6230      46.3091       0.0544       0.0966       3.4725    2757.2607     187.3394     154.4375    2229.0000
  723.9000      50.2565      55.2700      73.4491     103.0401      96.9601      10.3135     311.0000      -0.0163      -0.0533       4.0829      57.8647     353.6879       3.4592      46.3091       0.0776       0.1218       3.4570    2737.9192      89.0557     154.4375    2178.0000
  724.0524      47.8023      38.4168      44.1589      50.4190      49.9225      20.0310     311.0000       0.0081      -0.0280       4.2323      79.2633     359.4242       3.8018      46.3091       0.1195       0.1672       3.3344    2696.1553      51.7774     154.4375    2151.0000
  724.2048      49.7454      42.9525      43.3242      43.8299      39.3948      25.3841     311.0000       0.0324      -0.0028       4.0799      98.1104     355.0537       2.5761      46.5887       0.1655       0.2163       3.2277    2654.6770      45.7531     157.1875    2160.0000
  724.3572      51.0579      56.1583      57.3963      56.2388      50.7620      19.6998     311.0000       0.0373       0.0023       4.1041      98.0609     355.6000       2.5244      46.3091       0.1730       0.2242       3.1072    2646.2188      45.8066     156.5000    2175.0000
  724.5096      59.3586      61.2925      65.8454      58.0960      61.7871      16.1846     311.0000       0.0396       0.0047       4.1098     102.4617     356.1463       0.9601      46.3091       0.1620       0.2128       3.0575    2642.3257      45.7433     155.5625    2173.0000
  724.6620      50.9561      67.9801      64.2140      58.8878      58.3614      17.1346     311.0000       0.0373       0.0023       3.9785      98.2067     356.1463       0.7076      46.3091       0.1551       0.2056       3.0104    2646.2393      40.3096     155.5000    2170.0000
  724.8144      52.8470      57.0670      56.4912      56.5741      49.7933      20.0830     311.0000       0.0415       0.0066       3.7796      97.6471     356.1463      -0.6757      46.5887       0.1612       0.2119       2.9995    2639.1179      42.3357     155.0000    2196.0000
  724.9668      47.8552      47.9191      50.1442      53.5798      45.9212      21.7764     311.0000       0.0380       0.0030       4.0419      92.9195     359.1511       0.0887      46.3091       0.1956       0.2475       2.9365    2645.1016      41.5747     157.7500    2210.0000
  725.1192      43.1969      38.8346      42.2811      52.7295      37.8730      26.4040     311.0000       0.0410       0.0061       4.0987      91.7614     360.5168       0.3779      46.3091       0.1811       0.2324       2.9381    2639.9063      45.1743     156.0625    2194.0000
  725.2716      45.2292      43.4729      54.6539      66.3835      50.2544      19.8988     311.0000       0.0560       0.0216       3.8910      94.9467     354.5074       2.7204      46.5887       0.1686       0.2195       3.0231    2614.2888      43.0919     154.4375    2146.0000
  725.4240      42.7471      53.2153      62.6294      81.8129      69.2112      14.4485     311.0000       0.0838       0.0505       3.7097      97.4414     352.3221      25.5108      46.5887       0.1815       0.2328       3.3490    2566.7534      44.8317     154.4375    2137.0000
  725.5764      46.3732      46.3455      60.1228      91.3185      80.3323      12.4483     311.0000       0.0822       0.0488       3.8162      98.3679     350.6832      85.7737      46.5887       0.2204       0.2727       3.7559    2569.4758      32.8178     156.8125    2146.0000
  725.7288      46.1795      41.0511      56.3585      95.6060      94.0512      10.6325     311.0000       0.0544       0.0200       3.8918      96.6036     353.9611     149.1120      46.5887       0.2409       0.2931       4.0386    2616.9326      25.6480     157.1250    2152.0000
  725.8812      54.2840      53.0252      73.5799     125.1423     129.7630       7.7064     311.0000       0.0036      -0.0327       3.8941      84.7077     344.6737     169.2767      46.5887       0.1985       0.2501       4.0213    2703.9209      28.9747     159.0000    2156.0000
  726.0336      68.5110      67.6887      97.8251     171.6995     201.4730       4.9634     311.0000      -0.0327      -0.0702       3.8971      68.6921     346.8590     124.7802      46.5887       0.1716       0.2228       3.8422    2765.8425      47.6507     157.1250    2127.0000
  726.1860      71.5167      85.7784     122.1079     196.8259     257.5791       3.8823     311.0000      -0.0539      -0.0922       3.9437      51.8489     349.5905      60.5547      46.5887       0.1240       0.1727       3.6497    2802.0991      87.8399     158.9375    2133.0000
  726.3384      63.8218      92.5055     117.3490     202.6105     283.4618       3.5278     311.0000      -0.0576      -0.0961       3.8407      43.2426     346.8590      18.5554      46.5887       0.0871       0.1329       3.5206    2808.4946     118.4053     159.3125    2119.0000
  726.4908      67.3086      84.1754     108.6421     173.9613     252.9516       3.9533     311.0000      -0.0382      -0.0760       3.6687      52.7728     346.5858       3.5133      46.5887       0.1036       0.1506       3.4294    2775.3860     102.0858     160.6250    2169.0000
  726.6432      61.8100      75.2429     100.4599     158.9208     210.2654       4.7559     311.0000      -0.0208      -0.0579       3.6491      63.8836     345.7664       3.2785      46.5887       0.1205       0.1684       3.3215    2745.5918      81.0823     161.0000    2141.0000
  726.7956      69.1506      85.5000      85.7270     135.7231     142.8463       7.0005     311.0000      -0.0078      -0.0444       3.8433      69.7517     344.6737       1.2462      46.5887       0.1611       0.2116       3.2753    2723.3191      61.5035     159.5000    2087.0000
  726.9480      67.8053      77.8489      85.6935     120.0364     128.1372       7.8041     311.0000      -0.0085      -0.0452       4.0355      65.0561     345.2200      -0.8624      46.5887       0.1354       0.1844       3.2921    2724.5566      72.6971     159.6875    2151.0000
  727.1004      70.5801      77.6618      91.7667     120.0048     111.0596       9.0042     311.0000      -0.0043      -0.0409       3.9326      60.6623     345.2200      -3.7820      46.5887       0.1045       0.1518       3.3265    2717.4268      84.2505     160.1875    2151.0000
  727.2528      72.7810      75.9576      98.1690     126.3849     121.3582       8.2401     311.0000       0.0062      -0.0300       3.9586      65.7102     346.3127      -4.1578      46.5887       0.1108       0.1582       3.2618    2699.4590      80.3379     157.5000    2158.0000
  727.4052      83.6619      84.5366     118.2678     153.9700     152.9332       6.5388     311.0000       0.0270      -0.0084       3.8513      72.0402     345.2200      -4.3514      46.5887       0.1279       0.1767       3.1247    2663.7959      68.6757     155.7500    2196.0000
  727.5576      75.3508      76.8919      97.5985     112.9448     108.1170       9.2492     311.0000       0.0434       0.0086       3.7049      75.0512     342.4884      -2.2285      46.5887       0.1518       0.2019       2.9853    2635.8542      67.2604     156.2500    2154.0000
  727.7100      65.9974      63.4091      74.5923      79.7637      75.6387      13.2207     311.0000       0.0622       0.0281       3.7908      83.6224     341.3958      -0.8402      46.5887       0.1399       0.1895       2.9726    2603.7000      74.5315     157.8750    2115.0000
  727.8624      52.7227      55.0693      69.2262      74.9304      72.3232      13.8268     311.0000       0.0830       0.0496       3.9679      85.6940     337.8448       1.8339      46.5887       0.1252       0.1740       3.0966    2568.1042      76.9076     154.4375    2115.0000
  728.0148      48.7701      52.1606      58.7811      72.0364      68.8069      14.5334     311.0000       0.1067       0.0743       3.8615      87.9373     334.2937      22.1817      46.5887       0.1519       0.2022       3.4354    2527.4834      47.7964     156.3750    2078.0000
  728.1672      41.3795      45.4043      52.2672      59.5397      58.7247      17.0286     311.0000       0.1159       0.0838       3.7378      81.4572     332.3816      65.6884      46.5887       0.1807       0.2322       3.8381    2511.8120      25.0326     154.4375    2150.0000
  728.3196      40.4677      43.6568      48.6428      52.9192      54.0925      18.4868     311.0000       0.1186       0.0865       3.7608      78.7766     326.6453     113.9543      46.5887       0.1677       0.2187       4.1924    2507.2480      14.6811     154.5000    2173.0000
  728.4720      41.9612      48.0286      54.3823      64.9538      65.5322      15.2597     311.0000       0.1017       0.0691       3.9204      79.5444     318.9969     149.9650      46.5887       0.1460       0.1960       4.3409    2536.0095      13.5597     154.5625    2173.0000
  728.6244      40.0871      43.2094      51.4295      67.7732      68.6223      14.5725     311.0000       0.0950       0.0621       3.7951      81.3030     319.5432     150.7709      46.5887       0.1736       0.2249       4.2973    2547.5410      15.4880     154.4375    2209.0000
  728.7768      38.7939      38.2931      46.4192      59.3600      64.0224      15.6195     311.0000       0.0762       0.0426       3.7758      86.7257     323.0943     132.8387      46.5887       0.2022       0.2542       4.0757    2579.6301      26.0338     154.4375    2207.0000
  728.9292      44.8933      42.8118      51.2084      66.2387      75.3470      13.2719     311.0000       0.0725       0.0388       3.7753      87.6522     322.8211     100.7035      46.5887       0.2021       0.2540       3.8341    2585.9797      38.6734     154.4375    2150.0000
  729.0816      50.3162      48.9095      59.4006      83.0124     103.4996       9.6619     311.0000       0.0647       0.0307       3.9837      82.6301     318.4506      74.9850      46.5887       0.1633       0.2140       3.6385    2599.3721      44.0866     155.1250    2097.0000
  729.2340      50.9919      60.4224      70.9324      98.3474     127.4523       7.8461     311.0000       0.0726       0.0389       3.8369      80.8612     315.4458      60.6780      46.5887       0.1386       0.1882       3.5909    2585.8311      44.2238     154.8750    2137.0000
  729.3864      50.2586      56.7015      70.8871     108.9233     151.2082       6.6134     311.0000       0.0736       0.0399       3.6647      80.6296     315.1727      57.0200      46.5887       0.1640       0.2148       3.6022    2584.1160      40.6804     154.4375    2128.0000
  729.5388      47.9971      54.2232      63.7460      93.9679     140.1817       7.1336     311.0000       0.0764       0.0429       3.7948      87.7343     313.8069      45.7830      46.5887       0.1682       0.2193       3.5949    2579.2729      43.8097     154.4375    2105.0000
  729.6912      43.7832      52.4803      59.1275      79.9113     115.5531       8.6540     311.0000       0.0740       0.0403       3.8852      91.3267     312.9874      27.4062      46.5887       0.1590       0.2097       3.4922    2583.4509      47.4240     154.4375    2100.0000
  729.8436      44.9584      54.7804      62.6556      83.2788     118.1047       8.4671     311.0000       0.0739       0.0402       3.8672      89.0106     311.8948       6.0565      46.5887       0.1582       0.2088       3.3770    2583.6252      51.7216     154.4375    2139.0000
  729.9960      44.8756      57.0638      67.0492      88.2292     122.0305       8.1947     311.0000       0.0615       0.0274       3.8330      84.9018     311.3485      -2.5020      46.5887       0.1666       0.2175       3.2704    2604.7976      72.2244     154.0000    2113.0000
  730.1484      47.0512      57.1430      62.7809      80.7129     102.7162       9.7356     311.0000       0.0507       0.0162       3.9444      79.4681     310.8022      -2.2960      46.5887       0.1556       0.2061       3.2335    2623.2925      68.9017     152.8125    2083.0000
  730.3008      42.1914      48.3943      52.7867      69.4005      84.6510      11.8132     311.0000       0.0510       0.0165       3.8992      83.3108     310.8022      -6.8290      46.5887       0.1374       0.1870       3.2135    2622.7087      66.9514     151.3125    2085.0000
  730.4532      39.2702      43.9678      45.5485      56.5693      64.6213      15.4748     311.0000       0.0545       0.0201       3.8740      82.6519     311.8948      -8.3141      46.5887       0.1487       0.1989       3.2144    2616.8567      63.1859     152.0625    2129.0000
  730.6056      44.7096      47.1635      47.5907      55.3697      65.3649      15.2987     311.0000       0.0533       0.0189       3.8566      82.0572     312.9874      -9.2037      46.5887       0.1859       0.2377       3.2080    2618.8489      67.7981     151.8750    2137.0000
  730.7580      54.2806      61.6479      60.5735      69.7520      83.2213      12.0162     311.0000       0.0465       0.0119       3.9594      76.8248     314.6264      -5.2581      46.5887       0.1532       0.2036       3.1540    2630.4036      74.3765     151.0000    2144.0000
  730.9104      65.6636      77.1740      75.5827      82.6889      98.2997      10.1730     311.0000       0.0551       0.0207       4.0505      77.9387     315.1727      -8.6653      46.5887       0.1506       0.2008       3.0974    2615.8337      73.1062     151.3125    2127.0000
  731.0628      80.1415     100.6658      96.5075     102.1777     117.1159       8.5385     311.0000       0.0608       0.0267       3.9874      78.0115     314.6264     -12.1541      46.5887       0.1438       0.1937       3.0267    2605.9495      81.7312     149.8125    2181.0000
  731.2152      85.0298     108.8892     109.9595     116.2135     109.1635       9.1606     311.0000       0.0661       0.0322       3.9471      78.8339     313.5338     -15.0127      46.5887       0.1777       0.2292       2.9831    2596.9521      92.7223     152.6250    2192.0000
  731.3676      76.3821      98.4866      99.3352     109.6475     101.1212       9.8891     311.0000       0.0598       0.0256       3.8723      81.1943     312.4411     -12.7759      46.5887       0.1422       0.1920       2.9370    2607.7800      90.6538     149.1875    2185.0000
  731.5200      72.9413      89.5620      93.3652     107.3185     110.2829       9.0676     311.0000       0.0529       0.0184       3.7941      80.3095     312.4411      -9.8753      46.5887       0.1235       0.1720       2.9218    2619.5967      88.2862     148.8125    2154.0000
  731.6724      72.3433      85.0127      91.9348     110.5624     106.9821       9.3474     311.0000       0.0456       0.0109       3.9728      79.6542     313.5338      -0.9871      46.5887       0.1250       0.1735       2.9219    2631.9678      84.8854     146.1875    2160.0000
  731.8248      70.8704      80.6565      93.4227     114.6218     114.6756       8.7202     311.0000       0.0387       0.0037       3.8750      72.7057     315.1727       0.8330      46.5887       0.1285       0.1774       2.8980    2643.8416      97.0670     146.7500    2158.0000
  731.9772      68.4827      76.8416      92.7690     116.6173     120.3786       8.3071     311.0000       0.0362       0.0012       3.9557      67.3891     315.4458       0.7241      46.5887       0.1254       0.1740       2.8642    2648.0823     101.2713     146.7500    2135.0000
  732.1296      65.6255      72.9444      93.4097     120.7066     129.9911       7.6928     311.0000       0.0393       0.0044       3.7660      67.4354     315.1727      -8.6181      46.5887       0.1161       0.1639       2.8676    2642.7905     114.6530     145.4375    2146.0000
  732.2820      63.5820      72.1699      87.7526     121.0213     139.4528       7.1709     311.0000       0.0455       0.0108       3.9106      71.3730     314.0800      -9.6135      46.5887       0.1157       0.1634       2.8979    2632.1689     104.2683     144.6875    2173.0000
  732.4344      61.1082      72.5799      87.4175     119.3661     144.7371       6.9091     311.0000       0.0507       0.0162       3.8992      76.8925     312.9874      -7.9255      46.5887       0.1209       0.1687       2.9054    2623.2468     112.7017     144.6875    2196.0000
  732.5868      63.8364      71.7062      85.9018     119.1457     149.9531       6.6688     311.0000       0.0550       0.0207       3.9035      74.1312     314.0800      -5.1739      46.5887       0.0987       0.1450       2.8483    2615.9099     103.8715     144.6875    2267.0000
  732.7392      73.1323      85.2824     100.4843     137.7223     184.8318       5.4103     311.0000       0.0563       0.0220       3.8795      71.9400     315.1727       3.4008      46.5887       0.1051       0.1518       2.7966    2613.7500     121.6240     144.8125    2248.0000
  732.8916      85.7588     104.4883     125.5590     178.3434     231.1246       4.3267     311.0000       0.0577       0.0234       3.8245      67.5262     317.3580       9.3853      46.5887       0.1094       0.1561       2.7631    2611.3315     111.8274     145.8125    2119.0000
  733.0440      91.3777     118.2531     135.7304     183.1178     238.5484       4.1920     311.0000       0.0567       0.0224       3.8497      66.2276     310.8022       9.5541      46.5887       0.0960       0.1416       2.7336    2613.0569     116.2145     145.0000    2128.0000
  733.1964      89.9317     113.4450     136.9073     186.2564     238.9600       4.1848     311.0000       0.0560       0.0217       3.9351      62.2965     310.2559       3.3135      46.5887       0.0959       0.1414       2.6759    2614.1687     131.8599     144.7500    2131.0000
  733.3488      82.2882     117.6696     135.6127     167.5490     200.7090       4.9823     311.0000       0.0600       0.0258       3.9372      60.0219     309.7096      -4.5788      46.5887       0.0722       0.1152       2.6367    2607.3816     171.2651     144.6875    2072.0000
  733.5012      76.4977     108.4682     121.6440     151.0218     175.2604       5.7058     311.0000       0.0584       0.0241       3.8333      58.7676     309.7096      -4.1168      46.5887       0.0603       0.1024       2.6422    2610.1550     196.8695     144.6875    2131.0000
  733.6536      71.8119      98.1202     108.6656     133.5751     155.3380       6.4376     311.0000       0.0549       0.0206       3.8930      61.0747     309.4364      14.2758      46.5887       0.0859       0.1298       2.6890    2616.0610     122.0774     144.6875    2135.0000
  733.8060      67.9353      88.0891      93.9524     114.1501     132.7049       7.5355     311.0000       0.0509       0.0164       3.9920      64.5073     309.1632      28.7023      46.5887       0.1027       0.1487       2.7358    2622.8906     116.8443     144.6875    2105.0000
  733.9584      68.3461      80.6085      87.7838     101.1773     113.6001       8.8028     311.0000       0.0526       0.0182       3.9664      67.7916     308.6169      26.3817      46.5887       0.0987       0.1448       2.7395    2620.0098      91.1122     144.6875    2086.0000
  734.1108      80.0344      83.8662      89.3744     100.3768     111.5299       8.9662     311.0000       0.0566       0.0223       4.0707      66.3320     308.6169      10.6385      46.5887       0.1335       0.1820       2.7066    2613.2234     103.6091     143.3750    2116.0000
  734.2632      84.9507     108.3041     118.2220     134.6747     150.7565       6.6332     311.0000       0.0588       0.0246       4.0058      61.2746     308.0706      -4.7896      46.5887       0.1122       0.1593       2.6378    2609.4348     120.2807     144.6875    2118.0000
  734.4156     106.8126     148.5099     169.7824     193.0421     219.1055       4.5640     311.0000       0.0572       0.0229       4.0707      55.7615     307.7975      -3.2098      46.5887       0.0770       0.1207       2.5742    2612.2251     178.7089     142.3125    2140.0000
  734.5680     116.6289     183.7703     238.0587     291.9127     312.9276       3.1956     311.0000       0.0550       0.0206       3.9994      48.2973     306.9780      -5.0306      46.5887       0.0707       0.1129       2.5178    2615.9592     232.0394     144.6875    2120.0000
  734.7204     110.5915     204.3748     246.0719     315.7247     333.3521       2.9998     311.0000       0.0510       0.0165       3.8256      47.4439     306.4317      -0.7999      46.5887       0.0535       0.0931       2.4705    2622.8057     241.0373     144.6875    2144.0000
  734.8728     110.4804     165.8498     224.2794     331.8202     340.2435       2.9391     311.0000       0.0535       0.0191       3.9928      45.0402     306.1585      -0.0055      46.5887       0.0504       0.0895       2.4481    2618.4617     277.8463     144.6875    2135.0000
  735.0252     112.9881     158.9228     211.6783     325.0596     323.5528       3.0907     311.0000       0.0596       0.0254       4.0331      46.8932     304.7927      -2.5706      46.5887       0.0592       0.0991       2.4325    2608.1042     265.5869     144.4375    2160.0000
  735.1776     113.9880     146.4711     199.6717     302.2343     293.7696       3.4040     311.0000       0.0583       0.0240       4.0565      45.5041     305.3391      -2.8179      46.5887       0.0417       0.0796       2.4046    2610.3464     344.6700     143.2500    2172.0000
  735.3300     111.9000     158.2864     206.1802     287.7965     294.7667       3.3925     311.0000       0.0476       0.0130       3.9856      43.2712     305.6122       2.6162      46.5887       0.0401       0.0779       2.3931    2628.5764     301.8158     143.0000    2241.0000
  735.4824     112.3988     179.5509     232.1935     306.0813     350.0868       2.8564     311.0000       0.0361       0.0010       4.1026      45.8190     304.2464       7.4139      46.5887       0.0576       0.0970       2.4264    2648.3433     317.6782     141.9375    2228.0000
  735.6348     105.5829     172.0487     228.1022     297.4507     369.4435       2.7068     311.0000       0.0364       0.0013       4.1340      47.2081     303.7001       4.5273      46.5887       0.0588       0.0989       2.5056    2647.8093     263.9404     141.8750    2184.0000
  735.7872     101.1216     150.1139     197.7598     286.7616     315.1566       3.1730     311.0000       0.0452       0.0105       4.1132      54.1203     303.1538      -0.6039      46.5887       0.0497       0.0899       2.6304    2632.6816     255.0434     140.9375    2157.0000
  735.9396      96.9541     133.9510     172.9552     254.0380     278.8091       3.5867     311.0000       0.0543       0.0199       4.2311      57.1837     303.1538      -5.3105      46.5887       0.0759       0.1184       2.6944    2617.1724     192.4766     140.6875    2161.0000
  736.0920     103.2367     133.3671     171.6305     251.6877     280.2500       3.5682     311.0000       0.0540       0.0196       4.1993      58.8046     302.6075      -3.2001      46.5887       0.0970       0.1419       2.7129    2617.7073     271.7870     138.3125    2175.0000
  736.2444     115.9233     146.2095     184.5955     260.3361     296.4908       3.3728     311.0000       0.0507       0.0162       4.1192      57.3732     302.6075      -2.5904      46.5887       0.0892       0.1337       2.6557    2623.2686     295.8874     139.0000    2210.0000
  736.3968     113.7952     168.5113     197.4861     251.2543     288.7657       3.4630     311.0000       0.0489       0.0143       4.2151      62.0808     303.1538      -0.8705      46.5887       0.0691       0.1124       2.6722    2626.3813     334.9993     138.6250    2212.0000
  736.5492      95.1494     137.2168     173.3221     204.1784     258.9042       3.8624     311.0000       0.0536       0.0192       4.3101      64.5516     302.6075      -2.1162      46.5887       0.0840       0.1282       2.7613    2618.2913     247.2021     136.7500    2246.0000
  736.7016      83.2729     110.6196     133.6162     162.6617     188.8475       5.2953     311.0000       0.0530       0.0185       4.1829      70.1104     302.6075      -2.2275      46.5887       0.0871       0.1319       2.8800    2619.3979     174.2263     134.9375    2206.0000
  736.8540      81.3442     102.9802     118.5797     144.6615     161.2496       6.2016     311.0000       0.0483       0.0137       4.2478      76.9519     302.6075      -1.9836      46.5887       0.1120       0.1586       2.9463    2627.3428     168.7055     135.3125    2183.0000
  737.0064      85.1543     106.5658     125.0530     142.5602     162.2057       6.1650     311.0000       0.0509       0.0164       4.1700      82.9908     303.1538      -2.9311      46.5887       0.1271       0.1751       2.9939    2622.8762     157.5538     134.9375    2186.0000
  737.1588      85.6410     118.3576     138.0108     158.0809     176.4971       5.6658     311.0000       0.0538       0.0194       4.2799      81.8808     301.5148      -3.0658      46.5887       0.0880       0.1330       2.9703    2618.0330     176.0612     135.3125    2148.0000
  737.3112      90.0961     132.7697     153.6106     177.0918     195.7072       5.1097     311.0000       0.0588       0.0246       4.3286      72.5606     301.5148      -2.5053      46.5887       0.0855       0.1301       2.9474    2609.4031     144.6403     134.9375    2126.0000
  737.4636     103.7907     157.9608     177.4599     205.6734     212.2657       4.7111     311.0000       0.0527       0.0182       4.2154      68.8040     301.5148       0.9053      46.5887       0.0830       0.1272       2.8668    2619.9312     167.8211     134.9375    2137.0000
  737.6160      99.5454     138.5268     166.3661     212.3513     221.4794       4.5151     311.0000       0.0427       0.0079       4.2095      75.7227     302.0611       8.4729      46.5887       0.0726       0.1159       2.8452    2636.9580     185.6916     134.9375    2144.0000
  737.7684      98.7305     129.1098     158.3690     201.8876     200.0921       4.9977     311.0000       0.0311      -0.0041       4.1854      78.6075     304.2464      14.7583      46.5887       0.0979       0.1431       2.8077    2656.8303     218.9021     133.7500    2148.0000
  737.9208      95.3709     123.3725     153.1185     200.4689     195.9125       5.1043     311.0000       0.0346      -0.0005       4.2118      77.4494     304.2464      12.8787      46.5887       0.1092       0.1551       2.7853    2650.7595     226.3698     134.9375    2125.0000
  738.0732      97.8573     131.7749     166.9700     226.0225     212.9791       4.6953     311.0000       0.0428       0.0080       4.2670      65.6186     303.9733       5.1072      46.5887       0.0706       0.1136       2.7161    2636.8762     254.9544     134.9375    2169.0000
  738.2256     104.3480     138.4556     183.2043     242.9818     249.1709       4.0133     311.0000       0.0479       0.0132       4.1477      60.3408     303.7001      -1.4799      46.5887       0.0573       0.0985       2.6454    2628.1709     235.7443     134.9375    2193.0000
  738.3780     109.5865     157.9276     203.1395     268.7511     268.9055       3.7188     311.0000       0.0500       0.0154       4.2061      58.1640     304.2464      -2.4064      46.5887       0.0674       0.1091       2.6327    2624.5320     205.0001     134.2500    2183.0000
  738.5304     113.2854     154.8004     204.8919     263.5636     270.9871       3.6902     311.0000       0.0619       0.0278       4.2907      62.1476     303.7001      -2.4471      46.5887       0.0854       0.1287       2.7021    2604.0911     268.9243     133.8125    2154.0000
  738.6828     103.3113     136.6085     175.1457     219.9976     230.6755       4.3351     311.0000       0.0855       0.0523       4.2411      57.2466     304.2464      -4.7855      46.5887       0.0679       0.1093       2.8094    2563.7800     255.2371     131.7500    2172.0000
  738.8352      93.1306     128.5194     158.5350     201.1509     190.3231       5.2542     311.0000       0.0917       0.0586       4.1664      54.6127     305.3391       1.6398      46.5887       0.0391       0.0779       2.8904    2553.2764     154.7209     132.3125    2189.0000
  738.9876      80.3579     123.4515     149.0338     176.3679     184.1774       5.4295     311.0000       0.0907       0.0576       4.2150      52.9452     306.9780      15.7509      46.5887       0.0561       0.0958       2.9853    2554.9795     130.2908     131.6875    2221.0000
  739.1400      77.3799     125.4479     153.7399     181.6827     195.7044       5.1097     311.0000       0.0811       0.0477       4.2743      60.0791     308.0706      37.0471      46.5887       0.0618       0.1026       3.1101    2571.3381     100.3077     130.5000    2205.0000
  739.2924      91.6483     132.4128     160.9423     206.1532     219.4698       4.5564     311.0000       0.0653       0.0314       4.2224      63.9686     309.9827      60.0710      46.5887       0.0769       0.1195       3.1987    2598.2632      85.7384     129.1250    2204.0000
  739.4448     100.9167     161.9200     187.9425     238.1286     241.9034       4.1339     311.0000       0.0513       0.0168       4.2679      61.1892     308.0706      65.2514      46.5887       0.1017       0.1470       3.1422    2622.2212      82.2710     127.9375    2188.0000
  739.5972     116.2787     147.3113     175.8482     230.2494     246.6058       4.0551     311.0000       0.0452       0.0104       4.4129      53.4755     309.1632      46.9735      46.5887       0.0744       0.1177       2.9901    2632.7891     132.3237     127.0000    2163.0000
  739.7496     112.1377     113.9961     150.5617     233.7106     218.7890       4.5706     311.0000       0.0484       0.0138       4.4360      49.3011     310.8022      21.9164      46.5887       0.0556       0.0969       2.9092    2627.1611     168.1222     128.1875    2157.0000
  739.9020     110.0805     115.1333     146.2529     237.5484     170.9715       5.8489     311.0000       0.0390       0.0040       4.2876      52.2200     312.4411      25.1093      46.5887       0.0799       0.1225       2.9376    2643.3931     173.1463     127.8125    2174.0000
  740.0544     116.1306     142.9559     185.6098     253.4463     238.1357       4.1993     311.0000       0.0240      -0.0114       4.3278      56.2320     314.0800      45.7592      46.5887       0.0791       0.1220       2.9529    2668.8765     184.2718     126.8750    2157.0000
  740.2068     121.8566     221.3103     324.5602     308.0690     368.5645       2.7132     311.0000       0.0276      -0.0077       4.5495      57.4955     314.0800      45.1889      46.5887       0.0733       0.1156       2.8339    2662.7405     317.1650     125.1250    2166.0000
  740.3592     111.5526     376.1793     505.9224     634.9316     415.3420       2.4077     311.0000       0.0403       0.0054       4.5444      58.7511     312.4411      26.6767      46.5887       0.0561       0.0966       2.6812    2641.1465     314.9132     125.1250    2139.0000
  740.5116     120.1915     317.8492     463.7873     488.7551     385.4211       2.5946     311.0000       0.0545       0.0201       4.4083      58.7104     312.9874       6.8517      46.5887       0.0451       0.0837       2.6120    2616.8352     273.9030     125.6875    2152.0000
  740.6640     125.1387     185.1575     242.0897     279.5109     267.1000       3.7439     311.0000       0.0526       0.0181       4.4459      57.7643     312.4411       6.6841      46.5887       0.0569       0.0964       2.6285    2620.0532     217.7851     126.1250    2152.0000
  740.8164     122.8153     134.7145     175.4193     202.9432     149.7410       6.6782     311.0000       0.0452       0.0105       4.4850      52.4865     312.4411       9.2061      46.5887       0.0564       0.0956       2.5986    2632.6301     220.8253     125.1250    2139.0000
  740.9688     123.3156     128.2771     168.3575     215.4409     142.1521       7.0347     311.0000       0.0469       0.0123       4.5146      47.8542     313.5338       8.5223      46.5887       0.0454       0.0834       2.5216    2629.7734     273.0550     125.1250    2145.0000
  741.1212     106.0454     141.4839     194.2139     245.5688     199.3872       5.0154     311.0000       0.0405       0.0056       4.3547      45.9980     315.1727      20.4039      46.5887       0.0346       0.0710       2.4962    2640.8052     367.0917     125.1250    2148.0000
  741.2736     121.0368     201.3215     260.9687     341.1900     324.5521       3.0812     311.0000       0.0489       0.0143       4.4634      42.9601     316.2654      19.4936      46.5887       0.0438       0.0810       2.4915    2626.3533     221.1799     125.1250    2131.0000
  741.4260     134.1919     320.7528     502.0474     485.9226     448.0492       2.2319     311.0000       0.0471       0.0124       4.6299      43.1878     314.0800      18.7380      46.5887       0.0544       0.0926       2.4828    2629.4829     224.7820     125.1250    2137.0000
  741.5784     146.4779     366.6926     515.7079     716.7574     572.3760       1.7471     311.0000       0.0525       0.0181       4.4642      42.6419     312.9874       5.3344      46.5887       0.0429       0.0802       2.3647    2620.2036     266.9463     125.1250    2102.0000
  741.7308     175.5689     286.7152     438.0279     612.9271     448.7484       2.2284     311.0000       0.0511       0.0166       4.4526      43.0159     313.5338       2.8989      46.5887       0.0323       0.0687       2.3016    2622.6052     564.2507     125.1250    2120.0000
  741.8832     149.6045     184.2835     291.3472     562.4722     305.7171       3.2710     311.0000       0.0429       0.0081       4.4583      40.4977     315.1727      12.6970      46.5887       0.0332       0.0693       2.3170    2636.6897     493.9492     125.1250    2134.0000
  742.0356     148.7435     149.0454     229.3586     502.8979     208.3416       4.7998     311.0000       0.0391       0.0042       4.5267      42.2593     316.8116      22.8405      46.5887       0.0448       0.0820       2.3853    2643.1260     392.9378     125.1250    2115.0000
  742.1880     130.6367     155.0930     245.2104     487.7519     272.4277       3.6707     311.0000       0.0467       0.0121       4.6931      40.4574     318.9969      19.9327      46.5887       0.0394       0.0757       2.4496    2630.0669     444.5587     125.1250    2145.0000
  742.3404     144.2803     208.0877     326.1719     523.7784     398.3331       2.5105     311.0000       0.0496       0.0151       4.5080      41.1265     318.9969      10.0858      46.5887       0.0349       0.0705       2.5101    2625.1572     502.6653     125.1250    2157.0000
  742.4928     160.3739     284.2942     514.8599     473.6650     489.4875       2.0430     311.0000       0.0448       0.0101       4.4208      39.5341     316.8116      -0.3142      46.5887       0.0349       0.0705       2.6802    2633.3259     457.4415     125.1250    2129.0000
  742.6452     176.6302     332.2536     527.3849     687.9492     466.6392       2.1430     311.0000       0.0289      -0.0064       4.6059      44.1725     316.8116       0.1643      46.5887       0.0316       0.0670       2.8744    2660.5156     345.9761     125.0625    2154.0000
  742.7976     186.5079     259.1233     352.5813     388.4406     367.0639       2.7243     311.0000       0.0336      -0.0016       4.6522      54.6450     316.8116      -2.1908      46.5887       0.0369       0.0734       3.0081    2652.5991     511.4527     125.1250    2154.0000
  742.9500     140.9755     141.0094     200.0841     239.4534     217.3922       4.6000     311.0000       0.0436       0.0088       4.4788      60.2897     317.3580      -3.6709      46.5887       0.0533       0.0919       3.0042    2635.5115     445.0870     126.0625    2141.0000
  743.1024     102.9497     106.5392     151.4110     175.2807     150.1559       6.6597     311.0000       0.0518       0.0173       4.4060      65.1524     319.5432      -1.6656      46.5887       0.0526       0.0921       2.9914    2621.4170     625.8046     126.5625    2156.0000
  743.2548      74.2440      83.3840     105.0136     122.5458     115.8163       8.6344     311.0000       0.0401       0.0052       4.6000      61.1653     321.7285      23.8922      46.5887       0.0456       0.0852       3.2063    2641.4883     630.7490     129.9375    2125.0000
  743.4072      59.7964      69.7195      84.6971      96.5766      97.5078      10.2556     311.0000       0.0168      -0.0190       4.4116      68.5121     323.9137      59.2167      46.5887       0.0657       0.1073       3.5954    2681.2810      94.4047     128.5625    2164.0000
  743.5596      58.3154      67.7115      79.1818      93.9862      98.4968      10.1526     311.0000       0.0014      -0.0349       4.4791      74.3082     323.9137      84.2896      46.5887       0.1009       0.1458       4.0752    2707.6177      57.5537     129.8125    2163.0000
  743.7120      67.0275      81.8895      97.3869     111.7054     124.1146       8.0571     311.0000      -0.0121      -0.0489       4.6314      78.2249     326.6453      87.0342      46.5887       0.1029       0.1485       4.4120    2730.6707      52.8245     127.7500    2158.0000
  743.8644      82.9935      88.1585     110.1168     145.7859     145.4592       6.8748     311.0000      -0.0078      -0.0444       4.4468      74.5607     327.1916      81.7738      46.5887       0.0879       0.1321       4.6619    2723.3142      74.7228     128.6250    2135.0000
  744.0168      88.1196      81.5517     102.7076     154.0364     140.1610       7.1347     311.0000      -0.0079      -0.0446       4.2989      67.7890     327.1916      74.7533      46.5887       0.0827       0.1257       4.8016    2723.5085      75.0328     131.3750    2157.0000
  744.1692      95.9821      85.7071     107.0403     177.1844     145.6071       6.8678     311.0000      -0.0112      -0.0480       4.6072      59.8439     329.3769      73.1955      46.5887       0.0631       0.1039       4.9309    2729.1587      80.5531     129.6250    2162.0000
  744.3216     120.9182     114.9396     153.6522     248.7981     224.3262       4.4578     311.0000      -0.0138      -0.0507       4.5993      47.1301     331.5622      59.8617      46.5887       0.0468       0.0838       5.0414    2733.6187     124.0344     127.0000    2186.0000
  744.4740     169.8997     181.2539     249.7294     372.4795     305.6822       3.2714     311.0000      -0.0244      -0.0617       4.5517      44.0216     333.4742      53.4291      46.5887       0.0046       0.0354       5.1471    2751.7700     476.3284     128.5625    2200.0000
  744.6264     190.2750     347.6069     433.6317     566.2529     421.8040       2.3708     311.0000      -0.0171      -0.0540       4.4811      40.6635     332.1085      31.7214      46.5887       0.0038       0.0322       5.1416    2739.1760     512.3652     125.6250    2144.0000
  744.7788     253.0971     376.7851     882.8118    1215.4060    1083.1840       0.9232     311.0000      -0.0189      -0.0560       4.4452      39.9693     333.2011      20.7229      46.5887       0.0075       0.0358       5.0863    2742.3245     524.5748     125.1250    2139.0000
  744.9312     240.9083     330.2408     428.3129     420.4088     388.2803       2.5755     311.0000      -0.0025      -0.0390       4.4790      35.9731     332.6548       5.5335      46.5887      -0.0102       0.0167       5.0543    2714.2778    2125.5774     125.1250    2132.0000
  745.0836     117.6201     145.4721     198.6046     236.5125     173.9137       5.7500     311.0000       0.0059      -0.0302       4.4536      48.9003     333.2011       2.3501      46.5887      -0.0096       0.0180       4.9833    2699.8403     666.6785     125.1250    2117.0000
  745.2360      79.2448      89.7880     111.0078     134.6504     107.2230       9.3264     311.0000       0.0236      -0.0119       4.5915      71.1098     334.2937      -2.5840      46.5887       0.0185       0.0506       4.8644    2669.7075     149.6814     125.1250    2137.0000
  745.3884      66.7879      73.0796      88.2729     114.1628      97.2807      10.2795     311.0000       0.0405       0.0056       4.6655      86.8893     339.7569      -1.5256      46.5887       0.0670       0.1056       4.6720    2640.8101     103.2899     125.1250    2137.0000
  745.5408      61.1532      67.8369      83.5996     106.6588     100.5588       9.9444     311.0000       0.0606       0.0265       4.5951      93.4598     340.3032       1.1327      46.5887       0.0698       0.1108       4.5284    2606.3142      79.5605     123.1875    2166.0000
  745.6932      64.6552      72.6362      90.1294     111.8395     111.9121       8.9356     311.0000       0.0645       0.0305       4.5072      92.1195     345.2200      14.3504      46.5887       0.0753       0.1172       4.4968    2599.6841      57.5692     123.2500    2151.0000
  745.8456      98.7355      95.8643     119.2373     152.1071     157.0269       6.3683     311.0000       0.0541       0.0197       4.4353      83.8123     337.5716      17.5564      46.5887       0.0861       0.1286       4.5505    2617.4849      56.0073     118.6875    2144.0000
  745.9980     179.9801     176.7781     210.2698     256.9966     257.8583       3.8781     311.0000       0.0401       0.0052       4.5185      68.2269     337.0253      15.3515      46.5887       0.0691       0.1091       4.8015    2641.4680      83.3974     118.4375    2118.0000
  746.1504     313.3696     341.8242     307.7307     396.6300     414.1083       2.4148     311.0000       0.0332      -0.0020       4.4846      42.9128     338.6642       3.8254      46.5887       0.0209       0.0536       5.0595    2653.2922     366.1894     115.3750    2132.0000
  746.3028     334.7337     395.4257     475.7448     627.7584     674.2898       1.4830     311.0000       0.0098      -0.0262       4.5210      29.8607     344.1274      26.7847      46.5887      -0.0103       0.0166       5.3286    2693.1584    4396.1455     113.6250    2150.0000
  746.4552     351.5669     366.2027     628.8279     939.7056    1026.5214       0.9742     311.0000      -0.0005      -0.0369       4.6191      22.4332     346.8590      31.3165      46.5887      -0.0126       0.0117       5.4013    2710.8386    4406.8770     110.1250    2167.0000
  746.6076     310.8066     475.1600     790.7504    1277.2590    1421.6003       0.7034     311.0000      -0.0185      -0.0555       4.5755      23.4482     347.9516      46.6979      46.5887      -0.0136       0.0096       5.4234    2741.6235    4463.3418     109.3750    2160.0000
  746.7600     330.6106     694.9332    1568.2188    1816.3973    1784.2965       0.5604     311.0000      -0.0267      -0.0640       4.4297      22.2901     347.9516      53.6466      46.5887      -0.0163       0.0062       5.4180    2755.5769    4620.0737     105.6250    2150.0000
  746.9124     381.4012     767.8873    1950.0000    1950.0000    1950.0000       0.5001     311.0000      -0.0400      -0.0778       4.4488      19.2354     338.1179      80.3094      46.5887      -0.0130       0.0097       5.4779    2778.3442    4584.3604     103.0625    2105.0000
  747.0648     425.9945     738.1040    1821.2147    1942.3861    1658.2535       0.6030     311.0000      -0.0470      -0.0851       4.5945      18.2530     338.3911      97.4483      46.5887      -0.0164       0.0060       5.5380    2790.4050    4553.3643      99.6875    2115.0000
  747.2172     458.1602     631.9462    1543.8640    1785.1050    1023.7580       0.9768     311.0000      -0.0439      -0.0819       4.2737      19.2933     335.3864      99.5891      46.5887      -0.0152       0.0074       5.5616    2785.1357    4554.2119      99.1250    2135.0000
  747.3696     533.5364     540.3853    1345.7911    1712.6462     551.0286       1.8148     311.0000      -0.0400      -0.0779       4.4705      20.9142     339.7569      93.7521      46.5887      -0.0072       0.0164       5.5527    2778.4829    4356.6987      98.5625    2128.0000
  747.5220     528.6206     484.9760    1187.2700    1400.9690     735.9928       1.3587     311.0000      -0.0334      -0.0709       4.5879      20.0697     339.2105      79.3169      46.5887      -0.0083       0.0154       5.5048    2767.0588    4390.0898      96.7500    2162.0000
  747.6744     512.0213     523.8016    1293.8408    1433.1023    1018.5720       0.9818     311.0000      -0.0234      -0.0606       4.4060      22.7352     337.0253      58.9221      46.5887      -0.0167       0.0067       5.4098    2750.0342    4599.6694      95.8750    2144.0000
  747.8268     460.7937     500.6576    1038.9635    1167.0735     779.6115       1.2827     311.0000      -0.0128      -0.0496       4.3591      23.9531     335.9327      36.4151      46.5887      -0.0122       0.0118       5.2658    2731.8960    4653.5244      95.0000    2137.0000
  747.9792     295.3861     392.6248     717.2087     824.6190     568.0071       1.7605     311.0000       0.0048      -0.0314       4.5104      26.9980     333.2011      16.8626      46.5887      -0.0027       0.0225       5.1720    2701.7302    4619.6826      95.8750    2139.0000
  748.1316     224.7181     309.9654     569.6783     640.6602     482.5146       2.0725     311.0000       0.0148      -0.0210       4.4934      28.1820     332.1085      10.9296      46.5887      -0.0115       0.0137       5.0930    2684.6260    4598.9756      95.2500    2152.0000
  748.2840     185.1416     214.1445     369.5948     464.7070     306.6759       3.2608     311.0000       0.0091      -0.0269       4.3879      44.6796     334.8401      40.1075      46.5887      -0.0121       0.0143       5.1029    2694.4314     635.2598      93.8750    2129.0000
  748.4364     156.2091     172.0250     273.2408     389.2133     209.0128       4.7844     311.0000      -0.0023      -0.0388       4.3680      59.8589     332.6548      84.4626      46.5887       0.0194       0.0505       5.1168    2713.9500     148.2347      91.9375    2162.0000
  748.5888     220.9901     227.6054     382.4862     530.1770     304.9776       3.2789     311.0000      -0.0118      -0.0486       4.5109      64.9242     333.7474     124.7625      46.5887       0.0643       0.1013       5.2308    2730.1394      99.4390      91.7500    2133.0000
  748.7412     452.8792     404.4115     613.3682     766.5386     514.3686       1.9441     311.0000      -0.0171      -0.0541       4.4586      53.0590     337.0253     144.2151      46.5887       0.0543       0.0915       5.3990    2739.1953     118.5990      93.5000    2132.0000
  748.8936     644.1541     642.1085     957.2776    1156.4058     819.0648       1.2209     311.0000      -0.0300      -0.0675       4.3314      39.9097     334.2937     156.8294      46.5887       0.0249       0.0582       5.5736    2761.2947     322.7573      91.6250    2149.0000
  749.0460     765.1177     765.8952    1642.2626    1752.1326    1577.9839       0.6337     311.0000      -0.0333      -0.0709       4.1992      30.3994     336.2058     160.4998      46.5887      -0.0016       0.0269       5.6900    2766.9641    1357.8317      92.0000    2119.0000
  749.1984     866.2115     964.6010    1950.0000    1950.0000    1950.0000       0.5000     311.0000      -0.0328      -0.0704       4.2201      25.5354     338.6642     160.3088      46.5887      -0.0041       0.0225       5.7122    2766.1038    1402.6646      90.6875    2107.0000
  749.3508     879.4897    1062.3247    1950.0000    1950.0000    1950.0000       0.5000     311.0000      -0.0219      -0.0591       4.4478      21.2726     336.2058     153.0871      46.5887      -0.0062       0.0197       5.6902    2747.4531    1454.3101      90.8125    2124.0000
  749.5032     795.2020    1004.8247    1950.0000    1950.0000    1950.0000       0.5024     311.0000      -0.0228      -0.0600       4.4334      22.2172     334.2937     149.3442      46.5887      -0.0064       0.0195       5.6417    2748.9375    2040.9181      91.8750    2120.0000
  749.6556     761.0900     856.7426    1721.2042    1790.5281    1444.1373       0.6925     311.0000      -0.0311      -0.0686       4.1577      22.6493     332.6548     145.7655      46.5887       0.0045       0.0313       5.5667    2763.1917    3683.6582      91.9375    2139.0000
  749.8080     799.8757     596.6490    1131.3689    1344.2950    1028.5547       0.9722     311.0000      -0.0436      -0.0815       4.3525      23.4472     332.3816     138.0196      46.5887       0.0008       0.0277       5.4565    2784.5046    3907.0962      92.5625    2139.0000
  749.9604     611.0555     504.7867     840.0084     939.9964     876.7078       1.1406     311.0000      -0.0398      -0.0776       4.5207      22.7673     332.6548     112.8466      46.5887      -0.0066       0.0198       5.3066    2777.9773    3926.5808      95.0625    2142.0000
  750.1128     519.7690     509.5546     626.2228     672.0505     677.2978       1.4765     311.0000      -0.0347      -0.0723       4.2573      22.3620     330.4695      93.2329      46.5887      -0.0014       0.0260       5.2030    2769.2617    4599.5220      95.3125    2146.0000
  750.2652     255.6567     324.2020     445.9544     438.0927     462.6891       2.1613     311.0000      -0.0253      -0.0626       4.2162      24.8120     328.8306      77.0838      46.5887       0.0059       0.0347       5.1041    2753.2173    3499.6018      95.8750    2150.0000
  750.4176     170.8570     164.4593     239.6273     260.5762     282.2920       3.5424     311.0000      -0.0269      -0.0643       4.3380      37.3046     328.8306      79.5879      46.5887       0.0140       0.0446       5.0243    2756.0325     479.2930      95.8750    2168.0000
  750.5700     147.7393     127.4704     168.6961     182.6359     197.1838       5.0714     311.0000      -0.0122      -0.0490       4.5386      45.6420     329.3769      58.6078      46.5887       0.0273       0.0610       4.8748    2730.8030     189.6349      96.9375    2143.0000
  750.7224     155.9892     147.4740     195.5658     217.2402     243.8374       4.1011     311.0000       0.0090      -0.0271       4.3777      52.3097     329.9232      34.1895      46.5887       0.0537       0.0913       4.7871    2694.6641     182.8831      98.0625    2152.0000
  750.8748     147.3560     172.5222     214.0904     241.0033     255.5322       3.9134     311.0000       0.0136      -0.0222       4.4017      51.6550     330.4695      31.1937      46.5887       0.0384       0.0753       4.7845    2686.7095     199.6334      98.4375    2152.0000
  751.0272     133.2330     131.5149     162.4334     224.9145     232.0947       4.3086     311.0000       0.0047      -0.0315       4.4613      53.8190     330.4695      53.1697      46.5887       0.0317       0.0683       4.8308    2702.0327     187.1234      99.2500    2150.0000
  751.1796     119.4185     112.9106     137.9293     174.7802     179.8603       5.5599     311.0000      -0.0114      -0.0482       4.2309      59.7199     329.3769      75.0325      46.5887       0.0627       0.1020       4.8669    2729.5662     118.4278      99.2500    2150.0000
  751.3320     167.0646     136.1128     169.5001     219.5990     225.5129       4.4343     311.0000      -0.0072      -0.0438       4.3361      61.9903     327.1916      62.2020      46.5887       0.0652       0.1058       4.8528    2722.2344     113.2329     102.6250    2117.0000
  751.4844     225.9622     219.8868     279.2823     358.7410     358.9978       2.7855     311.0000       0.0078      -0.0283       4.5700      56.5785     326.6453      33.9475      46.5887       0.0624       0.1025       4.8998    2696.6921     191.7595     100.1875    2115.0000
  751.6368     369.5526     393.1719     439.3538     518.5272     505.5215       1.9782     311.0000       0.0217      -0.0139       4.4458      46.1075     325.5527      10.8557      46.5887       0.0480       0.0856       4.9868    2672.9253     389.7055     100.8750    2150.0000
  751.7892     355.5121     380.2416     525.6088     681.6279     631.8308       1.5827     311.0000       0.0242      -0.0113       4.3773      38.2302     325.5527       1.9417      46.5887       0.0103       0.0429       5.0014    2668.6094    1348.4603     102.4375    2158.0000
  751.9416     313.4255     329.6607     574.9847     842.6584     699.4783       1.4296     311.0000       0.0172      -0.0185       4.5258      40.5256     326.0990       2.7108      46.5887       0.0141       0.0463       4.9104    2680.5437     646.7070     103.2500    2151.0000
  752.0940     317.7719     391.2939     764.0859    1077.8887     805.4407       1.2416     311.0000       0.0167      -0.0190       4.5955      44.7208     326.0990       2.2802      46.5887       0.0254       0.0590       4.8229    2681.4033     393.3856     102.3125    2174.0000
  752.2464     311.3692     502.6435     999.9281    1321.1405     964.3932       1.0369     311.0000       0.0152      -0.0206       4.5352      46.1183     323.3674       1.9774      46.5887       0.0404       0.0756       4.7720    2683.9231     435.6792     103.2500    2210.0000
  752.3988     304.6105     438.3176     975.3699    1383.9960     953.7581       1.0485     311.0000       0.0197      -0.0159       4.4817      43.7986     323.3674      -1.1070      46.5887       0.0335       0.0686       4.8478    2676.2339     580.4986     103.0625    2189.0000
  752.5512     354.2505     387.9773     822.6685    1248.6897     846.5671       1.1812     311.0000       0.0109      -0.0251       4.5306      43.1110     326.6453      -0.9015      46.5887       0.0315       0.0664       4.8200    2691.3591     807.8831     103.1875    2124.0000
  752.7036     379.5840     332.9669     650.9888    1086.5813     747.2361       1.3383     311.0000       0.0090      -0.0270       4.5014      44.7280     331.0158      -2.3909      46.5887       0.0337       0.0691       4.7973    2694.5850     547.2227     103.6250    2162.0000
  752.8560     282.2302     283.2672     524.2930     937.0393     643.9925       1.5528     311.0000      -0.0014      -0.0379       4.4655      44.9306     323.9137       0.3085      46.5887       0.0294       0.0649       4.6573    2712.4556     382.5855     102.3125    2163.0000
  753.0084     249.9765     224.7091     379.9771     705.9021     492.3148       2.0312     311.0000      -0.0007      -0.0371       4.5677      43.7393     325.2795       0.8519      46.5887       0.0364       0.0726       4.6189    2711.1997     406.4432      99.1875    2160.0000
  753.1608     250.1754     244.8175     390.8889     679.2733     537.1125       1.8618     311.0000       0.0003      -0.0360       4.7923      45.5966     326.6453       1.7560      46.5887       0.0391       0.0755       4.6122    2709.4336     389.3327     100.8750    2129.0000
  753.3132     240.8855     267.0247     405.5185     603.3495     537.3650       1.8609     311.0000       0.0028      -0.0335       4.7132      48.4085     324.4601       1.7366      46.5887       0.0370       0.0728       4.6024    2705.2219     369.3984      99.9375    2120.0000
  753.4656     223.3619     253.7580     371.9753     510.1540     483.3917       2.0687     311.0000       0.0068      -0.0294       4.5032      53.1294     323.9137       0.8385      46.5887       0.0389       0.0749       4.5979    2698.4351     293.8713     101.1875    2141.0000
  753.6180     219.2556     227.7218     313.7050     398.6449     394.0458       2.5378     311.0000       0.0144      -0.0215       4.5685      51.2764     322.2748      -0.7310      46.5887       0.0427       0.0793       4.6544    2685.4343     293.5912     101.2500    2127.0000
  753.7704     202.0031     211.8561     295.1866     329.5468     347.5417       2.8774     311.0000       0.0244      -0.0111       4.6409      52.5490     321.7285      -3.1750      46.5887       0.0331       0.0692       4.7828    2668.2568     328.5674     101.1875    2139.0000
  753.9228     206.2593     200.6572     267.8823     305.6252     320.6470       3.1187     311.0000       0.0185      -0.0172       4.5846      52.1081     322.2748      -1.3468      46.5887       0.0353       0.0713       4.7927    2678.3052     299.9388      99.1250    2166.0000
  754.0752     208.1950     204.4969     272.4007     318.0593     328.1452       3.0474     311.0000       0.0061      -0.0300       4.6364      54.4640     322.8211       1.9715      46.5887       0.0340       0.0698       4.7393    2699.5762     332.9063      97.6250    2149.0000
  754.2276     214.9187     211.2774     290.1818     363.1860     364.7605       2.7415     311.0000      -0.0135      -0.0503       4.7754      52.2030     323.9137      12.4030      46.5887       0.0384       0.0743       4.6846    2733.0283     290.6654      96.6875    2140.0000
  754.3800     217.6168     230.1693     322.7476     439.9082     430.1279       2.3249     311.0000      -0.0120      -0.0488       4.6832      49.0811     322.8211      11.0085      46.5887       0.0390       0.0758       4.6870    2730.5144     290.6733      97.6875    2110.0000
  754.5324     211.8284     224.3134     327.1881     510.9154     473.4679       2.1121     311.0000      -0.0070      -0.0437       4.5189      45.1000     321.7285       7.7763      46.5887       0.0471       0.0848       4.7264    2722.0415     252.4076      96.0625    2113.0000
  754.6848     225.2627     229.8496     338.6389     594.6293     535.9584       1.8658     311.0000       0.0059      -0.0303       4.6722      44.2657     321.1822      -2.5940      46.5887       0.0472       0.0852       4.7558    2699.9580     288.0759      96.7500    2124.0000
  754.8372     227.2096     235.4948     346.8585     607.0266     552.2312       1.8108     311.0000       0.0105      -0.0255       4.7403      47.5902     321.1822      -4.5571      46.5887       0.0457       0.0832       4.8151    2692.0964     346.0135      96.6875    2150.0000
  754.9896     226.4954     234.5398     356.4455     647.3693     596.5932       1.6762     311.0000       0.0111      -0.0248       4.5722      51.2714     320.6359      -3.2992      46.5887       0.0419       0.0791       4.8267    2690.9551     350.6141      96.5625    2193.0000
  755.1420     227.7029     238.7204     392.1208     686.9569     678.9123       1.4729     311.0000       0.0149      -0.0209       4.5635      54.2522     321.7285      -2.1894      46.5887       0.0342       0.0709       4.8531    2684.4609     355.7654      95.8750    2176.0000
  755.2944     230.8519     245.0792     395.7284     692.7508     703.1685       1.4221     311.0000       0.0137      -0.0221       4.7412      54.2875     322.8211       0.8478      46.5887       0.0422       0.0797       4.8187    2686.4883     330.0900      95.8750    2150.0000
  755.4468     236.9527     253.9418     407.3050     641.0244     715.7172       1.3972     311.0000       0.0156      -0.0202       4.7947      51.2141     322.8211       1.6923      46.5887       0.0406       0.0776       4.7915    2683.3037     386.0281      95.8750    2143.0000
  755.5992     240.4349     259.3462     446.7436     679.8899     840.3135       1.1900     311.0000       0.0134      -0.0225       4.6642      48.6976     320.6359       2.3322      46.5887       0.0555       0.0939       4.7450    2687.1506     356.1197      95.8750    2170.0000
  755.7516     237.5581     250.6461     488.5162     738.8434     879.6270       1.1368     311.0000       0.0097      -0.0263       4.6652      45.9981     320.0895       1.6418      46.5887       0.0531       0.0918       4.7427    2693.3643     338.4808      95.8750    2152.0000
  755.9040     253.2104     267.1936     509.2075     754.6310     879.0691       1.1376     311.0000       0.0032      -0.0330       4.7062      46.8385     320.0895       1.0047      46.5887       0.0481       0.0868       4.7525    2704.5022     350.8334      95.4375    2172.0000
  756.0564     274.3039     260.3725     505.0830     709.8815     800.8898       1.2486     311.0000       0.0022      -0.0341       4.6719      44.0278     320.0895      -0.5250      46.5887       0.0441       0.0823       4.8132    2706.3140     447.3767      94.3125    2172.0000
  756.2088     320.1806     287.9344     540.8347     757.5687     790.9506       1.2643     311.0000       0.0070      -0.0292       4.6856      41.8555     324.4601      -2.7814      46.5887       0.0462       0.0844       4.8715    2698.1130     479.7918      93.3125    2158.0000
  756.3612     357.7900     375.9006     662.1133     909.3478     876.7850       1.1405     311.0000       0.0107      -0.0253       4.7752      39.9479     323.3674      -5.1174      46.5887       0.0417       0.0794       4.8969    2691.7551     588.7228      94.7500    2175.0000
  756.5136     378.3418     510.3108     941.0572    1195.7909    1104.4689       0.9054     311.0000       0.0092      -0.0268       4.9267      47.4195     323.9137      -6.3145      46.5887       0.0467       0.0845       4.8497    2694.2864     649.9455      94.9375    2141.0000
  756.6660     314.6056     478.9018     685.1020    1098.1453     742.2021       1.3473     311.0000       0.0044      -0.0318       4.9295      47.7986     321.7285       3.5267      46.5887       0.0495       0.0874       4.7657    2702.4275     599.7157      95.6250    2117.0000
  756.8184     297.3805     424.2266     824.3978    1152.2737     857.0378       1.1668     311.0000       0.0013      -0.0350       4.7039      49.2215     321.1822      20.0191      46.5887       0.0466       0.0843       4.7102    2707.7932     527.4258      94.3750    2140.0000
  756.9708     322.9179     414.5204     907.7657    1216.5861     863.6302       1.1579     311.0000      -0.0015      -0.0379       4.6092      45.7411     321.7285      38.6662      46.5887       0.0480       0.0860       4.6906    2712.6167     506.5753      92.9375    2154.0000
  757.1232     317.2399     465.7232     879.3699    1128.3973     809.9057       1.2347     311.0000       0.0006      -0.0358       4.7950      48.0322     321.7285      35.6629      46.5887       0.0384       0.0757       4.7466    2709.0107     592.9967      92.6875    2176.0000
  757.2756     318.7711     395.8206     845.5354     982.8940     740.6163       1.3502     311.0000       0.0018      -0.0345       4.7908      47.2712     322.8211      19.9027      46.5887       0.0524       0.0911       4.7715    2707.0024     550.0511      92.8125    2134.0000
  757.4280     295.9688     354.1500     757.0427     987.6374     724.9028       1.3795     311.0000       0.0031      -0.0332       4.7808      42.8349     324.4601       2.6195      46.5887       0.0464       0.0846       4.7745    2704.7356     562.8163      92.5625    2131.0000
  757.5804     286.1242     288.9985     627.6262     966.1480     642.8737       1.5555     311.0000       0.0010      -0.0353       4.9378      42.3717     324.4601      -2.9073      46.5887       0.0422       0.0798       4.7591    2708.2378     580.9523      92.4375    2137.0000
  757.7328     300.0045     319.1466     719.2460    1074.4243     798.0420       1.2531     311.0000      -0.0011      -0.0375       4.8100      45.4156     322.8211      -1.6317      46.5887       0.0402       0.0768       4.7529    2711.9504     667.7430      90.9375    2149.0000
  757.8852     268.7256     332.9151     709.2227    1124.6407     858.8268       1.1644     311.0000      -0.0044      -0.0409       4.6901      43.7917     320.0895      -0.9282      46.5887       0.0349       0.0708       4.7286    2717.5325     583.3467      94.9375    2137.0000
  758.0376     241.0953     279.6840     617.0123    1018.0284     778.6498       1.2843     311.0000      -0.0120      -0.0488       4.6274      43.8177     319.5432       0.4079      46.5887       0.0367       0.0722       4.6485    2730.5320     421.9494      95.8750    2118.0000
  758.1900     234.0320     265.9983     541.2444     870.0675     669.3914       1.4939     311.0000      -0.0082      -0.0448       4.7054      43.1229     320.0895      -0.7889      46.5887       0.0375       0.0733       4.6727    2723.9607     429.6650      92.6875    2124.0000
  758.3424     223.9503     241.5921     446.4080     705.6283     543.8118       1.8389     311.0000      -0.0083      -0.0449       4.7587      49.8216     322.8211      -0.3600      46.5887       0.0318       0.0674       4.6681    2724.1299     344.9788      93.1875    2174.0000
  758.4948     219.2373     242.1577     424.9670     627.2285     493.9857       2.0244     311.0000      -0.0027      -0.0392       4.8223      49.1834     323.9137      -1.7192      46.5887       0.0374       0.0743       4.7083    2714.6821     322.4425      92.8125    2176.0000
  758.6472     205.0146     247.9069     421.3852     607.0367     465.9374       2.1462     311.0000      -0.0055      -0.0420       4.9262      47.3305     325.0064      -1.2836      46.5887       0.0541       0.0927       4.6785    2719.3403     318.1779      93.9375    2151.0000
  758.7996     207.4717     259.5996     444.0255     555.6517     466.2227       2.1449     311.0000      -0.0044      -0.0409       4.8203      43.8553     324.7332      -1.3337      46.5887       0.0418       0.0789       4.6996    2717.5637     282.3272      92.6875    2141.0000
  758.9520     208.2505     237.9610     428.9662     521.3398     450.5265       2.2196     311.0000      -0.0063      -0.0429       4.5862      44.8995     322.2748       0.2718      46.5887       0.0367       0.0727       4.7193    2720.7971     276.6628      93.9375    2173.0000
  759.1044     206.4668     235.7853     413.1607     494.3242     431.6192       2.3169     311.0000      -0.0064      -0.0430       4.5850      48.1422     321.7285       0.6762      46.5887       0.0375       0.0735       4.7524    2720.9932     258.7558      93.6250    2177.0000
  759.2568     200.2040     235.6383     402.2289     525.0903     437.6862       2.2847     311.0000      -0.0007      -0.0371       4.7124      54.8652     323.3674      -2.2748      46.5887       0.0413       0.0778       4.8186    2711.1340     330.5370      92.2500    2145.0000
  759.4092     194.5581     225.4021     385.2697     562.0732     432.5382       2.3119     311.0000       0.0052      -0.0310       4.6091      54.4332     325.0064      -4.1919      46.5887       0.0304       0.0658       4.8779    2701.0774     446.1216      94.9375    2137.0000
  759.5616     185.2277     212.2760     370.5386     611.3951     427.8331       2.3374     311.0000       0.0071      -0.0290       4.7304      52.3460     327.4648      -4.4129      46.5887       0.0316       0.0673       4.9102    2697.8674     542.7758      94.5000    2158.0000
  759.7140     190.7765     221.5830     381.8802     682.4507     456.1383       2.1923     311.0000       0.0092      -0.0268       4.8081      47.4465     328.2842      -3.3264      46.5887       0.0429       0.0792       4.9366    2694.2312     671.2354      92.9375    2145.0000
  759.8664     188.5158     218.0782     397.9489     782.2036     490.7227       2.0378     311.0000       0.0113      -0.0246       4.7766      43.9722     327.1916      -3.4249      46.5887       0.0343       0.0701       4.9698    2690.6353     704.3342      95.6875    2172.0000
  760.0188     183.7656     206.5721     424.2652     796.5615     539.9688       1.8520     311.0000       0.0158      -0.0199       4.7547      41.1049     326.0990      -5.1854      46.5887       0.0373       0.0731       5.0118    2682.9065     793.4102      95.6875    2217.0000
  760.1712     185.6727     210.6026     431.6124     705.9468     562.7042       1.7771     311.0000       0.0033      -0.0329       4.6449      42.0980     324.1869      -2.8601      46.5887       0.0291       0.0645       4.9379    2704.2769     635.5853      95.8750    2212.0000
  760.3236     187.9712     212.4915     414.2127     590.6340     543.8409       1.8388     311.0000      -0.0082      -0.0448       4.6572      45.1627     326.6453      -1.4949      46.5887       0.0321       0.0674       4.8262    2723.9924     552.3459      95.8750    2173.0000
  760.4760     184.2174     210.0401     384.7795     497.1854     499.7178       2.0011     311.0000      -0.0164      -0.0533       4.6507      48.6390     332.1085      -0.1025      46.5887       0.0395       0.0751       4.7371    2737.9961     484.7138      95.8750    2143.0000
  760.6284     192.6495     217.3124     349.0460     433.7096     446.8884       2.2377     311.0000      -0.0113      -0.0480       4.7236      48.3737     334.5669      -1.6944      46.5887       0.0338       0.0688       4.7389    2729.2715     493.5035      96.0625    2154.0000
  760.7808     179.0408     206.2075     324.9864     425.5021     431.5911       2.3170     311.0000      -0.0058      -0.0423       4.8396      48.2003     335.9327      -2.5675      46.5887       0.0291       0.0642       4.7609    2719.8740     428.8979      96.3750    2133.0000
  760.9332     181.6301     220.9336     348.6522     476.7016     439.1591       2.2771     311.0000      -0.0040      -0.0405       4.8060      44.7240     335.3864      -2.1799      46.5887       0.0279       0.0625       4.7442    2716.8450     439.3495      95.8750    2105.0000
  761.0856     179.0757     234.3835     375.8451     532.2201     422.0741       2.3693     311.0000      -0.0066      -0.0432       4.6733      44.0609     330.4695      -1.1988      46.5887       0.0376       0.0731       4.6960    2721.2456     431.8415      95.8750    2084.0000
  761.2380     175.0097     242.1031     398.0702     580.3027     374.6711       2.6690     311.0000      -0.0115      -0.0483       4.7787      42.6134     328.2842       0.2425      46.5887       0.0297       0.0639       4.6465    2729.6492     458.9311      97.0000    2101.0000
  761.3904     169.8646     245.8578     441.4514     843.8361     434.6948       2.3005     311.0000      -0.0145      -0.0514       4.8201      49.4208     329.3769       1.7607      46.5887       0.0247       0.0587       4.6342    2734.8589     462.0432      97.3125    2118.0000
  761.5428     162.7777     230.1537     446.3411    1020.9714     431.1468       2.3194     311.0000      -0.0123      -0.0491       4.6684      52.8006     331.5622       2.5365      46.5887       0.0267       0.0606       4.6870    2731.0537     461.7567      97.7500    2115.0000
  761.6952     162.7976     213.2390     436.5457    1172.1721     436.0398       2.2934     311.0000      -0.0069      -0.0435       4.5468      56.2780     332.1085       2.4700      46.5887       0.0240       0.0582       4.7641    2721.8352     608.3774      98.1250    2142.0000
  761.8476     167.6971     212.8305     431.9006    1240.3973     492.0238       2.0324     311.0000       0.0024      -0.0339       4.7799      52.5721     335.3864       5.4657      46.5887       0.0309       0.0659       4.8280    2705.9690     891.8200      97.2500    2124.0000
  762.0000     168.3029     212.5751     456.3579    1171.5419     685.9271       1.4579     311.0000       0.0085      -0.0276       4.8536      53.4182     337.5716       3.0315      46.5887       0.0430       0.0793       4.7795    2695.4590    1030.4034      95.8750    2119.0000
  762.1524     153.2454     211.1144     460.0850    1027.3506     887.7172       1.1265     311.0000       0.0072      -0.0289       4.7902      53.8242     335.1132      18.8696      46.5887       0.0362       0.0720       4.6234    2697.6279     408.8406      95.8750    2126.0000
  762.3048     131.1962     180.8052     368.1958     743.6450     998.5000       1.0015     311.0000       0.0160      -0.0198       4.7079      56.1404     329.9232      28.7907      46.5887       0.0337       0.0694       4.5472    2682.7241     297.7052      95.8750    2133.0000
  762.4572     111.9514     156.9382     318.4813     633.6620     965.2837       1.0360     311.0000       0.0620       0.0279       4.8015      54.4838     326.6453      34.0946      46.5887       0.0333       0.0691       4.7533    2604.0046      69.5327      97.4375    2132.0000
  762.6096      98.6222     137.6255     269.2136     525.1691     795.7570       1.2567     311.0000       0.1023       0.0696       4.8481      54.9868     323.3674      53.1249      46.5887       0.0305       0.0660       5.2186    2535.0786      28.7782      98.4375    2143.0000
  762.7620      89.7469     117.8540     218.0518     435.2088     622.4294       1.6066     311.0000       0.1111       0.0788       4.7646      54.8370     314.0800      89.4847      46.5887       0.0387       0.0747       5.5932    2520.0337      17.5775      97.5000    2133.0000
  762.9144      82.3610     107.9283     191.1425     392.7662     483.2510       2.0693     311.0000       0.0720       0.0383       4.7589      55.4448     311.3485     140.9092      46.5887       0.0398       0.0753       5.7243    2586.8740      15.7166      96.3125    2127.0000
  763.0668      83.1792     108.4657     188.4536     377.9219     420.4209       2.3786     311.0000       0.0511       0.0166       4.8164      54.9419     310.2559     143.7218      46.5887       0.0331       0.0684       5.6305    2622.5498      17.0932      96.3750    2111.0000
  763.2192      84.8419     112.1560     188.7602     363.0969     383.8129       2.6054     311.0000       0.0483       0.0136       4.8693      52.1353     307.5243     117.1899      46.5887       0.0290       0.0641       5.4437    2627.4819      20.3734      95.8750    2158.0000
  763.3716      83.9959     118.7849     188.9697     359.6509     372.5156       2.6845     311.0000       0.0519       0.0175       4.8552      54.0220     306.4317      78.3253      46.5887       0.0326       0.0683       5.2259    2621.1702      25.8119      95.8750    2135.0000
  763.5240      83.2646     120.9839     201.3154     391.9453     399.5233       2.5030     311.0000       0.0422       0.0074       4.8741      55.8489     305.3391      52.4981      46.5887       0.0383       0.0742       5.0176    2637.8713      39.5609      96.1250    2137.0000
  763.6764      83.3193     126.9679     211.4709     409.6576     422.4398       2.3672     311.0000       0.0381       0.0031       4.7511      57.6425     305.8853      28.6696      46.5887       0.0380       0.0740       4.8706    2644.8228      71.7999      96.6875    2173.0000
  763.8288      85.2329     140.3093     227.5548     454.8341     471.4543       2.1211     311.0000       0.0410       0.0061       4.6789      54.2034     306.4317      10.7563      46.5887       0.0355       0.0719       4.8262    2639.9607     157.9250      95.8750    2206.0000
  763.9812      85.2842     142.1548     240.1714     494.4376     527.0920       1.8972     311.0000       0.0472       0.0125       4.8485      53.3557     306.9780      -1.7862      46.5887       0.0439       0.0815       4.7885    2629.2969     252.3166      95.8750    2150.0000
  764.1336      85.7578     144.3263     252.4582     549.4216     616.7953       1.6213     311.0000       0.0426       0.0078       4.8096      51.9375     306.9780       3.6802      46.5887       0.0483       0.0868       4.8229    2637.1050     301.2257      95.8750    2181.0000
  764.2860      87.6424     153.3207     278.9482     642.6780     753.8025       1.3266     311.0000       0.0345      -0.0006       4.8269      51.6706     306.9780      14.6072      46.5887       0.0505       0.0889       4.8724    2651.0137     312.0553      95.8750    2143.0000
  764.4384      89.2820     156.9956     301.2761     752.3902     961.7841       1.0397     311.0000       0.0308      -0.0044       4.9824      45.4135     306.9780      26.6013      46.5887       0.0416       0.0789       5.0297    2657.3025     348.7299      97.0000    2148.0000
  764.5908      90.8036     154.4435     307.0193     890.5267    1179.8395       0.8476     311.0000       0.0289      -0.0064       4.8540      43.0084     306.9780      37.4925      46.5887       0.0433       0.0804       5.1771    2660.6055     243.8199      98.1875    2154.0000
  764.7432      91.5147     155.5078     323.3183     970.3434    1312.8127       0.7617     311.0000       0.0234      -0.0121       4.7857      43.2400     306.9780      52.3748      46.5887       0.0541       0.0918       5.2672    2669.9688     142.5184      95.8750    2094.0000
  764.8956      93.9212     164.6809     328.7571    1004.0944    1322.0348       0.7564     311.0000       0.0184      -0.0173       4.6890      44.8639     303.1538      59.3066      46.5887       0.0357       0.0721       5.2520    2678.5828     110.7911      95.8750    2126.0000
  765.0480      98.2675     168.8889     337.7218     914.9614    1134.1351       0.8817     311.0000       0.0152      -0.0206       4.8376      45.2178     302.0611      47.4098      46.5887       0.0294       0.0652       5.1494    2684.0034     143.2400      95.8750    2162.0000
  765.2004     103.5414     188.6037     354.4875     789.1439     909.2562       1.0998     311.0000       0.0206      -0.0151       5.0057      45.1845     302.0611      23.5438      46.5887       0.0419       0.0794       5.0542    2674.8516     276.4568      95.8750    2120.0000
  765.3528      98.7382     190.6826     338.1666     618.4722     693.0917       1.4428     311.0000       0.0215      -0.0141       4.9236      44.2347     302.6075       5.6605      46.5887       0.0429       0.0801       4.9638    2673.2195     458.0798      95.8750    2111.0000
  765.5052      95.3165     179.2119     325.0334     598.4576     578.5071       1.7286     311.0000       0.0156      -0.0202       4.8945      46.6912     302.6075       6.9463      46.5887       0.0374       0.0742       4.9237    2683.2837     456.9690      95.8750    2100.0000
  765.6576      90.1746     192.1929     297.7492     517.8596     466.0883       2.1455     311.0000       0.0047      -0.0315       4.7943      48.3121     301.5148      15.6708      46.5887       0.0441       0.0810       4.8557    2701.8967     395.6805      95.8750    2154.0000
  765.8100      86.1654     175.7497     274.1150     479.9077     407.1508       2.4561     311.0000       0.0078      -0.0283       4.8348      48.5150     302.0611      14.9927      46.5887       0.0468       0.0840       4.8394    2696.6318     291.0431      95.4375    2161.0000
  765.9624      95.4661     197.0638     321.7823     610.0053     478.5008       2.0899     311.0000       0.0164      -0.0194       4.7251      49.3584     301.5148       9.0487      46.5887       0.0408       0.0773       4.8540    2681.9731     328.1433      95.8750    2144.0000
  766.1148     101.4979     221.7667     388.6982     775.7546     619.7932       1.6134     311.0000       0.0269      -0.0085       4.7549      50.4072     301.7880      -1.2298      46.5887       0.0348       0.0710       4.9125    2663.9595     438.7292      95.8750    2176.0000
  766.2672     110.9090     216.9918     427.6183     990.6910     809.3676       1.2355     311.0000       0.0268      -0.0085       4.9106      53.6498     302.6075      -2.6391      46.5887       0.0350       0.0709       4.9593    2664.0989     546.4003      95.8750    2146.0000
  766.4196     113.3878     221.0470     483.5933    1240.1981    1125.5958       0.8884     311.0000       0.0224      -0.0131       4.9436      51.8229     304.7927      -0.8166      46.5887       0.0333       0.0693       4.9555    2671.6868     479.1725      95.8750    2126.0000
  766.5720     112.4166     233.0464     519.6563    1344.0127    1431.5116       0.6986     311.0000       0.0149      -0.0209       4.9134      47.1003     304.7927       5.6257      46.5887       0.0368       0.0725       4.9887    2684.5300     454.2053      95.8750    2135.0000
  766.7244     105.0410     200.2928     471.8401    1280.1281    1629.6869       0.6136     311.0000      -0.0010      -0.0374       4.8042      44.1190     303.1538      17.3588      46.5887       0.0339       0.0695       5.0389    2711.6987     590.8707      95.8750    2140.0000
  766.8768      93.9402     167.3109     353.2033    1142.7446    1647.2689       0.6071     311.0000      -0.0034      -0.0399       4.9179      46.7234     303.7001      22.6388      46.5887       0.0365       0.0720       5.0932    2715.7754     507.1663      95.8750    2159.0000
  767.0292      92.6647     168.2955     326.0055     804.6437    1494.6093       0.6691     311.0000      -0.0069      -0.0435       4.8377      49.0413     302.6075      26.8617      46.5887       0.0368       0.0722       5.0413    2721.8374     585.8826      95.8750    2176.0000
  767.1816     101.2393     204.8198     386.4403     821.7318    1308.4747       0.7642     311.0000       0.0030      -0.0333       4.7727      49.5268     302.0611      17.5676      46.5887       0.0290       0.0635       4.9051    2704.8945     543.7404      95.8750    2163.0000
  767.3340     117.5515     295.7608     488.1569     879.1888    1172.6959       0.8527     311.0000       0.0095      -0.0265       4.8568      46.1443     302.6075      10.4430      46.5887       0.0268       0.0613       4.8517    2693.6765     545.8483      96.3750    2159.0000
  767.4864     116.9312     312.3268     563.2546     886.2931    1091.7793       0.9159     311.0000       0.0172      -0.0185       4.7838      48.1430     303.1538       1.6069      46.5887       0.0284       0.0638       4.8133    2680.5100     494.3022      96.6875    2137.0000
  767.6388     114.7704     307.7688     368.6813     700.1660     730.6156       1.3687     311.0000       0.0207      -0.0149       4.9685      51.5939     303.7001       0.8783      46.5887       0.0379       0.0746       4.8186    2674.6082     421.7593      95.8750    2124.0000
  767.7912     114.2373     302.8669     373.5164     787.8016    1156.5651       0.8646     311.0000       0.0206      -0.0150       5.0486      59.2373     303.7001       1.9002      46.5887       0.0460       0.0834       4.7472    2674.7664     340.3662      98.5625    2153.0000
  767.9436     110.2592     270.5278     379.9884     750.2020     726.5398       1.3764     311.0000       0.0132      -0.0227       5.0865      57.9868     302.0611      12.8314      46.5887       0.0515       0.0889       4.7728    2687.5132     317.7325      97.3750    2136.0000
  768.0960     109.9074     258.2920     337.1674     628.0965     706.5558       1.4153     311.0000       0.0105      -0.0254       4.8263      57.1429     302.0611      16.6602      46.5887       0.0387       0.0747       4.8095    2691.9839     325.5146      99.8125    2176.0000
  768.2484     112.9252     227.5171     323.7932     575.0813     683.9594       1.4621     311.0000       0.0112      -0.0247       4.7340      48.8354     302.0611      16.3138      46.5887       0.0300       0.0648       4.8750    2690.7915     450.7555     101.1875    2157.0000
  768.4008     115.7419     212.5086     286.7885     454.4037     600.1735       1.6662     311.0000       0.0195      -0.0162       4.8648      46.8092     303.1538       5.1510      46.5887       0.0239       0.0581       4.8216    2676.7126     549.0518     101.8125    2126.0000
  768.5532     118.6757     211.6069     272.6782     380.3706     520.0671       1.9228     311.0000       0.0211      -0.0145       4.9612      49.4774     304.2464       0.9604      46.5887       0.0214       0.0553       4.7067    2673.9824     528.8795     102.8125    2146.0000
  768.7056     118.5048     215.6616     283.2367     414.4076     467.7813       2.1378     311.0000       0.0162      -0.0196       4.8913      54.1675     304.7927       2.5663      46.5887       0.0363       0.0718       4.5974    2682.3513     344.6858     102.1250    2125.0000
  768.8580     115.6335     222.2631     261.5505     376.2800     466.9205       2.1417     311.0000       0.0201      -0.0155       4.9260      58.4592     304.7927       2.5504      46.5887       0.0420       0.0781       4.5990    2675.5999     313.0706     102.6250    2108.0000
  769.0104     106.4835     219.5972     266.0670     347.1010     445.8931       2.2427     311.0000       0.0224      -0.0131       5.1297      61.2386     303.1538       4.3936      46.5887       0.0313       0.0668       4.6875    2671.6121     262.9171     103.0625    2115.0000
  769.1628     115.7956     233.6636     241.9215     343.6237     365.1493       2.7386     311.0000       0.0187      -0.0170       5.1466      62.4566     302.6075       9.8689      46.5887       0.0353       0.0711       4.7688    2678.0396     315.5102     103.5625    2110.0000
  769.3152     116.6569     244.9599     257.0393     323.7383     377.0880       2.6519     311.0000       0.0149      -0.0209       4.8846      63.4328     301.7880       4.5855      46.5887       0.0411       0.0777       4.7606    2684.4675     233.6974     103.2500    2124.0000
  769.4676     119.4165     240.9933     276.0007     321.2798     383.2510       2.6093     311.0000       0.0161      -0.0197       4.8538      65.4819     302.6075       0.3321      46.5887       0.0441       0.0810       4.7158    2682.4954     248.4563     103.5625    2139.0000
  769.6200     123.6455     193.9828     224.6492     259.7481     309.1692       3.2345     311.0000       0.0297      -0.0056       4.9995      71.8189     303.7001      -7.1392      46.5887       0.0287       0.0643       4.6822    2659.1816     217.3026     103.6250    2137.0000
  769.7724     118.2407     155.5876     179.1405     198.3007     222.9797       4.4847     311.0000       0.0366       0.0016       4.9867      74.0906     304.2464      -2.6441      46.5887       0.0322       0.0679       4.6757    2647.3645     282.9625     105.3750    2139.0000
  769.9248     126.2369     147.2283     167.4142     190.4872     208.4167       4.7981     311.0000       0.0340      -0.0011       5.0181      70.8834     303.7001       0.1357      46.5887       0.0418       0.0782       4.6450    2651.8706     295.8770     105.6250    2163.0000
  770.0772     109.0349     172.6222     189.7278     239.3545     255.7015       3.9108     311.0000       0.0269      -0.0085       5.1548      69.2152     302.6075       0.4709      46.5887       0.0438       0.0803       4.6221    2664.0039     351.5239     105.6250    2136.0000
  770.2296     120.1425     231.1115     256.0851     328.3705     395.5308       2.5282     311.0000       0.0210      -0.0146       5.1046      65.5015     302.3343       1.0743      46.5887       0.0316       0.0664       4.6178    2674.1721     321.2652     105.6250    2143.0000
  770.3820     130.0167     301.9221     431.7222     624.2274     647.8652       1.5435     311.0000       0.0247      -0.0108       4.9527      64.6947     302.6075       0.0308      46.5887       0.0267       0.0611       4.6987    2667.7639     293.8375     105.6250    2186.0000
  770.5344     147.6113     433.4518     666.3918     660.7198     706.5187       1.4154     311.0000       0.0276      -0.0078       4.9320      58.1644     302.6075      -0.5469      46.5887       0.0354       0.0702       4.7500    2662.8784     288.2110     105.6250    2194.0000
  770.6868     164.7899     308.7538     355.0508     560.8259     611.1874       1.6362     311.0000       0.0310      -0.0042       5.0480      53.9953     303.1538      -1.3971      46.5887       0.0248       0.0591       4.8070    2656.9373     354.1445     105.6250    2190.0000
  770.8392     147.2770     238.4899     314.7894     482.2188     541.1401       1.8480     311.0000       0.0291      -0.0062       5.0869      49.9047     305.3391      -0.8531      46.5887       0.0222       0.0563       4.7978    2660.2781     379.7423     105.6250    2175.0000
  770.9916     127.6122     191.7357     235.2491     453.3058     423.4360       2.3616     311.0000       0.0335      -0.0016       5.1465      49.5332     306.4317      -1.8039      46.5887       0.0327       0.0680       4.8255    2652.6685     383.8661     105.6250    2156.0000
  771.1440     121.1839     166.1528     204.4364     327.0955     335.1543       2.9837     311.0000       0.0273      -0.0081       5.2579      50.6913     306.9780       3.4969      46.5887       0.0428       0.0793       4.8160    2663.3357     387.6094     105.6250    2162.0000
  771.2964     110.6688     188.9061     224.0830     326.3789     363.4432       2.7515     311.0000       0.0270      -0.0084       5.1740      52.5490     306.4317       1.1406      46.5887       0.0363       0.0719       4.8211    2663.8096     355.7833     106.2500    2128.0000
  771.4488     136.5378     345.6149     393.2659     526.1071     547.0201       1.8281     311.0000       0.0172      -0.0185       5.1050      50.6960     302.0611       2.0514      46.5887       0.0383       0.0748       4.7788    2680.5618     293.7430     105.6250    2141.0000
  771.6012     146.2688     617.8104     835.8547     952.6063    1015.9981       0.9843     311.0000       0.0111      -0.0249       5.1667      52.1430     301.5148       2.6119      46.5887       0.0417       0.0779       4.7808    2691.0120     250.3005     105.6250    2197.0000
  771.7536     219.9457     689.6892     494.3586     606.8848     561.9623       1.7795     311.0000       0.0116      -0.0243       5.1394      47.4488     302.6075       5.1737      46.5887       0.0352       0.0712       4.7633    2690.1060     361.8943     105.6250    2205.0000
  771.9060     168.4979     286.2668     378.1453     435.4472     390.9206       2.5581     311.0000       0.0145      -0.0214       5.0337      48.4119     304.2464       6.7360      46.5887       0.0304       0.0658       4.7250    2685.2473     441.8361     105.6250    2233.0000
  772.0584     137.5181     224.8210     237.7990     268.3434     256.5854       3.8973     311.0000       0.0231      -0.0124       5.3013      48.9868     304.7927       3.8671      46.5887       0.0347       0.0709       4.6836    2670.5261     567.0894     105.6250    2267.0000
  772.2108     135.4168     234.4593     243.1289     265.8629     249.0259       4.0156     311.0000       0.0244      -0.0111       5.3783      52.0883     303.7001       5.1043      46.5887       0.0354       0.0717       4.7011    2668.2571     375.5578     105.6250    2159.0000
  772.3632     103.0394     234.6957     258.3542     286.5837     269.6632       3.7083     311.0000       0.0300      -0.0052       5.3979      52.5391     303.1538       4.6129      46.5887       0.0434       0.0804       4.7600    2658.6287     351.9612     105.6250    2166.0000
  772.5156     129.9411     272.3777     310.3192     352.9839     325.4482       3.0727     311.0000       0.0311      -0.0041       5.1879      52.7762     302.6075       4.3619      46.5887       0.0510       0.0888       4.7875    2656.7925     293.0731     105.6250    2150.0000
  772.6680     139.5803     418.3182     331.1638     414.7877     365.3494       2.7371     311.0000       0.0229      -0.0126       4.9619      54.6292     301.5148       8.3590      46.5887       0.0480       0.0856       4.7876    2670.8398     278.9234     105.6250    2153.0000
  772.8204     150.0962     317.6127     345.3524     409.9715     339.7632       2.9432     311.0000       0.0223      -0.0133       5.1881      51.2113     302.8806       6.4867      46.5887       0.0428       0.0806       4.8053    2671.9436     268.5144     105.6250    2165.0000
  772.9728     150.8864     194.5546     218.5037     335.9774     228.0879       4.3843     311.0000       0.0258      -0.0096       5.3538      54.6622     303.7001       3.5889      46.5887       0.0474       0.0853       4.8320    2665.8450     320.9377     105.6250    2159.0000
  773.1252     149.8924     161.2593     177.9420     233.7432     206.9709       4.8316     311.0000       0.0333      -0.0019       5.3390      59.7578     304.7927      -1.5471      46.5887       0.0374       0.0745       4.8042    2653.0593     381.0455     105.6250    2148.0000
  773.2776     132.2646     251.9236     273.7929     385.6521     337.0047       2.9673     311.0000       0.0267      -0.0087       5.3531      62.5679     304.7927       2.7354      46.5887       0.0352       0.0716       4.7339    2664.4053     380.6892     105.6250    2173.0000
  773.4300     131.4765     305.6580     438.4894     501.7726     485.7983       2.0585     311.0000       0.0274      -0.0080       5.4751      57.8212     303.7001       3.7098      46.5887       0.0415       0.0782       4.6751    2663.1216     377.0637     106.1250    2173.0000
  773.5824     125.4240     343.0912     474.7493     541.3825     501.2478       1.9950     311.0000       0.0327      -0.0025       5.4429      52.0260     302.6075       2.7382      46.5887       0.0387       0.0748       4.7060    2654.0596     279.1784     106.3750    2152.0000
  773.7348     127.2181     217.4706     270.0992     361.8110     443.2697       2.2560     311.0000       0.0386       0.0036       5.2701      51.4515     302.0611      -0.3095      46.5887       0.0454       0.0817       4.7556    2643.9978     299.5624     106.8125    2189.0000
  773.8872     124.1520     206.0184     239.7426     311.1668     398.9026       2.5069     311.0000       0.0274      -0.0080       5.2477      48.8631     303.1538       4.7464      46.5887       0.0330       0.0684       4.8065    2663.1501     314.3379     108.9375    2215.0000
  774.0396     123.8783     176.0847     220.5934     290.7071     369.6502       2.7053     311.0000       0.0061      -0.0301       5.3177      48.0845     304.2464      18.6596      46.5887       0.0252       0.0604       4.8107    2699.6401     310.7524     109.5625    2216.0000
  774.1920     116.6827     151.3939     174.6722     227.5932     272.0307       3.6761     311.0000      -0.0019      -0.0384       5.3852      50.4007     305.8853      20.8445      46.5887       0.0415       0.0782       4.7502    2713.2957     276.5295     110.1875    2169.0000
  774.3444     111.3957     143.0071     151.0319     195.8937     225.0472       4.4435     311.0000       0.0012      -0.0351       5.4158      54.2848     306.9780      17.0395      46.5887       0.0350       0.0709       4.6624    2707.9963     252.2765     111.4375    2162.0000
  774.4968     115.7313     191.2797     255.7952     372.3280     451.1714       2.2165     311.0000       0.0081      -0.0279       5.4448      58.1026     308.0706       9.0828      46.5887       0.0314       0.0666       4.6428    2696.0928     224.1898     111.0000    2170.0000
  774.6492     115.5802     224.0423     317.1231     566.2283     760.3220       1.3152     311.0000       0.0071      -0.0290       5.3641      57.2143     304.2464      10.0622      46.5887       0.0341       0.0694       4.6682    2697.9021     265.5438     111.6875    2173.0000
  774.8016     109.1675     370.1273     445.4911     498.5375     534.1957       1.8720     311.0000       0.0091      -0.0269       5.4201      55.1537     303.1538       9.3474      46.5887       0.0373       0.0723       4.7065    2694.4639     267.1754     111.8125    2176.0000
  774.9540     109.8845     192.7132     250.7392     402.7531     453.2710       2.2062     311.0000       0.0125      -0.0234       5.4531      54.5458     305.8853       5.4498      46.5887       0.0292       0.0636       4.6867    2688.6907     369.4866     111.2500    2202.0000
  775.1064     110.6956     161.7720     232.2518     373.1074     439.6291       2.2746     311.0000       0.0158      -0.0200       5.3750      48.7172     309.1632       3.0160      46.5887       0.0261       0.0601       4.6920    2682.9648     334.4141     111.8125    2174.0000
  775.2588     116.6097     113.9130     158.7470     288.4474     286.3220       3.4926     311.0000       0.0148      -0.0210       5.3164      50.3718     312.4411       2.8763      46.5887       0.0296       0.0649       4.7051    2684.6309     330.0561     113.6875    2206.0000
  775.4112     121.2343     117.9266     149.1704     253.8684     287.3733       3.4798     311.0000       0.0174      -0.0183       5.3395      49.8008     312.9874       1.9343      46.5887       0.0394       0.0755       4.7271    2680.2534     281.2493     112.8750    2152.0000
  775.5636     113.1876     167.8739     201.4659     286.8228     432.7548       2.3108     311.0000       0.0172      -0.0185       5.5677      55.8229     312.9874       1.8966      46.5887       0.0350       0.0707       4.7425    2680.5066     272.7871     112.6250    2157.0000
  775.7160     119.7609     229.1832     311.2168     342.4104     675.1678       1.4811     311.0000       0.0148      -0.0211       5.5445      54.8079     303.7001       4.1370      46.5887       0.0249       0.0591       4.7638    2684.7380     332.9182     114.0000    2170.0000
  775.8684     122.0563     260.7736     452.2862     427.4672    1570.4777       0.6367     311.0000       0.0135      -0.0224       5.4574      49.4781     304.2464       5.4131      46.5887       0.0238       0.0574       4.7661    2686.8779     343.3221     114.0000    2222.0000
  776.0208     116.3537     269.9526     526.3743     932.9651     813.4357       1.2294     311.0000       0.0086      -0.0275       5.5934      51.6731     305.8853      12.0258      46.5887       0.0352       0.0698       4.7824    2695.3464     328.9639     114.8125    2218.0000
  776.1732     115.9541     231.7819     333.0134     547.4117     501.2459       1.9950     311.0000       0.0134      -0.0225       5.5525      54.3515     305.8853       9.9862      46.5887       0.0293       0.0637       4.7779    2687.1372     278.7078     115.3750    2201.0000
  776.3256     118.9085     172.9065     259.5691     428.7888     285.7449       3.4996     311.0000       0.0067      -0.0294       5.3688      57.8211     306.9780      11.9212      46.5887       0.0299       0.0646       4.8134    2698.4641     328.9117     116.3125    2158.0000
  776.4780     117.2208     158.6810     254.3488     461.2448     316.1505       3.1631     311.0000       0.0051      -0.0311       5.4066      56.6054     307.5243      11.1279      46.5887       0.0307       0.0656       4.8115    2701.3611     310.8724     117.3750    2163.0000
  776.6304     120.0126     157.2813     249.7139     440.1505     490.4859       2.0388     311.0000       0.0058      -0.0304       5.6138      54.0154     306.9780      11.3981      46.5887       0.0357       0.0711       4.7986    2700.1587     320.3798     117.1250    2125.0000
  776.7828     120.8130     168.6204     235.8817     378.8204     539.7194       1.8528     311.0000       0.0177      -0.0180       5.6086      53.6428     306.4317       7.5955      46.5887       0.0253       0.0600       4.7763    2679.6982     304.2467     117.4375    2127.0000
  776.9352     120.1048     200.0623     238.7227     405.3279     659.9966       1.5152     311.0000       0.0185      -0.0171       5.6424      50.2276     306.4317       5.2967      46.5887       0.0351       0.0703       4.7476    2678.2957     327.9308     120.2500    2175.0000
  777.0876     116.6808     223.0450     248.8557     361.5316     744.6559       1.3429     311.0000       0.0179      -0.0178       5.5729      50.6908     304.7927      -5.8422      46.5887       0.0286       0.0631       4.7218    2679.3877     441.9449     121.2500    2182.0000
  777.2400     114.2604     232.5854     288.3978     345.8347     644.9645       1.5505     311.0000       0.0164      -0.0194       5.5228      52.1118     303.7001      -8.6217      46.5887       0.0280       0.0625       4.6636    2681.9375     306.4767     123.1875    2168.0000
  777.3924     104.5967     233.9033     301.9191     463.1289     465.8000       2.1468     311.0000       0.0322      -0.0030       5.5003      62.1652     303.7001     -14.8234      46.5887       0.0377       0.0735       4.6877    2654.9287     243.0419     123.9375    2183.0000
  777.5448     109.2329     183.3324     207.1350     292.0370     324.8347       3.0785     311.0000       0.0351       0.0001       5.5421      64.7562     304.7927      -5.0147      46.5887       0.0415       0.0784       4.6938    2649.8960     207.2864     125.1250    2196.0000
  777.6972     100.4469     141.1612     175.9831     240.7813     251.3294       3.9788     311.0000       0.0331      -0.0020       5.6651      66.7683     305.8853      -1.6041      46.5887       0.0365       0.0733       4.6534    2653.3652     220.3175     125.1250    2193.0000
  777.8496      94.9714     114.5988     135.8919     176.9004     180.1870       5.5498     311.0000       0.0253      -0.0102       5.6016      64.3415     305.8853       0.7913      46.5887       0.0509       0.0893       4.5406    2666.7668     181.6014     125.1250    2149.0000
  778.0020      89.5184      98.5124     113.9570     131.5558     157.8432       6.3354     311.0000       0.0139      -0.0220       5.6404      67.8975     305.8853       9.7330      46.5887       0.0510       0.0897       4.5205    2686.3098     169.3211     125.1250    2154.0000
  778.1544      92.5009     138.0416     138.8038     159.3686     192.6529       5.1907     311.0000       0.0047      -0.0315       5.6506      67.3896     305.0659      22.9490      46.5887       0.0511       0.0896       4.5985    2701.8931     194.9258     125.4375    2184.0000
  778.3068      93.0097     138.2797     151.2904     185.0352     246.5514       4.0559     311.0000       0.0083      -0.0277       5.6257      65.4468     304.7927      23.2954      46.5887       0.0430       0.0804       4.6963    2695.7632     219.6118     128.8750    2177.0000
  778.4592      89.7897     181.6295     196.2319     200.1827     286.1054       3.4952     311.0000       0.0088      -0.0272       5.4734      63.8229     302.6075      16.1588      46.5887       0.0425       0.0796       4.7409    2694.9028     201.5636     129.5000    2184.0000
  778.6116      93.1262     193.6642     212.6289     257.7214     288.5994       3.4650     311.0000       0.0068      -0.0293       5.3919      62.8964     303.1538       0.1485      46.5887       0.0430       0.0803       4.6819    2698.3120     176.2664     128.3750    2194.0000
  778.7640      92.2322     131.0589     156.3947     201.7463     224.9236       4.4460     311.0000      -0.0016      -0.0380       5.5865      65.4905     302.6075       5.9698      46.5887       0.0387       0.0762       4.6275    2712.7363     146.6357     130.0000    2170.0000
  778.9164      88.6239      97.7086     117.3500     189.9627     159.0665       6.2867     311.0000      -0.0059      -0.0425       5.6549      63.0942     303.7001      17.9303      46.5887       0.0446       0.0827       4.5835    2720.0891     137.8795     131.0000    2160.0000
  779.0688      84.9139      87.3093     105.8626     146.6156     139.8633       7.1498     311.0000       0.0025      -0.0338       5.5704      67.7491     304.7927      24.9882      46.5887       0.0588       0.0982       4.5714    2705.7476     139.6376     133.3125    2176.0000
  779.2212      81.8028     100.2048     120.5377     164.7292     176.6604       5.6606     311.0000       0.0122      -0.0237       5.6699      64.2233     305.8853      18.2950      46.5887       0.0476       0.0854       4.5964    2689.1118     185.4459     134.9375    2197.0000
  779.3736      87.8525     127.8861     153.6376     191.1620     230.8039       4.3327     311.0000       0.0351      -0.0000       5.6545      59.2842     304.2464       5.5215      46.5887       0.0383       0.0751       4.6356    2650.0173     229.9426     134.9375    2194.0000
  779.5260      92.5635     151.2509     181.7170     204.8267     291.9196       3.4256     311.0000       0.0363       0.0012       5.4885      53.4426     305.3391      19.7244      46.5887       0.0477       0.0846       4.7392    2647.9705     226.5287     134.9375    2207.0000
  779.6784      96.2886     169.9677     188.7986     210.4468     327.4893       3.0535     311.0000       0.0194      -0.0163       5.5585      52.0529     304.7927      46.3502      46.5887       0.0381       0.0746       4.8179    2676.8901     165.3590     136.0625    2202.0000
  779.8308     108.3483     191.8400     220.7019     224.6350     345.5840       2.8937     311.0000       0.0012      -0.0352       5.5970      58.3733     304.2464      61.9788      46.5887       0.0342       0.0706       4.8830    2708.0200     179.4386     135.8125    2204.0000
  779.9832     108.7011     196.6169     230.9461     280.1985     341.7111       2.9264     311.0000       0.0084      -0.0277       5.6424      63.0343     306.4317      44.5998      46.5887       0.0424       0.0798       4.8740    2695.6506     209.4245     138.0625    2172.0000
  780.1356     100.6942     160.5941     190.4537     266.5284     290.8133       3.4386     311.0000       0.0161      -0.0197       5.6581      61.9049     307.2511      27.9951      46.5887       0.0359       0.0727       4.8691    2682.4597     306.0391     139.1250    2182.0000
  780.2880      89.5598     129.0189     163.2981     258.1371     242.2498       4.1280     311.0000       0.0178      -0.0179       5.7815      60.6497     307.5243      25.5625      46.5887       0.0434       0.0806       4.8517    2679.5708     254.1658     139.5000    2190.0000
  780.4404      96.0902     141.7525     186.3484     308.8708     286.5439       3.4899     311.0000       0.0181      -0.0176       5.7270      60.6988     305.8853      32.0339      46.5887       0.0481       0.0859       4.8673    2679.0178     223.2208     140.5625    2173.0000
  780.5928      96.2926     133.3799     184.4842     316.0103     327.4048       3.0543     311.0000       0.0353       0.0002       5.6999      65.9334     304.7927      22.9726      46.5887       0.0439       0.0809       4.8237    2649.6479     193.7818     141.5000    2176.0000
  780.7452     101.0312     145.4847     200.7314     314.0943     337.8154       2.9602     311.0000       0.0522       0.0177       5.6079      69.7025     304.2464      11.1320      46.5887       0.0416       0.0784       4.7343    2620.7539     189.6306     140.9375    2207.0000
  780.8976      99.9802     131.9936     175.1932     264.5234     301.0414       3.3218     311.0000       0.0573       0.0230       5.5918      72.2523     303.1538       4.0441      46.5887       0.0378       0.0742       4.6013    2612.0232     175.2417     141.0625    2173.0000
  781.0500      89.2949     112.4508     146.4705     200.4238     242.4772       4.1241     311.0000       0.0609       0.0267       5.7701      80.4152     304.2464       2.1880      46.5887       0.0317       0.0681       4.5297    2605.8843     180.8430     141.8750    2168.0000
  781.2024      77.1131      99.8927     122.9794     147.8041     174.9011       5.7175     311.0000       0.0468       0.0121       5.8456      86.4374     305.3391       9.4423      46.5887       0.0487       0.0874       4.4601    2630.0520     187.5785     142.5625    2153.0000
  781.3548      64.8549      82.2928     100.6271     128.3408     150.3924       6.6493     311.0000       0.0427       0.0079       5.7297      86.4852     305.8853      10.3908      46.5887       0.0664       0.1077       4.4334    2636.9448     141.6525     144.5000    2205.0000
  781.5072      56.1871      72.9251      85.0854     107.1955     123.7385       8.0816     311.0000       0.0339      -0.0012       5.8233      84.8716     305.8853      12.8808      46.5887       0.0724       0.1152       4.3505    2652.0081      95.5466     144.6875    2223.0000
  781.6596      49.8797      62.7750      73.5658      92.3333     105.5246       9.4765     311.0000       0.0453       0.0106       5.8708      87.0941     305.0659       4.8380      46.5887       0.0870       0.1313       4.3077    2632.5134      65.6563     144.6875    2190.0000
  781.8120      49.6261      59.4765      68.1054      82.9513      94.6413      10.5662     311.0000       0.0479       0.0133       5.7485      91.1644     304.7927       2.6958      46.5887       0.0923       0.1372       4.2916    2628.1370      61.2208     144.6875    2221.0000
  781.9644      52.9837      59.1259      71.6054      87.3411     101.0831       9.8929     311.0000       0.0440       0.0092       5.7490      87.0463     305.8853       1.9007      46.5887       0.1074       0.1530       4.2874    2634.8289      63.5228     144.6875    2204.0000
  782.1168      53.8294      62.0814      69.0187      83.1261      97.7248      10.2328     311.0000       0.0359       0.0009       5.7773      83.7450     307.2511       4.0481      46.5887       0.0778       0.1218       4.3100    2648.5811      81.5857     144.6875    2186.0000
  782.2692      52.1626      58.5092      64.6746      77.0031      93.0278      10.7495     311.0000       0.0199      -0.0157       5.7735      78.2377     308.6169      17.3020      46.5887       0.0747       0.1187       4.3617    2675.9856      86.2187     144.6875    2176.0000
  782.4216      49.3704      58.1098      62.8003      75.3187      92.9281      10.7610     311.0000       0.0084      -0.0277       5.8373      79.6560     308.0706      31.6508      46.5887       0.1118       0.1584       4.4543    2695.6594      83.5297     144.8125    2185.0000
  782.5740      51.0708      69.7168      74.8259      92.8651     119.3975       8.3754     311.0000       0.0040      -0.0322       5.7922      76.0556     308.6169      36.9797      46.5887       0.0961       0.1410       4.5681    2703.1577      76.7499     144.6875    2236.0000
  782.7264      63.3293      88.3450      98.9826     133.1266     183.0238       5.4638     311.0000       0.0074      -0.0287       5.8474      70.4452     305.8853      28.1165      46.5887       0.0610       0.1017       4.6801    2697.2844      88.4863     144.6875    2222.0000
  782.8788      73.2259     130.3805     141.5356     189.7601     239.9487       4.1676     311.0000       0.0196      -0.0161       5.8669      61.3610     304.7927      15.1021      46.5887       0.0495       0.0878       4.8059    2676.5085     124.4614     144.6875    2185.0000
  783.0312     103.5244     161.3436     171.3016     237.5438     324.2187       3.0843     311.0000       0.0260      -0.0095       5.7183      53.9960     304.7927       7.0229      46.5887       0.0314       0.0667       4.8935    2665.6094     184.6608     142.3125    2188.0000
  783.1836     107.8961     175.0257     192.4059     269.4740     381.2170       2.6232     311.0000       0.0278      -0.0075       5.7090      48.2549     305.3391       3.3903      46.5887       0.0284       0.0631       4.8703    2662.3853     275.6720     142.0000    2204.0000
  783.3360      97.4022     138.3344     164.2965     263.3885     361.1627       2.7688     311.0000       0.0175      -0.0182       5.7481      50.0793     306.1585       4.7300      46.5887       0.0128       0.0463       4.7862    2680.0891     314.8832     143.0000    2217.0000
  783.4884      80.9426     118.9012     142.2931     217.5201     280.6590       3.5630     311.0000       0.0046      -0.0316       5.7010      53.9532     306.9780      14.8289      46.5887       0.0355       0.0719       4.7002    2702.0745     204.5874     142.9375    2217.0000
  783.6408      70.3250      98.0941     115.5790     159.5703     204.9590       4.8790     311.0000       0.0008      -0.0355       5.8127      58.9946     307.5243      21.9913      46.5887       0.0707       0.1108       4.6330    2708.6355     153.4162     142.0000    2185.0000
  783.7932      69.8418     113.9660     127.2012     162.6287     209.6356       4.7702     311.0000       0.0019      -0.0344       5.9080      59.9652     306.9780      27.6425      46.5887       0.0567       0.0963       4.5763    2706.7007     149.0535     140.8750    2197.0000
  783.9456      75.7784     118.5751     133.0111     154.5025     211.1615       4.7357     311.0000       0.0150      -0.0208       5.6637      60.7756     304.2464      18.6472      46.5887       0.0549       0.0949       4.4924    2684.3752     143.6546     139.0000    2224.0000
  784.0980      76.9395     118.9867     142.8566     162.3272     206.0919       4.8522     311.0000       0.0189      -0.0168       5.5507      64.0231     305.6122      15.2500      46.5887       0.0702       0.1118       4.4854    2677.7209     142.6706     139.1875    2202.0000
  784.2504      88.2273     132.5037     141.5904     171.8812     195.9556       5.1032     311.0000       0.0196      -0.0161       5.8025      66.7089     306.9780      13.4354      46.5887       0.0684       0.1102       4.4908    2676.5293     159.6961     139.8750    2215.0000
  784.4028      81.9410     125.1286     139.1032     177.5078     187.1969       5.3420     311.0000       0.0120      -0.0239       5.7498      64.7207     307.5243      23.9286      46.5887       0.0615       0.1029       4.5289    2689.4312     152.3141     138.9375    2215.0000
  784.5552      82.2551     117.7022     130.3341     171.2066     185.8515       5.3806     311.0000       0.0096      -0.0264       5.7424      63.5626     309.1632      35.9199      46.5887       0.0691       0.1116       4.5748    2693.6245     145.1232     139.3125    2178.0000
  784.7076      77.0151     120.0974     128.5826     183.7416     186.9421       5.3492     311.0000       0.0121      -0.0238       5.8325      62.7507     308.6169      40.1382      46.5887       0.0929       0.1374       4.6293    2689.2251     133.3703     140.0000    2182.0000
  784.8600      83.8328     134.3950     152.9874     213.1723     249.6148       4.0062     311.0000       0.0189      -0.0168       5.8775      61.2126     307.7975      31.6174      46.5887       0.0927       0.1374       4.6693    2677.6909     158.2409     139.4375    2191.0000
  785.0124      87.3595     154.5398     181.9885     237.6691     309.0127       3.2361     311.0000       0.0310      -0.0043       5.7442      59.7311     309.1632      15.1789      46.5887       0.0793       0.1227       4.7144    2657.0178     200.4822     137.4375    2180.0000
  785.1648      90.5914     136.4163     172.1379     235.3694     314.8135       3.1765     311.0000       0.0352       0.0002       5.6596      54.3755     304.7927       4.4799      46.5887       0.0685       0.1107       4.6992    2649.7292     218.9825     136.3125    2218.0000
  785.3172      97.0519     151.8049     168.4205     240.5852     320.5500       3.1196     311.0000       0.0385       0.0035       5.7733      51.8234     304.2464       0.2351      46.5887       0.0623       0.1032       4.7285    2644.1914     176.3842     135.1875    2241.0000
  785.4696     101.4799     147.6842     163.8983     220.4378     303.4700       3.2952     311.0000       0.0296      -0.0057       5.7098      53.3049     305.3391       0.6235      46.5887       0.0566       0.0969       4.6578    2659.4016     162.2887     134.9375    2237.0000
  785.6220     102.9712     164.2400     176.4942     237.2051     320.6116       3.1190     311.0000       0.0304      -0.0049       5.7578      50.3112     306.4317      -1.5380      46.5887       0.0582       0.0983       4.7026    2658.0420     203.4992     134.9375    2220.0000
  785.7744     107.0524     186.3062     192.0757     256.5150     328.7774       3.0416     311.0000       0.0227      -0.0128       5.8039      49.9356     308.0706      -0.7896      46.5887       0.0547       0.0941       4.6522    2671.1536     272.4214     134.9375    2207.0000
  785.9268     107.8332     203.9076     218.6252     316.9666     376.8125       2.6538     311.0000       0.0231      -0.0124       5.8593      48.7775     306.1585      -0.8819      46.5887       0.0413       0.0787       4.6496    2670.4224     354.6642     134.4375    2196.0000
  786.0792     110.1575     218.0215     230.5623     272.3693     336.1227       2.9751     311.0000       0.0238      -0.0117       5.8163      50.8340     304.2464       0.4036      46.5887       0.0296       0.0654       4.6431    2669.2539     296.1117     134.3750    2191.0000
  786.2316     112.6720     192.4814     192.8697     208.1674     270.0240       3.7034     311.0000       0.0250      -0.0104       5.7450      51.2139     303.1538       2.8577      46.5887       0.0450       0.0824       4.7097    2667.2268     210.1863     132.3750    2221.0000
  786.3840     114.3879     187.6190     185.4694     202.3871     237.3107       4.2139     311.0000       0.0206      -0.0150       5.6026      49.7071     303.7001       2.8672      46.5887       0.0722       0.1120       4.8056    2674.7571     198.7752     134.9375    2254.0000
  786.5364     115.4613     172.7233     166.9262     169.3147     192.7478       5.1881     311.0000       0.0116      -0.0244       5.7539      49.2178     304.7927       3.9189      46.5887       0.0417       0.0797       4.8277    2690.1785     236.2216     134.9375    2238.0000
  786.6888     119.5247     175.8196     161.3463     173.0247     190.8934       5.2385     311.0000       0.0119      -0.0240       5.8804      47.1874     305.8853       3.3815      46.5887       0.0391       0.0771       4.8102    2689.6526     292.1233     134.3750    2204.0000
  786.8412     119.0270     188.3745     173.4619     233.8866     251.5949       3.9746     311.0000       0.0175      -0.0183       5.8062      47.9656     306.9780       3.2537      46.5887       0.0500       0.0888       4.7441    2680.1602     277.5719     133.0625    2205.0000
  786.9936     113.8230     182.7260     199.0678     220.5149     246.5325       4.0563     311.0000       0.0205      -0.0152       5.7966      51.2489     306.4317       2.7468      46.5887       0.0499       0.0891       4.6688    2675.0225     236.1584     134.9375    2209.0000
  787.1460     104.2175     175.7605     215.0667     277.2192     299.5841       3.3380     311.0000       0.0264      -0.0090       5.7274      54.6933     304.7927      -0.8030      46.5887       0.0624       0.1027       4.6942    2664.8848     195.0132     134.5000    2223.0000
  787.2984      99.9368     133.9534     149.8197     205.1103     209.5773       4.7715     311.0000       0.0228      -0.0127       5.8080      51.4844     304.2464       0.6728      46.5887       0.0620       0.1026       4.7078    2671.0010     175.9951     134.9375    2244.0000
  787.4508      92.2525     118.3886     138.0157     174.7113     185.5944       5.3881     311.0000       0.0238      -0.0117       5.8001      46.0515     304.2464       0.9756      46.5887       0.0670       0.1079       4.7152    2669.3777     188.0604     134.9375    2238.0000
  787.6032      88.0355     107.6799     125.5831     177.0267     179.7436       5.5635     311.0000       0.0162      -0.0196       5.8973      48.5204     305.8853       5.9822      46.5887       0.0483       0.0870       4.6309    2682.3191     184.7182     135.4375    2247.0000
  787.7556      95.7732     105.1935     112.1251     133.4779     160.8708       6.2162     311.0000       0.0157      -0.0201       5.7682      51.2998     306.7048       8.2910      46.5887       0.0432       0.0816       4.5741    2683.1396     161.9036     136.5000    2269.0000
  787.9080      95.4361     122.1366     119.9633     134.1278     160.2005       6.2422     311.0000       0.0195      -0.0161       5.7895      54.9537     308.6169       7.5173      46.5887       0.0714       0.1127       4.5397    2676.6101     124.4214     137.5000    2238.0000
  788.0604      98.3921     160.0564     153.1844     196.3454     225.6467       4.4317     311.0000       0.0271      -0.0082       5.8562      53.8502     308.6169       2.9743      46.5887       0.0707       0.1126       4.5743    2663.5764     130.2116     136.7500    2183.0000
  788.2128     110.2454     185.4462     180.4791     183.6683     260.0659       3.8452     311.0000       0.0361       0.0010       5.8847      57.1163     308.6169      -1.6515      46.5887       0.0575       0.0983       4.6662    2648.3149     140.8972     137.4375    2205.0000
  788.3652     106.7463     217.0632     346.5464     485.6621     539.8646       1.8523     311.0000       0.0403       0.0054       5.8543      57.9669     311.8948      -1.5223      46.5887       0.0575       0.0974       4.8149    2641.1379     189.0532     140.6250    2233.0000
  788.5176      99.7512     217.9100     213.5910     245.2355     312.6817       3.1981     311.0000       0.0416       0.0068       5.6696      54.7780     303.7001      -1.2834      46.5887       0.0517       0.0903       4.8932    2638.8103     238.1715     140.2500    2258.0000
  788.6700     104.9301     141.0258     153.5972     214.6693     249.0483       4.0153     311.0000       0.0430       0.0082       5.7365      54.5753     304.2464      -3.5892      46.5887       0.0405       0.0780       4.9115    2636.4988     224.1144     137.5000    2221.0000
  788.8224     105.4334     123.7909     153.3255     198.1710     236.4154       4.2298     311.0000       0.0414       0.0065       5.9365      57.5477     307.2511     -15.0998      46.5887       0.0519       0.0909       4.8332    2639.2676     211.0699     138.4375    2226.0000
  788.9748     106.9052     116.6386     153.1655     182.3883     252.1774       3.9655     311.0000       0.0375       0.0025       5.8156      65.2910     308.3438     -17.5085      46.5887       0.0601       0.1002       4.7080    2645.9194     156.1910     137.4375    2204.0000
  789.1272      98.8892     120.1630     132.9928     137.0841     220.5583       4.5339     311.0000       0.0360       0.0009       5.8398      66.7507     309.1632     -16.5241      46.5887       0.0562       0.0960       4.6003    2648.4624     151.2479     138.0625    2193.0000
  789.2796      99.7209     136.7464     139.6570     160.5047     194.1560       5.1505     311.0000       0.0402       0.0053       5.9815      62.1183     308.6169     -10.2072      46.5887       0.0606       0.1008       4.5357    2641.3276     123.4772     137.8125    2200.0000
  789.4320      92.2086     146.1871     125.5474     147.5869     166.6000       6.0024     311.0000       0.0547       0.0204       5.9497      55.0135     308.6169      -7.4968      46.5887       0.0503       0.0897       4.5614    2616.4187     122.6991     139.5000    2194.0000
  789.5844      86.1853     157.0780     153.3185     165.3727     184.8026       5.4112     311.0000       0.0684       0.0346       5.9407      53.0383     306.4317      28.5864      46.5887       0.0429       0.0815       4.9002    2592.9678     140.8445     139.1875    2232.0000
  789.7368      80.3086     159.3142     153.8911     198.6416     190.0547       5.2616     311.0000       0.0832       0.0499       5.8690      57.2598     306.9780     102.2284      46.5887       0.0523       0.0916       5.4089    2567.7061      29.5563     139.8750    2249.0000
  789.8892      79.2417     116.4891     120.5170     161.2057     148.3633       6.7402     311.0000       0.0949       0.0620       5.8616      56.8238     307.5243     183.1989      46.5887       0.0733       0.1145       5.9524    2547.7400      13.4207     140.2500    2242.0000
  790.0416      76.3167      87.7230     101.5024     148.9645     115.6799       8.6445     311.0000       0.0902       0.0571       5.9609      52.5064     313.8069     228.3928      46.5887       0.0640       0.1044       6.1133    2555.7463       9.6475     140.5000    2240.0000
  790.1940      87.8851      95.3244     112.5522     149.3349     126.5823       7.9000     311.0000       0.0789       0.0454       6.0241      49.6745     317.3580     214.8049      46.5887       0.0473       0.0862       5.9996    2575.0996      10.4743     140.5000    2240.0000
  790.3464      96.9781     115.2779     145.8224     163.7283     174.5053       5.7305     311.0000       0.0574       0.0231       5.9455      48.8925     318.7238     169.8718      46.5887       0.0546       0.0938       5.6799    2611.8933      12.6412     139.9375    2204.0000
  790.4988     117.6009     157.0283     202.6488     205.4772     287.3640       3.4799     311.0000       0.0469       0.0122       5.9438      53.4417     316.8116     111.8584      46.5887       0.0488       0.0878       5.3240    2629.8074      18.4002     138.8750    2226.0000
  790.6512     106.1705     186.8622     268.4595     267.1292     323.2934       3.0932     311.0000       0.0300      -0.0053       6.0944      58.9511     313.5338      73.3747      46.5887       0.0597       0.1002       5.0273    2658.6980      27.7657     140.1875    2258.0000
  790.8036      86.6999     161.7520     227.4939     244.2989     322.4568       3.1012     311.0000       0.0305      -0.0047       6.0084      63.3801     312.9874      38.9357      46.5887       0.0609       0.1015       4.8325    2657.8296      86.3543     142.0625    2228.0000
  790.9560      86.1745     134.5708     160.9721     215.3649     289.6155       3.4529     311.0000       0.0308      -0.0045       5.9494      65.2331     315.1727      19.4640      46.5887       0.0525       0.0923       4.7214    2657.4124     127.7674     143.8125    2255.0000
  791.1084      74.8654     105.0809     118.6756     178.0921     197.8630       5.0540     311.0000       0.0396       0.0047       5.9851      62.5555     306.4317       3.2244      46.5887       0.0646       0.1051       4.6373    2642.2871     138.8644     144.4375    2251.0000
  791.2608      73.1269      88.6162     100.6404     165.2255     136.1703       7.3437     311.0000       0.0364       0.0013       6.0134      64.9530     302.6075       1.2898      46.5887       0.0630       0.1040       4.6056    2647.8411     107.6265     143.8125    2239.0000
  791.4132      73.9174      81.9374      95.3668     138.2608     128.0820       7.8075     311.0000       0.0362       0.0012       6.2181      60.1422     302.0611      -0.4520      46.5887       0.0752       0.1176       4.5849    2648.0444     111.6148     144.6875    2234.0000
  791.5656      70.9805      85.4594      98.0948     127.7784     136.4792       7.3271     311.0000       0.0385       0.0035       6.2075      57.7450     302.0611       0.9222      46.5887       0.0626       0.1044       4.6257    2644.1470     113.4302     144.6875    2220.0000
  791.7180      67.9603      91.6316     102.4239     133.3607     150.2981       6.6534     311.0000       0.0329      -0.0022       6.0065      53.7604     302.8806      15.8634      46.5887       0.0617       0.1030       4.6951    2653.6890     139.7783     144.6875    2320.0000
  791.8704      66.1313      97.3475     110.3659     140.6606     167.6544       5.9646     311.0000       0.0280      -0.0073       6.0130      59.2738     304.2464      26.7673      46.5887       0.0699       0.1118       4.7611    2662.1003     111.5910     144.6875    2238.0000
  792.0228      67.6517      90.8502      96.7874     128.1938     165.9859       6.0246     311.0000       0.0182      -0.0175       6.0476      62.8867     303.7001      35.4342      46.5887       0.0720       0.1137       4.7647    2678.9031     123.7345     145.3750    2198.0000
  792.1752      68.3658      81.7619      89.1678     111.3220     144.9348       6.8997     311.0000       0.0119      -0.0240       6.1600      67.7998     303.4269      31.6026      46.5887       0.0703       0.1123       4.7130    2689.6714     114.8832     146.5000    2234.0000
  792.3276      70.0228      90.1414      99.5110     116.8366     147.0474       6.8005     311.0000       0.0121      -0.0238       6.0636      68.5674     301.5148      23.1426      46.5887       0.0752       0.1180       4.6511    2689.3474     132.8584     147.5000    2224.0000
  792.4800      74.3155      98.5825     104.1777     131.4925     158.9020       6.2932     311.0000       0.0145      -0.0214       6.1025      68.1621     302.0611      15.5735      46.5887       0.0752       0.1181       4.6112    2685.2568     128.5248     147.9375    2178.0000
  792.6324      69.7470      92.0158     101.7784     133.7692     163.3705       6.1211     311.0000       0.0125      -0.0234       6.1589      66.4917     302.6075      17.0481      46.5887       0.0636       0.1054       4.6156    2688.5962     129.6466     149.0000    2188.0000
  792.7848      61.9826      82.0134      89.2907     116.2405     132.4866       7.5479     311.0000       0.0073      -0.0288       6.1525      63.4912     303.1538      18.1885      46.5887       0.0633       0.1046       4.6439    2697.4785     125.0067     151.2500    2207.0000
  792.9372      64.2566      84.5336      93.5963     123.9680     141.9987       7.0423     311.0000       0.0051      -0.0311       6.2628      61.0070     303.1538      17.9238      46.5887       0.0725       0.1143       4.6900    2701.3159     126.8993     153.6875    2236.0000
  793.0896      75.8187     103.2733     121.4367     170.3198     175.7793       5.6890     311.0000       0.0168      -0.0189       6.1115      64.4631     302.6075       8.2943      46.5887       0.0643       0.1052       4.7147    2681.2139     135.5414     154.4375    2264.0000
  793.2420      91.6409     131.8872     156.9189     197.1786     217.2402       4.6032     311.0000       0.0261      -0.0093       6.0862      61.8242     302.8806       5.6486      46.5887       0.0604       0.1013       4.7491    2665.3972     154.8965     154.4375    2254.0000
  793.3944     100.1846     123.5270     146.1491     176.4964     200.7868       4.9804     311.0000       0.0313      -0.0039       6.1741      59.0448     303.1538       4.3280      46.5887       0.0647       0.1059       4.7624    2656.4253     159.3163     154.4375    2234.0000
  793.5468      83.6968      88.6824     109.5190     136.6475     154.9455       6.4539     311.0000       0.0336      -0.0016       6.2418      51.7044     304.7927       2.4164      46.5887       0.0555       0.0957       4.7751    2652.6108     137.8143     155.0000    2210.0000
  793.6992      71.9727      72.4688      83.9985      96.6416     111.5171       8.9672     311.0000       0.0317      -0.0035       6.3015      52.2785     304.7927       1.9052      46.5887       0.0495       0.0884       4.6985    2655.8479     138.7174     154.7500    2200.0000
  793.8516      58.8933      62.6492      76.5857      91.0462     101.9890       9.8050     311.0000       0.0171      -0.0187       6.3287      59.7409     304.7927      12.8894      46.5887       0.0509       0.0899       4.5848    2680.8157     133.2130     154.6875    2254.0000
  794.0040      50.9295      57.1142      67.0484      83.2130      89.3886      11.1871     311.0000       0.0129      -0.0230       6.1252      64.8062     306.4317      20.4346      46.5887       0.0562       0.0967       4.3759    2687.9604     117.1516     156.6250    2241.0000
  794.1564      44.1337      50.5446      50.6530      60.1606      61.6488      16.2209     311.0000       0.0073      -0.0288       6.0651      76.9712     303.7001      34.3001      46.5887       0.0828       0.1265       4.2337    2697.5269      77.0096     158.6875    2255.0000
  794.3088      35.0705      40.4629      44.5858      52.8949      54.3730      18.3915     311.0000       0.0168      -0.0190       6.2690      82.7293     303.4269      49.3741      46.5887       0.1073       0.1538       4.1824    2681.3547      49.2722     159.7500    2255.0000
  794.4612      33.3349      37.8851      43.5850      52.2592      53.6257      18.6478     311.0000       0.0256      -0.0099       6.2642      94.3420     303.1538      89.3602      46.5887       0.0977       0.1440       4.3491    2666.2690      44.1692     159.6250    2286.0000
  794.6136      30.9139      36.1216      43.1467      55.1562      55.6553      17.9677     311.0000       0.0608       0.0266       6.3105      95.3469     305.8853     128.7861      46.5887       0.1111       0.1587       4.6583    2606.0452      29.8128     161.8125    2265.0000
  794.7660      27.2451      28.2986      33.4326      42.7899      43.4434      23.0185     311.0000       0.0807       0.0473       6.3103      94.8654     309.7096     160.0780      46.5887       0.1679       0.2187       4.9365    2572.0269      12.4065     163.1250    2217.0000
  794.9184      29.2830      26.6725      29.7997      36.9021      38.7857      25.7827     311.0000       0.0677       0.0338       6.2426      84.8736     311.3485     168.7741      46.5887       0.1661       0.2170       5.0389    2594.3040      11.1725     162.5000    2225.0000
  795.0708      35.1549      31.4369      37.3386      45.5667      52.9036      18.9023     311.0000       0.0338      -0.0014       6.2248      75.5786     308.3438     157.9444      46.5887       0.1222       0.1708       4.9320    2652.2666      14.0051     161.6250    2267.0000
  795.2232      35.5527      39.9616      46.8507      55.4889      66.6583      15.0019     311.0000       0.0136      -0.0223       6.2404      73.3711     304.7927     134.2528      46.5887       0.1183       0.1665       4.7711    2686.7927      27.0876     164.0000    2260.0000
  795.3756      30.5337      36.0259      40.4369      47.5308      62.0242      16.1227     311.0000       0.0260      -0.0094       6.2201      76.1280     304.7927      92.5260      46.5887       0.1426       0.1920       4.6329    2665.4878      30.2034     162.9375    2253.0000
  795.5280      32.9157      35.1030      39.3111      46.8965      57.8671      17.2810     311.0000       0.0309      -0.0043       6.2872      78.7838     304.7927      68.6519      46.5887       0.1264       0.1749       4.6518    2657.0959      29.8800     163.3750    2254.0000
  795.6804      36.7125      46.9580      48.2498      51.5362      65.9501      15.1630     311.0000       0.0463       0.0116       6.3682      72.7441     316.2654      61.2407      46.5887       0.0845       0.1298       4.7954    2630.8975      51.3013     162.4375    2285.0000
  795.8328      37.0542      57.8217      57.7382      65.1822      79.0629      12.6482     311.0000       0.0510       0.0165       6.2409      69.7331     305.8853      95.6597      46.5887       0.0775       0.1223       5.0337    2622.8154      34.8537     163.3750    2217.0000
  795.9852      36.5535      43.3046      47.2892      57.4033      68.8121      14.5323     311.0000       0.0587       0.0245       6.2965      69.9361     306.9780     128.5229      46.5887       0.1334       0.1816       5.1881    2609.5388      24.9792     162.7500    2232.0000
  796.1376      33.5303      39.6691      41.1795      55.4951      61.2241      16.3334     311.0000       0.0600       0.0259       6.3760      75.5705     310.2559     132.8430      46.5887       0.1288       0.1772       5.1967    2607.3403      14.2526     161.3750    2229.0000
  796.2900      40.9307      40.5833      42.6947      57.2995      61.9055      16.1536     311.0000       0.0506       0.0161       6.4114      75.5705     307.5243     103.5342      46.5887       0.1181       0.1658       5.0613    2623.4402      16.2764     163.1250    2221.0000
  796.4424      40.4763      45.8618      46.6146      62.0347      66.2357      15.0976     311.0000       0.0500       0.0155       6.3756      69.4447     309.4364      66.2389      46.5887       0.1195       0.1675       4.8990    2624.4253      20.0438     162.3125    2204.0000
  796.5948      49.5201      62.0975      61.9688      81.3601     100.1827       9.9818     311.0000       0.0481       0.0135       6.1976      60.9779     308.0706      47.4651      46.5887       0.1109       0.1581       4.8290    2627.7700      40.7521     162.0625    2249.0000
  796.7472      53.2576      79.1646      93.4592     115.1167     129.2569       7.7365     311.0000       0.0502       0.0156       6.3219      59.8138     308.0706      51.2397      46.5887       0.0736       0.1175       4.8339    2624.2354      37.8179     160.0625    2258.0000
  796.8996      55.2248      74.4856      75.0324      97.0270     131.9543       7.5784     311.0000       0.0441       0.0093       6.3914      64.6540     307.5243      58.4955      46.5887       0.0880       0.1325       4.8578    2634.6001      33.7572     160.5625    2215.0000
  797.0520      57.2808      69.8871      66.6344      81.2436     110.8955       9.0175     311.0000       0.0445       0.0098       6.4439      67.0803     306.9780      47.5016      46.5887       0.1014       0.1470       4.8029    2633.8804      30.5776     159.3125    2212.0000
  797.2044      72.0346      84.4775      84.1867     103.3234     134.5869       7.4301     311.0000       0.0534       0.0190       6.3521      67.7318     308.0706      22.8429      46.5887       0.0869       0.1312       4.7694    2618.7227      56.5092     157.5000    2265.0000
  797.3568      78.6877     118.0603     118.5386     157.9029     184.0645       5.4329     311.0000       0.0625       0.0284       6.4402      69.3531     308.0706       1.1215      46.5887       0.0739       0.1166       4.7487    2603.1343      96.5963     154.5000    2279.0000
  797.5092      81.0252     192.4446     190.7233     222.1683     272.7769       3.6660     311.0000       0.0574       0.0231       6.3894      69.1126     305.3391       0.2928      46.5887       0.0589       0.0989       4.7575    2611.9290     140.9881     154.4375    2244.0000
  797.6616      98.4462     236.2176     247.5840     296.2397     310.2398       3.2233     311.0000       0.0523       0.0178       6.2859      68.2837     305.3391       0.4301      46.5887       0.0391       0.0759       4.7537    2620.6150     195.8965     152.6250    2249.0000
  797.8140     135.0648     209.8213     214.2100     295.5685     334.6598       2.9881     311.0000       0.0468       0.0122       6.2956      56.9594     305.8853       7.0558      46.5887       0.0354       0.0710       4.7016    2629.9451     323.8180     150.6875    2242.0000
  797.9664     136.9154     258.6317     235.4299     353.9715     359.4622       2.7819     311.0000       0.0383       0.0033       6.3935      55.2378     305.6122       5.5900      46.5887       0.0300       0.0647       4.5877    2644.5603     412.7841     149.3125    2269.0000
  798.1188     142.3816     264.1752     255.2759     416.2892     334.9220       2.9858     311.0000       0.0273      -0.0081       6.4315      50.1148     305.8853       5.7292      46.5887       0.0270       0.0617       4.4746    2663.3811     472.2103     145.3750    2278.0000
  798.2712     151.9429     365.9850     290.3383     410.6977     413.0558       2.4210     311.0000       0.0232      -0.0123       6.5215      49.5328     306.9780      -2.9049      46.5887       0.0262       0.0604       4.4694    2670.3633     629.1772     144.6875    2284.0000
  798.4236     163.7632     406.8661     424.0798     426.9920     354.7539       2.8189     311.0000       0.0267      -0.0087       6.5100      44.8612     307.5243      -3.1579      46.5887       0.0271       0.0609       4.5766    2664.3853     837.8278     141.3125    2284.0000
  798.5760     146.9535     832.9418     616.3580     791.6460     588.6410       1.6988     311.0000       0.0292      -0.0061       6.4075      44.7234     305.8853      -1.9310      46.5887       0.0205       0.0530       4.6865    2660.0378     742.3057     141.0625    2263.0000
  798.7284     163.7662     559.6507     565.2457     664.2360     522.5030       1.9139     311.0000       0.0301      -0.0052       6.3718      47.5653     305.8853      -0.6759      46.5887       0.0211       0.0533       4.7652    2658.5469     728.2939     137.5000    2251.0000
  798.8808     163.1942     280.2143     300.1268     374.9422     332.6014       3.0066     311.0000       0.0289      -0.0064       6.4180      49.6499     304.5196      -1.0941      46.5887       0.0206       0.0530       4.7801    2660.5051     449.6810     138.5000    2284.0000
  799.0332     145.5972     187.0767     211.5855     289.6298     241.1679       4.1465     311.0000       0.0241      -0.0113       6.4634      47.7941     305.8853      -1.6408      46.5887       0.0223       0.0553       4.7269    2668.7122     434.5389     136.0000    2290.0000
  799.1856     141.3769     166.9438     181.8213     216.1957     190.1845       5.2581     311.0000       0.0224      -0.0131       6.5365      44.3793     306.9780      -1.8711      46.5887       0.0260       0.0601       4.6994    2671.6472     348.2953     135.8750    2334.0000
  799.3380     131.7474     208.9475     228.1279     269.9861     308.7731       3.2386     311.0000       0.0196      -0.0161       6.4791      43.2173     308.6169      -0.0978      46.5887       0.0200       0.0534       4.6360    2676.5571     363.6442     134.9375    2333.0000
  799.4904     130.3962     213.0596     290.4269     363.3716     615.3243       1.6252     311.0000       0.0242      -0.0113       6.5005      48.8905     308.6169       0.6673      46.5887       0.0260       0.0605       4.6162    2668.6785     309.5134     134.9375    2346.0000
  799.6428     111.8160     211.7725     346.0231     403.6441     462.1450       2.1638     311.0000       0.0258      -0.0096       6.4165      56.5056     305.8853       1.4548      46.5887       0.0463       0.0825       4.5424    2665.8020     234.1810     134.9375    2361.0000
  799.7952     100.9798     169.2947     188.9402     237.5386     274.7337       3.6399     311.0000       0.0265      -0.0089       6.4961      59.7808     303.7001       2.1923      46.5887       0.0374       0.0739       4.5236    2664.6926     200.5086     134.0625    2302.0000
  799.9476      90.8672     120.9919     147.6184     186.1723     215.3260       4.6441     311.0000       0.0199      -0.0158       6.4412      56.1664     303.1538       4.5938      46.5887       0.0466       0.0842       4.5561    2676.0364     153.7598     133.0625    2282.0000
  800.1000      86.4547      94.6518     112.6150     158.8253     168.2517       5.9435     311.0000       0.0130      -0.0229       6.4392      55.7032     306.4317       5.9247      46.5887       0.0502       0.0885       4.5881    2687.7959     134.1629     133.0625    2274.0000
  800.2524      91.4578      79.2167      93.6245     118.3309     127.2249       7.8601     311.0000       0.0061      -0.0301       6.4814      55.7032     306.4317      14.1613      46.5887       0.0455       0.0835       4.6540    2699.5913     140.3165     132.1875    2242.0000
  800.4048      85.7681      88.5394      99.1166     123.6890     140.9301       7.0957     311.0000       0.0129      -0.0230       6.5014      55.1541     308.6169      12.7482      46.5887       0.0475       0.0852       4.6509    2688.0129     137.6589     131.3750    2255.0000
  800.5572      90.2934     126.9198     143.3722     172.0670     204.2975       4.8948     311.0000       0.0220      -0.0136       6.6074      55.2355     309.1632      11.0137      46.5887       0.0323       0.0684       4.6749    2672.3843     156.5839     129.5000    2280.0000
  800.7096      90.5287     177.7684     283.0060     392.7617     321.3078       3.1123     311.0000       0.0344      -0.0007       6.5750      59.0517     306.9780       0.7415      46.5887       0.0333       0.0697       4.6762    2651.1580     169.5606     131.0625    2294.0000
  800.8620      84.7711     220.7652     265.2282     265.2198     276.5186       3.6164     311.0000       0.0331      -0.0021       6.5070      59.7843     304.2464      -0.6971      46.5887       0.0535       0.0916       4.6686    2653.3953     176.9876     132.5625    2254.0000
  801.0144      87.1364     121.2892     137.0662     228.4415     241.6375       4.1384     311.0000       0.0218      -0.0138       6.5873      57.8499     304.2464       1.9181      46.5887       0.0495       0.0878       4.6467    2672.7639     186.0464     134.9375    2268.0000
  801.1668      84.0966     100.2494     114.0364     192.3837     172.4754       5.7979     311.0000       0.0081      -0.0280       6.4719      54.4055     305.8853       5.8885      46.5887       0.0463       0.0843       4.6041    2696.1758     167.2548     134.0000    2290.0000
  801.3192      80.8197      99.2664     114.8242     172.6060     167.2959       5.9774     311.0000       0.0012      -0.0351       6.5453      56.2520     307.2511       8.5058      46.5887       0.0456       0.0843       4.5357    2707.9824     155.9879     135.5000    2286.0000
  801.4716      82.5873     108.2032     124.1294     160.1385     186.9888       5.3479     311.0000      -0.0008      -0.0372       6.6600      55.5571     309.1632       9.3899      46.5887       0.0556       0.0954       4.4388    2711.3193     125.6955     138.4375    2288.0000
  801.6240      82.3752     111.0930     123.0848     163.3681     206.5281       4.8420     311.0000       0.0010      -0.0353       6.6882      57.4182     309.1632       7.4508      46.5887       0.0634       0.1042       4.3498    2708.3196     120.8539     137.5625    2272.0000
  801.7764      78.4481     110.6345     124.7920     140.6145     229.9583       4.3486     311.0000       0.0039      -0.0323       6.5498      62.0194     305.8853       5.2254      46.5887       0.0639       0.1047       4.3183    2703.3655     116.7328     137.1875    2260.0000
  801.9288      77.2198     106.2743     121.7465     147.6796     219.8234       4.5491     311.0000       0.0109      -0.0251       6.6068      64.8899     304.2464       1.9205      46.5887       0.0576       0.0978       4.3323    2691.4143     105.8198     137.8125    2297.0000
  802.0812      72.2352      92.8651     105.0236     135.8682     166.8647       5.9929     311.0000       0.0179      -0.0178       6.5767      65.6628     302.6075      -0.2766      46.5887       0.0563       0.0965       4.3571    2679.3931     104.3801     141.8750    2302.0000
  802.2336      68.1682      85.1351      95.2622     122.6865     138.3254       7.2293     311.0000       0.0174      -0.0183       6.5351      62.1885     303.1538      -0.7818      46.5887       0.0583       0.0983       4.3512    2680.2117      98.1629     141.0000    2320.0000
  802.3860      66.6696      76.8242      86.4597     115.3006     123.0765       8.1250     311.0000       0.0142      -0.0217       6.6353      60.5289     303.7001      -0.4177      46.5887       0.0524       0.0921       4.3105    2685.7659     119.9371     141.0625    2289.0000
  802.5384      66.2383      72.8691      81.8457     103.5884     117.7828       8.4902     311.0000       0.0135      -0.0224       6.6900      63.3355     304.2464       0.2534      46.5887       0.0639       0.1047       4.2905    2686.9456     107.2624     141.5625    2273.0000
  802.6908      63.2373      72.8747      79.0625      94.1969     116.3339       8.5960     311.0000       0.0161      -0.0197       6.6482      64.1984     304.2464       0.9899      46.5887       0.0731       0.1153       4.3284    2682.4895      95.3593     140.6875    2241.0000
  802.8432      66.9330      80.8386      88.1740     107.0579     130.7797       7.6464     311.0000       0.0158      -0.0200       6.6694      68.7779     303.7001       3.4339      46.5887       0.0684       0.1102       4.4006    2683.0464      90.0641     141.2500    2297.0000
  802.9956      70.2368      88.6094      97.1746     117.5024     143.6825       6.9598     311.0000       0.0221      -0.0134       6.6285      66.0104     302.0611       4.0278      46.5887       0.0570       0.0974       4.4403    2672.1418     109.7999     144.6875    2339.0000
  803.1480      69.4973      89.2883      96.4707     113.8658     140.8316       7.1007     311.0000       0.0188      -0.0169       6.6160      64.2237     303.4269      13.8884      46.5887       0.0572       0.0973       4.4864    2677.8765      94.1614     143.6250    2297.0000
  803.3004      69.6063      89.0604      94.3460     115.6996     135.4950       7.3803     311.0000       0.0246      -0.0109       6.7429      58.8964     303.1538      13.6108      46.5887       0.0566       0.0965       4.4764    2667.9199      90.5992     144.3750    2330.0000
  803.4528      72.6555      93.1740      99.9993     131.4811     137.5268       7.2713     311.0000       0.0217      -0.0138       6.7250      58.8964     304.2464      19.0749      46.5887       0.0659       0.1069       4.5135    2672.8218      94.2564     144.6875    2381.0000
  803.6052      77.1507     101.4077     108.6830     140.1111     156.4145       6.3933     311.0000       0.0226      -0.0130       6.6378      55.1879     304.7927      33.3860      46.5887       0.0485       0.0877       4.6199    2671.3738     121.5644     144.6875    2336.0000
  803.7576      82.5698     108.9116     123.9856     161.1812     159.7478       6.2599     311.0000       0.0129      -0.0230       6.7014      56.7460     308.6169      70.0638      46.5887       0.0529       0.0928       4.8206    2688.0220     132.5089     145.0000    2286.0000
  803.9100      86.7635     120.8817     136.4410     175.8295     186.6542       5.3575     311.0000       0.0062      -0.0300       6.8111      54.8834     303.1538     101.5322      46.5887       0.0765       0.1186       5.0060    2699.4690      70.8610     146.5625    2264.0000
  804.0624      89.1736     116.8856     133.2869     170.4164     181.1429       5.5205     311.0000       0.0086      -0.0274       6.8763      61.8811     304.7927     101.4991      46.5887       0.0815       0.1247       5.0248    2695.2510      76.2008     144.6875    2310.0000
  804.2148      79.6413      97.0524     114.6344     146.9240     163.9294       6.1002     311.0000       0.0134      -0.0225       6.6644      62.6916     305.3391      80.7052      46.5887       0.0598       0.1009       4.8851    2687.0825      84.7376     144.6875    2280.0000
  804.3672      70.5680      82.6558      97.9735     123.9351     138.3795       7.2265     311.0000       0.0110      -0.0249       6.6132      63.5392     303.7001      56.4661      46.5887       0.0665       0.1080       4.6358    2691.1172     112.2240     146.8750    2279.0000
  804.5196      62.7273      74.8497      85.3399     106.7942     119.5823       8.3624     311.0000       0.0177      -0.0180       6.6980      62.7952     304.7927      31.3451      46.5887       0.0604       0.1010       4.4005    2679.6721     105.1205     146.4375    2295.0000
  804.6720      57.2638      67.1099      77.0818      93.7101     108.2600       9.2370     311.0000       0.0304      -0.0049       6.9514      66.8938     303.1538      12.6569      46.5887       0.0632       0.1044       4.2832    2658.0979      87.6732     149.6875    2287.0000
  804.8244      52.6122      62.0004      69.8163      86.6789      95.1669      10.5079     311.0000       0.0475       0.0128       6.8490      72.4787     304.7927      -0.4420      46.5887       0.0690       0.1112       4.2482    2628.8323      80.7889     149.6250    2280.0000
  804.9768      49.2369      59.5273      63.4567      81.0159      87.9780      11.3665     311.0000       0.0561       0.0218       6.7938      80.0831     305.3391      -1.4467      46.5887       0.0797       0.1233       4.3088    2614.0994      63.9950     148.1250    2286.0000
  805.1292      48.9775      53.8008      61.1618      75.8490      84.1643      11.8815     311.0000       0.0602       0.0261       6.8038      84.8995     303.9733      -2.6793      46.5887       0.0825       0.1260       4.3291    2606.9888      71.6623     147.8125    2261.0000
  805.2816      49.2956      52.8972      57.9163      70.9002      81.4447      12.2783     311.0000       0.0578       0.0235       6.9213      94.6275     303.7001      -3.0210      46.5887       0.0742       0.1170       4.2755    2611.2004      76.8385     149.1250    2278.0000
  805.4340      50.8432      51.5911      56.4502      68.6431      79.7621      12.5373     311.0000       0.0541       0.0197       6.8278     107.1338     304.2464      -0.5274      46.5887       0.0628       0.1046       4.1041    2617.5659      80.7592     146.1250    2299.0000
  805.5864      44.4003      51.8070      53.6374      63.9782      75.9759      13.1621     311.0000       0.0555       0.0212       6.7093     113.5302     305.8853       3.0437      46.5887       0.0831       0.1268       3.9345    2615.0991      70.4478     147.7500    2294.0000
  805.7388      39.6576      45.1118      48.8396      57.1201      69.5927      14.3693     311.0000       0.0607       0.0266       6.8731     118.2387     304.7927       5.7597      46.5887       0.1067       0.1528       3.8664    2606.1809      49.8644     144.6875    2312.0000
  805.8912      39.9204      42.1074      45.1843      51.3933      61.9014      16.1547     311.0000       0.0695       0.0357       6.8482     113.8522     304.7927       4.4510      46.5887       0.1010       0.1473       3.9212    2591.1038      48.9195     144.6875    2274.0000
  806.0436      42.2787      46.2542      47.1193      54.6546      65.7311      15.2135     311.0000       0.0602       0.0261       6.8551     117.4813     309.7096      11.4160      46.5887       0.0932       0.1389       3.9938    2606.9863      50.6388     144.6875    2280.0000
  806.1960      43.8914      54.6874      53.6370      62.9641      74.2886      13.4610     311.0000       0.0549       0.0205       6.9250     114.7141     305.8853      28.8458      46.5887       0.0737       0.1178       4.1479    2616.1680      64.1875     144.6875    2263.0000
  806.3484      42.0325      58.2139      60.9131      72.3705      85.5692      11.6865     311.0000       0.0350      -0.0001       6.8195     114.7401     304.2464      61.9888      46.5887       0.1105       0.1573       4.2955    2650.1499      42.5601     143.4375    2273.0000
  806.5008      40.1034      52.5730      54.8728      66.6223      76.8524      13.0120     311.0000       0.0293      -0.0060       6.7916     114.0349     303.7001      80.9085      46.5887       0.1623       0.2124       4.4593    2659.9451      25.6326     144.6875    2297.0000
  806.6532      50.8530      53.5051      53.4102      70.0515      76.5454      13.0641     311.0000       0.0249      -0.0106       6.8619     106.4688     304.7927      67.4145      46.5887       0.1526       0.2018       4.5263    2667.4563      26.8215     142.7500    2321.0000
  806.8056      77.6672      94.1854      95.7885     121.0755     141.8392       7.0502     311.0000       0.0254      -0.0100       7.0191      89.3736     318.9969      33.9789      46.5887       0.0641       0.1050       4.7019    2666.5676      51.8527     144.6875    2319.0000
  806.9580     168.1660     268.6314     240.3616     241.3530     248.8647       4.0182     311.0000       0.0254      -0.0100       6.9820      62.8313     307.5243       5.1813      46.5887       0.0110       0.0436       4.9860    2666.4878     295.8176     142.7500    2328.0000
  807.1104     192.1278     270.5948     603.5339     827.7944    1149.2596       0.8701     311.0000       0.0181      -0.0176       6.9080      47.6102     306.9780      -0.6299      46.5887      -0.0031       0.0254       5.1519    2679.0415    3473.7314     143.6875    2311.0000
  807.2628     168.3729     287.9519     453.2790     633.6942     848.7280       1.1782     311.0000       0.0161      -0.0196       6.8426      39.1023     308.0706       0.9069      46.5887      -0.0084       0.0187       5.0785    2682.4065    1131.7659     144.6875    2289.0000
  807.4152     155.6226     356.5461     426.2727     680.3114     671.5884       1.4890     311.0000       0.0054      -0.0307       6.9363      42.7793     308.0706      12.8593      46.5887       0.0141       0.0439       4.8611    2700.7275     511.9773     143.3125    2365.0000
  807.5676     135.2674     261.6828     345.3963     516.9404     504.6330       1.9816     311.0000       0.0105      -0.0255       7.0627      48.8014     306.4317      18.4062      46.5887       0.0246       0.0567       4.7502    2692.0388     366.5326     141.6875    2339.0000
  807.7200     125.4163     237.1703     273.3737     420.5608     373.7915       2.6753     311.0000       0.0228      -0.0127       7.0702      56.1092     305.0659      24.1435      46.5887       0.0161       0.0483       4.7816    2670.9688     312.1561     142.3750    2307.0000
  807.8724     120.3617     196.7538     233.5312     340.7707     275.6343       3.6280     311.0000       0.0312      -0.0040       6.8777      58.9158     305.8853      29.3608      46.5887       0.0254       0.0586       4.8439    2656.6169     151.8742     140.0000    2290.0000
  808.0248     116.5129     146.2983     177.6702     235.1665     207.3042       4.8238     311.0000       0.0284      -0.0069       6.9432      57.5260     306.9780      33.3614      46.5887       0.0281       0.0622       4.8932    2661.3833      92.7990     138.5000    2287.0000
  808.1772     120.3035     162.7452     194.4187     234.0801     223.9313       4.4657     311.0000       0.0152      -0.0206       7.0167      59.1101     308.0706      36.9246      46.5887       0.0298       0.0651       4.8658    2684.0012      96.4550     135.8750    2254.0000
  808.3296     126.8777     174.7608     211.6539     223.1827     233.5437       4.2819     311.0000       0.0133      -0.0226       7.0847      61.8539     308.6169      33.9768      46.5887       0.0418       0.0791       4.8107    2687.2354     137.4357     134.9375    2263.0000
  808.4820     100.4286     148.4227     161.3562     195.0952     198.3422       5.0418     311.0000       0.0116      -0.0243       6.9799      66.3642     306.9780      35.4273      46.5887       0.0476       0.0857       4.7540    2690.1128     148.8417     134.9375    2254.0000
  808.6344      88.3096     115.1409     130.8568     159.4365     168.7966       5.9243     311.0000       0.0139      -0.0219       7.1142      66.8621     306.9780      39.2466      46.5887       0.0530       0.0922       4.6958    2686.2122     129.6507     135.0000    2249.0000
  808.7868      73.9188      99.7267     108.8288     133.1350     143.6011       6.9637     311.0000       0.0184      -0.0173       7.0608      69.2284     306.4317      41.7163      46.5887       0.0675       0.1087       4.6444    2678.5027      96.1931     136.1250    2291.0000
  808.9392      69.4842      81.3989      91.1076     111.0800     123.6258       8.0889     311.0000       0.0321      -0.0030       7.1145      75.1592     305.8853      41.6753      46.5887       0.0755       0.1182       4.6384    2655.0276      94.9039     134.9375    2240.0000
  809.0916      74.9004      91.2204     101.4274     119.2778     132.8999       7.5245     311.0000       0.0212      -0.0144       7.0785      76.0857     307.5243      70.3428      46.5887       0.0751       0.1181       4.7501    2673.6780      89.4414     134.3750    2308.0000
  809.2440      79.8371     105.8665     118.0320     145.8370     168.0411       5.9509     311.0000       0.0186      -0.0171       7.1056      75.6797     311.8948      93.6787      46.5887       0.0785       0.1222       4.8833    2678.2109     105.9415     133.4375    2296.0000
  809.3964      81.9526      97.8644     115.5109     153.6679     186.2798       5.3683     311.0000       0.0045      -0.0317       7.0999      67.7864     316.8116     121.0926      46.5887       0.0958       0.1410       4.9792    2702.3279      80.2334     134.9375    2280.0000
  809.5488      77.2306      88.0708      98.3947     135.2239     164.1146       6.0933     311.0000       0.0155      -0.0203       7.1830      63.9307     311.8948     109.1576      46.5887       0.0978       0.1435       4.9691    2683.4966      59.0121     131.9375    2297.0000
  809.7012      82.4306      95.9177     105.2081     131.9207     154.2339       6.4837     311.0000       0.0159      -0.0199       7.1218      64.2919     312.9874      96.1370      46.5887       0.0858       0.1302       4.9462    2682.7732      66.9803     131.3125    2267.0000
  809.8536      82.3360     111.4382     119.9294     155.3952     203.1137       4.9233     311.0000       0.0255      -0.0099       7.1349      65.7308     307.7975      81.8198      46.5887       0.0836       0.1275       4.9476    2666.3569      93.9081     130.3125    2306.0000
  810.0060      85.8050     122.4682     132.8612     166.4978     226.8627       4.4080     311.0000       0.0261      -0.0094       7.1687      68.9726     305.8853      86.1337      46.5887       0.0787       0.1215       4.9861    2665.4373      91.3913     130.3125    2352.0000
  810.1584      85.5858     129.1649     145.1548     185.3917     253.5684       3.9437     311.0000       0.0267      -0.0087       7.1858      63.3622     312.4411      86.7748      46.5887       0.0599       0.1005       4.9779    2664.4058      87.0400     130.9375    2297.0000
  810.3108     106.5109     144.0519     150.3776     197.9300     264.0647       3.7870     311.0000       0.0306      -0.0047       7.2756      59.2610     314.6264      64.2433      46.5887       0.0440       0.0820       4.8893    2657.7119      94.4465     129.5625    2277.0000
  810.4632     123.0984     205.1264     216.8027     250.3890     330.0102       3.0302     311.0000       0.0383       0.0034       7.2946      54.6336     309.1632      31.0271      46.5887       0.0436       0.0810       4.7590    2644.4458     149.7377     128.1250    2307.0000
  810.6156     131.6088     204.5047     268.5807     322.1304     334.4885       2.9896     311.0000       0.0468       0.0122       7.2380      55.5600     308.6169      10.1216      46.5887       0.0366       0.0731       4.6954    2629.8872     248.3773     127.5625    2290.0000
  810.7680     102.8655     152.5976     171.4938     234.5047     239.0846       4.1826     311.0000       0.0325      -0.0027       7.3257      56.1326     307.7975      30.6690      46.5887       0.0306       0.0667       4.7384    2654.4084     208.2134     127.9375    2293.0000
  810.9204      94.1849     129.8909     146.6136     185.3170     199.9306       5.0017     311.0000       0.0145      -0.0214       7.2491      56.9104     306.9780      60.0822      46.5887       0.0536       0.0923       4.8324    2685.2813     210.8033     127.9375    2309.0000
  811.0728      89.9112     121.4032     153.2775     186.0538     211.4565       4.7291     311.0000       0.0097      -0.0263       7.2191      55.7910     306.9780      83.2055      46.5887       0.0527       0.0913       4.9163    2693.3997     196.8694     127.7500    2293.0000
  811.2252      85.3559     122.4995     142.2843     168.6784     190.2303       5.2568     311.0000       0.0169      -0.0188       7.2277      59.0328     306.4317      90.8272      46.5887       0.0517       0.0910       4.9528    2681.0571      88.8627     126.5625    2281.0000
  811.3776      88.2990     122.3538     120.4095     149.9850     172.0931       5.8108     311.0000       0.0298      -0.0055       7.3033      62.8015     308.0706      84.3406      46.5887       0.0523       0.0914       4.9369    2659.0225      66.8063     127.0000    2345.0000
  811.5300      87.1442     109.2218     122.5890     142.8656     172.0706       5.8116     311.0000       0.0312      -0.0040       7.2715      62.5598     308.0706      65.6621      46.5887       0.0571       0.0972       4.8724    2656.6150      59.3051     128.6250    2295.0000
  811.6824      84.5216     115.1960     123.7891     139.3292     172.5638       5.7950     311.0000       0.0301      -0.0052       7.2951      55.7006     308.0706      44.0788      46.5887       0.0577       0.0976       4.8232    2658.5049     101.4199     125.1250    2282.0000
  811.8348      86.7330     128.1229     133.6629     154.4083     198.6777       5.0333     311.0000       0.0165      -0.0193       7.3556      52.2263     305.8853      34.7769      46.5887       0.0592       0.0990       4.8036    2681.8660     135.2572     125.1250    2293.0000
  811.9872      87.7981     122.8731     139.4849     184.1970     225.0817       4.4428     311.0000       0.0070      -0.0291       7.2760      53.0382     305.8853      25.4979      46.5887       0.0438       0.0818       4.7731    2698.0916     165.1948     124.5625    2304.0000
  812.1396      81.1781     110.7086     122.5368     168.4383     198.4193       5.0398     311.0000      -0.0012      -0.0376       7.1913      56.4531     304.7927      22.2836      46.5887       0.0457       0.0838       4.6949    2712.0037     156.5466     125.0625    2265.0000
  812.2920      80.3196     105.6987     113.9006     163.3719     182.2681       5.4864     311.0000       0.0030      -0.0333       7.1899      60.1590     305.3391      17.9625      46.5887       0.0492       0.0877       4.6076    2704.8955     131.0049     120.8750    2269.0000
  812.4444      84.6142     109.8594     124.5456     182.2802     186.6987       5.3562     311.0000       0.0102      -0.0258       7.3670      62.3528     304.7927      20.8037      46.5887       0.0528       0.0914       4.5497    2692.6414     164.4447     118.8750    2301.0000
  812.5968     108.2227     145.9842     149.8621     228.3320     221.3004       4.5187     311.0000       0.0148      -0.0210       7.4622      62.9978     304.7927      23.4091      46.5887       0.0374       0.0740       4.5735    2684.6931     196.1325     119.3750    2286.0000
  812.7492     139.1490     186.0062     202.8551     257.3092     256.8696       3.8930     311.0000       0.0119      -0.0241       7.3171      58.3655     304.7927      25.6205      46.5887       0.0413       0.0775       4.6623    2689.7136     219.0403     117.6875    2250.0000
  812.9016     211.8930     295.0798     272.1836     324.4693     362.7813       2.7565     311.0000       0.0005      -0.0358       7.3881      46.2250     305.8853      32.1012      46.5887       0.0332       0.0675       4.7767    2709.1018     296.1940     118.5625    2246.0000
  813.0540     233.2507     498.5862     615.5045     567.5599     431.6947       2.3165     311.0000      -0.0109      -0.0476       7.4218      33.8284     304.2464      37.0684      46.5887       0.0081       0.0389       4.8153    2728.6206     485.6710     116.0000    2286.0000
  813.2064     169.6899     292.7561     396.3198     365.8521     343.2550       2.9133     311.0000      -0.0049      -0.0414       7.3055      27.1348     304.2464      27.9586      46.5887       0.0017       0.0313       4.6902    2718.3003    1718.8417     116.6250    2319.0000
  813.3588     118.2221     188.4979     193.1984     206.6105     201.1437       4.9716     311.0000       0.0092      -0.0269       7.3938      26.9158     303.7001      27.5216      46.5887       0.0140       0.0458       4.5405    2694.3132    1614.9949     115.3750    2289.0000
  813.5112      99.8967     142.8781     155.0771     165.0787     158.8329       6.2959     311.0000       0.0354       0.0004       7.4707      37.9884     304.7927      31.3423      46.5887       0.0273       0.0628       4.4929    2649.4194    1382.2957     115.3750    2278.0000
  813.6636      89.4960     123.8837     137.0885     148.6077     136.9002       7.3046     311.0000       0.0542       0.0199       7.5148      49.7293     305.8853      85.8913      46.5887       0.0584       0.0995       4.7240    2617.2458     438.7374     115.3750    2270.0000
  813.8160      84.5561     121.2884     140.5728     161.9771     139.8535       7.1503     311.0000       0.0764       0.0428       7.4796      63.7517     305.8853     150.7075      46.5887       0.1278       0.1755       5.0272    2579.4331      41.3109     115.3750    2279.0000
  813.9684      80.9259     103.7268     131.6680     162.1384     141.2585       7.0792     311.0000       0.0706       0.0369       7.5042      78.0672     306.4317     226.0695      46.5887       0.1955       0.2474       5.2603    2589.1902      18.8894     114.7500    2270.0000
  814.1208      76.7167      86.2196     109.9065     144.9887     121.1721       8.2527     311.0000       0.0554       0.0211       7.4361      81.1267     306.4317     231.3898      46.5887       0.1771       0.2283       5.2487    2615.2166      14.4838     113.0000    2270.0000
  814.2732      84.4771      92.0347     117.2769     152.7355     121.0795       8.2590     311.0000       0.0233      -0.0123       7.3979      80.1117     304.7927     190.4204      46.5887       0.1317       0.1801       5.0692    2670.2358      20.6738     112.1250    2273.0000
  814.4256      90.4021     113.6599     151.2736     215.3871     195.8775       5.1052     311.0000       0.0219      -0.0137       7.4470      65.9881     312.9874     101.2571      46.5887       0.0610       0.1025       4.8323    2672.6033      55.5067     110.8750    2289.0000
  814.5780      95.3979     142.1297     202.1113     302.3844     328.2285       3.0467     311.0000       0.0165      -0.0193       7.5531      62.1606     321.4553      50.2081      46.5887       0.0208       0.0564       4.7168    2681.8145     198.0634     108.5000    2289.0000
  814.7304     103.3155     176.2288     251.4528     378.0814     438.2852       2.2816     311.0000       0.0222      -0.0133       7.6759      62.5256     323.3674      24.0772      46.5887       0.0293       0.0645       4.7082    2672.0156     356.6301     106.7500    2279.0000
  814.8828     108.6459     227.6813     333.4683     508.5624     619.8363       1.6133     311.0000       0.0021      -0.0342       7.5984      63.2621     304.7927      45.2132      46.5887       0.0323       0.0674       4.7742    2706.3904     305.2383     105.6250    2267.0000
  815.0352     120.2566     268.9823     401.3055     647.2360     866.1792       1.1545     311.0000       0.0091      -0.0269       7.4238      57.5889     311.3485      45.4054      46.5887       0.0304       0.0655       4.7786    2694.3911     383.0770     105.6250    2257.0000
  815.1876     136.6735     255.5782     424.6917     737.7715     995.0138       1.0050     311.0000       0.0109      -0.0251       7.5575      52.3833     304.7927      48.9824      46.5887       0.0424       0.0783       4.7675    2691.4348     427.4259     105.3125    2281.0000
  815.3400     159.5430     257.4095     426.8976     757.0432     971.5588       1.0293     311.0000       0.0058      -0.0304       7.7079      50.1400     302.6075      49.9513      46.5887       0.0344       0.0697       4.7135    2700.0950     780.9131     104.7500    2329.0000
  815.4924     128.4605     321.9880     410.2088     689.5051     830.5931       1.2040     311.0000      -0.0046      -0.0411       7.5477      49.9673     304.7927      52.8743      46.5887       0.0295       0.0643       4.6363    2717.8208     367.8309     102.3125    2301.0000
  815.6448     116.5977     288.2469     406.2529     653.4960     843.3032       1.1858     311.0000      -0.0036      -0.0401       7.5328      51.3571     305.0659      43.9064      46.5887       0.0263       0.0609       4.5627    2716.1184     296.5886     104.2500    2275.0000
  815.7972      99.9570     260.0268     412.0617     847.6503     974.6508       1.0260     311.0000       0.0082      -0.0279       7.6625      52.7780     305.3391      30.3409      46.5887       0.0323       0.0675       4.5880    2696.0344     287.7142     100.4375    2264.0000
  815.9496     118.4020     242.6348     364.8450     523.5029     695.1350       1.4386     311.0000       0.0063      -0.0298       7.7280      55.1794     304.7927      38.6512      46.5887       0.0350       0.0707       4.7281    2699.2083     244.0310     102.1250    2282.0000
  816.1020     127.8604     255.5398     328.8907     531.1384     584.4603       1.7110     311.0000       0.0032      -0.0330       7.5301      54.5378     305.0659      77.8205      46.5887       0.0266       0.0612       5.0062    2704.4895     251.8130      99.8125    2280.0000
  816.2544     131.5047     219.8633     393.4028     594.2560     628.1152       1.5921     311.0000       0.0011      -0.0352       7.6301      52.5391     303.7001     126.2135      46.5887       0.0413       0.0773       5.2762    2708.0813     198.7199     100.5000    2274.0000
  816.4068     156.6300     178.2214     318.7627     496.8286     433.3743       2.3075     311.0000      -0.0072      -0.0439       7.7860      49.4209     308.0706     160.0535      46.5887       0.0393       0.0748       5.4339    2722.3867     152.5298      98.5000    2260.0000
  816.5592     179.8206     211.3656     392.8009     500.5515     452.3251       2.2108     311.0000      -0.0164      -0.0533       7.7029      52.2575     314.0800     153.2369      46.5887       0.0343       0.0699       5.3894    2737.9646     134.7081      98.7500    2280.0000
  816.7116     190.1843     396.7557     669.5546     890.2844     792.9171       1.2612     311.0000      -0.0073      -0.0440       7.6007      54.6622     313.5338     119.7257      46.5887       0.0315       0.0670       5.2314    2722.5481     197.9826      98.4375    2293.0000
  816.8640     213.1104     546.5375    1703.7937    1715.3969    1704.1689       0.5868     311.0000       0.0065      -0.0296       7.6683      57.6405     304.7927      95.9852      46.5887       0.0314       0.0670       5.1022    2698.8542     383.3572      97.0625    2312.0000
  817.0164     208.7434     670.4166    1950.0000    1950.0000    1950.0000       0.5001     311.0000       0.0089      -0.0272       7.6570      56.0545     304.7927      93.7116      46.5887       0.0355       0.0709       5.0191    2694.8259     321.9333      95.8750    2299.0000
  817.1688     200.2504     695.8678    1690.3112    1716.9440    1741.5950       0.5742     311.0000       0.0027      -0.0336       7.7426      56.0188     304.7927      98.0744      46.5887       0.0324       0.0674       4.9558    2705.3977     309.5985      95.8750    2296.0000
  817.3212     196.7793     605.7613    1300.7401    1327.2726    1555.8760       0.6427     311.0000      -0.0060      -0.0426       7.8229      56.2505     306.4317     103.1790      46.5887       0.0316       0.0668       4.8922    2720.2678     363.6088      93.8125    2285.0000
  817.4736     193.5227     469.3172    1040.9958    1049.2008    1334.6534       0.7493     311.0000      -0.0093      -0.0460       7.7260      57.2286     306.9780     118.8540      46.5887       0.0418       0.0787       4.9267    2725.9729     307.4687      95.8750    2286.0000
  817.6260     198.1934     505.8586     871.4510     859.0685    1176.5546       0.8499     311.0000      -0.0119      -0.0487       7.6340      57.0613     303.1538     149.4162      46.5887       0.0437       0.0813       5.0745    2730.4287     338.6641      93.2500    2287.0000
  817.7784     182.9289     376.2694     654.3226     660.9592     928.3967       1.0771     311.0000      -0.0077      -0.0443       7.6612      60.2519     304.2464     185.6756      46.5887       0.0388       0.0760       5.2705    2723.1675     217.3406      92.9375    2320.0000
  817.9308     173.3402     248.2191     371.1250     373.3308     694.5035       1.4399     311.0000      -0.0113      -0.0481       7.7348      58.2015     304.2464     213.7587      46.5887       0.0443       0.0811       5.4007    2729.3093      80.4332      90.8125    2280.0000
  818.0832     190.4043     254.1617     326.4213     318.3638     502.6061       1.9896     311.0000      -0.0151      -0.0520       7.7660      58.8105     306.9780     200.6621      46.5887       0.0492       0.0865       5.3782    2735.8640      50.4116      91.0625    2294.0000
  818.2356     188.7483     330.2114     428.0140     405.0785     555.2114       1.8011     311.0000      -0.0157      -0.0526       7.6278      54.1098     305.8853     158.7429      46.5887       0.0265       0.0618       5.2520    2736.8467      56.7770      93.3750    2305.0000
  818.3880     190.6303     475.0233     573.2969     504.9604     632.8893       1.5801     311.0000      -0.0103      -0.0471       7.7845      53.8782     305.8853     117.9161      46.5887       0.0376       0.0742       5.1566    2727.6758     129.7894      95.0625    2286.0000
  818.5404     187.2446     460.8005     454.9266     371.1041     427.5561       2.3389     311.0000      -0.0064      -0.0430       7.8326      51.2078     306.4317     104.1193      46.5887       0.0456       0.0820       5.1497    2721.0186     346.0352      93.2500    2281.0000
  818.6928     203.1464     417.9281     605.5853     409.5398     517.1892       1.9335     311.0000      -0.0026      -0.0391       7.6539      53.0666     306.4317     104.9988      46.5887       0.0362       0.0717       5.1805    2714.4524     216.7720      95.6875    2295.0000
  818.8452     241.4142     553.4232     522.8600     592.5130     479.1039       2.0872     311.0000      -0.0022      -0.0386       7.6112      56.0777     307.5243      98.6626      46.5887       0.0280       0.0629       5.1296    2713.7620     106.7787      95.8750    2281.0000
  818.9976     175.5355     254.2997     344.7687     403.5990     313.4644       3.1902     311.0000       0.0009      -0.0354       7.8316      59.3570     307.5243      87.7049      46.5887       0.0345       0.0706       5.0304    2708.4705     126.7368      95.8750    2303.0000
  819.1500     143.6942     170.6914     208.6212     294.4879     202.1303       4.9473     311.0000       0.0015      -0.0348       7.9200      61.7531     306.9780      69.8390      46.5887       0.0348       0.0706       4.9429    2707.4219     157.6761      95.1875    2290.0000
  819.3024     129.9776     157.2149     197.8498     279.1163     215.1329       4.6483     311.0000       0.0045      -0.0317       7.7528      58.5471     308.6169      50.0290      46.5887       0.0345       0.0702       4.8832    2702.3220     313.2276      96.0625    2312.0000
  819.4548     140.9774     208.5494     257.8044     389.3073     332.8028       3.0048     311.0000       0.0046      -0.0316       7.7171      56.2808     308.6169      41.6574      46.5887       0.0318       0.0669       4.8533    2702.1335     334.1603      97.7500    2280.0000
  819.6072     156.9598     284.7149     394.1163     549.0154     512.6204       1.9508     311.0000       0.0072      -0.0289       7.8284      58.5096     306.9780      36.7136      46.5887       0.0286       0.0636       4.7869    2697.7454     270.7186      98.0625    2266.0000
  819.7596     166.5876     299.0699     458.5838     591.0609     588.3140       1.6998     311.0000       0.0069      -0.0292       7.8511      69.1274     307.5243      36.0942      46.5887       0.0425       0.0783       4.6881    2698.1743     239.6397      99.8125    2295.0000
  819.9120     176.2712     279.9413     372.6130     513.5589     536.6450       1.8634     311.0000       0.0105      -0.0255       7.7703      76.6715     303.9733      26.7818      46.5887       0.0395       0.0749       4.5342    2692.0757     261.9285     102.6875    2302.0000
  820.0644     168.5856     234.5149     312.6393     423.9074     463.4583       2.1577     311.0000       0.0123      -0.0237       7.7167      76.7155     306.4317      20.6766      46.5887       0.0241       0.0584       4.3925    2689.0471     552.4443     103.6875    2287.0000
  820.2168     143.0010     218.1788     281.1113     390.7368     397.5791       2.5152     311.0000       0.0170      -0.0188       7.8430      73.7044     306.7048      15.6095      46.5887       0.0297       0.0653       4.2839    2680.9612     503.7332     105.6250    2312.0000
  820.3692     133.7218     190.6455     234.5380     278.5670     323.0881       3.0951     311.0000       0.0258      -0.0096       7.8027      74.3134     305.8853       9.6881      46.5887       0.0424       0.0791       4.2098    2665.7971     573.0514     106.4375    2289.0000
  820.5216     127.1313     230.3032     257.5562     336.8639     383.3765       2.6084     311.0000       0.0407       0.0059       7.7904      80.6452     306.9780       2.3985      46.5887       0.0377       0.0744       4.2268    2640.3416     278.3574     105.6250    2261.0000
  820.6740     128.2303     233.1387     287.1557     302.5514     411.7343       2.4288     311.0000       0.0536       0.0192       7.8374      82.8095     306.9780      -0.9708      46.5887       0.0380       0.0747       4.2610    2618.3386     350.6044     105.6250    2266.0000
  820.8264     124.3782     256.7487     285.7159     352.7185     371.9621       2.6884     311.0000       0.0644       0.0304       7.8272      88.6263     305.8853      -0.8471      46.5887       0.0424       0.0799       4.3424    2599.8025     263.7459     107.0625    2273.0000
  820.9788     128.3310     199.1510     255.1128     340.6816     352.3436       2.8381     311.0000       0.0664       0.0324       7.7927      88.1262     304.2464       3.1488      46.5887       0.0521       0.0902       4.3399    2596.4724     288.3384     110.8750    2313.0000
  821.1312     124.3431     149.6648     197.1244     287.9532     256.7454       3.8949     311.0000       0.0595       0.0253       7.7506      96.4333     304.5196      14.3752      46.5887       0.0535       0.0921       4.3394    2608.3242     132.7500     111.8750    2320.0000
  821.2836     121.9830     149.3297     192.7069     267.2061     208.8217       4.7888     311.0000       0.0541       0.0197       7.8037      93.5860     305.3391      14.6236      46.5887       0.0485       0.0867       4.3086    2617.5439     133.8491     111.1875    2285.0000
  821.4360     120.0673     173.3787     234.4285     318.8860     288.0447       3.4717     311.0000       0.0525       0.0180       7.8747      93.8440     305.8853      11.0741      46.5887       0.0460       0.0846       4.3504    2620.2483     163.4169     115.3750    2311.0000
  821.5884     126.1811     222.3116     306.2949     391.5587     406.3542       2.4609     311.0000       0.0563       0.0219       7.8586      89.8501     306.7048       0.2041      46.5887       0.0543       0.0926       4.3743    2613.7996     277.3474     115.3750    2295.0000
  821.7408     131.3589     217.5717     315.0986     347.5627     486.8293       2.0541     311.0000       0.0415       0.0067       7.8303      93.0928     306.4317      10.0803      46.5887       0.0350       0.0715       4.4152    2638.9919     292.7533     115.3750    2288.0000
  821.8932     129.4228     218.4780     282.9555     368.9347     461.8041       2.1654     311.0000       0.0399       0.0049       7.8359      89.8449     305.8853       9.8124      46.5887       0.0293       0.0647       4.4325    2641.8406     460.6457     113.5625    2318.0000
  822.0456     135.6478     209.4213     270.7227     333.9973     425.3694       2.3509     311.0000       0.0323      -0.0029       7.8742      82.2093     305.3391      13.8524      46.5887       0.0444       0.0809       4.4446    2654.7949     486.8039     112.9375    2296.0000
  822.1980     146.0059     220.5705     270.7494     346.1474     405.3829       2.4668     311.0000       0.0369       0.0019       7.8779      76.5565     303.1538       6.7949      46.5887       0.0322       0.0673       4.4629    2646.8271     523.7648     113.6250    2309.0000
  822.3504     132.7643     195.9287     245.6226     351.2964     395.7340       2.5269     311.0000       0.0248      -0.0107       7.8334      75.6967     305.3391      12.0795      46.5887       0.0292       0.0638       4.4436    2667.6069     560.5197     115.3750    2296.0000
  822.5028     131.7692     170.9359     199.6023     250.9908     247.0355       4.0480     311.0000       0.0183      -0.0174       7.8768      75.7473     305.8853       9.7618      46.5887       0.0277       0.0624       4.4191    2678.7585     417.2999     117.0625    2313.0000
  822.6552     128.6895     202.8615     293.5969     431.2635     445.7837       2.2432     311.0000       0.0157      -0.0201       7.8991      77.7734     305.8853       2.1586      46.5887       0.0288       0.0641       4.3643    2683.1816     377.3799     115.3750    2263.0000
  822.8076     143.5764     255.9616     487.7727     430.2354     543.8085       1.8389     311.0000       0.0101      -0.0259       7.8521      80.2701     306.9780      -3.6325      46.5887       0.0353       0.0719       4.3253    2692.7014     344.6805     116.6250    2302.0000
  822.9600     153.4073     331.5256     689.2028     938.9214     624.7881       1.6005     311.0000       0.0182      -0.0175       7.8900      84.8103     306.4317      -0.3042      46.5887       0.0493       0.0878       4.3175    2678.9329     425.6171     116.4375    2325.0000
  823.1124     138.1212     229.3937     295.7564     420.2868     361.2666       2.7680     311.0000       0.0283      -0.0070       7.9501      83.3414     304.7927       9.3548      46.5887       0.0573       0.0965       4.3192    2661.6147     197.9737     117.7500    2345.0000
  823.2648     123.9384     153.8113     218.5320     337.2588     291.4878       3.4307     311.0000       0.0296      -0.0057       7.8656      87.9972     303.7001      28.7728      46.5887       0.0651       0.1045       4.3038    2659.3901     203.0721     117.7500    2339.0000
  823.4172     116.1019     116.2905     156.7660     278.2518     204.3389       4.8938     311.0000       0.0378       0.0028       7.8309      89.1601     304.2464      23.1261      46.5887       0.0414       0.0786       4.2667    2645.4285     162.7781     119.4375    2272.0000
  823.5696     108.7158     103.2088     134.6265     196.4424     177.2245       5.6426     311.0000       0.0428       0.0080       7.9181      96.4137     304.7927      16.1524      46.5887       0.0371       0.0742       4.2424    2636.7273     280.1034     120.9375    2293.0000
  823.7220     102.2669     123.7004     161.0342     212.3017     216.6178       4.6164     311.0000       0.0610       0.0268       7.9612      94.1239     305.3391      -3.1908      46.5887       0.0458       0.0844       4.1782    2605.7424     256.3264     121.1250    2297.0000
  823.8744     106.9563     158.4863     201.9273     222.9050     271.0222       3.6897     311.0000       0.0650       0.0310       7.9613      97.1717     305.8853       5.1258      46.5887       0.0448       0.0845       4.1147    2598.7871     378.9633     123.5625    2339.0000
  824.0268      91.2477     142.5924     199.4218     212.1693     285.0380       3.5083     311.0000       0.0609       0.0267       7.8805     100.3020     305.3391      45.5265      46.5887       0.0769       0.1199       4.1848    2605.8826     149.8608     124.5625    2291.0000
  824.1792      80.5271     107.7738     123.3421     143.0149     160.3829       6.2351     311.0000       0.0610       0.0269       7.9369     107.0577     308.0706      99.9413      46.5887       0.1004       0.1461       4.4311    2605.6206      54.2066     125.3750    2278.0000
  824.3316      65.7882      81.7974      96.6949     112.4324     115.7000       8.6430     311.0000       0.0488       0.0142       7.9929     102.6439     306.4317     160.4950      46.5887       0.1446       0.1935       4.7945    2626.4924      25.2746     125.8125    2327.0000
  824.4840      66.4001      79.3297      97.7269     122.9366     119.4594       8.3710     311.0000       0.0523       0.0179       7.9666      93.8813     305.3391     188.0963      46.5887       0.1275       0.1757       5.1001    2620.4890      22.8571     127.3750    2336.0000
  824.6364      70.5062      79.2655     100.4206     134.0477     130.1901       7.6811     311.0000       0.0542       0.0198       7.9626      86.1676     308.0706     203.4118      46.5887       0.0871       0.1326       5.3091    2617.3701      20.7720     129.4375    2302.0000
  824.7888      72.4011      94.3567     104.2443     143.8810     154.2321       6.4837     311.0000       0.0558       0.0215       7.9040      82.2431     311.8948     207.6974      46.5887       0.1035       0.1502       5.3830    2614.5562      20.0778     131.6250    2338.0000
  824.9412      75.7836      97.8175     122.6726     185.5217     203.9274       4.9037     311.0000       0.0393       0.0044       7.9722      83.3064     316.2654     203.9525      46.5887       0.1097       0.1568       5.2695    2642.7397      16.9768     134.9375    2320.0000
  825.0936      81.1984     123.2839     149.3039     221.6790     252.9602       3.9532     311.0000       0.0235      -0.0121       8.1255      87.7614     325.0064     180.1155      46.5887       0.0996       0.1459       5.0019    2669.8992      22.4464     132.4375    2307.0000
  825.2460      74.2833     109.3158     146.0824     212.6296     266.7104       3.7494     311.0000       0.0077      -0.0284       8.0139      94.4701     309.1632     150.1849      46.5887       0.1161       0.1636       4.6959    2696.8257      25.8337     133.6250    2309.0000
  825.3984      68.1839      82.1578     107.2719     172.7973     245.8257       4.0679     311.0000       0.0031      -0.0331       7.8735      96.6988     314.6264     110.3504      46.5887       0.1217       0.1693       4.4438    2704.6487      34.2186     134.2500    2305.0000
  825.5508      59.9791      72.5570      89.3619     143.2306     205.9313       4.8560     311.0000       0.0003      -0.0361       7.9161      86.6668     312.4411      75.2852      46.5887       0.1059       0.1527       4.2843    2709.5388      38.6837     133.3750    2325.0000
  825.7032      71.2834      76.2519      93.5808     133.1889     197.7658       5.0565     311.0000      -0.0009      -0.0373       8.1287      77.7928     318.4506      43.7107      46.5887       0.0878       0.1327       4.1982    2711.5588      71.8128     132.0000    2347.0000
  825.8556      74.4439      92.2372      99.2886     130.6528     194.4372       5.1430     311.0000      -0.0094      -0.0461       8.0474      67.5001     308.0706      34.8516      46.5887       0.0774       0.1213       4.1405    2726.0742     113.6562     132.2500    2330.0000
  826.0080      77.5307     104.6117     111.8200     140.6676     204.1972       4.8972     311.0000      -0.0181      -0.0552       8.0819      66.3420     308.0706      38.4669      46.5887       0.0691       0.1119       4.1235    2741.0161     143.9909     131.5625    2309.0000
  826.1604      81.5102     145.6519     148.8382     150.1616     251.9424       3.9692     311.0000      -0.0219      -0.0591       8.1891      68.5750     308.6169      57.7247      46.5887       0.0783       0.1216       4.1917    2747.4639     118.1274     132.3750    2304.0000
  826.3128     101.0949     152.5162     189.0856     223.1156     303.2708       3.2974     311.0000      -0.0074      -0.0440       8.0585      67.0057     309.7096      71.6743      46.5887       0.0774       0.1206       4.3441    2722.6772      98.3382     132.8750    2282.0000
  826.4652      97.3000     143.4294     142.2918     176.5647     203.7896       4.9070     311.0000      -0.0073      -0.0439       7.9987      66.3918     305.8853      88.9180      46.5887       0.0895       0.1338       4.4887    2722.4993      96.1529     134.3125    2308.0000
  826.6176      97.1914     126.2080     123.8522     160.1066     131.2737       7.6177     311.0000      -0.0023      -0.0387       7.9849      66.3466     303.7001      85.5713      46.5887       0.1030       0.1487       4.5143    2713.9258     108.5015     133.2500    2335.0000
  826.7700     103.8042     131.3729     132.4543     151.3712     131.4808       7.6057     311.0000      -0.0166      -0.0536       8.1041      70.8000     304.7927      79.7210      46.5887       0.0859       0.1308       4.4275    2738.4255     141.2701     130.2500    2369.0000
  826.9224     104.2584     154.9827     165.0302     197.3883     180.0284       5.5547     311.0000      -0.0151      -0.0520       8.2576      69.3817     306.4317      61.7504      46.5887       0.0854       0.1301       4.2900    2735.7439     202.9877     130.3125    2359.0000
  827.0748     109.5515     167.9765     187.4583     201.5868     212.3185       4.7099     311.0000      -0.0198      -0.0568       8.1393      68.6148     306.9780      49.6564      46.5887       0.0770       0.1206       4.1828    2743.7979     192.7606     132.8750    2365.0000
  827.2272     120.7826     183.1155     226.9622     239.2628     292.5920       3.4177     311.0000      -0.0162      -0.0531       8.0981      65.7828     306.9780      35.8970      46.5887       0.0809       0.1242       4.1564    2737.6807     195.2374     130.1875    2346.0000
  827.3796     122.7316     171.8079     200.8793     242.9660     228.0910       4.3842     311.0000      -0.0061      -0.0427       8.0899      63.7916     305.8853      11.6870      46.5887       0.0697       0.1115       4.2236    2720.5132     237.0856     129.4375    2269.0000
  827.5320     119.0550     158.3958     195.1457     238.4651     215.6986       4.6361     311.0000       0.0071      -0.0291       8.1297      56.0487     304.7927     -14.9546      46.5887       0.0598       0.1000       4.3302    2697.9419     327.2274     127.3750    2294.0000
  827.6844     115.5571     143.7815     179.8038     245.1346     209.0351       4.7839     311.0000       0.0074      -0.0287       8.1296      54.8906     303.7001     -25.1772      46.5887       0.0495       0.0881       4.4214    2697.2942     401.0444     125.1250    2339.0000
  827.8368     118.2374     141.7370     175.3733     221.2628     215.6850       4.6364     311.0000      -0.0063      -0.0429       8.1440      58.7053     304.7927     -13.3033      46.5887       0.0456       0.0841       4.4312    2720.7668     283.0215     125.1250    2317.0000
  827.9892     125.0394     170.8512     216.5949     271.1830     304.3054       3.2862     311.0000      -0.0145      -0.0514       8.1467      65.4333     305.8853       2.1777      46.5887       0.0530       0.0925       4.3841    2734.7605     261.3133     125.1250    2335.0000
  828.1416     147.9434     208.9564     280.3022     258.3878     428.2262       2.3352     311.0000      -0.0224      -0.0596       8.2369      64.7384     306.4317      14.7593      46.5887       0.0495       0.0891       4.2850    2748.3796     270.1414     125.1250    2334.0000
  828.2940     166.2300     272.1095     385.7675     430.8267     375.7311       2.6615     311.0000      -0.0276      -0.0650       8.2422      61.9387     308.8901      28.7375      46.5887       0.0566       0.0965       4.1940    2757.2532     316.6089     125.1250    2298.0000
  828.4464     133.8226     208.6017     235.9243     296.6882     305.9005       3.2690     311.0000      -0.0224      -0.0596       8.1847      58.6023     306.9780      26.1104      46.5887       0.0602       0.1005       4.1351    2748.3594     247.8356     125.1250    2294.0000
  828.5988     101.6616     144.0756     165.3494     244.2167     177.6233       5.6299     311.0000       0.0052      -0.0309       8.1360      57.3583     306.9780      17.8361      46.5887       0.0602       0.1007       4.1926    2701.0591     223.7196     122.7500    2271.0000
  828.7512     105.3883     129.3039     153.2364     208.1133     165.6275       6.0376     311.0000       0.0221      -0.0134       8.2146      57.7267     308.3438      45.2201      46.5887       0.0681       0.1094       4.4915    2672.1626     153.2734     122.5000    2293.0000
  828.9036     138.2093     229.3710     285.0392     390.4712     319.0894       3.1339     311.0000       0.0278      -0.0075       8.2962      60.6161     318.4506      92.8016      46.5887       0.0697       0.1118       4.8699    2662.3853      60.1519     121.5625    2351.0000
  829.0560     182.2856     480.0489     700.6523     757.6137     663.4329       1.5073     311.0000       0.0140      -0.0219       8.2223      65.1524     321.7285     142.4661      46.5887       0.0722       0.1145       5.1896    2686.0967      43.5180     121.3750    2346.0000
  829.2084     235.1133     505.3165    1350.1244    1885.6622    1648.6781       0.6065     311.0000       0.0089      -0.0271       8.3061      69.4137     315.7190     142.1697      46.5887       0.0697       0.1120       5.2478    2694.7813      44.1981     122.6250    2358.0000
  829.3608     209.6152     448.6511     618.3790     850.3293     895.1374       1.1171     311.0000       0.0020      -0.0343       8.2516      69.2111     314.6264     119.6725      46.5887       0.0770       0.1194       5.1284    2706.6272      80.6054     120.9375    2311.0000
  829.5132     206.1011     263.6907     461.1237     750.5423     870.0323       1.1494     311.0000      -0.0078      -0.0445       8.1378      69.3437     309.7096      89.0265      46.5887       0.0693       0.1105       4.8941    2723.3987     139.6625     121.5000    2297.0000
  829.6656     164.8803     253.2257     344.7387     573.9265     746.6882       1.3392     311.0000      -0.0054      -0.0419       8.1831      69.9917     305.8853      58.1579      46.5887       0.0553       0.0951       4.6688    2719.1560     220.4182     121.2500    2312.0000
  829.8180     123.3957     174.4546     254.8806     440.2314     594.8793       1.6810     311.0000      -0.0052      -0.0418       8.3891      74.2535     305.8853      47.8320      46.5887       0.0472       0.0857       4.5404    2718.9180     301.9678     123.0625    2352.0000
  829.9704     115.4486     160.9464     211.3517     341.3770     462.0684       2.1642     311.0000       0.0024      -0.0339       8.3679      76.4386     305.8853      47.6394      46.5887       0.0355       0.0729       4.4639    2705.8823     250.0591     124.0625    2375.0000
  830.1228     121.5352     169.5710     216.5813     313.4947     385.7455       2.5924     311.0000      -0.0051      -0.0416       8.1746      81.8777     305.8853      60.6196      46.5887       0.0554       0.0950       4.3805    2718.6907     180.5791     124.6875    2347.0000
  830.2752     114.6392     169.9118     224.2169     316.2974     365.3136       2.7374     311.0000       0.0006      -0.0357       8.2197      91.3936     306.7048      62.3274      46.5887       0.0617       0.1029       4.2838    2708.9683     160.1280     125.1250    2336.0000
  830.4276     109.0602     143.1418     165.4512     200.6373     226.7751       4.4097     311.0000       0.0089      -0.0271       8.3916      96.6615     306.9780      57.2586      46.5887       0.0816       0.1249       4.2507    2694.7085     134.5694     125.1250    2336.0000
  830.5800      98.9153     120.5693     142.7069     169.3477     183.7449       5.4423     311.0000       0.0193      -0.0164       8.4057     100.9973     306.1585      53.2196      46.5887       0.0759       0.1182       4.2921    2677.0037     117.2143     125.1250    2354.0000
  830.7324      97.0035     122.1881     146.5030     176.5113     190.8824       5.2388     311.0000       0.0333      -0.0018       8.3214     102.0787     306.4317      45.9058      46.5887       0.0643       0.1052       4.3360    2653.0168     117.2777     125.1250    2347.0000
  830.8848      99.8776     121.0418     134.3046     150.8828     167.8976       5.9560     311.0000       0.0440       0.0092       8.2700     106.8052     308.0706      59.6249      46.5887       0.0580       0.0979       4.4295    2634.8308     125.1330     126.5625    2354.0000
  831.0372     104.9403     139.7691     159.1512     188.4766     184.3786       5.4236     311.0000       0.0496       0.0150       8.3654     110.5111     311.6216      82.5300      46.5887       0.0523       0.0919       4.5191    2625.2642      95.7514     127.9375    2399.0000
  831.1896     105.6914     146.1103     155.8511     198.4184     191.7030       5.2164     311.0000       0.0453       0.0106       8.3403     114.9769     310.2559     113.1284      46.5887       0.0533       0.0932       4.6111    2632.4971      88.0501     130.2500    2371.0000
  831.3420     113.2783     179.6245     242.8533     264.7856     213.3010       4.6882     311.0000       0.0433       0.0086       8.2082     125.6490     308.0706     132.5695      46.5887       0.0554       0.0962       4.6294    2635.8855      63.1114     131.5000    2343.0000
  831.4944      94.6974     179.0880     228.2043     279.3975     277.1535       3.6081     311.0000       0.0479       0.0133       8.4032     137.6933     308.3438     145.9024      46.5887       0.0748       0.1173       4.6298    2628.1221      66.9879     129.5000    2359.0000
  831.6468      91.4377     116.8308     154.6793     211.8410     219.4863       4.5561     311.0000       0.0460       0.0113       8.4981     151.7995     308.0706     145.6284      46.5887       0.0923       0.1366       4.5731    2631.3718      41.4692     134.0000    2326.0000
  831.7992      89.7425     103.0618     140.0996     193.8085     213.2396       4.6896     311.0000       0.0449       0.0102       8.3523     159.6867     305.3391     114.1653      46.5887       0.0859       0.1298       4.4344    2633.1626      50.9869     134.9375    2323.0000
  831.9516      86.2041      87.3151     113.3056     151.7439     170.7242       5.8574     311.0000       0.0427       0.0079       8.3826     151.7423     305.3391      66.2952      46.5887       0.0732       0.1159       4.2472    2637.0327      63.7814     134.9375    2320.0000
  832.1040      77.8419      79.4178      97.0723     123.2872     144.7280       6.9095     311.0000       0.0488       0.0142       8.3703     144.3452     305.0659      27.0424      46.5887       0.0631       0.1046       4.1198    2626.5959     122.0289     134.9375    2359.0000
  832.2564      83.1335      99.1544     114.7719     154.4477     198.6404       5.0342     311.0000       0.0550       0.0206       8.3908     135.7326     304.7927       9.7711      46.5887       0.0585       0.0986       4.0828    2615.9749     143.1503     134.9375    2354.0000
  832.4088      81.6292     104.5005     130.9411     174.1966     248.1126       4.0304     311.0000       0.0694       0.0356       8.4639     146.3679     305.3391      -0.1631      46.5887       0.0417       0.0799       4.1128    2591.2749     135.3016     134.9375    2311.0000
  832.5612      75.9251     122.3367     141.7260     188.3873     231.5599       4.3185     311.0000       0.0733       0.0396       8.3750     138.9561     306.9780      -2.0828      46.5887       0.0512       0.0900       4.1065    2584.5916     140.7494     134.9375    2374.0000
  832.7136      77.2406     104.4133     124.7037     165.3174     206.3538       4.8460     311.0000       0.0788       0.0453       8.4093     145.2488     306.1585      -2.6872      46.8683       0.0586       0.0988       4.0775    2575.2109     112.0748     134.9375    2383.0000
  832.8660      73.1950      84.0188      98.6496     132.2491     165.8680       6.0289     311.0000       0.0811       0.0477       8.4946     138.5789     305.3391      -0.6278      46.5887       0.0716       0.1134       4.0409    2571.3374      96.4468     134.9375    2318.0000
  833.0184      67.6938      72.7141      83.5243     120.4068     123.9697       8.0665     311.0000       0.0780       0.0445       8.4354     140.9863     303.7001       1.3115      46.5887       0.0740       0.1162       3.9751    2576.5752      97.4404     134.9375    2338.0000
  833.1708      65.4645      71.2198      78.5707      92.0361     104.0446       9.6113     311.0000       0.0747       0.0410       8.3556     140.6870     303.1538       1.2574      46.5887       0.0612       0.1016       3.9516    2582.3303     114.1518     134.9375    2325.0000
  833.3232      79.0342      93.9565      99.6121     119.1173     145.0741       6.8930     311.0000       0.0673       0.0334       8.4018     143.3814     303.7001       0.6547      46.5887       0.0467       0.0854       3.9165    2594.9685     120.6741     134.9375    2313.0000
  833.4756      88.9613     111.1974     130.0010     157.1896     227.3394       4.3987     311.0000       0.0604       0.0262       8.4252     149.2993     304.7927       7.0939      46.5887       0.0544       0.0934       4.0156    2606.7734     127.3727     134.9375    2359.0000
  833.6280      92.3257     138.5107     176.1942     174.2417     271.1516       3.6880     311.0000       0.0491       0.0145       8.3847     144.7268     306.4317      27.6167      46.5887       0.0428       0.0813       4.2157    2626.1167     140.0109     133.8125    2382.0000
  833.7804      86.3317     143.2733     153.8089     195.0568     213.8123       4.6770     311.0000       0.0400       0.0051       8.4756     143.0003     306.9780      56.9348      46.5887       0.0451       0.0838       4.4669    2641.5884     113.1141     133.6875    2351.0000
  833.9328      84.0824     112.8024     130.9683     175.8795     181.5356       5.5086     311.0000       0.0481       0.0135       8.3926     139.4375     305.8853      82.4852      46.5887       0.0607       0.1011       4.7120    2627.7393      84.4039     131.5000    2304.0000
  834.0852      84.8981      92.0725     117.7931     183.0161     140.6790       7.1084     311.0000       0.0543       0.0200       8.3852     138.9447     305.8853      99.5173      46.5887       0.0745       0.1161       4.8553    2617.0789      59.3622     131.1875    2335.0000
  834.2376      78.0341      97.2151     124.9695     163.5063     126.7870       7.8872     311.0000       0.0507       0.0162       8.4093     136.6285     303.9733     110.1654      46.5887       0.0668       0.1078       4.9235    2623.3296      66.8220     130.5625    2373.0000
  834.3900      96.1571     127.3317     179.4845     222.2216     219.2730       4.5605     311.0000       0.0491       0.0145       8.4018     130.4658     306.7048      98.1984      46.8683       0.0451       0.0845       4.8689    2626.0786      52.7115     130.8125    2358.0000
  834.5424     118.2233     186.7306     307.9768     376.3975     376.0620       2.6591     311.0000       0.0687       0.0349       8.4142     130.3497     305.8853      60.4765      46.5887       0.0598       0.1004       4.7378    2592.4399      75.7822     127.4375    2390.0000
  834.6948     134.9523     213.3669     385.1321     481.2589     450.8002       2.2183     311.0000       0.0950       0.0620       8.4459     130.3497     311.8948      21.6143      46.5887       0.0700       0.1118       4.6376    2547.6243     108.4256     127.1875    2372.0000
  834.8472     127.7460     198.3727     293.6357     469.9513     488.1864       2.0484     311.0000       0.1052       0.0727       8.4917     133.6705     309.1632       9.9375      46.5887       0.0717       0.1135       4.6322    2530.0615     174.7881     126.5625    2346.0000
  834.9996     115.7394     165.2228     256.1248     447.6086     482.7052       2.0717     311.0000       0.0783       0.0448       8.4652     126.3627     307.5243      48.3906      46.5887       0.0737       0.1155       4.7218    2576.0884     143.7824     127.6875    2359.0000
  835.1520     105.7681     158.2660     215.3418     432.6225     409.3683       2.4428     311.0000       0.0548       0.0205       8.3391     121.9620     306.7048      96.0760      46.5887       0.0561       0.0966       4.8023    2616.2273     132.7571     125.1250    2375.0000
  835.3044      85.5100     133.9861     182.3839     328.3170     330.8344       3.0227     311.0000       0.0382       0.0032       8.4329     125.1249     312.4411     133.6389      46.8683       0.0571       0.0979       4.8531    2644.6965     106.0108     125.6250    2394.0000
  835.4568      92.8167     143.4856     218.5282     438.3743     423.0600       2.3637     311.0000       0.0522       0.0177       8.5507     132.9539     314.6264     133.3065      46.8683       0.0661       0.1077       4.8468    2620.7332      81.9907     125.1250    2382.0000
  835.6092      97.4606     200.0387     326.8785     562.5013     552.7721       1.8091     311.0000       0.0571       0.0228       8.4641     136.7551     317.9043     120.9946      46.5887       0.0663       0.1078       4.8216    2612.4167      70.7872     125.1250    2345.0000
  835.7616     114.9562     195.8917     346.7357     472.6292     535.3151       1.8681     311.0000       0.0694       0.0355       8.3742     134.1211     318.4506     100.0788      46.5887       0.0719       0.1140       4.7665    2591.3921      59.7002     125.1250    2346.0000
  835.9140     104.9480     132.2011     210.0371     358.4441     454.2472       2.2014     311.0000       0.0600       0.0259       8.4300     130.5549     319.5432      98.6602      46.8683       0.0877       0.1310       4.6963    2607.3320      62.6841     125.1250    2355.0000
  836.0664      93.3593     119.0827     168.6111     273.5583     353.0266       2.8326     311.0000       0.0522       0.0177       8.5934     128.6067     317.6311     100.8992      46.8683       0.0650       0.1064       4.5936    2620.8066      53.9343     122.5000    2366.0000
  836.2188      91.3888     107.8352     153.1829     207.0099     305.1604       3.2770     311.0000       0.0344      -0.0008       8.4925     134.3705     313.5338     100.3432      46.8683       0.0619       0.1033       4.4580    2651.2561      61.8000     122.3750    2314.0000
  836.3712      85.7441     102.8100     134.4291     173.1705     271.8361       3.6787     311.0000       0.0290      -0.0063       8.2991     137.3289     311.8948      81.8083      46.8683       0.0852       0.1287       4.3232    2660.4126      68.4693     122.8750    2357.0000
  836.5236      82.4737     102.6800     127.4974     171.7897     247.1175       4.0467     311.0000       0.0411       0.0063       8.4186     146.1304     311.8948      47.3130      46.8683       0.0695       0.1116       4.1965    2639.6472      94.4282     121.6875    2350.0000
  836.6760      83.8040     102.8078     124.3890     167.6648     198.1516       5.0466     311.0000       0.0448       0.0100       8.4334     148.4711     312.9874      31.3041      46.8683       0.0587       0.0998       4.1205    2633.4619      96.8294     121.3125    2320.0000
  836.8284      78.3351      96.6583     113.7954     144.9416     194.9437       5.1297     311.0000       0.0394       0.0044       8.4758     152.4145     314.0800      25.9686      46.8683       0.0616       0.1024       4.1018    2642.6882      97.5715     121.9375    2381.0000
  836.9808      80.4897     108.0754     120.7135     154.5255     165.3797       6.0467     311.0000       0.0324      -0.0027       8.5208     144.3078     316.2654      27.3223      46.8683       0.0559       0.0960       4.1410    2654.5225     107.5219     121.1875    2338.0000
  837.1332      81.8833     101.3729     118.5794     149.4140     164.4206       6.0820     311.0000       0.0406       0.0057       8.4600     141.1552     316.2654      17.7710      46.8683       0.0527       0.0914       4.2112    2640.5986     108.9905     122.1875    2351.0000
  837.2856      80.1615      90.5431      96.8512     114.6322     132.2968       7.5588     311.0000       0.0535       0.0191       8.4159     140.7492     314.0800       6.0847      46.8683       0.0417       0.0791       4.2232    2618.5654      90.0805     122.3125    2346.0000
  837.4380      77.4889      82.7321      95.2470     109.3114     133.6174       7.4841     311.0000       0.0537       0.0193       8.4272     141.6756     312.9874       1.8935      46.8683       0.0510       0.0890       4.1938    2618.1260      95.9005     124.3125    2342.0000
  837.5904      82.4683      74.9176      80.3610      89.3849     115.1424       8.6849     311.0000       0.0457       0.0110       8.4677     139.3577     312.9874       1.1384      46.8683       0.0433       0.0808       4.1163    2631.8970      96.9896     123.0625    2367.0000
  837.7428      85.6547      84.9196      86.2892      94.3524     104.8740       9.5353     311.0000       0.0440       0.0093       8.4551     139.4674     314.6264      -1.1821      46.8683       0.0403       0.0778       4.0353    2634.7253     133.1607     123.5625    2390.0000
  837.8952      82.7874      93.4578      96.0416     109.0829     118.8301       8.4154     311.0000       0.0552       0.0208       8.3254     139.7942     317.3580       7.0109      46.8683       0.0434       0.0816       3.9934    2615.6082     117.7524     122.7500    2401.0000
  838.0476      88.2638     135.0909     139.6036     153.0422     163.3482       6.1219     311.0000       0.0831       0.0497       8.3746     140.6047     320.6359      11.8024      46.8683       0.0420       0.0804       4.0346    2567.9832     123.5138     124.7500    2338.0000
  838.2000      92.4603     192.7723     303.2397     290.4928     248.4274       4.0253     311.0000       0.1121       0.0798       8.4494     139.1704     323.3674      25.1222      46.8683       0.0554       0.0950       4.1742    2518.3396      54.2759     125.1250    2333.0000
  838.3524      99.7116     180.8603     251.8374     244.5633     272.8556       3.6649     311.0000       0.1106       0.0783       8.4854     144.1343     316.2654      57.4219      46.8683       0.0685       0.1091       4.3651    2520.7966      44.9601     125.1250    2375.0000
  838.5048     100.3196     113.9550     138.4182     213.5855     165.9929       6.0244     311.0000       0.0837       0.0503       8.3847     146.4538     317.3580      96.5107      46.8683       0.0820       0.1243       4.4846    2566.9285      35.5052     125.1250    2357.0000
  838.6572      95.6849     104.4436     138.2569     191.8195     151.8586       6.5851     311.0000       0.0456       0.0109       8.3572     142.7479     317.3580     112.8767      46.8683       0.0766       0.1190       4.4807    2631.9961      43.5586     125.1250    2337.0000
  838.8096      91.8447      95.4249     125.9205     171.2463     169.8951       5.8860     311.0000       0.0295      -0.0058       8.3627     138.4850     318.4506      84.7914      46.8683       0.0616       0.1034       4.3567    2659.6218      51.6446     124.6250    2345.0000
  838.9620      92.7275      96.0488     108.6872     146.6494     180.5395       5.5390     311.0000       0.0358       0.0008       8.2953     139.5174     320.3627      41.2846      46.8683       0.0688       0.1104       4.2385    2648.7278      79.9296     125.1250    2419.0000
  839.1144      87.6725     104.5885     120.7969     143.7904     173.4241       5.7662     311.0000       0.0403       0.0054       8.2981     141.0058     321.7285      14.2877      46.8683       0.0486       0.0876       4.0955    2641.0334      92.2840     125.1250    2363.0000
  839.2668      82.6860     108.5135     134.2556     158.5507     183.6065       5.4464     311.0000       0.0397       0.0047       8.4081     140.1107     324.4601       2.1245      46.8683       0.0376       0.0747       3.9893    2642.1724      98.4089     125.1250    2341.0000
  839.4192      86.8913     122.0455     141.0509     194.8183     203.4031       4.9163     311.0000       0.0373       0.0023       8.3781     137.8604     322.0016      -0.3397      46.8683       0.0432       0.0811       3.9672    2646.2422      98.2831     122.6875    2321.0000
  839.5716      96.7343     138.0974     177.7513     211.0478     181.2113       5.5184     311.0000       0.0469       0.0122       8.3448     132.8977     320.0895      -2.2051      46.8683       0.0473       0.0856       4.0496    2629.8696     123.3107     122.7500    2352.0000
  839.7240     107.3483     175.4722     209.7538     232.4234     243.2715       4.1106     311.0000       0.0554       0.0211       8.2894     135.0107     319.8164      14.7386      46.8683       0.0459       0.0841       4.2075    2615.2415     132.0290     120.8750    2297.0000
  839.8764      93.7267     106.6481     168.2506     234.1304     209.9392       4.7633     311.0000       0.0513       0.0168       8.2383     141.8112     318.4506      40.9310      46.8683       0.0632       0.1027       4.3427    2622.3469     126.6373     119.6250    2299.0000
  840.0288      91.2611     101.0795     146.9143     216.4081     184.6984       5.4142     311.0000       0.0414       0.0066       8.3894     144.2206     321.1822      53.5924      46.8683       0.0545       0.0939       4.4549    2639.1855     118.7750     116.1875    2376.0000
  840.1812      88.8337      88.1929     130.4605     199.6794     185.7713       5.3830     311.0000       0.0359       0.0008       8.4036     145.9572     322.2748      38.8560      46.8683       0.0620       0.1022       4.4713    2648.6787     118.9841     117.3125    2375.0000
  840.3336      86.9326      99.5748     142.6217     211.1153     238.7561       4.1884     311.0000       0.0253      -0.0101       8.3596     140.8919     325.5527      24.4064      46.8683       0.0496       0.0888       4.3967    2666.7410     125.5422     115.3750    2320.0000
  840.4860      87.9858     110.8082     160.8505     227.6233     281.6296       3.5508     311.0000       0.0269      -0.0085       8.3284     142.4200     325.5527      14.0381      46.8683       0.0377       0.0754       4.2899    2664.0730     125.7798     115.3750    2353.0000
  840.6384      82.0519     108.4081     154.0792     222.3534     292.2548       3.4217     311.0000       0.0318      -0.0034       8.3988     142.3073     321.4553       9.9092      46.8683       0.0511       0.0897       4.2313    2655.6111     102.8998     113.5625    2323.0000
  840.7908      81.1038     105.1656     142.9492     204.7994     252.4567       3.9611     311.0000       0.0395       0.0046       8.3237     138.1363     319.5432       0.6237      46.8683       0.0513       0.0893       4.1633    2642.4280     114.0550     114.8125    2361.0000
  840.9432      78.7210      97.3679     131.6896     179.0688     211.9931       4.7171     311.0000       0.0366       0.0016       8.2628     140.9897     318.4506      -0.0765      46.8683       0.0386       0.0755       4.0862    2647.3894     124.2506     110.8750    2351.0000
  841.0956      74.7423      91.4643     122.2627     161.2376     182.3223       5.4848     311.0000       0.0341      -0.0010       8.3409     145.3387     319.5432       1.8537      46.8683       0.0400       0.0769       3.9732    2651.7285     121.1055     109.6250    2347.0000
  841.2480      71.0332      85.5118     109.8721     147.1207     159.1842       6.2820     311.0000       0.0380       0.0030       8.3721     150.1175     322.2748       3.0420      46.8683       0.0459       0.0840       3.8948    2644.9878     106.2954     108.4375    2395.0000
  841.4004      73.5853      83.0438     104.3358     135.4538     142.0886       7.0379     311.0000       0.0412       0.0063       8.3929     148.0914     324.4601       4.8466      46.8683       0.0646       0.1044       3.8995    2639.6021     103.8121     106.7500    2384.0000
  841.5528      84.9894      97.4992     123.1605     163.4013     170.5335       5.8640     311.0000       0.0369       0.0019       8.3754     144.2734     325.0064      14.3173      46.8683       0.0438       0.0814       4.0040    2646.8787     114.5794     105.6250    2331.0000
  841.7052     102.1372     135.9601     175.3900     243.4573     246.0895       4.0636     311.0000       0.0323      -0.0029       8.4136     127.5180     322.8211      25.3038      46.8683       0.0345       0.0703       4.1935    2654.8020     155.4004     105.6250    2343.0000
  841.8576     126.9814     253.3113     305.7764     370.6819     361.3576       2.7673     311.0000       0.0279      -0.0074       8.3618     113.9516     320.6359      34.2209      46.8683       0.0282       0.0623       4.4085    2662.2231     249.9727     103.6250    2350.0000
  842.0100     158.9556     282.7697     460.1854     529.6701     481.4550       2.0770     311.0000       0.0318      -0.0034       8.3525      97.3843     319.5432      25.0726      46.8683       0.0168       0.0493       4.5221    2655.6873     674.7645     102.6250    2349.0000
  842.1624     157.1761     233.1073     360.8817     614.2498     508.3160       1.9673     311.0000       0.0292      -0.0061       8.4126      90.2093     329.9232      14.9572      46.8683       0.0170       0.0491       4.5741    2660.0784     440.8414     101.4375    2366.0000
  842.3148     155.4638     202.4151     308.6577     572.2714     404.0472       2.4750     311.0000       0.0294      -0.0059       8.4153      84.3745     330.1964       4.5931      46.8683       0.0281       0.0620       4.6072    2659.6711     529.4124     100.3750    2367.0000
  842.4672     149.6055     183.3230     335.2998     540.9192     434.7767       2.3000     311.0000       0.0274      -0.0080       8.3322      83.5041     329.3769       4.0135      46.8683       0.0309       0.0660       4.6221    2663.1497     438.2294     100.4375    2344.0000
  842.6196     134.9072     186.4101     297.2721     453.2299     377.6875       2.6477     311.0000       0.0333      -0.0019       8.4059      88.5915     331.0158       1.2970      46.8683       0.0293       0.0657       4.5665    2653.1331     268.8151      96.4375    2337.0000
  842.7720     123.0648     193.6962     254.0173     395.1628     354.7537       2.8189     311.0000       0.0326      -0.0026       8.4551      94.1946     329.9232      -0.1960      46.8683       0.0651       0.1052       4.4090    2654.2283     184.4251      96.3750    2368.0000
  842.9244     122.8719     180.9460     261.8319     341.7496     326.1528       3.0660     311.0000       0.0338      -0.0014       8.4040      89.7873     328.2842      -1.4253      46.8683       0.0788       0.1209       4.3641    2652.2703     165.8956      95.8750    2414.0000
  843.0768     126.3074     165.0477     229.2818     292.2773     280.6851       3.5627     311.0000       0.0298      -0.0055       8.3448      88.4058     325.5527      -0.0470      46.8683       0.0632       0.1037       4.3992    2659.1260     185.5905      95.8750    2359.0000
  843.2292     116.7941     134.0514     187.5179     238.5292     227.0509       4.4043     311.0000       0.0342      -0.0010       8.4131      85.2386     327.7379       1.7931      46.8683       0.0457       0.0842       4.5295    2651.5691     176.8494      95.8750    2385.0000
  843.3816     101.6413     121.7039     162.6137     196.9923     191.6051       5.2191     311.0000       0.0249      -0.0105       8.4401      82.5996     330.4695      20.0405      46.8683       0.0426       0.0802       4.6235    2667.3638     197.5497      94.6250    2333.0000
  843.5340     103.3392     140.8754     195.6614     261.3710     250.8501       3.9864     311.0000       0.0085      -0.0276       8.3203      88.3901     334.2937      45.8038      46.8683       0.0369       0.0739       4.6906    2695.4954     175.0440      94.6875    2313.0000
  843.6864     109.7965     142.8940     227.4049     323.7870     337.4232       2.9636     311.0000      -0.0051      -0.0416       8.3802      87.9307     337.5716      65.4519      46.8683       0.0423       0.0793       4.7011    2718.6653     139.5074      92.9375    2349.0000
  843.8388     111.5525     144.1049     224.2381     358.9389     339.3432       2.9469     311.0000       0.0060      -0.0302       8.4531      92.7890     338.1179      48.5680      46.8683       0.0588       0.0965       4.6598    2699.7815     127.8964      91.5000    2366.0000
  843.9912     116.9621     154.6832     252.6569     443.0857     421.9025       2.3702     311.0000       0.0252      -0.0103       8.4034      79.4650     328.8306      21.3952      46.8683       0.0400       0.0754       4.6976    2666.9905     141.6708      87.4375    2368.0000
  844.1436     128.7991     181.1175     308.5013     542.8509     491.7759       2.0334     311.0000       0.0301      -0.0052       8.3098      66.6467     330.1964       0.8025      46.8683       0.0118       0.0430       4.7737    2658.5505     285.0515      88.6250    2352.0000
  844.2960     152.1137     239.0843     438.8485     803.8016     746.0084       1.3405     311.0000       0.0137      -0.0222       8.3773      54.4492     330.4695       8.0369      46.8683       0.0045       0.0334       4.8997    2686.6177     567.0474      86.0625    2360.0000
  844.4484     185.0179     377.4631    1106.9058    1304.0348    1222.2576       0.8182     311.0000       0.0081      -0.0280       8.4120      45.5585     329.9232      10.0508      46.8683      -0.0051       0.0218       4.8985    2696.2122    2714.5767      86.0625    2382.0000
  844.6008     185.4571     468.7217    1128.6874    1455.6919    1347.2212       0.7423     311.0000       0.0129      -0.0230       8.3685      49.7276     341.3958       9.9306      46.8683      -0.0032       0.0235       4.8253    2687.9661    1098.2244      86.0000    2384.0000
  844.7532     160.4982     392.1213     803.1403     933.6054     835.0845       1.1975     311.0000       0.0244      -0.0110       8.3365      53.6160     335.9327       2.3942      46.8683      -0.0020       0.0258       4.6584    2668.2175     564.8287      83.5625    2361.0000
  844.9056     135.2911     301.3831     651.4922     736.7695     670.8622       1.4906     311.0000       0.0160      -0.0198       8.3863      64.5776     334.2937       7.4301      46.8683       0.0188       0.0494       4.5254    2682.6155     408.8785      81.1250    2321.0000
  845.0580     145.5398     323.6615     790.3248     884.0872     770.8110       1.2973     311.0000       0.0072      -0.0289       8.4155      64.5776     331.0158       8.1475      46.8683       0.0241       0.0564       4.3841    2697.7314     445.0519      82.1250    2369.0000
  845.2104     161.5000     408.2073     890.7234    1007.4129     854.2849       1.1706     311.0000      -0.0067      -0.0434       8.4248      65.1467     326.0990      11.4539      46.8683       0.0177       0.0498       4.2719    2721.5325     503.6765      79.6250    2369.0000
  845.3628     161.5766     336.3533     769.6642     971.1777     791.2081       1.2639     311.0000      -0.0238      -0.0610       8.4171      58.1380     326.6453      21.7686      46.8683       0.0163       0.0483       4.1710    2750.7043     537.4349      76.9375    2393.0000
  845.5152     161.2914     240.8364     635.3202     891.9683     717.5114       1.3937     311.0000      -0.0398      -0.0776       8.3804      55.2065     319.2701      30.5839      46.8683       0.0233       0.0557       4.1128    2778.1030     552.5679      76.3125    2375.0000
  845.6676     173.4057     221.6246     577.9233     971.8105     622.4920       1.6064     311.0000      -0.0542      -0.0926       8.3364      47.6270     319.5432      39.7704      46.8683       0.0250       0.0576       4.0885    2802.7280     591.2307      76.3125    2360.0000
  845.8200     174.6714     268.6350     756.9566    1185.1998     896.8594       1.1150     311.0000      -0.0459      -0.0839       8.4205      44.8654     318.9969      30.0913      46.8683       0.0176       0.0498       4.0368    2788.4243     635.2304      76.3125    2329.0000
  845.9724     175.1463     328.7725     821.3325    1245.2130     922.8937       1.0835     311.0000      -0.0360      -0.0737       8.4901      43.4294     320.9090      21.0445      46.8683       0.0152       0.0472       3.9306    2771.6111     669.9794      75.6875    2365.0000
  846.1248     180.5733     379.4491     898.7429    1298.6907    1007.5168       0.9925     311.0000      -0.0321      -0.0696       8.4603      45.3358     321.1822      12.5134      46.8683       0.0222       0.0547       3.8533    2764.8591     506.8059      73.8750    2363.0000
  846.2772     187.0739     407.4396     932.7265    1311.4211    1078.2278       0.9274     311.0000      -0.0362      -0.0739       8.3961      43.9414     318.9969       7.4785      46.8683       0.0236       0.0559       3.7831    2771.9099     543.6276      72.5625    2352.0000
  846.4296     192.5912     406.2949     790.0980     861.1055     610.3878       1.6383     311.0000      -0.0359      -0.0735       8.3301      45.5295     316.8116       5.5053      46.8683       0.0177       0.0494       3.8112    2771.3452     472.0404      72.0625    2325.0000
  846.5820     188.1028     373.9433     687.3577     715.0573     458.6045       2.1805     311.0000      -0.0177      -0.0547       8.3794      44.7468     315.7190      -1.7407      46.8683       0.0178       0.0487       3.8638    2740.3257     453.8754      73.2500    2309.0000
  846.7344     167.4656     288.9063     543.3512     643.4698     399.1645       2.5052     311.0000      -0.0038      -0.0403       8.3939      45.1281     316.2654      -4.8897      46.8683       0.0067       0.0370       3.9747    2716.4426     406.6127      72.5625    2390.0000
  846.8868     159.1873     249.6758     414.6165     623.2792     346.3129       2.8876     311.0000      -0.0011      -0.0375       8.3804      40.2641     317.9043      -4.4951      46.8683       0.0132       0.0439       4.1081    2711.8877     477.8034      71.8125    2434.0000
  847.0392     164.8934     240.3252     413.0927     510.5813     347.7494       2.8756     311.0000      -0.0087      -0.0453       8.4218      40.0338     319.5432      -0.9880      46.8683       0.0139       0.0449       4.2146    2724.8215     589.9872      71.0000    2333.0000
  847.1916     164.3627     264.0332     421.5631     484.6906     339.0211       2.9497     311.0000      -0.0091      -0.0458       8.4347      42.4944     320.6359       0.4301      46.8683       0.0105       0.0405       4.3661    2725.6008     658.3019      70.3125    2342.0000
  847.3440     176.5428     323.9536     558.9608     633.2786     474.5937       2.1071     311.0000      -0.0104      -0.0472       8.4072      45.9686     320.3627       1.9915      46.8683       0.0133       0.0438       4.4186    2727.8459     555.9537      71.3750    2341.0000
  847.4964     156.3491     291.9770     468.0897     604.2330     457.7080       2.1848     311.0000      -0.0100      -0.0468       8.2498      49.0408     317.3580       2.2869      46.8683       0.0116       0.0423       4.3496    2727.1479     632.6512      70.1875    2339.0000
  847.6488     144.5391     202.3642     388.4029     489.0874     382.9550       2.6113     311.0000      -0.0168      -0.0538       8.3065      55.7396     316.8116       4.8263      46.8683       0.0220       0.0546       4.1653    2738.7996     357.3886      70.5000    2315.0000
  847.8012     128.7488     172.8321     306.9750     429.0913     344.8508       2.8998     311.0000      -0.0166      -0.0536       8.3801      63.3830     317.3580       3.8216      46.8683       0.0376       0.0722       4.0344    2738.3840     239.1563      72.5625    2343.0000
  847.9536     120.6323     153.9149     267.0379     427.7396     346.2522       2.8881     311.0000      -0.0206      -0.0577       8.4062      67.4023     318.4506       4.1227      46.8683       0.0289       0.0634       4.0015    2745.1543     202.2051      72.7500    2346.0000
  848.1060     131.9084     159.8181     266.6483     412.6687     411.3369       2.4311     311.0000      -0.0154      -0.0523       8.2540      69.4453     320.9090       1.1523      46.8683       0.0245       0.0584       4.0450    2736.2749     208.0251      71.2500    2334.0000
  848.2584     132.5376     164.1108     268.2706     377.6876     414.7715       2.4110     311.0000      -0.0135      -0.0504       8.3975      65.9077     321.1822       0.9480      46.8683       0.0299       0.0640       4.0763    2733.1697     266.7636      72.2500    2330.0000
  848.4108     137.3086     166.8731     260.2637     337.0586     379.3851       2.6358     311.0000      -0.0068      -0.0434       8.4693      62.8685     319.5432       0.2449      46.8683       0.0225       0.0558       4.0404    2721.6375     326.7341      73.3125    2328.0000
  848.5632     133.6602     153.5721     219.2244     277.9887     299.1081       3.3433     311.0000       0.0030      -0.0333       8.3552      65.1327     318.4506      -0.6473      46.8683       0.0194       0.0527       3.9039    2704.8662     321.8518      72.7500    2339.0000
  848.7156     111.8855     140.3789     195.1146     232.4559     230.1048       4.3458     311.0000       0.0119      -0.0240       8.2755      73.4925     317.9043      -0.6046      46.8683       0.0385       0.0743       3.7083    2689.5840     281.6699      72.7500    2359.0000
  848.8680      91.6394     116.9122     148.4863     173.0298     165.4984       6.0424     311.0000       0.0187      -0.0170       8.3627      78.9406     318.4506       0.8788      46.8683       0.0430       0.0800       3.6033    2678.0867     171.6443      74.1875    2330.0000
  849.0204      84.5357     120.9837     151.6619     170.6891     155.0368       6.4501     311.0000       0.0290      -0.0063       8.3613      79.5053     320.0895       1.8146      46.8683       0.0401       0.0775       3.6862    2660.3545     149.1045      75.2500    2336.0000
  849.1728      88.5818     145.3748     178.6953     205.0484     171.8034       5.8206     311.0000       0.0389       0.0039       8.2765      80.0604     323.3674      13.6209      46.8683       0.0470       0.0850       3.9185    2643.5332     111.8201      76.3125    2321.0000
  849.3252      98.6950     156.6603     231.5156     262.3983     218.8544       4.5692     311.0000       0.0401       0.0052       8.3308      79.4156     325.5527      47.4222      46.8683       0.0542       0.0926       4.2749    2641.4497     107.1333      76.0000    2317.0000
  849.4776      99.3780     155.6588     237.2944     299.3001     210.4755       4.7511     311.0000       0.0172      -0.0186       8.3030      78.1491     323.9137      82.1493      46.8683       0.0487       0.0855       4.5714    2680.6201      74.8111      74.9375    2331.0000
  849.6300     101.2433     136.6670     227.7099     332.0179     213.0094       4.6946     311.0000      -0.0024      -0.0389       8.2414      70.5006     322.8211      95.9446      46.8683       0.0357       0.0708       4.8495    2714.1543      82.5130      73.8750    2367.0000
  849.7824     126.8739     166.8614     315.6694     462.4119     310.4294       3.2213     311.0000      -0.0105      -0.0472       8.2784      65.0558     323.3674      75.2320      46.8683       0.0220       0.0548       5.0461    2727.9312     123.5460      73.9375    2355.0000
  849.9348     185.5699     202.2599     447.8105     672.0977     444.7331       2.2485     311.0000      -0.0113      -0.0480       8.3951      53.9768     329.9232      56.2952      46.8683       0.0077       0.0377       5.1637    2729.2676     755.0844      72.6250    2358.0000
  850.0872     179.8369     253.5905     705.9905    1057.5381     719.6757       1.3895     311.0000      -0.0040      -0.0405       8.4009      49.8738     327.4648      35.3949      46.8683      -0.0032       0.0244       5.0765    2716.8125    2028.9501      71.0000    2317.0000
  850.2396     177.7709     292.0749    1031.3826    1421.8824    1100.8511       0.9084     311.0000       0.0102      -0.0258       8.2569      52.1741     328.8306      20.7896      46.8683      -0.0023       0.0245       4.8789    2692.5205    1189.6072      71.5000    2296.0000
  850.3920     169.7662     310.7496    1330.8439    1707.5775    1460.6746       0.6846     311.0000       0.0313      -0.0039       8.2055      60.2490     329.3769       4.6883      46.8683       0.0013       0.0282       4.7143    2656.4089     964.2133      68.3750    2325.0000
  850.5444     159.4969     302.4816    1413.2606    1878.2722    1707.6987       0.5856     311.0000       0.0385       0.0035       8.2518      59.4689     328.0111      -0.5953      46.8683       0.0042       0.0314       4.7532    2644.1782    1077.5815      68.3750    2333.0000
  850.6968     157.6051     315.7493    1507.8076    1939.9771    1751.0931       0.5711     311.0000       0.0334      -0.0018       8.2490      54.3657     325.5527      -1.5328      46.8683       0.0039       0.0306       4.8980    2652.9561    1073.7585      66.5625    2355.0000
  850.8492     158.5129     318.5875    1438.2556    1921.4626    1597.5330       0.6260     311.0000       0.0218      -0.0138       8.2514      40.4878     323.9137      -0.1917      46.8683      -0.0070       0.0180       5.0743    2672.6953    1525.9142      66.5625    2345.0000
  851.0016     160.1359     297.9867    1183.5160    1833.2838    1291.2670       0.7744     311.0000       0.0097      -0.0263       8.2960      34.3791     323.9137       1.8876      46.8683      -0.0149       0.0085       5.1955    2693.3643    1952.7084      66.5625    2337.0000
  851.1540     165.2109     308.3665     989.5265    1628.0642    1005.2978       0.9947     311.0000      -0.0012      -0.0376       8.3483      26.3633     325.5527       3.4359      46.8683      -0.0158       0.0070       5.2258    2712.0249    3975.8750      66.3750    2355.0000
  851.3064     156.3640     253.6097     780.1119    1475.6064     788.9482       1.2675     311.0000      -0.0170      -0.0540       8.2450      25.4153     328.5574      11.5016      46.8683      -0.0130       0.0099       5.2172    2739.1121    3867.8127      64.6875    2326.0000
  851.4588     140.8958     230.2089     560.4063    1396.0170     585.2957       1.7085     311.0000      -0.0255      -0.0628       8.2753      22.5924     331.0158      17.9622      46.8683      -0.0159       0.0071       5.1506    2753.6697    4322.2974      64.8750    2326.0000
  851.6112     138.0850     219.0659     471.3193    1026.2111     409.9052       2.4396     311.0000      -0.0215      -0.0587       8.3691      25.3718     332.1085      20.1218      46.8683      -0.0157       0.0076       5.0400    2746.7820    4334.9312      60.6875    2322.0000
  851.7636     164.4324     338.3607     763.9197    1054.6073     604.2670       1.6549     311.0000      -0.0168      -0.0537       8.2706      24.5751     332.1085      27.5552      46.8683      -0.0105       0.0135       4.9486    2738.6509    3172.0740      62.0000    2333.0000
  851.9160     194.7387     478.8497    1155.5430    1577.9434    1077.3772       0.9282     311.0000      -0.0092      -0.0459       8.2554      28.8379     326.9185      25.9097      46.8683       0.0030       0.0281       4.8464    2725.6614    2677.3621      63.2500    2341.0000
  852.0684     205.1976     491.6472    1611.0610    1846.7631    1439.4377       0.6947     311.0000      -0.0059      -0.0424       8.3112      31.3857     326.6453      23.8745      46.8683      -0.0099       0.0144       4.7720    2720.0073    2408.0396      60.1875    2330.0000
  852.2208     195.0914     480.0207     757.0008    1140.7408     598.2384       1.6716     311.0000       0.0067      -0.0294       8.3248      38.8687     327.7379       7.8244      46.8683      -0.0111       0.0131       4.5733    2698.5879    2157.4470      59.1250    2342.0000
  852.3732     155.0878     237.6464     445.7315     787.4193     394.6929       2.5336     311.0000       0.0024      -0.0339       8.2762      36.5828     329.3769       8.1441      46.8683      -0.0061       0.0190       4.3933    2705.9114    1400.5197      56.8125    2365.0000
  852.5256     150.6445     162.4655     318.2092     580.3331     257.0385       3.8905     311.0000       0.0041      -0.0321       8.2975      35.2190     329.9232       6.6862      46.8683      -0.0060       0.0202       4.3166    2702.9465    1109.4124      56.8125    2337.0000
  852.6780     122.8070     200.1765     421.3498     866.3604     306.0785       3.2671     311.0000      -0.0003      -0.0366       8.2978      33.3990     330.4695      17.5090      46.8683       0.0013       0.0293       4.4810    2710.4612    1381.1370      56.8125    2312.0000
  852.8304     132.3118     295.6142     572.0689     816.8060     470.2651       2.1265     311.0000       0.0094      -0.0267       8.2140      37.8920     328.8306      31.4128      46.8683       0.0033       0.0325       4.7447    2693.9807    1917.8784      56.8125    2328.0000
  852.9828     135.8232     256.7152     599.9753     754.2932     504.6093       1.9817     311.0000       0.0026      -0.0336       8.1728      50.7014     326.6453      62.6922      46.8683       0.0162       0.0469       4.9583    2705.5159     162.0178      56.8125    2333.0000
  853.1352     119.1340     197.1389     460.9617     530.0933     403.6954       2.4771     311.0000       0.0099      -0.0261       8.3331      62.0508     326.6453      69.7687      46.8683       0.0380       0.0712       5.0141    2693.0742      94.8921      55.8750    2313.0000
  853.2876     123.9193     168.5029     359.1364     354.2289     298.1516       3.3540     311.0000       0.0178      -0.0180       8.2540      64.9185     328.0111      49.3960      46.8683       0.0450       0.0788       5.0820    2679.6333      89.6413      55.4375    2333.0000
  853.4400     137.8156     158.9992     310.6877     296.1882     237.8558       4.2042     311.0000       0.0220      -0.0136       8.1835      53.5274     329.9232      19.1457      46.8683       0.0135       0.0441       5.1444    2672.3979     267.2118      56.1875    2304.0000
  853.5924     137.2712     189.5905     362.6867     362.0943     322.2908       3.1028     311.0000       0.0136      -0.0223       8.1678      42.4379     336.7521       3.6922      46.8683      -0.0091       0.0174       5.1824    2686.7268     950.6527      55.4375    2365.0000
  853.7448     143.2877     274.0753     552.1195     536.3432     521.5430       1.9174     311.0000       0.0021      -0.0342       8.2841      37.9493     332.6548       4.5366      46.8683      -0.0130       0.0113       5.1093    2706.3508    1350.9609      56.8125    2335.0000
  853.8972     143.1505     462.2422    1149.4213    1305.3914     993.2660       1.0068     311.0000      -0.0027      -0.0392       8.4136      34.1889     329.9232       4.4827      46.8683      -0.0133       0.0102       5.0080    2714.6575    1483.0505      56.3750    2333.0000
  854.0496     152.9885     503.1831    1950.0000    1950.0000    1950.0000       0.5043     311.0000      -0.0020      -0.0385       8.2946      28.0497     327.7379       2.6152      46.8683      -0.0130       0.0101       4.9572    2713.4719    2901.4148      56.8125    2312.0000
  854.2020     171.0158     446.7486    1400.6650    1604.7479    1310.0101       0.7634     311.0000       0.0009      -0.0355       8.2048      23.0885     327.1916       5.5187      46.8683      -0.0156       0.0074       4.8950    2708.5332    4608.1914      56.8125    2320.0000
  854.3544     176.8006     331.8557     855.4589    1336.3354     749.0901       1.3350     311.0000       0.0016      -0.0347       8.2643      24.2150     327.7379      25.1784      46.8683      -0.0113       0.0126       4.8044    2707.2280    3067.3223      56.8125    2346.0000
  854.5068     156.8356     266.8464     742.4676    1391.4893     570.1338       1.7540     311.0000       0.0057      -0.0305       8.2952      30.7241     328.2842      35.0714      46.8683      -0.0041       0.0211       4.6322    2700.2446     935.0130      56.8125    2378.0000
  854.6592     147.6244     225.2292     610.8887    1270.3042     473.1121       2.1137     311.0000       0.0131      -0.0228       8.2529      39.5102     328.8306      33.6344      46.8683      -0.0034       0.0232       4.4895    2687.5835     931.4088      56.8125    2381.0000
  854.8116     131.7522     246.2677     664.7964    1143.9403     713.3977       1.4017     311.0000       0.0109      -0.0251       8.2403      48.8665     329.3769      29.1831      46.8683      -0.0013       0.0268       4.4222    2691.3545     698.3986      59.2500    2384.0000
  854.9640     133.9188     255.6250     668.7492     755.2336     766.4211       1.3048     311.0000       0.0180      -0.0177       8.3222      65.0501     326.0990      18.7714      46.8683       0.0165       0.0472       4.3504    2679.1626     426.5860      58.6875    2330.0000
  855.1164     133.5296     285.3607     709.3848     631.4023     716.3275       1.3960     311.0000       0.0223      -0.0132       8.2649      80.4039     324.1869      14.9937      46.8683       0.0338       0.0670       4.3766    2671.8269     302.5578      57.3750    2307.0000
  855.2688     134.0547     290.5174     561.3426     674.5344     572.8802       1.7456     311.0000       0.0378       0.0028       8.2561      81.7862     322.2748      -2.1226      46.8683       0.0306       0.0632       4.4275    2645.3062     338.3552      56.8125    2322.0000
  855.4212     138.2440     197.9654     409.9753     499.7376     414.2576       2.4140     311.0000       0.0305      -0.0047       8.3285      75.3026     323.3674      -1.6508      46.8683       0.0059       0.0357       4.4905    2657.7607     419.5078      57.2500    2334.0000
  855.5736     121.9934     137.8573     274.6418     354.3600     266.8444       3.7475     311.0000       0.0188      -0.0169       8.3439      70.3716     323.9137       1.2290      46.8683       0.0066       0.0351       4.4787    2677.8052     517.9149      57.3750    2346.0000
  855.7260     118.5359     119.3013     216.9095     292.4421     208.8844       4.7873     311.0000       0.0097      -0.0263       8.3123      73.4552     326.6453       4.6725      46.8683       0.0015       0.0291       4.4477    2693.3721     449.8715      56.9375    2346.0000
  855.8784     107.5862     155.3597     280.8648     427.7303     288.1495       3.4704     311.0000       0.0052      -0.0310       8.1942      73.0850     328.0111       7.7083      46.8683      -0.0013       0.0257       4.5288    2701.1138     569.7731      58.6250    2321.0000
  856.0308     115.1783     226.8432     480.2135     552.3344     429.2889       2.3294     311.0000      -0.0051      -0.0417       8.2144      65.3557     327.1916      10.0491      46.8683       0.0010       0.0282       4.6994    2718.7859     462.2346      58.1875    2307.0000
  856.1832     127.6314     287.7924     730.6270     529.4836     635.1057       1.5745     311.0000      -0.0214      -0.0586       8.3310      52.9732     324.4601      17.0100      46.8683       0.0039       0.0310       4.9162    2746.6079     690.4244      57.6875    2326.0000
  856.3356     135.3949     315.6994     817.6903     968.8606     621.2667       1.6096     311.0000      -0.0303      -0.0678       8.3501      45.0981     323.0943      24.3711      46.8683      -0.0069       0.0186       5.0666    2761.8972    1193.2102      58.3750    2350.0000
  856.4880     153.2362     324.4862     958.7473    1124.4164     580.3995       1.7230     311.0000      -0.0214      -0.0585       8.3725      36.5535     325.5527      21.9851      46.8683      -0.0104       0.0136       5.0169    2746.5396    3306.9031      56.8125    2379.0000
  856.6404     154.3144     284.9527     988.7618    1298.6960     549.3098       1.8205     311.0000      -0.0050      -0.0415       8.2932      36.0953     327.1916      13.4563      46.8683      -0.0129       0.0102       4.8704    2718.4841    3202.7695      56.8125    2341.0000
  856.7928     151.4304     243.4635     979.2762    1549.6736     482.6871       2.0717     311.0000       0.0015      -0.0348       8.2297      39.2752     329.3769       6.7477      46.8683      -0.0166       0.0064       4.6852    2707.3909    3678.0557      56.8125    2370.0000
  856.9452     137.4888     238.9142     948.3679    1684.1172     609.4509       1.6408     311.0000       0.0031      -0.0332       8.3382      51.2294     328.8306       5.9314      46.8683      -0.0109       0.0136       4.5621    2704.7544    1373.1094      56.8125    2338.0000
  857.0976     136.6309     247.5703     961.1609    1674.7528     728.4701       1.3727     311.0000       0.0028      -0.0335       8.3675      63.0187     328.0111       6.0258      46.8683      -0.0017       0.0246       4.4139    2705.2476     675.1965      56.8125    2323.0000
  857.2500     138.0179     273.3014     937.1620    1598.0396     848.7852       1.1782     311.0000       0.0078      -0.0283       8.2518      68.9396     325.5527       2.3713      46.8683       0.0058       0.0342       4.3096    2696.7434     466.1534      56.8125    2357.0000
  857.4024     129.6405     257.3102     793.9693    1422.3257     790.7227       1.2647     311.0000       0.0126      -0.0233       8.2081      74.8677     322.2748       0.9792      46.8683       0.0135       0.0433       4.3133    2688.4331     445.9431      56.8125    2370.0000
  857.5548     122.5023     205.7044     582.7816    1246.6804     631.5805       1.5833     311.0000       0.0229      -0.0126       8.2303      82.5112     321.7285      -0.6959      46.8683       0.0146       0.0447       4.4051    2670.7593     515.2711      56.8750    2352.0000
  857.7072     124.8248     168.5383     424.3496     975.9741     473.7315       2.1109     311.0000       0.0337      -0.0014       8.3124      89.7601     323.3674      -1.8160      46.8683       0.0095       0.0386       4.5442    2652.3743     556.8546      56.8125    2341.0000
  857.8596     129.5556     158.4172     401.2252    1034.2472     458.8316       2.1794     311.0000       0.0284      -0.0069       8.3429      85.8871     327.1916       0.2789      46.8683       0.0095       0.0376       4.6433    2661.4021     567.0664      56.8125    2360.0000
  858.0120     127.4579     181.1865     475.1216    1170.2970     594.7299       1.6814     311.0000       0.0153      -0.0205       8.2750      74.1854     328.8306       1.7745      46.8683      -0.0001       0.0260       4.7565    2683.8572     723.5400      56.8125    2353.0000
  858.1644     132.9327     218.0428     653.4800    1307.4381     769.5975       1.2994     311.0000       0.0071      -0.0291       8.2884      58.3816     330.4695       1.1334      46.8683      -0.0166       0.0071       4.9025    2697.9431    1105.6573      53.8125    2355.0000
  858.3168     136.9935     300.0024     890.9798    1548.6638     980.2404       1.0202     311.0000       0.0092      -0.0268       8.3013      47.4439     330.4695      -1.4560      46.8683      -0.0189       0.0036       5.0535    2694.2847    2350.6665      55.3125    2338.0000
  858.4692     151.4656     326.8922    1274.1891    1777.8827    1240.4447       0.8062     311.0000       0.0068      -0.0293       8.2733      44.0279     327.7379      -1.1911      46.8683      -0.0089       0.0141       5.0922    2698.3389    2516.7771      54.3125    2361.0000
  858.6216     159.6084     355.6981    1490.7830    1870.2217    1215.3241       0.8228     311.0000      -0.0005      -0.0369       8.1871      41.2152     330.4695       0.0637      46.8683      -0.0153       0.0073       5.0556    2710.9343    3045.7747      51.1250    2390.0000
  858.7740     162.0314     360.7927    1690.3730    1935.1539    1013.2938       0.9869     311.0000      -0.0099      -0.0466       8.2817      37.7409     328.8306       1.7278      46.8683      -0.0179       0.0049       4.9648    2726.9038    3926.5078      52.0625    2326.0000
  858.9264     162.4171     352.6686    1792.2593    1950.0000     848.6846       1.1783     311.0000      -0.0059      -0.0425       8.2703      32.6661     330.4695      -0.5786      46.8683      -0.0090       0.0141       4.9724    2720.1433    4580.4058      54.1875    2329.0000
  859.0788     162.5143     340.9322    1793.1318    1945.5686     763.2162       1.3102     311.0000      -0.0040      -0.0405       8.2917      30.2109     332.9279      -1.0214      46.8683      -0.0138       0.0095       4.9422    2716.8586    4456.8569      51.6875    2347.0000
  859.2312     157.6649     330.9207    1755.7290    1910.8248     790.1876       1.2655     311.0000       0.0006      -0.0357       8.2841      33.2219     333.2011      -1.5359      46.8683      -0.0148       0.0083       4.9319    2708.9089    3167.6650      50.4375    2349.0000
  859.3836     155.0342     328.9034    1617.5496    1839.3519     951.8370       1.0506     311.0000       0.0045      -0.0317       8.2589      35.6343     332.1085      -1.7426      46.8683      -0.0077       0.0169       4.9200    2702.2295    2693.2375      51.7500    2343.0000
  859.5360     152.0726     315.3304    1408.8274    1737.6743     905.1464       1.1048     311.0000       0.0045      -0.0317       8.2422      38.0674     329.9232      -2.0688      46.8683      -0.0004       0.0250       4.8845    2702.2422    2304.4800      50.9375    2344.0000
  859.6884     146.9275     282.8112    1104.8326    1567.0881     729.6551       1.3705     311.0000      -0.0001      -0.0365       8.1551      38.7008     328.8306      -2.0945      46.8683      -0.0035       0.0222       4.8390    2710.1572    2553.3345      50.3750    2345.0000
  859.8408     143.8268     249.4460     912.9510    1417.3406     602.1698       1.6607     311.0000      -0.0122      -0.0490       8.1834      38.5213     329.6501       0.2763      46.8683      -0.0072       0.0180       4.7340    2730.8040    2048.9788      50.5000    2349.0000
  859.9932     143.2292     206.3304     683.4103    1240.4174     450.4098       2.2202     311.0000      -0.0117      -0.0485       8.2158      37.1043     331.5622       0.3600      46.8683      -0.0060       0.0190       4.7643    2730.0579    1688.7621      50.0625    2357.0000
  860.1456     141.6868     221.9596     743.0052    1534.4656     505.5780       1.9779     311.0000      -0.0099      -0.0466       8.2326      39.1593     334.2937       0.9058      46.8683      -0.0112       0.0131       4.8042    2726.8533    1570.3400      51.6875    2371.0000
  860.2980     138.3893     275.3765     970.1556    1560.2440     685.4413       1.4589     311.0000      -0.0011      -0.0375       8.3337      40.4423     334.2937      -0.5949      46.8683      -0.0084       0.0161       4.8952    2711.9055    1516.9672      51.8750    2341.0000
  860.4504     141.9307     309.7311    1129.2357    1617.4493     871.4368       1.1475     311.0000       0.0041      -0.0321       8.2438      41.8576     333.2011      -1.1456      46.8683      -0.0067       0.0179       4.9513    2703.0349     816.5934      53.3750    2338.0000
  860.6028     144.8441     305.3843    1180.6273    1603.9254     994.8009       1.0052     311.0000       0.0152      -0.0206       8.0831      36.9660     331.5622      -3.9058      46.8683      -0.0070       0.0179       5.0628    2684.0156     915.7213      54.5000    2337.0000
  860.7552     147.8981     300.8246    1125.9281    1524.6487    1019.5789       0.9808     311.0000       0.0192      -0.0165       8.1672      36.7632     330.4695      -4.7202      46.8683      -0.0048       0.0201       5.1294    2677.2144     897.4561      56.0000    2333.0000
  860.9076     142.4762     238.3123     828.8199    1197.7039     724.0527       1.3811     311.0000       0.0202      -0.0154       8.3373      34.5344     331.5622      -4.6275      46.8683      -0.0107       0.0134       5.1281    2675.4348    1522.6677      53.1875    2357.0000
  861.0600     141.7425     225.3772     734.7851    1262.0898     731.7551       1.3666     311.0000       0.0103      -0.0257       8.2498      37.5990     333.2011      16.1726      46.8683      -0.0088       0.0152       5.0255    2692.4565    1434.2258      52.1875    2358.0000
  861.2124     148.2826     267.9521    1033.2141    1497.7205    1070.9036       0.9338     311.0000       0.0061      -0.0300       8.2086      38.4967     334.2937      26.6964      46.8683      -0.0131       0.0105       4.9831    2699.5422    2005.5043      50.3125    2359.0000
  861.3648     154.3401     329.1064    1328.9806    1688.5071    1349.5906       0.7410     311.0000       0.0066      -0.0295       8.1809      38.9225     335.3864      25.3406      46.8683      -0.0104       0.0139       5.0064    2698.7158    2587.1130      51.3750    2349.0000
  861.5172     151.9585     352.9410    1536.4607    1817.3289    1521.9260       0.6571     311.0000       0.0121      -0.0238       8.2303      36.8709     335.3864       5.6217      46.8683      -0.0065       0.0181       5.0864    2689.2578    3128.4902      50.9375    2346.0000
  861.6696     153.0814     351.6492    1692.4435    1900.9478    1575.4377       0.6347     311.0000       0.0126      -0.0233       8.2448      34.5805     332.6548      -3.9570      46.8683      -0.0082       0.0163       5.0848    2688.5183    2985.6814      54.1250    2341.0000
  861.8220     153.6907     331.4508    1792.2827    1950.0000    1506.4197       0.6638     311.0000       0.0069      -0.0292       8.2158      35.7757     332.6548      -1.9374      46.8683      -0.0113       0.0128       5.0134    2698.1331    2879.0146      54.4375    2331.0000
  861.9744     154.6081     308.0172    1786.9952    1950.0000    1324.0696       0.7552     311.0000       0.0018      -0.0345       8.1701      34.6496     333.2011      -0.8252      46.8683      -0.0051       0.0196       4.9342    2706.8716    1811.3519      54.4375    2351.0000
  862.1268     154.2951     290.3961    1796.7954    1950.0000    1166.7170       0.8571     311.0000      -0.0002      -0.0366       8.2707      35.5469     334.8401      -1.2679      46.8683      -0.0075       0.0172       4.9013    2710.4248    1690.7842      55.5625    2358.0000
  862.2792     151.8936     283.7722    1681.6118    1937.3998     942.3382       1.0612     311.0000      -0.0016      -0.0380       8.3241      34.2995     335.9327      -1.9779      46.8683      -0.0081       0.0168       4.8909    2712.6875    1353.1892      56.8125    2401.0000
  862.4316     147.1257     282.5837    1577.2300    1814.8143     961.0908       1.0405     311.0000      -0.0058      -0.0424       8.2022      37.2491     336.4790      -1.9364      46.8683      -0.0083       0.0163       4.8616    2719.9070    1393.5894      56.8125    2394.0000
  862.5840     148.9505     305.3909    1494.7715    1692.5118     989.7706       1.0103     311.0000      -0.0155      -0.0524       8.1254      37.0704     335.1132       0.2718      46.8683      -0.0111       0.0132       4.7881    2736.5178    1220.0786      56.8125    2375.0000
  862.7364     144.5714     312.9423    1363.8473    1492.4882     983.0792       1.0172     311.0000      -0.0156      -0.0525       8.1970      39.3633     332.6548       0.2151      46.8683      -0.0048       0.0200       4.7817    2736.6960    1177.6041      56.8750    2345.0000
  862.8888     146.0884     295.8978    1157.2709    1257.0347     836.3150       1.1957     311.0000      -0.0041      -0.0407       8.2320      38.5763     330.4695      -2.0151      46.8683      -0.0052       0.0196       4.8625    2717.0876    1115.8644      58.3750    2337.0000
  863.0412     143.5707     261.3486     853.5381     935.6160     579.1771       1.7266     311.0000       0.0125      -0.0234       8.2253      39.5655     331.0158      -5.1439      46.8683      -0.0113       0.0129       5.0027    2688.6514    1022.7426      59.3125    2353.0000
  863.1936     129.3186     197.6657     577.4033     649.0375     346.1196       2.8892     311.0000       0.0206      -0.0150       8.1152      40.2901     333.2011      -6.3441      46.8683      -0.0083       0.0162       5.0789    2674.7815    1167.9720      62.8125    2370.0000
  863.3460     123.9385     180.2594     488.6491     507.3651     273.3428       3.6584     311.0000       0.0205      -0.0152       8.2157      40.2666     335.1132      -6.0546      46.8683      -0.0030       0.0216       5.0823    2675.0076     790.3981      63.8125    2361.0000
  863.4984     130.5519     223.5148     759.2617     814.3618     482.0294       2.0746     311.0000       0.0165      -0.0193       8.3092      36.4485     335.9327      -4.8709      46.8683      -0.0145       0.0090       5.0354    2681.7952     989.5024      63.9375    2359.0000
  863.6508     145.5086     294.6516     976.6855    1082.5995     705.3267       1.4178     311.0000       0.0065      -0.0296       8.1741      34.4758     336.7521      -1.8768      46.8683      -0.0113       0.0124       4.9323    2698.9009     914.6917      64.9375    2302.0000
  863.8032     147.9448     309.9851    1077.4493    1234.5573     816.2587       1.2251     311.0000      -0.0014      -0.0378       8.0749      34.9122     333.2011       0.4048      46.8683      -0.0082       0.0159       4.8468    2712.4104    1563.7606      66.2500    2285.0000
  863.9556     146.1272     283.4007     866.0494    1093.4535     644.8829       1.5507     311.0000       0.0005      -0.0358       8.1625      39.1355     332.1085      -0.5720      46.8683      -0.0104       0.0142       4.8437    2709.0825    1310.7908      66.3750    2301.0000
  864.1080     137.3572     240.8103     732.1666    1098.3125     496.6660       2.0134     311.0000       0.0094      -0.0266       8.1839      39.1579     332.3816      -3.5779      46.8683      -0.0071       0.0173       4.9249    2693.9387     828.8401      66.5625    2307.0000
  864.2604     129.7328     198.5004     572.2573     797.0070     425.0046       2.3529     311.0000       0.0140      -0.0218       8.2641      38.8985     334.2937      -5.3108      46.8683      -0.0090       0.0153       4.9931    2686.0049     677.3394      66.5625    2325.0000
  864.4128     127.9883     224.6575     661.3985    1058.2609     541.9672       1.8451     311.0000       0.0157      -0.0201       8.1861      36.2862     335.9327      -6.0022      46.8683      -0.0064       0.0179       5.0066    2683.1021     539.9315      66.1875    2350.0000
  864.5652     137.4544     272.1906     875.9476    1240.1202     736.0440       1.3586     311.0000       0.0140      -0.0219       8.0974      35.6590     337.5716      -4.7309      46.8683      -0.0099       0.0144       4.9562    2686.1228     739.6924      67.1875    2386.0000
  864.7176     139.3388     311.0733    1098.8734    1440.1763     981.1958       1.0192     311.0000       0.0106      -0.0254       8.1448      33.2531     337.5716      -2.1191      46.8683      -0.0143       0.0099       4.8706    2691.9412    1041.7130      69.7500    2376.0000
  864.8700     148.4258     304.6024    1150.6255    1488.8811    1082.8787       0.9235     311.0000       0.0004      -0.0359       8.2405      34.8524     335.3864       2.4743      46.8683      -0.0031       0.0220       4.7847    2709.2908    1416.2267      68.3125    2353.0000
  865.0224     151.3467     274.3638    1019.2595    1342.8805     994.0903       1.0059     311.0000      -0.0029      -0.0394       8.2351      34.6446     334.2937       3.3555      46.8683      -0.0090       0.0158       4.7667    2714.9517     876.8525      70.8125    2346.0000
  865.1748     147.4771     218.3253     776.5844    1067.8960     779.7560       1.2825     311.0000       0.0040      -0.0322       8.1997      35.8603     334.2937       0.4947      46.8683      -0.0049       0.0198       4.8353    2703.1096     994.8660      72.9375    2372.0000
  865.3272     134.5141     180.2612     602.5110     940.2556     571.3913       1.7501     311.0000       0.0148      -0.0211       8.1212      35.4295     335.9327      -3.4158      46.8683      -0.0085       0.0162       4.8558    2684.7522     981.0864      73.4375    2372.0000
  865.4796     127.6733     152.5403     458.2759     628.7944     459.5889       2.1759     311.0000       0.0179      -0.0178       8.1560      41.1363     337.8448      -3.2320      46.8683      -0.0077       0.0175       4.7670    2679.3149     785.6710      76.3125    2385.0000
  865.6320     123.1553     171.3196     488.4970     681.0976     501.5413       1.9939     311.0000       0.0175      -0.0183       8.1251      50.2015     339.7569      -1.2350      46.8683      -0.0001       0.0270       4.5799    2680.1372     447.9723      76.3125    2376.0000
  865.7844     120.2382     188.6817     480.0424     660.6647     449.0633       2.2269     311.0000       0.0203      -0.0153       8.1848      59.9946     338.3911      -0.1814      46.8683       0.0059       0.0344       4.4129    2675.2524     325.2823      76.3125    2333.0000
  865.9368     119.9361     190.7595     465.7861     633.9838     446.3719       2.2403     311.0000       0.0255      -0.0099       8.2393      69.1293     337.5716      -1.4615      46.8683       0.0107       0.0408       4.2781    2666.3557     331.2730      76.4375    2334.0000
  866.0892     119.1026     203.9824     357.2909     504.3933     308.2448       3.2442     311.0000       0.0285      -0.0069       8.1640      75.1514     334.8401      -3.2816      46.8683       0.0123       0.0434       4.1363    2661.3462     228.8588      78.2500    2371.0000
  866.2416     110.9540     176.7625     417.4706     601.1650     302.9883       3.3005     311.0000       0.0288      -0.0065       8.2324      85.0373     335.9327      -2.3036      46.8683       0.0279       0.0613       3.9562    2660.6790     206.4283      80.5625    2413.0000
  866.3940     106.5909     171.6101     380.3628     566.1144     274.1828       3.6472     311.0000       0.0281      -0.0073       8.2007      95.0322     337.0253       8.8484      46.8683       0.0297       0.0641       3.8579    2662.0139     157.6692      83.2500    2409.0000
  866.5464      99.0442     143.6033     342.0959     549.4638     251.2945       3.9794     311.0000       0.0283      -0.0071       8.1125     108.3107     339.7569      25.4126      46.8683       0.0390       0.0745       3.8092    2661.6396     103.0561      80.9375    2413.0000
  866.6988      95.3291     114.9917     272.4671     396.8065     197.7893       5.0559     311.0000       0.0351      -0.0000       8.1918     117.0231     342.2153      25.9848      46.8683       0.0449       0.0811       3.8596    2650.0454      80.8931      82.5625    2338.0000
  866.8512     101.7041     141.8510     373.9967     437.6470     256.1108       3.9046     311.0000       0.0378       0.0028       8.1793     116.2513     341.3958      15.9576      46.8683       0.0330       0.0687       3.9562    2645.2981      97.8062      83.0000    2353.0000
  867.0036     104.3827     195.1300     506.7859     696.3182     407.0253       2.4568     311.0000       0.0417       0.0068       8.1747     107.1914     342.4884       5.0795      46.8683       0.0387       0.0748       4.1445    2638.7351     196.5815      84.8750    2328.0000
  867.1560     102.7647     186.9676     584.5682     850.9759     536.9556       1.8624     311.0000       0.0378       0.0028       8.2352      95.0889     339.2105       2.9335      46.8683       0.0306       0.0658       4.3143    2645.4460     316.8690      84.6875    2306.0000
  867.3084     100.3869     163.4986     591.6874    1010.0894     637.7131       1.5681     311.0000       0.0349      -0.0002       8.2205      89.0668     340.8495       1.8044      46.8683       0.0316       0.0665       4.3978    2650.3687     149.1975      86.0000    2333.0000
  867.4608      91.7175     132.0361     447.4297    1025.7958     603.9390       1.6558     311.0000       0.0279      -0.0075       8.1406      84.8039     341.3958       0.7169      46.8683       0.0349       0.0698       4.4349    2662.3000     171.5164      85.3125    2329.0000
  867.6132     101.8308     145.8403     555.4633    1364.5233     803.8385       1.2440     311.0000       0.0175      -0.0183       8.1911      80.0961     341.9421      12.3889      46.8683       0.0228       0.0560       4.5038    2680.1504     208.3647      86.0625    2339.0000
  867.7656     112.8348     174.1907     789.3036    1504.1549    1027.6426       0.9731     311.0000       0.0158      -0.0200       8.2256      75.6308     353.6879      12.1858      46.8683       0.0123       0.0437       4.6751    2682.9509     823.1438      86.0625    2360.0000
  867.9180     116.6949     203.7498    1039.9901    1714.7654    1257.0503       0.7955     311.0000       0.0195      -0.0161       8.1732      75.1759     345.7664      11.0853      46.8683       0.0194       0.0506       4.8426    2676.5852    1187.8531      86.0625    2349.0000
  868.0704     117.9214     222.4533    1270.4943    1801.7532    1332.1622       0.7507     311.0000       0.0296      -0.0057       8.1971      76.3885     344.6737      -0.1705      46.8683       0.0161       0.0473       4.9337    2659.3936    2881.1499      85.7500    2352.0000
  868.2228     115.8401     234.7137    1419.8751    1781.6351    1230.0465       0.8130     311.0000       0.0359       0.0008       8.3237      78.2120     344.9469       0.0689      46.8683       0.0091       0.0394       4.8546    2648.6904    1154.4009      85.8750    2325.0000
  868.3752     115.4102     238.9743    1403.0785    1652.3573    1002.1188       0.9979     311.0000       0.0356       0.0005       8.1395      82.1855     342.4884       7.4968      46.8683       0.0098       0.0405       4.7061    2649.1909     877.1224      86.0625    2361.0000
  868.5276     113.7951     230.8249    1232.5029    1442.7356     826.7445       1.2096     311.0000       0.0316      -0.0037       8.1669      86.6957     339.7569       6.6254      46.8683       0.0191       0.0509       4.5927    2656.0415     710.7560      86.0625    2370.0000
  868.6800     107.3807     222.5934     998.5837    1205.1647     610.9758       1.6367     311.0000       0.0283      -0.0070       8.2210      87.2529     342.4884       6.3035      46.8683       0.0182       0.0499       4.5162    2661.6313    1245.0781      86.0625    2370.0000
  868.8324     104.7945     178.4794     741.7449     968.4644     499.1019       2.0036     311.0000       0.0118      -0.0241       8.2765      93.2750     344.1274      10.3791      46.8683       0.0150       0.0469       4.4228    2689.8445     743.0144      86.6875    2417.0000
  868.9848     103.0883     156.3367     590.8973     764.9503     413.3146       2.4195     311.0000       0.0093      -0.0268       8.2281      96.1221     344.6737      19.9256      46.8683       0.0253       0.0588       4.2942    2694.1689     398.1028      86.3750    2379.0000
  869.1372     101.0840     154.2385     524.7687     717.6371     394.2922       2.5362     311.0000       0.0176      -0.0182       8.1793      95.4116     343.5811      21.0588      46.8683       0.0498       0.0864       4.2392    2679.9773     344.4285      86.0625    2321.0000
  869.2896      98.2956     142.4655     466.5106     805.0991     397.9686       2.5128     311.0000       0.0394       0.0044       8.2094      83.1873     341.3958       7.6470      46.8683       0.0429       0.0790       4.2675    2642.6731     393.7123      86.9375    2371.0000
  869.4420      98.9185     142.1711     431.2722     856.2547     412.1437       2.4263     311.0000       0.0408       0.0059       8.2365      73.4593     338.6642       7.0293      46.8683       0.0279       0.0625       4.4086    2640.1863     604.1857      87.6875    2368.0000
  869.5944      94.4967     140.9587     362.0895     802.3140     350.2782       2.8549     311.0000       0.0185      -0.0172       8.1412      70.3708     341.9421      30.4313      46.8683       0.0181       0.0504       4.6064    2678.3162     566.0958      86.0625    2369.0000
  869.7468      86.9967     123.5395     328.6051     808.0917     303.1867       3.2983     311.0000      -0.0149      -0.0518       8.1567      65.9601     342.7616      60.5900      46.8683       0.0110       0.0418       4.7896    2735.5203     472.6103      85.7500    2358.0000
  869.8992      94.7328     136.7579     394.8393    1068.8143     388.3138       2.5752     311.0000      -0.0198      -0.0569       8.2730      65.2882     346.8590      68.4686      46.8683       0.0086       0.0383       4.8662    2743.8398     332.2500      84.3125    2359.0000
  870.0516     103.4965     154.7303     500.1014    1266.7234     523.8012       1.9091     311.0000      -0.0152      -0.0521       8.3320      61.8810     359.1511      65.9802      46.8683       0.0066       0.0358       4.8379    2735.9487     327.4222      84.8750    2399.0000
  870.2040     111.0758     174.6839     586.4872    1484.9261     597.0251       1.6750     311.0000       0.0005      -0.0359       8.2182      62.0709     353.9611      58.5814      46.8683       0.0100       0.0391       4.7789    2709.1890     291.8239      82.8125    2381.0000
  870.3564     117.4298     181.3651     599.3156    1693.6486     665.8141       1.5019     311.0000       0.0121      -0.0238       8.1392      62.1130     353.9611      44.5280      46.8683       0.0063       0.0350       4.7072    2689.2764     319.2599      84.8125    2400.0000
  870.5088     106.7287     173.4805     603.0864    1835.7756     668.1968       1.4966     311.0000       0.0276      -0.0078       8.1878      62.3707     346.3127      23.9072      46.8683       0.0024       0.0309       4.6556    2662.8569     297.9952      84.5000    2405.0000
  870.6612     102.5270     156.0583     546.9657    1830.3645     634.4173       1.5762     311.0000       0.0265      -0.0089       8.2510      64.6062     359.9705      19.3484      46.8683       0.0109       0.0402       4.5840    2664.7527     393.8498      83.1250    2419.0000
  870.8136     103.7791     140.5587     481.1033    1676.0374     542.3943       1.8437     311.0000       0.0065      -0.0296       8.1612      67.1981     347.9516      42.9409      46.8683       0.0095       0.0387       4.5378    2698.9001     188.9280      83.1875    2341.0000
  870.9660     102.3565     152.4673     517.4531    1367.5659     574.5862       1.7404     311.0000      -0.0152      -0.0521       8.1739      68.5878     350.6832      64.5080      46.8683       0.0062       0.0352       4.5096    2736.0276     194.9833      83.0000    2330.0000
  871.1184     103.2166     172.5253     553.9431    1090.5060     678.7269       1.4733     311.0000      -0.0092      -0.0459       8.2602      64.4945     353.4147      50.9706      46.8683       0.0088       0.0381       4.4979    2725.7200     196.4681      82.1250    2331.0000
  871.2708     102.7914     189.3196     528.9228     811.8125     705.2567       1.4179     311.0000      -0.0008      -0.0372       8.2678      58.1719     356.1463      27.3304      46.8683       0.0133       0.0435       4.4960    2711.3584     441.4448      80.0625    2331.0000
  871.4232     102.3793     193.7492     469.1920     634.6519     651.6011       1.5347     311.0000       0.0098      -0.0262       8.1959      56.8926     352.8684      13.0179      46.8683       0.0109       0.0412       4.5178    2693.2161     632.7309      82.0625    2338.0000
  871.5756     100.1144     124.3859     315.4543     396.7338     571.5251       1.7497     311.0000       0.0202      -0.0154       8.1728      60.7828     351.2295      12.4538      46.8683       0.0090       0.0392       4.5184    2675.4001     472.3719      80.9375    2352.0000
  871.7280     100.7267      99.1094     212.9749     279.2876     371.5101       2.6917     311.0000       0.0207      -0.0149       8.2540      59.8162     356.6926      23.5033      46.8683       0.0167       0.0474       4.5057    2674.5349     227.4154      81.4375    2365.0000
  871.8804     104.1729     121.6193     272.2343     335.5641     395.6678       2.5274     311.0000       0.0321      -0.0031       8.2332      60.0571     358.0584      15.6255      46.8683       0.0153       0.0460       4.4622    2655.1824     185.0171      78.3750    2387.0000
  872.0328      97.7347     167.4620     437.2765     526.2709     607.3307       1.6465     311.0000       0.0242      -0.0112       8.2563      58.0246     369.2579      21.6486      46.8683       0.0041       0.0341       4.4516    2668.5435     203.9941      77.5625    2385.0000
  872.1852      97.6633     234.6455     663.2803     770.9380     832.9191       1.2006     311.0000       0.0169      -0.0189       8.3163      65.3609     356.1463      39.2559      46.8683       0.0131       0.0442       4.4878    2681.1086     217.5606      76.4375    2370.0000
  872.3376     106.2103     235.8336     960.8253    1098.7723    1098.4956       0.9103     311.0000       0.0039      -0.0323       8.1967      68.4839     351.5027      75.3615      46.8683       0.0205       0.0529       4.5672    2703.2468     182.4185      76.3125    2339.0000
  872.4900     110.3066     226.0137    1185.4067    1340.0841    1206.5812       0.8288     311.0000      -0.0033      -0.0398       8.2629      70.2732     349.5905     109.8678      46.8683       0.0373       0.0722       4.7266    2715.6145     149.7875      76.3125    2371.0000
  872.6424     116.6914     209.4163    1426.7975    1580.1764    1279.7567       0.7814     311.0000       0.0041      -0.0321       8.2130      63.1347     347.9516     127.7320      46.8683       0.0407       0.0766       4.9386    2702.9915      97.8688      75.9375    2416.0000
  872.7948     128.9738     199.0358    1656.9722    1824.2646    1555.9796       0.6427     311.0000       0.0010      -0.0353       8.2721      55.7576     349.0442     134.6049      46.8683       0.0451       0.0816       5.1176    2708.2168      75.9876      74.5000    2429.0000
  872.9472     139.0920     198.7247    1655.4596    1876.0455    1575.0858       0.6349     311.0000      -0.0002      -0.0366       8.2572      48.0583     349.5905     125.8118      46.8683       0.0397       0.0746       5.2089    2710.3604      59.1289      76.1875    2415.0000
  873.0996     143.5657     208.4771    1447.5302    1711.1490    1399.0858       0.7148     311.0000      -0.0077      -0.0443       8.3384      43.4597     347.9516      98.4056      46.8683       0.0218       0.0544       5.1472    2723.1445      81.9061      73.6250    2369.0000
  873.2520     141.1225     229.0733    1225.4209    1460.4492    1127.0520       0.8873     311.0000      -0.0065      -0.0431       8.2440      37.3612     347.9516      57.1368      46.8683       0.0073       0.0367       5.0034    2721.1919     154.1637      72.5625    2405.0000
  873.4044     131.0136     259.7137     878.4419    1102.6777     784.5113       1.2747     311.0000      -0.0002      -0.0366       8.1848      30.4853     346.8590      21.6396      46.8683      -0.0063       0.0213       4.8702    2710.3176    1358.4116      71.9375    2367.0000
  873.5568     123.2763     252.4646     657.6961     774.9156     494.1419       2.0237     311.0000       0.0062      -0.0299       8.3166      27.4742     340.5763      21.1611      46.8683      -0.0105       0.0162       4.9126    2699.3826    2292.6248      70.6875    2352.0000
  873.7092     110.3928     300.2123     516.7666     596.8207     356.9048       2.8019     311.0000       0.0023      -0.0340       8.2233      30.8997     339.7569      69.6728      46.8683       0.0012       0.0301       5.1211    2706.0415     758.6585      70.7500    2357.0000
  873.8616     103.5774     185.4092     413.4810     433.0643     287.0181       3.4841     311.0000       0.0066      -0.0295       8.2531      36.5322     338.1179     133.7316      46.8683       0.0184       0.0499       5.3718    2698.7244     136.5959      71.1250    2386.0000
  874.0140      98.8963     131.5459     216.3731     227.9413     144.8923       6.9017     311.0000       0.0010      -0.0354       8.2038      46.3706     338.1179     185.5295      46.8683       0.0414       0.0765       5.4607    2708.3364      42.5970      71.5000    2376.0000
  874.1664      98.0841     127.5920     197.5919     188.7577      97.0407      10.3050     311.0000      -0.0021      -0.0385       8.2564      53.8672     340.3032     195.9751      46.8683       0.0468       0.0831       5.3634    2713.5779      35.7287      71.8125    2400.0000
  874.3188     126.0859     176.0612     318.1628     220.8829     129.2133       7.7391     311.0000      -0.0103      -0.0471       8.3353      62.1788     339.7569     174.0675      46.8683       0.0431       0.0799       5.1762    2727.6929      45.0438      72.8750    2401.0000
  874.4712     163.5111     316.0385     577.1638     520.9821     318.3719       3.1410     311.0000      -0.0188      -0.0559       8.2503      59.3748     337.0253     140.7893      47.1479       0.0441       0.0812       5.0254    2742.1575     120.8638      70.1875    2386.0000
  874.6236     162.1114     343.4712    1522.6555    1191.6370     723.0929       1.3829     311.0000      -0.0211      -0.0582       8.2020      59.6121     335.3864     112.0377      47.1479       0.0366       0.0720       4.9667    2746.0200     239.9933      70.5000    2379.0000
  874.7760     151.3852     333.7424    1178.9021    1226.0942     697.5733       1.4335     311.0000      -0.0235      -0.0607       8.2628      55.2087     336.4790     100.5311      46.8683       0.0186       0.0514       4.9898    2750.1111     260.1823      70.0000    2391.0000
  874.9284     122.1609     285.5540     833.0529    1114.9890     525.2750       1.9038     311.0000      -0.0213      -0.0584       8.3382      53.5848     338.1179     106.3945      46.8683       0.0148       0.0465       5.0696    2746.3477     376.3518      71.8125    2362.0000
  875.0808     107.9508     179.2485     655.0786    1241.3850     422.8387       2.3650     311.0000      -0.0216      -0.0587       8.2597      49.1840     339.7569     117.1927      46.8683       0.0218       0.0540       5.1443    2746.8730     229.1180      72.1250    2382.0000
  875.2332     112.7637     185.5506     759.2181    1622.0795     639.7022       1.5632     311.0000      -0.0205      -0.0576       8.1907      50.7742     346.8590     121.6843      46.8683       0.0124       0.0438       5.1756    2745.0120     201.6211      71.1875    2375.0000
  875.3856     131.2083     182.7039    1079.2634    1779.9661     806.5745       1.2398     311.0000      -0.0172      -0.0542       8.3525      54.4384     344.1274     108.1150      47.1479       0.0261       0.0593       5.1385    2739.4436     263.9421      70.5625    2372.0000
  875.5380     132.1846     210.0141    1221.4645    1847.4888    1008.2744       0.9918     311.0000      -0.0157      -0.0526       8.4167      55.3602     350.1369      88.6855      47.1479       0.0366       0.0714       5.0500    2736.8704     359.2994      72.3750    2378.0000
  875.6904     136.0995     225.7967    1400.7814    1846.0939    1206.7983       0.8286     311.0000      -0.0059      -0.0425       8.1087      49.3718     336.7521      54.4672      46.8683       0.0297       0.0642       4.9022    2720.0437     362.1248      74.1250    2374.0000
  875.8428     136.9012     253.7534    1507.6165    1759.3005    1259.7571       0.7938     311.0000      -0.0048      -0.0413       8.2508      40.8152     333.7474      30.3550      46.8683       0.0258       0.0593       4.8198    2718.1597     494.9620      76.3125    2402.0000
  875.9952     133.6745     282.8139    1508.7542    1619.3120    1160.8798       0.8614     311.0000      -0.0016      -0.0380       8.3175      34.1499     332.6548      10.5751      46.8683       0.0185       0.0500       4.7674    2712.7534    1082.3032      76.3125    2389.0000
  876.1476     130.9836     320.7046    1377.4133    1420.9648    1010.5016       0.9896     311.0000      -0.0029      -0.0394       8.2746      32.0653     337.0253       7.4551      47.1479       0.0032       0.0319       4.8470    2714.9478     996.2947      76.2500    2416.0000
  876.3000     131.1054     333.7215    1197.8278    1220.6538     822.0992       1.2164     311.0000      -0.0002      -0.0365       8.2108      29.2439     334.2937       1.2136      47.1479       0.0002       0.0276       4.8325    2710.2725    1166.1571      76.3125    2429.0000
  876.4524     122.9153     298.7755     835.6749     896.6924     462.1940       2.1636     311.0000       0.0009      -0.0354       8.1939      30.3551     335.9327      -1.3547      47.1479      -0.0063       0.0199       4.8198    2708.4810    1131.7145      76.3125    2439.0000
  876.6048     117.2348     229.0922     551.8802     562.0243     339.9346       2.9417     311.0000      -0.0075      -0.0441       8.1528      29.9361     333.2011       2.1694      46.8683      -0.0005       0.0261       4.7608    2722.7559    2105.1919      76.4375    2391.0000
  876.7572     115.7678     216.5624     496.8189     500.7086     301.8885       3.3125     311.0000      -0.0050      -0.0416       8.2638      32.2393     333.2011       6.4144      47.1479      -0.0003       0.0266       4.7935    2718.5862    1401.3031      77.2500    2396.0000
  876.9096     119.2903     192.0452     417.3149     396.2206     248.3149       4.0271     311.0000      -0.0119      -0.0487       8.2700      29.7071     331.0158      27.9982      47.1479       0.0054       0.0334       4.8621    2730.3787    1124.6270      77.6250    2393.0000
  877.0620     114.2503     169.8273     352.1756     306.7050     207.7930       4.8125     311.0000      -0.0088      -0.0455       8.2254      30.8210     332.1085      37.4861      46.8683      -0.0011       0.0265       4.9022    2724.9944     852.0998      79.3125    2372.0000
  877.2144     111.3545     162.6378     342.3969     309.5073     213.9484       4.6740     311.0000      -0.0085      -0.0452       8.1785      30.9340     332.6548      43.3204      47.1479       0.0038       0.0318       4.9303    2724.5557     861.1381      80.8125    2381.0000
  877.3668     115.7191     216.7597     544.0241     481.5025     316.6063       3.1585     311.0000      -0.0088      -0.0455       8.1762      32.3341     333.2011      56.6523      47.1479       0.0065       0.0349       5.0782    2725.0352    1426.1998      79.6875    2347.0000
  877.5192     119.2520     310.9417     750.5728     690.7773     449.5268       2.2246     311.0000      -0.0000      -0.0364       8.1831      32.1248     341.9421      97.3380      47.1479       0.0033       0.0322       5.4026    2710.0823     852.5494      84.2500    2370.0000
  877.6716     130.2972     290.1426    1039.9274     998.7571     701.6119       1.4253     311.0000      -0.0039      -0.0404       8.3100      33.5430     336.4790     163.4412      47.1479       0.0147       0.0451       5.7549    2716.6531     109.8243      84.9375    2349.0000
  877.8240     132.9446     277.1855    1245.1086    1270.1052     859.3793       1.1636     311.0000      -0.0008      -0.0372       8.2337      30.7376     339.4837     191.7439      47.1479       0.0188       0.0495       5.8886    2711.4304      47.4527      86.0625    2345.0000
  877.9764     140.3776     265.0432    1435.8925    1500.3943    1110.3615       0.9006     311.0000      -0.0138      -0.0507       8.2194      34.5019     342.4884     169.8475      47.1479       0.0237       0.0549       5.7129    2733.6379      46.5543      86.0625    2420.0000
  878.1288     143.8596     264.6901    1598.9584    1705.5225    1401.6163       0.7135     311.0000      -0.0165      -0.0534       8.2114      32.4944     351.2295     105.7224      47.1479       0.0130       0.0434       5.3709    2738.1860      89.9285      86.0625    2448.0000
  878.2812     145.3161     275.4189    1500.3401    1638.5370    1400.9727       0.7138     311.0000      -0.0031      -0.0396       8.3225      32.9576     333.7474      41.5995      47.1479       0.0069       0.0365       5.1161    2715.3640    1087.8185      86.0625    2439.0000
  878.4336     146.1431     293.6300    1359.5787    1480.4950    1266.8712       0.7893     311.0000       0.0030      -0.0333       8.1966      28.8788     332.1085      11.9171      47.1479      -0.0005       0.0275       5.0027    2704.9309    2906.4299      86.0625    2470.0000
  878.5860     147.8779     308.6114    1063.3473    1175.1395     947.0645       1.0559     311.0000       0.0125      -0.0234       8.1537      28.9131     332.1085      -0.5262      47.1479      -0.0010       0.0261       5.0053    2688.6663    3016.3110      86.0625    2441.0000
  878.7384     133.6897     329.2294     762.7344     854.6392     641.5597       1.5587     311.0000       0.0133      -0.0226       8.1559      26.7978     331.8353      -1.9951      47.1479       0.0023       0.0289       4.9808    2687.2166    2568.7908      86.5625    2414.0000
  878.8908     158.0861     276.9458     540.9868     604.9526     423.7438       2.3599     311.0000       0.0158      -0.0200       8.1869      25.7848     329.9232      -3.2396      47.1479      -0.0052       0.0201       4.9430    2683.0378    2894.1770      88.8750    2328.0000
  879.0432     135.6109     163.5249     312.6501     377.9971     240.5132       4.1578     311.0000       0.0164      -0.0194       8.3407      26.2267     330.7427      -4.5865      47.1479      -0.0128       0.0116       4.8798    2681.9644    2360.9922      92.8750    2359.0000
  879.1956     119.3102     137.8006     224.6863     236.7565     166.7159       5.9982     311.0000       0.0103      -0.0256       8.1572      30.2990     326.6453       5.1150      47.1479      -0.0062       0.0187       4.8236    2692.3098    2895.6040      93.9375    2372.0000
  879.3480     115.3588     171.6647     280.8241     305.5688     218.6670       4.5732     311.0000      -0.0013      -0.0377       8.1169      34.6154     325.5527      43.1399      47.1479      -0.0101       0.0149       4.8985    2712.2703    3076.0220      95.8750    2370.0000
  879.5004     127.3859     255.6344     410.7676     438.4938     313.4246       3.1906     311.0000      -0.0047      -0.0413       8.1989      41.8528     327.7379      88.3553      47.1479      -0.0089       0.0169       5.0299    2718.1118     710.4301      98.4375    2378.0000
  879.6528     133.7161     286.6842     481.9098     536.6085     398.4653       2.5096     311.0000      -0.0035      -0.0400       8.1681      48.9289     338.1179     124.4464      47.1479       0.0067       0.0346       5.1555    2715.9868     390.1891     101.5000    2395.0000
  879.8052     134.6657     212.4031     353.0198     384.0174     292.6909       3.4166     311.0000       0.0021      -0.0342       8.2186      54.5763     334.2937     136.0984      47.1479       0.0128       0.0432       5.1941    2706.4358     201.5300     101.0625    2370.0000
  879.9576     120.4762     146.9395     219.9495     287.8083     195.1759       5.1236     311.0000       0.0090      -0.0270       8.1159      56.1404     335.9327     138.8748      47.1479       0.0236       0.0564       5.2446    2694.6013     153.2832     101.0625    2358.0000
  880.1100     129.3092     144.6016     220.8877     330.0049     182.0287       5.4936     311.0000       0.0070      -0.0291       8.2016      55.3570     336.7521     147.1851      47.1479       0.0406       0.0765       5.3230    2698.0503     103.9103     102.9375    2382.0000
  880.2624     132.6467     186.6304     324.6120     458.6442     310.1754       3.2240     311.0000       0.0091      -0.0269       8.2555      54.3083     349.0442     146.9057      47.1479       0.0353       0.0710       5.3741    2694.4519      99.5836     105.6250    2382.0000
  880.4148     152.1482     250.0558     460.8367     567.7302     419.8242       2.3819     311.0000      -0.0002      -0.0366       8.2324      52.6870     349.0442     150.6226      47.1479       0.0382       0.0744       5.3884    2710.3950     112.3026     106.6250    2399.0000
  880.5672     134.6049     269.6076     544.3688     633.2703     555.4937       1.8002     311.0000      -0.0042      -0.0407       8.0821      53.2629     343.0348     157.1615      47.1479       0.0422       0.0785       5.4169    2717.1213     189.8672     105.6250    2375.0000
  880.7196     133.9446     317.0803     669.4507     791.6370     682.7370       1.4647     311.0000      -0.0051      -0.0417       8.1167      52.1748     346.3127     172.2057      47.1479       0.0287       0.0637       5.4999    2718.7278     176.9908     107.8750    2369.0000
  880.8720     136.4201     356.1054     785.4719    1079.4546     799.1334       1.2514     311.0000      -0.0041      -0.0406       8.1801      53.6173     343.5811     177.6946      47.1479       0.0313       0.0664       5.5560    2716.9998     131.4091     109.1875    2342.0000
  881.0244     137.0796     345.3537     784.1388    1218.0311     782.9062       1.2773     311.0000      -0.0065      -0.0431       8.1069      56.6042     346.8590     172.2703      47.1479       0.0434       0.0799       5.5073    2721.1506      76.0313     111.5625    2296.0000
  881.1768     115.8685     216.6375     658.3481    1359.6136     711.2242       1.4060     311.0000       0.0029      -0.0333       8.1027      56.3051     343.0348     146.3590      47.1479       0.0364       0.0727       5.3471    2704.9954      64.1878     113.3750    2369.0000
  881.3292     111.1395     173.7650     501.5043    1326.1604     541.3981       1.8471     311.0000       0.0093      -0.0267       8.1468      56.3408     335.9327     123.4183      47.1479       0.0382       0.0750       5.1478    2694.0144      74.5418     115.0000    2418.0000
  881.4816     108.5328     173.6629     523.1363    1378.3174     665.4810       1.5027     311.0000       0.0160      -0.0197       8.1706      51.9400     338.1179     103.3034      47.1479       0.0446       0.0817       4.9970    2682.5667      77.7669     115.3750    2377.0000
  881.6340     112.5817     179.6639     527.9471    1210.8676     792.0994       1.2625     311.0000       0.0107      -0.0253       8.0556      51.5340     327.7379      95.8231      47.1479       0.0467       0.0843       4.8932    2691.7705      94.7613     115.3750    2393.0000
  881.7864     121.2730     206.5861     516.7603    1026.2841     942.3638       1.0612     311.0000       0.0039      -0.0323       8.0682      47.0448     326.0990      92.7238      47.1479       0.0391       0.0762       4.8301    2703.3645     119.2020     115.3750    2371.0000
  881.9388     121.4292     165.0421     437.2148     867.0257    1112.2601       0.8991     311.0000       0.0037      -0.0326       8.1311      50.8901     325.8258      83.1022      47.1479       0.0556       0.0944       4.7726    2703.7207      76.8194     115.3750    2401.0000
  882.0912     124.8269     148.8175     302.0960     605.6406    1219.4362       0.8201     311.0000       0.0063      -0.0299       8.1370      55.1146     325.5527      60.8432      47.1479       0.0554       0.0940       4.6964    2699.2876      81.0775     115.3750    2432.0000
  882.2436     134.7018     199.9701     360.6418     557.5126     992.0016       1.0081     311.0000       0.0143      -0.0215       8.1143      59.5560     323.9137      31.2686      47.1479       0.0363       0.0722       4.6417    2685.5239     123.2205     117.3750    2393.0000
  882.3960     154.3827     288.6615     586.2932     734.3923    1319.0162       0.7581     311.0000       0.0193      -0.0163       8.0940      54.6933     328.8306      11.1678      47.1479       0.0124       0.0440       4.6638    2676.9456     663.6183     116.3125    2396.0000
  882.5484     148.6702     375.2150     869.7814     649.0050    1891.3982       0.5287     311.0000       0.0062      -0.0300       8.1621      50.4428     327.1916      30.9708      47.1479      -0.0013       0.0276       4.8057    2699.4375     972.8319     115.3750    2372.0000
  882.7008     159.8891     384.8339     673.7213     469.4667     917.2059       1.0903     311.0000      -0.0056      -0.0422       8.1325      46.2278     318.9969      62.3233      47.1479       0.0054       0.0338       4.9480    2719.6563     183.3531     115.3750    2368.0000
  882.8532     156.0233     305.8496     394.7380     452.4029     391.5088       2.5542     311.0000      -0.0134      -0.0503       7.9701      49.3297     319.5432      89.9296      47.1479       0.0118       0.0410       5.0142    2732.9675     143.5777     115.3750    2362.0000
  883.0056     171.4877     223.7254     297.6070     410.5664     250.0907       3.9985     311.0000      -0.0101      -0.0468       7.9633      51.9947     319.5432      81.5752      47.1479       0.0126       0.0420       4.9487    2727.2478      94.3886     115.3750    2358.0000
  883.1580     185.3452     200.0023     261.7681     344.1310     184.3932       5.4232     311.0000      -0.0011      -0.0375       8.2458      54.7793     319.5432      53.1094      47.1479       0.0040       0.0334       4.8412    2711.9382     122.7904     115.3125    2341.0000
  883.3104     185.4804     248.7637     321.0997     325.1868     241.0846       4.1479     311.0000       0.0043      -0.0319       8.1343      49.8789     320.0895      23.6616      47.1479       0.0114       0.0416       4.7155    2702.5854     150.7346     115.3750    2375.0000
  883.4628     204.3365     347.7517     412.1649     445.5768     375.8877       2.6604     311.0000       0.0106      -0.0253       8.0709      46.7507     321.7285       5.6720      47.1479       0.0107       0.0407       4.6140    2691.8271     354.8608     115.3750    2363.0000
  883.6152     145.9518     330.5068     431.0847     423.5862     323.4498       3.0917     311.0000       0.0120      -0.0239       8.0827      49.8141     317.3580       2.8830      47.1479       0.0115       0.0418       4.6011    2689.5093     232.8376     114.3750    2359.0000
  883.7676     146.6326     201.0446     257.7606     248.6742     312.6687       3.1983     311.0000       0.0156      -0.0202       8.1261      56.6779     318.4506       0.9434      47.1479       0.0170       0.0481       4.6411    2683.4082     229.5602     115.3750    2383.0000
  883.9200     128.3824     164.5584     201.7677     225.1756     219.5371       4.5550     311.0000       0.0174      -0.0183       8.0695      59.9613     315.1727       1.1539      47.1479       0.0207       0.0528       4.6889    2680.2175     242.9022     115.3750    2396.0000
  884.0724     115.7290     132.1681     156.4389     197.0136     153.4455       6.5170     311.0000       0.0143      -0.0215       8.1759      59.9613     315.7190       7.8144      47.1479       0.0185       0.0510       4.7117    2685.4683     183.7527     115.3750    2384.0000
  884.2248     117.7854     138.0854     170.5672     221.8543     152.7873       6.5450     311.0000       0.0129      -0.0230       8.0846      56.8398     317.3580      21.8461      47.1479       0.0240       0.0578       4.6935    2687.9822     177.0748     114.3125    2333.0000
  884.3772     114.6761     147.3663     187.3648     261.9767     178.6999       5.5960     311.0000       0.0101      -0.0259       8.1046      59.1205     317.9043      42.7723      47.1479       0.0314       0.0670       4.6979    2692.7131     131.2608     115.3750    2386.0000
  884.5296     114.3498     156.8958     198.4691     293.4198     216.5527       4.6178     311.0000       0.0150      -0.0208       8.1137      59.1592     316.2654      57.1704      47.1479       0.0496       0.0880       4.6965    2684.3477     110.1268     115.3750    2394.0000
  884.6820     116.0693     171.3184     231.4659     325.6157     261.1140       3.8297     311.0000       0.0183      -0.0174       8.1338      64.0233     319.5432      62.1431      47.1479       0.0710       0.1122       4.7590    2678.6399      77.2934     114.1250    2363.0000
  884.8344     113.7659     178.2161     251.3439     359.6922     318.4684       3.1400     311.0000       0.0260      -0.0094       8.1634      63.8203     321.7285      57.2703      47.1479       0.0711       0.1129       4.8242    2665.4897      59.1548     114.3750    2361.0000
  884.9868     108.5884     149.9777     218.2437     329.1296     310.5262       3.2203     311.0000       0.0276      -0.0078       8.0707      60.7181     314.6264      60.1380      47.1479       0.0660       0.1078       4.8558    2662.8435      53.5072     113.3125    2406.0000
  885.1392     106.5622     141.0618     211.5271     301.8671     338.1000       2.9577     311.0000       0.0270      -0.0084       7.9136      57.3547     322.2748      68.6915      47.1479       0.0740       0.1167       4.8200    2663.7881      49.3222     115.2500    2398.0000
  885.2916     109.3508     144.1242     210.6763     310.4273     407.1466       2.4561     311.0000       0.0191      -0.0166       8.0363      58.5309     327.7379      74.8935      47.1479       0.0827       0.1264       4.7113    2677.3638      47.2416     115.0625    2386.0000
  885.4440     114.1879     130.3785     211.8876     325.4410     437.0769       2.2879     311.0000       0.0210      -0.0146       8.0406      63.6751     321.7285      65.8650      47.1479       0.0867       0.1311       4.5416    2674.1694      66.9774     112.3750    2386.0000
  885.5964     102.7217     144.2703     220.4576     338.5588     438.6237       2.2799     311.0000       0.0298      -0.0054       8.1143      69.3483     320.6359      39.8223      47.1479       0.0719       0.1151       4.3228    2658.9844      84.7305     113.7500    2362.0000
  885.7488      90.3315     136.4489     186.6677     286.4153     368.4115       2.7144     311.0000       0.0375       0.0025       8.0791      73.0022     319.5432      25.9118      47.1479       0.0870       0.1312       4.1812    2645.8647      91.3444     115.0000    2379.0000
  885.9012      86.4518     119.2480     162.0993     255.2139     284.2993       3.5174     311.0000       0.0341      -0.0010       8.0792      72.7871     315.9922      29.9988      47.1479       0.0921       0.1360       4.1690    2651.7175      79.9130     113.5625    2374.0000
  886.0536      96.4913     131.4143     172.6698     246.5831     275.9915       3.6233     311.0000       0.0133      -0.0226       8.0577      68.7728     316.2654      61.7604      47.1479       0.0593       0.1003       4.2956    2687.2935      79.5343     115.3750    2372.0000
  886.2060      94.8764     136.3973     180.4031     228.9697     253.3117       3.9477     311.0000       0.0031      -0.0331       8.0767      63.9087     321.7285      81.7776      47.1479       0.0458       0.0851       4.4178    2704.6924     100.6735     116.3125    2408.0000
  886.3584      92.5452     122.2212     153.1869     218.0189     211.5896       4.7261     311.0000      -0.0045      -0.0410       8.0326      65.3297     315.7190      88.9540      47.1479       0.0593       0.0999       4.4895    2717.6396      84.8323     118.6875    2412.0000
  886.5108      95.3559     110.7814     133.0235     187.6507     156.4364       6.3924     311.0000       0.0058      -0.0304       7.9992      64.2549     316.2654      80.3530      47.1479       0.0730       0.1152       4.5449    2700.1660      91.3048     118.7500    2381.0000
  886.6632     110.6564     131.7364     164.8308     193.2697     181.5315       5.5087     311.0000       0.0151      -0.0208       8.0545      67.0858     324.7332      81.1675      47.1479       0.0768       0.1192       4.6852    2684.2476      92.0772     115.5000    2384.0000
  886.8156     118.7471     190.4184     241.2872     247.5641     235.1509       4.2526     311.0000       0.0191      -0.0166       8.0956      63.7992     319.5432      89.8702      47.1479       0.0667       0.1082       4.8826    2677.3508     113.4440     115.3750    2383.0000
  886.9680     131.2204     391.8201     428.9831     506.1859     395.5953       2.5278     311.0000       0.0145      -0.0213       8.0723      64.5368     319.2701      99.0400      47.1479       0.0534       0.0928       5.0223    2685.1575      45.8488     117.7500    2376.0000
  887.1204     137.1833     447.8687     372.8505     415.4355     397.1497       2.5179     311.0000       0.0064      -0.0297       8.0997      54.2940     325.5527     103.8699      47.1479       0.0530       0.0918       5.0485    2699.0745      46.7254     117.8750    2378.0000
  887.2728     123.9125     232.6291     336.4394     410.2507     359.9566       2.7781     311.0000       0.0035      -0.0327       8.0264      52.2679     313.2606     103.1964      47.1479       0.0481       0.0862       5.0123    2704.0122      41.9946     117.1250    2371.0000
  887.4252     114.0223     133.5842     201.1283     274.5144     253.2480       3.9487     311.0000       0.0042      -0.0320       8.0099      48.1393     328.8306     103.2059      47.1479       0.0433       0.0806       5.0046    2702.8657     100.8149     117.3750    2391.0000
  887.5776     118.9449     140.1377     199.7128     345.1560     244.6019       4.0883     311.0000       0.0059      -0.0302       7.9661      51.3820     321.7285     106.8940      47.1479       0.0353       0.0720       5.0369    2699.8269      72.8817     118.5000    2392.0000
  887.7300     120.6740     170.2395     280.8817     451.5358     419.6870       2.3827     311.0000       0.0205      -0.0151       7.9293      50.4019     324.4601     119.7236      47.1479       0.0354       0.0720       5.1462    2674.9531     126.2855     119.0625    2357.0000
  887.8824     114.2113     216.2604     456.8191     631.2538     621.8397       1.6081     311.0000       0.0292      -0.0061       8.1237      50.5503     318.4506     139.9226      47.1479       0.0460       0.0839       5.2603    2660.0315      80.0061     119.7500    2360.0000
  888.0348     106.1312     200.7861     316.6187     547.2513     603.8089       1.6562     311.0000       0.0259      -0.0095       8.1665      50.0844     318.7238     158.3693      47.1479       0.0496       0.0881       5.3288    2665.7563      28.3422     117.3125    2376.0000
  888.1872     109.6617     179.9231     292.0355     477.6732     614.7926       1.6266     311.0000       0.0139      -0.0219       8.0830      49.0384     318.4506     150.3108      47.1479       0.0511       0.0904       5.2626    2686.2163      26.5057     116.3750    2366.0000
  888.3396     126.1351     188.9027     290.1200     448.1640     552.3755       1.8104     311.0000       0.0048      -0.0314       8.0480      51.1229     317.0848     131.3686      47.1479       0.0688       0.1091       5.1186    2701.8591      30.7176     115.3750    2385.0000
  888.4920     106.1023     138.4499     225.1196     346.8548     448.8705       2.2278     311.0000       0.0059      -0.0302       8.0737      52.9157     312.9874     101.1503      47.1479       0.0515       0.0898       4.9460    2699.8330      47.4233     115.3750    2363.0000
  888.6444     100.7674     117.9129     168.1262     266.3374     332.2723       3.0096     311.0000       0.0095      -0.0266       8.0735      53.4780     313.5338      71.4662      47.1479       0.0323       0.0684       4.7470    2693.8364      51.0023     115.3750    2414.0000
  888.7968     112.6134     113.0887     156.5006     228.2505     284.9331       3.5096     311.0000       0.0146      -0.0212       8.0369      54.4573     314.6264      37.7746      47.1479       0.0422       0.0795       4.5490    2685.0608      72.0644     115.3750    2409.0000
  888.9492      94.0693     144.8075     184.8011     256.5697     315.4962       3.1696     311.0000       0.0197      -0.0160       8.0744      55.4465     316.8116      10.6115      47.1479       0.0444       0.0816       4.4513    2676.3896     169.2745     115.3750    2409.0000
  889.1016     109.8117     172.0872     217.7619     274.1754     354.3382       2.8222     311.0000       0.0238      -0.0117       8.1314      59.7872     316.8116      -0.0412      47.1479       0.0295       0.0648       4.5046    2669.2815     201.4412     115.3750    2383.0000
  889.2540     117.7032     202.2507     360.4677     523.5263     434.3678       2.3022     311.0000       0.0294      -0.0058       8.0810      59.2711     314.0800      -2.6824      47.1479       0.0318       0.0665       4.6512    2659.6487     256.4953     115.3750    2373.0000
  889.4064     125.9227     194.6617     307.3740     428.7607     440.4409       2.2705     311.0000       0.0336      -0.0015       8.1097      60.7519     311.3485      -4.0815      47.1479       0.0295       0.0638       4.7114    2652.5188     280.5976     113.9375    2372.0000
  889.5588     108.4518     153.5622     180.9064     208.2787     179.7803       5.5623     311.0000       0.0272      -0.0082       8.0720      60.3460     309.7096      -2.5399      47.1479       0.0317       0.0661       4.6530    2663.5298     237.1142     111.9375    2390.0000
  889.7112     100.4071     122.2578     145.1916     155.5290     127.4212       7.8480     311.0000       0.0193      -0.0164       8.1071      63.8203     310.8022      -0.5186      47.1479       0.0219       0.0557       4.5429    2677.0017     213.9757     113.1875    2392.0000
  889.8636      98.7893     108.0325     129.8210     152.3922     129.0435       7.7493     311.0000       0.0130      -0.0229       8.0886      62.1606     311.8948       1.6212      47.1479       0.0395       0.0750       4.4548    2687.7449     187.3229     111.5625    2424.0000
  890.0160     103.1489     123.5013     146.3806     152.7825     148.8387       6.7187     311.0000       0.0169      -0.0189       7.8733      60.5471     313.5338      -0.0584      47.1479       0.0252       0.0596       4.4656    2681.1816     214.3234     110.6250    2429.0000
  890.1684     119.7727     179.2781     218.7919     217.5886     237.9184       4.2031     311.0000       0.0223      -0.0133       7.9869      55.9680     315.1727      -1.6408      47.1479       0.0186       0.0521       4.5299    2671.9004     252.6678     110.5625    2399.0000
  890.3208     139.7949     244.2586     453.9400     356.7987     477.2982       2.0951     311.0000       0.0305      -0.0047       8.2674      57.9941     312.9874      -1.2898      47.1479       0.0275       0.0614       4.5629    2657.8223     389.2440     108.3750    2392.0000
  890.4732     140.7400     335.6019     588.8795     510.8635     527.0458       1.8974     311.0000       0.0353       0.0003       8.2034      62.1216     310.8022       5.1346      47.1479       0.0288       0.0625       4.5614    2649.5872     264.8546     106.6875    2394.0000
  890.6256     144.2120     236.1627     330.0504     364.9443     333.1909       3.0013     311.0000       0.0426       0.0078       7.9450      68.2440     308.6169       7.1473      47.1479       0.0421       0.0770       4.4967    2637.0808     176.8724     107.1875    2401.0000
  890.7780     151.2352     224.4271     316.4566     375.4337     300.3047       3.3300     311.0000       0.0449       0.0101       8.0182      70.3342     308.6169       5.5995      47.1479       0.0374       0.0720       4.5543    2633.2646     186.7807     106.3125    2398.0000
  890.9304     145.5041     204.9337     322.0444     456.5933     354.0262       2.8246     311.0000       0.0418       0.0069       8.1259      68.6322     309.4364      -0.4952      47.1479       0.0168       0.0497       4.6653    2638.5383     283.7278     106.3125    2357.0000
  891.0828     140.9108     189.6140     276.0306     502.7937     360.0510       2.7774     311.0000       0.0299      -0.0054       8.0911      60.5125     310.8022      -2.3568      47.1479       0.0157       0.0475       4.8331    2658.8625     411.2026     106.4375    2358.0000
  891.2352     143.5668     221.2872     337.2919     519.8997     408.0881       2.4505     311.0000       0.0170      -0.0188       8.0332      48.0051     313.5338      -2.2185      47.1479       0.0093       0.0394       4.9359    2680.9783     650.1009     107.1250    2383.0000
  891.3876     145.5912     240.7182     396.8196     520.4998     517.7041       1.9316     311.0000       0.0057      -0.0304       8.1037      35.5783     310.8022      -1.0140      47.1479       0.0062       0.0352       4.9803    2700.2341    1003.1362     106.6250    2351.0000
  891.5400     132.4173     321.7099     433.8941     565.6373     490.9761       2.0368     311.0000      -0.0011      -0.0375       8.0800      31.7214     309.7096      -2.9116      47.1479       0.0020       0.0306       4.9484    2711.8474    3017.1497     105.6250    2372.0000
  891.6924     116.3333     230.6546     252.3215     343.0163     306.1658       3.2662     311.0000      -0.0036      -0.0401       8.1292      38.2890     308.3438      -6.0897      47.1479       0.0050       0.0348       4.8040    2716.1980     918.8992     105.6250    2395.0000
  891.8448     104.3145     136.7163     179.3065     238.1161     219.3334       4.5593     311.0000       0.0021      -0.0342       8.1513      48.2487     306.9780      -6.0904      47.1479       0.0276       0.0608       4.5628    2706.3862     435.1828     105.6250    2394.0000
  891.9972      75.7309      84.5205     112.2911     157.6440     139.4440       7.1713     311.0000       0.0098      -0.0262       8.1790      65.0439     307.7975      -4.0081      47.1479       0.0337       0.0689       4.2730    2693.1599     126.5305     104.9375    2396.0000
  892.1496      66.4311      68.0149      84.2247     108.7194      92.0795      10.8602     311.0000       0.0094      -0.0266       8.0244      66.1589     309.1632      -0.0916      47.1479       0.0478       0.0857       4.0504    2693.8645      92.7278     105.6250    2399.0000
  892.3020      80.3947      87.9191     113.0995     139.3613     136.6691       7.3169     311.0000       0.0022      -0.0341       8.0096      66.7616     310.8022      -0.0103      47.1479       0.0551       0.0940       3.9978    2706.2224      86.2252     105.6250    2424.0000
  892.4544     108.0304     144.1401     210.4637     266.0335     294.4724       3.3959     311.0000      -0.0063      -0.0429       8.2102      52.5246     311.8948       3.0892      47.1479       0.0695       0.1101       4.2078    2720.8528     140.4411     105.0625    2429.0000
  892.6068     115.8814     288.9048     358.2480     382.3892     348.1503       2.8723     311.0000      -0.0008      -0.0371       8.2894      48.5999     309.7096       3.7527      47.1479       0.0435       0.0809       4.5452    2711.2917     200.8383     104.2500    2408.0000
  892.7592     120.5207     305.2130     303.4891     385.5814     418.2993       2.3906     311.0000      -0.0061      -0.0426       8.2013      41.2803     306.9780      17.4966      47.1479       0.0305       0.0655       4.8575    2720.3542     283.2124     103.6875    2361.0000
  892.9116     151.0247     203.9593     295.3689     397.3622     440.5459       2.2699     311.0000      -0.0125      -0.0493       8.0991      42.7819     306.9780      27.4391      47.1479       0.0242       0.0574       4.9783    2731.3342     334.2423     102.9375    2392.0000
  893.0640     129.4780     194.6822     254.9777     358.8385     422.0988       2.3691     311.0000      -0.0180      -0.0550       8.0715      48.2255     307.2511      32.1159      47.1479       0.0209       0.0537       4.9455    2740.7976     404.8347     102.8125    2401.0000
  893.2164     121.8637     154.1617     198.5880     283.2067     319.4285       3.1306     311.0000      -0.0061      -0.0426       8.1045      54.2878     309.1632      18.9879      47.1479       0.0167       0.0492       4.8053    2720.3652     369.5484     102.0000    2416.0000
  893.3688     111.5716     155.4598     196.7287     283.1444     322.7446       3.0984     311.0000       0.0088      -0.0272       8.1197      54.2586     309.1632       6.3100      47.1479       0.0206       0.0535       4.6784    2694.8840     414.3181     105.3750    2405.0000
  893.5212     109.4065     182.2427     242.1603     390.5936     394.5884       2.5343     311.0000       0.0166      -0.0192       8.1220      50.8475     311.8948       0.2029      47.1479       0.0145       0.0466       4.5679    2681.6929     328.5774     104.3750    2410.0000
  893.6736     112.9517     211.3047     309.6203     473.3593     487.3907       2.0517     311.0000       0.0246      -0.0108       8.1745      49.0656     309.7096      -1.6885      47.1479       0.0229       0.0557       4.5413    2667.8503     314.3736     104.0625    2389.0000
  893.8260     118.7219     220.4067     285.3740     402.3495     416.8504       2.3989     311.0000       0.0327      -0.0025       8.1504      53.7637     308.3438      -2.1961      47.1479       0.0337       0.0671       4.5642    2654.0657     311.1857     105.6250    2424.0000
  893.9784     125.1415     170.1036     223.7325     346.2787     351.9820       2.8411     311.0000       0.0372       0.0022       8.1020      58.1644     306.9780      -1.5790      47.1479       0.0232       0.0557       4.6208    2646.3936     334.4243     105.6250    2415.0000
  894.1308     118.6965     151.9226     211.0654     296.5233     280.9725       3.5591     311.0000       0.0382       0.0032       8.0449      59.6745     306.9780      -1.5948      47.1479       0.0244       0.0575       4.6825    2644.7014     528.9775     105.6250    2430.0000
  894.2832     114.6994     140.5041     184.0945     241.9501     233.3342       4.2857     311.0000       0.0343      -0.0008       8.1040      65.3583     308.0706      -0.9663      47.1479       0.0208       0.0539       4.6613    2651.3230     471.2768     107.8750    2376.0000
  894.4356     113.6605     152.2480     195.3787     228.4868     250.6208       3.9901     311.0000       0.0343      -0.0008       8.1215      69.6836     309.1632      -1.2877      47.1479       0.0228       0.0568       4.5825    2651.3445     359.0280     109.1250    2391.0000
  894.5880     112.1803     173.8172     196.4792     293.6695     247.1702       4.0458     311.0000       0.0406       0.0057       8.1301      75.4741     310.8022      -2.3959      47.1479       0.0321       0.0667       4.5069    2640.5195     283.8542     107.6250    2401.0000
  894.7404     111.0549     214.8425     311.2944     286.5845     403.8848       2.4760     311.0000       0.0373       0.0023       8.0807      78.3160     311.3485       3.9866      47.1479       0.0288       0.0632       4.4051    2646.1731     306.2906     108.5625    2347.0000
  894.8928     106.8583     202.7980     310.4981     381.0260     385.1367       2.5965     311.0000       0.0434       0.0087       8.0755      77.4650     309.1632       4.9636      47.1479       0.0247       0.0587       4.3413    2635.7273     275.6975     109.4375    2358.0000
  895.0452     106.5670     145.0681     195.1146     286.7694     261.7230       3.8208     311.0000       0.0403       0.0054       8.2440      80.7003     306.9780       8.5409      47.1479       0.0378       0.0732       4.2519    2641.1675     217.4112     111.8750    2335.0000
  895.1976     103.9096     124.2801     170.1031     275.9312     232.2441       4.3058     311.0000       0.0488       0.0142       8.2011      80.6464     305.8853      -0.1905      47.1479       0.0392       0.0752       4.2303    2626.5757     168.1000     112.5625    2396.0000
  895.3500      97.3509     116.2752     163.5772     259.1663     210.6486       4.7472     311.0000       0.0493       0.0147       8.0342      84.1802     307.5243      -0.7441      47.1479       0.0328       0.0682       4.2271    2625.6804     240.4585     113.8750    2413.0000
  895.5024     100.6436     114.9458     154.6048     210.0312     205.4510       4.8673     311.0000       0.0452       0.0105       8.0356      91.2717     307.5243      -1.1418      47.1479       0.0257       0.0606       4.1813    2632.6621     197.4561     114.3750    2391.0000
  895.6548      93.0660     123.2139     160.3466     218.6567     235.4908       4.2465     311.0000       0.0449       0.0101       8.0559      99.7914     308.8901       0.4961      47.1479       0.0391       0.0754       4.1347    2633.2891     141.3383     113.9375    2372.0000
  895.8072      99.5197     140.2568     171.7377     240.9511     276.4694       3.6170     311.0000       0.0499       0.0154       8.1686     107.8672     311.3485      -1.5366      47.1479       0.0471       0.0846       4.1715    2624.6101     142.2797     113.7500    2374.0000
  895.9596     104.2931     157.4728     209.8294     235.2637     373.6292       2.6765     311.0000       0.0579       0.0236       8.2095     104.2782     309.9827      -2.6433      47.1479       0.0387       0.0756       4.2271    2611.0654     135.0079     114.9375    2369.0000
  896.1120     103.8136     170.6471     209.5608     299.3819     327.2342       3.0559     311.0000       0.0606       0.0264       8.1230      96.8664     309.7096       2.7695      47.1479       0.0454       0.0825       4.3542    2606.4590     156.9912     115.3750    2393.0000
  896.2644     109.8936     142.6485     181.9887     247.6608     271.3192       3.6857     311.0000       0.0514       0.0169       8.0182      91.1826     309.9827      17.8432      47.1479       0.0393       0.0750       4.5344    2622.1086     160.1770     115.3750    2389.0000
  896.4168     111.8942     137.4815     165.9071     260.5434     249.7687       4.0037     311.0000       0.0408       0.0059       8.1454      83.9816     306.9780      42.8131      47.1479       0.0344       0.0691       4.7596    2640.1838     145.8344     115.4375    2431.0000
  896.5692     110.4725     120.9895     134.9620     192.7579     158.7991       6.2973     311.0000       0.0450       0.0103       8.1993      78.0110     307.7975      46.8094      47.1479       0.0237       0.0572       4.8604    2633.0393     105.5054     115.6250    2434.0000
  896.7216     114.5211     149.2944     185.6816     232.1106     241.5813       4.1394     311.0000       0.0512       0.0167       8.0600      76.0832     307.5243      33.8604      47.1479       0.0213       0.0547       4.7291    2622.4951     106.9123     117.3125    2393.0000
  896.8740     148.7868     192.1780     303.8490     253.4795     350.9569       2.8494     311.0000       0.0643       0.0303       8.0738      82.4157     309.1632       6.8333      47.1479       0.0152       0.0482       4.5410    2599.9741     268.3827     118.4375    2400.0000
  897.0264     138.6942     206.1990     505.8699     431.3369     606.2140       1.6496     311.0000       0.0656       0.0316       8.2174      90.5202     309.7096      -3.3269      47.1479       0.0267       0.0607       4.3641    2597.7854     299.0688     119.5000    2398.0000
  897.1788     109.1139     217.0337     320.6650     342.0737     281.1136       3.5573     311.0000       0.0681       0.0343       8.1299      99.0297     308.0706      -4.3862      47.1479       0.0350       0.0700       4.2637    2593.4663     156.5879     121.8125    2392.0000
  897.3312     101.5426     114.6847     157.7976     199.2659     186.4244       5.3641     311.0000       0.0668       0.0329       8.0637      99.6952     308.6169      -1.9622      47.1479       0.0417       0.0772       4.2044    2595.7131     158.6710     122.5000    2412.0000
  897.4836      98.2348      82.2572     115.5818     167.1730     115.9469       8.6246     311.0000       0.0617       0.0276       8.3287     100.8039     305.8853       0.5617      47.1479       0.0331       0.0685       4.1928    2604.5303     166.4093     123.6875    2423.0000
  897.6360      87.8754      81.8070     112.9846     147.9359     110.5486       9.0458     311.0000       0.0638       0.0297       8.3080      92.1924     306.1585      -0.7102      47.1479       0.0314       0.0669       4.2014    2600.9851     194.7745     124.3750    2447.0000
  897.7884      82.7280      86.9358     121.1497     146.1925     129.1482       7.7430     311.0000       0.0640       0.0299       7.9888      93.3504     306.9780      -1.7586      47.1479       0.0372       0.0735       4.1246    2600.6396     190.0973     124.1250    2410.0000
  897.9408      82.5598      96.0704     128.8499     151.3677     158.6613       6.3027     311.0000       0.0585       0.0243       8.0063      99.6884     309.1632      -0.3970      47.1479       0.0369       0.0738       4.0214    2609.9431     186.7633     125.1250    2379.0000
  898.0932      76.5565      99.4061     126.7444     130.3200     166.6523       6.0005     311.0000       0.0498       0.0152       8.2420     106.9297     311.3485       0.4957      47.1479       0.0431       0.0815       3.9540    2624.8481     162.0743     125.1250    2420.0000
  898.2456      70.6389      99.0121     117.9398     132.2861     146.2297       6.8386     311.0000       0.0449       0.0102       8.1723     108.9559     313.5338      -0.6263      47.1479       0.0765       0.1180       4.0328    2633.2415     110.4617     125.1250    2370.0000
  898.3980      66.9013      90.6326     110.8497     142.8569     134.3132       7.4453     311.0000       0.0439       0.0091       8.0374     101.2281     308.6169      -1.8406      47.1479       0.0722       0.1139       4.1165    2634.9941     119.2743     125.1250    2359.0000
  898.5504      57.8014      70.2360      86.6980     128.3355     112.2018       8.9125     311.0000       0.0342      -0.0009       8.1454      99.4676     308.6169       8.0607      47.1479       0.0593       0.1000       4.1353    2651.5596     101.9762     126.5000    2373.0000
  898.7028      49.8535      56.3058      72.3186     107.9122      95.8194      10.4363     311.0000       0.0377       0.0027       8.2364      98.0870     309.1632       8.9612      47.1479       0.0591       0.1003       4.0833    2645.5676      79.1054     127.0000    2414.0000
  898.8552      50.2097      59.2506      76.0784     106.0433     110.0864       9.0838     311.0000       0.0472       0.0125       8.1876     102.6907     310.8022       7.2956      47.1479       0.0762       0.1191       4.0470    2629.3018      60.7612     128.8125    2422.0000
  899.0076      58.1341      69.5280      93.7404     140.9186     180.0316       5.5546     311.0000       0.0542       0.0198       8.0827     100.8638     311.0753      -2.6522      47.1479       0.0805       0.1241       4.0261    2617.3828      54.9294     128.1250    2396.0000
  899.1600      70.4238      88.2981     131.7871     213.4013     258.4038       3.8699     311.0000       0.0377       0.0027       8.1393      98.5476     311.8948      -1.3967      47.1479       0.0872       0.1313       3.9986    2645.5828      63.9913     129.8750    2362.0000
  899.3124      82.8836     114.0306     172.1613     257.9711     336.3284       2.9733     311.0000       0.0145      -0.0213       8.0985      83.2837     309.1632       0.3872      47.1479       0.0851       0.1286       3.9950    2685.1650      72.1832     129.9375    2382.0000
  899.4648      84.6359     109.5854     149.5085     261.9294     409.7703       2.4404     311.0000       0.0039      -0.0323       8.0716      75.3218     305.3391       1.6224      47.1479       0.0629       0.1046       4.0480    2703.2515      90.6037     129.8125    2429.0000
  899.6172      73.0565      98.5570     139.4954     242.6935     409.0927       2.4444     311.0000      -0.0037      -0.0402       8.2339      68.6854     305.8853       3.9489      47.1479       0.0706       0.1130       4.0807    2716.3110      95.9008     129.8750    2399.0000
  899.7696      67.3602      93.0179     128.5386     229.8332     378.7455       2.6403     311.0000      -0.0025      -0.0389       8.2856      74.3585     305.8853       4.6899      47.1479       0.0734       0.1164       4.0694    2714.2219      86.4268     129.6250    2399.0000
  899.9220      67.5967      91.7675     121.0221     217.7303     346.7253       2.8841     311.0000       0.0001      -0.0363       8.0282      72.4545     305.3391       4.1788      47.1479       0.0751       0.1182       4.0341    2709.8240      85.6761     130.8125    2420.0000
  900.0744      74.1832     104.5792     128.2650     197.8190     299.9285       3.3341     311.0000       0.0060      -0.0302       8.0265      74.7318     304.7927       2.0986      47.1479       0.0880       0.1321       4.0086    2699.8223      85.6395     130.5625    2402.0000
  900.2268      81.9118     119.2805     151.6947     202.1014     258.5342       3.8680     311.0000       0.0081      -0.0280       8.1272      75.3180     305.3391       0.3111      47.1479       0.0786       0.1218       4.0472    2696.1802      99.1242     131.1875    2379.0000
  900.3792      94.4811     145.1064     177.9643     200.2583     244.0707       4.0972     311.0000       0.0041      -0.0321       8.1634      75.8463     305.3391      -0.5262      47.1479       0.0699       0.1118       4.0873    2703.0139     122.2370     131.6875    2377.0000
  900.5316      96.5900     146.6315     179.2293     236.0507     238.9427       4.1851     311.0000       0.0024      -0.0339       8.1136      73.7201     305.8853      -3.8085      47.1479       0.0632       0.1046       4.1296    2705.9099     139.0974     131.6250    2420.0000
  900.6840      94.5909     140.6383     161.3099     209.3106     211.2549       4.7336     311.0000      -0.0097      -0.0464       8.1106      67.5002     305.3391      -4.4193      47.1479       0.0629       0.1044       4.0675    2726.5425     138.4378     130.9375    2393.0000
  900.8364      91.0921     131.9836     152.1461     180.6633     159.8927       6.2542     311.0000      -0.0238      -0.0611       8.1951      63.4058     305.0659      -3.4571      47.1479       0.0613       0.1027       3.9730    2750.7710     140.8145     130.5000    2399.0000
  900.9888      95.3263     132.4636     162.0062     220.5432     183.6437       5.4453     311.0000      -0.0355      -0.0731       8.1895      64.0652     305.8853      10.4601      47.1479       0.0676       0.1089       3.9060    2770.6799     147.2222     128.7500    2425.0000
  901.1412      96.3502     127.0174     166.7422     234.8517     199.0116       5.0248     311.0000      -0.0328      -0.0703       8.1765      67.7903     305.8853      22.1498      47.1479       0.0570       0.0965       3.9448    2766.0588     156.3920     127.9375    2411.0000
  901.2936      90.0107     117.0581     150.0006     220.7412     173.7396       5.7557     311.0000      -0.0280      -0.0654       8.1707      72.0512     305.3391      21.7392      47.1479       0.0520       0.0912       4.0262    2757.8550     141.2256     128.5000    2399.0000
  901.4460      87.7589     114.9203     145.2094     196.3918     155.8714       6.4155     311.0000      -0.0209      -0.0580       8.1662      66.9859     305.3391       9.3381      47.1479       0.0575       0.0969       4.1481    2745.7656     148.0481     128.5000    2396.0000
  901.5984      94.7825     124.3522     161.0465     211.5109     188.5043       5.3049     311.0000      -0.0190      -0.0561       8.1970      66.5086     305.8853      -1.6294      47.1479       0.0440       0.0820       4.2195    2742.4841     165.9349     128.6250    2383.0000
  901.7508     102.9964     137.8720     189.1915     226.1969     229.0436       4.3660     311.0000      -0.0027      -0.0392       8.2188      64.8873     306.9780      -3.4649      47.1479       0.0403       0.0773       4.3581    2714.6985     201.2162     128.6250    2439.0000
  901.9032      98.7738     133.2550     178.8662     201.0187     224.1607       4.4611     311.0000       0.0101      -0.0259       8.2377      68.5776     307.5243      -3.3543      47.1479       0.0371       0.0734       4.4739    2692.6553     202.7956     128.5625    2459.0000
  902.0556      91.0128     120.9687     157.5235     194.8489     209.1280       4.7818     311.0000       0.0246      -0.0109       8.1342      67.3164     306.9780      -5.0104      47.1479       0.0390       0.0757       4.5909    2667.9092     194.7913     129.6250    2470.0000
  902.2080      84.0120     109.0095     144.1938     193.3503     198.7881       5.0305     311.0000       0.0232      -0.0123       8.2590      73.8607     306.9780      -3.1087      47.1479       0.0357       0.0721       4.5341    2670.3350     215.5089     128.0625    2432.0000
  902.3604      77.2172      99.5871     133.1884     179.9529     187.8602       5.3231     311.0000       0.0280      -0.0073       8.2482      87.1899     306.9780      -3.7863      47.1479       0.0405       0.0779       4.3833    2662.1106     159.7901     130.8125    2429.0000
  902.5128      69.9116      88.0184     115.7353     169.1667     168.9514       5.9189     311.0000       0.0301      -0.0052       8.0719     104.0068     306.9780      10.0906      47.1479       0.0529       0.0920       4.1357    2658.5378     114.3629     132.2500    2376.0000
  902.6652      65.5812      81.4531     106.8081     150.9695     154.4504       6.4746     311.0000       0.0373       0.0023       8.2069     116.4553     307.2511      20.3116      47.1479       0.0641       0.1046       3.9785    2646.1636      76.5803     133.8125    2387.0000
  902.8176      65.5862      81.3408     107.0336     151.6576     163.0681       6.1324     311.0000       0.0395       0.0045       8.2677     122.6133     306.4317      21.0013      47.1479       0.0705       0.1116       3.9226    2642.5254      68.4812     133.7500    2395.0000
  902.9700      64.9816      80.2795     105.6068     145.7014     165.4286       6.0449     311.0000       0.0477       0.0130       8.1915     128.9809     305.8853       6.9983      47.1479       0.0619       0.1021       4.0006    2628.4927      72.9220     134.0000    2381.0000
  903.1224      65.3244      80.1289     101.5656     137.4027     163.7660       6.1063     311.0000       0.0523       0.0178       8.2601     122.7271     305.8853      -4.2059      47.1479       0.0429       0.0809       4.1000    2620.5818      75.1638     133.7500    2392.0000
  903.2748      64.7679      79.6254     100.3981     130.7896     166.4203       6.0089     311.0000       0.0517       0.0172       8.1606     120.4942     306.4317      -3.7110      47.1479       0.0495       0.0882       4.1563    2621.6199      97.6917     134.8125    2394.0000
  903.4272      63.6955      78.1204      97.9615     139.0992     172.7567       5.7885     311.0000       0.0466       0.0119       8.1778     109.6497     305.3391      -1.5836      47.1479       0.0450       0.0830       4.1652    2630.2874     104.6578     134.9375    2411.0000
  903.5796      61.4463      75.2345      91.8624     126.3299     156.5523       6.3876     311.0000       0.0487       0.0141       8.2370     126.6891     305.3391      -0.8759      47.1479       0.0417       0.0797       4.1190    2626.7908     114.9893     135.8750    2403.0000
  903.7320      58.7603      71.9587      85.4723     111.8263     138.0765       7.2424     311.0000       0.0549       0.0205       8.3283     134.3129     305.3391      -1.3833      47.1479       0.0535       0.0925       4.0164    2616.1333      88.9779     136.5625    2373.0000
  903.8844      58.5518      71.7424      85.7733     111.5724     135.7624       7.3658     311.0000       0.0608       0.0267       8.2472     146.2267     305.3391      -3.1664      47.1479       0.0560       0.0954       3.9230    2606.0042      70.9036     138.8125    2402.0000
  904.0368      58.2350      71.0768      84.3317     108.4697     129.4985       7.7221     311.0000       0.0574       0.0231       8.2179     145.2136     305.3391      -3.2294      47.1479       0.0461       0.0846       3.8801    2611.8108      72.8819     140.0000    2429.0000
  904.1892      56.7936      67.6870      78.2579      97.7599     113.5427       8.8073     311.0000       0.0550       0.0207       8.3036     145.3035     304.7927      -3.4745      47.1479       0.0525       0.0913       3.9525    2615.9255      80.6127     138.7500    2409.0000
  904.3416      56.0751      66.6382      75.1400      89.7303     103.1958       9.6903     311.0000       0.0578       0.0235       8.2462     151.2245     304.7927      -4.2844      47.1479       0.0522       0.0911       4.0459    2611.1624      91.4595     139.6875    2431.0000
  904.4940      56.3804      67.0252      75.0652      92.7840     104.2669       9.5908     311.0000       0.0651       0.0311       8.2402     153.7537     305.3391      -5.3780      47.1479       0.0443       0.0822       4.1147    2598.6431      81.1834     141.5625    2423.0000
  904.6464      55.1699      65.0093      73.5870      91.6241     101.3296       9.8688     311.0000       0.0711       0.0373       8.2457     153.2586     305.0659      -6.1555      47.1479       0.0450       0.0829       4.1148    2588.3752      79.5837     142.6875    2439.0000
  904.7988      52.4159      61.9336      69.1401      85.1521      93.7645      10.6650     311.0000       0.0729       0.0392       8.2490     152.4442     305.3391      -6.0029      47.1479       0.0485       0.0869       4.1153    2585.2617      78.9767     143.6875    2435.0000
  904.9512      50.0356      58.5307      65.6494      80.9616      87.9000      11.3766     311.0000       0.0713       0.0375       8.2867     147.7996     304.7927      -7.1249      47.1479       0.0543       0.0935       4.0841    2588.1309      70.6841     143.3125    2395.0000
  905.1036      49.6889      57.2754      64.3198      79.4892      85.1402      11.7453     311.0000       0.0647       0.0306       8.1984     146.8408     304.7927      -5.8990      47.1479       0.0555       0.0952       4.0533    2599.4412      64.7525     143.2500    2412.0000
  905.2560      49.7340      56.8244      64.2071      79.1063      84.3612      11.8538     311.0000       0.0556       0.0212       8.3567     148.0751     305.8853      -3.7985      47.1479       0.0561       0.0959       3.9721    2614.9927      64.8954     144.6875    2398.0000
  905.4084      50.3890      57.0083      64.6259      81.7046      87.2495      11.4614     311.0000       0.0422       0.0073       8.3791     150.0808     305.3391       1.4923      47.1479       0.0593       0.0994       3.9645    2637.8789      63.6393     144.4375    2403.0000
  905.5608      51.9380      59.4446      66.1960      81.6497      90.4366      11.0575     311.0000       0.0387       0.0038       8.2612     151.1392     304.7927       2.0390      47.1479       0.0639       0.1043       4.0119    2643.7920      68.8927     144.6875    2484.0000
  905.7132      54.7784      62.7048      70.3526      84.2414      94.3004      10.6044     311.0000       0.0359       0.0009       8.2849     140.8871     304.2464       1.2569      47.1479       0.0469       0.0854       4.1069    2648.5586      80.4044     144.6875    2443.0000
  905.8656      57.7808      67.0019      74.4835      88.5190     101.8280       9.8205     311.0000       0.0446       0.0098       8.4654     132.0818     305.3391      -3.2408      47.1479       0.0407       0.0784       4.1787    2633.7764      75.3489     143.9375    2457.0000
  906.0180      58.6692      68.8403      73.5973      88.0832     102.9071       9.7175     311.0000       0.0485       0.0139       8.3126     125.4527     305.3391      -1.6820      47.1479       0.0441       0.0818       4.2281    2627.0579      86.0046     144.6875    2519.0000
  906.1704      58.8027      69.6999      77.1945      92.5163     108.2852       9.2349     311.0000       0.0536       0.0192       8.1355     124.3584     304.2464      -2.7587      47.1479       0.0470       0.0845       4.2705    2618.2832      88.3240     142.3125    2400.0000
  906.3228      59.2367      69.1124      77.6547      95.9919     106.1140       9.4238     311.0000       0.0577       0.0234       8.2040     128.8280     304.7927      -1.8766      47.1479       0.0355       0.0723       4.2536    2611.3533     118.3016     142.3750    2359.0000
  906.4752      56.9419      68.0102      75.9120      93.5953     102.3890       9.7667     311.0000       0.0631       0.0290       8.4358     137.1811     305.3391      -5.6181      47.1479       0.0492       0.0873       4.2183    2602.1282      80.6319     141.9375    2394.0000
  906.6276      55.5463      63.7129      73.9199      93.3312      98.1642      10.1870     311.0000       0.0644       0.0304       8.3577     140.3053     304.7927      -4.6158      47.1479       0.0487       0.0876       4.1753    2599.8281      73.6148     140.9375    2395.0000
  906.7800      54.1939      63.0094      71.9498      87.5621      92.4304      10.8190     311.0000       0.0651       0.0311       8.2589     142.8531     304.7927      -5.0967      47.1479       0.0583       0.0982       4.2127    2598.6089      66.2867     141.1875    2424.0000
  906.9324      56.3560      65.6704      74.9688      86.6329      98.3162      10.1713     311.0000       0.0643       0.0303       8.2049     141.7277     305.8853      -4.7302      47.1479       0.0667       0.1075       4.2515    2600.0010      89.7851     140.6250    2387.0000
  907.0848      58.8101      69.5185      78.8601      92.8073     104.0345       9.6122     311.0000       0.0636       0.0295       8.2316     137.0225     304.7927      -4.9436      47.1479       0.0480       0.0870       4.2693    2601.3152      91.6930     139.4375    2390.0000
  907.2372      59.2880      71.9155      80.0282      92.7246     105.2636       9.5000     311.0000       0.0642       0.0302       8.3080     138.2014     304.2464      -5.2192      47.1479       0.0525       0.0919       4.2500    2600.1353     100.1088     140.6875    2418.0000
  907.3896      57.6412      70.1626      77.6071      90.7833     101.1252       9.8887     311.0000       0.0608       0.0267       8.4152     142.7712     305.3391      -3.6981      47.1479       0.0493       0.0880       4.1580    2606.0264      97.6416     139.4375    2412.0000
  907.5420      56.3482      70.2663      74.6973      92.8732     101.6757       9.8352     311.0000       0.0584       0.0241       8.2352     151.4437     305.3391      -2.8884      47.1479       0.0512       0.0900       4.0550    2610.1858      79.1144     136.7500    2401.0000
  907.6944      55.3825      66.7088      74.5993      95.7912     100.5028       9.9500     311.0000       0.0559       0.0215       8.2354     155.9382     305.0659      -3.5996      47.1479       0.0429       0.0809       3.9617    2614.4773      76.7826     136.6875    2408.0000
  907.8468      55.4383      66.6642      77.8137     101.2725     109.0747       9.1680     311.0000       0.0553       0.0209       8.3893     149.8599     304.7927      -4.3528      47.1479       0.0609       0.1005       3.9263    2615.4475      68.5863     137.9375    2401.0000
  907.9992      56.8184      67.3941      76.7520     100.2857     106.7447       9.3681     311.0000       0.0579       0.0237       8.4611     146.2986     305.3391      -4.8773      47.1479       0.0559       0.0952       3.9233    2610.9480      78.0971     136.0625    2444.0000
  908.1516      57.9750      67.5060      77.8269     102.1949     107.3728       9.3133     311.0000       0.0534       0.0190       8.2575     132.9817     305.3391      -3.2430      47.1479       0.0479       0.0860       3.9369    2618.6707      74.6568     135.8750    2426.0000
  908.3040      61.8983      73.5030      82.5433     106.3054     113.0135       8.8485     311.0000       0.0518       0.0173       8.1400     134.8963     304.2464      -3.2847      47.1479       0.0403       0.0775       3.9773    2621.4187      90.3193     134.9375    2414.0000
  908.4564      67.0069      82.6142      93.1636     113.2068     130.9207       7.6382     311.0000       0.0466       0.0119       8.2983     134.8807     304.7927      -2.5208      47.1479       0.0341       0.0708       4.0261    2630.3660      95.3508     134.5000    2346.0000
  908.6088      70.0639      87.9513      98.7149     110.4353     139.0862       7.1898     311.0000       0.0411       0.0062       8.3394     129.4283     305.3391       0.6561      47.1479       0.0531       0.0915       4.0717    2639.7129     111.2258     134.7500    2373.0000
  908.7612      70.5330      92.6393     101.9632     119.6242     146.6058       6.8210     311.0000       0.0478       0.0132       8.2873     127.1085     305.3391       0.6790      47.1479       0.0403       0.0773       4.1407    2628.2212     115.9041     131.7500    2415.0000
  908.9136      72.7196      95.1438     104.4316     124.9249     150.3833       6.6497     311.0000       0.0573       0.0230       8.2422     129.7600     304.7927       0.5827      47.1479       0.0369       0.0736       4.1743    2611.9734     100.7087     130.2500    2434.0000
  909.0660      73.2859      95.8857     105.1315     134.0390     152.1034       6.5745     311.0000       0.0604       0.0262       8.3120     139.0802     304.7927      -2.5470      47.1479       0.0507       0.0889       4.1735    2606.7502      92.3741     129.4375    2381.0000
  909.2184      72.1758      91.1012     101.6544     129.3983     146.4534       6.8281     311.0000       0.0436       0.0088       8.3822     130.8444     305.3391       8.4035      47.1479       0.0540       0.0928       4.1949    2635.4131      96.2968     127.1875    2405.0000
  909.3708      79.4238     101.3857     114.0868     146.5208     165.8764       6.0286     311.0000       0.0251      -0.0104       8.2785     109.4317     304.7927       9.4326      47.1479       0.0495       0.0879       4.3095    2667.1531     125.5487     125.7500    2408.0000
  909.5232      89.8888     117.8875     137.2266     179.2892     201.6550       4.9590     311.0000       0.0121      -0.0238       8.2490      91.4481     304.7927      10.2885      47.1479       0.0431       0.0807       4.4004    2689.3044     164.9511     125.1250    2434.0000
  909.6756      87.0948     117.4301     133.4927     176.7238     197.6656       5.0591     311.0000       0.0038      -0.0324       8.2949      76.6791     304.7927       1.1706      47.1479       0.0308       0.0666       4.3887    2703.4282     151.6962     125.1250    2424.0000
  909.8280      86.8202     112.5949     127.7576     162.3482     193.0013       5.1813     311.0000       0.0040      -0.0322       8.4379      77.9986     304.2464      -0.8776      47.1479       0.0344       0.0699       4.3572    2703.1438     145.9473     125.1250    2444.0000
  909.9804      88.3339     114.0349     129.1844     168.2767     192.7080       5.1892     311.0000       0.0096      -0.0264       8.4142      79.3753     305.3391      -1.3549      47.1479       0.0387       0.0743       4.3762    2693.5142     156.6027     122.1875    2449.0000
  910.1328      88.6793     118.0812     131.0674     171.7871     193.5317       5.1671     311.0000       0.0196      -0.0160       8.1974      79.2822     305.3391      -2.4261      47.1479       0.0334       0.0690       4.4405    2676.4534     194.6186     120.1250    2478.0000
  910.2852      88.7582     117.0743     132.3841     167.5569     197.3580       5.0669     311.0000       0.0283      -0.0070       8.1932      78.2160     304.7927      -0.8674      47.1479       0.0345       0.0704       4.4714    2661.5417     167.8670     117.5625    2412.0000
  910.4376      90.8873     123.4926     139.3892     157.5669     192.9137       5.1837     311.0000       0.0361       0.0010       8.4256      81.9889     304.7927       6.7544      47.1479       0.0417       0.0780       4.5166    2648.2771     154.5540     116.8750    2346.0000
  910.5900      93.7274     125.7415     138.9758     167.7988     192.6209       5.1915     311.0000       0.0367       0.0017       8.4188      85.2307     305.3391       6.9585      47.1479       0.0253       0.0596       4.5461    2647.2695     153.3203     117.0000    2387.0000
  910.7424      96.6855     112.8248     127.0275     151.2750     173.5789       5.7611     311.0000       0.0311      -0.0041       8.2084      85.2819     304.7927       6.5606      47.1479       0.0268       0.0606       4.5132    2656.8350     171.0269     117.1250    2402.0000
  910.8948      89.0405     109.8220     120.0566     144.5891     160.8402       6.2174     311.0000       0.0305      -0.0047       8.1397      86.3730     304.7927      -1.6248      47.1479       0.0274       0.0612       4.4111    2657.7639     225.1319     115.9375    2418.0000
  911.0472      88.3282     106.6475     116.5487     136.0079     145.5842       6.8689     311.0000       0.0294      -0.0059       8.3792      93.5275     304.7927      -2.8412      47.1479       0.0200       0.0533       4.1895    2659.7056     165.0518     115.3750    2378.0000
  911.1996      81.8931     107.4740     117.8434     135.3197     142.0191       7.0413     311.0000       0.0331      -0.0020       8.5064     114.5320     305.3391      -2.8136      47.1479       0.0290       0.0641       3.9638    2653.3748     139.9895     115.3750    2408.0000
  911.3520      81.6050     111.2530     123.9406     140.6568     144.0031       6.9443     311.0000       0.0326      -0.0026       8.2677     126.1546     304.7927      -1.5843      47.1479       0.0452       0.0826       3.7510    2654.2280      98.8950     115.3750    2446.0000
  911.5044      82.1914     112.4593     128.1796     138.5623     147.6898       6.7709     311.0000       0.0352       0.0002       8.1441     136.9495     304.7927       0.6196      47.1479       0.0635       0.1032       3.6750    2649.7512      82.5316     115.0000    2426.0000
  911.6568      85.3778     112.9125     128.1277     141.9168     146.0647       6.8463     311.0000       0.0369       0.0019       8.2821     134.0357     305.3391       0.0069      47.1479       0.0580       0.0978       3.7650    2646.9314      72.9788     115.3125    2396.0000
  911.8092      88.4363     118.2466     134.5594     156.3314     147.3690       6.7857     311.0000       0.0407       0.0059       8.4728     129.6985     304.7927      -1.8721      47.1479       0.0541       0.0933       4.0423    2640.3286      96.6809     112.6875    2373.0000
  911.9616      96.3562     132.0665     155.0443     180.0640     167.6233       5.9658     311.0000       0.0386       0.0036       8.2583     123.5059     304.7927      -2.3732      47.1479       0.0464       0.0846       4.3150    2643.9966     156.5684     113.3125    2395.0000
  912.1140     104.4735     155.8881     182.9141     220.7247     213.8722       4.6757     311.0000       0.0310      -0.0042       8.1452     103.5404     305.3391      -0.6266      47.1479       0.0345       0.0698       4.4619    2656.9155     290.0436     110.0625    2413.0000
  912.2664     110.9697     178.1358     223.7260     272.7710     271.1483       3.6880     311.0000       0.0248      -0.0107       8.2740      88.8432     305.3391       0.4451      47.1479       0.0270       0.0604       4.4892    2667.6560     268.4133     108.7500    2460.0000
  912.4188     120.5285     220.1359     252.8947     346.9540     419.2497       2.3852     311.0000       0.0226      -0.0129       8.3608      77.1362     304.7927      -0.0196      47.1479       0.0178       0.0494       4.5498    2671.3074     276.4524     106.8125    2382.0000
  912.5712     136.0740     275.6755     388.3462     581.7033     631.6741       1.5831     311.0000       0.0216      -0.0140       8.3543      70.8912     305.3391      -1.5144      47.1479       0.0148       0.0462       4.7026    2673.0732     416.1683     105.6250    2407.0000
  912.7236     150.9218     307.7568     471.0163     676.8643     742.9023       1.3461     311.0000       0.0075      -0.0286       8.1157      57.6889     304.7927       2.4493      47.1479       0.0172       0.0476       4.8814    2697.2146     849.5594     106.0000    2419.0000
  912.8760     160.6539     289.8636     593.3597     896.2043     974.8245       1.0258     311.0000      -0.0063      -0.0429       8.0240      42.4432     305.3391       6.5622      47.1479      -0.0020       0.0255       5.0600    2720.7463    4464.2910     105.9375    2395.0000
  913.0284     163.9250     386.9521     676.1896    1091.6953    1165.9381       0.8577     311.0000      -0.0101      -0.0468       8.2828      33.2896     305.8853      -0.7224      47.1479      -0.0045       0.0213       5.1475    2727.2429    4543.8716     105.6250    2386.0000
  913.1808     154.9777     352.4122     732.0990    1326.7040    1201.7698       0.8321     311.0000      -0.0078      -0.0444       8.4173      32.3864     305.8853      -8.0311      47.1479      -0.0062       0.0191       5.1291    2723.2581    4477.9697     105.6250    2430.0000
  913.3332     159.5573     357.8542     750.3845    1302.3003    1303.9832       0.7669     311.0000       0.0007      -0.0356       8.1441      29.9551     305.8853     -13.3395      47.1479      -0.0124       0.0121       5.0221    2708.7654    4219.9634     105.6875    2446.0000
  913.4856     169.5294     472.9516    1104.0721    1940.3333    1649.8735       0.6061     311.0000      -0.0072      -0.0438       8.0332      30.9421     305.3391      -6.2926      47.1479      -0.0072       0.0179       4.7812    2722.3130    4128.2778     105.9375    2450.0000
  913.6380     175.1206     515.8386    1008.0096    1779.8488    1502.1566       0.6657     311.0000      -0.0111      -0.0479       8.2764      29.1674     305.8853      -2.7881      47.1479      -0.0031       0.0222       4.5843    2728.9988    3797.7917     105.6250    2429.0000
  913.7904     173.5467     494.0256     886.2949    1784.0283    1207.9027       0.8279     311.0000      -0.0199      -0.0570       8.4807      33.0409     305.3391       0.1185      47.1479      -0.0016       0.0239       4.4773    2743.9700    4041.8296     106.3125    2463.0000
  913.9428     178.9545     478.0988     947.9296    1781.4290    1131.1542       0.8841     311.0000      -0.0142      -0.0511       8.3346      31.4196     305.3391      -0.0780      47.1479      -0.0126       0.0119       4.5422    2734.3142    3222.5532     106.1250    2400.0000
  914.0952     179.0557     444.4601     933.4911    1643.0374     894.6522       1.1178     311.0000      -0.0087      -0.0453       8.1039      33.0435     304.7927      -0.6852      47.1479      -0.0078       0.0175       4.6052    2724.8120    3038.3533     107.8750    2363.0000
  914.2476     181.3533     356.4906     724.7170    1287.1061     975.0358       1.0256     311.0000      -0.0080      -0.0446       8.1379      32.8170     305.3391      -1.5500      47.1479      -0.0063       0.0192       4.5799    2723.6511    2865.8779     108.0625    2425.0000
  914.4000     193.0163     301.5159     529.1130     923.0524     733.5848       1.3632     311.0000      -0.0103      -0.0471       8.4038      33.2803     305.3391      -7.0043      47.1479      -0.0001       0.0257       4.5549    2727.6504    3586.2886     109.0625    2408.0000
  914.5524     171.4941     278.1092     447.8367     637.9719     566.6292       1.7648     311.0000      -0.0155      -0.0524       8.4298      34.4758     305.3391     -14.1013      47.1479      -0.0029       0.0228       4.4685    2736.4517    3503.7932     109.7500    2383.0000
  914.7048     135.6201     196.6142     262.0756     438.3472     383.7775       2.6057     311.0000      -0.0092      -0.0459       8.1841      35.1444     305.3391     -14.9639      47.1479      -0.0059       0.0207       4.3371    2725.7832    3344.6345     110.0625    2379.0000
  914.8572     112.1017     156.8882     203.5056     290.0959     288.2402       3.4693     311.0000       0.0090      -0.0271       8.1133      47.2696     304.5196     -10.7598      47.1479      -0.0022       0.0263       4.0759    2694.6885    1473.0216     112.8125    2425.0000
  915.0096      86.9214     117.6940     148.3691     194.0379     207.0341       4.8301     311.0000       0.0353       0.0002       8.3445      70.0583     304.2464      -4.1099      47.1479       0.0161       0.0480       3.7838    2649.6648     201.3256     114.6250    2433.0000
  915.1620      67.4798      92.7732     111.1338     136.5804     148.6037       6.7293     311.0000       0.0540       0.0196       8.3830      95.5993     305.3391      -3.8877      47.1479       0.0372       0.0728       3.5418    2617.6250      93.1938     115.3750    2402.0000
  915.3144      56.2141      66.3325      80.1662     102.4770     115.8305       8.6333     311.0000       0.0588       0.0245       8.2654     119.5938     304.7927      -3.1676      47.1479       0.0718       0.1126       3.4263    2609.5181      61.2214     115.3750    2390.0000
  915.4668      46.4990      49.4505      59.7486      69.4815      78.4779      12.7424     311.0000       0.0577       0.0234       8.1531     127.2372     303.4269      -0.6552      47.1479       0.0899       0.1341       3.3952    2611.3750      56.5269     118.3750    2427.0000
  915.6192      45.7365      47.7261      53.8776      58.7151      65.6207      15.2391     311.0000       0.0581       0.0239       8.3171     139.5241     303.7001      -2.0154      47.1479       0.0940       0.1390       3.4057    2610.6238      59.1467     118.4375    2401.0000
  915.7716      44.8109      49.6118      57.5827      62.9392      78.4707      12.7436     311.0000       0.0574       0.0231       8.4902     144.5033     304.2464      -2.6870      47.1479       0.0903       0.1351       3.4060    2611.9094      61.3770     121.1250    2413.0000
  915.9240      46.4437      52.5247      58.0102      71.5889      89.5099      11.1719     311.0000       0.0483       0.0137       8.3960     147.3795     305.0659      -2.6071      47.1479       0.0944       0.1392       3.3836    2627.3889      59.0101     122.3750    2439.0000
  916.0764      48.8034      56.0362      60.7103      74.3493      97.2889      10.2787     311.0000       0.0425       0.0076       8.1609     141.5835     304.2464      -0.6874      47.1479       0.0736       0.1170       3.3677    2637.4089      57.1155     123.9375    2406.0000
  916.2288      58.2423      59.8863      63.0579      79.9949     103.9770       9.6175     311.0000       0.0432       0.0084       8.2060     138.8592     303.7001      -0.0877      47.1479       0.0767       0.1200       3.3882    2636.1255      74.5739     124.2500    2398.0000
  916.3812      69.9446      85.2720      87.9314     113.3124     153.6429       6.5086     311.0000       0.0520       0.0175       8.3957     142.3149     303.7001      -2.0790      47.1479       0.0770       0.1201       3.4309    2621.0859      97.7696     125.1250    2413.0000
  916.5336      84.7020     148.8240     157.0593     178.5465     203.7511       4.9079     311.0000       0.0613       0.0271       8.3827     147.3138     304.7927      -4.3042      47.1479       0.0861       0.1300       3.4667    2605.2556     135.3123     125.1250    2420.0000
  916.6860      91.5838     136.5721     162.8814     216.7456     248.4710       4.0246     311.0000       0.0599       0.0257       8.1675     147.6978     304.7927      -2.7385      47.1479       0.0714       0.1138       3.4280    2607.5454     131.6160     126.1250    2398.0000
  916.8384      86.6110     120.2300     129.0847     181.0366     212.9865       4.6951     311.0000       0.0635       0.0294       8.1556     145.4649     303.7001      -2.9464      47.1479       0.0596       0.1008       3.4215    2601.4490     151.7892     125.1250    2402.0000
  916.9908      83.3641     121.1645     125.6334     149.0792     160.8897       6.2154     311.0000       0.0602       0.0261       8.3038     146.1597     302.6075      -1.2712      47.1479       0.0789       0.1217       3.3635    2606.9905     161.5731     125.3750    2400.0000
  917.1432      95.0907     136.9280     151.5931     200.1293     206.1123       4.8517     311.0000       0.0602       0.0260       8.3319     146.4739     303.1538      -1.5903      47.1479       0.0662       0.1080       3.3279    2607.1135     146.4117     125.4375    2413.0000
  917.2956     100.3719     143.7114     182.0175     247.1386     250.1535       3.9975     311.0000       0.0564       0.0221       8.2190     150.5898     303.7001      -1.2066      47.1479       0.0717       0.1139       3.2986    2613.4990     154.3073     125.1250    2399.0000
  917.4480      90.2785     134.6293     156.0723     196.2383     191.9026       5.2110     311.0000       0.0595       0.0253       8.1407     144.2084     302.6075      -3.0491      47.1479       0.0638       0.1052       3.3265    2608.2151     177.9523     125.8750    2422.0000
  917.6004      90.6948     128.5542     145.5027     158.2407     160.0752       6.2471     311.0000       0.0628       0.0287       8.2750     142.3849     301.5148       6.9454      47.1479       0.0665       0.1077       3.3462    2602.6475     195.2226     126.8750    2440.0000
  917.7528     103.9684     129.0840     177.4107     228.2037     209.1948       4.7802     311.0000       0.0629       0.0288       8.4028     142.9716     301.7880       6.7031      47.1479       0.0583       0.0987       3.3157    2602.4932     240.5134     125.7500    2450.0000
  917.9052     111.6897     155.6059     231.0220     290.5165     284.2542       3.5180     311.0000       0.0593       0.0251       8.3420     141.4312     302.6075       8.6374      47.1479       0.0581       0.0978       3.2692    2608.5593     262.5442     126.4375    2377.0000
  918.0576      92.3594     123.0788     156.0279     227.1062     199.1492       5.0214     311.0000       0.0616       0.0275       8.1892     137.7668     303.7001      -3.0546      47.1479       0.0513       0.0904       3.2333    2604.6650     226.1409     125.1250    2408.0000
  918.2100      77.4113      98.4000     120.8729     156.1240     158.1342       6.3237     311.0000       0.0644       0.0304       8.3475     129.6133     302.0611      -3.3581      47.1479       0.0558       0.0953       3.1856    2599.8057     158.2041     125.1250    2403.0000
  918.3624      79.1183      98.2954     121.4205     143.9333     168.3009       5.9417     311.0000       0.0627       0.0286       8.4661     124.7961     302.0611      -3.5605      47.1479       0.0491       0.0881       3.0989    2602.7373     144.9146     124.7500    2412.0000
  918.5148      77.7313      96.0254     114.1536     146.5678     159.0309       6.2881     311.0000       0.0571       0.0228       8.3083     123.4741     302.6075      -2.5244      47.1479       0.0480       0.0867       3.0355    2612.4280     156.6320     122.6250    2375.0000
  918.6672      74.2722      89.4101     112.5412     153.4620     171.5596       5.8289     311.0000       0.0569       0.0226       8.1117     124.0015     303.1538      -3.4313      47.1479       0.0479       0.0866       3.0664    2612.6521     171.1697     120.9375    2374.0000
  918.8196      71.7427      82.2060      98.5256     123.7858     140.8093       7.1018     311.0000       0.0611       0.0270       8.2943     129.1899     302.6075      -5.0685      47.1479       0.0525       0.0918       3.1793    2605.4871     104.2975     120.4375    2409.0000
  918.9720      63.8473      77.1877      87.0798     103.3845     115.5409       8.6549     311.0000       0.0604       0.0263       8.4760     130.3266     301.5148      -5.0983      47.1479       0.0614       0.1019       3.2800    2606.6582      87.3342     120.6875    2425.0000
  919.1244      65.7821      81.5169      93.9875     118.6436     134.1821       7.4526     311.0000       0.0555       0.0211       8.3960     131.0042     302.0611      -4.2665      47.1479       0.0597       0.1004       3.3002    2615.1187      79.2141     117.5625    2418.0000
  919.2768      70.5807      84.9818     101.3557     137.5136     154.1079       6.4890     311.0000       0.0544       0.0200       8.1262     135.6178     302.6075      -3.8030      47.1479       0.0623       0.1038       3.3089    2617.0515      85.7056     118.3750    2407.0000
  919.4292      65.8388      80.0805      87.7126     115.7670     131.0092       7.6331     311.0000       0.0556       0.0213       8.2526     135.4960     302.6075      -5.6903      47.1479       0.0893       0.1335       3.2892    2614.8792      76.3256     118.1875    2389.0000
  919.5816      60.0020      73.0211      79.0125      89.3175      97.4781      10.2587     311.0000       0.0535       0.0190       8.4620     138.2755     301.5148      -4.9157      47.1479       0.0850       0.1287       3.2673    2618.5876      72.2175     116.0000    2425.0000
  919.7340      65.9316      79.1011      88.5580     105.8997     111.4387       8.9735     311.0000       0.0534       0.0190       8.4504     134.5085     302.0611      -5.0142      47.1479       0.0738       0.1162       3.2118    2618.7053      82.9025     115.7500    2406.0000
  919.8864      70.9709      85.6021      99.8474     132.9843     143.0504       6.9905     311.0000       0.0560       0.0217       8.1976     131.8046     302.6075      -3.5412      47.1479       0.0618       0.1027       3.1645    2614.1792     113.9749     115.7500    2394.0000
  920.0388      70.7974      85.0493      95.4894     122.0992     141.0773       7.0883     311.0000       0.0584       0.0241       8.2512     137.3609     302.6075      -2.8217      47.1479       0.0604       0.1009       3.1333    2610.2041     124.6555     115.3750    2415.0000
  920.1912      71.4378      84.1212      92.6870     109.4206     127.8020       7.8246     311.0000       0.0581       0.0238       8.4471     135.9581     302.6075      -3.0346      47.1479       0.0519       0.0911       3.1422    2610.6592     110.2442     115.3750    2419.0000
  920.3436      72.1364      85.4856      96.0451     112.8055     128.9996       7.7520     311.0000       0.0572       0.0229       8.5438     146.4832     302.6075      -4.6418      47.1479       0.0476       0.0866       3.1580    2612.2002      95.2719     115.3750    2413.0000
  920.4960      73.1076      87.9151     101.2408     126.9405     143.5545       6.9660     311.0000       0.0572       0.0229       8.3618     130.9863     303.7001      -6.3443      47.1479       0.0538       0.0927       3.1722    2612.2673     107.1277     115.3750    2399.0000
  920.6484      70.6765      85.4968      98.2528     132.2526     144.5873       6.9162     311.0000       0.0576       0.0233       8.2494     138.2737     303.7001      -6.6888      47.1479       0.0480       0.0870       3.1603    2611.5623     128.1771     115.3750    2394.0000
  920.8008      67.9860      82.3355      93.5587     117.0231     127.2056       7.8613     311.0000       0.0633       0.0292       8.3350     136.6528     302.6075      -6.0437      47.1479       0.0567       0.0965       3.1829    2601.8218     153.7942     115.3750    2417.0000
  920.9532      64.6029      77.9392      91.0768     109.4512     116.5791       8.5779     311.0000       0.0707       0.0369       8.4647     151.2257     303.1538      -4.4687      47.1479       0.0565       0.0966       3.2406    2589.1860     118.1234     114.3750    2390.0000
  921.1056      60.9516      76.2970      88.9186     115.6357     120.9476       8.2680     311.0000       0.0684       0.0346       8.4221     149.6040     303.1538      -2.5084      47.1479       0.0554       0.0957       3.2874    2592.9631     103.3520     114.3750    2401.0000
  921.2580      58.1966      73.9945      82.0455     111.7338     114.8988       8.7033     311.0000       0.0576       0.0233       8.2517     151.9295     303.7001       0.2034      47.1479       0.0727       0.1146       3.2980    2611.5854      77.9717     114.2500    2416.0000
  921.4104      58.9905      66.1998      80.7265     108.8918     113.9168       8.7783     311.0000       0.0491       0.0145       8.2554     149.8449     303.1538       0.5238      47.1479       0.0633       0.1048       3.3114    2626.0273      68.5103     113.6875    2412.0000
  921.5628      59.5683      69.0728      84.7311     113.1793     121.9408       8.2007     311.0000       0.0520       0.0175       8.4043     145.7850     302.6075      -1.0526      47.1479       0.0721       0.1142       3.3575    2621.1135      61.5062     112.0000    2418.0000
  921.7152      62.8115      70.1907      84.0929     114.9762     130.3926       7.6691     311.0000       0.0597       0.0255       8.5019     142.8937     303.7001      -4.9455      47.1479       0.0761       0.1186       3.3796    2607.9824      61.3696     110.2500    2432.0000
  921.8676      60.4645      71.7413      90.2748     124.0556     146.8323       6.8105     311.0000       0.0629       0.0288       8.3706     146.8169     304.7927      -6.9323      47.1479       0.0785       0.1216       3.3579    2602.4343      60.6801     108.3125    2365.0000
  922.0200      57.4090      69.2824      83.3326     111.9157     140.5334       7.1157     311.0000       0.0661       0.0322       8.3097     151.5966     303.4269      -7.6239      47.1479       0.0772       0.1204       3.3283    2596.9358      62.2865     108.0000    2406.0000
  922.1724      54.7053      64.6959      77.8239     104.7953     135.1556       7.3989     311.0000       0.0631       0.0291       8.3754     155.1829     303.1538      -5.1336      47.1479       0.0740       0.1171       3.3253    2602.0505      63.5307     105.8125    2442.0000
  922.3248      54.7521      67.0143      82.6855     104.4370     142.4168       7.0216     311.0000       0.0564       0.0220       8.4339     149.7124     303.1538      -2.7421      47.1479       0.0775       0.1206       3.2942    2613.6221      63.0614     105.5625    2415.0000
  922.4772      55.3006      70.0711      83.5537     113.5320     146.4183       6.8297     311.0000       0.0461       0.0114       8.3684     153.2867     304.2464       1.3738      47.4275       0.0727       0.1153       3.2582    2631.1213      58.6119     105.2500    2395.0000
  922.6296      55.3823      69.3308      79.1620     112.6036     142.7645       7.0045     311.0000       0.0489       0.0144       8.3499     150.3587     304.2464       0.7553      47.1479       0.0791       0.1220       3.2562    2626.2986      56.3834     101.8125    2386.0000
  922.7820      56.2481      64.9124      75.4936     103.8896     129.0293       7.7502     311.0000       0.0567       0.0224       8.3955     158.8546     303.7001      -0.9687      47.1479       0.0679       0.1100       3.2891    2613.0701      61.4595     102.2500    2432.0000
  922.9344      56.9177      71.4275      80.5760     107.8605     128.6610       7.7724     311.0000       0.0626       0.0285       8.3644     150.0947     303.7001      -3.9849      47.1479       0.0599       0.1012       3.3158    2602.9285      70.0623      99.8750    2465.0000
  923.0868      62.3853      79.7721      89.5935     122.8690     153.9824       6.4942     311.0000       0.0585       0.0243       8.2959     152.3276     304.7927      -3.9256      47.4275       0.0774       0.1199       3.3300    2609.9353      70.8980      98.6875    2419.0000
  923.2392      68.0290      87.6399     103.1679     143.9729     184.5237       5.4194     311.0000       0.0543       0.0199       8.2882     143.2945     305.6122      -4.0507      47.4275       0.0769       0.1193       3.3937    2617.1980      67.9402      96.9375    2401.0000
  923.3916      69.4493      89.0285      99.0518     138.4846     179.5457       5.5696     311.0000       0.0455       0.0108       8.3693     143.2121     305.3391      -3.6545      47.1479       0.0616       0.1031       3.4716    2632.1990      71.0968      95.6875    2419.0000
  923.5440      70.2501      88.5999      99.6052     131.1281     164.2403       6.0886     311.0000       0.0308      -0.0045       8.4412     130.9087     304.7927      -2.8560      47.1479       0.0597       0.1006       3.5453    2657.3511      86.2893      93.6250    2459.0000
  923.6964      73.9706      95.3897     110.1436     140.0373     172.7930       5.7873     311.0000       0.0138      -0.0221       8.3822     125.5702     305.3391      -3.4757      47.4275       0.0762       0.1181       3.6052    2686.4468      95.9090      91.9375    2435.0000
  923.8488      78.3895     107.6118     125.1413     159.6019     195.0966       5.1257     311.0000       0.0019      -0.0343       8.2961     115.2369     305.8853      -5.8513      47.4275       0.0505       0.0903       3.6849    2706.6731     145.4080      90.2500    2401.0000
  924.0012      74.0111     100.0743     116.5027     148.8190     173.0120       5.7799     311.0000      -0.0021      -0.0385       8.3221     111.6783     305.3391      -7.1185      47.1479       0.0569       0.0971       3.7814    2713.5928     222.2112      90.2500    2405.0000
  924.1536      69.2685      89.3096      99.6995     122.6900     141.1064       7.0869     311.0000       0.0066      -0.0295       8.4597     105.5128     304.7927      -5.8904      47.1479       0.0625       0.1036       3.8432    2698.7542     344.7625      89.3125    2467.0000
  924.3060      68.9790      85.0989      95.8533     118.7679     132.4516       7.5499     311.0000       0.0077      -0.0283       8.5008     114.0225     304.7927      -3.3791      47.1479       0.0791       0.1217       3.7884    2696.7666     166.7590      88.6250    2448.0000
  924.4584      76.5414     100.9757     110.3307     140.1342     150.4244       6.6479     311.0000       0.0018      -0.0345       8.4213     110.7798     305.8853      -2.2392      47.4275       0.0782       0.1213       3.6806    2706.9006     121.8894      87.7500    2430.0000
  924.6108      84.0030     111.1219     127.9026     161.9983     166.4646       6.0073     311.0000      -0.0122      -0.0490       8.3337     104.2358     306.7048      -3.5002      47.4275       0.0742       0.1167       3.6039    2730.9194     130.4161      87.6250    2410.0000
  924.7632      85.7823     115.2872     134.5537     172.3728     173.1628       5.7749     311.0000      -0.0175      -0.0545       8.3697      86.6544     305.3391       3.3212      47.4275       0.0595       0.1005       3.5894    2739.9429     170.9495      86.9375    2419.0000
  924.9156      79.0739     102.3088     120.6638     160.5410     155.0256       6.4505     311.0000      -0.0129      -0.0497       8.5307      85.7279     304.7927      16.5915      47.4275       0.0439       0.0830       3.5759    2732.0010     162.2103      86.2500    2449.0000
  925.0680      74.6331      95.3961     107.0275     135.1256     134.7502       7.4211     311.0000      -0.0078      -0.0444       8.4598      84.4572     304.7927      35.1007      47.4275       0.0563       0.0965       3.5331    2723.3113     133.8970      86.5625    2409.0000
  925.2204      72.1040      90.1977     107.1617     135.8680     140.6341       7.1107     311.0000      -0.0000      -0.0364       8.2811      92.3132     305.8853      30.1642      47.4275       0.0690       0.1099       3.5346    2710.0830     118.5253      86.6250    2401.0000
  925.3728      69.7227      86.2454     102.4398     143.5098     153.6510       6.5083     311.0000       0.0011      -0.0352       8.2810      94.2381     305.6122      17.8347      47.4275       0.0561       0.0964       3.5055    2708.0347      98.0975      86.6250    2436.0000
  925.5252      69.8287      80.6519      94.3270     123.8194     140.5041       7.1172     311.0000       0.0074      -0.0287       8.4643     101.3296     303.7001      -0.8523      47.4275       0.0694       0.1110       3.5203    2697.2871      71.2929      86.0625    2462.0000
  925.6776      73.1609      81.2804      92.1550     110.4251     128.1584       7.8028     311.0000       0.0054      -0.0307       8.4652     107.1287     304.7927      -4.2548      47.4275       0.0917       0.1359       3.5137    2700.6814      64.5757      86.0625    2418.0000
  925.8300      73.7872      86.9440      99.2157     124.2833     141.2299       7.0807     311.0000      -0.0028      -0.0392       8.3364     105.7477     306.4317      -5.3151      47.4275       0.0781       0.1212       3.5437    2714.7534      79.7723      85.3750    2433.0000
  925.9824      77.8211      95.6808     112.1474     140.9052     163.2961       6.1238     311.0000      -0.0122      -0.0490       8.2740      99.2139     306.4317      -0.2854      47.4275       0.0636       0.1053       3.5657    2730.8420     128.7892      82.7500    2435.0000
  926.1348      78.6453      98.0061     116.9179     149.9306     168.3241       5.9409     311.0000      -0.0177      -0.0547       8.3874      92.8665     305.3391       1.9257      47.4275       0.0525       0.0924       3.5875    2740.2007     139.2682      84.1875    2465.0000
  926.2872      70.8924      90.6279     106.6305     128.8146     144.4664       6.9220     311.0000      -0.0051      -0.0416       8.4908      92.3226     304.7927       2.2855      47.4275       0.0515       0.0911       3.6394    2718.6816      99.7841      82.1875    2438.0000
  926.4396      64.3713      79.4787      92.9980     114.6469     123.9187       8.0698     311.0000       0.0097      -0.0263       8.3433     102.5763     305.8853      -2.1219      47.4275       0.0655       0.1067       3.6628    2693.3420      66.3202      84.2500    2405.0000
  926.5920      59.2762      69.0980      81.1438     101.3197     105.0343       9.5207     311.0000       0.0246      -0.0108       8.2335     112.3980     306.4317      -3.2098      47.4275       0.0722       0.1142       3.6321    2667.8845      63.3582      83.8750    2449.0000
  926.7444      56.3543      63.4030      74.7097      87.8762      94.7067      10.5589     311.0000       0.0237      -0.0118       8.3736     125.3245     305.8853      11.7140      47.4275       0.0717       0.1142       3.5612    2669.4429      61.4127      84.8125    2465.0000
  926.8968      56.4116      63.2742      75.1699      91.0312      98.7709      10.1244     311.0000       0.0167      -0.0191       8.4696     124.8464     305.6122      11.1313      47.4275       0.0786       0.1216       3.5078    2681.5266      67.1414      82.4375    2424.0000
  927.0492      55.6707      63.1771      74.2629      92.5621     101.5025       9.8520     311.0000       0.0075      -0.0286       8.3752     122.5302     305.8853      10.0863      47.4275       0.0753       0.1182       3.4970    2697.1379      76.4508      82.5000    2401.0000
  927.2016      53.3666      61.2370      71.5544      91.0813     102.0353       9.8005     311.0000       0.0057      -0.0305       8.2477     110.0873     306.4317      -5.9099      47.4275       0.0699       0.1120       3.4930    2700.2444      91.7371      81.9375    2412.0000
  927.3540      51.7805      60.1523      69.4411      89.8426     102.7837       9.7292     311.0000       0.0112      -0.0248       8.2352     108.9615     305.8853      -2.8470      47.4275       0.0700       0.1120       3.4620    2690.8633      88.3863      81.6250    2471.0000
  927.5064      49.5656      58.0144      67.1637      87.5454     102.6479       9.7420     311.0000       0.0228      -0.0127       8.2951     112.9453     304.7927       0.1123      47.4275       0.0732       0.1157       3.4470    2670.9844      67.7523      80.7500    2471.0000
  927.6588      48.7799      58.7670      66.8156      86.8760     105.4806       9.4804     311.0000       0.0260      -0.0094       8.4204     125.4324     305.8853       1.8256      47.4275       0.0817       0.1255       3.4268    2665.5605      54.2278      80.6875    2422.0000
  927.8112      49.4342      58.4186      67.0562      87.2407     109.8879       9.1002     311.0000       0.0187      -0.0169       8.3934     131.5022     306.4317       2.1052      47.4275       0.0859       0.1302       3.4344    2677.9644      52.1536      80.8125    2413.0000
  927.9636      50.3877      58.9158      66.5439      83.6806     110.8490       9.0213     311.0000       0.0194      -0.0162       8.2120     133.0772     305.8853      -0.8543      47.4275       0.0835       0.1281       3.4942    2676.7727      50.2851      79.6250    2454.0000
  928.1160      51.7698      60.6429      67.9593      82.7623     110.9488       9.0132     311.0000       0.0272      -0.0082       8.1987     135.6719     305.8853      -0.2358      47.4275       0.0917       0.1367       3.5971    2663.5435      50.8092      79.3750    2467.0000
  928.2684      54.8882      64.6346      72.0463      90.0624     119.3050       8.3819     311.0000       0.0288      -0.0065       8.3883     131.6120     306.4317      -2.1398      47.4275       0.0958       0.1410       3.6795    2660.7532      52.5182      78.3125    2429.0000
  928.4208      56.6224      67.8998      72.0344      91.7094     119.4295       8.3731     311.0000       0.0214      -0.0141       8.5161     129.0642     306.1585      -2.6135      47.4275       0.0818       0.1257       3.7204    2673.3296      64.7328      76.5625    2394.0000
  928.5732      59.9328      67.8454      73.4942      93.2210     119.3709       8.3772     311.0000       0.0046      -0.0316       8.3690     112.5642     305.8853      -4.7305      47.4275       0.0849       0.1287       3.7187    2702.1165      71.6452      76.3125    2447.0000
  928.7256      65.9106      79.1812      84.9161     108.9681     133.2910       7.5024     311.0000      -0.0072      -0.0439       8.2469     100.5733     305.8853      -6.7275      47.4275       0.0864       0.1301       3.7230    2722.3899      86.0656      76.3125    2498.0000
  928.8780      74.6532      96.5896     105.5319     139.6991     158.1178       6.3244     311.0000      -0.0309      -0.0684       8.2409      82.0952     306.4317      -5.6317      47.4275       0.0626       0.1037       3.6673    2762.8635     140.6297      76.3125    2465.0000
  929.0304      77.8939     107.5055     118.7926     153.5583     164.1299       6.0927     311.0000      -0.0429      -0.0808       8.3996      68.7228     305.8853       3.7076      47.4275       0.0483       0.0873       3.6342    2783.3823     281.7688      73.7500    2409.0000
  929.1828      74.7589     107.2008     117.9753     140.6467     146.4178       6.8298     311.0000      -0.0458      -0.0839       8.4199      62.4105     305.8853      20.9804      47.4275       0.0348       0.0717       3.6217    2788.3909     356.1980      73.8750    2467.0000
  929.3352      76.3707     104.3854     116.7413     141.5661     152.7996       6.5445     311.0000      -0.0313      -0.0689       8.3549      70.9810     305.8853      27.3392      47.4275       0.0311       0.0672       3.6660    2763.6033     203.3017      72.5000    2511.0000
  929.4876      76.4716     100.9792     114.9885     142.0396     145.3756       6.8787     311.0000      -0.0192      -0.0563       8.2696      84.1300     306.4317      17.8142      47.4275       0.0445       0.0823       3.6718    2742.9094     124.3346      69.3125    2517.0000
  929.6400      76.2363      98.4508     113.7908     140.2806     146.0123       6.8487     311.0000      -0.0108      -0.0476       8.2735      93.0955     306.4317       0.8307      47.4275       0.0668       0.1070       3.6538    2728.5095     107.9566      68.2500    2455.0000
  929.7924      80.3033     102.2709     121.0984     153.9850     168.4711       5.9357     311.0000      -0.0089      -0.0455       8.3522      97.3584     305.8853      -7.1712      47.4275       0.0588       0.0989       3.6507    2725.1433      92.6311      67.3125    2402.0000
  929.9448      82.7428     107.1949     127.3825     159.5472     180.9088       5.5276     311.0000      -0.0109      -0.0477       8.4065      89.7149     305.8853      -6.8538      47.4275       0.0594       0.0998       3.7102    2728.6343     105.8245      66.5625    2435.0000
  930.0972      85.0394     110.3718     126.0981     163.3929     192.8975       5.1841     311.0000      -0.0189      -0.0559       8.3429      85.4039     305.8853      -4.0190      47.4275       0.0627       0.1032       3.7145    2742.2400     123.7203      66.5625    2478.0000
  930.2496      84.5306     110.2520     130.0796     163.6071     200.8394       4.9791     311.0000      -0.0252      -0.0624       8.2668      75.3556     305.8853      -0.2501      47.4275       0.0499       0.0891       3.6469    2753.0081     150.1487      65.3750    2449.0000
  930.4020      89.5615     119.4614     146.2924     184.0760     238.6434       4.1904     311.0000      -0.0188      -0.0558       8.4014      81.7493     305.6122      -0.2117      47.4275       0.0500       0.0888       3.5745    2742.1357     103.5373      63.4375    2391.0000
  930.5544      95.5855     133.4262     161.8694     194.8007     268.8343       3.7198     311.0000      -0.0122      -0.0491       8.4724      83.6392     306.1585      -1.7958      47.4275       0.0534       0.0923       3.5440    2730.9368     101.3628      64.0000    2375.0000
  930.7068      98.4354     136.8812     158.1022     189.4933     248.7525       4.0201     311.0000      -0.0103      -0.0470       8.3517      84.2987     305.8853       0.2191      47.4275       0.0488       0.0874       3.5794    2727.5593     117.1133      61.7500    2425.0000
  930.8592     100.7111     140.2969     165.1231     197.9725     248.8159       4.0190     311.0000      -0.0151      -0.0520       8.2270      81.1606     305.3391       2.0185      47.4275       0.0575       0.0971       3.6492    2735.8098     185.0385      59.1250    2442.0000
  931.0116     104.9955     143.6094     168.6304     214.6399     258.6760       3.8658     311.0000      -0.0203      -0.0574       8.3500      82.0281     305.3391      12.5649      47.4275       0.0473       0.0860       3.7296    2744.7881     226.0533      57.3125    2426.0000
  931.1640     104.9118     144.6660     169.7395     232.3159     260.7518       3.8351     311.0000      -0.0256      -0.0629       8.4932      79.0344     306.4317       8.7264      47.4275       0.0522       0.0913       3.7890    2753.8210     338.5569      56.8125    2412.0000
  931.3164     103.7671     140.3457     171.4240     237.9259     253.8291       3.9397     311.0000      -0.0301      -0.0675       8.4586      71.6914     305.8853       7.0019      47.4275       0.0594       0.0988       3.8258    2761.4207     321.0066      56.8125    2431.0000
  931.4688     107.6296     150.6776     184.0399     256.4527     264.9897       3.7737     311.0000      -0.0278      -0.0651       8.3282      60.1466     305.6122      -4.0545      47.4275       0.0451       0.0836       3.8696    2757.4670     378.2721      56.8125    2432.0000
  931.6212     106.1258     149.9818     188.3696     266.7057     265.5935       3.7652     311.0000      -0.0272      -0.0645       8.3040      56.6567     305.8853      -2.4521      47.4275       0.0434       0.0815       3.8735    2756.4282     369.2089      54.9375    2438.0000
  931.7736     102.4327     141.6089     175.1357     241.6593     237.2226       4.2154     311.0000      -0.0243      -0.0615       8.3508      57.2645     305.3391      -2.3298      47.4275       0.0481       0.0867       3.8883    2751.4922     343.2816      54.1250    2401.0000
  931.9260     101.4584     142.9694     170.9644     220.4774     225.8568       4.4276     311.0000      -0.0304      -0.0679       8.4123      57.6915     305.3391      -0.7601      47.4275       0.0569       0.0961       3.8578    2762.0527     257.8524      54.9375    2451.0000
  932.0784     101.2441     136.3693     161.4178     204.6348     208.5482       4.7951     311.0000      -0.0362      -0.0739       8.4516      56.7157     305.8853      -0.3793      47.4275       0.0496       0.0884       3.8338    2771.8699     312.2463      52.3125    2477.0000
  932.2308     100.0378     143.5247     157.6068     198.5123     208.9615       4.7856     311.0000      -0.0419      -0.0798       8.4089      60.1952     305.3391      -0.1988      47.4275       0.0476       0.0862       3.7744    2781.6838     277.9816      54.3125    2435.0000
  932.3832      94.5642     144.4874     158.8141     186.2456     204.0902       4.8998     311.0000      -0.0426      -0.0805       8.3201      65.3559     305.3391      -0.6533      47.4275       0.0476       0.0860       3.7225    2782.8879     228.8314      53.8125    2403.0000
  932.5356      94.7529     138.5096     154.2344     176.5550     201.3767       4.9658     311.0000      -0.0354      -0.0730       8.3531      66.5738     305.8853      -2.8553      47.4275       0.0496       0.0879       3.7378    2770.4631     221.8540      51.8750    2408.0000
  932.6880      99.6355     142.6069     161.8362     186.4739     214.4871       4.6623     311.0000      -0.0273      -0.0646       8.4528      61.0149     305.8853      -4.1637      47.4275       0.0415       0.0786       3.7887    2756.6538     180.2645      54.0625    2444.0000
  932.8404     112.5116     170.3017     199.5843     240.8790     288.8955       3.4615     311.0000      -0.0185      -0.0556       8.4864      65.6329     305.8853      -5.4338      47.4275       0.0385       0.0752       3.9163    2741.6863     203.7728      52.8750    2457.0000
  932.9928     133.8377     210.7379     252.6819     306.0224     376.5020       2.6560     311.0000      -0.0227      -0.0599       8.4216      70.2865     304.7927      -3.5522      47.4275       0.0485       0.0859       4.0130    2748.7966     228.4856      53.5000    2415.0000
  933.1452     142.4259     233.0927     302.5497     395.8548     491.3586       2.0352     311.0000      -0.0232      -0.0604       8.3243      75.2025     305.3391      -2.8653      47.4275       0.0416       0.0778       4.1891    2749.6709     531.3713      52.8750    2432.0000
  933.2976     155.2632     264.0959     365.1011     537.0854     669.4535       1.4938     311.0000      -0.0206      -0.0577       8.3236      69.1297     305.8853      -2.7421      47.4275       0.0213       0.0545       4.3249    2745.1755    1092.5430      52.4375    2422.0000
  933.4500     161.4919     301.2414     424.9037     721.5383     867.8195       1.1523     311.0000      -0.0208      -0.0580       8.4470      60.9922     305.8853      -1.1969      47.4275       0.0094       0.0406       4.3436    2745.6311    1298.0260      52.9375    2483.0000
  933.6024     160.3767     287.3218     429.0713     899.2654    1023.4778       0.9771     311.0000      -0.0318      -0.0694       8.4158      57.3801     305.3391       2.9986      47.4275       0.0220       0.0542       4.2047    2764.4487     373.3690      53.0625    2430.0000
  933.7548     164.0370     262.4211     441.6054    1081.3093    1115.0248       0.8968     311.0000      -0.0453      -0.0833       8.3292      52.9793     305.3391       6.3641      47.4275       0.0280       0.0615       4.0563    2787.4827     354.0194      50.7500    2381.0000
  933.9072     175.3152     331.7830     558.6573    1189.9955    1037.4702       0.9639     311.0000      -0.0354      -0.0730       8.4366      51.9974     305.6122       1.7989      47.4275       0.0247       0.0581       4.0814    2770.4619     379.1667      50.6250    2412.0000
  934.0596     180.2817     368.0528     657.8966    1182.3363    1074.5266       0.9306     311.0000      -0.0258      -0.0631       8.4748      50.3416     305.8853      -1.8804      47.4275       0.0193       0.0518       4.1419    2754.0469     987.9645      49.8125    2439.0000
  934.2120     169.2794     525.9932     796.9531    1165.5787    1041.3691       0.9603     311.0000      -0.0119      -0.0487       8.4121      49.6809     305.8853      -4.9188      47.4275       0.0214       0.0534       4.2770    2730.3728     775.3405      51.3125    2420.0000
  934.3644     187.7448     425.5702     825.3595    1355.6851    1047.8285       0.9544     311.0000      -0.0170      -0.0540       8.3937      47.2185     304.7927      -1.7142      47.4275       0.0098       0.0403       4.3131    2739.0217     829.2099      49.8125    2400.0000
  934.5168     185.9321     402.0092     554.3558     660.5617     626.6169       1.5959     311.0000      -0.0266      -0.0640       8.4288      45.4859     304.7927       5.1224      47.4275       0.0054       0.0352       4.3780    2755.5571    1148.2244      49.9375    2410.0000
  934.6692     172.0550     326.7947     530.4109     500.7907     492.0649       2.0323     311.0000      -0.0407      -0.0786       8.4535      45.4763     305.8853      15.6760      47.4275       0.0170       0.0479       4.3481    2779.6265    1466.9186      50.1250    2410.0000
  934.8216     167.6902     323.4711     604.7034     759.5567     745.7567       1.3409     311.0000      -0.0270      -0.0644       8.5226      53.5765     305.8853      13.5949      47.4275       0.0241       0.0559       4.4265    2756.2046    1223.7296      48.9375    2434.0000
  934.9740     174.3997     380.1633     597.8149     737.2061     702.2746       1.4239     311.0000      -0.0042      -0.0407       8.5592      54.4987     304.7927       6.3727      47.4275       0.0127       0.0436       4.4712    2717.1836    1212.2272      48.3125    2403.0000
  935.1264     174.4167     335.7701     442.9080     635.6763     642.3939       1.5567     311.0000       0.0084      -0.0277       8.4150      60.4961     303.7001      -2.3403      47.4275       0.0097       0.0401       4.4375    2695.6655    1128.6720      47.1875    2396.0000
  935.2788     166.9795     247.3034     398.4713     585.5835     550.1719       1.8176     311.0000       0.0021      -0.0342       8.3064      55.8733     304.2464      -3.3097      47.4275       0.0191       0.0503       4.3290    2706.3948     972.5622      48.3125    2439.0000
  935.4312     155.2743     270.6577     499.2679     792.3179     656.4957       1.5232     311.0000      -0.0129      -0.0497       8.4640      55.2947     304.7927      -2.1605      47.4275       0.0151       0.0464       4.1608    2731.9856     889.9443      47.6250    2419.0000
  935.5836     154.4248     305.6903     529.7164     789.2590     761.9550       1.3124     311.0000      -0.0084      -0.0451       8.5375      60.0358     305.8853      -4.0417      47.4275       0.0154       0.0465       4.1459    2724.4238     594.2297      47.5000    2411.0000
  935.7360     153.8307     269.1029     428.2764     799.0041     714.6566       1.3993     311.0000      -0.0058      -0.0424       8.4305      68.8366     305.3391      -1.4098      47.4275       0.0130       0.0440       4.1519    2719.9014     377.2652      47.5000    2393.0000
  935.8884     149.1054     245.9804     413.4700     886.9305     761.3306       1.3135     311.0000       0.0015      -0.0348       8.3047      77.1145     304.7927       1.2097      47.4275       0.0166       0.0479       4.2815    2707.4473     350.9848      47.2500    2396.0000
  936.0408     160.3663     248.3942     442.9526     871.1257     754.9639       1.3246     311.0000       0.0055      -0.0307       8.4092      70.9837     304.7927       2.2225      47.4275       0.0235       0.0555       4.4037    2700.6763     328.3647      47.3750    2431.0000
  936.1932     166.1693     262.3669     477.1816     831.8588     812.1198       1.2313     311.0000       0.0108      -0.0252       8.5157      63.3656     305.3391       0.1888      47.4275       0.0173       0.0484       4.5995    2691.5750     559.2351      48.4375    2436.0000
  936.3456     167.9185     287.4222     538.3376     813.3048     893.4097       1.1193     311.0000       0.0189      -0.0168       8.4973      57.7266     305.3391      -4.8876      47.4275       0.0071       0.0369       4.7890    2677.7642     604.5654      47.5000    2390.0000
  936.4980     173.9821     330.3249     615.7083     835.3978     946.0790       1.0570     311.0000       0.0236      -0.0119       8.3669      55.8736     305.0659      -2.4962      47.4275       0.0092       0.0386       4.9539    2669.5867     832.1599      49.0625    2401.0000
  936.6504     177.4243     348.5074     654.1671     802.6899     907.6696       1.1017     311.0000       0.0243      -0.0112       8.3716      52.2550     305.3391      -2.1071      47.4275       0.0084       0.0379       5.0196    2668.4888     842.1681      47.5625    2423.0000
  936.8028     180.0685     382.3573     700.0490     791.5253     853.9102       1.1711     311.0000       0.0247      -0.0107       8.4242      50.6623     305.8853      -1.5576      47.4275       0.0078       0.0371       4.9915    2667.7126    1214.7441      49.0625    2432.0000
  936.9552     161.4990     330.1272     593.7746     808.8248     732.6103       1.3650     311.0000       0.0222      -0.0133       8.3799      50.3734     306.9780      -3.7248      47.4275       0.0017       0.0307       4.8763    2671.9563     705.7460      49.3125    2436.0000
  937.1076     153.7296     294.9061     536.9559     805.2375     650.8243       1.5365     311.0000       0.0280      -0.0074       8.4018      53.7894     306.4317      -1.4873      47.4275       0.0110       0.0410       4.7288    2662.1401     256.3850      50.3750    2426.0000
  937.2600     151.6532     245.1206     473.5455     762.1033     577.0684       1.7329     311.0000       0.0417       0.0069       8.4892      59.3959     305.8853       1.1210      47.4275       0.0220       0.0533       4.6144    2638.6807     209.6794      50.1250    2439.0000
  937.4124     151.5917     244.7001     471.0990     737.3082     565.2330       1.7692     311.0000       0.0560       0.0217       8.3983      63.0084     305.8853       2.3093      47.4275       0.0190       0.0513       4.5497    2614.1907     212.2350      51.8750    2452.0000
  937.5648     154.1413     252.6214     501.3944     853.3917     653.7308       1.5297     311.0000       0.0556       0.0212       8.3070      65.4454     307.5243       8.2064      47.4275       0.0317       0.0656       4.5495    2614.9651     289.4786      50.6250    2405.0000
  937.7172     153.8926     285.8410     542.4575     919.2324     700.8877       1.4268     311.0000       0.0396       0.0047       8.4115      68.2863     309.1632      16.1858      47.4275       0.0227       0.0560       4.5570    2642.3235     277.9788      51.8125    2429.0000
  937.8696     142.8953     233.0841     469.5688     860.2097     661.7514       1.5111     311.0000       0.0239      -0.0116       8.4066      70.3415     309.1632      24.9143      47.4275       0.0232       0.0561       4.5728    2669.1648     181.3012      51.8750    2382.0000
  938.0220     139.2395     193.7825     387.2904     683.1180     513.2767       1.9483     311.0000       0.0224      -0.0131       8.3634      69.3228     309.1632      21.3726      47.4275       0.0225       0.0553       4.5617    2671.6340     161.3748      53.8125    2409.0000
  938.1744     146.8022     218.1052     448.7527     773.0671     582.4595       1.7169     311.0000       0.0225      -0.0131       8.4132      63.2801     309.7096      21.1406      47.4275       0.0190       0.0511       4.6064    2671.5562     179.7571      53.5000    2400.0000
  938.3268     159.0044     281.8330     587.7672     931.4103     726.6907       1.3761     311.0000       0.0138      -0.0220       8.4964      59.7542     311.3485      25.6755      47.4275       0.0197       0.0512       4.7158    2686.3613     288.6727      54.1250    2415.0000
  938.4792     166.7541     359.1477     706.4243    1066.5089     830.3649       1.2043     311.0000       0.0136      -0.0223       8.4265      56.9499     311.8948      22.4261      47.4275       0.0131       0.0425       4.8852    2686.7483     442.5417      54.2500    2401.0000
  938.6316     181.2860     413.5450     902.5165    1164.8594     982.0107       1.0183     311.0000       0.0173      -0.0185       8.3432      52.9239     311.8948      14.2217      47.4275       0.0010       0.0286       5.0465    2680.4812     629.7965      54.2500    2393.0000
  938.7840     175.1125     365.2870     849.2689    1099.9000     892.3857       1.1206     311.0000       0.0337      -0.0014       8.3410      43.6561     311.8948      -1.7290      47.4275      -0.0064       0.0199       5.2510    2652.2991    1128.7114      55.0000    2413.0000
  938.9364     175.0775     340.1157     981.7130    1156.8341     973.5610       1.0272     311.0000       0.0335      -0.0016       8.4503      36.5324     313.5338      -2.0876      47.4275      -0.0047       0.0214       5.3749    2652.6628    2118.3784      55.4375    2439.0000
  939.0888     178.1744     372.5390     972.8763    1128.9144     905.9307       1.1038     311.0000       0.0348      -0.0003       8.4429      32.1544     314.6264      -2.1715      47.4275      -0.0050       0.0209       5.4160    2650.5188    3615.0398      55.5000    2435.0000
  939.2412     185.6117     428.9769    1128.4713    1165.3167     947.9552       1.0549     311.0000       0.0327      -0.0025       8.4130      33.1675     314.6264      -0.3393      47.4275      -0.0083       0.0167       5.3673    2654.1499    1681.4548      55.8750    2395.0000
  939.3936     182.0819     380.9345    1133.8789    1145.1299     911.2426       1.0974     311.0000       0.0304      -0.0049       8.4166      34.6074     315.1727       0.9072      47.4275       0.0005       0.0262       5.3350    2658.0383    1787.5549      54.8125    2396.0000
  939.5460     178.0801     359.9811    1266.8322    1246.2369     959.8986       1.0418     311.0000       0.0219      -0.0137       8.3348      34.3530     315.1727       2.4364      47.4275      -0.0007       0.0249       5.2864    2672.6184    2191.9539      54.9375    2391.0000
  939.6984     177.7231     348.3079    1193.6313    1077.1893     791.1077       1.2641     311.0000       0.0156      -0.0202       8.3303      34.5010     315.1727       1.6606      47.4275      -0.0064       0.0191       5.2419    2683.3376    4504.8682      56.8125    2446.0000
  939.8508     176.8397     348.4743    1244.0760    1210.0461     939.8721       1.0640     311.0000       0.0117      -0.0242       8.3895      32.8771     315.7190       1.0269      47.4275      -0.0091       0.0163       5.2204    2689.9517    4513.9741      56.3750    2419.0000
  940.0032     187.7447     411.9747    1549.7711    1532.9895    1228.6606       0.8139     311.0000       0.0055      -0.0306       8.3996      34.8367     316.2654       8.7538      47.4275      -0.0078       0.0177       5.2575    2700.5139    4442.5776      56.1875    2392.0000
  940.1556     183.6497     399.2359    1614.6354    1663.4517    1291.6422       0.7742     311.0000       0.0014      -0.0350       8.3435      33.2154     316.2654      14.9939      47.4275      -0.0032       0.0227       5.2505    2707.6733    4070.5439      54.8125    2417.0000
  940.3080     175.7772     367.6482    1466.5824    1691.7944    1148.5049       0.8707     311.0000       0.0059      -0.0303       8.2852      36.4386     315.7190      14.6551      47.4275       0.0039       0.0307       5.2061    2699.9551    3060.8264      56.6875    2434.0000
  940.4604     168.9272     339.5683    1320.5441    1710.2429     992.4644       1.0076     311.0000       0.0194      -0.0163       8.2496      43.3217     316.2654       4.7345      47.4275      -0.0047       0.0214       5.1019    2676.8391     785.3915      56.8125    2422.0000
  940.6128     164.0834     323.5986    1244.9097    1706.6991    1084.8674       0.9218     311.0000       0.0239      -0.0115       8.3417      49.0498     316.2654      14.1554      47.4275      -0.0010       0.0256       5.0151    2669.0525     522.7476      56.8125    2413.0000
  940.7652     164.7276     342.6917    1150.8182    1644.0730    1053.8020       0.9489     311.0000       0.0225      -0.0130       8.4224      51.8617     315.1727      18.1797      47.4275       0.0055       0.0323       5.0352    2671.4758     456.9491      55.9375    2389.0000
  940.9176     158.5390     297.2997     978.8677    1556.3334     965.7231       1.0355     311.0000       0.0169      -0.0188       8.4355      46.5764     315.7190      18.9927      47.4275      -0.0051       0.0204       5.1274    2681.0483     835.3179      56.2500    2416.0000
  941.0700     164.7821     317.9906     843.1306    1370.7126     859.6688       1.1632     311.0000       0.0190      -0.0167       8.3928      42.5477     316.8116       2.8024      47.4275      -0.0101       0.0146       5.2851    2677.5266    2394.9158      56.8125    2458.0000
  941.2224     164.0406     303.9861     757.8482    1322.2432     813.2075       1.2297     311.0000       0.0160      -0.0198       8.4004      45.3271     317.3580      -1.0710      47.4275      -0.0157       0.0078       5.3198    2682.7000    4138.6909      56.8125    2449.0000
  941.3748     159.4143     324.1110     850.3601    1212.4866     878.1652       1.1387     311.0000       0.0168      -0.0190       8.3435      50.0221     316.8116      -0.8442      47.4275      -0.0123       0.0115       5.3197    2681.2800    1819.9838      57.8750    2442.0000
  941.5272     170.6055     394.9803    1075.7921    1393.8582     929.4910       1.0759     311.0000       0.0168      -0.0189       8.2337      53.2700     316.2654      -0.4659      47.4275      -0.0043       0.0204       5.3317    2681.2051    1556.7902      57.3125    2377.0000
  941.6796     181.8590     496.3588    1407.2076    1550.9911    1173.5765       0.8521     311.0000       0.0122      -0.0237       8.3402      47.0708     316.2654       1.3292      47.4275      -0.0002       0.0255       5.3453    2689.0576    1524.0494      58.0625    2405.0000
  941.8320     186.5700     531.3558    1718.2018    1086.1411     836.2912       1.1958     311.0000       0.0115      -0.0244       8.3605      39.2816     317.3580       1.1652      47.4275      -0.0052       0.0202       5.3914    2690.2568    3426.0623      60.3125    2457.0000
  941.9844     184.2542     492.2434    1371.4349    1477.8765    1146.2808       0.8724     311.0000       0.0077      -0.0283       8.4136      32.3632     317.3580       1.9453      47.4275      -0.0098       0.0151       5.3238    2696.7634    4276.3760      61.7500    2425.0000
  942.1368     190.2844     496.2721    1529.0468    1589.6730     931.3911       1.0737     311.0000       0.0096      -0.0264       8.4016      37.2099     316.2654       1.0898      47.4275      -0.0105       0.0140       5.2424    2693.5842    3653.4431      61.0000    2399.0000
  942.2892     194.9969     462.8139    1627.3088    1537.9142     922.4454       1.0841     311.0000       0.0075      -0.0286       8.2901      48.4086     315.9922       2.2461      47.4275      -0.0087       0.0161       5.1080    2697.1987    1762.1499      61.5000    2412.0000
  942.4416     193.8071     421.1682    1562.1069    1455.8182     904.3477       1.1058     311.0000       0.0079      -0.0282       8.2679      61.2138     316.2654       3.4060      47.4275      -0.0008       0.0246       5.0497    2696.5647    1247.0500      64.0000    2423.0000
  942.5940     191.0383     386.1459    1516.6256    1404.2632     838.6934       1.1923     311.0000       0.0066      -0.0295       8.4396      61.1766     315.7190       5.2171      47.4275      -0.0011       0.0247       5.0492    2698.7351    1197.2166      64.6250    2436.0000
  942.7464     175.4039     363.0089    1432.6129    1285.6779     780.6971       1.2809     311.0000       0.0067      -0.0295       8.4376      57.8529     315.9922       4.7240      47.4275      -0.0041       0.0213       5.0700    2698.6250    1525.2621      66.0625    2448.0000
  942.8988     168.0716     343.8980    1294.7990    1157.6260     693.5580       1.4418     311.0000       0.0038      -0.0324       8.3568      53.5901     315.7190       3.4583      47.4275      -0.0098       0.0153       5.0705    2703.5237    1830.4026      65.5000    2408.0000
  943.0512     169.5660     362.3738    1310.8047    1196.8601     699.6963       1.4292     311.0000       0.0081      -0.0280       8.2281      52.4277     315.7190      -1.0326      47.4275      -0.0027       0.0228       5.1008    2696.1382    2241.6482      65.3125    2429.0000
  943.2036     178.5176     370.5092    1365.1124    1281.2019     715.3206       1.3980     311.0000       0.0047      -0.0315       8.3151      50.3788     316.2654      -0.8123      47.4275      -0.0078       0.0168       5.1049    2701.9089    2865.3674      65.6250    2473.0000
  943.3560     182.9329     399.8001    1398.3635    1375.7206     745.1210       1.3421     311.0000       0.0069      -0.0292       8.4436      49.1305     317.3580      -0.4914      47.4275      -0.0164       0.0071       5.1682    2698.1321    4000.1028      66.5625    2417.0000
  943.5084     182.8793     428.0189    1430.6670    1462.8428     767.0061       1.3038     311.0000       0.0075      -0.0286       8.4210      52.1697     317.3580       1.3492      47.4275      -0.0092       0.0144       5.2045    2697.2502    3510.0420      66.9375    2441.0000
  943.6608     173.5774     427.9846    1326.9044    1432.7920     687.2168       1.4551     311.0000       0.0187      -0.0170       8.3600      52.5972     317.3580      -0.7527      47.4275      -0.0110       0.0130       5.2837    2678.0251    3273.2258      66.9375    2393.0000
  943.8132     164.2298     365.0533    1158.9559    1315.0184     637.2377       1.5693     311.0000       0.0228      -0.0127       8.2903      55.2665     317.3580      -0.9305      47.4275      -0.0055       0.0192       5.2682    2670.9741    2902.3188      67.0625    2415.0000
  943.9656     164.7504     350.8417    1137.2626    1182.3057     624.6439       1.6009     311.0000       0.0238      -0.0117       8.2893      53.2726     318.4506      -0.6278      47.4275      -0.0044       0.0205       5.1951    2669.2688    1728.2677      66.7500    2458.0000
  944.1180     169.7645     360.7022    1244.2498    1260.4335     679.2515       1.4722     311.0000       0.0181      -0.0176       8.2993      55.5888     317.3580       0.8416      47.4275      -0.0082       0.0169       5.0470    2679.0327    1245.8959      69.3125    2434.0000
  944.2704     167.8167     355.2759    1376.8455    1352.9099     706.7849       1.4149     311.0000       0.0155      -0.0203       8.2670      61.0696     317.3580       0.3567      47.4275      -0.0036       0.0217       4.9326    2683.5146     968.5137      70.5625    2408.0000
  944.4228     162.8042     362.1221    1496.9971    1444.2256     720.9381       1.3871     311.0000       0.0200      -0.0156       8.3980      65.3559     318.4506      -1.6863      47.4275      -0.0067       0.0187       4.9727    2675.7285    1102.6024      72.2500    2409.0000
  944.5752     160.5628     338.6207    1525.8363    1328.3663     642.7037       1.5559     311.0000       0.0176      -0.0181       8.3686      60.2853     318.9969      -1.0974      47.4275      -0.0020       0.0234       5.0613    2679.8772    1654.0231      74.2500    2439.0000
  944.7276     157.6760     303.8328    1413.3424    1324.8849     605.1245       1.6526     311.0000       0.0155      -0.0203       8.1792      52.9457     318.4506      -0.2666      47.4275      -0.0114       0.0135       5.1360    2683.4426    3330.9177      75.1875    2478.0000
  944.8800     156.0884     276.8502    1290.3048    1301.8179     503.9374       1.9844     311.0000       0.0097      -0.0263       8.1901      55.7773     319.5432       1.3499      47.4275      -0.0085       0.0166       5.0355    2693.3840    3333.0039      76.3125    2446.0000
  945.0324     149.8185     291.7812    1454.6155    1188.0476     565.1676       1.7694     311.0000       0.0159      -0.0199       8.4332      71.1758     320.0895      -0.4191      47.4275      -0.0035       0.0226       4.9178    2682.8367    1662.4615      76.3125    2410.0000
  945.1848     149.4310     300.4504    1627.7936    1421.4812     623.9495       1.6027     311.0000       0.0184      -0.0172       8.4394      80.7484     319.5432      -0.7234      47.4275       0.0108       0.0389       4.8333    2678.4624    1166.9667      76.3125    2414.0000
  945.3372     150.5124     323.4636    1744.4575    1571.5978     729.7179       1.3704     311.0000       0.0168      -0.0189       8.2733      75.3690     320.0895       0.3076      47.4275       0.0084       0.0369       4.8752    2681.2100    1217.5565      77.0625    2439.0000
  945.4896     150.0079     336.4664    1849.9993    1740.2825     891.4827       1.1217     311.0000       0.0040      -0.0323       8.1750      61.4183     320.6359       8.8911      47.4275      -0.0010       0.0262       5.0095    2703.2283    2224.7249      78.3125    2425.0000
  945.6420     149.1207     343.8791    1896.6342    1840.7478     879.1364       1.1375     311.0000      -0.0159      -0.0529       8.2264      50.5764     320.6359      24.6482      47.4275      -0.0020       0.0245       5.1253    2737.2549    2742.2581      78.0625    2436.0000
  945.7944     148.1122     342.3033    1884.6205    1897.1079     936.0439       1.0683     311.0000      -0.0190      -0.0560       8.2822      46.6051     320.6359      25.7359      47.4275      -0.0044       0.0214       5.1449    2742.4531    2741.5928      78.7500    2406.0000
  945.9468     146.5691     331.5931    1814.1597    1900.7109    1026.9928       0.9737     311.0000      -0.0105      -0.0473       8.2408      47.1527     321.7285      19.5379      47.4275      -0.0109       0.0142       5.0884    2728.0356    3302.9482      80.0625    2406.0000
  946.0992     145.1588     313.8218    1690.3519    1855.5472    1212.1354       0.8250     311.0000       0.0084      -0.0277       8.1870      46.9543     322.2748       4.3426      47.4275      -0.0045       0.0208       5.0001    2695.7161    2325.5151      82.4375    2399.0000
  946.2516     143.5616     282.5084    1495.0844    1759.5663    1140.5643       0.8768     311.0000       0.0150      -0.0208       8.1422      55.2334     322.2748       1.5666      47.4275      -0.0042       0.0213       4.9573    2684.3777    2179.1702      82.9375    2444.0000
  946.4040     138.6967     266.1804    1367.9193    1717.3605    1190.0326       0.8403     311.0000       0.0205      -0.0151       8.1686      61.8318     321.7285      -2.1992      47.4275      -0.0037       0.0218       4.9576    2674.8611    2027.5302      85.6250    2439.0000
  946.5564     132.5683     245.1127    1177.3807    1533.7472    1044.5931       0.9573     311.0000       0.0168      -0.0190       8.2447      65.1230     322.2748      -2.5775      47.4275      -0.0024       0.0237       4.9374    2681.3049    1916.2045      86.0625    2416.0000
  946.7088     138.4727     276.4736    1280.9481    1708.6107    1155.3236       0.8656     311.0000       0.0092      -0.0269       8.3144      61.7158     323.0943      -0.6042      47.4275      -0.0010       0.0252       4.9243    2694.3228    2207.6401      86.0625    2452.0000
  946.8612     143.3887     297.3491    1453.9912    1772.6528    1242.8671       0.8046     311.0000       0.0027      -0.0335       8.1882      57.0343     322.2748       2.6584      47.4275      -0.0029       0.0235       4.9430    2705.3171    1930.5924      86.6250    2449.0000
  947.0136     148.5254     329.9753    1740.0740    1913.9988    1531.1125       0.6531     311.0000      -0.0055      -0.0421       8.1288      52.8068     321.7285      15.4881      47.4275      -0.0017       0.0243       5.0593    2719.4348    2522.6519      89.1875    2419.0000
  947.1660     149.4161     326.9261    1645.3965    1908.4769    1257.4413       0.7953     311.0000      -0.0100      -0.0467       8.2204      49.3252     322.5479      24.9870      47.4275      -0.0062       0.0191       5.1782    2727.0745    2518.8879      90.3750    2425.0000
  947.3184     144.6824     303.5807    1607.9244    1892.4192     991.6104       1.0085     311.0000      -0.0049      -0.0414       8.1945      49.5568     322.8211      23.4652      47.4275      -0.0121       0.0125       5.2488    2718.3494    3216.8423      92.6875    2425.0000
  947.4708     141.9673     279.4519    1360.8744    1844.3782     716.5059       1.3957     311.0000       0.0103      -0.0257       8.2914      57.8366     322.8211       8.7144      47.4275      -0.0047       0.0200       5.2466    2692.3865    2783.8872      94.6250    2436.0000
  947.6232     145.6049     285.4749    1449.7072    1692.3112     802.9023       1.2455     311.0000       0.0216      -0.0140       8.3396      65.3328     322.8211      -3.4454      47.4275      -0.0062       0.0184       5.2044    2673.1204    2672.1028      95.5625    2454.0000
  947.7756     150.9978     298.8199    1414.1898    1571.4651     783.2469       1.2767     311.0000       0.0244      -0.0111       8.2238      70.5090     323.3674      -4.9102      47.4275      -0.0120       0.0122       5.1945    2668.3499    2894.5737      95.8750    2420.0000
  947.9280     155.3137     305.9120    1248.9966    1335.6265     618.8126       1.6160     311.0000       0.0256      -0.0098       8.2227      75.8297     323.3674      -4.2362      47.4275      -0.0058       0.0193       5.1997    2666.1956    3326.5715      96.9375    2394.0000
  948.0804     147.8801     282.3471    1005.5601    1033.6113     471.3711       2.1215     311.0000       0.0197      -0.0159       8.2117      75.5470     323.9137      -1.7226      47.4275      -0.0049       0.0202       5.1479    2676.2505    3580.6899      98.7500    2412.0000
  948.2328     140.2023     267.3461     834.1361     832.4218     370.2893       2.7006     311.0000       0.0126      -0.0233       8.2094      72.3435     325.0064      -0.5267      47.4275      -0.0076       0.0171       5.0408    2688.5215    4053.7151     100.6250    2438.0000
  948.3852     137.5584     253.5154     679.8049     748.5579     302.4640       3.3062     311.0000       0.0068      -0.0293       7.9741      66.3630     325.0064      -0.2031      47.4275      -0.0117       0.0129       4.9120    2698.2937    4150.0869     103.0000    2464.0000
  948.5376     129.8739     230.8368     573.4155     515.4039     256.5703       3.8976     311.0000       0.0117      -0.0243       8.0729      63.8490     325.5527      -1.5311      47.4275      -0.0030       0.0221       4.9055    2690.0466    3316.8569     105.6250    2417.0000
  948.6900     131.4567     300.7722     821.3817     698.9141     320.3592       3.1215     311.0000       0.0153      -0.0205       8.2123      60.5689     327.4648      -1.1656      47.4275      -0.0057       0.0195       4.9513    2683.8643    3264.6101     106.2500    2406.0000
  948.8424     136.3985     380.9857    1132.6637    1162.0574     505.2150       1.9794     311.0000       0.0204      -0.0152       8.2044      53.6203     328.2842      -0.7215      47.4275      -0.0099       0.0148       5.0461    2675.0342    3451.4238     107.8750    2422.0000
  948.9948     144.2054     355.4978    1572.0919    1550.8577     837.0205       1.1947     311.0000       0.0187      -0.0170       8.3297      48.3129     328.2842       6.9063      47.4275      -0.0031       0.0221       5.1083    2678.1045    4297.4492     111.6250    2480.0000
  949.1472     137.1551     302.6374    1159.8813    1339.2020     547.9346       1.8250     311.0000       0.0045      -0.0317       8.1625      44.8943     329.1037      27.6184      47.4275      -0.0025       0.0224       5.2039    2702.2324    2028.4192     113.9375    2538.0000
  949.2996     139.9416     270.0681    1148.6588    1541.2728     490.5547       2.0385     311.0000      -0.0074      -0.0441       8.0789      41.4200     329.3769      44.2364      47.4275      -0.0108       0.0131       5.2708    2722.6899    2045.5148     115.3750    2572.0000
  949.4520     142.3508     259.9521    1385.3083    1776.0819     832.3123       1.2015     311.0000      -0.0047      -0.0413       8.1497      38.2017     329.3769      38.8100      47.4275      -0.0157       0.0074       5.2783    2718.0962    2139.7830     116.3750    2393.0000
  949.6044     139.8392     255.3810    1403.8519    1912.5168    1065.9224       0.9382     311.0000      -0.0043      -0.0408       8.1284      38.2954     329.9232      32.9905      47.4275      -0.0160       0.0070       5.2527    2717.3813    4461.3530     117.6875    2415.0000
  949.7568     132.2213     258.6615    1415.1100    1950.0000    1352.8054       0.7392     311.0000      -0.0006      -0.0369       8.1453      41.3013     329.9232      18.8537      47.4275      -0.0069       0.0167       5.1636    2710.9456    4402.4102     121.9375    2472.0000
  949.9092     125.9845     249.2038    1234.7268    1902.3584    1502.6130       0.6655     311.0000      -0.0083      -0.0449       8.1743      43.5065     329.3769      17.8888      47.4275      -0.0119       0.0118       5.0811    2724.1589    3884.1758     125.1250    2399.0000
  950.0616     113.9900     225.6535     992.6807    1716.4205    1472.1863       0.6793     311.0000      -0.0020      -0.0384       8.0225      45.5911     329.9232       4.6070      47.4275      -0.0157       0.0081       4.9796    2713.3782    3533.7861     125.8750    2429.0000
  950.2140     113.8434     238.5325     853.1578    1555.5392    1339.9666       0.7463     311.0000      -0.0029      -0.0394       8.2438      48.3999     330.4695       4.3104      47.4275      -0.0081       0.0172       4.9350    2714.9639    3271.7007     130.6875    2426.0000
  950.3664     113.6973     256.6683     747.9700    1352.2517    1126.9192       0.8874     311.0000       0.0000      -0.0363       8.1375      53.1069     328.8306       8.3654      47.4275       0.0000       0.0271       4.9568    2709.9543    3498.4011     133.6250    2402.0000
  950.5188     120.1671     248.8982     645.8432    1154.2495     909.7892       1.0992     311.0000      -0.0063      -0.0429       8.1335      64.2753     328.2842      23.5901      47.4275       0.0032       0.0327       4.9655    2720.7668    2406.2666     134.9375    2462.0000
  950.6712     104.1943     170.3837     387.5482     902.1460     675.2950       1.4808     311.0000      -0.0064      -0.0430       8.2147      80.9277     328.8306      29.8212      47.4275       0.0385       0.0731       4.9684    2720.8711     339.2748     138.4375    2479.0000
  950.8236      90.7103     127.5500     243.6709     571.5716     375.6473       2.6621     311.0000      -0.0138      -0.0506       8.1245      89.6459     328.8306      31.8537      47.4275       0.0840       0.1232       5.0106    2733.5149     180.6171     142.0000    2433.0000
  950.9760     115.5898     146.6086     299.3596     716.4943     473.7608       2.1108     311.0000      -0.0038      -0.0403       7.8760      88.6818     329.3769      13.7460      47.4275       0.0398       0.0745       5.2669    2716.4980     194.5367     144.4375    2440.0000
  951.1284     151.7372     242.5624     420.0536     568.3378     501.2963       1.9948     311.0000      -0.0111      -0.0478       8.0228      70.1522     328.8306       6.4180      47.4275      -0.0072       0.0204       5.5051    2728.9199     402.0180     144.8125    2460.0000
  951.2808     182.2597     304.9051     305.5039     392.7810     362.7816       2.7565     311.0000      -0.0139      -0.0508       8.2361      59.3936     327.7379      -3.1595      47.4275      -0.0200       0.0050       5.5018    2733.7673    4486.2593     150.2500    2463.0000
  951.4332     156.6754     280.9632     224.6444     256.1895     241.8942       4.1340     311.0000      -0.0169      -0.0539       8.2168      56.6012     327.7379      -0.7598      47.4275      -0.0166       0.0088       5.0945    2738.9629    4595.7363     153.6250    2438.0000
  951.5856     101.9513     147.9921     194.3018     203.6771     185.8591       5.3804     311.0000      -0.0055      -0.0420       8.0568      81.9815     328.0111       1.0242      47.4275       0.0103       0.0399       4.5409    2719.3704     358.1440     154.4375    2414.0000
  951.7380      67.5363      79.5567      95.9110     100.1764      92.6970      10.7878     311.0000       0.0208      -0.0148       8.1549     124.9028     329.3769       1.7476      47.4275       0.0342       0.0682       4.0756    2674.4321     135.9737     157.4375    2423.0000
  951.8904      50.3579      54.1598      60.5095      61.8521      59.1738      16.8994     311.0000       0.0431       0.0083       8.0893     158.3775     329.9232      -1.8659      47.4275       0.0607       0.0990       3.7712    2636.3472      77.0939     161.4375    2434.0000
  952.0428      45.5378      46.0644      52.9395      56.0374      51.2424      19.5151     311.0000       0.0556       0.0212       8.1805     179.6519     329.9232      -4.7188      47.4275       0.0597       0.1006       3.6330    2614.9404      63.9772     164.1875    2409.0000
  952.1952      41.1904      45.2479      50.9067      55.2753      49.5895      20.1656     311.0000       0.0520       0.0175       8.0749     173.6752     330.4695      -1.8044      47.4275       0.0984       0.1439       3.5779    2621.0996      60.0215     165.4375    2425.0000
  952.3476      45.1831      54.0713      62.7624      71.7674      60.8961      16.4214     311.0000       0.0514       0.0169       8.2037     172.1639     332.9279       2.5961      47.4275       0.1004       0.1465       3.6153    2622.0784      57.1927     167.5625    2432.0000
  952.5000      47.3829      55.2797      70.1648      85.5512      69.7569      14.3355     311.0000       0.0469       0.0122       8.0472     172.2808     334.2937      17.0481      47.4275       0.1158       0.1632       3.7362    2629.8762      59.0715     169.5000    2429.0000
  952.6524      48.0186      52.3733      65.5768      86.6700      69.0207      14.4884     311.0000       0.0343      -0.0009       7.7286     173.6992     334.2937      34.2484      47.4275       0.1229       0.1709       3.8602    2651.4231      55.0617     172.5000    2452.0000
  952.8048      49.8480      49.5687      65.6181      89.2217      70.2208      14.2408     311.0000       0.0182      -0.0175       8.0532     167.4662     333.7474      41.7316      47.4275       0.1155       0.1632       3.9148    2678.8296      59.3974     173.3125    2479.0000
  952.9572      50.9221      51.6097      74.9846     111.1178      90.8052      11.0126     311.0000       0.0237      -0.0118       8.1736     163.0945     343.5811      28.0247      47.4275       0.1133       0.1608       3.8514    2669.5078      59.5611     174.0000    2497.0000
  953.1096      52.9609      56.2903      79.9932     128.6948     108.8135       9.1900     311.0000       0.0378       0.0028       8.0841     176.9917     338.6642      10.6530      47.4275       0.0996       0.1454       3.7424    2645.4021      55.9708     174.0000    2458.0000
  953.2620      47.2640      56.2040      81.4618     146.9761     128.3041       7.7940     311.0000       0.0545       0.0201       8.0032     187.8410     339.7569       0.0536      47.4275       0.0832       0.1270       3.6581    2616.8042      53.5429     174.0000    2439.0000
  953.4144      47.5414      55.7951      83.8583     170.0565     157.0129       6.3689     311.0000       0.0583       0.0241       8.1015     188.6484     339.2105       5.9216      47.4275       0.0653       0.1071       3.6279    2610.2380      54.0555     174.3750    2400.0000
  953.5668      48.9434      64.0962      95.0303     214.2247     187.3539       5.3375     311.0000       0.0665       0.0326       8.0776     185.1853     338.6642       3.4063      47.4275       0.0674       0.1095       3.6674    2596.2712      55.0750     174.4375    2427.0000
  953.7192      51.1039      69.3620     110.5274     261.7866     214.6816       4.6581     311.0000       0.0694       0.0356       8.1724     182.0498     338.1179       3.7510      47.4275       0.0727       0.1149       3.6996    2591.2800      53.6524     175.1875    2415.0000
  953.8716      47.4923      61.3811      96.5118     278.2267     197.3180       5.0680     311.0000       0.0616       0.0274       8.1373     187.2510     338.9374       3.8860      47.4275       0.0735       0.1157       3.7143    2604.7344      56.2385     174.7500    2425.0000
  954.0240      44.4523      55.9328      86.6668     277.4554     165.4763       6.0432     311.0000       0.0431       0.0083       7.9207     183.1123     338.6642      17.7381      47.4275       0.0650       0.1064       3.7023    2636.2588      61.6021     176.1875    2417.0000
  954.1764      46.6790      54.0196      87.3380     275.8534     164.3887       6.0831     311.0000       0.0310      -0.0043       7.8617     183.4113     338.6642      22.4304      47.4275       0.0602       0.1011       3.6817    2657.0610      69.4539     177.6250    2429.0000
  954.3288      48.5079      60.6706     100.5024     337.2136     206.0000       4.8544     311.0000       0.0310      -0.0043       7.9926     174.3781     338.6642      16.9342      47.4275       0.0603       0.1008       3.7014    2657.0476      75.0747     177.8125    2416.0000
  954.4812      53.0244      68.4993     121.7928     450.3872     276.7992       3.6127     311.0000       0.0378       0.0028       8.1485     151.3667     339.2105       4.5269      47.4275       0.0693       0.1097       3.8229    2645.4453     103.5964     176.1250    2434.0000
  954.6336      62.5425      86.9687     169.2287     605.5176     353.2506       2.8309     311.0000       0.0203      -0.0153       8.0804     122.5480     339.7569      13.9377      47.4275       0.0513       0.0890       3.9817    2675.2856     161.1150     177.2500    2468.0000
  954.7860      74.1000     108.3686     233.9897     844.5276     414.8000       2.4108     311.0000      -0.0011      -0.0375       7.9570      87.4812     341.9421      25.4498      47.4275       0.0166       0.0496       4.1178    2711.8159     304.3660     179.0000    2439.0000
  954.9384      82.8385     130.9887     226.1366    1100.1370     377.8465       2.6466     311.0000      -0.0202      -0.0573       7.8319      63.1953     342.4884      40.5209      47.4275       0.0105       0.0409       4.1226    2744.5999     340.2690     176.1875    2436.0000
  955.0908      74.2920     105.6853     206.7770    1275.2438     281.7087       3.5498     311.0000      -0.0173      -0.0543       7.7873      48.0796     342.7616      38.7249      47.4275       0.0044       0.0335       4.0645    2739.5186     303.2764     176.8125    2432.0000
  955.2432      64.5219      85.8923     173.2741    1277.6677     202.7995       4.9310     311.0000       0.0021      -0.0342       7.8628      41.6214     344.6737      27.0984      47.7071       0.0029       0.0315       3.9397    2706.4438     240.3445     178.0625    2425.0000
  955.3956      54.8121      67.3454     123.3011    1242.0682     132.8251       7.5287     311.0000       0.0214      -0.0142       7.8551      37.5414     345.7664      12.6405      47.4275       0.0082       0.0382       3.8574    2673.4802     198.8610     178.7500    2430.0000
  955.5480      53.4922      66.5395     112.2337    1040.7096      96.1329      10.4023     311.0000       0.0313      -0.0040       8.1006      35.0164     346.3127       2.4178      47.4275       0.0211       0.0528       3.7608    2656.5459     172.7990     179.5625    2434.0000
  955.7004      64.7230      86.4511     155.6553    1178.8229     117.7980       8.4891     311.0000       0.0265      -0.0089       8.0110      34.3831     347.4053       2.7618      47.4275       0.0224       0.0553       3.6851    2664.7585     157.6219     182.8125    2451.0000
  955.8528      73.2987      97.9233     206.2728    1270.8822     125.9548       7.9394     311.0000       0.0172      -0.0186       8.0324      36.4093     348.2248       5.1928      47.4275       0.0297       0.0640       3.5876    2680.6096     125.6633     183.7500    2479.0000
  956.0052      77.9107     129.9398     187.1255    1313.3875     132.0914       7.5705     311.0000       0.0133      -0.0226       7.8772      38.4710     349.5905       6.5761      47.7071       0.0311       0.0654       3.5412    2687.2781     101.4274     186.5000    2471.0000
  956.1576      67.6483      82.5555     158.3710    1292.4641      82.9946      12.0490     311.0000       0.0064      -0.0297       7.8704      40.1193     351.2295       9.3453      47.4275       0.0252       0.0587       3.6051    2699.0369      94.7849     189.4375    2451.0000
  956.3100      59.7316      68.6725     135.0369    1152.7839      67.6322      14.7859     311.0000       0.0009      -0.0354       7.6220      39.1672     351.7758      10.8507      47.4275       0.0228       0.0547       3.7422    2708.3809     104.2313     190.8125    2458.0000
  956.4624      61.6038      57.5938     118.4933     926.6954      56.9112      17.5712     311.0000      -0.0111      -0.0478       7.7561      38.2017     352.3221      16.6569      47.7071       0.0071       0.0372       3.9347    2728.8982     176.1062     192.7500    2458.0000
  956.6148      55.3089      51.4864     121.1600     605.4138      56.9614      17.5557     311.0000      -0.0149      -0.0518       7.8944      34.5479     354.2342      24.3676      47.7071       0.0069       0.0367       4.0460    2735.4346     191.9926     192.8125    2441.0000
  956.7672      50.8524      60.1875     121.6684     447.7378      55.3619      18.0630     311.0000      -0.0073      -0.0439       7.8420      37.0940     357.7852      26.3152      47.4275       0.0131       0.0441       4.0939    2722.4458     168.4120     193.5000    2435.0000
  956.9196      46.4751      60.2981      96.9612     275.6586      56.7910      17.6084     311.0000      -0.0008      -0.0371       7.6605      34.6050     357.7852      29.7220      47.4275       0.0194       0.0518       4.0394    2711.2957      85.5315     196.2500    2435.0000
  957.0720      49.1827      49.1588      75.5251     175.7217      48.5566      20.5945     311.0000       0.0127      -0.0232       7.6154      33.9767     358.3316      19.7270      47.4275       0.0327       0.0673       3.9074    2688.3342      74.6031     199.5000    2471.0000
  957.2244      40.2097      29.5404      53.7981     116.4138      38.8210      25.7592     311.0000       0.0138      -0.0221       7.8599      30.5041     361.0632      14.5872      47.4275       0.0418       0.0781       3.7158    2686.4031      62.6128     202.1250    2455.0000
  957.3768      27.8834      20.4435      36.4023      66.5107      31.6845      31.5612     311.0000       0.0239      -0.0116       7.8128      29.3392     364.8874       2.3282      47.7071       0.0388       0.0758       3.4829    2669.1047      59.2778     203.2500    2448.0000
  957.5292      22.2735      17.6239      29.6182      53.1266      36.3891      27.4808     311.0000       0.0255      -0.0099       7.7950      27.3286     365.9800      -0.1745      47.4275       0.0388       0.0767       3.2914    2666.3184      43.3727     204.6875    2478.0000
  957.6816      22.7306      26.9473      37.7725      57.6143      33.3434      29.9909     311.0000       0.0407       0.0059       7.7635      24.5492     367.6189       2.1477      47.4275       0.0566       0.0973       3.2828    2640.3364      32.0821     205.9375    2439.0000
  957.8340      18.2233      18.5839      27.5584      42.3402      34.8245      28.7154     311.0000       0.0958       0.0630       8.0554      22.9252     372.5358      13.8679      47.7071       0.0731       0.1167       3.6508    2546.1309      25.0543     209.8750    2383.0000
  957.9864       8.8319      10.7333      14.5573      22.6417      21.2191      47.1273     311.0000       0.2042       0.1753       7.9949      22.5045     378.5452      35.1884      47.4275       0.1146       0.1625       4.2846    2360.8091       7.2755     211.0000    2410.0000
  958.1388       5.0125       4.9116       6.0462      10.9130       9.8574     101.4470     311.0000       0.3201       0.2954       7.4803      23.4309     374.7210      60.7409      47.7071       0.2797       0.3332       4.8706    2162.6611       3.0074     213.0625    2442.0000
  958.2912       3.8165       3.3007       4.0375       5.4686       5.8649     170.5053     311.0000       0.3596       0.3363       7.4687      24.2293     380.1841      86.6804      47.7071       0.3814       0.4308       5.0106    2095.1492       2.1104     213.4375    2472.0000
  958.4436       3.4470       3.1438       3.8147       5.2713       6.2522     159.9443     311.0000       0.3364       0.3122       7.9231      23.8381     414.0557      99.4210      47.7071       0.3795       0.4243       4.8169    2134.8167       2.0668     215.5000    2464.0000
  958.5960       3.4130       3.2696       3.9012       5.4948       7.8762     126.9655     311.0000       0.2870       0.2610       7.9446      25.4594     398.2126     105.1507      47.7071       0.3491       0.3907       4.4841    2219.2942       2.2363     217.9375    2431.0000
  958.7484       3.5724       3.5868       4.1723       6.2391       9.1792     108.9414     311.0000       0.2626       0.2358       7.8169      26.4880     403.1294     102.8109      47.7071       0.3644       0.4066       4.2412    2260.9990       2.3303     219.4375    2479.0000
  958.9008       3.4253       3.4105       3.8515       5.6750       8.8849     112.5510     311.0000       0.2418       0.2143       7.5573      29.1686     413.7825      94.7969      47.4275       0.3728       0.4157       4.0072    2296.4824       2.3739     220.1250    2486.0000
  959.0532       3.2187       3.0867       3.5458       5.0239       7.6636     130.4868     311.0000       0.2276       0.1995       7.8532      26.2278     397.6663      74.9869      47.4275       0.3672       0.4101       3.7550    2320.7573       2.5240     220.7500    2473.0000
  959.2056       3.1513       2.9723       3.2877       4.6360       6.6855     149.5771     311.0000       0.2396       0.2119       7.5997      24.5913     409.6852      49.5262      47.7071       0.3140       0.3592       3.6130    2300.2830       2.6366     220.8125    2462.0000
  959.3580       2.9474       2.7954       3.0251       4.0564       5.6074     178.3372     311.0000       0.2781       0.2519       7.6953      23.4526     440.0056      36.3898      47.7071       0.3063       0.3532       3.7732    2234.4329       2.5715     219.7500    2426.0000
  959.5104       2.8639       2.8900       3.1874       4.4259       5.9281     168.6888     311.0000       0.3315       0.3072       7.6930      25.2617     379.0916      42.0108      47.7071       0.3565       0.3999       4.2264    2143.1133       2.2483     220.1250    2439.0000
  959.6628       2.8036       2.9895       3.1690       4.3351       5.8029     172.3289     311.0000       0.3668       0.3438       7.7964      27.1454     410.7778      68.4507      47.7071       0.3945       0.4363       4.7890    2082.7178       2.1559     220.9375    2474.0000
  959.8152       2.8466       2.8657       3.0943       4.2248       5.5683     179.5889     311.0000       0.3635       0.3403       7.7036      26.4000     437.2741      99.7258      47.7071       0.3324       0.3770       5.1418    2088.4854       2.0160     221.0625    2515.0000
  959.9676       3.1879       2.8427       3.0783       4.1666       5.3835     185.7524     311.0000       0.3247       0.3002       7.8133      25.4654     451.7514     129.7405      47.7071       0.3612       0.4061       5.1981    2154.7488       2.0285     221.4375    2496.0000
  960.1200       3.2440       2.9334       3.0912       4.1446       5.3691     186.2509     311.0000       0.2852       0.2592       8.0844      25.6079     517.3092     139.5218      47.7071       0.3507       0.3973       5.0645    2222.3052       2.0904     219.6250    2457.0000
  960.2724       3.3320       3.2241       3.4425       4.8746       6.3562     157.3269     311.0000       0.2608       0.2339       7.6942      26.2324     401.2173     143.1553      47.7071       0.3288       0.3738       4.9599    2264.1094       2.2563     219.4375    2481.0000
  960.4248       3.4130       3.6555       3.9192       5.6632       7.8191     127.8922     311.0000       0.2577       0.2307       7.7456      26.4457     423.8894     139.8809      47.7071       0.3150       0.3613       4.9269    2269.3469       2.3763     218.0000    2506.0000
  960.5772       3.8112       3.9828       4.3655       6.5873       9.9730     100.2707     311.0000       0.2582       0.2312       7.8761      25.2440     447.3809     129.3616      47.7071       0.3469       0.3924       4.8109    2268.5303       2.3850     217.8125    2521.0000
  960.7296       3.9208       3.8640       4.1656       6.3125       8.9106     112.2265     311.0000       0.2650       0.2383       7.7951      23.2012     449.0199     109.6313      47.7071       0.2872       0.3352       4.5997    2256.8003       2.2789     216.0000    2532.0000
  960.8820       4.0411       3.7230       4.0076       5.9161       7.5951     131.6645     311.0000       0.2527       0.2255       7.7126      21.5799     445.1956      87.6389      47.7071       0.3326       0.3805       4.3291    2277.9258       2.3623     216.3750    2513.0000
  961.0344       4.4394       4.2565       4.7477       7.5671      10.1228      98.7864     311.0000       0.2233       0.1950       7.7728      19.9449     462.4046      83.6272      47.7071       0.3163       0.3653       4.1416    2328.1936       2.6160     214.8125    2483.0000
  961.1868       4.9098       4.8777       5.3728       9.0981      13.0434      76.6674     311.0000       0.1950       0.1657       7.7390      18.5369     451.7514      83.9102      47.7071       0.2310       0.2822       4.0548    2376.5344       3.1859     213.8125    2508.0000
  961.3392       5.1295       5.0226       5.4932       9.9850      14.9201      67.0235     311.0000       0.1980       0.1688       7.6001      18.3053     447.9272      91.0397      47.7071       0.1876       0.2383       4.1235    2371.4751       3.3696     213.0625    2495.0000
  961.4916       5.5933       5.1822       6.0252      10.7408      15.0596      66.4030     311.0000       0.2069       0.1781       7.8473      18.7223     458.8535      99.8864      47.7071       0.2145       0.2663       4.2702    2356.1333       3.1718     213.0625    2556.0000
  961.6440       6.1753       5.8275       6.8094      12.5852      16.5523      60.4144     311.0000       0.1940       0.1647       7.8275      19.0320     461.0388     115.8011      47.7071       0.2101       0.2619       4.3766    2378.3218       3.5523     211.3750    2527.0000
  961.7964       6.6171       7.0716       8.2340      16.7731      21.0410      47.5262     311.0000       0.1619       0.1314       7.7004      18.5791     499.2808     118.2628      47.7071       0.1740       0.2250       4.3321    2433.1311       3.9292     210.3750    2495.0000
  961.9488       5.0805       5.9502       6.8656      11.0956      12.7471      78.4495     311.0000       0.1500       0.1191       7.5005      19.4666     429.3525     102.3052      47.7071       0.1857       0.2372       4.1966    2453.4795       3.8503     209.3750    2520.0000
  962.1012       4.5425       4.6841       5.3724       7.5814       8.3007     120.4711     311.0000       0.1587       0.1281       7.6692      21.5928     440.8251      80.6785      47.7071       0.2002       0.2520       4.1059    2438.6624       3.3154     208.2500    2521.0000
  962.2536       4.5650       4.2004       4.7548       6.3942       6.7957     147.1516     311.0000       0.1750       0.1450       7.7926      23.6670     447.9272      75.0964      47.7071       0.2021       0.2537       4.1815    2410.7573       3.2650     207.8750    2491.0000
  962.4060       4.5814       4.4738       4.7902       6.0044       6.4233     155.6825     311.0000       0.1742       0.1441       7.8439      23.5782     416.7873      89.1085      47.7071       0.2489       0.3009       4.3556    2412.1553       3.0267     206.7500    2470.0000
  962.5584       5.1653       5.0975       5.5500       7.6427       8.0979     123.4886     311.0000       0.1599       0.1294       7.8044      25.5895     438.0936     101.3684      47.7071       0.2054       0.2571       4.4968    2436.5652       3.3495     205.9375    2454.0000
  962.7108       5.5188       5.2287       6.1045       9.2498       9.9173     100.8340     311.0000       0.1475       0.1165       7.7604      25.9513     463.7703      92.8128      47.7071       0.1610       0.2115       4.4700    2457.7483       3.4232     204.8750    2442.0000
  962.8632       5.0289       4.9237       5.8480       8.3069       8.9947     111.1771     311.0000       0.1333       0.1018       8.0938      23.4922     450.6588      74.8875      47.7071       0.1695       0.2204       4.3096    2482.0791       2.9346     205.0000    2498.0000
  963.0156       5.1977       4.9032       5.4887       7.7410       8.5465     117.0074     311.0000       0.1406       0.1094       7.6868      20.6689     466.5019      47.3495      47.7071       0.1991       0.2510       4.0448    2469.5137       2.6899     203.6250    2494.0000
  963.1680       5.6339       5.4391       6.2873       9.5451      10.7751      92.8068     311.0000       0.1555       0.1248       7.6525      17.9910     468.9603      39.9528      47.7071       0.1630       0.2136       3.8521    2444.0461       2.9154     203.2500    2473.0000
  963.3204       5.5984       5.9409       7.0802      11.3130      13.3891      74.6877     311.0000       0.1888       0.1593       7.7032      20.4633     424.9820      47.5969      47.7071       0.2034       0.2545       3.8507    2387.2178       3.3806     203.2500    2444.0000
  963.4728       5.9780       5.6615       6.8055      11.2038      14.4623      69.1451     311.0000       0.2136       0.1850       7.8603      22.8550     432.0841      83.6642      47.7071       0.2648       0.3163       4.0849    2344.8262       3.1156     203.2500    2403.0000
  963.6252       6.1640       5.3199       6.5389      10.7953      13.8916      71.9861     311.0000       0.2126       0.1840       7.7577      24.7209     432.6304     124.9773      47.7071       0.3276       0.3757       4.3456    2346.4272       2.8301     203.2500    2411.0000
  963.7776       6.0574       5.6877       6.8788      11.2534      14.5444      68.7549     311.0000       0.1972       0.1680       8.0108      24.7964     428.2599     147.3677      47.7071       0.2837       0.3340       4.4328    2372.8408       2.6997     203.2500    2465.0000
  963.9300       6.4244       6.1493       7.7221      13.8689      20.5937      48.5586     311.0000       0.1859       0.1563       7.8800      21.9863     382.3694     140.1265      47.7071       0.2626       0.3127       4.3591    2392.0588       2.8493     203.2500    2465.0000
  964.0824       6.6128       6.4054       8.0716      15.5020      23.7013      42.1918     311.0000       0.1762       0.1463       7.8943      21.2943     400.3978     121.1143      47.7071       0.2569       0.3086       4.2185    2408.6829       2.7644     203.2500    2488.0000
  964.2348       6.5641       6.6581       8.4066      14.6470      23.8200      41.9815     311.0000       0.1821       0.1524       7.8662      21.8133     412.9631      84.1920      47.7071       0.2298       0.2813       4.0742    2398.5566       3.3932     203.2500    2471.0000
  964.3872       6.9014       7.3724       9.0125      15.1362      23.5952      42.3816     311.0000       0.1885       0.1590       7.8484      22.3073     443.5567      61.8141      47.7071       0.1885       0.2389       4.0236    2387.5918       3.7346     202.8750    2483.0000
  964.5396       6.7467       6.8627       8.2518      12.7404      18.7692      53.2787     311.0000       0.2104       0.1817       7.9356      23.3894     461.0388      54.1570      47.7071       0.2323       0.2838       4.1462    2350.2231       3.9482     202.8125    2444.0000
  964.6920       6.4431       6.5006       7.6265      11.8328      16.4183      60.9076     311.0000       0.2115       0.1828       7.9562      24.0128     479.0672      87.9858      47.7071       0.2226       0.2741       4.3924    2348.3279       3.2986     202.5000    2427.0000
  964.8444       6.2985       6.1654       6.8929       9.7594      13.2774      75.3161     311.0000       0.2085       0.1797       7.8907      25.4025     423.6162     114.2821      47.7071       0.2230       0.2750       4.5641    2353.4575       3.0417     201.3125    2463.0000
  964.9968       6.4475       5.9764       6.9107      10.1376      12.8153      78.0318     311.0000       0.2000       0.1710       7.9222      24.2005     430.4451     116.9040      47.7071       0.2078       0.2593       4.5641    2367.9229       2.8440     201.1250    2522.0000
  965.1492       7.1119       6.1948       7.3373      11.3671      14.0981      70.9313     311.0000       0.2010       0.1719       7.6369      23.2896     433.7231     102.2804      47.7071       0.2278       0.2800       4.5141    2366.3250       2.8693     200.1875    2450.0000
  965.3016       7.3750       6.9959       8.3197      13.6654      17.2567      57.9486     311.0000       0.1935       0.1642       7.5720      22.6364     428.2599      98.8078      47.7071       0.2211       0.2728       4.4944    2379.0706       3.3350     200.1250    2467.0000
  965.4540       7.6237       7.7433       9.3780      16.5502      20.8708      47.9139     311.0000       0.1913       0.1619       7.7304      24.6488     474.1504     108.4816      47.7071       0.2262       0.2778       4.5399    2382.9434       3.9413     198.0000    2440.0000
  965.6064       7.4996       8.2437      10.0966      17.9476      23.3992      42.7364     311.0000       0.1984       0.1693       7.9789      23.2591     453.6635     113.3463      47.7071       0.1820       0.2326       4.6275    2370.6663       4.1480     197.5625    2457.0000
  965.7588       8.2591       8.3597      10.5113      19.6673      26.2491      38.0965     311.0000       0.2142       0.1856       8.1621      21.6234     465.4093     110.1267      47.7071       0.1932       0.2442       4.7220    2343.7815       3.6845     197.5000    2487.0000
  965.9112       8.7650       8.2064       9.6348      15.9746      21.8196      45.8303     311.0000       0.2323       0.2044       7.7838      20.1952     498.7345     116.9243      47.7071       0.2310       0.2830       4.8572    2312.7354       3.2223     197.5625    2439.0000
  966.0636       8.6949       7.0659       8.2116      13.4981      18.7943      53.2077     311.0000       0.2302       0.2022       7.7058      21.0619     469.2335     139.3311      47.7071       0.2884       0.3402       4.9465    2316.4312       3.1572     194.2500    2450.0000
  966.2160       9.1250       8.4629      10.3940      17.5375      26.5664      37.6416     311.0000       0.2042       0.1753       7.6764      22.4243     461.0388     170.9430      47.7071       0.2494       0.3014       4.9063    2360.8115       3.0436     193.5000    2465.0000
  966.3684       9.8257      10.4847      12.8267      23.3471      36.9011      27.0994     311.0000       0.1844       0.1548       7.8829      22.8551     447.9272     168.4337      47.7071       0.1784       0.2293       4.6959    2394.6104       3.3043     193.5000    2477.0000
  966.5208       9.8214      10.5287      13.5183      26.5499      41.8088      23.9184     311.0000       0.1764       0.1465       7.9103      22.2200     470.8725     143.8994      47.7071       0.1697       0.2207       4.4402    2408.3513       3.1049     192.0625    2507.0000
  966.6732       9.8121       9.9478      12.5017      25.4498      38.0493      26.2817     311.0000       0.2057       0.1768       8.0539      21.8843     503.6513     103.7328      47.7071       0.1582       0.2087       4.3881    2358.2271       3.2756     191.3750    2458.0000
  966.8256       9.6406       9.5534      12.4133      26.2397      35.0460      28.5339     311.0000       0.2319       0.2040       7.8058      22.4932     465.4093      92.2871      47.7071       0.1993       0.2511       4.5923    2313.4231       3.3874     190.6875    2466.0000
  966.9780       9.1714       9.2602      11.6408      28.0478      29.7071      33.6620     311.0000       0.2657       0.2390       7.8894      22.2616     432.6304     105.2754      47.7071       0.2076       0.2595       4.9943    2255.6938       3.4194     189.3750    2505.0000
  967.1304       9.2605       9.6956      12.6014      27.1911      33.1821      30.1367     311.0000       0.2810       0.2549       7.9028      19.8166     423.3430     147.7792      47.7071       0.1906       0.2421       5.4075    2229.4236       2.9286     187.7500    2449.0000
  967.2828       9.8810      10.1573      13.5642      29.3896      38.1184      26.2341     311.0000       0.2787       0.2524       7.7222      19.9374     467.5945     186.7080      47.7071       0.1699       0.2208       5.6740    2233.4724       2.7158     185.7500    2425.0000
  967.4352      10.4019      11.4596      15.1450      33.7702      47.3188      21.1332     311.0000       0.2418       0.2142       7.7042      18.5754     463.7703     206.3940      47.7071       0.2109       0.2628       5.6421    2296.5300       2.7423     185.0625    2467.0000
  967.5876      10.9507      13.0942      17.7105      39.9730      55.6263      17.9771     311.0000       0.2182       0.1897       7.7182      19.7348     449.2930     182.6842      47.7071       0.2264       0.2783       5.4071    2336.9565       2.9717     184.1250    2441.0000
  967.7400      10.3444      10.4882      13.9728      27.1667      45.7808      21.8432     311.0000       0.2081       0.1793       7.9681      18.5842     471.9651     146.5950      47.7071       0.2132       0.2653       5.1441    2354.1123       3.0541     183.7500    2456.0000
  967.8924      10.4772       8.7703      11.7857      21.6659      35.7897      27.9410     311.0000       0.1929       0.1635       7.8168      22.6528     447.6541     121.8715      47.7071       0.2313       0.2836       4.9795    2380.1650       3.4521     183.7500    2484.0000
  968.0448      10.5696      10.0264      12.7605      22.2434      31.2597      31.9901     311.0000       0.1615       0.1310       7.6783      24.0425     425.5284     110.8944      47.7071       0.2322       0.2842       4.8676    2433.8899       4.4263     184.8750    2471.0000
  968.1972      11.9037      10.8486      13.3936      22.5653      28.7747      34.7528     311.0000       0.1519       0.1211       7.8046      23.0424     418.4262      87.3487      47.7071       0.1807       0.2318       4.7412    2450.2183       5.9560     183.7500    2522.0000
  968.3496      11.1646      12.1541      14.6837      23.7519      25.3585      39.4345     311.0000       0.1649       0.1346       7.7883      21.2154     408.5926      84.6262      47.7071       0.1282       0.1773       4.6880    2427.9392       6.6377     183.7500    2489.0000
  968.5020       9.1588       9.9902      11.5957      17.2346      16.8983      59.1775     311.0000       0.1813       0.1515       7.7534      21.2154     428.8062     102.4873      47.7071       0.1321       0.1813       4.6807    2399.9934       4.7570     183.8750    2515.0000
  968.6544       7.9446       9.3015      11.0994      15.8244      14.4776      69.0720     311.0000       0.1693       0.1391       7.9115      22.6208     436.1814     140.3804      47.7071       0.1564       0.2069       4.6714    2420.5579       4.1141     184.3750    2576.0000
  968.8068       7.4250       8.9296      10.7142      15.0879      13.2225      75.6284     311.0000       0.1658       0.1355       7.9602      21.5220     451.7514     146.0140      47.7071       0.1735       0.2248       4.5590    2426.4780       4.1710     183.7500    2439.0000
  968.9592       8.0628       9.2744      10.2600      15.0654      13.1424      76.0897     311.0000       0.1743       0.1443       7.8154      20.9990     456.1220     138.3591      47.7071       0.1756       0.2268       4.4156    2411.9695       4.9671     183.7500    2456.0000
  969.1116       8.2141       8.5261      10.8118      16.1942      14.3280      69.7936     311.0000       0.2060       0.1772       7.8540      17.9598     455.5756     126.2755      47.7071       0.1868       0.2383       4.3428    2357.6570       4.5441     183.7500    2444.0000
  969.2640       7.9003       8.0305      10.6360      16.6586      15.5728      64.2145     311.0000       0.2357       0.2079       7.6533      17.9474     437.5472     122.3962      47.7071       0.2110       0.2625       4.3443    2307.0042       3.4076     183.7500    2436.0000
  969.4164       8.5534       7.8950       9.7047      16.9307      17.3718      57.5646     311.0000       0.2464       0.2190       7.8412      17.1483     459.3998     118.9306      47.7071       0.2302       0.2821       4.3242    2288.6868       2.7036     183.7500    2488.0000
  969.5688       8.2089       6.4347       8.7186      14.4610      16.2369      61.5880     311.0000       0.2350       0.2072       7.9189      19.5238     475.7893      99.9968      47.7071       0.2449       0.2972       4.1179    2308.1018       2.6040     184.1875    2467.0000
  969.7212       8.5419       7.4082       9.6360      17.0019      19.8335      50.4198     311.0000       0.2265       0.1983       7.9267      20.8381     455.0293      58.5351      47.7071       0.2400       0.2920       3.8362    2322.7468       3.1948     184.1875    2415.0000
  969.8736       9.1565       9.2774      13.7979      24.5607      35.8309      27.9089     311.0000       0.2115       0.1828       7.7813      23.0866     465.9556      17.7472      47.7071       0.1930       0.2442       3.5688    2348.3955       3.6074     186.1250    2444.0000
  970.0260       7.9040      10.3162      14.3145      27.9942      34.8019      28.7341     311.0000       0.1967       0.1675       7.7078      21.1269     479.0672      -2.6457      47.7071       0.1783       0.2292       3.4931    2373.6824       4.0964     185.8750    2470.0000
  970.1784       8.0318       9.2103      11.9289      20.8986      30.1516      33.1657     311.0000       0.1944       0.1651       7.8283      19.6954     414.0557       6.4876      47.7071       0.1730       0.2237       3.7042    2377.5801       4.4691     185.1250    2452.0000
  970.3308       8.0789       8.4062       9.8007      16.8632      22.1510      45.1446     311.0000       0.2059       0.1771       7.5788      17.8424     449.0199      46.9494      47.7071       0.1976       0.2494       4.1140    2357.8284       4.6218     185.0625    2446.0000
  970.4832       7.6502       7.6717       9.1143      14.1163      17.6879      56.5358     311.0000       0.2320       0.2040       7.7197      19.2501     470.8725      93.4079      47.7071       0.1875       0.2387       4.5263    2313.3521       3.4747     183.7500    2427.0000
  970.6356       7.2768       7.1820       8.4023      12.7067      15.5301      64.3913     311.0000       0.2365       0.2088       7.7152      20.6817     451.7514     134.8054      47.7071       0.2805       0.3333       4.6835    2305.5540       2.9260     185.2500    2475.0000
  970.7880       7.2704       7.7710       8.7204      13.0972      15.5767      64.1984     311.0000       0.2364       0.2087       7.8034      21.1449     474.4235     148.3703      47.7071       0.2132       0.2652       4.6509    2305.7119       2.7496     184.5625    2474.0000
  970.9404       6.7795       7.5441       8.5696      12.0961      14.5181      68.8795     311.0000       0.2171       0.1887       7.8081      19.9402     423.3430     149.2162      47.7071       0.1927       0.2440       4.5142    2338.6929       3.2137     183.7500    2497.0000
  971.0928       6.3973       6.4057       7.1135       9.6670      11.8286      84.5409     311.0000       0.2012       0.1722       7.6579      19.7372     439.1862     135.2880      47.7071       0.2190       0.2709       4.2932    2365.8782       3.0615     183.7500    2479.0000
  971.2452       5.7191       5.6992       6.1962       7.5178       9.1280     109.5532     311.0000       0.2106       0.1819       7.5576      17.1894     431.5378      84.5473      47.7071       0.2180       0.2697       3.9776    2349.8494       3.0934     183.7500    2462.0000
  971.3976       5.5477       5.3668       5.9112       7.6327       9.1250     109.5889     311.0000       0.2134       0.1848       7.7497      17.1784     450.3857      45.8653      47.7071       0.1958       0.2467       3.6148    2345.1172       3.1817     183.7500    2455.0000
  971.5500       5.7474       5.6286       6.2627       8.2379       9.7477     102.5887     311.0000       0.2249       0.1967       7.8626      16.7759     433.7231      17.1354      47.7071       0.2282       0.2797       3.3589    2325.4724       3.3380     183.7500    2444.0000
  971.7024       6.6508       6.0440       6.7505       9.2292      10.9945      90.9547     311.0000       0.2173       0.1889       7.6778      18.6561     475.7893      22.7904      47.7071       0.2502       0.3006       3.2269    2338.3718       3.0892     184.2500    2487.0000
  971.8548       6.9150       6.6532       7.5436      11.3288      13.8072      72.4258     311.0000       0.2361       0.2083       7.6591      18.5708     445.7420      17.6775      47.7071       0.2844       0.3345       3.2290    2306.3474       3.0778     187.2500    2513.0000
  972.0072       7.7842       7.3549       8.6199      13.9516      15.7929      63.3196     311.0000       0.2563       0.2293       7.7507      18.5552     432.0841      24.6563      47.7071       0.2857       0.3343       3.4068    2271.7065       3.0668     184.2500    2535.0000
  972.1596       8.4906       8.1274       9.9689      16.1916      18.8713      52.9906     311.0000       0.2780       0.2517       7.7257      19.1760     426.0746      42.2072      47.7071       0.2824       0.3320       3.6991    2234.6443       3.2287     183.7500    2497.0000
  972.3120       8.1240       8.0637       9.8407      15.7136      19.6502      50.8902     311.0000       0.2712       0.2447       7.7677      21.7238     443.5567      74.6918      47.7071       0.2621       0.3124       4.0112    2246.2439       2.8433     183.8750    2539.0000
  972.4644       8.0034       8.2430       9.7004      15.1975      18.7994      53.1931     311.0000       0.2580       0.2310       7.4969      22.5479     430.4451      93.1337      47.7071       0.2515       0.3028       4.1874    2268.8650       2.7708     183.7500    2491.0000
  972.6168       8.1267       7.8000       8.8647      12.9960      16.5062      60.5832     311.0000       0.2323       0.2044       7.6564      22.5947     434.8157     113.3757      47.7071       0.2560       0.3069       4.2947    2312.7400       2.8543     183.8125    2472.0000
  972.7692       8.2289       7.0706       8.1705      11.8064      14.1882      70.4811     311.0000       0.2190       0.1906       7.8440      22.1731     464.3167     129.4980      47.7071       0.3001       0.3493       4.3990    2335.5649       3.4337     183.8125    2513.0000
  972.9216       8.2658       7.0818       7.9815      11.7156      13.8078      72.4231     311.0000       0.1987       0.1696       7.6974      20.9438     473.3309     151.5322      47.7071       0.3538       0.3997       4.4661    2370.2227       3.3924     183.7500    2543.0000
  973.0740       8.4761       7.9318       8.8888      13.4498      15.6520      63.8895     311.0000       0.1969       0.1677       7.7264      22.8156     493.8176     147.1458      47.7071       0.2613       0.3098       4.4124    2373.2214       3.1627     184.1875    2477.0000
  973.2264       8.1075       8.3805       9.5038      14.3112      16.6045      60.2246     311.0000       0.2075       0.1786       7.5678      22.1930     417.8799     123.4293      47.7071       0.2540       0.3037       4.2701    2355.2524       2.9820     185.0625    2425.0000
  973.3788       8.0781       7.8332       8.8614      13.5917      15.6075      64.0718     311.0000       0.2283       0.2003       7.8407      23.4087     462.1314      90.8818      47.7071       0.2651       0.3162       4.1683    2319.5872       3.0757     186.0000    2402.0000
  973.5312       7.7071       7.4622       8.3596      12.6285      14.3312      69.7779     311.0000       0.2355       0.2077       7.8353      20.8420     452.8441      91.4328      47.7071       0.2536       0.3046       4.2536    2307.2427       3.1660     184.8125    2399.0000
  973.6836       8.3281       7.9248       9.1583      13.7157      15.9904      62.5375     311.0000       0.2432       0.2157       7.8586      20.2467     483.9840     110.7373      47.7071       0.2323       0.2831       4.4999    2294.1260       3.6121     184.5625    2393.0000
  973.8360       9.0350       8.2784       9.5216      15.0741      17.5837      56.8707     311.0000       0.2545       0.2274       7.7582      19.6696     514.8508     131.8879      47.7071       0.2384       0.2897       4.7808    2274.7744       3.1632     184.7500    2409.0000
  973.9884       8.4898       8.1852       9.5696      15.9750      18.6652      53.5756     311.0000       0.2502       0.2230       7.5817      19.5056     529.3281     142.8552      47.7071       0.2409       0.2923       4.9091    2282.0847       2.8708     187.1875    2519.0000
  974.1408       9.0737       8.7550      10.0087      16.9406      21.1503      47.2806     311.0000       0.2435       0.2159       7.5208      20.1009     484.5303     133.7607      47.7071       0.2723       0.3237       4.8533    2293.6921       2.8052     185.6250    2561.0000
  974.2932       8.9733       8.4851      10.6797      18.7853      24.8197      40.2905     311.0000       0.2255       0.1974       7.6979      21.7401     499.5540     126.9636      47.7071       0.2375       0.2885       4.7002    2324.3452       3.1410     184.5625    2449.0000
  974.4456       8.9308       8.8910      11.7165      22.2435      30.5272      32.7577     311.0000       0.2197       0.1913       7.6534      23.7549     485.0766     127.9519      47.7071       0.2348       0.2854       4.6511    2334.3086       3.3262     185.3125    2425.0000
  974.5980       9.1572      10.6713      13.9815      27.1651      35.1704      28.4330     311.0000       0.2139       0.1853       7.7579      22.3366     535.8839     148.9816      47.7071       0.2537       0.3050       4.7351    2344.2573       3.3570     188.9375    2393.0000
  974.7504       8.7843       8.6742      10.4895      21.4191      29.9760      33.3600     311.0000       0.2105       0.1818       7.8229      20.9290     573.0333     167.5539      47.7071       0.2384       0.2901       4.8246    2349.9604       3.4870     187.9375    2475.0000
  974.9028       8.7304       7.1753       9.1046      16.1061      22.3029      44.8372     311.0000       0.1930       0.1636       7.6769      20.2522     554.4586     161.7756      47.7071       0.2489       0.3013       4.7243    2379.9998       3.1314     187.7500    2524.0000
  975.0552       8.5125       7.2526       8.8668      15.0339      21.0133      47.5888     311.0000       0.1565       0.1258       7.7131      22.2783     500.9198     129.5626      47.7071       0.2286       0.2809       4.4322    2442.4441       3.3969     188.1875    2465.0000
  975.2076       8.7634       8.1028      10.2618      17.8338      25.0419      39.9330     311.0000       0.1166       0.0845       7.6651      24.2614     481.7987      83.9541      47.7071       0.1574       0.2079       4.0605    2510.5464       4.2997     187.6875    2504.0000
  975.3600       9.1783       8.2339      10.2858      17.7646      24.4977      40.8201     311.0000       0.1040       0.0714       7.6813      22.3926     520.8603      51.9588      47.7071       0.0951       0.1419       3.8188    2532.2397       5.7210     188.0625    2488.0000
  975.5124       9.5000       8.5023      10.9082      19.0930      25.3121      39.5067     311.0000       0.1111       0.0788       7.6437      21.1894     527.6892      55.4755      47.7071       0.1122       0.1602       3.7985    2519.9976       6.2682     189.1250    2434.0000
  975.6648       9.2425       8.7586      10.9120      18.8829      22.4182      44.6067     311.0000       0.1653       0.1349       7.8266      17.7283     502.0124      73.3693      47.7071       0.1598       0.2105       4.0563    2427.3328       4.4879     189.6250    2498.0000
  975.8172       8.1846       8.4779      10.1052      16.9915      20.8217      48.0269     311.0000       0.2168       0.1883       7.7949      18.4365     527.1429     101.1741      47.7071       0.2074       0.2596       4.3956    2339.3164       3.7767     190.3125    2452.0000
  975.9696       8.1364       7.8719       9.5718      15.8090      18.5130      54.0160     311.0000       0.2588       0.2318       7.7906      18.6266     548.9955     121.2015      47.7071       0.2536       0.3057       4.6374    2267.4746       2.7818     190.5000    2429.0000
  976.1220       8.6523       7.9116      10.0359      16.2578      19.4508      51.4118     311.0000       0.2492       0.2219       7.7085      21.4632     514.5776     131.1791      47.7071       0.2569       0.3080       4.5897    2283.8384       2.7932     190.0625    2480.0000
  976.2744       8.7723       8.4059       9.4667      15.2022      18.4909      54.0808     311.0000       0.2271       0.1990       7.6549      22.3763     523.3187     125.2034      47.7071       0.2479       0.2992       4.3494    2321.6699       3.0572     189.9375    2519.0000
  976.4268       8.5824       7.8892       9.5576      15.5139      19.6407      50.9148     311.0000       0.2150       0.1865       7.6150      21.3742     571.3944     106.2670      47.7071       0.2238       0.2755       4.0860    2342.3403       3.6925     189.2500    2482.0000
  976.5792       8.6194       7.4128       8.9822      14.1552      18.7846      53.2351     311.0000       0.2235       0.1953       7.6791      20.0157     581.7744      99.3397      47.7071       0.2235       0.2744       4.0114    2327.7498       3.5713     188.0000    2496.0000
  976.7316       8.9093       7.6143       8.7988      14.0595      18.9533      52.7611     311.0000       0.2372       0.2095       8.0358      17.9103     559.9218     107.3878      47.7071       0.2580       0.3087       4.1740    2304.3975       3.0720     188.6875    2545.0000
  976.8840       9.0563       8.5137      10.0568      16.9575      23.8371      41.9515     311.0000       0.2277       0.1996       8.0232      18.2772     584.5059     117.6991      47.7071       0.2888       0.3398       4.3555    2320.6819       2.9857     188.2500    2607.0000
  977.0364       8.9574       8.5441      11.1341      20.9550      30.7666      32.5028     311.0000       0.1933       0.1639       7.6759      15.5915     567.5701     132.0372      47.7071       0.1942       0.2451       4.4080    2379.5286       3.3835     187.9375    2515.0000
  977.1888       9.2467       8.9310      11.1270      20.3507      28.7606      34.7698     311.0000       0.1775       0.1476       7.5744      18.2160     497.0956     131.5770      47.7071       0.1853       0.2363       4.4168    2406.4580       3.7360     189.7500    2497.0000
  977.3412       9.8496       9.0569      10.8553      19.7817      27.0845      36.9215     311.0000       0.1766       0.1467       7.7954      17.3009     446.2883     134.5394      47.7071       0.2330       0.2853       4.5602    2407.9333       4.2042     188.0000    2433.0000
  977.4936      10.7028      10.4331      13.0846      25.5376      36.3630      27.5005     311.0000       0.1702       0.1400       7.8722      20.3185     463.7703     155.7026      47.7071       0.2147       0.2668       4.8616    2418.9241       4.4499     187.3125    2422.0000
  977.6460      10.6713      12.1882      17.4892      34.0921      43.5686      22.9523     311.0000       0.1571       0.1265       7.8667      17.7258     467.5945     168.2584      47.7071       0.1566       0.2068       5.0664    2441.3442       5.4439     186.4375    2480.0000
  977.7984       8.9229       8.8397      11.5582      20.7309      28.1961      35.4659     311.0000       0.1473       0.1163       7.7243      17.4524     489.1740     165.7381      47.7071       0.2088       0.2604       5.0023    2458.0374       4.2728     188.9375    2466.0000
  977.9508       9.9035       7.8003       9.2698      15.5553      20.5576      48.6438     311.0000       0.1558       0.1251       7.7700      17.5838     494.3640     126.7834      47.7071       0.2745       0.3265       4.7047    2443.6465       3.8135     189.1250    2495.0000
  978.1032      10.7978       9.0222      11.0745      19.3966      27.1050      36.8936     311.0000       0.1592       0.1286       8.0191      19.7850     498.1882      82.1130      47.7071       0.2330       0.2852       4.3636    2437.8025       3.6066     190.0000    2468.0000
  978.2556      11.0009      10.4705      13.0529      23.2159      34.8490      28.6952     311.0000       0.1609       0.1303       8.0215      21.8999     517.3092      47.9166      47.7071       0.1779       0.2291       4.2186    2434.9258       4.8421     188.9375    2495.0000
  978.4080      12.0346      12.4835      15.2399      27.3653      40.9345      24.4293     311.0000       0.1585       0.1279       7.6349      19.9689     533.6987      33.6342      47.7071       0.1309       0.1801       4.2856    2438.9150       5.6499     188.0625    2490.0000
  978.5604      11.9513      14.4439      17.5139      34.0117      47.0515      21.2533     311.0000       0.1688       0.1386       7.6909      19.5629     499.0077      26.1078      47.7071       0.1428       0.1926       4.3389    2421.3066       7.5065     187.3750    2503.0000
  978.7128      12.3264      13.0767      16.8335      31.9807      38.0576      26.2759     311.0000       0.1856       0.1560       8.0319      20.2577     521.1334      38.5814      47.7071       0.1825       0.2340       4.3841    2392.6594       6.0671     188.0625    2473.0000
  978.8652      10.4534      10.1782      12.5347      22.5263      25.3860      39.3918     311.0000       0.2167       0.1882       7.9245      21.0579     523.5919      59.3109      47.7071       0.2067       0.2583       4.4352    2339.4292       4.2847     187.6250    2456.0000
  979.0176      10.1002       9.2325      11.0851      20.2527      20.2613      49.3553     311.0000       0.2265       0.1984       7.7945      21.3518     537.5229     108.1233      47.7071       0.2204       0.2721       4.6521    2322.6040       3.2822     187.5625    2514.0000
  979.1700      10.9916       9.9327      12.4204      23.4118      23.5747      42.4183     311.0000       0.2289       0.2009       8.0006      20.7708     471.9651     142.3214      47.7071       0.2186       0.2703       4.8749    2318.5559       3.0411     188.6250    2532.0000
  979.3224      11.4029      10.7881      13.6089      24.1651      27.5075      36.3537     311.0000       0.2196       0.1912       8.0434      22.3917     496.5493     158.6084      47.7071       0.2379       0.2901       4.9943    2334.5388       2.9706     187.2500    2558.0000
  979.4748      12.6522      11.8319      14.9121      27.5833      32.8042      30.4839     311.0000       0.2372       0.2094       7.9507      20.8799     512.3924     146.5733      47.7071       0.1902       0.2416       5.0446    2304.4495       3.2442     186.3125    2478.0000
  979.6272      12.1970      12.1893      15.3576      26.7094      35.7046      28.0076     311.0000       0.2607       0.2338       7.7653      18.6814     527.1429     132.6435      47.7071       0.1871       0.2385       5.0532    2264.1753       3.1018     185.6250    2480.0000
  979.7796      11.3979      11.4328      13.9631      25.2230      32.0611      31.1904     311.0000       0.2614       0.2345       7.8096      18.0873     545.7176     129.1139      47.7071       0.2177       0.2699       4.9989    2263.0220       3.0369     185.3125    2492.0000
  979.9320      11.1035      10.4081      13.3814      24.2544      30.7427      32.5280     311.0000       0.2267       0.1985       7.9631      17.2662     533.6987     116.1511      47.7071       0.2051       0.2571       4.7444    2322.4050       3.1193     183.8125    2510.0000
  980.0844      11.5445      10.9567      14.2191      27.7607      34.4666      29.0136     311.0000       0.1881       0.1586       8.0317      19.3661     562.6533      92.0143      47.7071       0.1716       0.2224       4.3668    2388.3499       3.9585     186.0000    2501.0000
  980.2368      12.1615      11.4045      14.9683      30.7290      36.7575      27.2053     311.0000       0.1794       0.1495       7.8034      21.5812     575.2186      71.7266      47.7071       0.1973       0.2488       4.1144    2403.2856       4.9928     185.6250    2519.0000
  980.3892      12.1927      11.6202      15.3425      30.5227      34.8377      28.7045     311.0000       0.1901       0.1606       7.9500      23.4355     580.6818      73.7717      47.7071       0.2076       0.2591       4.1147    2384.9922       4.9180     187.7500    2534.0000
  980.5416      12.2453      12.2394      15.9046      31.8424      34.9278      28.6305     311.0000       0.1941       0.1648       7.9970      22.9261     483.9840      93.1649      47.7071       0.2283       0.2803       4.3048    2378.1433       4.9690     187.5000    2514.0000
  980.6940      14.0942      14.0506      19.8319      39.9847      42.6510      23.4461     311.0000       0.1857       0.1561       8.0342      19.9026     502.0124     111.6507      47.7071       0.2062       0.2582       4.5224    2392.4900       5.2707     188.9375    2528.0000
  980.8464      13.0763      14.0290      19.8071      37.9265      44.4928      22.4755     311.0000       0.1810       0.1512       7.9017      21.0875     488.9008     120.7020      47.7071       0.1652       0.2159       4.6902    2400.5291       5.4432     187.0000    2510.0000
  980.9988      13.3690      12.9339      18.0203      34.5170      41.2866      24.2209     311.0000       0.1695       0.1393       7.7176      20.8970     501.4661     132.8499      47.7071       0.1715       0.2226       4.7460    2420.1409       5.0831     188.9375    2471.0000
  981.1512      13.1781      12.0479      16.7571      32.9072      39.2161      25.4997     311.0000       0.1690       0.1387       7.9320      24.1258     514.5776     134.8739      47.7071       0.1836       0.2351       4.6681    2421.0691       4.5478     188.0000    2484.0000
  981.3036      11.7766      10.9031      14.5346      29.5856      34.2575      29.1907     311.0000       0.1662       0.1359       8.0067      22.1107     510.7534     128.9558      47.7071       0.1863       0.2376       4.4666    2425.7920       3.9941     188.2500    2465.0000
  981.4560      11.8812      10.6523      14.3804      28.1658      32.5944      30.6801     311.0000       0.1689       0.1387       7.9229      24.1247     464.3167     108.5014      47.7071       0.2026       0.2545       4.2421    2421.1858       4.1330     187.3125    2472.0000
  981.6084      11.2594      10.5872      14.2913      28.1567      32.9880      30.3141     311.0000       0.1812       0.1514       7.9522      22.5033     505.8366      77.3368      47.7071       0.1716       0.2226       4.1106    2400.1414       3.8191     187.7500    2456.0000
  981.7608      11.1373      10.3374      13.9391      28.1268      32.0473      31.2039     311.0000       0.1963       0.1671       8.0470      23.1002     523.3187      56.4699      47.7071       0.1778       0.2292       4.1487    2374.2830       4.2849     186.5625    2467.0000
  981.9132      11.2287      10.5020      14.5829      29.3521      35.3294      28.3050     311.0000       0.2097       0.1809       7.9132      23.6429     504.1977      63.3938      47.7071       0.1702       0.2212       4.3571    2351.4890       4.3377     186.8750    2498.0000
  982.0656      10.3511       9.6248      12.9741      24.1350      30.6405      32.6366     311.0000       0.2181       0.1897       7.7422      23.8434     573.3065      99.7171      47.7071       0.1652       0.2161       4.6422    2336.9929       4.3451     186.5000    2492.0000
  982.2180       9.8817       9.0828      11.6637      20.3749      26.3683      37.9244     311.0000       0.2345       0.2067       8.0353      26.9004     583.9597     134.0454      47.7071       0.1981       0.2500       4.9170    2308.9316       3.8243     184.7500    2501.0000
  982.3704       9.0360       8.3928      10.5756      17.8813      23.7128      42.1714     311.0000       0.2442       0.2168       8.0291      26.1706     561.2875     152.9582      47.7071       0.2130       0.2650       5.0055    2292.3550       3.4089     183.7500    2476.0000
  982.5228       8.0773       7.3907       9.1437      14.3526      19.1279      52.2796     311.0000       0.2390       0.2113       7.8996      25.0437     541.3470     147.5346      47.7071       0.2322       0.2839       4.8280    2301.3140       2.9654     184.3750    2416.0000
  982.6752       7.7874       7.0484       8.4252      13.5201      18.4200      54.2888     311.0000       0.2155       0.1870       7.8914      20.9736     555.5513     129.6632      47.7071       0.2172       0.2688       4.4053    2341.4409       2.8906     186.1875    2464.0000
  982.8276       8.4921       8.3688      10.2459      17.1657      25.0726      39.8842     311.0000       0.2011       0.1720       8.0461      20.7554     539.4349     104.4455      47.7071       0.2288       0.2802       3.9861    2366.1292       3.1188     184.4375    2494.0000
  982.9800       9.5952       9.6161      12.6301      25.0226      38.8664      25.7292     311.0000       0.1929       0.1635       8.0940      23.0919     538.6155      80.2908      47.7071       0.2140       0.2656       3.7251    2380.1616       3.5228     185.1250    2459.0000
  983.1324      10.0182       9.5735      12.4319      24.0950      38.6357      25.8828     311.0000       0.1888       0.1593       7.7854      24.5102     503.6513      69.0346      47.7071       0.2123       0.2637       3.6509    2387.2219       3.8515     185.2500    2474.0000
  983.2848      10.9672       9.5325      12.4545      24.9768      40.3281      24.7966     311.0000       0.1873       0.1578       7.9612      23.7134     520.0408      68.0130      47.7071       0.2131       0.2648       3.7046    2389.6958       4.2144     186.0000    2543.0000
  983.4372      11.2108      10.1722      13.7600      28.7606      44.9423      22.2507     311.0000       0.1845       0.1548       7.8603      21.6085     525.5040      66.7908      47.7071       0.2274       0.2794       3.7608    2394.5022       4.3988     185.9375    2512.0000
  983.5896      11.4581      10.4010      13.9500      30.0940      47.0434      21.2570     311.0000       0.1801       0.1503       7.8771      22.4334     527.6892      67.3335      47.7071       0.2021       0.2539       3.8066    2402.0718       4.8202     186.1250    2484.0000
  983.7420      10.6860      10.3261      13.7850      29.6544      44.9600      22.2420     311.0000       0.1805       0.1506       7.9547      21.0014     537.5229      66.9494      47.7071       0.1581       0.2085       3.8307    2401.4282       4.6810     185.1250    2468.0000
  983.8944      10.1140      10.1055      13.8046      28.7486      40.4768      24.7055     311.0000       0.1918       0.1624       8.0044      22.4100     542.4397      73.9946      47.7071       0.2011       0.2527       3.8732    2381.9814       4.7024     185.4375    2521.0000
  984.0468      10.4593      10.1437      13.6077      27.8842      37.8612      26.4123     311.0000       0.2038       0.1749       7.9650      21.9767     523.8650      84.5547      47.7071       0.2435       0.2952       3.9255    2361.4612       3.9028     184.4375    2527.0000
  984.1992      10.2541      10.1597      13.5634      27.2104      34.9182      28.6383     311.0000       0.2017       0.1727       7.6576      22.6002     486.4424      87.0533      47.7071       0.2480       0.2991       3.9361    2365.0356       3.8824     183.7500    2503.0000
  984.3516      10.0138      10.0838      13.4585      27.6791      33.4202      29.9220     311.0000       0.1994       0.1703       7.6800      22.8323     510.7534      89.1631      47.7071       0.2298       0.2809       3.9652    2369.0530       4.0349     183.7500    2506.0000
  984.5040       9.7237      10.2647      13.9712      29.1552      34.8069      28.7299     311.0000       0.2016       0.1726       7.8612      23.0485     515.6703      95.7830      47.7071       0.2435       0.2948       4.0239    2365.1929       4.0659     184.3750    2490.0000
  984.6564       9.0621       9.7360      12.9279      26.7905      32.0169      31.2335     311.0000       0.2093       0.1805       7.9541      21.6449     494.9103     109.2212      47.7071       0.2663       0.3172       4.0992    2352.1216       3.8424     183.7500    2479.0000
  984.8088       9.2012       8.7093      11.9846      24.9931      31.2292      32.0213     311.0000       0.1978       0.1686       7.7635      18.4682     521.6797     119.4084      47.7071       0.2503       0.3014       4.1030    2371.7859       3.7794     183.7500    2523.0000
  984.9612      10.2419      10.0376      13.9769      30.0216      43.0584      23.2243     311.0000       0.1884       0.1589       7.8715      17.7029     546.5370     110.3857      47.7071       0.2446       0.2958       4.0477    2387.7693       4.1395     183.7500    2514.0000
  985.1136      11.4940      11.0660      15.6118      36.2059      52.1909      19.1604     311.0000       0.1855       0.1558       7.7237      19.2935     562.1070      94.8272      47.7071       0.2388       0.2898       3.9728    2392.8530       4.4712     184.4375    2520.0000
  985.2660      11.3889      10.8507      15.4295      35.2406      55.2055      18.1141     311.0000       0.1869       0.1573       7.9124      21.7560     469.7798      83.8409      47.7071       0.2510       0.3022       3.8765    2390.3911       4.6881     184.1250    2545.0000
  985.4184      10.9926      10.2023      14.5513      32.0609      51.0979      19.5703     311.0000       0.1697       0.1395       7.8271      20.5954     480.9793      81.9943      47.7071       0.2361       0.2872       3.6964    2419.8645       4.3595     184.9375    2472.0000
  985.5708      10.2869       9.7815      13.9809      29.8979      44.4657      22.4893     311.0000       0.1535       0.1228       7.6759      21.2033     481.7987      72.5858      47.7071       0.2191       0.2704       3.4932    2447.4417       3.7212     186.0000    2452.0000
  985.7232       9.8228      10.0741      14.1976      30.0633      40.6555      24.5969     311.0000       0.1490       0.1180       7.6182      18.8871     509.6608      54.4643      47.7071       0.2361       0.2878       3.3761    2455.2634       3.9475     188.6875    2468.0000
  985.8756       9.2212      10.2348      14.2645      28.7290      39.0541      25.6055     311.0000       0.1654       0.1351       8.0499      18.1881     533.4255      39.6347      47.7071       0.1838       0.2350       3.3852    2427.1509       4.6050     189.9375    2535.0000
  986.0280       8.7713       9.4559      12.6854      25.0849      31.1639      32.0885     311.0000       0.1901       0.1607       8.0801      16.4529     485.0766      36.9136      47.7071       0.1584       0.2088       3.4867    2384.8552       4.9280     190.1250    2534.0000
  986.1804       9.0938       9.3632      12.1777      22.0552      27.0048      37.0304     311.0000       0.2007       0.1716       7.7616      17.3326     502.5587      50.8106      47.7071       0.1981       0.2500       3.6468    2366.8123       4.0256     190.3750    2510.0000
  986.3328       9.9316       9.8340      12.9233      26.1066      31.2740      31.9754     311.0000       0.1969       0.1677       7.6778      20.5674     458.3072      69.9093      47.7071       0.2345       0.2865       3.8757    2373.3577       4.3941     190.0625    2477.0000
  986.4852       9.6716       9.3544      13.0141      28.4929      32.7884      30.4986     311.0000       0.1930       0.1636       7.6476      21.7073     487.2619      78.7289      47.7071       0.2234       0.2750       4.1043    2380.0195       5.1591     192.5625    2506.0000
  986.6376       9.4873       8.4835      11.6956      23.5530      28.8690      34.6393     311.0000       0.2064       0.1776       7.6386      21.7541     444.1030      78.6657      47.7071       0.2299       0.2814       4.3203    2357.0090       4.6029     192.3750    2492.0000
  986.7900       9.5264       9.3081      12.3907      24.1462      32.4753      30.7927     311.0000       0.2281       0.2000       7.8189      22.4490     475.2430      76.2610      47.7071       0.2315       0.2835       4.5199    2319.9387       3.2961     193.3750    2484.0000
  986.9424       9.6045      10.0787      13.3369      27.9848      39.6479      25.2220     311.0000       0.2350       0.2072       7.8214      20.6221     471.4188      87.9245      47.7071       0.2167       0.2680       4.7184    2308.1274       2.9815     192.5625    2465.0000
  987.0948       9.3362       9.5379      12.8067      28.2202      42.3152      23.6322     311.0000       0.2387       0.2110       7.9062      22.0118     449.2930     102.7803      47.7071       0.2132       0.2647       4.8968    2301.8975       2.8752     192.1250    2519.0000
  987.2472       8.5905       8.8731      11.5102      21.9338      33.8032      29.5830     311.0000       0.2384       0.2107       7.7266      21.5329     447.9272     114.8744      47.7071       0.2248       0.2757       4.9839    2302.3022       3.2396     190.3750    2506.0000
  987.3996       9.3625       9.4993      11.7088      20.1431      33.1200      30.1933     311.0000       0.2332       0.2053       7.7473      22.9148     489.9934     115.0553      47.7071       0.2316       0.2835       4.9248    2311.2637       3.4407     191.0000    2462.0000
  987.5520      10.0024      10.3022      12.9631      24.7299      37.8974      26.3871     311.0000       0.2169       0.1884       7.8761      22.4516     492.9982     100.1711      47.7071       0.2332       0.2847       4.7260    2339.1660       3.8974     189.6875    2486.0000
  987.7044       9.8567       9.9358      12.7042      25.5654      39.0949      25.5788     311.0000       0.2098       0.1811       7.8548      21.0307     516.7629      69.7374      47.7071       0.1932       0.2448       4.4720    2351.1709       3.8348     191.0000    2513.0000
  987.8568      10.1465       9.5692      12.5078      23.9747      35.4381      28.2182     311.0000       0.2103       0.1816       7.7481      25.1998     565.6581      59.1261      47.7071       0.1985       0.2498       4.2723    2350.4248       3.9529     191.8750    2490.0000
  988.0092      11.2107      10.0783      12.5269      23.7718      35.2980      28.3302     311.0000       0.2101       0.1814       7.6667      23.2005     601.9880      68.3117      47.7071       0.2159       0.2675       4.1106    2350.6992       3.7844     191.5000    2482.0000
  988.1616      11.3824      10.6290      13.2703      26.3458      34.8379      28.7043     311.0000       0.1954       0.1661       7.7181      22.1017     616.7385      95.1643      47.7071       0.2585       0.3100       3.9494    2375.9219       3.6248     189.3125    2443.0000
  988.3140      11.2765      10.9561      13.9328      27.3199      33.1221      30.1913     311.0000       0.1819       0.1522       7.7637      18.6274     612.6411     104.9607      47.7071       0.2274       0.2782       3.7685    2398.9353       3.6359     191.3125    2489.0000
  988.4664      10.1544       8.9757      11.7317      21.9603      24.4694      40.8674     311.0000       0.1894       0.1600       7.8712      19.6404     462.6777      87.2746      47.7071       0.2359       0.2872       3.5926    2386.0708       3.5528     191.5000    2587.0000
  988.6188       9.0495       7.6666       9.8662      16.1469      17.3255      57.7186     311.0000       0.2017       0.1727       7.6998      19.4083     459.3998      59.0172      47.7071       0.2349       0.2864       3.4730    2365.0747       3.6184     191.8125    2609.0000
  988.7712       8.2253       7.1129       8.5167      12.4357      13.4391      74.4096     311.0000       0.2108       0.1821       7.7523      19.1460     453.3904      40.5476      47.7071       0.2690       0.3203       3.4542    2349.5950       3.5847     190.9375    2446.0000
  988.9236       7.2871       6.6197       7.8412      11.2320      12.0087      83.2731     311.0000       0.2027       0.1737       7.7581      18.2792     486.7156      52.5196      47.7071       0.2851       0.3354       3.5381    2363.4238       3.7743     190.3750    2452.0000
  989.0760       6.4584       6.2442       7.1697       9.8130      10.6908      93.5387     311.0000       0.1965       0.1673       7.7680      20.8130     505.2903      73.8487      47.7071       0.2342       0.2837       3.6256    2373.9336       3.5466     192.3750    2476.0000
  989.2284       5.5684       5.5062       6.3112       8.3844       9.2974     107.5565     311.0000       0.2009       0.1719       7.6687      19.0012     512.3924      82.9475      47.7071       0.2577       0.3082       3.6400    2366.4451       2.9344     191.7500    2452.0000
  989.3808       5.2525       4.9941       5.5985       7.3778       8.3174     120.2302     311.0000       0.2053       0.1764       7.7522      22.7071     515.1240      74.2004      47.7071       0.2975       0.3471       3.5531    2358.8979       2.6351     192.5000    2432.0000
  989.5332       5.1157       5.1006       5.6444       7.3991       8.6519     115.5809     311.0000       0.2058       0.1769       7.8405      21.6940     576.3112      62.0723      47.7071       0.2631       0.3133       3.4773    2358.1145       2.7178     193.2500    2465.0000
  989.6856       4.9478       4.8936       5.3656       7.1549       8.4471     118.3844     311.0000       0.1921       0.1627       7.7500      26.3363     492.9982      53.4964      47.7071       0.2953       0.3452       3.4603    2381.5425       3.1044     193.5000    2498.0000
  989.8380       4.8251       4.6941       5.0849       6.9821       8.4891     117.7977     311.0000       0.1799       0.1501       7.7629      24.1050     480.7061      46.2928      47.7071       0.2724       0.3232       3.5205    2402.3584       2.9647     193.5000    2513.0000
  989.9904       5.2432       4.8964       5.5213       7.9618       9.6501     103.6257     311.0000       0.1586       0.1280       7.7877      25.3518     493.8176      43.3857      47.7071       0.2224       0.2742       3.5984    2438.8479       2.8697     193.5000    2515.0000
  990.1428       6.0180       5.4059       6.2324       9.4912      12.4558      80.2841     311.0000       0.1418       0.1106       7.7897      23.7518     514.5776      31.7824      47.7071       0.1815       0.2328       3.6216    2467.5364       3.0246     193.5000    2519.0000
  990.2952       6.7179       6.3551       7.2483      11.2314      16.0581      62.2739     311.0000       0.1266       0.0948       7.6736      22.1419     490.2666      18.2977      47.7071       0.1507       0.2010       3.6358    2493.5544       3.4957     193.5000    2477.0000
  990.4476       7.6099       7.2188       8.5499      14.7304      22.4598      44.5239     311.0000       0.1205       0.0885       7.7667      20.0573     477.9745       3.5236      47.7071       0.1441       0.1940       3.6977    2504.0188       4.9754     193.5625    2455.0000
  990.6000       9.4081       9.2013      11.2345      21.9006      32.6657      30.6131     311.0000       0.1336       0.1021       7.8502      20.9422     494.3640      -0.9041      47.7071       0.1482       0.1983       3.8661    2481.5967       5.9574     193.5000    2441.0000
  990.7524       9.5562       8.9679      10.6456      20.8659      35.2248      28.3891     311.0000       0.1614       0.1309       7.7191      22.3631     504.7440      15.7218      47.7071       0.1647       0.2154       4.1624    2433.9954       6.5864     193.5000    2465.0000
  990.9048       9.7047       9.0149      10.5699      18.9982      24.1442      41.4178     311.0000       0.1710       0.1409       7.8186      22.9982     546.2639      55.2654      47.7071       0.1857       0.2374       4.3614    2417.5200       4.8130     193.5000    2499.0000
  991.0572       9.1170       9.2634      10.7734      17.5770      19.0514      52.4896     311.0000       0.1604       0.1298       7.7934      22.0886     541.8934      91.4843      47.7071       0.1786       0.2301       4.3386    2435.7751       5.2467     193.5000    2484.0000
  991.2096       8.5458       9.4357      11.5532      15.8669      18.2133      54.9048     311.0000       0.1335       0.1020       7.8768      20.4541     558.8292      96.3035      47.7071       0.1331       0.1822       4.0271    2481.6589       5.2807     193.6250    2488.0000
  991.3620       7.0013       8.1427       9.0254      12.9530      13.8183      72.3677     311.0000       0.1245       0.0926       7.8205      22.3668     463.2240      72.8302      47.7071       0.1441       0.1940       3.7362    2497.1304       6.7335     197.1875    2541.0000
  991.5144       5.9660       6.4848       7.2169       9.5102       9.4696     105.6015     311.0000       0.1240       0.0922       7.6716      20.9584     465.9556      68.8624      47.7071       0.1360       0.1855       3.6558    2497.8831       5.8965     197.5000    2480.0000
  991.6668       4.9561       5.3297       5.8015       7.1748       7.2475     137.9777     311.0000       0.1365       0.1051       7.8912      24.1057     489.4472      87.7686      47.7071       0.1357       0.1852       3.7221    2476.5811       3.9636     199.9375    2467.0000
  991.8192       4.6987       4.6203       5.1768       6.3115       6.3751     156.8612     311.0000       0.1492       0.1183       7.8925      22.1930     454.4830     103.6353      47.7071       0.1969       0.2487       3.7355    2454.8433       3.2136     202.0000    2486.0000
  991.9716       5.2038       4.6444       5.1047       6.3123       6.5425     152.8458     311.0000       0.1394       0.1081       7.8463      21.5961     457.7609      96.6682      47.7071       0.2433       0.2959       3.6356    2471.5735       3.1764     202.2500    2515.0000
  992.1240       7.0267       6.8441       7.5686      10.5137      10.6738      93.6877     311.0000       0.1247       0.0929       7.8837      20.4192     485.6229      81.8489      47.7071       0.2125       0.2644       3.5801    2496.7700       4.3136     203.0625    2534.0000
  992.2764       8.5337      10.0545      11.8253      18.2398      18.1543      55.0835     311.0000       0.1198       0.0877       7.9215      22.2590     474.1504      85.4013      47.7071       0.1786       0.2296       3.6890    2505.2170       5.8068     203.2500    2515.0000
  992.4288       9.7902       9.2580      11.2440      19.2663      22.5356      44.3741     311.0000       0.1458       0.1148       7.7388      22.6260     454.4830      94.4047      47.7071       0.1652       0.2159       3.9334    2460.6331       5.6527     203.2500    2534.0000
  992.5812      10.6796       8.4746      10.4124      18.2836      23.8194      41.9827     311.0000       0.1503       0.1194       7.9216      23.8975     478.5208     100.8241      47.7071       0.2431       0.2960       4.1193    2452.9141       4.2635     203.2500    2483.0000
  992.7336       9.9042       8.4136      10.2368      17.7895      23.4413      42.6598     311.0000       0.1352       0.1038       7.9991      20.9717     483.4377      86.9970      47.7071       0.2152       0.2678       4.1461    2478.7935       4.4745     203.2500    2458.0000
  992.8860       9.2839       9.2316      10.5041      18.2564      23.2451      43.0198     311.0000       0.1054       0.0728       8.0083      21.6068     493.2713      57.0838      47.7071       0.1152       0.1635       3.9772    2529.8279       5.3370     203.2500    2451.0000
  993.0384       9.2668       9.5769      10.7726      16.9636      22.9304      43.6103     311.0000       0.0879       0.0547       7.8624      19.3781     529.8745      46.2646      47.7071       0.0923       0.1385       3.8629    2559.7695       7.1555     203.2500    2524.0000
  993.1908       8.0190      10.0000      11.0241      16.9731      21.0488      47.5087     311.0000       0.0928       0.0598       7.8705      19.1341     518.4019      56.6974      47.7071       0.0918       0.1375       3.9118    2551.3428       6.4863     203.2500    2522.0000
  993.3432       7.8896       9.6527      10.3112      15.4157      17.3715      57.5654     311.0000       0.1037       0.0711       7.7288      21.1769     457.7609      89.9174      47.7071       0.1037       0.1506       4.1405    2532.6255       6.2195     203.5625    2467.0000
  993.4956       6.8702       7.8534       8.0751      12.0005      12.3097      81.2367     311.0000       0.1048       0.0722       7.8241      22.1341     453.9367     110.4534      47.7071       0.1221       0.1702       4.3129    2530.7881       5.2636     205.6250    2480.0000
  993.6480       6.4114       6.0589       6.5529       8.3099       9.0360     110.6680     311.0000       0.1047       0.0722       7.8673      22.4620     457.2146     108.5286      47.7071       0.1819       0.2333       4.3636    2530.8823       4.6990     205.3125    2470.0000
  993.8004       7.0995       6.4200       6.7542       8.0692       8.7548     114.2234     311.0000       0.0873       0.0541       7.9196      21.1738     454.4830     102.0520      47.7071       0.1251       0.1736       4.3371    2560.7639       4.5369     203.7500    2499.0000
  993.9528       7.1102       6.9389       7.5317       9.4551      10.2662      97.4068     311.0000       0.0988       0.0660       7.9512      21.4471     452.5709      95.2811      47.7071       0.0958       0.1422       4.4058    2541.0247       5.1703     204.5625    2474.0000
  994.1052       7.8121       7.3985       8.2489      10.8551      12.5706      79.5504     311.0000       0.0835       0.0501       8.0121      22.7405     457.2146     115.9720      47.7071       0.1191       0.1668       4.5496    2567.2783       5.1442     203.2500    2449.0000
  994.2576       8.3367       7.7305       8.2771      10.3086      12.9725      77.0860     311.0000       0.0896       0.0565       7.8253      20.9838     457.2146     115.0944      47.7071       0.1299       0.1786       4.6564    2556.7207       5.0156     203.2500    2497.0000
  994.4100       9.0578       8.2173       9.3683      11.4161      15.4576      64.6930     311.0000       0.0870       0.0538       7.9207      19.7841     439.1862      87.4712      47.7071       0.1167       0.1644       4.5714    2561.2654       5.2788     203.2500    2525.0000
  994.5624      10.1399       9.1170      10.7228      14.3594      19.4227      51.4860     311.0000       0.1017       0.0690       7.7551      19.4927     439.1862      38.1615      47.7071       0.0840       0.1294       4.3642    2536.0815       6.3108     203.8750    2472.0000
  994.7148       9.3352       8.5948       9.6991      14.3880      15.0206      66.5753     311.0000       0.1006       0.0679       7.8171      20.9000     440.2788      28.9183      47.7071       0.0939       0.1395       4.2049    2537.9763       6.5234     203.6250    2399.0000
  994.8672       9.4579       8.4632       9.8987      14.9128      15.8358      63.1481     311.0000       0.1006       0.0679       8.0567      20.2180     436.4546      57.9965      47.7071       0.1108       0.1577       4.2203    2538.0132       6.1088     204.1250    2390.0000
  995.0196       9.0028       8.4228      10.2621      15.5582      14.8066      67.5374     311.0000       0.0929       0.0599       7.9154      22.4468     435.9083     106.1313      47.7071       0.1026       0.1493       4.3617    2551.0894       5.0996     203.2500    2414.0000
  995.1720       7.9170       7.9768      10.1910      15.0775      15.4568      64.6964     311.0000       0.1071       0.0746       7.8848      21.6381     436.4546     127.1029      47.7071       0.1156       0.1636       4.5618    2526.9429       5.0129     203.2500    2448.0000
  995.3244       7.8703       8.9273      10.3927      14.7820      15.8064      63.2654     311.0000       0.1271       0.0954       7.8321      24.1287     451.7514     124.9738      47.7071       0.1357       0.1851       4.7359    2492.5908       4.0388     203.2500    2513.0000
  995.4768       6.5226       6.8694       7.4872       9.7224      10.9869      91.0177     311.0000       0.1664       0.1361       7.9272      21.4965     446.2883     114.0692      47.7071       0.1673       0.2183       4.8726    2425.5173       3.6243     201.0625    2519.0000
  995.6292       5.5388       5.0010       5.7133       6.8509       7.9654     125.5429     311.0000       0.1829       0.1532       7.9946      25.5668     432.6304     115.2971      47.7071       0.2150       0.2676       4.9169    2397.1731       3.0050     199.6250    2515.0000
  995.7816       6.0054       4.4391       4.8886       5.7459       6.7977     147.1077     311.0000       0.1641       0.1337       7.8901      25.8426     441.3714     123.5845      47.7071       0.2513       0.3042       4.8231    2429.4370       2.8967     198.0000    2538.0000
  995.9340       6.9805       5.4248       5.5963       6.4616       8.1010     123.4417     311.0000       0.1264       0.0946       7.8242      26.4620     431.8109     117.0390      47.7071       0.1982       0.2501       4.6414    2493.9197       3.4695     198.1250    2572.0000
  996.0864       7.8533       7.1260       7.9893      10.8050      17.2350      58.0216     311.0000       0.0889       0.0557       7.9416      21.6969     477.9745     100.7538      47.7071       0.1109       0.1589       4.4572    2558.0405       4.3997     199.3750    2548.0000
  996.2388       7.9945       9.0383       9.5424      13.7053      18.1022      55.2418     311.0000       0.0874       0.0543       7.8104      18.9851     451.4783      88.9010      47.7071       0.0902       0.1364       4.4290    2560.4712       6.2603     198.8125    2494.0000
  996.3912       7.5322       9.1876       9.8319      14.9991      18.7088      53.4508     311.0000       0.1062       0.0737       8.0020      19.9871     444.6494      95.1827      47.7071       0.0935       0.1395       4.5651    2528.3335       5.8709     197.0625    2528.0000
  996.5436       7.7015       8.2701       8.4291      12.2033      13.0443      76.6620     311.0000       0.1276       0.0959       8.1176      25.7455     425.2552     108.0399      47.7071       0.1291       0.1776       4.7584    2491.7905       4.3710     194.3125    2490.0000
  996.6960       7.0612       6.8010       7.7535      10.3838      11.6914      85.5328     311.0000       0.1239       0.0921       8.0432      27.1524     410.7778     106.5426      47.7071       0.1574       0.2077       4.8525    2498.0503       3.9566     193.5000    2479.0000
  996.8484       8.4492       7.9326       9.4987      12.8143      12.9681      77.1125     311.0000       0.1007       0.0680       7.8202      27.4019     443.5567      77.5948      47.7071       0.1382       0.1876       4.7306    2537.7961       4.2640     193.5000    2499.0000
  997.0008       9.1795       9.6294      10.0326      13.6708      15.4493      64.7277     311.0000       0.0837       0.0503       7.8280      23.0332     442.4640      49.1524      47.7071       0.1263       0.1751       4.5174    2566.9526       5.3657     191.1250    2537.0000
  997.1532       8.3998       8.0404       8.8468      11.5794      15.2291      65.6638     311.0000       0.0875       0.0544       7.5862      24.4515     468.1408      24.9131      47.7071       0.1369       0.1861       4.3076    2560.3213       5.1236     191.3125    2487.0000
  997.3056       7.9677       6.7485       7.4705       9.3474      11.6358      85.9415     311.0000       0.0885       0.0553       7.8142      25.2300     448.4735      18.1291      47.7071       0.1566       0.2068       4.1893    2558.6729       5.0479     189.5625    2487.0000
  997.4580      10.8648       7.9930       8.7043      11.4949      14.9099      67.0693     311.0000       0.0806       0.0472       7.9139      23.8403     446.2883       7.7603      47.7071       0.1303       0.1785       4.1094    2572.1458       6.4047     187.6250    2539.0000
  997.6104      13.3409      13.6457      15.3730      22.0514      30.2411      33.0676     311.0000       0.0538       0.0194       7.8599      20.6091     489.9934       4.5083      47.7071       0.0771       0.1209       3.9875    2618.0122       9.3423     186.6875    2510.0000
  997.7628      15.1825      22.6937      23.0633      35.5984      45.0543      22.1955     311.0000       0.0324      -0.0028       7.9620      18.6546     413.5093       3.8917      47.7071       0.0560       0.0978       3.8009    2654.5562      13.4285     185.6250    2521.0000
  997.9152      15.8931      29.3179      30.7551      50.3287      61.7708      16.1889     311.0000       0.0277      -0.0077       7.7628      17.7359     403.6757       2.3370      47.7071       0.0785       0.1222       3.6035    2662.7136      14.0615     184.1875    2517.0000
  998.0676      17.0923      23.6207      30.7639      65.6244      64.1076      15.5988     311.0000       0.0275      -0.0078       7.7147      19.0007     397.6663       5.4541      47.7071       0.0843       0.1284       3.5702    2662.8923      14.1003     183.1875    2525.0000
  998.2200      17.2996      20.2959      28.9344      72.7261      58.6552      17.0488     311.0000       0.0299      -0.0054       7.7820      20.7522     400.9441      15.3604      47.7071       0.0858       0.1300       3.7613    2658.8914      14.3518     182.4375    2471.0000
  998.3724      20.0522      22.6861      35.4378     100.9085      65.8398      15.1884     311.0000       0.0370       0.0020       7.9391      24.2187     406.4073      26.5977      47.7071       0.0750       0.1179       4.0598    2646.6929      15.6143     177.6250    2462.0000
  998.5248      23.5533      28.7513      54.6584     164.9062     100.9959       9.9014     311.0000       0.0375       0.0025       7.8194      23.7537     400.9441      62.2413      47.7071       0.0765       0.1189       4.4829    2645.8210      15.7330     177.5625    2492.0000
  998.6772      33.0658      38.2782      77.7463     246.1876     145.7374       6.8617     311.0000       0.0498       0.0152       7.7464      25.2673     400.3978      99.2260      47.7071       0.0690       0.1101       4.8914    2624.8696      17.8699     174.0000    2479.0000
  998.8296      37.0976      46.5642     121.1105     394.4507     236.5720       4.2270     311.0000       0.0409       0.0060       7.6609      29.2883     390.0178     138.2234      47.7071       0.0624       0.1017       5.2307    2640.0525      19.0067     174.0000    2497.0000
  998.9820      39.2301      54.3662     187.2069     657.3174     414.7156       2.4113     311.0000       0.0317      -0.0035       7.9478      35.7754     387.5594     136.3373      47.7071       0.0395       0.0757       5.2797    2655.7988      28.4523     174.0000    2505.0000
  999.1344      40.1223      67.6671     295.8201    1049.8124     688.0854       1.4533     311.0000       0.0047      -0.0315       7.8653      39.2572     382.9157     112.7963      47.7071       0.0214       0.0547       5.1253    2701.9370      37.8410     171.8125    2538.0000
  999.2868      37.2501      82.2375     395.3028    1403.2700     850.5735       1.1757     311.0000      -0.0098      -0.0465       7.6369      45.9434     375.2673      76.2448      47.7071       0.0062       0.0369       4.9194    2726.6895     104.1782     172.3750    2516.0000
  999.4392      37.3470      87.9473     380.2422    1432.7507     718.9478       1.3909     311.0000      -0.0110      -0.0477       7.7652      46.9530     374.1747      49.4101      47.7071       0.0056       0.0348       4.7686    2728.7566     173.5407     168.9375    2545.0000
  999.5916      38.4728      89.7506     305.1245    1168.0359     499.7873       2.0009     311.0000       0.0066      -0.0295       7.7861      51.0924     373.6284      25.7225      47.7071       0.0035       0.0320       4.7234    2698.6750     170.1257     167.2500    2545.0000
  999.7440      37.4648      68.7977     209.5112     870.4881     357.4197       2.7978     311.0000       0.0066      -0.0295       7.7407      48.8951     371.4431      24.6022      47.7071       0.0076       0.0358       4.7611    2698.6873     177.5584     164.7500    2511.0000
  999.8964      37.4067      56.9946     142.4159     709.6843     227.2775       4.3999     311.0000       0.0120      -0.0240       7.6312      51.8231     370.3505      19.6323      47.7071       0.0057       0.0337       4.8044    2689.5361     211.5030     165.3750    2544.0000
 1000.0488      36.6289      53.6514     121.7386     544.3814     191.0249       5.2349     311.0000      -0.0010      -0.0374       7.6253      51.4171     368.1653      32.9947      47.7071      -0.0026       0.0242       4.8190    2711.7183     227.9723     164.1875    2532.0000
 1000.2012      39.0535      64.4785     139.5073     451.2459     244.6621       4.0873     311.0000       0.0002      -0.0361       7.3995      52.8666     367.0726      31.3468      47.7071      -0.0039       0.0225       4.7931    2709.6243     245.3092     164.1875    2558.0000
 1000.3536      46.3620      89.4993     200.6268     581.9995     334.6967       2.9878     311.0000       0.0013      -0.0350       7.7419      51.5888     366.2531      25.7678      47.7071      -0.0010       0.0252       4.7379    2707.7788     358.2360     163.8125    2537.0000
 1000.5060      58.8769     151.1389     384.6223     811.3856     483.8421       2.0668     311.0000       0.0111      -0.0249       7.8208      50.3401     366.5263      12.1253      47.7071      -0.0036       0.0217       4.7118    2691.0654     392.1026     161.0625    2537.0000
 1000.6584      64.1533     211.8398     868.6861    1601.8342    1191.9672       0.8389     311.0000       0.0080      -0.0281       7.7355      51.4982     364.0679      13.6509      47.7071      -0.0098       0.0152       4.7125    2696.3147     477.2519     159.0000    2531.0000
 1000.8108      67.1674     246.9913     755.3883    1521.2434     927.9372       1.0777     311.0000      -0.0022      -0.0386       7.5328      51.8743     362.1558      25.3696      47.7071      -0.0115       0.0130       4.7713    2713.7651     497.2463     154.8750    2534.0000
 1000.9632      68.3223     247.3054     612.2061    1604.3176     574.3136       1.7412     311.0000      -0.0104      -0.0472       7.5172      51.0143     361.8826      31.2393      47.7071      -0.0058       0.0192       4.8048    2727.8452     587.1992     154.4375    2497.0000
 1001.1156      65.1457     167.0039     492.4805    1786.5725     586.5939       1.7048     311.0000      -0.0076      -0.0443       7.6856      45.5386     362.1558      24.5547      47.7071      -0.0069       0.0174       4.7853    2723.0493     702.7082     152.5625    2499.0000
 1001.2680      63.8264     132.6095     386.5817    1933.1630     543.9579       1.8384     311.0000      -0.0004      -0.0368       7.4802      46.4404     361.0632      13.7057      47.7071      -0.0075       0.0166       4.7293    2710.7366     747.2341     151.5625    2492.0000
 1001.4204      64.8310     121.2698     377.9521    1950.0000     566.9438       1.7638     311.0000       0.0056      -0.0306       7.6643      44.8951     358.8779       8.7173      47.7071      -0.0115       0.0120       4.6910    2700.4114     774.8101     148.6875    2505.0000
 1001.5728      66.6324     130.5083     422.6659    1950.0000     692.1679       1.4447     311.0000       0.0158      -0.0199       7.6620      45.9701     358.8779       3.5880      47.7071      -0.0133       0.0101       4.7327    2682.8975    1221.9039     147.0625    2507.0000
 1001.7252      70.4618     150.4163     495.0041    1950.0000     778.5703       1.2844     311.0000       0.0161      -0.0197       7.4158      45.5043     359.4242       3.8309      47.7071      -0.0087       0.0153       4.8012    2682.5513     874.5327     144.6875    2475.0000
 1001.8776      76.1767     162.4197     536.6758    1950.0000     813.1695       1.2298     311.0000       0.0058      -0.0304       7.3502      43.7736     357.7852       7.1943      47.7071      -0.0095       0.0148       4.8442    2700.1587     903.1021     144.6875    2454.0000
 1002.0300      75.1260     156.3431     505.4365    1950.0000     748.1068       1.3367     311.0000       0.0016      -0.0347       7.3137      40.8979     356.6926       7.7336      47.7071      -0.0097       0.0148       4.7884    2707.2136     839.4872     144.6875    2476.0000
 1002.1824      73.8186     145.9778     450.1544    1950.0000     633.4841       1.5786     311.0000       0.0019      -0.0344       7.5469      38.8410     356.1463       7.8657      47.7071      -0.0068       0.0180       4.7282    2706.7852    1029.8279     144.6875    2479.0000
 1002.3348      72.7999     140.1948     400.4264    1950.0000     563.5031       1.7746     311.0000       0.0059      -0.0303       7.5224      42.3491     355.0537      11.2007      47.7071      -0.0053       0.0198       4.7017    2699.9709     861.3767     144.6875    2536.0000
 1002.4872      73.6246     145.0480     398.4796    1950.0000     578.0587       1.7299     311.0000       0.0108      -0.0252       7.4454      45.7707     355.6000      10.7951      47.7071      -0.0035       0.0219       4.7494    2691.5593     924.2831     145.1250    2511.0000
 1002.6396      75.6144     146.1957     385.3750    1950.0000     616.7590       1.6214     311.0000       0.0151      -0.0208       7.2518      48.9883     355.6000       9.9525      47.7071      -0.0092       0.0160       4.7719    2684.2539     810.6801     146.1250    2490.0000
 1002.7920      74.4164     136.3430     403.1406    1950.0000     714.8984       1.3988     311.0000       0.0239      -0.0116       7.4185      47.3873     355.6000       3.2086      47.7071      -0.0049       0.0208       4.7666    2669.1218     778.1462     149.3750    2470.0000
 1002.9444      77.3092     140.4114     426.4071    1950.0000     873.8694       1.1443     311.0000       0.0240      -0.0115       7.3464      46.6415     354.2342       2.9993      47.7071      -0.0040       0.0221       4.7303    2668.9106     820.7609     152.0625    2516.0000
 1003.0968      78.6806     151.1781     431.0330    1950.0000    1126.0454       0.8881     311.0000       0.0288      -0.0065       7.2254      47.4762     353.4147       1.3754      47.7071       0.0013       0.0280       4.7338    2660.7932     856.8581     154.4375    2547.0000
 1003.2492      74.3037     134.3517     410.9658    1950.0000    1376.1324       0.7267     311.0000       0.0251      -0.0104       7.3412      51.3596     353.4147       5.1165      47.7071       0.0037       0.0305       4.7523    2667.1208     451.1174     158.2500    2581.0000
 1003.4016      68.0087     114.1887     338.9616    1950.0000    1599.9919       0.6250     311.0000       0.0173      -0.0185       7.4402      51.9317     352.3221      12.3050      47.7071      -0.0017       0.0252       4.7935    2680.4509     304.7498     161.4375    2583.0000
 1003.5540      65.3580     106.9542     318.5425    1790.9563    1615.7579       0.6189     311.0000      -0.0011      -0.0375       7.2343      48.0859     351.7758      23.2079      47.7071       0.0043       0.0319       4.8388    2711.9390     267.7729     162.2500    2525.0000
 1003.7064      70.2115     114.5614     397.2995    1512.2456    1408.2350       0.7101     311.0000      -0.0109      -0.0476       7.2087      41.9961     350.6832      25.3246      47.7071       0.0013       0.0293       4.8748    2728.5720     343.9300     164.1875    2580.0000
 1003.8588      76.6891     116.5100     424.2516    1114.7072    1014.9531       0.9853     311.0000      -0.0167      -0.0537       7.0649      40.2343     350.1369      19.6998      47.7071       0.0007       0.0287       4.8723    2738.5764     384.8347     168.9375    2561.0000
 1004.0112      81.8398     123.0200     386.8220     726.2337     634.5541       1.5759     311.0000      -0.0139      -0.0508       7.1441      42.6936     349.0442      10.2415      47.7071       0.0101       0.0392       4.8287    2733.7644     372.9616     174.0000    2586.0000
 1004.1636      85.0499     105.6128     308.5972     445.9993     365.5370       2.7357     311.0000      -0.0122      -0.0490       7.3829      43.2245     348.4979      10.9076      47.7071       0.0079       0.0368       4.7705    2730.8708     270.0895     174.4375    2611.0000
 1004.3160      82.8992      86.0761     224.9973     277.5499     213.8473       4.6762     311.0000      -0.0026      -0.0391       7.2697      40.1146     347.9516       9.9430      47.7071       0.0095       0.0386       4.6744    2714.4673     212.9778     180.1250    2624.0000
 1004.4684      79.0543      68.1175     152.5263     187.2952     133.0191       7.5177     311.0000       0.0062      -0.0299       7.2292      34.1809     346.3127       8.9293      47.7071       0.0068       0.0356       4.5903    2699.3145     196.3080     183.5000    2523.0000
 1004.6208      72.4023      57.8466      98.9012     125.5928      82.7038      12.0913     311.0000       0.0042      -0.0320       7.1916      39.0982     345.2200      11.3435      47.7071       0.0016       0.0303       4.5742    2702.8713     213.1562     185.5625    2570.0000
 1004.7732      56.1871      61.7501      71.7334      97.8607      59.8204      16.7167     311.0000       0.0095      -0.0265       7.1330      44.5586     344.6737      37.8084      47.7071      -0.0002       0.0294       4.7808    2693.6873     173.4408     190.9375    2579.0000
 1004.9256      50.4415      54.6535      77.7749      89.2551      53.4784      18.6991     311.0000       0.0516       0.0171       7.0799      48.0290     345.2200      73.9150      47.7071       0.0160       0.0487       5.1684    2621.7190      72.7546     194.7500    2565.0000
 1005.0780      25.6212      25.3650      30.2977      50.9506      30.9882      32.2703     311.0000       0.1068       0.0743       7.1466      46.5860     344.6737     111.9676      47.7071       0.0491       0.0869       5.5730    2527.3718      14.5810     198.4375    2571.0000
 1005.2304      16.5938      13.9136      19.4195      34.3971      22.8353      43.7919     311.0000       0.1351       0.1037       7.0455      45.9686     340.8495     140.8520      47.7071       0.0857       0.1290       5.8077    2478.9480      10.4889     203.1875    2554.0000
 1005.3828      17.0152      15.5648      22.1075      39.9111      19.0033      52.6225     311.0000       0.1449       0.1138       7.1882      44.3789     350.1369     153.5292      47.7071       0.1095       0.1563       5.9114    2462.1509       9.6684     203.3750    2520.0000
 1005.5352      15.7273      13.7104      23.9036      41.7461      26.8999      37.1749     311.0000       0.1629       0.1324       7.1437      42.3775     364.8874     157.5580      47.7071       0.1415       0.1908       5.9803    2431.4883       7.0345     206.2500    2472.0000
 1005.6876      12.0157      10.0123      16.1301      24.3447      22.1103      45.2277     311.0000       0.1991       0.1700       7.0858      38.7915     363.2484     161.5927      47.7071       0.1544       0.2048       6.0746    2369.5718       5.8245     208.4375    2481.0000
 1005.8400       8.4444       6.2809       7.9097      10.9993      11.0788      90.2628     311.0000       0.2671       0.2405       6.9454      40.0025     375.8137     156.0483      47.7071       0.1738       0.2250       6.2373    2253.2085       3.7860     210.3125    2491.0000
 1005.9924       4.5889       4.3302       5.2207       6.6127       7.0303     142.2415     311.0000       0.3484       0.3247       7.0382      41.3091     370.3505     142.7584      47.7071       0.3039       0.3517       6.4258    2114.2600       2.5142     213.0625    2525.0000
 1006.1448       3.0382       2.9773       3.3439       3.8674       4.3127     231.8751     311.0000       0.3904       0.3682       7.0818      41.8790     390.0178     143.2667      47.7071       0.3898       0.4332       6.5249    2042.4169       1.8163     213.0625    2525.0000
 1006.2972       2.5967       2.5856       2.7118       3.0187       3.5555     281.2538     311.0000       0.3710       0.3482       7.2113      39.7138     437.5472     165.8140      47.7071       0.3716       0.4150       6.4231    2075.5200       1.8070     213.0625    2521.0000
 1006.4496       2.7914       2.8298       2.9782       3.4322       4.0710     245.6385     311.0000       0.3167       0.2918       6.9390      34.5765     413.5093     191.5125      47.7071       0.3314       0.3798       6.1458    2168.5122       1.9920     213.0625    2488.0000
 1006.6020       3.9889       3.9407       3.8994       4.8633       6.3406     157.7136     311.0000       0.2775       0.2512       6.9084      32.6169     422.7967     192.2612      47.7071       0.3093       0.3580       5.8125    2235.5000       2.3833     214.0000    2517.0000
 1006.7544       4.7665       4.7959       5.2778       7.2024      10.4159      96.0069     311.0000       0.2575       0.2305       7.1288      30.3163     440.2788     174.1204      47.7071       0.2311       0.2816       5.5095    2269.6072       2.6705     214.5625    2513.0000
 1006.9068       6.5857       6.0553       6.5090       9.9737      13.7979      72.4748     311.0000       0.2529       0.2257       6.8598      30.1263     375.8137     168.8569      47.7071       0.2516       0.3019       5.4021    2277.5337       3.3422     214.6875    2522.0000
 1007.0592       6.0571       6.4061       7.3432      12.0975      15.5737      64.2110     311.0000       0.2968       0.2712       6.8840      29.4288     370.6237     167.6869      47.7071       0.2303       0.2798       5.6060    2202.5269       3.6126     216.5625    2545.0000
 1007.2116       5.8892       6.5408       8.2522      16.1032      18.5644      53.8665     311.0000       0.3731       0.3503       6.9366      28.5056     365.9800     161.9072      47.7071       0.3414       0.3872       6.0155    2072.0488       2.6895     216.0000    2508.0000
 1007.3640       5.4735       5.8274       7.3153      11.2139      12.8293      77.9467     311.0000       0.4234       0.4024       7.2971      29.2844     379.6378     155.0987      47.7071       0.4318       0.4711       6.3154    1986.0153       2.0578     216.7500    2537.0000
 1007.5164       5.7093       5.8835       6.9303       9.2953      10.2897      97.1842     311.0000       0.4005       0.3787       7.0974      26.2760     382.3694     163.9978      47.7071       0.3798       0.4216       6.2600    2025.0852       2.0587     217.6250    2585.0000
 1007.6688       6.0114       6.4418       7.8936      11.8872      13.4423      74.3921     311.0000       0.3503       0.3266       7.1584      25.1549     390.5641     177.9500      47.7071       0.3119       0.3574       5.9502    2111.0449       2.4043     217.2500    2583.0000
 1007.8212       5.5916       6.4621       8.5560      14.5882      15.2887      65.4077     311.0000       0.3315       0.3072       6.7967      23.9331     377.7258     178.2190      47.7071       0.3593       0.4051       5.6428    2143.2019       2.5683     216.2500    2578.0000
 1007.9736       4.8788       5.3201       6.5940       9.4266       9.8906     101.1059     311.0000       0.3470       0.3233       6.6931      26.7390     392.2031     157.3774      47.7071       0.3545       0.4007       5.4784    2116.5750       2.2708     217.1250    2567.0000
 1008.1260       4.6877       4.3092       5.1225       7.0032       7.2351     138.2146     311.0000       0.3148       0.2899       6.9637      28.0728     364.8874     167.4757      47.7071       0.3468       0.3944       5.3730    2171.7087       2.3012     215.0000    2603.0000
 1008.2784       5.0344       5.1704       6.4760      10.3013      10.0986      99.0232     311.0000       0.2752       0.2488       7.2471      27.0818     356.6926     178.9033      47.7071       0.2036       0.2535       5.3119    2239.4568       3.2421     214.6250    2586.0000
 1008.4308       6.4739       8.8032      15.4014      27.4272      25.0197      39.9685     311.0000       0.2633       0.2365       7.1856      27.7502     352.5953     185.9996      47.7071       0.1509       0.2007       5.3484    2259.7646       3.3828     213.0625    2572.0000
 1008.5832       7.0916      10.6365      25.3249      38.6181      36.0732      27.7214     311.0000       0.2861       0.2601       7.0087      27.0398     332.6548     180.0454      47.7071       0.2256       0.2778       5.4813    2220.8220       3.4000     213.0625    2521.0000
 1008.7356       6.6857       9.2616      16.2635      33.1399      32.6254      30.6510     311.0000       0.3211       0.2964       6.9820      29.4002     334.2937     159.7497      47.7071       0.2225       0.2745       5.5558    2160.8699       2.7400     213.0625    2501.0000
 1008.8880       4.5099       4.7964       6.7400      12.3084      16.4671      60.7272     311.0000       0.3459       0.3221       6.9359      27.9376     335.3864     126.7240      47.7071       0.2400       0.2901       5.4112    2118.5737       2.1485     211.2500    2511.0000
 1009.0404       2.7403       2.9702       3.7575       5.7232       6.8677     145.6087     311.0000       0.3646       0.3415       6.8765      31.1639     331.0158      87.0528      47.7071       0.3497       0.3944       5.1216    2086.5908       1.7476     212.1875    2552.0000
 1009.1928       2.2609       2.4163       2.8779       3.9895       5.0857     196.6302     311.0000       0.3716       0.3487       7.1687      32.5799     351.2295      58.2926      47.7071       0.4737       0.5076       4.8277    2074.6282       1.7085     209.8125    2543.0000
 1009.3452       2.3398       2.5047       2.9439       4.3622       6.7260     148.6766     311.0000       0.3685       0.3455       7.1672      36.3898     339.4837      61.2290      47.7071       0.4309       0.4645       4.7871    2079.9133       1.7931     207.4375    2556.0000
 1009.4976       2.3497       2.5264       2.9210       3.9723       6.7273     148.6480     311.0000       0.3857       0.3634       7.2128      34.1255     337.0253      74.0058      47.7071       0.4302       0.4644       5.0201    2050.4016       1.7547     204.4375    2523.0000
 1009.6500       2.4289       2.5195       2.8169       3.7335       6.2257     160.6255     311.0000       0.3962       0.3743       6.9914      31.5488     334.5669     104.9269      47.7071       0.4522       0.4882       5.4479    2032.4189       1.4716     203.4375    2511.0000
 1009.8024       2.4623       2.6369       2.8835       3.7556       5.8082     172.1718     311.0000       0.3870       0.3647       6.8114      29.6875     327.1916     131.9128      47.7071       0.3731       0.4161       5.7970    2048.1704       1.6456     203.1250    2500.0000
 1009.9548       2.6003       2.9603       3.2081       4.3113       6.2407     160.2378     311.0000       0.3410       0.3170       6.7789      32.5597     330.1964     156.1155      47.7071       0.3312       0.3755       5.8806    2126.9512       1.8385     201.4375    2492.0000
 1010.1072       2.9789       3.6446       3.7793       5.2418       7.6994     129.8797     311.0000       0.3104       0.2853       7.1781      33.9520     328.8306     155.4468      47.7071       0.3407       0.3853       5.7306    2179.2253       2.3453     200.0625    2492.0000
 1010.2596       3.5509       4.2192       4.5555       6.5144       9.4877     105.4000     311.0000       0.2959       0.2703       7.3220      32.6123     346.8590     146.5774      47.7071       0.2767       0.3258       5.4830    2203.9604       2.5731     196.3125    2531.0000
 1010.4120       4.2742       5.1330       5.6487       9.1286      11.6553      85.7978     311.0000       0.3205       0.2958       7.2377      29.9519     348.4979     128.6013      47.7071       0.2271       0.2773       5.4054    2161.9412       2.9432     195.1875    2484.0000
 1010.5644       5.2237       6.3865       7.7908      18.7506      16.2324      61.6050     311.0000       0.3344       0.3102       6.9043      27.3599     355.6000     119.0088      47.7071       0.2717       0.3233       5.4589    2138.2334       2.7358     193.5000    2530.0000
 1010.7168       6.0027       7.1615       9.3459      19.0037      14.9683      66.8077     311.0000       0.3562       0.3328       6.6435      29.5712     364.3410     110.7773      47.7071       0.2842       0.3336       5.6395    2100.8706       2.7482     193.5000    2541.0000
 1010.8692       6.3757       7.2556      11.1995      28.9605      20.5443      48.6754     311.0000       0.3859       0.3636       6.7260      28.4309     420.3383     104.1746      47.7071       0.2537       0.3029       5.8714    2050.0291       2.2272     193.4375    2497.0000
 1011.0216       7.0977       7.7260      11.5969      36.1822      27.3311      36.5884     311.0000       0.4403       0.4200       7.0172      29.4280     394.3884      95.0258      47.7071       0.3846       0.4256       6.1744    1957.0627       1.9100     191.8750    2543.0000
 1011.1740       8.4168       7.8215      12.3162      44.5910      36.9682      27.0503     311.0000       0.4856       0.4669       7.3352      27.8388     413.5093      85.5730      47.7071       0.4229       0.4603       6.4499    1879.6377       1.5896     191.1875    2525.0000
 1011.3264      11.0395       8.1339      16.9984      47.4798      50.4178      19.8343     311.0000       0.4815       0.4626       7.1697      30.6241     427.1672      79.3652      47.7071       0.4788       0.5107       6.4871    1886.6522       1.6199     189.6250    2551.0000
 1011.4788      11.0872      13.3199      21.2304      39.3303      46.9875      21.2822     311.0000       0.4346       0.4140       6.8584      31.2320     434.5425      83.6190      47.7071       0.4244       0.4625       6.2678    1966.8635       1.9683     186.5625    2549.0000
 1011.6312       6.7440       7.4491      10.2886      24.8142      39.3418      25.4183     311.0000       0.3730       0.3502       6.7244      28.2209     426.6209      98.2267      47.7071       0.3464       0.3892       5.8918    2072.1953       2.3446     185.8125    2544.0000
 1011.7836       4.9841       5.3199       6.4096      10.7620      14.3948      69.4695     311.0000       0.3223       0.2976       7.0704      24.7787     426.6209     114.8601      47.7071       0.3379       0.3807       5.4954    2158.9290       2.5177     184.5000    2583.0000
 1011.9360       4.4116       5.0461       5.5668       8.6290      13.2386      75.5369     311.0000       0.2948       0.2692       7.1263      22.7721     369.2579     124.7113      47.7071       0.3515       0.3958       5.1963    2205.9006       2.5610     183.7500    2656.0000
 1012.0884       5.0966       5.7504       7.1752      13.0873      17.5002      57.1423     311.0000       0.3275       0.3030       7.2771      24.9411     356.1463     108.2392      47.7071       0.2820       0.3307       5.1350    2150.0386       2.7608     182.4375    2575.0000
 1012.2408       5.7048       6.5197       8.8316      18.0564      22.4565      44.5305     311.0000       0.3720       0.3492       7.1483      26.7824     376.3600      90.4660      47.7071       0.3033       0.3518       5.2613    2073.8655       2.5537     180.5625    2585.0000
 1012.3932       5.8138       6.3020       7.8958      13.8954      16.7132      59.8328     311.0000       0.3966       0.3747       7.1898      26.3018     376.9063      79.7983      47.7071       0.4193       0.4604       5.3810    2031.7819       2.4292     177.6875    2565.0000
 1012.5456       4.9488       5.3412       6.6682      10.5332       9.9687     100.3136     311.0000       0.3747       0.3520       7.0863      27.9428     379.6378      85.0085      47.7071       0.4343       0.4691       5.3399    2069.1855       2.4244     176.8750    2537.0000
 1012.6980       4.1243       4.4716       5.4229       7.3965       8.3735     119.4251     311.0000       0.3337       0.3094       7.1121      27.8986     353.1416     103.2698      47.7071       0.3797       0.4206       5.2075    2139.4316       2.4682     175.9375    2597.0000
 1012.8504       4.1076       4.7529       5.8167       8.0359       8.9316     111.9618     311.0000       0.3090       0.2839       7.1975      27.7659     352.8684     128.9220      47.7071       0.3056       0.3523       5.2049    2181.5854       2.7079     178.5000    2662.0000
 1013.0028       5.2196       6.2274       7.8662      10.4919      13.9093      71.8943     311.0000       0.3062       0.2810       7.1216      23.7242     372.5358     148.0682      47.7071       0.2372       0.2881       5.3450    2186.4082       3.2934     176.5000    2635.0000
 1013.1552       6.0964       7.2136       9.7760      15.1689      21.2731      47.0077     311.0000       0.3349       0.3107       6.9726      24.1559     332.1085     155.6931      47.7071       0.2493       0.3009       5.6396    2137.3994       3.0086     174.9375    2618.0000
 1013.3076       6.5099       7.5148      11.3914      21.6543      23.4621      42.6219     311.0000       0.3385       0.3144       7.1352      24.5371     333.2011     176.8576      47.7071       0.2564       0.3080       5.8902    2131.1677       2.8290     174.0000    2514.0000
 1013.4600       6.9245       8.6267      14.3336      33.6414      26.5183      37.7098     311.0000       0.3599       0.3367       7.1113      27.3429     329.3769     186.6797      47.7071       0.2087       0.2593       6.0920    2094.5183       2.6412     174.2500    2525.0000
 1013.6124       6.1493       7.3138      11.3455      26.4326      23.5606      42.4438     311.0000       0.3873       0.3650       6.9460      25.0583     325.0064     184.3228      47.7071       0.1998       0.2502       6.1656    2047.6742       2.3847     174.0000    2555.0000
 1013.7648       5.6155       6.8513       9.7923      25.9571      19.8675      50.3335     311.0000       0.3920       0.3699       7.0326      27.0944     306.7048     173.1291      47.7071       0.2490       0.2997       5.9993    2039.6393       1.8895     174.0000    2525.0000
 1013.9172       6.7756       9.7644      18.2271      47.0287      37.3357      26.7840     311.0000       0.3434       0.3195       7.1173      25.2314     332.1085     175.6156      47.7071       0.2932       0.3434       5.5912    2122.8188       2.1428     174.0000    2576.0000
 1014.0696       8.8103      10.9245      21.4122      35.8984      33.2976      30.0322     311.0000       0.3036       0.2782       7.4184      27.1108     356.4195     164.4132      47.7071       0.3108       0.3606       5.1292    2190.9067       2.6608     172.0000    2576.0000
 1014.2220       5.5445       6.4954       9.7227      19.6075      19.7501      50.6327     311.0000       0.3058       0.2805       7.2882      26.4475     371.4431     136.9944      47.7071       0.2563       0.3070       4.8339    2187.1467       3.0045     173.1875    2535.0000
 1014.3744       3.8519       4.3177       5.5205       9.0375       8.8328     113.2140     311.0000       0.3210       0.2963       7.3860      29.9523     356.6926     103.6885      47.7071       0.2881       0.3371       4.6768    2161.1123       2.5059     172.4375    2515.0000
 1014.5268       2.9958       3.6764       4.7808       7.1488       8.1450     122.7745     311.0000       0.3095       0.2844       6.9476      28.9552     338.6642      84.2688      47.7071       0.3297       0.3756       4.5482    2180.7334       2.2836     173.0625    2541.0000
 1014.6792       3.1559       3.8486       4.9892       7.8062       9.2458     108.1570     311.0000       0.2987       0.2732       7.0395      28.7236     342.4884      79.3767      47.7071       0.4062       0.4477       4.5352    2199.1816       2.3503     174.0000    2620.0000
 1014.8316       3.6267       4.5253       6.1383      11.1444      14.8000      67.5674     311.0000       0.3023       0.2769       7.1596      26.4906     326.0990      86.2677      47.7071       0.3067       0.3530       4.6207    2193.1331       2.7175     174.0000    2642.0000
 1014.9840       3.6779       4.4483       5.7388      10.7576      14.1249      70.7970     311.0000       0.3132       0.2882       7.2041      27.4614     341.3958     102.6511      47.7071       0.2752       0.3226       4.7232    2174.4197       2.7187     174.0000    2537.0000
 1015.1364       3.2972       3.8876       5.0542       8.7241      11.7761      84.9175     311.0000       0.3297       0.3053       6.9834      29.9771     328.2842     103.0052      47.7071       0.3489       0.3937       4.6923    2146.2104       2.4072     174.0000    2587.0000
 1015.2888       3.1722       3.3930       4.3544       7.1078       9.1748     108.9944     311.0000       0.3577       0.3344       7.2120      33.8101     343.5811      87.2703      47.7071       0.4182       0.4564       4.6057    2098.2546       2.1979     174.0000    2594.0000
 1015.4412       3.1346       3.4274       4.3993       6.9213       9.3934     106.4576     311.0000       0.3839       0.3615       7.5036      32.9020     324.4601      74.9869      47.7071       0.4379       0.4722       4.5871    2053.4780       2.1027     174.0000    2557.0000
 1015.5936       3.3681       3.9989       5.1440       8.3755      14.1706      70.5687     311.0000       0.3865       0.3642       7.2082      30.8758     307.5243      79.6982      47.7071       0.4863       0.5130       4.6615    2049.0916       2.1456     174.0000    2610.0000
 1015.7460       3.6606       4.4990       5.6851      10.5152      16.5032      60.5944     311.0000       0.3588       0.3355       7.0969      29.2290     308.0706      98.7303      47.7071       0.4397       0.4732       4.7511    2096.4668       2.1283     174.0000    2678.0000
 1015.8984       3.8513       5.0518       6.3099      12.3437      20.2052      49.4922     311.0000       0.3228       0.2981       7.1047      31.1963     333.7474     123.3184      47.7071       0.4253       0.4628       4.8649    2158.0667       2.2124     173.8125    2718.0000
 1016.0508       4.0818       4.7775       6.5642      12.3247      19.1718      52.1600     311.0000       0.3322       0.3079       7.1381      30.8081     360.7900     124.4376      47.7071       0.3588       0.4049       5.0681    2141.9224       2.4648     174.0000    2601.0000
 1016.2032       4.1976       5.1980       6.4943      12.2041      16.9841      58.8786     311.0000       0.3269       0.3024       7.3147      30.8081     383.4621     135.2372      47.7071       0.3245       0.3717       5.3133    2151.0710       2.3651     172.5000    2589.0000
 1016.3556       4.5671       4.5224       5.5843       9.4672      11.9933      83.3802     311.0000       0.2780       0.2517       7.1954      27.8960     375.5405     141.5038      47.7071       0.3383       0.3864       5.3479    2234.6394       2.8186     171.3750    2525.0000
 1016.5080       6.1700       6.5273       8.8432      19.2788      22.0676      45.3152     311.0000       0.1999       0.1708       7.2630      29.7229     342.4884     148.2413      47.7071       0.2120       0.2619       5.0293    2368.2219       3.7353     170.6250    2562.0000
 1016.6604       6.4603      10.1947      11.8084      20.5033      23.2022      43.0994     311.0000       0.1812       0.1514       7.1613      28.7964     338.6642     133.8704      47.7071       0.1641       0.2139       4.4974    2400.1528       4.0313     171.6875    2612.0000
 1016.8128       4.5845       5.5932       7.5856      12.0680      12.1220      82.4945     311.0000       0.2541       0.2270       7.1168      31.4863     353.9611      87.2681      47.7071       0.2181       0.2688       4.0714    2275.4890       2.5869     172.8750    2636.0000
 1016.9652       2.8995       3.0832       3.3750       4.3883       4.3324     230.8165     311.0000       0.3410       0.3171       7.2628      30.5056     359.9705      48.2337      47.7071       0.4069       0.4522       4.0542    2126.8601       1.7766     172.5000    2577.0000
 1017.1176       3.1913       2.8984       3.2465       4.2265       4.4157     226.4668     311.0000       0.3876       0.3653       7.2913      30.2424     367.0726      38.1110      47.7071       0.4102       0.4506       4.5398    2047.2397       1.7261     171.0625    2565.0000
 1017.2700       4.5463       4.9105       5.9201      10.0853      10.8426      92.2288     311.0000       0.3709       0.3480       7.3251      30.6476     387.0131      84.6207      47.7071       0.3472       0.3928       5.2151    2075.7410       2.1677     167.4375    2619.0000
 1017.4224       5.5849       7.0581       8.3661      15.6412      18.6319      53.6713     311.0000       0.3642       0.3411       7.4133      32.4793     406.9536     130.5944      47.7071       0.2502       0.3005       5.7394    2087.2136       2.5599     168.1250    2543.0000
 1017.5748       5.0575       6.1382       7.2178      10.6345      18.4697      54.1426     311.0000       0.3615       0.3383       7.2204      32.4979     340.8495     150.9343      47.7071       0.2346       0.2855       5.8683    2091.7800       2.4325     167.1875    2598.0000
 1017.7272       5.1917       6.0836       7.7190      13.6890      22.2907      44.8617     311.0000       0.3346       0.3104       7.0623      30.7925     380.7305     146.9765      47.7071       0.2736       0.3247       5.6513    2137.9045       2.1789     166.1250    2669.0000
 1017.8796       5.2029       5.0374       5.8370       9.7932      11.6853      85.5779     311.0000       0.2836       0.2576       7.2107      25.6787     371.4431     142.1361      47.7071       0.2500       0.3003       5.3472    2224.9648       2.5306     165.8750    2610.0000
 1018.0320       3.7909       3.8807       4.4855       6.6257       7.0279     142.2900     311.0000       0.2636       0.2368       7.4419      27.5446     328.8306     138.8216      47.7071       0.2418       0.2905       5.1878    2259.2065       2.9761     165.4375    2581.0000
 1018.1844       3.0863       3.1200       3.5932       5.2133       5.5467     180.2888     311.0000       0.2929       0.2672       7.6405      28.8641     353.4147     133.3432      47.7071       0.3197       0.3678       5.2521    2209.1555       2.3405     164.7500    2561.0000
 1018.3368       3.2480       3.3031       3.8191       6.0658       6.3378     157.7829     311.0000       0.3329       0.3087       7.5607      36.1456     365.4337     120.7471      47.7071       0.3837       0.4269       5.3482    2140.6917       1.9015     164.1875    2551.0000
 1018.4892       3.7212       3.7605       4.5079       7.8703       9.6749     103.3601     311.0000       0.3382       0.3141       7.3228      38.7242     356.6926     117.5871      47.7071       0.3837       0.4265       5.3390    2131.7114       1.9421     164.1875    2625.0000
 1018.6416       4.1778       4.2874       5.3153       8.8884      13.2688      75.3647     311.0000       0.3161       0.2913       7.2017      41.9467     392.7494     119.4801      47.7071       0.3081       0.3553       5.2262    2169.4338       2.2048     164.1875    2665.0000
 1018.7940       4.2878       4.1293       4.7567       7.6751      11.5480      86.5950     311.0000       0.2735       0.2471       7.3260      41.1687     374.1747     123.8096      47.7071       0.3102       0.3578       5.0262    2242.3357       2.4042     164.1875    2639.0000
 1018.9464       3.6208       3.6081       4.0721       5.9407       8.3385     119.9251     311.0000       0.2422       0.2147       7.4965      40.3526     379.6378     114.5785      47.7071       0.3159       0.3629       4.7813    2295.8071       2.9084     164.9375    2635.0000
 1019.0988       3.2954       3.2091       3.5147       4.8443       6.8753     145.4479     311.0000       0.2519       0.2247       7.4768      36.0621     374.7210      89.4506      47.7071       0.3172       0.3638       4.6483    2279.1853       2.6230     164.1875    2612.0000
 1019.2512       3.0213       2.8945       3.2462       4.3401       5.3681     186.2874     311.0000       0.2753       0.2489       7.4247      35.8271     406.4073      66.1442      47.7071       0.3008       0.3487       4.7043    2239.2651       2.2944     162.0000    2628.0000
 1019.4036       3.3805       2.9222       3.2834       4.4544       5.3725     186.1320     311.0000       0.2791       0.2529       7.4284      34.2962     402.0368      60.4067      47.7071       0.3746       0.4184       4.9959    2232.6719       2.1455     163.1250    2646.0000
 1019.5560       3.6412       3.3467       3.8296       5.3075       6.3194     158.2430     311.0000       0.2862       0.2603       7.3606      36.5822     402.5831      67.9154      47.7071       0.3846       0.4274       5.4739    2220.5581       2.5803     163.4375    2626.0000
 1019.7084       3.7528       4.1011       4.3566       6.6373       8.0584     124.0943     311.0000       0.3494       0.3257       7.3974      35.1855     357.7852      84.2061      47.7071       0.3122       0.3535       6.1182    2112.5337       3.0888     163.1875    2698.0000
 1019.8608       3.5943       4.2509       5.0285       8.6540      10.7676      92.8709     311.0000       0.4803       0.4614       7.3587      36.1120     402.8563      84.0296      47.7071       0.3944       0.4300       6.7506    1888.7144       2.1858     162.3750    2634.0000
 1020.0132       3.3418       3.3505       3.7522       5.2181       6.2999     158.7324     311.0000       0.5986       0.5840       7.3952      36.1120     474.6967      58.4618      47.7071       0.7312       0.7355       7.1704    1686.3400       1.5162     161.0000    2538.0000
 1020.1656       3.4000       3.1083       3.2789       4.3107       5.1584     193.8580     311.0000       0.5887       0.5737       7.3786      32.0381     515.9434      48.5139      47.7071       0.6421       0.6545       6.8543    1703.3228       1.3501     161.5625    2603.0000
 1020.3180       3.2472       3.2056       3.4114       4.8084       5.5442     180.3672     311.0000       0.4784       0.4594       7.3032      29.4903     557.7365      52.7216      47.7071       0.3676       0.4083       6.0671    1892.0167       1.6163     161.6250    2651.0000
 1020.4704       3.2172       3.1239       3.3620       4.6289       6.1688     162.1068     311.0000       0.3701       0.3472       7.4464      30.0765     573.5797      61.6591      47.7071       0.3695       0.4106       5.1387    2077.0989       1.9969     163.5000    2607.0000
 1020.6228       3.1373       3.0193       3.3811       4.3808       6.5696     152.2162     311.0000       0.3433       0.3194       7.6244      33.7213     481.2524      49.2170      47.7071       0.4302       0.4668       4.7387    2122.9783       2.2228     161.9375    2601.0000
 1020.7752       2.9949       2.9690       3.2531       4.6061       6.0565     165.1126     311.0000       0.3551       0.3316       7.4792      36.0631     434.2693      46.6015      47.7071       0.4084       0.4428       4.7187    2102.8438       2.2919     161.3125    2587.0000
 1020.9276       2.9593       2.8714       3.1031       4.7545       7.1439     139.9803     311.0000       0.3523       0.3287       7.4077      32.7079     365.9800      66.6287      47.7071       0.4084       0.4444       4.8625    2107.6177       2.2711     160.1875    2595.0000
 1021.0800       2.8479       2.7051       2.9204       4.0789       4.9180     203.3360     311.0000       0.3397       0.3157       7.5166      34.7608     433.1767      83.7259      47.7071       0.4456       0.4803       4.9856    2129.1592       2.3516     160.3125    2576.0000
 1021.2324       2.9742       2.9233       3.1797       4.7251       5.5076     181.5677     311.0000       0.3195       0.2948       7.5142      36.3566     347.9516      86.8363      47.7071       0.4414       0.4772       5.0506    2163.5906       2.2385     159.7500    2577.0000
 1021.3848       3.9224       3.8172       4.3388       7.3117      10.1402      98.6178     311.0000       0.2909       0.2651       7.5046      39.7346     367.6189      81.2967      47.7071       0.3829       0.4227       5.0911    2212.6272       2.7109     158.6250    2591.0000
 1021.5372       5.5690       5.7761       7.0027      14.7551      24.1385      41.4276     311.0000       0.2791       0.2529       7.3085      39.3047     390.5641      66.6795      47.7071       0.3330       0.3781       5.1695    2232.7100       2.8499     158.2500    2612.0000
 1021.6896       5.8275       6.0334       6.8737      14.3960      23.9089      41.8255     311.0000       0.2855       0.2595       7.3551      39.9377     389.4715      60.5957      47.7071       0.3316       0.3758       5.3626    2221.7566       3.5542     158.2500    2603.0000
 1021.8420       5.2624       5.4809       6.5020      12.9637      24.1362      41.4316     311.0000       0.3225       0.2979       7.2995      40.5245     396.0273      64.2567      47.7071       0.3483       0.3916       5.6834    2158.5217       3.2955     157.5000    2620.0000
 1021.9944       5.0019       5.0324       5.8199       9.5728      13.1185      76.2281     311.0000       0.3719       0.3491       7.6325      40.2941     382.6426      81.4532      47.7071       0.4234       0.4594       6.0339    2074.0322       2.8508     156.0625    2605.0000
 1022.1468       4.3172       4.7246       4.8903       6.9828       8.4017     119.0233     311.0000       0.4196       0.3985       7.6213      40.6706     440.2788     101.3379      47.7071       0.4343       0.4693       6.2658    1992.5181       2.2538     155.4375    2622.0000
 1022.2992       5.6958       6.3898       7.2815      14.1437      17.7123      56.4581     311.0000       0.4490       0.4289       7.3399      43.3317     383.4621     112.4407      47.7071       0.5027       0.5315       6.3559    1942.2915       2.0514     155.7500    2636.0000
 1022.4516       6.9869       9.7627      13.3912      29.3856      36.3156      27.5364     311.0000       0.4464       0.4263       7.4172      46.3159     411.8704     121.4054      47.7071       0.4277       0.4643       6.3595    1946.6635       2.0793     154.7500    2648.0000
 1022.6040       8.8965      10.9030      14.0522      27.8923      46.3569      21.5718     311.0000       0.4457       0.4255       7.5818      45.1555     440.2788     115.7613      47.7071       0.3784       0.4193       6.3609    1947.9307       2.1196     154.4375    2640.0000
 1022.7564      10.1824      10.9851      14.6057      27.5129      55.2101      18.1126     311.0000       0.4407       0.4204       7.4236      41.7723     466.5019     101.7851      47.7071       0.3541       0.3973       6.2664    1956.3276       2.1133     154.1875    2633.0000
 1022.9088      10.7536      11.5302      13.9609      34.7883      54.0008      18.5182     311.0000       0.4275       0.4067       7.3007      37.6214     501.4661      95.0977      47.7071       0.3642       0.4067       6.1113    1978.9951       1.9442     154.4375    2594.0000
 1023.0612       8.3143       8.4677      10.9499      34.2885      44.5199      22.4619     311.0000       0.4078       0.3863       7.4119      33.1400     409.6852      92.5293      47.7071       0.3639       0.4079       5.9384    2012.6245       2.2043     154.4375    2589.0000
 1023.2136       7.4532       6.8670       8.9437      17.2943      27.0143      37.0175     311.0000       0.3657       0.3427       7.4831      30.2304     412.4167     114.7784      47.7071       0.3971       0.4393       5.7185    2084.5825       2.3565     154.4375    2621.0000
 1023.3660       6.4657       6.9666       8.0750      11.7456      19.9537      50.1161     311.0000       0.3128       0.2878       7.4577      29.6013     416.2410     152.9026      47.7071       0.3230       0.3710       5.4672    2175.0847       3.0620     154.4375    2609.0000
 1023.5184       7.0357       7.6860       9.2777      16.6877      22.1509      45.1450     311.0000       0.2640       0.2372       7.4269      30.0646     328.2842     180.1138      47.7071       0.2403       0.2900       5.1848    2258.5991       3.1789     154.4375    2627.0000
 1023.6708       6.7760       8.5625      11.5965      17.5448      21.3095      46.9275     311.0000       0.2445       0.2171       7.4341      30.6553     338.6642     195.7183      47.7071       0.1668       0.2168       5.0907    2291.8408       3.0737     154.4375    2667.0000
 1023.8232       5.7537       6.0380       7.1670      10.6245      13.0092      76.8687     311.0000       0.2589       0.2319       7.3295      31.9868     394.3884     191.9825      47.7071       0.2181       0.2697       5.1608    2267.3247       2.9528     154.4375    2637.0000
 1023.9756       5.1007       4.9528       5.7951       7.9227       9.4422     105.9073     311.0000       0.2944       0.2688       7.2977      31.5210     338.6642     186.3744      47.7071       0.3062       0.3566       5.3814    2206.5417       2.5440     153.7500    2625.0000
 1024.1280       5.1713       5.2524       5.4642       6.9331       7.8518     127.3588     311.0000       0.2836       0.2576       7.4314      34.5346     371.9894     185.7376      47.7071       0.3937       0.4398       5.4682    2224.9885       2.7605     152.0625    2583.0000
 1024.2804       7.3304       7.6097       9.1595      13.3891      17.6480      56.6637     311.0000       0.2270       0.1989       7.4491      36.0651     370.6237     182.4143      47.7071       0.3279       0.3785       5.3422    2321.8062       3.1862     151.8750    2572.0000
 1024.4328      15.0271      14.9927      17.6367      25.1598      27.0207      37.0087     311.0000       0.1447       0.1136       7.4016      39.3104     321.1822     182.7111      47.7071       0.1577       0.2083       5.0314    2462.5872       5.1784     153.1875    2578.0000
 1024.5852      16.8236      19.7799      19.9917      26.2559      48.1603      20.7640     311.0000       0.1111       0.0788       7.3895      37.3299     354.5074     165.7193      47.7071       0.0749       0.1191       4.7880    2519.9399       7.3936     151.5625    2615.0000
 1024.7376      20.0501      24.5439      26.1345      30.2801      72.2131      13.8479     311.0000       0.0900       0.0569       7.3513      37.1269     317.9043     154.1700      47.7071       0.0760       0.1188       4.6323    2556.1201       6.4398     149.8750    2648.0000
 1024.8900      26.6029      34.2541      38.7434      41.8080      76.2354      13.1173     311.0000       0.0766       0.0430       7.3290      38.9799     316.8116     138.2842      47.7071       0.0493       0.0889       4.5118    2579.0879       8.9207     147.5625    2554.0000
 1025.0424      31.7665      43.3766      67.3385     135.8650     154.9571       6.4534     311.0000       0.0521       0.0177       7.4003      40.5807     316.8116     129.2241      47.7071       0.0459       0.0845       4.3364    2620.8313      11.9967     145.5625    2576.0000
 1025.1948      32.0760      43.5973      51.3427      96.0723     111.6059       8.9601     311.0000       0.0370       0.0020       7.4173      42.7349     319.5432     124.0690      47.7071       0.0605       0.0994       4.1686    2646.6497      17.2254     144.6875    2586.0000
 1025.3472      36.5134      41.3868      52.5446     144.5027     105.4126       9.4865     311.0000       0.0233      -0.0122       7.3568      38.0419     331.8353     107.4994      47.7071       0.0549       0.0927       3.9990    2670.1057      20.8368     144.6875    2594.0000
 1025.4996      39.6211      41.7612      65.9723     199.5255      84.1717      11.8805     311.0000       0.0148      -0.0211       7.3685      38.6498     315.1727      71.2855      47.7071       0.0208       0.0541       3.8507    2684.7764      28.0962     144.6875    2609.0000
 1025.6520      48.9220      47.0414      75.9940     224.3826      51.8572      19.2837     311.0000       0.0215      -0.0141       7.3952      37.6901     315.1727      23.9384      47.7071       0.0021       0.0318       3.9010    2673.3174     338.6133     143.6875    2580.0000
 1025.8044      70.5230      66.0822      97.2304     142.4713      75.8464      13.1845     311.0000       0.0145      -0.0213       7.3575      60.2877     315.4458       2.1496      47.7071      -0.0034       0.0237       4.0920    2685.1235    1088.7296     139.8750    2602.0000
 1025.9568     113.7998      99.0342     344.6544    1477.1169     185.1306       5.4016     311.0000       0.0094      -0.0266       7.3918      82.3725     315.7190      -0.0367      47.7071      -0.0054       0.0209       4.4236    2693.8921    1394.2850     136.1250    2592.0000
 1026.1092     169.1893     243.8064     560.3819     612.5054     293.8496       3.4031     311.0000       0.0094      -0.0266       7.3511     101.8832     316.2654      -0.6948      47.7071      -0.0022       0.0241       4.6365    2693.8530     691.4406     134.9375    2546.0000
 1026.2616     117.7192     322.6762     866.0896    1558.1599     367.0645       2.7243     311.0000       0.0215      -0.0141       7.3312      95.7912     315.7190      -3.0782      47.7071       0.0020       0.0292       4.7756    2673.2229     699.5659     129.8750    2579.0000
 1026.4140     118.0752     230.5845     344.8628     908.4410     192.4960       5.1949     311.0000       0.0301      -0.0052       7.2584      81.8503     315.7190      -4.9562      47.7071       0.0081       0.0360       4.8392    2658.5850     596.4744     125.1250    2657.0000
 1026.5664      96.2444     150.1992     233.3050    1105.7739     175.8230       5.6875     311.0000       0.0336      -0.0016       7.3176      73.4574     316.2654      -6.0608      47.7071       0.0036       0.0316       4.8771    2652.5710     991.9830     118.7500    2692.0000
 1026.7188      88.8933     135.8011     210.3986    1344.1989     169.6536       5.8944     311.0000       0.0308      -0.0045       7.4135      69.5563     316.2654      -5.4266      47.7071      -0.0034       0.0235       4.8554    2657.4131    1014.1838     114.9375    2686.0000
 1026.8712      97.2583     147.5934     243.7808    1370.5752     277.8293       3.5993     311.0000       0.0241      -0.0114       7.3732      69.5224     317.3580      -3.2687      47.7071       0.0032       0.0306       4.7838    2668.8057    1116.2887     107.4375    2601.0000
 1027.0236     108.4593     178.5747     293.3265    1363.0669     377.5391       2.6487     311.0000       0.0210      -0.0146       7.3744      62.2505     317.3580      -2.9478      47.7071       0.0009       0.0278       4.7625    2674.0947    1247.1555     103.7500    2551.0000
 1027.1760     112.5805     210.8346     330.6958    1252.6705     572.2006       1.7476     311.0000       0.0214      -0.0142       7.2702      63.8874     317.3580      -3.1722      47.7071      -0.0025       0.0243       4.7737    2673.4731    1341.4628      93.1875    2534.0000
 1027.3284     118.4289     271.2325     382.3648    1420.2375     882.2927       1.1334     311.0000       0.0283      -0.0070       7.2922      62.6661     317.3580      -3.7184      47.7071       0.0039       0.0316       4.8004    2661.5850     842.1764      81.2500    2563.0000
 1027.4808     117.5105     373.8813     480.0597    1472.8389    1234.9963       0.8097     311.0000       0.0288      -0.0066       7.3661      66.9271     317.3580      -1.8034      47.7071       0.0047       0.0326       4.7355    2660.8076     668.6851      69.4375    2651.0000
 1027.6332     122.7247     373.4483     507.9118    1769.7795    1700.8304       0.5879     311.0000       0.0269      -0.0085       7.3854      64.2345     317.3580      -0.1822      47.7071       0.0032       0.0311       4.6588    2664.0623     632.2235      57.5000    2642.0000
 1027.7856     120.6378     387.1050     506.1018    1660.8983    1420.0342       0.7042     311.0000       0.0234      -0.0122       7.4584      69.9112     317.3580      -0.0632      47.7071      -0.0001       0.0272       4.6199    2670.0486     767.2582      47.5000    2595.0000
 1027.9380     123.6593     375.4481     437.9837    1641.4220    1189.2163       0.8409     311.0000       0.0196      -0.0160       7.3969      66.8659     318.4506      -0.6211      47.7071       0.0028       0.0306       4.6531    2676.4307     703.9681      37.2500    2600.0000
 1028.0904     130.9453     427.8733     567.8012    1718.1625    1360.6942       0.7349     311.0000       0.0154      -0.0204       7.2789      67.6534     318.4506      -0.6323      47.7071       0.0042       0.0319       4.7209    2683.6445    1071.9760      27.6875    2579.0000
 1028.2428     149.2666     479.9134    1009.0071    1767.1416    1530.3325       0.6535     311.0000       0.0084      -0.0277       7.3035      63.8409     318.4506       0.8457      47.7071      -0.0001       0.0270       4.7195    2695.6787    1612.2217      17.7500    2552.0000
 1028.3952     147.4649     352.6082     615.8394    1572.5551    1203.1371       0.8312     311.0000       0.0018      -0.0345       7.4107      68.1405     318.9969       2.0952      47.7071       0.0028       0.0301       4.6597    2707.0007     951.6835       8.9375    2591.0000
 1028.5476     135.8719     319.7136     504.0207    1060.3475     813.9315       1.2286     311.0000       0.0005      -0.0359       7.3890      68.3722     317.9043       1.3564      47.7071       0.0002       0.0273       4.6507    2709.1882     897.1741       3.8125    2591.0000
 1028.7000     133.2080     320.0973     546.2900    1451.5909     962.2041       1.0393     311.0000       0.0077      -0.0284       7.3110      67.0345     317.9043      -1.8456      47.7071      -0.0013       0.0262       4.7669    2696.8201    1176.6409      -1.8125    2609.0000
 1028.8524     140.7081     373.4542     615.3071    1458.7227     828.6575       1.2068     311.0000       0.0137      -0.0221       7.3192      58.7118     317.3580      -3.6929      47.7071       0.0036       0.0312       4.8997    2686.5305    2034.6935      -4.9375    2621.0000
 1029.0048     149.1972     452.5734     702.0981    1616.5626     795.9579       1.2563     311.0000       0.0207      -0.0149       7.3445      54.3110     317.3580      -5.0678      47.7071       0.0012       0.0287       4.9854    2674.5930    1559.9750      -8.8125    2643.0000
 1029.1572     150.7377     478.9824     742.5227    1477.2651     698.9228       1.4308     311.0000       0.0192      -0.0165       7.4052      53.1767     317.9043      -3.5117      47.7071       0.0000       0.0274       4.9411    2677.1677    1209.3135     -11.5625    2639.0000
 1029.3096     154.0806     531.3494     730.2708    1505.1305     733.9161       1.3626     311.0000       0.0151      -0.0208       7.3969      54.5658     318.4506      -2.0804      47.7071       0.0047       0.0323       4.8247    2684.2563     919.2338     -11.5625    2605.0000
 1029.4620     156.8128     540.0441     785.0170    1542.0896     677.5253       1.4760     311.0000       0.0088      -0.0272       7.3388      56.4619     318.4506      -1.2257      47.7071       0.0012       0.0288       4.7260    2694.8901     711.6271     -13.5000    2576.0000
 1029.6144     161.3336     555.0411     767.1966    1405.6956     667.0964       1.4990     311.0000       0.0097      -0.0263       7.3497      53.6253     317.9043      -3.6285      47.7071       0.0058       0.0333       4.7315    2693.4348     890.8131     -16.0000    2600.0000
 1029.7668     161.8231     513.9572     729.8149    1260.8107     690.4872       1.4483     311.0000       0.0088      -0.0272       7.4247      53.7457     316.8116      -4.5769      47.7071      -0.0012       0.0261       4.7976    2694.8801    1275.7764     -18.0000    2567.0000
 1029.9192     159.0436     442.3144     803.7435    1225.7657     806.1599       1.2404     311.0000       0.0053      -0.0309       7.4015      49.5880     316.8116      -4.2043      47.7071      -0.0008       0.0258       4.8347    2700.9304    2961.6902     -18.0625    2531.0000
 1030.0716     162.4573     439.8458     789.6560    1140.2926     989.0355       1.0111     311.0000      -0.0007      -0.0371       7.3910      48.0000     316.8116      -2.3806      47.7071      -0.0033       0.0232       4.8280    2711.1455    2552.8459     -18.1875    2548.0000
 1030.2240     164.8487     423.2094     809.6246     965.3127    1008.6639       0.9914     311.0000       0.0011      -0.0352       7.4070      48.2317     316.2654      -2.9464      47.7071       0.0005       0.0272       4.8288    2708.1331    1928.1018     -17.7500    2584.0000
 1030.3764     165.3208     424.6252     855.5038    1163.8744    1147.3103       0.8716     311.0000      -0.0010      -0.0374       7.3076      51.4795     316.2654      -1.6546      47.7071      -0.0034       0.0237       4.7735    2711.7290    1537.1527     -19.3125    2653.0000
 1030.5288     164.7538     410.8564     917.7613    1343.4427    1212.6422       0.8246     311.0000      -0.0065      -0.0432       7.3411      54.2590     315.7190      -0.0081      47.7071       0.0083       0.0369       4.6792    2721.2000    1127.9115     -20.6250    2684.0000
 1030.6812     169.2603     418.2873    1016.6583    1379.0919    1201.7146       0.8321     311.0000      -0.0125      -0.0493       7.3879      54.1419     316.8116       2.0533      47.7071       0.0052       0.0341       4.6011    2731.3362    1138.4109     -20.1875    2620.0000
 1030.8336     165.6056     407.7454     928.9016    1662.8120    1193.5303       0.8379     311.0000      -0.0149      -0.0518       7.3658      48.6611     315.7190       2.1334      47.7071       0.0132       0.0427       4.5759    2735.5381    1448.5350     -19.8750    2576.0000
 1030.9860     164.6063     402.8026     897.7421    1645.9359    1297.9174       0.7705     311.0000      -0.0181      -0.0551       7.3568      45.8816     316.5385       2.8982      47.7071       0.0119       0.0411       4.5673    2740.9646    2283.0930     -20.7500    2589.0000
 1031.1384     169.6387     424.9149     909.7767    1633.7354    1319.7449       0.7577     311.0000      -0.0163      -0.0533       7.4077      44.8363     316.8116       2.0783      47.7071      -0.0037       0.0241       4.5995    2737.9321    2577.3523     -20.0625    2613.0000
 1031.2908     175.4507     458.1887     927.8552    1572.3062    1379.2957       0.7250     311.0000      -0.0124      -0.0492       7.4445      50.0663     316.8116       1.9195      47.7071       0.0043       0.0329       4.6390    2731.1194    2462.6223     -20.9375    2571.0000
 1031.4432     176.4821     521.6653    1051.4092    1586.4556    1569.6671       0.6371     311.0000      -0.0059      -0.0424       7.4666      52.2622     315.7190       1.6878      47.7071       0.0096       0.0386       4.6852    2720.0100    1890.2836     -21.2500    2545.0000
 1031.5956     174.5370     504.9133     873.1309    1558.7341    1632.7877       0.6124     311.0000       0.0019      -0.0344       7.3549      52.0349     315.7190       0.5121      47.7071       0.0080       0.0371       4.7346    2706.7327    1925.9496     -21.3125    2587.0000
 1031.7480     179.6400     521.2558     843.6419    1533.8636    1367.5704       0.7312     311.0000       0.0044      -0.0318       7.3514      53.8705     316.8116      -0.1748      47.7071       0.0055       0.0339       4.7201    2702.5032    1341.5809     -21.3125    2593.0000
 1031.9004     178.7009     473.9561     942.0579    1304.9918    1430.4663       0.6991     311.0000       0.0022      -0.0340       7.3754      57.5093     315.1727      -0.6552      47.7071       0.0009       0.0291       4.6344    2706.1780    1136.0326     -21.3125    2581.0000
 1032.0528     175.4353     432.9900     943.6865    1308.2502    1367.3153       0.7314     311.0000      -0.0084      -0.0451       7.4297      63.4098     315.1727       1.8542      47.7071       0.0099       0.0386       4.5285    2724.4111     826.9643     -21.3125    2583.0000
 1032.2052     177.9776     420.5015     903.4785    1242.5348    1239.6655       0.8067     311.0000      -0.0131      -0.0499       7.4275      62.9232     315.1727       2.5697      47.7071       0.0069       0.0357       4.4947    2732.3608     751.9323     -21.3125    2588.0000
 1032.3576     178.1813     413.4772     799.7124    1104.4232    1063.9030       0.9399     311.0000      -0.0106      -0.0474       7.4109      62.6910     315.7190       2.1980      47.7071       0.0080       0.0371       4.5583    2728.1733     705.9307     -22.3125    2558.0000
 1032.5100     177.0939     392.4953     820.4827    1154.7809    1028.8889       0.9719     311.0000      -0.0079      -0.0446       7.3633      59.4492     315.7190       1.3952      47.7071       0.0133       0.0430       4.5717    2723.5576     730.7421     -21.8125    2588.0000
 1032.6624     181.7997     409.0772     861.1023    1109.5315     992.0129       1.0081     311.0000      -0.0028      -0.0392       7.2861      56.9014     315.1727       0.8309      47.7071       0.0048       0.0341       4.5998    2714.7419     759.7355     -23.3125    2607.0000
 1032.8148     183.4723     436.9999     906.0113     947.5082     921.9778       1.0846     311.0000      -0.0014      -0.0378       7.3433      56.1655     314.6264       0.9046      47.7071       0.0103       0.0400       4.5910    2712.3860     856.6812     -23.6875    2598.0000
 1032.9672     181.7894     433.8505     749.4900     859.8223     719.7344       1.3894     311.0000       0.0028      -0.0334       7.3786      55.5914     314.8995      -0.7796      47.7071       0.0106       0.0403       4.6005    2705.1362     915.8475     -24.6875    2589.0000
 1033.1196     169.9135     395.3958     737.5399     976.8842     768.1744       1.3018     311.0000      -0.0031      -0.0395       7.4171      57.0410     315.1727      -0.2172      47.7071       0.0067       0.0357       4.5313    2715.2488    1266.2660     -24.0000    2559.0000
 1033.2720     171.4282     405.2677     840.2079    1121.6730     844.2463       1.1845     311.0000       0.0006      -0.0357       7.4674      59.6799     314.6264      -1.4279      47.7071       0.0099       0.0395       4.5557    2708.9373    1471.9010     -25.5625    2564.0000
 1033.4244     171.5664     436.7421     853.8693    1179.6935     873.0151       1.1455     311.0000       0.0030      -0.0333       7.4390      64.7756     314.6264      -1.0679      47.7071       0.0069       0.0357       4.5634    2704.9524    1302.0699     -25.2500    2547.0000
 1033.5768     169.9511     407.9940     713.9783    1158.1603     745.5575       1.3413     311.0000       0.0113      -0.0246       7.4499      66.1578     315.1727      -2.3541      47.7071       0.0035       0.0321       4.6028    2690.6650    1174.9915     -26.8125    2562.0000
 1033.7292     177.6336     348.9368     691.4889    1111.8646     676.7219       1.4777     311.0000       0.0119      -0.0240       7.4673      64.4869     314.8995      -2.3229      47.7071       0.0101       0.0385       4.5733    2689.5898    1062.9723     -27.4375    2567.0000
 1033.8816     181.3387     419.2553     880.4661    1064.5852     846.5588       1.1813     311.0000       0.0066      -0.0295       7.5032      63.8150     314.6264      -0.0772      47.7071       0.0100       0.0390       4.5434    2698.7556    1317.8748     -27.8750    2569.0000
 1034.0340     190.9288     527.5003    1059.0410    1206.9709    1228.8450       0.8138     311.0000       0.0012      -0.0351       7.4149      62.6045     314.6264       2.5036      47.7071       0.0027       0.0312       4.5524    2707.9207    1876.2063     -29.1875    2551.0000
 1034.1864     182.9240     477.4732    1047.8501    1069.5245    1318.9138       0.7582     311.0000       0.0018      -0.0345       7.3292      60.3840     312.9874       3.4473      47.7071       0.0001       0.0285       4.6011    2706.9990    1915.7782     -30.8125    2589.0000
 1034.3388     183.9235     432.5951     882.5162    1012.0945    1323.7399       0.7554     311.0000       0.0056      -0.0306       7.3810      52.9815     313.5338       2.5752      47.7071       0.0095       0.0388       4.6640    2700.4429    1307.8247     -31.1250    2581.0000
 1034.4912     181.9845     420.5124     943.2382    1116.1193    1233.0785       0.8110     311.0000       0.0114      -0.0246       7.4715      45.0744     312.9874       0.2365      47.7071       0.0173       0.0468       4.7460    2690.5632    1081.0283     -31.1250    2585.0000
 1034.6436     181.1458     417.4697     841.7910    1163.5798    1068.5594       0.9358     311.0000       0.0129      -0.0229       7.4881      47.0191     311.3485      -0.8543      47.7071       0.0003       0.0284       4.7867    2687.8667    1218.3838     -31.1875    2584.0000
 1034.7960     177.7218     383.6721     844.4093    1128.6908    1049.0636       0.9532     311.0000       0.0167      -0.0190       7.4106      48.9830     310.8022      -2.0189      47.7071      -0.0017       0.0259       4.7979    2681.3958    1754.9700     -31.4375    2563.0000
 1034.9484     173.5124     377.0457     893.9048    1171.6931    1091.4578       0.9162     311.0000       0.0209      -0.0147       7.4165      57.3533     311.3485      -1.9102      47.7071       0.0025       0.0305       4.7805    2674.2996    2251.5227     -32.8125    2565.0000
 1035.1008     170.1041     378.9663     844.5234    1112.1523     971.7793       1.0290     311.0000       0.0247      -0.0108       7.4038      59.3000     311.3485      -1.4372      47.7071       0.0078       0.0364       4.7444    2667.7966    1980.1024     -34.3750    2565.0000
 1035.2532     167.2342     367.0601     842.8033    1089.1283     970.4743       1.0304     311.0000       0.0259      -0.0095       7.3210      63.5628     311.8948      -0.8504      47.7071       0.0058       0.0346       4.6763    2665.6414    1469.1743     -36.3125    2565.0000
 1035.4056     167.3181     364.0941     866.7806    1166.8162     989.5733       1.0105     311.0000       0.0258      -0.0097       7.3256      62.6363     311.8948      -0.5524      47.7071       0.0121       0.0417       4.6081    2665.9312    1224.0919     -36.8750    2569.0000
 1035.5580     164.3773     354.1932     865.1738    1244.4706     962.5086       1.0390     311.0000       0.0274      -0.0080       7.4656      62.3920     312.7143      -0.4478      47.7071       0.0108       0.0401       4.5884    2663.1965    1248.7977     -38.2500    2572.0000
 1035.7104     163.2204     342.2138     887.3439    1372.4000    1125.5554       0.8885     311.0000       0.0326      -0.0026       7.4636      60.1112     312.4411      -0.5369      47.7071       0.0078       0.0367       4.6238    2654.2261    1051.1786     -38.9375    2569.0000
 1035.8628     166.7812     358.7509     993.4814    1495.7831    1250.6174       0.7996     311.0000       0.0328      -0.0023       7.3643      63.8111     312.7143       0.7207      47.7071       0.0020       0.0301       4.6173    2653.8359     898.9238     -40.4375    2545.0000
 1036.0152     177.5509     389.8488    1202.3353    1666.6600    1466.8066       0.6818     311.0000       0.0315      -0.0037       7.3832      60.9507     312.4411       1.2431      47.7071       0.0062       0.0349       4.6283    2656.0696     745.8587     -40.8750    2543.0000
 1036.1676     177.1294     397.4421    1258.8873    1680.7878    1564.5308       0.6392     311.0000       0.0285      -0.0069       7.4379      57.9237     312.7143       1.0679      47.7071       0.0085       0.0369       4.7080    2661.3416     798.7163     -40.8750    2565.0000
 1036.3200     176.0771     389.3352    1245.7213    1637.2894    1615.5983       0.6190     311.0000       0.0264      -0.0090       7.4026      48.4616     312.9874       0.1352      47.7071       0.0065       0.0348       4.8606    2664.9312    1137.8632     -40.8750    2541.0000
 1036.4724     180.5495     417.6092    1321.2754    1592.6096    1619.7451       0.6174     311.0000       0.0225      -0.0130       7.3677      39.5704     314.0800      -0.2794      47.7071      -0.0016       0.0255       4.9930    2671.4873    2133.2156     -41.5000    2554.0000
 1036.6248     187.6000     464.1989    1448.5875    1500.5490    1478.3055       0.6765     311.0000       0.0175      -0.0182       7.3170      32.1339     314.0800      -1.0657      47.7071      -0.0016       0.0250       5.0268    2680.0425    3942.3977     -42.5625    2564.0000
 1036.7772     193.8294     518.7660    1600.4568     975.3846    1144.1567       0.8740     311.0000       0.0104      -0.0256       7.3850      27.6320     314.0800      -1.7142      47.7071      -0.0078       0.0177       4.9681    2692.2688    4175.6831     -44.2500    2548.0000
 1036.9296     190.8451     520.9003    1485.7180    1387.4618    1324.1296       0.7552     311.0000      -0.0029      -0.0394       7.4961      24.7106     314.0800       0.7298      47.7071      -0.0054       0.0197       4.8850    2714.9365    4258.4766     -45.0000    2567.0000
 1037.0820     187.8389     551.3557    1385.4570    1357.7606    1118.3865       0.8941     311.0000      -0.0042      -0.0407       7.4439      26.6963     314.0800       0.9193      47.7071      -0.0078       0.0173       4.8975    2717.2224    4219.9775     -46.6250    2547.0000
 1037.2344     181.0968     487.8456     996.3535    1080.4458     829.7559       1.2052     311.0000       0.0012      -0.0351       7.3603      29.0853     314.0800       0.7136      47.7071      -0.0080       0.0172       4.9654    2707.9143    4256.3345     -47.3125    2544.0000
 1037.3868     168.1155     365.3857     849.8689    1017.0179     624.6992       1.6008     311.0000       0.0098      -0.0262       7.3717      34.6650     312.9874      -0.4041      47.7071      -0.0020       0.0239       4.9571    2693.1968    3068.6035     -47.7500    2573.0000
 1037.5392     177.7378     397.3493    1121.7729    1299.3434     934.1238       1.0705     311.0000       0.0173      -0.0184       7.4301      40.5544     312.9874      -0.2813      47.7071      -0.0056       0.0205       4.9250    2680.3435    2555.6899     -49.2500    2567.0000
 1037.6916     188.3440     441.4510    1206.9795    1321.2070    1144.1517       0.8740     311.0000       0.0192      -0.0165       7.4581      45.0671     312.9874       1.2655      47.7071      -0.0010       0.0257       4.8346    2677.1692    2103.4592     -50.5625    2568.0000
 1037.8440     186.6479     416.6100     978.9808    1186.0779     940.5771       1.0632     311.0000       0.0242      -0.0113       7.4527      52.2265     313.5338       1.4768      47.7071       0.0099       0.0381       4.8156    2668.6423    1688.5486     -50.6250    2577.0000
 1037.9964     188.8826     422.5140     924.2292     933.6548     871.5286       1.1474     311.0000       0.0190      -0.0166       7.4514      52.1931     312.9874       3.3143      47.7071       0.0043       0.0325       4.7215    2677.4294    1487.4019     -50.6250    2587.0000
 1038.1488     190.3721     384.1664     950.3590     850.1724     867.1744       1.1532     311.0000       0.0126      -0.0233       7.4524      55.6083     313.5338       7.6180      47.7071       0.0057       0.0342       4.7084    2688.4507    1328.4152     -50.6250    2553.0000
 1038.3012     193.5523     438.0220     912.9219     870.5206     886.6170       1.1279     311.0000       0.0062      -0.0300       7.4697      51.2076     313.5338       9.3670      47.7071       0.0100       0.0389       4.6482    2699.4373    1503.6349     -50.6250    2571.0000
 1038.4536     189.9759     393.4655     683.4129     768.3307     554.5441       1.8033     311.0000       0.0051      -0.0310       7.4479      52.4562     312.9874       8.5404      47.7071       0.0045       0.0331       4.6427    2701.2087    1483.8479     -50.6250    2562.0000
 1038.6060     188.2082     356.7897     659.7770     620.3145     580.5755       1.7224     311.0000       0.0096      -0.0264       7.3824      53.5615     312.9874       3.4432      47.7071       0.0013       0.0301       4.6285    2693.6238    1360.5471     -50.8750    2580.0000
 1038.7584     206.3098     614.2147    1579.2944     594.9976     553.6259       1.8063     311.0000       0.0172      -0.0186       7.4004      59.3286     312.9874      -0.0799      47.7071       0.0119       0.0417       4.6702    2680.6284    1365.3324     -50.6250    2569.0000
 1038.9108     223.6483     537.0583    1862.0712    1378.9377    1248.1379       0.8012     311.0000       0.0192      -0.0165       7.4119      58.5765     313.8069      -0.3228      47.7071       0.0128       0.0429       4.6625    2677.1948    1281.7311     -50.6250    2536.0000
 1039.0632     213.4762     414.0254    1091.0433    1027.3911     784.5621       1.2746     311.0000       0.0159      -0.0199       7.4762      56.2889     313.5338       0.7205      47.7071       0.0111       0.0407       4.5750    2682.7590    1292.8136     -50.6250    2551.0000
 1039.2156     178.1650     287.2790     740.0639     722.8993     454.2079       2.2016     311.0000       0.0129      -0.0230       7.5023      53.6147     313.5338       2.1946      47.7071       0.0110       0.0409       4.5243    2688.0161    1507.5479     -52.8750    2561.0000
 1039.3680     142.4820     224.6785     539.8236     593.9382     327.9101       3.0496     311.0000       0.0107      -0.0253       7.4759      54.8115     314.0800       3.1221      47.7071       0.0096       0.0394       4.5376    2691.7158    1351.8937     -53.6875    2544.0000
 1039.5204     156.1748     241.2846     613.2287    1011.3163     488.9637       2.0451     311.0000       0.0101      -0.0258       7.4175      55.9410     314.0800       2.7893      47.7071       0.0091       0.0388       4.5840    2692.6455    1622.1243     -53.3125    2569.0000
 1039.6728     180.4718     315.3729     875.1808    1088.5319     786.2283       1.2719     311.0000       0.0112      -0.0248       7.4991      57.9671     314.0800       1.3587      47.7071       0.0131       0.0431       4.6336    2690.8655    1510.8069     -53.5625    2568.0000
 1039.8252     197.1579     426.3148    1141.9172    1262.2612    1013.3510       0.9868     311.0000       0.0134      -0.0224       7.5667      58.6634     314.0800      -0.0403      47.7071       0.0061       0.0351       4.6314    2687.0166    1497.8170     -53.0625    2553.0000
 1039.9776     197.4947     512.9568    1399.8544    1607.1406    1353.9186       0.7386     311.0000       0.0196      -0.0161       7.5897      57.0954     314.6264      -1.0962      47.7071       0.0054       0.0345       4.6287    2676.5598    1408.4387     -52.3125    2583.0000
 1040.1300     196.2134     531.4651    1391.2323    1473.1624    1294.2117       0.7727     311.0000       0.0243      -0.0112       7.5789      53.1344     315.1727      -1.7722      47.7071       0.0096       0.0386       4.6200    2668.4399    1366.3094     -53.0625    2555.0000
 1040.2824     177.6590     428.5196     947.7396     986.3810     822.7280       1.2155     311.0000       0.0277      -0.0077       7.4942      49.9343     315.7190      -2.4149      47.7071       0.0077       0.0369       4.6354    2662.6646    1506.1436     -54.6875    2560.0000
 1040.4348     162.9610     334.4528     681.8768     666.9272     553.5411       1.8066     311.0000       0.0272      -0.0082       7.3989      50.8467     316.2654      -2.5961      47.7071       0.0105       0.0398       4.6513    2663.5376    1230.1495     -54.2500    2557.0000
 1040.5872     160.7419     299.1944     662.0314     697.8395     523.8715       1.9089     311.0000       0.0216      -0.0140       7.4048      51.3632     316.2654      -1.2701      47.7071       0.0060       0.0353       4.6281    2673.0786    1162.4061     -54.5000    2572.0000
 1040.7396     154.2024     313.1319     748.2350     785.1977     595.5333       1.6792     311.0000       0.0167      -0.0190       7.4758      53.0163     317.3580       0.3562      47.7071       0.0086       0.0382       4.6294    2681.3716    1061.1774     -53.6875    2583.0000
 1040.8920     166.8096     338.1776     989.5869    1053.5948     800.0809       1.2499     311.0000       0.0184      -0.0173       7.4721      55.7566     317.3580       0.8531      47.7071       0.0102       0.0397       4.6993    2678.6050    1355.6407     -51.6875    2577.0000
 1041.0444     178.2263     411.9415    1204.2516    1313.3960     970.0550       1.0309     311.0000       0.0247      -0.0107       7.4798      58.8341     317.9043       1.6649      47.7071       0.0111       0.0405       4.7593    2667.7112    1756.2939     -52.3125    2564.0000
 1041.1968     191.0704     408.8538    1324.8698    1457.4197    1079.8104       0.9261     311.0000       0.0314      -0.0038       7.4458      59.1828     317.9043       4.5424      47.7071       0.0046       0.0330       4.7615    2656.3247    2335.6482     -51.5625    2556.0000
 1041.3492     197.7580     387.5071    1226.4154    1458.8730     876.7171       1.1406     311.0000       0.0298      -0.0055       7.4333      56.1718     317.9043      13.4685      47.7071       0.0053       0.0339       4.6760    2658.9932    1277.8049     -52.0000    2539.0000
 1041.5016     204.2320     386.8983    1204.3412    1403.9901     896.2014       1.1158     311.0000       0.0255      -0.0100       7.4961      53.9675     318.4506      11.6544      47.7071       0.0080       0.0369       4.6301    2666.4338    1191.2300     -51.8125    2545.0000
 1041.6540     206.0644     443.4407    1332.6956    1338.6172    1125.8213       0.8882     311.0000       0.0204      -0.0152       7.5364      50.3447     318.9969       7.4043      47.7071       0.0051       0.0341       4.6386    2675.1140    1311.0696     -50.6250    2572.0000
 1041.8064     199.5868     463.3551    1220.9478    1217.7261    1111.2444       0.8999     311.0000       0.0164      -0.0194       7.5206      48.5265     319.2701      -3.1297      47.7071       0.0064       0.0353       4.6509    2682.0354    2098.0063     -50.6250    2585.0000
 1041.9588     185.0427     416.3006     934.9107     919.7479     883.9052       1.1313     311.0000      -0.0009      -0.0373       7.5233      45.6271     319.5432      -9.1579      47.7071       0.0037       0.0327       4.4938    2711.5327    1515.4086     -50.6250    2580.0000
 1042.1112     177.1569     354.0295     773.4653     819.6215     710.3202       1.4078     311.0000      -0.0199      -0.0570       7.5858      48.0918     319.8164      -7.7233      47.7071       0.0133       0.0432       4.2802    2744.1006     847.9485     -50.6250    2553.0000
 1042.2636     170.2670     342.7870     597.4443     687.0980     564.2468       1.7723     311.0000      -0.0244      -0.0617       7.5918      49.2684     320.0895      -7.9327      47.7071       0.0156       0.0464       4.1607    2751.7847     510.6886     -50.6250    2581.0000
 1042.4160     174.5698     271.7627     510.4532     698.1017     519.0507       1.9266     311.0000      -0.0141      -0.0510       7.5317      48.6883     320.0895      -2.1052      47.7071       0.0133       0.0438       4.2018    2734.1584     504.3466     -50.6250    2611.0000
 1042.5684     178.8893     289.3304     532.2726     617.5829     457.3958       2.1863     311.0000       0.0028      -0.0335       7.5599      49.8464     320.0895      -0.5610      47.7071       0.0150       0.0458       4.2890    2705.1929     499.7538     -50.6250    2586.0000
 1042.7208     189.2661     315.2737     613.2047     683.2782     502.5551       1.9898     311.0000       0.0060      -0.0302       7.5484      53.5329     320.3627      15.3298      47.7071       0.0130       0.0433       4.3326    2699.7620     659.0891     -50.6250    2585.0000
 1042.8732     182.5570     417.6733     758.2930     829.3336     596.0047       1.6778     311.0000       0.0122      -0.0237       7.5831      52.3800     320.6359      15.0697      47.7071       0.0091       0.0391       4.3960    2689.1536     665.7042     -50.6250    2627.0000
 1043.0256     174.2242     344.9511     662.0291     754.3965     502.4189       1.9904     311.0000       0.0101      -0.0259       7.5632      48.7834     320.6359      12.1200      47.7071       0.0116       0.0416       4.4434    2692.7983     683.7000     -50.6250    2627.0000
 1043.1780     159.7833     294.9575     560.6066     691.3928     418.9076       2.3872     311.0000       0.0163      -0.0195       7.5451      40.4113     320.6359      -4.5981      47.7071       0.0131       0.0432       4.5430    2682.1292     852.0250     -50.6250    2643.0000
 1043.3304     180.8226     364.7984     804.9260    1072.9718     571.1996       1.7507     311.0000       0.0156      -0.0202       7.5587      44.0000     321.1822      -3.8819      47.7071       0.0086       0.0380       4.6280    2683.2764     945.3986     -50.6250    2601.0000
 1043.4828     210.5088     468.5492    1160.3433    1352.3375     882.4560       1.1332     311.0000       0.0191      -0.0166       7.5762      47.8283     321.1822      -3.2256      47.7071      -0.0007       0.0275       4.7172    2677.4153    1419.2072     -50.6250    2593.0000
 1043.6352     207.0570     442.8171    1266.3656    1551.6730    1057.3080       0.9458     311.0000       0.0144      -0.0215       7.6211      49.0695     321.7285       0.6974      47.7071       0.0126       0.0416       4.7529    2685.4368    1410.3450     -50.6250    2585.0000
 1043.7876     197.4825     410.1635    1248.0503    1615.4242    1089.2224       0.9181     311.0000       0.0094      -0.0266       7.6541      44.5815     322.2748       2.3048      47.7071       0.0099       0.0389       4.7577    2693.8701    2583.6519     -50.6250    2572.0000
 1043.9400     202.2721     401.9985    1318.8766    1792.0984    1256.3964       0.7959     311.0000      -0.0009      -0.0373       7.6050      40.3219     322.2748       3.2604      47.7071       0.0017       0.0301       4.6913    2711.6230    2278.9253     -50.6250    2601.0000
 1044.0924     200.6221     378.8738    1183.6292    1838.9213    1225.5063       0.8160     311.0000      -0.0063      -0.0429       7.6290      38.8490     322.5479       1.5945      47.7071       0.0060       0.0345       4.6227    2720.7239    1905.9811     -50.6250    2609.0000
 1044.2448     209.4398     456.5407    1542.0636    1858.3108    1517.4458       0.6590     311.0000      -0.0061      -0.0427       7.6665      40.0630     322.8211      -0.8881      47.7071       0.0030       0.0313       4.5851    2720.4871    1941.9951     -50.6250    2607.0000
 1044.3972     210.1434     483.1225    1690.0610    1853.5817    1596.2166       0.6265     311.0000      -0.0020      -0.0384       7.6039      37.6294     323.3674       9.6273      47.7071       0.0079       0.0365       4.6051    2713.4402    1935.6010     -50.6250    2608.0000
 1044.5496     200.8314     477.3066    1394.9714    1577.0927    1165.2250       0.8582     311.0000       0.0013      -0.0351       7.5499      37.0761     323.3674      20.1304      47.7071       0.0087       0.0372       4.6567    2707.8433    1870.1888     -50.6250    2594.0000
 1044.7020     183.1351     364.6454    1163.4319    1314.8379     821.7582       1.2169     311.0000       0.0022      -0.0340       7.5892      35.1401     323.3674      21.5237      47.7071      -0.0025       0.0250       4.7232    2706.1731    1943.4943     -50.6250    2605.0000
 1044.8544     176.2374     318.9414     777.4967    1016.1378     485.5847       2.0594     311.0000       0.0102      -0.0258       7.6381      36.1781     323.3674       9.1300      47.7071       0.0012       0.0288       4.8282    2692.5830    2486.3613     -50.6250    2613.0000
 1045.0068     176.0732     335.8248     789.7520     721.4563     408.5871       2.4475     311.0000       0.0116      -0.0243       7.6364      37.1946     323.9137      15.6300      47.7071       0.0061       0.0342       4.8559    2690.1550    2001.5557     -50.6250    2576.0000
 1045.1592     183.2104     502.7581    1307.9673    1293.2439     804.1929       1.2435     311.0000       0.0166      -0.0192       7.5876      36.1120     323.9137      15.7216      47.7071       0.0025       0.0303       4.9069    2681.6729    1801.4470     -50.6250    2573.0000
 1045.3116     188.9318     522.2177    1783.8510    1784.4299    1443.1221       0.6929     311.0000       0.0179      -0.0178       7.6385      35.7450     323.3674      15.4629      47.7071       0.0031       0.0306       4.9754    2679.3582    2029.9807     -50.6250    2619.0000
 1045.4640     202.3063     531.3570    1696.8711    1690.9409    1308.4880       0.7642     311.0000       0.0214      -0.0141       7.5940      30.4880     323.3674      -2.6004      47.7071      -0.0003       0.0268       5.0520    2673.3457    2512.3420     -50.6250    2594.0000
 1045.6164     202.1742     476.8664    1699.1083    1746.1414    1196.8225       0.8355     311.0000       0.0073      -0.0288       7.5402      32.0339     322.2748      -1.5674      47.7071       0.0000       0.0267       4.9118    2697.5444    2689.1270     -50.6250    2611.0000
 1045.7688     201.2168     420.5511    1715.9741    1797.5876    1227.1639       0.8149     311.0000      -0.0088      -0.0454       7.5929      30.3709     321.1822       0.2532      47.7071      -0.0024       0.0242       4.6966    2724.9814    2278.7629     -50.6250    2596.0000
 1045.9212     197.2154     385.4160    1717.1965    1897.0034    1349.7115       0.7409     311.0000      -0.0183      -0.0554       7.6733      31.9600     320.6359       1.2696      47.7071      -0.0040       0.0228       4.5419    2741.3464    2056.2139     -51.5000    2599.0000
 1046.0736     197.5057     374.7462    1797.3306    1905.6644    1480.3932       0.6755     311.0000      -0.0208      -0.0579       7.7075      30.5941     320.6359       0.0405      47.7071       0.0060       0.0340       4.4819    2745.4866    1589.8286     -51.5000    2634.0000
 1046.2260     196.3735     379.9153    1708.7881    1822.5238    1442.8035       0.6931     311.0000      -0.0228      -0.0600       7.6212      30.5751     320.6359      -0.5760      47.7071       0.0104       0.0393       4.4208    2749.0266    1203.2029     -51.1250    2625.0000
 1046.3784     195.9346     383.3546    1633.2467    1725.6465    1438.8954       0.6950     311.0000      -0.0263      -0.0636       7.5904      37.7525     320.6359      -1.0397      47.7071       0.0076       0.0371       4.3167    2755.0007     942.3534     -50.6875    2653.0000
 1046.5308     189.6626     400.6956    1526.6541    1613.2294    1351.1763       0.7401     311.0000      -0.0262      -0.0635       7.6797      38.9704     321.1822      -0.3419      47.7071       0.0117       0.0419       4.2528    2754.7568     785.1660     -50.6250    2664.0000
 1046.6832     189.5810     422.3002    1317.0891    1497.0397    1197.9541       0.8348     311.0000      -0.0273      -0.0647       7.6609      42.5053     320.6359       0.6561      47.7071       0.0107       0.0410       4.2472    2756.7622     849.6516     -50.6250    2608.0000
 1046.8356     188.1982     425.2328    1063.6853    1281.9111    1048.0144       0.9542     311.0000      -0.0225      -0.0597       7.5921      40.6405     320.6359       0.3035      47.7071       0.0111       0.0413       4.3380    2748.4355     851.3738     -50.0000    2618.0000
 1046.9880     183.8006     417.5334     956.5894    1073.4904     867.9768       1.1521     311.0000      -0.0137      -0.0505       7.6097      38.2278     320.6359      -1.6553      47.7071       0.0181       0.0485       4.4496    2733.3706     953.5894     -46.3750    2641.0000
 1047.1404     182.6046     408.1614     921.3507    1167.9869     881.4694       1.1345     311.0000      -0.0124      -0.0492       7.5619      36.6064     320.6359      -1.7614      47.7071       0.0054       0.0351       4.4676    2731.2004    1002.6901     -45.2500    2609.0000
 1047.2928     189.9759     408.8500     851.8901    1093.2319     797.8762       1.2533     311.0000      -0.0167      -0.0537       7.4991      34.7556     320.0895      -0.2902      47.7071       0.0170       0.0475       4.4270    2738.5576    1182.3114     -43.7500    2592.0000
 1047.4452     185.7456     380.4208     872.9290    1216.9298     862.8234       1.1590     311.0000      -0.0217      -0.0588       7.5044      38.7359     320.0895       1.8892      47.7071       0.0134       0.0440       4.3836    2747.0706    1132.5298     -43.0625    2596.0000
 1047.5976     189.3695     374.2196     855.0431    1255.1809     785.6602       1.2728     311.0000      -0.0158      -0.0527       7.5700      42.4418     319.5432       1.8637      47.7071       0.0035       0.0333       4.4016    2736.9531    1134.8411     -45.6875    2572.0000
 1047.7500     194.7052     367.6618     881.2700    1329.7679     761.9183       1.3125     311.0000      -0.0068      -0.0434       7.6520      45.4810     319.5432       1.3647      47.7071       0.0174       0.0482       4.4398    2721.5693    1360.3296     -43.8750    2625.0000
 1047.9024     188.1574     341.0340    1023.6349    1386.2893     848.1278       1.1791     311.0000      -0.0009      -0.0372       7.6959      43.1599     319.5432       0.7296      47.7071       0.0153       0.0461       4.4509    2711.4590    1785.1407     -44.8125    2583.0000
 1048.0548     187.8943     396.9312    1065.3534    1459.4043     842.1342       1.1875     311.0000      -0.0007      -0.0371       7.6394      44.2266     319.5432       2.7165      47.7071       0.0116       0.0421       4.4746    2711.2559    2215.1052     -42.5625    2583.0000
 1048.2072     177.1861     357.5771     971.4271    1437.2516     761.0847       1.3139     311.0000      -0.0115      -0.0483       7.5557      46.8606     318.9969      16.6745      47.7071       0.0133       0.0435       4.5242    2729.6958    2061.7791     -42.0000    2584.0000
 1048.3596     179.8108     322.2891     951.7570    1188.4551     708.8491       1.4107     311.0000      -0.0040      -0.0405       7.5206      54.4792     318.9969      16.5806      47.7071       0.0112       0.0412       4.6131    2716.8757    1895.8748     -41.6875    2585.0000
 1048.5120     185.6521     349.9391    1108.5359    1287.3196     726.5986       1.3763     311.0000       0.0115      -0.0244       7.5529      55.9317     318.4506      11.3678      47.7071       0.0178       0.0481       4.7435    2690.3293    1559.3328     -40.8750    2594.0000
 1048.6644     196.4421     363.8484    1210.6472    1284.4747     804.6094       1.2428     311.0000       0.0294      -0.0059       7.6285      54.1705     318.9969      -4.5862      47.7071       0.0072       0.0374       4.7536    2659.6995    1413.4230     -40.8750    2594.0000
 1048.8168     192.6623     407.8850    1416.9136    1452.9952     992.0035       1.0081     311.0000       0.0282      -0.0071       7.6661      48.7495     318.9969      -7.0570      47.7071       0.0135       0.0442       4.6998    2661.7822    1290.2666     -40.8750    2588.0000
 1048.9692     178.9788     391.1599    1393.4412    1557.5781     877.4108       1.1397     311.0000       0.0141      -0.0218       7.5705      46.4620     318.9969      -4.3759      47.7071       0.0128       0.0438       4.5169    2685.9080    1448.6483     -40.8750    2559.0000
 1049.1216     169.9129     351.5154    1219.3949    1473.1782     930.9758       1.0741     311.0000       0.0015      -0.0348       7.5265      50.2876     318.9969      -1.7359      47.7071       0.0179       0.0498       4.3512    2707.3721    1361.3513     -38.7500    2564.0000
 1049.2740     168.5315     360.3279    1190.1125    1520.0167    1015.4303       0.9848     311.0000      -0.0070      -0.0436       7.5688      55.9402     318.9969       0.9699      47.7071       0.0240       0.0562       4.2407    2721.9929    1383.7660     -38.0625    2560.0000
 1049.4264     167.6750     346.4203    1011.7836    1354.2792     952.3549       1.0500     311.0000      -0.0014      -0.0378       7.5309      57.8217     318.9969      -0.7381      47.7071       0.0137       0.0452       4.2801    2712.3281    1092.3508     -37.0625    2595.0000
 1049.5788     155.7875     283.6079     860.2485    1221.2280     866.3672       1.1542     311.0000       0.0021      -0.0342       7.4786      54.6910     318.9969      -9.8684      47.7071       0.0169       0.0483       4.3422    2706.3999     908.3598     -35.5625    2612.0000
 1049.7312     141.0462     242.3228     620.0541     912.7017     612.8483       1.6317     311.0000      -0.0058      -0.0424       7.4700      55.9014     318.9969     -14.1840      47.7071       0.0241       0.0569       4.4057    2719.9932     776.5099     -32.6875    2597.0000
 1049.8836     146.5463     248.0087     623.3010     943.8745     659.4593       1.5164     311.0000      -0.0121      -0.0489       7.5062      55.9110     319.5432      -8.3575      47.7071       0.0262       0.0594       4.4004    2730.6921     588.7368     -31.1875    2585.0000
 1050.0360     162.1622     297.0165     875.2963    1258.7152     964.7583       1.0365     311.0000      -0.0076      -0.0442       7.5644      61.6374     319.5432       1.1144      47.7071       0.0174       0.0503       4.4041    2722.9683     493.3824     -31.1250    2635.0000
 1050.1884     174.2251     341.4718     980.1623    1288.4271    1080.8385       0.9252     311.0000       0.0123      -0.0236       7.5448      59.5005     319.5432       4.4611      47.7071       0.0252       0.0588       4.4554    2688.9543     400.8611     -31.1250    2641.0000
 1050.3408     180.2846     386.5580    1033.1665    1387.4183    1077.6167       0.9280     311.0000       0.0227      -0.0128       7.5107      63.1046     320.0895       9.3257      47.7071       0.0322       0.0664       4.4797    2671.1047     435.9464     -31.1250    2625.0000
 1050.4932     175.9974     327.6712     945.8979    1302.5649     933.8018       1.0709     311.0000       0.0263      -0.0091       7.5234      60.8971     319.5432       6.3257      47.7071       0.0308       0.0646       4.4891    2665.0281     498.5652     -31.1250    2618.0000
 1050.6456     169.5823     304.4687     864.3218    1235.8212     777.0709       1.2869     311.0000       0.0211      -0.0144       7.6040      64.6549     319.8164      10.0963      47.7071       0.0225       0.0555       4.4378    2673.8357     595.9387     -31.0000    2612.0000
 1050.7980     165.8515     271.7378     747.5910    1008.7980     660.9670       1.5129     311.0000       0.0139      -0.0219       7.5834      60.3178     320.0895      -0.7386      47.7071       0.0203       0.0531       4.4035    2686.1567     775.8970     -31.1250    2624.0000
 1050.9504     170.1715     303.0317     761.6577     890.6978     645.0379       1.5503     311.0000       0.0027      -0.0336       7.5045      56.0728     319.5432       1.3006      47.7071       0.0213       0.0539       4.3644    2705.3882    1229.9883     -31.0000    2621.0000
 1051.1028     168.9328     309.7878     703.1044     776.3010     581.4526       1.7198     311.0000      -0.0046      -0.0412       7.4249      53.9363     319.5432      -1.2536      47.7071       0.0154       0.0473       4.3090    2717.9209    1450.9734     -28.5625    2607.0000
 1051.2552     169.7922     310.5266     665.2468     672.4770     522.4641       1.9140     311.0000      -0.0014      -0.0378       7.4707      59.1256     319.5432      -0.5951      47.7071       0.0220       0.0547       4.2831    2712.3164     976.5560     -28.5625    2572.0000
 1051.4076     162.9249     307.6962     642.7462     635.4871     503.5790       1.9858     311.0000       0.0065      -0.0296       7.5498      63.3260     318.9969      -1.2522      47.7071       0.0282       0.0619       4.2621    2698.8147     546.1600     -26.7500    2555.0000
 1051.5600     158.5265     279.1464     576.4028     706.6956     530.6487       1.8845     311.0000       0.0158      -0.0200       7.5613      62.6623     319.2701      -3.4096      47.7071       0.0259       0.0600       4.2821    2683.0254     448.2647     -26.6875    2572.0000
 1051.7124     164.0266     308.0024     547.2537     535.0517     410.4837       2.4362     311.0000       0.0135      -0.0223       7.4773      59.5576     318.9969      -2.7649      47.7071       0.0322       0.0669       4.2640    2686.8479     473.6739     -24.5000    2585.0000
 1051.8648     154.7174     393.7455     537.1176     644.2882     471.1839       2.1223     311.0000       0.0135      -0.0224       7.5488      63.6799     318.9969      -2.5964      47.7071       0.0341       0.0693       4.2618    2686.9121     658.9924     -24.9375    2572.0000
 1052.0172     138.3395     220.0159     419.7614     552.6722     429.4584       2.3285     311.0000       0.0180      -0.0177       7.6264      69.3166     318.9969      -2.3921      47.7071       0.0265       0.0612       4.2566    2679.2627     487.9654     -22.8125    2568.0000
 1052.1696     107.6844     144.9129     255.8547     430.3366     283.6738       3.5252     311.0000       0.0306      -0.0046       7.5906      73.9490     318.9969      -1.8504      47.7071       0.0321       0.0676       4.2724    2657.6177     273.5652     -24.0625    2570.0000
 1052.3220      95.9568     132.5039     223.0616     369.6721     244.2329       4.0945     311.0000       0.0386       0.0037       7.5511      73.3531     318.9969      -2.6858      47.7071       0.0470       0.0844       4.2923    2643.9622     234.9839     -21.5000    2575.0000
 1052.4744     106.1042     142.5633     256.4583     439.2862     308.9392       3.2369     311.0000       0.0379       0.0029       7.5271      68.8956     318.4506      -1.8210      47.7071       0.0451       0.0823       4.3101    2645.2212     210.0771     -21.3125    2553.0000
 1052.6268     126.8667     187.7016     367.9416     578.7457     489.8415       2.0415     311.0000       0.0370       0.0020       7.5280      62.8735     318.4506      -3.8388      47.7071       0.0456       0.0827       4.3604    2646.7144     350.8880     -22.1250    2581.0000
 1052.7792     145.2711     249.4637     485.0081     640.5099     584.1860       1.7118     311.0000       0.0350      -0.0001       7.5539      56.1287     318.4506      -4.3466      47.7071       0.0362       0.0721       4.4204    2650.1492     349.8441     -24.0625    2547.0000
 1052.9316     150.7957     256.4550     525.4232     709.4214     661.9415       1.5107     311.0000       0.0327      -0.0025       7.6849      52.8708     318.4506      -6.1257      47.7071       0.0266       0.0610       4.4604    2654.0759     512.5522     -25.2500    2571.0000
 1053.0840     151.1951     285.0251     610.5479     732.4039     722.1592       1.3847     311.0000       0.0240      -0.0115       7.6723      47.8008     318.4506      -5.9059      47.7071       0.0239       0.0575       4.4653    2668.9099     530.1374     -26.2500    2575.0000
 1053.2364     153.3869     352.8316     485.9918     681.9366     701.1456       1.4262     311.0000       0.0197      -0.0159       7.5350      42.5560     318.4506      -4.7317      47.7071       0.0246       0.0575       4.4756    2676.2422     741.2567     -26.4375    2585.0000
 1053.3888     155.6156     278.7919     723.6425     904.7944     827.8169       1.2080     311.0000       0.0155      -0.0203       7.5172      39.7393     317.9043      -2.3289      47.7071       0.0206       0.0531       4.4757    2683.5254     898.6191     -25.8125    2589.0000
 1053.5412     171.4620     305.7854     781.9252     990.2695     802.0983       1.2467     311.0000       0.0155      -0.0203       7.5771      40.3722     317.9043      -1.9064      47.7071       0.0121       0.0436       4.4793    2683.5352     724.6114     -26.9375    2585.0000
 1053.6936     162.7358     294.2370     868.0095    1081.5927     830.3590       1.2043     311.0000       0.0121      -0.0238       7.6009      44.2030     318.4506       1.6909      47.7071       0.0195       0.0517       4.4557    2689.3218     664.2445     -26.6875    2605.0000
 1053.8460     153.8289     256.6898     775.4257    1087.4396     825.5563       1.2113     311.0000       0.0117      -0.0242       7.6477      44.2265     318.7238      -0.8807      47.7071       0.0314       0.0649       4.4121    2689.9922     627.6397     -27.6875    2600.0000
 1053.9984     148.5851     235.0050     694.8819    1012.8433     553.0785       1.8081     311.0000       0.0118      -0.0242       7.5275      45.6526     319.5432       0.0067      47.7071       0.0200       0.0525       4.3586    2689.8586     617.2922     -27.4375    2596.0000
 1054.1508     153.7287     261.9070     782.3196     916.8233     700.2045       1.4282     311.0000       0.0125      -0.0234       7.5037      42.2039     319.5432       0.5345      47.7071       0.0142       0.0464       4.3186    2688.6443     832.5605     -28.1250    2592.0000
 1054.3032     153.5610     294.8674     850.1343     916.5676     886.7963       1.1277     311.0000       0.0137      -0.0222       7.6163      40.1504     319.5432       1.9648      47.7071       0.0224       0.0550       4.3622    2686.6479     753.3788     -27.8750    2640.0000
 1054.4556     148.0313     296.3875     742.2875     958.3652     855.8699       1.1684     311.0000       0.0124      -0.0236       7.6659      44.8245     319.5432       0.9143      47.7071       0.0214       0.0541       4.4066    2688.8682     788.5197     -29.3750    2629.0000
 1054.6080     151.4239     263.0522     578.0167     779.5387     696.2299       1.4363     311.0000       0.0103      -0.0256       7.6494      50.7003     320.0895      -2.4116      47.7071       0.0272       0.0606       4.3934    2692.3181     794.1019     -28.8750    2625.0000
 1054.7604     147.1231     223.3900     429.7879     659.9083     577.0427       1.7330     311.0000       0.0041      -0.0321       7.6294      59.2156     319.5432      -0.1383      47.7071       0.0228       0.0560       4.2639    2702.9353     609.9171     -30.7500    2592.0000
 1054.9128     147.9094     217.6130     388.3061     506.9290     438.3306       2.2814     311.0000       0.0030      -0.0332       7.6078      58.7992     319.5432       0.9079      47.7071       0.0324       0.0670       4.1459    2704.7971     553.2018     -31.1250    2559.0000
 1055.0652     152.4217     268.5717     470.4000     533.7844     459.8142       2.1748     311.0000       0.0058      -0.0304       7.5995      58.9200     319.5432      -0.0217      47.7071       0.0319       0.0663       4.0755    2700.0779     481.9044     -31.1250    2599.0000
 1055.2176     152.2937     271.7259     575.1927     694.2055     569.2370       1.7567     311.0000       0.0110      -0.0249       7.6073      59.9688     319.5432      -1.5824      47.7071       0.0220       0.0557       4.0546    2691.1157     567.9760     -31.1250    2603.0000
 1055.3700     143.9914     290.4899     532.2471     584.9180     476.5624       2.0984     311.0000       0.0171      -0.0187       7.6444      60.3435     320.0895      -2.4848      47.7071       0.0334       0.0675       4.1299    2680.8303     461.4599     -31.1250    2560.0000
 1055.5224     150.2556     263.3145     528.8840     489.6342     414.9280       2.4101     311.0000       0.0223      -0.0133       7.6633      52.7469     320.0895      -2.0559      47.7071       0.0267       0.0603       4.3017    2671.8679     528.6382     -31.1250    2586.0000
 1055.6748     170.1239     282.5771     691.0366     671.0931     544.8458       1.8354     311.0000       0.0256      -0.0099       7.6280      46.1393     319.5432       4.6103      47.7071       0.0212       0.0537       4.5267    2666.2751     529.6832     -31.8750    2570.0000
 1055.8272     171.0544     284.8811     817.7224     945.5915     714.7961       1.3990     311.0000       0.0238      -0.0117       7.6351      42.8923     320.0895       3.0222      47.7071       0.0168       0.0490       4.6625    2669.3232     852.3966     -33.0000    2563.0000
 1055.9796     154.0406     235.4617     647.2153     905.3091     619.8195       1.6134     311.0000       0.0163      -0.0195       7.6043      50.5291     320.0895       2.0289      47.7071       0.0237       0.0564       4.6806    2682.2053     857.0429     -33.3750    2609.0000
 1056.1320     141.1229     212.6695     582.0126    1036.8627     608.9963       1.6420     311.0000       0.0113      -0.0246       7.6055      50.0039     319.5432      -6.3028      47.7071       0.0221       0.0553       4.6404    2690.6104    1004.3862     -34.7500    2637.0000
 1056.2844     127.0261     197.6882     516.2408    1014.5783     613.5466       1.6299     311.0000       0.0060      -0.0301       7.6683      48.8501     320.0895      -5.2671      47.7071       0.0205       0.0535       4.6011    2699.6858     687.5567     -35.5625    2627.0000
 1056.4368     149.3549     248.0698     650.6188    1256.0474     837.2384       1.1944     311.0000       0.0038      -0.0324       7.6910      43.6238     320.6359      -3.8757      47.7071       0.0233       0.0560       4.6171    2703.4302     716.7831     -36.1250    2638.0000
 1056.5892     167.0063     342.0371     873.1906    1347.8279     898.7765       1.1126     311.0000       0.0050      -0.0312       7.6499      42.3253     321.7285      -2.0664      47.7071       0.0165       0.0480       4.7284    2701.4241     779.3876     -36.0625    2572.0000
 1056.7416     181.4548     378.6795     871.3307    1298.3145     807.5662       1.2383     311.0000       0.0088      -0.0272       7.6154      37.6033     321.7285      -1.1671      47.7071       0.0147       0.0450       4.8979    2694.9265    1200.3513     -36.8750    2577.0000
 1056.8940     171.5462     411.6227     997.6990    1328.2657     758.0518       1.3192     311.0000       0.0099      -0.0261       7.6325      35.8018     322.2748      -0.6628      47.7071       0.0104       0.0396       5.0381    2693.0432    1402.9857     -37.6875    2568.0000
 1057.0464     159.5770     331.7743     910.9919    1094.0840     597.1091       1.6747     311.0000       0.0089      -0.0272       7.6808      31.3717     322.2748      -0.1228      47.7071      -0.0023       0.0253       5.1323    2694.8083    1846.8142     -39.1875    2572.0000
 1057.1988     160.2134     324.6682     866.1407    1081.0901     503.6152       1.9856     311.0000       0.0044      -0.0318       7.7154      31.9246     322.8211       1.3454      47.7071       0.0017       0.0296       5.1155    2702.5474    2090.6030     -38.9375    2603.0000
 1057.3512     164.7668     350.3544    1296.1655    1475.1830     842.7515       1.1866     311.0000       0.0045      -0.0317       7.6761      29.0827     322.8211       1.8058      47.7071       0.0065       0.0349       5.0537    2702.2571    2277.1057     -39.0625    2591.0000
 1057.5036     179.4234     429.4627    1466.3478    1638.8773    1058.1040       0.9451     311.0000       0.0049      -0.0312       7.5901      34.0274     322.8211       2.0945      47.7071       0.0050       0.0332       4.9517    2701.5371    2878.0815     -37.8750    2583.0000
 1057.6560     182.5920     402.7781    1766.7584    1878.1982    1576.2312       0.6344     311.0000       0.0051      -0.0310       7.5896      35.4171     322.8211       1.7207      47.7071       0.0036       0.0318       4.8937    2701.2278    3265.6631     -37.7500    2572.0000
 1057.8084     177.0207     357.9002    1535.2650    1785.0149    1340.1276       0.7462     311.0000      -0.0022      -0.0386       7.6642      37.8318     322.2748       1.7979      47.7071       0.0064       0.0352       4.8556    2713.7710    3332.1106     -37.0000    2569.0000
 1057.9608     166.5074     311.0979    1363.9087    1655.7102    1116.0614       0.8960     311.0000      -0.0117      -0.0485       7.6980      33.8354     322.2748       2.1822      47.7071       0.0119       0.0415       4.8119    2730.0098    3404.8589     -37.5000    2610.0000
 1058.1132     156.6262     284.4861    1231.8048    1532.8741    1189.3259       0.8408     311.0000      -0.0162      -0.0531       7.6874      33.3111     322.2748       2.3148      47.7071       0.0027       0.0316       4.7361    2737.6777    4441.2612     -37.3750    2665.0000
 1058.2656     155.8972     292.3326    1258.7019    1409.1772    1252.8901       0.7982     311.0000      -0.0221      -0.0593       7.6525      34.7039     322.2748       6.5179      47.7071       0.0045       0.0336       4.6383    2747.8665    2872.4363     -37.7500    2602.0000
 1058.4180     155.4303     308.9756    1176.7444    1219.5143    1159.9138       0.8621     311.0000      -0.0300      -0.0675       7.6326      43.9416     322.2748       9.1279      47.7071       0.0137       0.0441       4.4871    2761.3696     901.9929     -36.6875    2639.0000
 1058.5704     158.5210     327.6837    1134.8252    1325.1256    1161.5980       0.8609     311.0000      -0.0360      -0.0737       7.7327      46.3995     321.7285       7.7872      47.7071       0.0194       0.0504       4.3462    2771.5793     562.3205     -37.0000    2604.0000
 1058.7228     160.5727     341.4506    1105.4464    1341.7706     982.5097       1.0178     311.0000      -0.0335      -0.0711       7.7551      43.3885     322.2748       1.2772      47.7071       0.0257       0.0577       4.2693    2767.3252     523.4453     -38.9375    2565.0000
 1058.8752     161.8300     340.8395    1121.4144    1284.9639     957.1957       1.0447     311.0000      -0.0308      -0.0683       7.6917      29.6214     322.5479      -2.4633      47.7071       0.0134       0.0443       4.2575    2762.6836     658.2612     -38.9375    2616.0000
 1059.0276     157.7462     313.3984     964.0116    1394.2623     864.4204       1.1568     311.0000      -0.0326      -0.0701       7.6422      23.9819     322.2748      -1.4422      47.7071       0.0143       0.0455       4.2954    2765.6919    1180.2649     -38.1250    2592.0000
 1059.1800     164.0940     323.0030     963.2787    1280.9912     865.9282       1.1548     311.0000      -0.0342      -0.0719       7.6892      19.3287     322.8211       0.3614      47.7071       0.0162       0.0468       4.3787    2768.5547    1380.5098     -38.5000    2578.0000
 1059.3324     166.5275     305.7153     915.0621    1150.4972     771.5726       1.2961     311.0000      -0.0427      -0.0806       7.6810      21.2883     322.8211       5.2378      47.7071       0.0049       0.0341       4.5022    2783.0640    3037.1597     -38.0000    2585.0000
 1059.4848     154.1845     286.8070     831.3119     999.7510     668.8371       1.4951     311.0000      -0.0427      -0.0806       7.6905      19.8231     322.2748       5.0673      47.7071       0.0031       0.0312       4.5577    2783.0325    3116.5735     -38.3750    2572.0000
 1059.6372     147.5735     268.0564     753.4810     867.8506     580.0084       1.7241     311.0000      -0.0397      -0.0775       7.6843      20.3072     321.7285       5.2199      47.7071       0.0002       0.0280       4.5577    2777.8904    4240.8638     -39.2500    2557.0000
 1059.7896     137.2787     248.1390     690.3520     824.6054     536.5620       1.8637     311.0000      -0.0266      -0.0640       7.6742      19.1474     321.7285       1.0140      47.7071       0.0047       0.0330       4.5022    2755.5520    3555.5286     -38.3750    2568.0000
 1059.9420     142.6660     255.7474     595.8348     756.7059     510.3709       1.9594     311.0000      -0.0205      -0.0576       7.6983      20.6309     321.7285       0.0622      47.7071       0.0087       0.0384       4.4527    2745.0657    2023.1008     -36.2500    2580.0000
 1060.0944     139.2673     239.7707     581.6683     712.7595     508.4204       1.9669     311.0000      -0.0234      -0.0607       7.7470      25.8105     321.1822      -1.3947      47.7071       0.0162       0.0475       4.2552    2750.0945     748.0360     -37.0625    2594.0000
 1060.2468     136.1607     224.1124     548.9858     723.2476     533.8074       1.8733     311.0000      -0.0344      -0.0720       7.7257      31.0785     321.1822      -1.6825      47.7071       0.0270       0.0604       3.9251    2768.8552     484.8792     -36.7500    2572.0000
 1060.3992     134.4646     219.3777     521.7574     703.2560     550.7713       1.8156     311.0000      -0.0415      -0.0794       7.6307      33.3763     321.1822      -2.8129      47.7071       0.0277       0.0616       3.6289    2781.0173     487.1000     -35.8125    2594.0000
 1060.5516     130.5947     209.3191     467.9541     674.0842     584.9911       1.7094     311.0000      -0.0460      -0.0841       7.6691      36.3326     321.1822      -2.9852      47.7071       0.0286       0.0632       3.4738    2788.7136     652.1890     -36.1250    2607.0000
 1060.7040     130.4562     212.0245     462.9668     655.8671     577.6277       1.7312     311.0000      -0.0394      -0.0772       7.7922      39.9797     320.9090      -4.5094      47.7071       0.0346       0.0694       3.5067    2777.3342     728.5759     -35.7500    2588.0000
 1060.8564     130.4234     227.7313     486.2829     702.4255     646.3189       1.5472     311.0000      -0.0362      -0.0739       7.8024      39.7480     320.6359      -2.1057      47.7071       0.0356       0.0704       3.5885    2771.9600     737.5571     -35.2500    2565.0000
 1061.0088     135.3038     248.1635     534.3528     681.6532     689.0706       1.4512     311.0000      -0.0252      -0.0625       7.7326      37.6238     320.0895       0.0057      47.7071       0.0209       0.0540       3.7625    2753.0500    1064.0183     -33.6875    2561.0000
 1061.1612     127.0057     238.9521     513.4714     742.4128     648.1670       1.5428     311.0000      -0.0065      -0.0431       7.7112      34.7327     320.0895       1.4689      47.7071       0.0186       0.0515       4.0155    2721.0579     718.4704     -35.5625    2573.0000
 1061.3136     130.7020     242.0518     536.9882     739.3782     619.8028       1.6134     311.0000      -0.0046      -0.0411       7.6885      33.0098     319.5432      25.8420      47.7071       0.0284       0.0617       4.3741    2717.8960     420.2252     -36.3125    2592.0000
 1061.4660     128.1370     203.9660     460.4380     636.1639     491.7635       2.0335     311.0000      -0.0036      -0.0401       7.8152      30.4724     319.5432      45.0733      47.7071       0.0224       0.0547       4.7213    2716.2102     400.2325     -37.8750    2595.0000
 1061.6184     145.3706     234.5791     512.7711     514.5219     407.6112       2.4533     311.0000      -0.0108      -0.0476       7.8530      23.4458     319.5432      46.0408      47.7071       0.0146       0.0448       4.9158    2728.5071     696.2567     -37.7500    2596.0000
 1061.7708     175.0840     338.0776     801.3168     894.1013     732.3647       1.3654     311.0000      -0.0212      -0.0583       7.7380      20.3046     319.5432      32.9988      47.7071       0.0088       0.0376       4.9389    2746.2363    1603.4031     -38.9375    2585.0000
 1061.9232     171.8999     390.1556    1216.9015    1222.0068    1050.6991       0.9517     311.0000      -0.0227      -0.0599       7.6633      17.5642     319.5432      13.2349      47.7071      -0.0059       0.0210       4.8817    2748.8838    4088.9097     -38.9375    2565.0000
 1062.0756     168.3621     409.8161    1371.4192    1230.5500    1153.6359       0.8668     311.0000      -0.0214      -0.0586       7.7345      15.5577     318.9969      10.8547      47.7071      -0.0047       0.0222       4.9297    2746.6108    4222.7231     -40.8125    2600.0000
 1062.2280     161.4487     396.2479    1456.2808    1211.6874    1078.4559       0.9273     311.0000      -0.0032      -0.0396       7.7840      14.4273     319.5432      -1.8451      47.7071       0.0042       0.0314       4.9812    2715.4087    4353.8960     -40.5625    2619.0000
 1062.3804     158.3089     359.0832    1408.9889    1307.4033    1023.4684       0.9771     311.0000      -0.0015      -0.0380       7.8079      14.4017     318.9969      -2.1136      47.7071       0.0005       0.0272       4.9961    2712.6248    4377.1460     -40.1250    2610.0000
 1062.5328     156.1692     334.5914    1340.3809    1341.6000     966.2830       1.0349     311.0000      -0.0027      -0.0392       7.8063      16.8031     318.9969      -1.3924      47.7071      -0.0064       0.0196       4.9904    2714.6375    4477.4741     -40.8750    2595.0000
 1062.6852     148.4634     316.4331    1223.1508    1321.6602     846.9039       1.1808     311.0000      -0.0023      -0.0388       7.8188      18.1651     320.0895      -1.8077      47.7071       0.0021       0.0291       4.9980    2714.0144    4530.7158     -40.8750    2619.0000
 1062.8376     139.9419     295.9247    1096.0624    1269.5411     843.4567       1.1856     311.0000      -0.0036      -0.0401       7.8021      19.1921     319.5432      -2.1873      47.7071      -0.0000       0.0267       4.9616    2716.2378    4529.2075     -40.8750    2634.0000
 1062.9900     141.7661     340.2347    1116.9487    1473.0398     913.9639       1.0941     311.0000      -0.0108      -0.0476       7.7672      21.9046     319.5432      -1.3063      47.7071      -0.0037       0.0229       4.8379    2728.5505    4516.1558     -40.8750    2626.0000
 1063.1424     151.2473     342.4897    1372.8643    1584.2671    1105.6294       0.9045     311.0000      -0.0235      -0.0607       7.8454      21.7583     320.0895       2.2788      47.7071       0.0050       0.0321       4.7144    2750.1777    4499.9995     -40.8750    2601.0000
 1063.2948     150.6104     322.8714    1420.5400    1626.8217    1280.9064       0.7807     311.0000      -0.0260      -0.0633       7.9010      21.6444     320.6359       2.9132      47.7071      -0.0036       0.0231       4.6622    2754.5276    4453.8789     -40.8750    2613.0000
 1063.4472     157.9985     332.1150    1505.2881    1669.2493    1460.2780       0.6848     311.0000      -0.0222      -0.0593       7.8765      18.9429     320.6359       2.8286      47.7071      -0.0038       0.0230       4.7061    2747.8948    4406.0483     -40.8750    2605.0000
 1063.5996     160.0113     332.8917    1542.8892    1651.4205    1609.2603       0.6214     311.0000      -0.0146      -0.0515       7.8215      18.1628     320.6359       0.8881      47.7071       0.0052       0.0324       4.7356    2734.9175    4381.2114     -40.8750    2575.0000
 1063.7520     157.4582     324.2023    1450.4482    1543.7704    1631.3109       0.6130     311.0000      -0.0125      -0.0494       7.7795      18.6963     320.6359       0.5884      47.7071      -0.0013       0.0252       4.7749    2731.4319    4381.3716     -40.8750    2589.0000
 1063.9044     156.2574     314.5175    1275.3376    1316.2533    1518.4827       0.6586     311.0000      -0.0124      -0.0493       7.8478      16.2838     321.1822      -0.3419      47.7071      -0.0037       0.0227       4.8017    2731.2791    4367.8608     -40.8750    2596.0000
 1064.0568     153.1149     311.0910    1051.7174    1155.3102    1373.0281       0.7283     311.0000      -0.0184      -0.0554       7.9368      16.0600     321.1822      -6.5489      47.7071      -0.0006       0.0259       4.7823    2741.3972    4290.5601     -40.8750    2577.0000
 1064.2092     159.0535     350.0876    1013.1567    1209.9871    1211.5481       0.8254     311.0000      -0.0233      -0.0605       7.9362      14.8299     321.1822      -9.9223      47.7071      -0.0038       0.0227       4.7401    2749.7837    4286.1699     -41.0000    2603.0000
 1064.3616     159.5311     349.5570     947.4061    1171.0010    1073.0851       0.9319     311.0000      -0.0257      -0.0629       7.9293      19.2306     321.1822      -9.2330      47.7071       0.0003       0.0271       4.6887    2753.8647    3388.6306     -40.8750    2619.0000
 1064.5140     141.9517     286.9834     676.4588     906.7237     779.8921       1.2822     311.0000      -0.0270      -0.0644       7.8883      22.6660     321.1822      -2.2733      47.7071       0.0029       0.0307       4.6216    2756.2129    1357.1796     -40.8750    2599.0000
 1064.6664     123.5172     213.5692     421.3222     586.4081     477.0520       2.0962     311.0000      -0.0335      -0.0711       7.9280      25.4670     320.6359       2.0494      47.7071       0.0010       0.0291       4.4799    2767.2344    1306.8796     -40.8750    2586.0000
 1064.8188     118.2916     192.9534     361.4689     503.2771     365.0763       2.7392     311.0000      -0.0473      -0.0854       8.0565      30.9643     320.0895       3.0456      47.7071       0.0089       0.0391       4.1730    2790.8557    2089.0669     -40.5000    2579.0000
 1064.9712     115.7705     184.0010     330.2470     408.4536     336.3470       2.9731     311.0000      -0.0495      -0.0876       7.9989      34.0066     320.0895       2.4457      47.7071       0.0179       0.0497       3.8972    2794.5674     323.4717     -38.5000    2615.0000
 1065.1236     112.2910     176.2635     293.9719     327.2152     283.9740       3.5214     311.0000      -0.0403      -0.0782       7.9698      41.3673     320.6359       1.5726      47.7071       0.0311       0.0653       3.7807    2778.9851     155.1776     -38.0000    2622.0000
 1065.2760     119.5545     198.3942     317.1349     343.1451     281.8023       3.5486     311.0000      -0.0247      -0.0620       7.9985      39.5759     320.6359       1.5359      47.7071       0.0454       0.0814       3.9397    2752.2634     124.2891     -37.1875    2587.0000
 1065.4284     129.3076     247.1018     409.1882     405.0212     331.5153       3.0165     311.0000      -0.0105      -0.0473       7.9849      42.3855     320.0895       2.0471      47.7071       0.0394       0.0744       4.2989    2728.0188     209.4480     -36.6875    2597.0000
 1065.5808     139.3803     310.8774     432.4982     504.9155     372.3621       2.6856     311.0000      -0.0054      -0.0419       7.8649      36.6813     319.8164       3.0398      47.7071       0.0131       0.0441       4.6227    2719.1702     736.0819     -35.8125    2624.0000
 1065.7332     146.5825     354.7548     633.8704     585.5441     421.3895       2.3731     311.0000      -0.0060      -0.0426       8.0323      35.6559     320.0895       2.9933      47.7071       0.0004       0.0286       4.8179    2720.3057    2968.7168     -35.4375    2601.0000
 1065.8856     148.0639     476.2357     822.4352     813.5022     538.4656       1.8571     311.0000      -0.0133      -0.0502       8.1375      31.4565     318.9969       2.3637      47.7071       0.0005       0.0275       4.8831    2732.8191    2831.2788     -35.3125    2599.0000
 1066.0380     152.8673     441.9101    1056.2692    1130.9475     715.8991       1.3968     311.0000      -0.0148      -0.0517       8.0372      27.4171     318.9969       0.0944      47.7071      -0.0021       0.0244       4.9723    2735.3801    3330.5947     -33.9375    2565.0000
 1066.1904     155.4328     378.9013    1016.4395    1235.1870     700.0215       1.4285     311.0000      -0.0180      -0.0551       7.9408      21.9572     319.5432      -0.3183      47.7071      -0.0047       0.0213       5.0042    2740.8364    4002.2949     -33.5000    2569.0000
 1066.3428     157.6874     271.8152     846.1121    1265.6578     630.7770       1.5853     311.0000      -0.0195      -0.0566       8.0090      19.0890     320.6359       0.2418      47.7071      -0.0018       0.0243       4.9902    2743.4194    4628.4536     -33.6250    2583.0000
 1066.4952     156.1639     316.1631    1085.2274    1470.5527     694.7638       1.4393     311.0000      -0.0157      -0.0527       8.0570      19.3828     320.6359      -0.3877      47.7071      -0.0027       0.0231       4.9862    2736.8882    3035.1748     -33.3750    2561.0000
 1066.6476     155.1437     324.0163    1315.5184    1677.4999    1081.6470       0.9245     311.0000      -0.0074      -0.0440       8.0887      23.6074     320.6359      -2.4977      47.7071      -0.0108       0.0142       5.0192    2722.5715    2432.4465     -33.3750    2571.0000
 1066.8000     156.8012     356.2001    1547.9312    1825.4186    1406.7058       0.7109     311.0000       0.0013      -0.0351       8.0424      23.4645     321.1822      -4.7994      47.7071      -0.0047       0.0208       5.0884    2707.8530    2058.5642     -32.8750    2587.0000
 1066.9524     157.9216     348.3228    1630.3203    1899.5946    1606.6820       0.6224     311.0000       0.0047      -0.0314       8.0207      24.5761     321.7285      -5.5304      47.7071       0.0002       0.0261       5.1413    2701.8784    2660.8223     -32.3125    2586.0000
 1067.1048     155.1490     329.8533    1471.9279    1906.9105    1623.9612       0.6158     311.0000       0.0040      -0.0323       8.0778      24.5405     321.7285      -4.7946      47.7071      -0.0059       0.0197       5.1538    2703.2332    3323.1511     -33.6250    2584.0000
 1067.2572     150.8193     315.3510    1380.5347    1946.6355    1673.3140       0.5976     311.0000       0.0047      -0.0315       8.1126      30.5591     320.6359      -4.9508      47.7071      -0.0074       0.0179       5.1116    2702.0134    2665.1873     -32.9375    2562.0000
 1067.4096     147.6165     313.7123    1389.6591    1938.0480    1844.8783       0.5420     311.0000       0.0058      -0.0304       8.0576      37.3073     321.7285      -4.0772      47.7071      -0.0053       0.0206       5.0308    2700.1116    2097.8530     -34.2500    2560.0000
 1067.5620     148.1103     311.0975    1209.0967    1892.8097    1828.2568       0.5470     311.0000       0.0010      -0.0353       8.0313      44.0590     322.2748      -1.5483      47.7071      -0.0019       0.0245       4.9183    2708.2781    1802.5254     -35.0000    2583.0000
 1067.7144     152.4968     315.8716    1084.3602    1825.3761    1783.7469       0.5606     311.0000      -0.0019      -0.0384       8.0654      47.5368     321.1822       0.9391      47.7071       0.0043       0.0319       4.8534    2713.3137    1454.3740     -36.1250    2562.0000
 1067.8668     155.3707     365.3897    1289.9280    1767.4852    1749.7443       0.5715     311.0000      -0.0102      -0.0469       8.0733      47.0970     321.7285       2.5914      47.7071       0.0043       0.0318       4.8200    2727.4287    1517.4071     -36.2500    2573.0000
 1068.0192     163.4536     411.3935    1465.1694    1493.1439    1545.1302       0.6472     311.0000      -0.0125      -0.0493       8.0653      39.3989     322.8211       1.0920      47.7071      -0.0009       0.0263       4.8625    2731.2913    1788.4471     -37.0000    2600.0000
 1068.1716     163.7112     443.4031    1384.5062    1541.7838    1549.5955       0.6453     311.0000      -0.0118      -0.0486       8.0645      32.9005     321.1822      -1.5936      47.7071       0.0054       0.0326       4.9506    2730.1563    3235.1409     -38.0625    2593.0000
 1068.3240     166.4486     465.6292    1299.8898    1554.4412    1396.8710       0.7159     311.0000      -0.0146      -0.0515       8.0399      27.6053     319.8164      -1.5225      47.7071      -0.0024       0.0239       4.9536    2734.9614    3630.3796     -38.0000    2620.0000
 1068.4764     171.0243     498.9515    1393.7406    1493.0220    1312.8730       0.7617     311.0000      -0.0180      -0.0550       8.0541      29.7122     319.5432      -0.4916      47.7071      -0.0088       0.0165       4.9230    2740.7415    2984.1704     -36.8125    2594.0000
 1068.6288     177.4850     518.3560    1457.7552    1369.7181    1518.3917       0.6586     311.0000      -0.0224      -0.0596       8.1266      27.6406     319.2701       0.7267      47.7071      -0.0051       0.0208       4.8658    2748.3052    2877.7529     -36.3125    2580.0000
 1068.7812     177.8547     493.1334    1247.5825    1644.1305    1283.4017       0.7792     311.0000      -0.0179      -0.0549       8.1431      31.4902     317.9043      -0.8678      47.7071      -0.0045       0.0219       4.8372    2740.6184    3703.8232     -35.3750    2604.0000
 1068.9336     174.0448     413.6000    1066.4301    1621.9363    1058.0344       0.9451     311.0000      -0.0080      -0.0447       8.0162      40.3106     316.2654      -2.7547      47.7071       0.0030       0.0305       4.8404    2723.6821    2261.5044     -33.5625    2581.0000
 1069.0860     169.4276     367.3622     886.9162    1489.4961     869.5817       1.1500     311.0000       0.0003      -0.0361       8.0580      51.8864     316.2654      -3.2332      47.7071       0.0069       0.0350       4.8555    2709.5117    1706.8976     -31.9375    2612.0000
 1069.2384     168.1097     332.1996     824.0472    1297.3658     803.2763       1.2449     311.0000      -0.0016      -0.0381       8.1882      57.5596     316.2654      -0.6201      47.7071       0.0098       0.0389       4.8601    2712.7827    1492.9698     -31.1250    2601.0000
 1069.3908     170.2917     340.3021     798.2914    1066.8655     786.6669       1.2712     311.0000       0.0024      -0.0338       8.2568      57.7500     316.2654      -0.8330      47.7071       0.0082       0.0371       4.9306    2705.8220    1815.7667     -31.1250    2598.0000
 1069.5432     170.3183     344.9399     721.5351     865.7709     708.4853       1.4115     311.0000       0.0015      -0.0348       8.1876      54.1326     314.8995      -0.3757      47.7071       0.0029       0.0319       4.9145    2707.4141    1325.2332     -29.8750    2600.0000
 1069.6956     164.7388     313.1308     667.3333     723.8039     637.5767       1.5684     311.0000       0.0093      -0.0268       8.1281      49.4184     314.6264      -3.2480      47.7071       0.0065       0.0351       4.9314    2694.1445     867.1409     -27.8750    2627.0000
 1069.8480     163.0182     311.1031     599.4252     575.1166     566.8162       1.7642     311.0000       0.0057      -0.0305       8.1262      43.8595     314.3532      -2.6181      47.7071       0.0102       0.0392       4.8441    2700.3352     974.5493     -27.8750    2604.0000
 1070.0004     163.5882     340.1234     506.9868     497.5727     478.0902       2.0917     311.0000       0.0010      -0.0353       8.1671      43.0475     313.5338      -0.0942      47.7071       0.0019       0.0295       4.8072    2708.2576     920.5887     -25.3125    2626.0000
 1070.1528     148.1988     310.0201     545.7516     573.4279     506.3572       1.9749     311.0000       0.0004      -0.0360       8.1840      44.6689     313.8069       2.0757      47.7071       0.0007       0.0285       4.7687    2709.3447     977.1796     -23.3750    2609.0000
 1070.3052     149.8189     312.3817     549.9987     674.4608     543.4247       1.8402     311.0000       0.0080      -0.0280       8.0996      44.1692     314.6264       2.4264      47.7071       0.0048       0.0324       4.8733    2696.2534     817.2264     -22.3125    2583.0000
 1070.4576     154.6105     367.8832     623.9668     779.2681     564.8327       1.7704     311.0000       0.0236      -0.0120       8.1247      44.6663     315.1727      -1.6947      47.7071       0.0054       0.0334       5.1046    2669.7229     843.7480     -21.3125    2595.0000
 1070.6100     157.9079     313.5554     579.8659     860.0881     585.6226       1.7076     311.0000       0.0253      -0.0101       8.1373      37.4418     315.1727      -2.4462      47.7071       0.0043       0.0314       5.3384    2666.6721    1286.7312     -21.3125    2564.0000
 1070.7624     160.9671     277.2749     575.6270    1053.1719     582.0688       1.7180     311.0000       0.0205      -0.0152       8.1593      34.9304     315.1727      -2.5191      47.7071      -0.0035       0.0232       5.4600    2675.0298    2811.5950     -19.8750    2594.0000
 1070.9148     167.9863     300.9881     681.0162    1205.1614     710.9076       1.4067     311.0000      -0.0019      -0.0383       8.2119      27.1256     315.1727       4.0550      47.7071      -0.0023       0.0238       5.3983    2713.1787    4540.1919     -17.3750    2552.0000
 1071.0672     174.7657     288.8774     755.6777    1258.8439     925.6021       1.0804     311.0000      -0.0121      -0.0489       8.2431      29.4861     315.1727       1.5090      47.7071      -0.0078       0.0181       5.2734    2730.6355    4519.7856     -16.4375    2569.0000
 1071.2196     167.6525     334.9174     779.1379    1198.3356    1175.5321       0.8507     311.0000      -0.0180      -0.0550       8.2315      28.5280     314.0800       0.1595      47.7071      -0.0034       0.0225       5.1011    2740.7380    1970.6921     -15.1875    2565.0000
 1071.3720     165.5244     334.1452     734.7462    1036.6017    1317.2104       0.7592     311.0000      -0.0111      -0.0479       8.1951      32.4201     314.6264     -10.5875      47.7071      -0.0055       0.0205       4.9577    2728.9788    1096.4041     -12.8125    2564.0000
 1071.5244     156.7780     267.5103     547.7632     809.9529    1297.2982       0.7708     311.0000      -0.0084      -0.0451       8.1682      37.5404     314.6264     -15.0278      47.7071      -0.0036       0.0227       4.8622    2724.3374    1006.1226     -11.5625    2572.0000
 1071.6768     143.4276     250.3773     441.3414     635.2164    1105.9972       0.9042     311.0000      -0.0049      -0.0414       8.2039      46.6051     314.6264     -19.0601      47.7071       0.0040       0.0308       4.8083    2718.3096    1093.1200     -11.5625    2598.0000
 1071.8292     140.1043     241.6519     420.0172     657.2916    1063.5736       0.9402     311.0000       0.0002      -0.0362       8.2718      59.7181     314.0800     -12.9008      47.7071       0.0003       0.0268       4.7178    2709.7051     569.1518     -10.4375    2577.0000
 1071.9816     139.3233     229.5564     377.9323     622.0682     880.3668       1.1359     311.0000       0.0082      -0.0279       8.3119      64.8342     313.5338      -5.6589      47.7071      -0.0034       0.0234       4.6136    2696.0366     380.4859      -9.1875    2583.0000
 1072.1340     138.9259     226.3438     347.3788     536.7835     675.9644       1.4794     311.0000       0.0168      -0.0190       8.2580      69.9524     314.0800      -2.2213      47.7071       0.0051       0.0336       4.5447    2681.3491     283.5237      -8.0625    2575.0000
 1072.2864     135.7821     218.7818     336.1298     468.2389     536.0552       1.8655     311.0000       0.0187      -0.0170       8.1352      67.0058     314.0800      -3.8760      47.7071       0.0095       0.0398       4.4600    2678.0112     398.0179      -7.6250    2564.0000
 1072.4388     137.3621     216.4172     309.5850     434.7490     428.2749       2.3349     311.0000       0.0094      -0.0266       8.2292      68.0095     312.9874      -3.2015      47.7071       0.0165       0.0479       4.3214    2693.9695     422.7133      -6.8750    2593.0000
 1072.5912     136.4756     214.1189     282.4957     364.1551     354.5003       2.8209     311.0000      -0.0126      -0.0494       8.3196      61.2700     312.9874       3.1481      47.7071       0.0255       0.0581       4.1320    2731.4851     366.8618      -7.0625    2615.0000
 1072.7436     136.4265     204.0856     274.3773     324.4142     326.6221       3.0616     311.0000      -0.0232      -0.0604       8.2909      53.0983     314.0800       4.3819      47.7071       0.0285       0.0617       4.0635    2749.6489     398.8163      -7.8125    2605.0000
 1072.8960     157.2627     263.2811     326.4113     348.1808     371.0796       2.6948     311.0000      -0.0264      -0.0637       8.2504      39.7736     313.5338       2.5072      47.7071       0.0271       0.0607       4.1022    2755.1436     732.2539      -8.4375    2616.0000
 1073.0484     201.3297     444.2968     470.1348     530.3873     423.0646       2.3637     311.0000      -0.0215      -0.0586       8.3413      34.5817     313.5338      -2.7361      47.7071       0.0215       0.0548       4.1389    2746.6807    1659.0199      -9.1875    2593.0000
 1073.2008     201.4239     410.9261     542.9241     552.5593     469.9113       2.1281     311.0000      -0.0315      -0.0690       8.2407      27.9298     312.9874      -0.3538      47.7071       0.0193       0.0520       4.0480    2763.9021    1221.5659      -9.1250    2594.0000
 1073.3532     155.4940     243.6148     321.9795     336.6241     358.7169       2.7877     311.0000      -0.0312      -0.0687       8.2196      30.0899     312.9874       6.0041      47.7071       0.0252       0.0589       4.0047    2763.3235    1084.5874     -10.0625    2624.0000
 1073.5056     148.8261     211.6651     281.6986     296.7399     292.1913       3.4224     311.0000      -0.0333      -0.0709       8.2739      28.4462     312.4411      22.9399      47.7071       0.0310       0.0656       4.0180    2766.9124    1077.9247      -9.5000    2632.0000
 1073.6580     142.4754     208.8450     283.1733     306.0641     294.8257       3.3918     311.0000      -0.0272      -0.0645       8.3227      29.8359     312.4411      35.3668      47.7071       0.0299       0.0649       4.1307    2756.4426    1401.1697     -11.4375    2631.0000
 1073.8104     140.9448     216.1369     284.6531     316.2270     304.1936       3.2874     311.0000      -0.0263      -0.0636       8.3222      27.2305     312.4411      41.6019      47.7071       0.0288       0.0629       4.1915    2754.9155    1751.6250     -10.1875    2588.0000
 1073.9628     134.7267     208.0829     274.9803     310.7073     294.8107       3.3920     311.0000      -0.0168      -0.0538       8.2932      27.8383     312.1680      26.9904      47.7071       0.0209       0.0537       4.2517    2738.7419    2008.2114      -9.8125    2594.0000
 1074.1152     126.6153     163.7952     229.1788     279.5306     258.9618       3.8616     311.0000      -0.0136      -0.0504       8.2899      27.8383     312.9874      14.2415      47.7071       0.0195       0.0518       4.2433    2733.2136    1766.3149      -9.8125    2611.0000
 1074.2676     124.6381     147.0212     192.4243     237.9121     213.1160       4.6923     311.0000      -0.0124      -0.0492       8.3007      29.6128     312.9874       4.4105      47.7071       0.0232       0.0554       4.2382    2731.2283    1302.8330     -11.5625    2620.0000
 1074.4200     123.9852     152.9232     204.6213     247.9750     226.5443       4.4141     311.0000      -0.0108      -0.0475       8.2998      26.8252     311.3485       3.6390      47.7071       0.0190       0.0507       4.2991    2728.3977     827.3707     -10.9375    2612.0000
 1074.5724     116.4205     187.8072     243.4040     303.1681     270.7253       3.6938     311.0000      -0.0033      -0.0398       8.3167      30.0359     311.8948       2.7418      47.7071       0.0159       0.0470       4.4426    2715.6484     879.9550     -11.5625    2599.0000
 1074.7248     116.9272     200.2064     287.6863     402.9549     343.2263       2.9135     311.0000       0.0019      -0.0344       8.3197      32.1811     312.4411       0.7601      47.7071       0.0116       0.0427       4.5916    2706.8171    1214.9489     -11.5625    2516.0000
 1074.8772     120.3373     262.8613     378.5748     543.5394     462.3558       2.1628     311.0000      -0.0031      -0.0396       8.3507      31.9446     312.4411       0.2780      47.7071       0.0223       0.0546       4.5977    2715.3589    1934.4644     -11.5625    2595.0000
 1075.0296     120.2040     293.5387     511.4196     761.2948     629.1436       1.5895     311.0000      -0.0027      -0.0391       8.3452      32.2083     310.8022      -0.6022      47.7071       0.0184       0.0507       4.5563    2714.5469    1675.0896     -11.5625    2584.0000
 1075.1820     121.5897     238.6359     420.1617     957.1743     695.0570       1.4387     311.0000      -0.0004      -0.0367       8.3678      28.8641     310.8022       0.4454      47.7071       0.0244       0.0574       4.4510    2710.6240    1253.2733     -11.8125    2565.0000
 1075.3344     127.4956     184.6217     416.9333    1208.7234     795.1303       1.2577     311.0000       0.0093      -0.0267       8.3713      31.3989     310.2559       1.2729      47.7071       0.0298       0.0636       4.4066    2694.1184    1115.3372     -13.5625    2572.0000
 1075.4868     130.4192     219.7768     547.3802    1433.1604    1111.4181       0.8998     311.0000       0.0084      -0.0277       8.3294      30.3449     307.2511       3.4220      47.7071       0.0323       0.0666       4.3535    2695.6699    1120.5405     -14.3125    2584.0000
 1075.6392     140.1907     221.8904     550.7552    1435.3312    1181.9760       0.8460     311.0000       0.0063      -0.0299       8.3290      29.5199     306.4317       2.8589      47.7071       0.0183       0.0510       4.3526    2699.2642    1499.6422     -13.4375    2570.0000
 1075.7916     127.9187     256.1451     613.4208    1314.3440    1224.8247       0.8164     311.0000       0.0014      -0.0349       8.3715      30.2330     306.4317       5.9478      47.7071       0.0131       0.0450       4.3417    2707.5374    1360.2390     -12.9375    2587.0000
 1075.9440     122.2918     242.8790     526.2076    1038.2462    1030.0314       0.9708     311.0000       0.0017      -0.0346       8.4264      32.9083     306.4317       3.1395      47.7071       0.0248       0.0568       4.3477    2707.1272    1072.1930     -13.0000    2599.0000
 1076.0964     117.1325     215.7828     405.5916     775.7805     743.6273       1.3448     311.0000      -0.0001      -0.0365       8.4004      34.9323     306.4317       1.1468      47.7071       0.0157       0.0466       4.3346    2710.2070     925.8051     -12.6250    2591.0000
 1076.2488     112.8564     192.5728     326.9057     600.3324     565.5198       1.7683     311.0000      -0.0026      -0.0390       8.3549      32.6823     306.4317      -4.3850      47.7071       0.0090       0.0389       4.3449    2714.3948     947.4363     -12.1250    2599.0000
 1076.4012     116.0516     173.2579     271.9558     458.8874     402.1665       2.4865     311.0000      -0.0060      -0.0426       8.4437      29.9029     306.9780       6.3682      47.7071       0.0115       0.0414       4.3467    2720.2295     947.2063     -11.5625    2600.0000
 1076.5536     113.2199     160.0610     241.6746     351.1907     311.1120       3.2143     311.0000      -0.0076      -0.0442       8.4077      29.7189     306.4317       7.1766      47.7071       0.0104       0.0402       4.3537    2722.9355     988.0152     -11.2500    2594.0000
 1076.7060     123.8771     210.8368     300.3646     345.4901     342.7272       2.9178     311.0000      -0.0123      -0.0491       8.3797      31.9506     306.7048       8.7674      47.7071       0.0099       0.0397       4.3026    2730.9663     941.6578      -9.6875    2578.0000
 1076.8584     140.5942     291.1573     385.1467     443.6858     435.2188       2.2977     311.0000      -0.0123      -0.0491       8.3353      33.2727     306.9780      -1.6441      47.7071       0.0111       0.0413       4.3002    2731.0471     888.5765      -8.6250    2613.0000
 1077.0108     167.3022     325.3432     686.1895     817.4268     828.5377       1.2069     311.0000      -0.0090      -0.0457       8.3903      33.0541     306.4317      -2.9142      47.7071       0.0147       0.0455       4.3154    2725.3748     908.9810      -7.0625    2618.0000
 1077.1632     161.3933     327.3945     507.2549     548.1657     459.4485       2.1765     311.0000      -0.0037      -0.0402       8.4122      31.6644     306.4317      -4.4348      47.7071       0.0131       0.0437       4.3526    2716.3586    1162.8669      -4.0000    2625.0000
 1077.3156     148.3828     280.7508     369.1980     438.4569     417.1750       2.3971     311.0000      -0.0027      -0.0392       8.4317      28.2135     306.4317      -4.0941      47.7071       0.0125       0.0428       4.3386    2714.6353     917.6371      -1.8125    2607.0000
 1077.4680     145.4288     255.4229     362.4968     447.7161     333.5742       2.9978     311.0000      -0.0067      -0.0433       8.4404      32.0859     306.4317      -2.0771      47.7071       0.0125       0.0430       4.3111    2721.4856     762.4617      -1.8125    2658.0000
 1077.6204     143.4591     236.9780     372.7803     485.8432     415.8973       2.4044     311.0000      -0.0124      -0.0492       8.4337      35.7919     306.9780      -1.4586      47.7071       0.0140       0.0451       4.2652    2731.2620     768.5487      -0.4375    2600.0000
 1077.7728     141.3601     225.5015     365.3003     415.6025     390.9130       2.5581     311.0000      -0.0124      -0.0492       8.4807      36.5864     306.9780      -1.7519      47.7071       0.0169       0.0482       4.2186    2731.1868    1077.9434       1.0625    2617.0000
 1077.9252     147.5354     229.3926     398.6807     476.2874     441.7761       2.2636     311.0000      -0.0127      -0.0496       8.4676      32.0384     306.9780       0.1421      47.7071       0.0164       0.0472       4.1310    2731.7837    1339.3926       2.6250    2610.0000
 1078.0776     154.7166     264.1178     479.0251     634.0623     548.0152       1.8248     311.0000      -0.0122      -0.0490       8.4628      26.4795     306.9780       4.6668      47.7071       0.0062       0.0352       4.1183    2730.8604    1332.0707       5.4375    2633.0000
 1078.2300     166.5397     305.1984     608.6636     863.4301     758.6422       1.3181     311.0000      -0.0219      -0.0590       8.5006      23.8456     306.9780       6.4266      47.7071      -0.0004       0.0275       4.1159    2747.4138    1695.7559       7.8125    2634.0000
 1078.3824     163.0505     335.4428     650.5656    1056.9700     809.8805       1.2348     311.0000      -0.0244      -0.0617       8.4960      24.1132     306.9780       5.4812      47.7071       0.0049       0.0328       4.2078    2751.7539    1492.8662       7.9375    2621.0000
 1078.5348     159.3022     297.1296     630.8407    1216.6729     851.6316       1.1742     311.0000      -0.0160      -0.0529       8.4917      28.0766     306.9780       1.8353      47.7071       0.0030       0.0308       4.3598    2737.3452    1168.3347      11.1875    2601.0000
 1078.6872     157.9217     295.8206     629.6435    1336.0150     846.2531       1.1817     311.0000       0.0005      -0.0359       8.4935      35.5732     306.4317       1.2319      47.7071       0.0030       0.0308       4.5720    2709.1755     747.2211      13.6250    2572.0000
 1078.8396     159.0530     278.8656     599.3749    1420.2139     769.0031       1.3004     311.0000       0.0070      -0.0291       8.5547      39.4554     306.9780       2.5501      47.7071       0.0046       0.0323       4.7410    2697.9978     644.1174      17.5625    2568.0000
 1078.9920     157.0965     294.5370     657.3234    1355.9580     834.6676       1.1981     311.0000      -0.0074      -0.0441       8.5542      40.5799     306.9780       7.1924      47.7071       0.0022       0.0297       4.8161    2722.7373     687.2484      17.7500    2604.0000
 1079.1444     156.1295     310.7168     680.3389    1265.6085     847.1377       1.1804     311.0000      -0.0129      -0.0498       8.5251      41.6838     307.5243       7.1843      47.7071       0.0001       0.0272       4.8180    2732.1204     961.7977      18.4375    2594.0000
 1079.2968     149.0801     277.8069     574.6045    1089.2972     797.1918       1.2544     311.0000      -0.0131      -0.0499       8.4538      45.3299     307.5243       5.5063      47.7071      -0.0028       0.0239       4.8211    2732.3315    1283.0122      22.1250    2578.0000
 1079.4492     140.4306     254.0610     495.1814     836.3145     656.6281       1.5229     311.0000       0.0063      -0.0299       8.4457      51.4197     307.2511      -0.9637      47.7071       0.0019       0.0291       4.8058    2699.3000    1566.2959      24.8750    2627.0000
 1079.6016     133.8598     223.4623     411.5188     697.9181     594.0193       1.6834     311.0000       0.0110      -0.0250       8.5105      55.1256     306.9780      -2.9647      47.7071      -0.0033       0.0238       4.6723    2691.2439    1091.9329      27.5000    2602.0000
 1079.7540     112.7501     176.6576     318.3536     536.5583     503.3376       1.9867     311.0000       0.0106      -0.0254       8.5789      61.9829     307.5243       2.1718      47.7071       0.0044       0.0330       4.3895    2691.8330     375.6210      28.6250    2584.0000
 1079.9064     105.4764     154.2499     255.6804     425.7878     427.7922       2.3376     311.0000      -0.0015      -0.0379       8.5445      61.5000     307.5243       8.1532      47.7071       0.0174       0.0487       4.0407    2712.5740     280.6820      30.3125    2591.0000
 1080.0588      94.1657     132.7849     213.1286     359.2800     382.0191       2.6177     311.0000      -0.0159      -0.0528       8.4943      59.1215     307.5243       9.4919      47.7071       0.0354       0.0697       3.7739    2737.1633     201.0467      33.1250    2608.0000
 1080.2112      92.1273     120.0221     181.9896     305.2271     346.9470       2.8823     311.0000      -0.0182      -0.0552       8.5501      54.1769     307.5243       1.2236      47.7071       0.0372       0.0730       3.6543    2741.1401     194.8458      36.2500    2595.0000
 1080.3636      89.7960     116.3845     168.0809     260.3234     315.0859       3.1737     311.0000      -0.0157      -0.0527       8.5807      52.3951     307.5243      -5.3062      47.7071       0.0283       0.0637       3.6177    2736.9119     160.9533      37.2500    2643.0000
 1080.5160      87.1609     112.6957     155.7949     223.8702     274.1843       3.6472     311.0000      -0.0084      -0.0450       8.5335      54.3500     307.5243      -6.3276      47.7071       0.0420       0.0791       3.6501    2724.3076     136.6967      38.2500    2616.0000
 1080.6684      85.1378     112.2504     149.0525     190.3617     246.2196       4.0614     311.0000      -0.0123      -0.0492       8.5661      52.2031     308.0706      -3.5100      47.7071       0.0491       0.0866       3.6406    2731.1079     118.6704      39.4375    2598.0000
 1080.8208      83.1294     109.7017     143.4314     174.1500     224.7608       4.4492     311.0000      -0.0140      -0.0509       8.6055      56.9559     307.5243      -2.1865      47.7071       0.0359       0.0722       3.6157    2733.9478     114.1961      40.6875    2585.0000
 1080.9732      81.5256     108.5025     136.6165     156.7051     204.0562       4.9006     311.0000      -0.0185      -0.0555       8.5880      59.0919     307.5243      -1.5285      47.7071       0.0338       0.0696       3.5331    2741.5884     106.7824      42.6875    2615.0000
 1081.1256      80.9247     108.2312     131.8106     144.3116     176.9321       5.6519     311.0000      -0.0228      -0.0600       8.5711      64.4815     307.5243      -1.7278      47.7071       0.0394       0.0759       3.4482    2749.0205     101.4802      45.5000    2631.0000
 1081.2780      82.8339     112.5613     131.8605     148.2723     170.8134       5.8543     311.0000      -0.0310      -0.0684       8.5338      64.8354     307.5243      -0.9985      47.7071       0.0403       0.0769       3.3548    2762.9304     104.8170      46.1875    2625.0000
 1081.4304      83.5114     112.9209     134.1973     151.6985     167.4691       5.9713     311.0000      -0.0301      -0.0675       8.5821      65.6708     307.5243      -2.5356      47.7071       0.0393       0.0760       3.3401    2761.4009     114.3810      47.0000    2639.0000
 1081.5828      85.8440     116.1491     138.0057     155.7811     168.6649       5.9289     311.0000      -0.0262      -0.0635       8.5644      64.3722     307.5243      -3.5727      47.7071       0.0419       0.0789       3.3572    2754.7170     113.0587      47.0000    2658.0000
 1081.7352      86.3861     116.0558     136.6172     161.6506     162.7680       6.1437     311.0000      -0.0183      -0.0553       8.5926      68.1804     307.5243      -5.0201      47.7071       0.0413       0.0785       3.4115    2741.2466     130.6588      47.0000    2604.0000
 1081.8876      85.7496     110.1732     130.0011     156.5832     156.2350       6.4006     311.0000      -0.0172      -0.0542       8.6107      67.0660     307.7975      -4.0252      47.7071       0.0429       0.0799       3.4481    2739.4805     127.2050      47.0000    2658.0000
 1082.0400      88.6705     112.4424     136.3115     167.2386     163.7375       6.1073     311.0000      -0.0165      -0.0535       8.5839      71.1441     307.5243      -3.7282      47.7071       0.0442       0.0812       3.4925    2738.2671     157.8423      47.0000    2656.0000
 1082.1924      93.0095     121.3272     152.9429     189.7900     186.6257       5.3583     311.0000      -0.0121      -0.0489       8.5775      70.1310     307.5243      -1.1096      47.7071       0.0332       0.0690       3.5662    2730.7534     157.7153      47.0000    2625.0000
 1082.3448      97.5814     130.2750     167.6235     209.5347     210.3367       4.7543     311.0000      -0.0138      -0.0507       8.5790      69.3583     307.5243      -1.3499      47.7071       0.0351       0.0711       3.5702    2733.5935     201.2169      47.0000    2603.0000
 1082.4972      99.3458     129.8925     171.0590     212.8787     220.2482       4.5403     311.0000      -0.0221      -0.0592       8.5678      65.6975     307.7975       0.1662      47.7071       0.0372       0.0731       3.5015    2747.7234     182.0616      47.0000    2605.0000
 1082.6496      96.0252     121.4268     162.5058     204.2515     218.3687       4.5794     311.0000      -0.0341      -0.0717       8.5666      66.1027     307.5243      -0.3169      47.7071       0.0338       0.0690       3.4104    2768.2888     175.4621      46.6250    2595.0000
 1082.8020      93.8995     118.6920     158.7919     195.4114     215.8228       4.6334     311.0000      -0.0372      -0.0749       8.5798      68.2215     308.0706       1.4412      47.7071       0.0257       0.0602       3.3971    2773.5930     165.9320      45.8750    2621.0000
 1082.9544      93.4753     120.9307     158.9059     191.7710     221.0456       4.5240     311.0000      -0.0268      -0.0641       8.7030      64.9623     307.5243      -1.1172      47.7071       0.0360       0.0717       3.4770    2755.8215     152.4735      44.5000    2655.0000
 1083.1068      93.0572     122.5032     160.7959     194.2590     225.0139       4.4442     311.0000      -0.0208      -0.0579       8.6534      63.0293     308.0706      -2.4810      47.7071       0.0373       0.0732       3.5297    2745.6130     158.4421      42.1875    2599.0000
 1083.2592      95.3800     129.9798     162.2918     193.0563     228.6711       4.3731     311.0000      -0.0184      -0.0554       8.6018      62.1653     308.0706      -3.2699      47.7071       0.0343       0.0699       3.5494    2741.4490     182.2955      39.9375    2636.0000
 1083.4116      92.0573     125.5828     153.1404     185.5995     207.6908       4.8149     311.0000      -0.0198      -0.0569       8.5878      66.0742     307.5243      -3.4466      47.7071       0.0353       0.0710       3.5512    2743.8506     225.2362      38.2500    2588.0000
 1083.5640      89.2599     122.3717     154.5210     187.2063     210.3763       4.7534     311.0000      -0.0245      -0.0618       8.5913      64.1978     308.0706      -3.9129      47.7071       0.0360       0.0721       3.5332    2751.9221     217.8279      37.2500    2612.0000
 1083.7164      89.0272     122.6476     150.0010     176.9811     194.2322       5.1485     311.0000      -0.0283      -0.0657       8.6040      61.3559     308.0706      -4.9171      47.7071       0.0361       0.0722       3.5163    2758.3479     250.2633      36.6250    2609.0000
 1083.8688      89.8607     124.1686     154.9727     188.8325     202.3525       4.9419     311.0000      -0.0292      -0.0666       8.6247      57.6500     308.0706      -4.8587      47.7071       0.0353       0.0712       3.5281    2759.9546     220.5648      34.0000    2634.0000
 1084.0212      87.6288     120.3634     153.3786     193.4183     198.1441       5.0468     311.0000      -0.0292      -0.0666       8.6760      54.1991     308.0706      -3.1080      47.7071       0.0372       0.0731       3.5799    2759.8511     234.5395      32.7500    2639.0000
 1084.1736      84.5414     112.3214     144.2462     187.7067     181.8269       5.4997     311.0000      -0.0268      -0.0641       8.6447      58.6228     308.0706      -2.3336      47.7071       0.0353       0.0708       3.6481    2755.8337     167.2280      29.5625    2635.0000
 1084.3260      84.1379     108.8013     142.1198     190.6917     182.1599       5.4897     311.0000      -0.0304      -0.0679       8.6709      59.3578     308.0706      -0.9611      47.7071       0.0317       0.0675       3.6662    2762.0374     155.4732      27.6875    2660.0000
 1084.4784      87.5044     115.7574     153.0874     205.7781     205.6362       4.8630     311.0000      -0.0309      -0.0684       8.6478      61.3128     308.0706      -1.5132      47.7071       0.0486       0.0866       3.6647    2762.8628     131.1417      27.5000    2646.0000
 1084.6308      91.4280     123.7880     165.8701     210.9104     218.9639       4.5670     311.0000      -0.0277      -0.0650       8.6931      52.0172     308.0706      -1.8978      47.7071       0.0502       0.0887       3.6633    2757.3220     154.2870      25.6250    2587.0000
 1084.7832      95.0983     132.1650     178.6435     226.0309     234.2104       4.2697     311.0000      -0.0264      -0.0638       8.6644      46.6498     308.6169       2.8183      47.7071       0.0440       0.0817       3.6634    2755.2156     143.0596      24.1250    2612.0000
 1084.9356      99.8763     149.2174     192.5676     231.7175     250.7509       3.9880     311.0000      -0.0270      -0.0644       8.6609      39.6201     308.0706       7.4067      47.7071       0.0447       0.0820       3.6563    2756.2476     117.3705      22.3125    2652.0000
 1085.0880     108.2226     163.2423     224.1847     257.5875     269.3452       3.7127     311.0000      -0.0346      -0.0722       8.6448      38.9330     308.3438      10.6704      47.7071       0.0433       0.0805       3.6259    2769.1089     144.2847      21.1250    2631.0000
 1085.2404     114.6520     185.4019     242.0141     282.9216     274.0439       3.6491     311.0000      -0.0398      -0.0776       8.6693      37.0697     308.0706       4.5266      47.7071       0.0335       0.0694       3.5872    2778.0388     217.3707      19.1250    2643.0000
 1085.3928     128.5922     222.4267     316.1002     317.4557     300.9370       3.3230     311.0000      -0.0405      -0.0784       8.6839      37.0454     308.6169      -2.4817      47.7071       0.0266       0.0609       3.5488    2779.3376     605.1335      17.7500    2643.0000
 1085.5452     127.0149     255.5685     367.7805     321.0906     321.9304       3.1063     311.0000      -0.0429      -0.0809       8.6944      38.6970     308.6169       6.9132      47.7071       0.0204       0.0530       3.5225    2783.4121     329.7339      17.7500    2659.0000
 1085.6976     128.6850     236.2601     350.6464     398.3535     298.7260       3.3475     311.0000      -0.0442      -0.0822       8.6331      44.9563     308.6169      19.0907      47.7071       0.0263       0.0588       3.5647    2785.5874     255.5289      17.7500    2659.0000
 1085.8500     134.6987     208.9201     330.6258     406.6369     266.0266       3.7590     311.0000      -0.0420      -0.0799       8.6328      44.7282     308.6169      19.8951      47.7071       0.0172       0.0491       3.7070    2781.7842     233.3471      17.7500    2585.0000
 1086.0024     124.4759     180.3920     286.5993     423.5916     246.8293       4.0514     311.0000      -0.0333      -0.0709       8.6500      42.1181     308.6169       5.6396      47.7071       0.0247       0.0582       3.8884    2767.0237     455.7412      16.9375    2644.0000
 1086.1548     115.0207     166.3997     270.2671     381.1886     251.9735       3.9687     311.0000      -0.0308      -0.0683       8.6189      34.4378     308.6169      -4.2396      47.7071       0.0294       0.0634       4.0082    2762.6245    1205.9160      14.5625    2640.0000
 1086.3072     109.8485     154.0879     235.0480     355.7939     215.3119       4.6444     311.0000      -0.0380      -0.0757       8.5910      33.9745     309.1632      -1.8468      47.7071       0.0206       0.0539       4.0014    2774.9146    2111.6279      14.5625    2617.0000
 1086.4596     105.2040     143.0182     208.2506     275.7499     219.6544       4.5526     311.0000      -0.0466      -0.0847       8.6161      37.0410     308.8901      -2.4793      47.7071       0.0234       0.0566       3.9310    2789.7439    1119.0610      13.3750    2641.0000
 1086.6120      89.6207     116.8911     169.3355     215.5156     195.8407       5.1062     311.0000      -0.0492      -0.0874       8.6373      42.6415     309.1632      -4.5190      47.9868       0.0214       0.0546       3.8045    2794.1978     365.2628      13.4375    2604.0000
 1086.7644      83.3729     104.0788     145.4193     177.3776     176.3964       5.6691     311.0000      -0.0435      -0.0815       8.6693      49.8530     309.1632     -11.5399      47.7071       0.0277       0.0621       3.6850    2784.3955     231.6052      10.3125    2594.0000
 1086.9168      73.7485      84.2118     112.5241     131.6824     146.6792       6.8176     311.0000      -0.0376      -0.0753       8.6589      52.4596     309.1632      -8.1012      47.7071       0.0423       0.0783       3.5629    2774.2368     199.3172      10.5000    2612.0000
 1087.0692      72.5775      79.1460     100.1366     118.2510     131.4774       7.6059     311.0000      -0.0333      -0.0709       8.6456      53.8860     309.7096      -5.9066      47.7071       0.0379       0.0736       3.4883    2766.9966     215.3763      10.3125    2610.0000
 1087.2216      71.6201      84.5901     104.4338     123.2129     140.7180       7.1064     311.0000      -0.0362      -0.0738       8.5858      51.4183     310.2559       1.0545      47.7071       0.0292       0.0641       3.4300    2771.8455     231.9223      11.3125    2617.0000
 1087.3740      72.5324      91.8460     112.1957     134.2177     155.4613       6.4325     311.0000      -0.0449      -0.0829       8.5921      49.0198     310.2559       2.4393      47.7071       0.0284       0.0635       3.4132    2786.7595     190.5131      10.0625    2634.0000
 1087.5264      72.9081      94.2421     117.7090     143.6861     159.0182       6.2886     311.0000      -0.0482      -0.0863       8.6382      52.7124     310.2559       2.2449      47.9868       0.0422       0.0791       3.4325    2792.4060     120.4067      10.5000    2621.0000
 1087.6788      73.9759      96.5362     120.5397     153.8131     165.1639       6.0546     311.0000      -0.0349      -0.0725       8.6368      58.4402     310.2559       2.2984      47.9868       0.0480       0.0859       3.5412    2769.6184      92.4622       8.3125    2605.0000
 1087.8312      75.7142      98.7596     124.6359     163.2660     166.8397       5.9938     311.0000      -0.0177      -0.0547       8.5872      68.3354     310.8022      -0.2587      47.7071       0.0423       0.0801       3.6693    2740.2048      89.7345       9.0000    2629.0000
 1087.9836      79.7221     105.1295     137.0864     181.6564     189.2566       5.2838     311.0000      -0.0057      -0.0423       8.5826      69.1864     310.8022      -1.4794      47.9868       0.0533       0.0920       3.8179    2719.7324      95.5948       8.6875    2626.0000
 1088.1360      91.9608     126.3373     169.4175     229.6012     250.9933       3.9842     311.0000      -0.0029      -0.0394       8.5703      73.0753     310.8022      -3.2380      47.9868       0.0516       0.0900       4.0182    2714.9763      85.0814       8.5000    2668.0000
 1088.2884     108.3282     152.2846     204.8674     268.8636     311.6604       3.2086     311.0000       0.0020      -0.0343       8.5480      70.8887     311.3485       1.5476      47.9868       0.0422       0.0788       4.3156    2706.5806     102.2816       8.1250    2658.0000
 1088.4408     123.5473     193.9435     272.9968     350.0525     464.1588       2.1544     311.0000       0.0059      -0.0302       8.5847      72.5621     311.8948      12.6295      47.9868       0.0235       0.0569       4.6508    2699.8992     188.6536       7.9375    2643.0000
 1088.5932     143.3577     254.4707     352.6399     426.1702     651.6754       1.5345     311.0000       0.0075      -0.0286       8.5713      65.6161     311.8948      13.2830      47.9868       0.0171       0.0484       4.9177    2697.1636     728.0611       7.9375    2645.0000
 1088.7456     168.9728     369.1647     536.4952     686.2563     901.1218       1.1097     311.0000       0.0131      -0.0228       8.6186      58.0494     312.9874       7.4763      47.9868       0.0069       0.0361       5.0917    2687.6506    1136.9602       7.9375    2636.0000
 1088.8980     178.3629     539.9257     706.3149     965.7240    1178.8137       0.8483     311.0000       0.0213      -0.0143       8.6348      52.0644     312.9874      -3.7107      47.9868       0.0020       0.0301       5.1805    2673.6387    1040.1420       6.8750    2653.0000
 1089.0504     176.4639     563.0582     848.6860    1196.9487    1281.6478       0.7802     311.0000       0.0257      -0.0097       8.6105      47.5702     312.9874      -5.5523      47.9868       0.0064       0.0345       5.1849    2665.9897    1209.2195       4.8125    2640.0000
 1089.2028     183.8831     466.7324     797.7053    1312.8684    1127.8809       0.8866     311.0000       0.0148      -0.0210       8.6353      47.4602     312.4411      -4.1728      47.9868       0.0051       0.0332       5.0579    2684.7019    1679.8706       3.0625    2635.0000
 1089.3552     178.3149     436.6564     734.3303    1288.0842     955.5021       1.0466     311.0000       0.0015      -0.0348       8.6840      46.8684     311.8948      -3.3751      47.9868      -0.0051       0.0225       4.8952    2707.4810    1791.4193       0.6875    2648.0000
 1089.5076     174.9251     403.2546     717.4695    1138.8148     834.5223       1.1983     311.0000      -0.0085      -0.0451       8.5974      49.3327     311.8948      -0.5009      47.7071       0.0054       0.0340       4.7673    2724.4607    1622.4536      -1.5000    2641.0000
 1089.6600     175.6918     376.7793     686.8085    1013.4337     714.1901       1.4002     311.0000      -0.0003      -0.0367       8.5976      55.7863     311.0753      -1.4331      47.9868       0.0071       0.0360       4.8092    2710.4771    1685.9159      -1.8125    2660.0000
 1089.8124     173.8208     347.0764     674.9772     952.1287     670.9938       1.4903     311.0000       0.0024      -0.0339       8.6863      56.2238     310.8022      -0.5918      47.9868       0.0122       0.0413       4.8410    2705.9319    1250.1462      -3.1875    2632.0000
 1089.9648     175.8447     341.2821     630.3311     869.2111     649.6515       1.5393     311.0000       0.0018      -0.0345       8.6978      55.7856     310.8022      -0.6750      47.9868       0.0100       0.0392       4.8702    2707.0010    1242.8380      -6.7500    2638.0000
 1090.1172     184.8704     315.1548     565.0530     790.0458     546.1275       1.8311     311.0000      -0.0024      -0.0389       8.6746      48.8370     310.2559      -0.5641      47.9868       0.0102       0.0389       4.8765    2714.1760    1246.4606      -9.1250    2638.0000
 1090.2696     190.8306     357.8936     639.8742     867.6624     616.3625       1.6224     311.0000      -0.0006      -0.0370       8.6764      47.9943     308.8901      -1.5466      47.9868       0.0008       0.0289       4.9037    2711.0393    1415.1918     -11.5625    2619.0000
 1090.4220     199.1119     426.2868     749.7919     991.9897     653.2325       1.5308     311.0000       0.0058      -0.0303       8.6097      48.4130     309.1632      -3.3085      47.9868      -0.0012       0.0262       4.8947    2700.0002    1288.4073     -11.8125    2620.0000
 1090.5744     194.4128     504.6020     766.9434     906.2455     768.5347       1.3012     311.0000       0.0026      -0.0336       8.6353      55.3269     308.6169      -2.2259      47.9868       0.0030       0.0314       4.7689    2705.4917    1296.9102     -14.3750    2621.0000
 1090.7268     184.6963     467.8357     720.1702     781.5032     734.0862       1.3622     311.0000       0.0027      -0.0336       8.6426      59.2978     308.0706      -3.6044      47.9868       0.0088       0.0379       4.6670    2705.4673    1322.7264     -17.3750    2626.0000
 1090.8792     187.7197     392.0411     583.9753     627.2548     653.0745       1.5312     311.0000      -0.0052      -0.0418       8.6611      62.1593     308.0706      -2.9767      47.9868       0.0094       0.0390       4.5228    2718.9302     870.5295     -21.3125    2635.0000
 1091.0316     185.7514     348.0638     528.3821     531.6260     604.4216       1.6545     311.0000      -0.0123      -0.0491       8.6980      60.5726     307.5243      -2.0306      47.9868       0.0111       0.0409       4.3928    2731.0801     627.7042     -21.3125    2644.0000
 1091.1840     180.5523     304.3955     449.0612     451.9388     535.7709       1.8665     311.0000      -0.0181      -0.0551       8.7979      62.5192     306.9780      -0.1693      47.9868       0.0118       0.0417       4.3080    2740.9053     478.7008     -21.3125    2637.0000
 1091.3364     178.5720     298.0843     464.1308     480.7230     562.1238       1.7790     311.0000      -0.0078      -0.0445       8.7724      62.5192     307.2511      -1.1926      47.9868       0.0148       0.0452       4.3997    2723.3831     493.9473     -23.8125    2626.0000
 1091.4888     178.5562     303.5738     441.5744     528.6272     601.8018       1.6617     311.0000       0.0112      -0.0248       8.6808      65.2986     307.5243      -4.1742      47.9868       0.0144       0.0450       4.5975    2690.8604     567.5756     -25.1875    2692.0000
 1091.6412     179.3358     301.3238     458.2179     502.9640     525.9638       1.9013     311.0000       0.0274      -0.0080       8.6788      61.0020     306.9780      -7.0045      47.9868       0.0058       0.0354       4.7993    2663.1589     666.8512     -26.1250    2635.0000
 1091.7936     194.4318     400.2685     558.6989     600.7433     602.3586       1.6601     311.0000       0.0258      -0.0096       8.6862      56.9800     307.5243      -6.6936      47.9868       0.0116       0.0416       4.9064    2665.9060     630.9186     -27.0625    2629.0000
 1091.9460     209.1800     605.5643     752.1277     806.8627     770.8444       1.2973     311.0000       0.0154      -0.0204       8.7360      47.4801     306.9780      -2.5151      47.9868       0.0165       0.0461       4.9581    2683.6316     977.5180     -27.5000    2615.0000
 1092.0984     216.0503     533.5137     730.7963     803.3113     720.3130       1.3883     311.0000      -0.0000      -0.0364       8.7586      37.0910     306.9780       3.8135      47.9868       0.0030       0.0311       4.9700    2710.0400    1456.2944     -26.6250    2619.0000
 1092.2508     201.2245     368.8453     623.7375     759.7433     716.4479       1.3958     311.0000      -0.0055      -0.0420       8.7418      27.0944     306.4317       8.3175      47.9868      -0.0010       0.0253       5.0085    2719.3320    4569.0146     -26.6250    2680.0000
 1092.4032     188.8166     323.5336     549.0276     705.3777     625.4421       1.5989     311.0000      -0.0067      -0.0434       8.7011      24.8858     307.5243       5.6489      47.9868      -0.0123       0.0125       5.0146    2721.5344    4563.2163     -24.7500    2625.0000
 1092.5556     183.0848     324.7683     549.7145     708.7896     695.5197       1.4378     311.0000       0.0042      -0.0320       8.7081      32.5292     307.2511       0.1574      47.9868      -0.0116       0.0128       4.9829    2702.8337    1207.3871     -24.3125    2615.0000
 1092.7080     177.0623     323.6016     510.6761     676.0558     713.5984       1.4013     311.0000       0.0150      -0.0208       8.7486      43.5030     306.4317      -0.7036      47.9868      -0.0103       0.0147       4.8758    2684.4023     378.0175     -23.6250    2621.0000
 1092.8604     175.7970     306.6836     477.7131     610.6891     732.2689       1.3656     311.0000       0.0215      -0.0141       8.7146      49.4210     306.9780      -1.6098      47.9868       0.0026       0.0297       4.8009    2673.2463     346.2524     -23.2500    2651.0000
 1093.0128     170.9263     298.4234     479.8233     663.6694     776.9011       1.2872     311.0000       0.0118      -0.0241       8.6767      50.5765     306.9780       0.5496      47.9868       0.0168       0.0462       4.7145    2689.8276     381.5909     -22.5625    2666.0000
 1093.1652     177.1433     297.6458     457.9858     627.9148     775.7858       1.2890     311.0000       0.0013      -0.0350       8.7403      50.3412     306.9780      -1.6096      47.9868       0.0074       0.0364       4.7015    2707.7588     878.3722     -21.8750    2652.0000
 1093.3176     183.6549     301.9272     450.1977     627.6257     734.8165       1.3609     311.0000      -0.0059      -0.0425       8.8110      51.0733     306.9780       1.6608      47.9868      -0.0017       0.0262       4.7382    2720.1079     852.8686     -21.3125    2646.0000
 1093.4700     185.7244     280.5093     420.8465     595.6973     688.3040       1.4528     311.0000      -0.0031      -0.0396       8.7868      49.7985     306.9780       2.2335      47.9868       0.0046       0.0326       4.7861    2715.3206     911.9696     -21.3125    2638.0000
 1093.6224     177.0841     250.9369     377.7083     547.2860     569.6434       1.7555     311.0000       0.0049      -0.0313       8.7699      49.2887     306.4317       1.8237      47.9868       0.0081       0.0364       4.8662    2701.5762     801.4381     -21.3125    2615.0000
 1093.7748     171.3198     280.4548     399.2774     445.4439     537.2299       1.8614     311.0000       0.0148      -0.0211       8.7350      45.6578     306.4317      -0.5486      47.9868       0.0001       0.0273       4.9291    2684.7390     854.2678     -21.3125    2615.0000
 1093.9272     208.5220     384.3307     574.5106     668.6198     765.8928       1.3057     311.0000       0.0165      -0.0192       8.7362      43.7207     306.9780      -0.3834      47.9868      -0.0012       0.0260       4.9862    2681.7285     807.9551     -20.2500    2634.0000
 1094.0796     230.1068     766.5488    1051.7637    1205.6300    1156.1161       0.8650     311.0000       0.0159      -0.0199       8.7569      40.9887     306.4317      -0.7851      47.9868       0.0090       0.0364       5.0352    2682.7712     816.0820     -18.8125    2599.0000
 1094.2320     272.1231     758.0289    1630.7367    1712.9840    1805.6492       0.5538     311.0000       0.0175      -0.0183       8.7408      39.4869     306.9780      -2.2724      47.9868      -0.0053       0.0211       5.0473    2680.1519     788.4028     -19.3125    2597.0000
 1094.3844     237.8325     522.1252     908.6203    1220.9835    1180.4498       0.8471     311.0000       0.0179      -0.0178       8.7492      38.0298     306.4317      -3.5343      47.9868      -0.0054       0.0204       4.9974    2679.3154     778.0276     -17.8125    2598.0000
 1094.5368     200.8058     374.4249     506.0527     661.5261     532.4921       1.8780     311.0000       0.0181      -0.0176       8.7372      37.6500     306.4317      -3.7022      47.9868      -0.0028       0.0237       4.9281    2678.9807    1354.5298     -17.1250    2589.0000
 1094.6892     184.3288     303.9648     449.6964     790.7787     522.2092       1.9149     311.0000       0.0170      -0.0187       8.7871      40.4295     306.4317      -2.2521      47.9868      -0.0004       0.0262       4.8856    2680.9082    1036.3733     -17.0000    2615.0000
 1094.8416     205.0228     350.0182     602.9377    1033.1860     709.2712       1.4099     311.0000       0.0301      -0.0052       8.8005      46.4858     306.1585      -4.3640      47.9868      -0.0021       0.0248       4.9899    2658.5830    1190.0133     -17.3750    2607.0000
 1094.9940     227.8800     371.6616     721.2924    1073.1318     852.5071       1.1730     311.0000       0.0352       0.0002       8.7705      47.0683     306.4317      -4.7855      47.9868       0.0037       0.0313       5.0402    2649.7263    1022.0723     -15.0000    2611.0000
 1095.1464     255.6734     477.2837     807.3740    1081.5190     971.6227       1.0292     311.0000       0.0408       0.0060       8.7438      51.0465     306.1585      -6.5329      47.9868       0.0051       0.0331       5.0914    2640.1816    1142.5663     -14.6250    2628.0000
 1095.2988     263.4531     494.3384     787.3403     940.7924    1184.4127       0.8443     311.0000       0.0318      -0.0034       8.7973      49.2229     306.4317      -4.7989      47.9868       0.0003       0.0279       5.0341    2655.6611    1148.1819     -13.8125    2607.0000
 1095.4512     234.2796     406.0040     591.8705     633.2405    1038.5439       0.9629     311.0000       0.0226      -0.0130       8.8556      53.3380     306.4317      -8.7700      47.9868       0.0003       0.0276       4.9515    2671.3782    1331.8575     -12.7500    2611.0000
 1095.6036     209.4022     284.1754     436.8747     442.7438     802.7902       1.2457     311.0000       0.0123      -0.0236       8.9043      49.5289     305.8853      -5.7065      47.9868       0.0072       0.0351       4.8533    2688.9946    1209.1185     -12.6250    2594.0000
 1095.7560     185.5329     234.9263     313.8806     350.7704     588.8796       1.6981     311.0000       0.0134      -0.0225       8.8854      49.7359     305.8853      -5.6617      47.9868      -0.0018       0.0255       4.8368    2687.0586    1178.4128     -11.5625    2587.0000
 1095.9084     160.6055     195.0439     250.4446     279.9569     431.3914       2.3181     311.0000       0.0202      -0.0154       8.8238      46.4594     305.8853      -1.6913      47.9868       0.0014       0.0289       4.8657    2675.4602    1026.3724     -11.5625    2625.0000
 1096.0608     141.5329     167.6592     218.8183     252.9112     326.7581       3.0604     311.0000       0.0238      -0.0117       8.8571      48.6923     305.8853      -3.3312      47.9868       0.0063       0.0343       4.8469    2669.3191     801.3787     -10.2500    2627.0000
 1096.2132     120.8649     160.7348     183.8041     217.6844     249.4651       4.0086     311.0000       0.0087      -0.0274       8.8177      49.3871     305.8853       1.6723      47.9868      -0.0020       0.0257       4.6261    2695.1306     687.5237      -9.0000    2588.0000
 1096.3656     101.5168     138.5529     146.6738     198.3495     180.9366       5.5268     311.0000      -0.0027      -0.0391       8.8064      55.4431     305.8853       3.2279      47.9868       0.0054       0.0347       4.2719    2714.5725     234.1104      -8.6875    2602.0000
 1096.5180      85.8514     111.8120     123.8814     153.1001     142.0610       7.0392     311.0000      -0.0055      -0.0420       8.8634      53.2102     305.8853       3.1269      47.9868       0.0196       0.0518       3.9824    2719.3606      87.7136      -7.2500    2649.0000
 1096.6704      92.8033     122.4285     128.4290     154.1494     132.7010       7.5357     311.0000       0.0092      -0.0268       8.8484      55.7528     305.8853      10.1337      47.9868       0.0492       0.0852       4.0203    2694.2175      65.7597      -6.8750    2618.0000
 1096.8228     131.8416     181.8109     192.9129     218.6307     195.5397       5.1141     311.0000       0.0183      -0.0174       8.7422      50.8888     306.4317       9.6219      47.9868       0.0423       0.0780       4.3672    2678.7493      87.4409      -6.7500    2635.0000
 1096.9752     169.5304     279.6793     325.9571     337.5540     302.4869       3.3059     311.0000       0.0180      -0.0177       8.8018      49.4420     306.7048      11.9228      47.9868       0.0147       0.0458       4.7397    2679.2349     315.6385      -5.7500    2621.0000
 1097.1276     194.8874     327.7244     401.2062     286.8230     287.5524       3.4776     311.0000       0.0200      -0.0157       8.8053      41.5970     306.4317       0.2089      47.9868      -0.0002       0.0279       5.0431    2675.8342    2058.8997      -5.5625    2628.0000
 1097.2800     229.9805     430.7270     561.2604     381.7305     391.7780       2.5525     311.0000       0.0167      -0.0191       8.7938      36.5273     306.4317       0.5655      47.9868      -0.0071       0.0186       5.1151    2681.4922    2038.8000      -7.1250    2611.0000
 1097.4324     233.2825     555.5964     696.4034     594.8162     601.3523       1.6629     311.0000       0.0133      -0.0226       8.8544      32.7093     306.9780      -0.3982      47.9868      -0.0071       0.0181       5.1119    2687.2495    1908.2587      -8.0000    2608.0000
 1097.5848     246.9553     451.5267     783.3662     747.3518     686.3428       1.4570     311.0000       0.0041      -0.0321       8.8098      29.6292     308.0706       0.3097      47.9868      -0.0047       0.0202       4.9993    2702.9517    2402.0286      -8.8750    2602.0000
 1097.7372     254.9672     481.5515     842.9176     975.2044     768.5641       1.3011     311.0000       0.0017      -0.0346       8.7859      26.5921     308.0706       0.2909      47.9868      -0.0042       0.0211       4.9271    2707.0645    3064.5400      -8.4375    2628.0000
 1097.8896     210.8518     362.3318     751.3228    1201.5557     741.7422       1.3482     311.0000       0.0049      -0.0313       8.8057      25.7672     308.6169      -0.6018      47.9868      -0.0070       0.0183       4.8711    2701.6697    2691.8303      -6.6875    2585.0000
 1098.0420     204.2448     358.8292     686.0487    1338.6564     565.2150       1.7692     311.0000       0.0079      -0.0281       8.7870      26.9695     309.7096      -1.6572      47.9868      -0.0051       0.0205       4.7964    2696.4429    1470.6006      -6.7500    2616.0000
 1098.1944     232.1861     450.9633     945.7062    1361.9600     906.7849       1.1028     311.0000       0.0017      -0.0346       8.8568      27.1855     309.7096       1.7221      47.9868      -0.0074       0.0180       4.7034    2707.1208    1044.1821      -7.0625    2625.0000
 1098.3468     259.7755     560.9577    1156.9899    1358.0101    1199.4323       0.8337     311.0000      -0.0026      -0.0391       8.8539      28.4737     309.7096       4.1111      47.9868      -0.0059       0.0195       4.6330    2714.4734     887.3812      -7.0625    2626.0000
 1098.4992     245.5160     550.3273     946.0447     940.0827     976.8666       1.0237     311.0000      -0.0019      -0.0384       8.8333      28.4893     310.2559       5.2710      47.9868      -0.0053       0.0202       4.6239    2713.2910     977.9627      -7.5625    2634.0000
 1098.6516     239.3779     515.9229     856.6849     731.1375     923.9849       1.0823     311.0000       0.0019      -0.0344       8.7339      28.8628     311.3485       6.2826      47.9868      -0.0028       0.0230       4.6434    2706.7659    1105.1609      -7.4375    2611.0000
 1098.8040     231.0119     488.7075     775.1325     612.1500     867.0281       1.1534     311.0000      -0.0126      -0.0494       8.7072      24.2428     312.4411      17.3521      47.9868      -0.0047       0.0209       4.6474    2731.4712    1300.1591      -6.3125    2625.0000
 1098.9564     212.1757     395.2422     661.2740     559.1663     801.6218       1.2475     311.0000      -0.0348      -0.0725       8.7921      24.6298     312.4411      33.3037      47.9868      -0.0098       0.0158       4.6056    2769.5842    1386.6499      -6.9375    2628.0000
 1099.1088     181.2470     306.2430     495.1302     458.9039     630.1844       1.5868     311.0000      -0.0505      -0.0887       8.8348      26.3789     312.9874      45.1739      47.9868       0.0032       0.0301       4.5601    2796.3091     326.6562      -6.0625    2634.0000
 1099.2612     168.1779     265.3441     442.4740     445.6012     569.4448       1.7561     311.0000      -0.0477      -0.0858       8.8455      31.7197     312.9874      46.8647      47.9868       0.0092       0.0375       4.5482    2791.5449     330.4765      -6.6875    2656.0000
 1099.4136     180.3169     286.6591     510.0494     600.4565     726.7349       1.3760     311.0000      -0.0335      -0.0711       8.8219      31.3171     312.9874      43.2324      47.9868       0.0060       0.0342       4.6234    2767.2537     333.7383      -6.1875    2643.0000
 1099.5660     177.1166     282.3621     557.6223     735.9227     834.3341       1.1986     311.0000      -0.0167      -0.0537       8.7999      39.1412     312.9874      41.9049      47.9868       0.0036       0.0316       4.7631    2738.5554    1442.3389      -6.6250    2642.0000
 1099.7184     175.2957     268.8948     573.4386     877.9714     963.4108       1.0380     311.0000      -0.0079      -0.0446       8.7951      45.8322     312.9874      43.5283      47.9868      -0.0010       0.0257       4.9055    2723.5945     869.3056      -7.2500    2670.0000
 1099.8708     165.9189     249.5376     573.1232     956.4050    1156.0645       0.8650     311.0000      -0.0042      -0.0407       8.8003      54.5765     314.0800      36.3512      47.9868      -0.0079       0.0182       4.9632    2717.1138     810.8960      -6.3750    2625.0000
 1100.0232     166.0181     261.5139     547.8392     897.5745    1284.4418       0.7785     311.0000      -0.0008      -0.0372       8.8485      53.9102     314.0800      20.2899      47.9868       0.0026       0.0298       4.8580    2711.3054     697.9234      -5.5625    2643.0000
 1100.1756     162.6734     256.8570     458.4611     790.2637    1200.9764       0.8327     311.0000       0.0024      -0.0339       8.8254      52.3149     314.0800       5.0654      47.9868       0.0077       0.0362       4.6503    2705.9712     694.7632      -4.5625    2643.0000
 1100.3280     158.8306     230.4745     435.7628     592.7787    1194.5825       0.8371     311.0000      -0.0013      -0.0377       8.8320      44.9604     314.0800      -0.1087      47.9868       0.0101       0.0395       4.4083    2712.2407     710.5241      -3.5000    2638.0000
 1100.4804     160.7191     224.9495     417.2917     491.9627     960.7522       1.0409     311.0000      -0.0155      -0.0524       8.8410      36.2722     314.6264       1.8477      47.9868       0.0156       0.0461       4.1925    2736.4446    1066.9202      -1.8125    2674.0000
 1100.6328     161.5145     229.3079     372.6031     425.1841     710.9616       1.4065     311.0000      -0.0243      -0.0616       8.8125      29.3530     314.8995       0.6106      47.9868       0.0085       0.0383       4.0430    2751.6201    1004.0609      -1.8125    2639.0000
 1100.7852     152.7045     217.9972     338.7767     394.0265     516.6614       1.9355     311.0000      -0.0270      -0.0643       8.7572      30.7695     315.1727      -0.9754      47.9868       0.0037       0.0328       3.9647    2756.1672    1072.1093      -1.2500    2641.0000
 1100.9376     147.2279     207.8569     309.9478     366.3369     387.4389       2.5811     311.0000      -0.0226      -0.0598       8.7982      35.2270     315.1727      -0.7496      47.9868       0.0100       0.0396       3.9264    2748.6191    1212.5150      -0.5000    2662.0000
 1101.0900     136.6867     217.6647     302.0620     344.7038     303.8198       3.2914     311.0000      -0.0234      -0.0606       8.8375      39.5724     315.7190      -0.9458      47.9868       0.0126       0.0428       3.8657    2749.9771    1176.4949       0.3125    2649.0000
 1101.2424     118.7493     231.4971     299.7737     333.4029     268.9544       3.7181     311.0000      -0.0286      -0.0660       8.8519      48.5553     316.8116       0.5014      47.9868       0.0075       0.0376       3.7482    2758.9358     552.9519       1.1875    2648.0000
 1101.3948     110.0293     177.3580     250.8494     253.4299     199.9219       5.0020     311.0000      -0.0290      -0.0664       8.8275      53.4808     316.2654      -0.4883      47.9868       0.0092       0.0399       3.6562    2759.5227     125.9614       0.9375    2634.0000
 1101.5472      96.4244     132.2888     175.4049     197.7119     151.9340       6.5818     311.0000      -0.0241      -0.0613       8.7786      62.1444     316.8116       1.7297      47.9868       0.0272       0.0602       3.5648    2751.1650      65.8463       1.3125    2622.0000
 1101.6996      82.4397      96.2166     128.2351     141.0249     119.7632       8.3498     311.0000      -0.0158      -0.0528       8.8241      65.1789     317.6311       3.5822      47.9868       0.0285       0.0627       3.5357    2737.0969      46.3080      -0.0625    2628.0000
 1101.8520      92.4006      89.8957     118.8408     126.3383     112.5272       8.8867     311.0000      -0.0115      -0.0483       8.8657      71.2401     317.9043       4.0874      47.9868       0.0445       0.0814       3.5406    2729.7092      47.9323      -1.7500    2624.0000
 1102.0044     110.5214     109.5285     148.9560     178.7334     176.1998       5.6754     311.0000      -0.0094      -0.0461       8.8857      63.5029     318.4506       2.5263      47.9868       0.0665       0.1060       3.5577    2726.0540      69.9774      -1.8125    2626.0000
 1102.1568     131.5349     151.9173     198.5899     235.0933     249.6261       4.0060     311.0000      -0.0070      -0.0436       8.8354      50.7248     318.4506       0.2682      47.9868       0.0452       0.0831       3.5664    2721.9333     138.9627      -1.8125    2653.0000
 1102.3092     142.7623     182.7449     265.9989     335.7822     340.9354       2.9331     311.0000      -0.0068      -0.0434       8.8350      38.6416     319.5432      -0.0262      47.9868       0.0340       0.0700       3.5388    2721.6284     462.2747      -3.0625    2626.0000
 1102.4616     131.7506     188.4594     269.3480     356.8412     435.1760       2.2979     311.0000      -0.0032      -0.0397       8.8635      37.6246     319.5432      -0.4208      47.9868       0.0215       0.0552       3.5396    2715.5508     540.5298      -4.6250    2642.0000
 1102.6140     128.5760     196.6242     276.9127     392.0783     474.1956       2.1088     311.0000      -0.0006      -0.0370       8.8440      38.8495     320.0895      -0.5817      47.9868       0.0227       0.0559       3.5440    2710.9966     511.0929      -6.6875    2635.0000
 1102.7664     125.6934     203.5290     285.9943     428.1289     416.4673       2.4011     311.0000       0.0010      -0.0354       8.8185      39.3383     320.0895      -0.4232      47.9868       0.0251       0.0587       3.5439    2708.3376     493.4719      -8.6250    2622.0000
 1102.9188     126.1936     199.6969     310.7212     455.4412     414.8173       2.4107     311.0000      -0.0004      -0.0368       8.7733      35.0834     320.9090       1.1063      47.9868       0.0316       0.0666       3.5068    2710.6985     442.4356     -10.8125    2639.0000
 1103.0712     128.8681     198.3636     335.8578     508.9791     398.9250       2.5067     311.0000       0.0010      -0.0353       8.7531      30.8865     321.7285       2.8379      47.9868       0.0413       0.0775       3.4755    2708.2087     426.5858     -11.5625    2638.0000
 1103.2236     130.1774     197.0022     348.7215     557.8899     413.3426       2.4193     311.0000       0.0012      -0.0351       8.7916      29.6924     321.7285       7.6730      47.9868       0.0342       0.0700       3.4799    2707.9023     411.0092     -12.1250    2665.0000
 1103.3760     126.7016     185.0113     353.7135     601.0157     433.0107       2.3094     311.0000       0.0077      -0.0283       8.8615      31.4900     321.7285       7.8695      47.9868       0.0384       0.0746       3.5026    2696.7568     368.1900     -13.4375    2640.0000
 1103.5284     121.8986     172.9954     347.3836     655.0458     488.3093       2.0479     311.0000       0.0130      -0.0229       8.8178      33.2440     322.2748       6.3839      47.9868       0.0337       0.0697       3.5226    2687.7415     297.5966     -14.5625    2646.0000
 1103.6808     120.8126     165.2213     343.1205     708.2299     565.5711       1.7681     311.0000       0.0189      -0.0168       8.8548      31.6331     321.7285       0.9961      47.9868       0.0394       0.0761       3.5179    2677.7537     292.8319     -16.4375    2629.0000
 1103.8332     121.8455     165.2765     339.1519     726.3516     667.6110       1.4979     311.0000       0.0205      -0.0151       8.8606      29.8530     322.2748      -1.3046      47.9868       0.0435       0.0803       3.5530    2674.8652     350.8077     -17.4375    2665.0000
 1103.9856     118.1349     170.5892     329.4655    